# Create Next Stack

<p>
  <a aria-label="Last commit" href="https://github.com/akd-io/create-next-stack/commits/develop">
    <img alt="" src="https://img.shields.io/github/last-commit/akd-io/create-next-stack/develop?style=flat-square">
  </a>
  <a aria-label="License" href="https://github.com/akd-io/create-next-stack/blob/develop/packages/create-next-stack/LICENSE">
    <img alt="" src="https://img.shields.io/npm/l/create-next-stack?color=44cc11&style=flat-square">
  </a>
  <a aria-label="NPM version" href="https://www.npmjs.com/package/create-next-stack">
    <img alt="" src="https://img.shields.io/npm/v/create-next-stack?style=flat-square">
  </a>
  <a aria-label="Community Discord" href="https://discord.gg/7Ns5WwGjjZ">
    <img alt="" src="https://img.shields.io/badge/Discord-gray?style=flat-square&logo=discord">
  </a>
  <a aria-label="Twitter profile of the creator of Create Next Stack" href="https://twitter.com/akd_io">
    <img alt="" src="https://img.shields.io/badge/Twitter-gray?style=flat-square&logo=twitter">
  </a>
  <a aria-label="GitHub Repo stars" href="https://github.com/akd-io/create-next-stack">
    <img alt="" src="https://img.shields.io/github/stars/akd-io/create-next-stack?style=social">
  </a>
</p>

[Create Next Stack](https://www.create-next-stack.com/) is a website and CLI tool used to easily set up the boilerplate of new [Next.js](https://github.com/vercel/next.js) apps.

Where [Create Next App](https://github.com/vercel/next.js/tree/canary/packages/create-next-app) lets you choose a single template only, Create Next Stack lets you pick and choose an array of technologies often used alongside Next.js, and free you of the pain of making them work together.

To get started, go to [create-next-stack.com](https://www.create-next-stack.com).

## Supported technologies

The table below provides an overview of the technologies currently supported by Create Next Stack.

<!-- CNS-START-OF-TECHNOLOGIES-TABLE -->

| Name                | Links                                                                                                                                                                                                                        |
| ------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Next.js             | [Website](https://nextjs.org/) - [Docs](https://nextjs.org/docs) - [Learn Next.js](https://nextjs.org/learn) - [GitHub](https://github.com/vercel/next.js) - [Wikipedia](https://en.wikipedia.org/wiki/Next.js)              |
| React               | [Website](https://reactjs.org/) - [Docs](https://reactjs.org/docs/getting-started.html) - [GitHub](https://github.com/facebook/react) - [Wikipedia](<https://en.wikipedia.org/wiki/React_(JavaScript_library)>)              |
| TypeScript          | [Website](https://www.typescriptlang.org/) - [Docs](https://www.typescriptlang.org/docs/) - [GitHub](https://github.com/microsoft/TypeScript) - [Wikipedia](https://en.wikipedia.org/wiki/TypeScript)                        |
| Emotion             | [Website](https://emotion.sh/) - [Docs](https://emotion.sh/docs/introduction) - [GitHub](https://github.com/emotion-js/emotion)                                                                                              |
| Styled Components   | [Website](https://styled-components.com/) - [Docs](https://styled-components.com/docs) - [GitHub](https://github.com/styled-components/styled-components)                                                                    |
| Tailwind CSS        | [Website](https://tailwindcss.com/) - [Docs](https://tailwindcss.com/docs) - [GitHub](https://github.com/tailwindlabs/tailwindcss)                                                                                           |
| Sass                | [Website](https://sass-lang.com/) - [Docs](https://sass-lang.com/documentation) - [Next.js-specific docs](https://nextjs.org/docs/basic-features/built-in-css-support#sass-support)                                          |
| CSS Modules         | [Website](https://github.com/css-modules/css-modules) - [Docs](https://github.com/css-modules/css-modules) - [Next.js-specific docs](https://nextjs.org/docs/basic-features/built-in-css-support#adding-component-level-css) |
| CSS Modules         | [Website](https://github.com/css-modules/css-modules) - [Docs](https://github.com/css-modules/css-modules) - [Next.js-specific docs](https://nextjs.org/docs/basic-features/built-in-css-support#adding-component-level-css) |
| Mantine             | [Website](https://mantine.dev/) - [Docs](https://mantine.dev/pages/getting-started/) - [GitHub](https://github.com/mantinedev/mantine)                                                                                       |
| Chakra UI           | [Website](https://chakra-ui.com/) - [Docs](https://chakra-ui.com/docs/getting-started) - [GitHub](https://github.com/chakra-ui/chakra-ui)                                                                                    |
| Material UI         | [Website](https://material-ui.com/) - [Docs](https://material-ui.com/getting-started/installation/) - [GitHub](https://github.com/mui-org/material-ui)                                                                       |
| Framer Motion       | [Website](https://www.framer.com/motion/) - [Docs](https://www.framer.com/docs/) - [GitHub](https://github.com/framer/motion)                                                                                                |
| React Hook Form     | [Website](https://react-hook-form.com/) - [Docs](https://react-hook-form.com/get-started) - [GitHub](https://github.com/react-hook-form/react-hook-form)                                                                     |
| Formik              | [Website](https://formik.org/) - [Docs](https://formik.org/docs/overview) - [GitHub](https://github.com/formium/formik)                                                                                                      |
| React Query         | [Website](https://tanstack.com/query/latest) - [Docs](https://tanstack.com/query/latest/docs/react/overview) - [GitHub](https://github.com/tanstack/query)                                                                   |
| React Icons         | [Website](https://react-icons.github.io/react-icons/) - [GitHub](https://github.com/react-icons/react-icons)                                                                                                                 |
| ESLint              | [Website](https://eslint.org/) - [Configuration](https://eslint.org/docs/user-guide/configuring/) - [Rules](https://eslint.org/docs/rules/) - [GitHub](https://github.com/eslint/eslint)                                     |
| Prettier            | [Website](https://prettier.io/) - [Docs](https://prettier.io/docs/en/index.html) - [Options](https://prettier.io/docs/en/options.html) - [GitHub](https://github.com/prettier/prettier)                                      |
| Husky               | [Website](https://typicode.github.io/husky/) - [Docs](https://typicode.github.io/husky/) - [GitHub](https://github.com/typicode/husky)                                                                                       |
| lint-staged         | [Website](https://github.com/okonet/lint-staged) - [GitHub](https://github.com/okonet/lint-staged)                                                                                                                           |
| pnpm                | [Website](https://pnpm.io/) - [Docs](https://pnpm.io/motivation) - [GitHub](https://github.com/pnpm/pnpm)                                                                                                                    |
| Yarn                | [Website](https://yarnpkg.com/) - [CLI Docs](https://yarnpkg.com/cli) - [GitHub](https://github.com/yarnpkg/berry)                                                                                                           |
| npm                 | [Website](https://www.npmjs.com/) - [Docs](https://docs.npmjs.com/) - [GitHub](https://github.com/npm/cli)                                                                                                                   |
| GitHub Actions      | [Website](https://github.com/features/actions) - [Docs](https://docs.github.com/en/actions) - [Workflow syntax](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions)                             |
| Plausible Analytics | [Website](https://plausible.io/) - [Docs](https://plausible.io/docs) - [GitHub](https://github.com/plausible/analytics)                                                                                                      |
| next-plausible      | [Website](https://next-plausible.vercel.app/) - [GitHub](https://github.com/4lejandrito/next-plausible)                                                                                                                      |
| Vercel              | [Website](https://vercel.com/) - [Docs](https://vercel.com/docs) - [CLI Docs](https://vercel.com/docs/cli)                                                                                                                   |
| Netlify             | [Website](https://www.netlify.com/) - [Docs](https://docs.netlify.com/) - [CLI Docs](https://cli.netlify.com/)                                                                                                               |

<!-- CNS-END-OF-TECHNOLOGIES-TABLE -->

## Usage

Below you see an overview of Create Next Stack's usage, including detailed information about arguments and options. The overview is the result of running `create-next-stack --help`

<!-- CNS-START-OF-HELP-OUTPUT -->

```
USAGE
  $ create-next-stack [APP_NAME] [FLAGS]

ARGUMENTS
  APP_NAME  The name of your app, optionally including a path prefix. Eg.:
            "my-app" or "path/to/my-app"

FLAGS
  -h, --help                    Shows the CLI help information.
  -v, --version                 Shows the CLI version information.
  --chakra                      Adds Chakra UI. (Component library) (Requires
                                Emotion and Framer Motion)
  --debug                       Show verbose error messages for debugging
                                purposes.
  --formatting-pre-commit-hook  Adds a formatting pre-commit hook. (Requires
                                Prettier)
  --formik                      Adds Formik. (Form library)
  --framer-motion               Adds Framer Motion. (Animation library)
  --github-actions              Adds a GitHub Actions continuous integration
                                workflow.
  --mantine                     Adds Mantine. (Component library) (Requires
                                Emotion)
  --material-ui                 Adds Material UI. (Component library) (Requires
                                Emotion)
  --netlify                     Adds Netlify. (Hosting)
  --package-manager=<option>    (required) Sets the preferred package manager.
                                (Required)
                                <options: pnpm|yarn|npm>
  --plausible                   Adds Plausible. (Analytics)
  --prettier                    Adds Prettier. (Code formatting)
  --react-hook-form             Adds React Hook Form. (Form library)
  --react-icons                 Adds React Icons. (Icon library)
  --react-query                 Adds React Query. (Server state management
                                library)
  --styling=<styling-method>    (required) Sets the preferred styling method.
                                (Required) <styling-method> =
                                emotion|styled-components|tailwind-css|css-modul
                                es|css-modules-with-sass
  --vercel                      Adds Vercel. (Hosting)
```

<!-- CNS-END-OF-HELP-OUTPUT -->

## All contributors

Contributions are welcome! Please see the [contributing guidelines](CONTRIBUTING.md) for more information.

<a href="https://github.com/akd-io/create-next-stack/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=akd-io/create-next-stack" />
</a>

## License

Create Next Stack is released under the [MIT License](LICENSE).
