import endent from "endent"
import { ValidCNSInputs } from "../../../../create-next-stack-types"
import { getProjectNameOfPath } from "../../../../helpers/get-project-name-of-path"

export const generateIndexPage = ({ args }: ValidCNSInputs): string => endent`
  import { NextPage } from "next";
  import Head from "next/head";
  import LandingPageTemplate from "../templates/LandingPage/LandingPageTemplate";

  const Index: NextPage = () => {
    return (
      <>
        <Head>
          <title>${getProjectNameOfPath(args.app_name)}</title>
          <meta name="description" content="Generated by Create Next Stack." />
        </Head>
        <LandingPageTemplate />
      </>
    );
  };

  export default Index;
`
