import { Box, Flex } from "@chakra-ui/react"
import { Global, css } from "@emotion/react"
import { ComponentProps, FC } from "react"
import { Section } from "../../components/Section"
import { Description } from "./components/Description"
import { Footer } from "./components/Footer"
import { HeaderSection } from "./components/Header"
import { Newsletter } from "./components/NewsletterSection"
import { TechnologiesForm } from "./components/TechnologiesForm"

const globalStyles = css`
  body {
    background-color: #eee;
  }
`

const Card: FC<ComponentProps<typeof Box>> = (props) => (
  <Box
    width="100%"
    borderRadius={[30, 50]}
    padding={[30, 50, 70]}
    background="white"
    boxShadow="0 10px 50px rgba(0,0,0,0.1)"
    {...props}
  />
)

const LandingPageTemplate = () => {
  return (
    <>
      <Global styles={globalStyles} />
      <Flex direction="column" gap="16" alignItems="center" py="16">
        <HeaderSection />
        <Flex
          as="main"
          direction="column"
          gap="16"
          alignItems="center"
          width="100%"
        >
          <Section>
            <Description />
          </Section>
          <Section>
            <Card>
              <TechnologiesForm />
            </Card>
          </Section>
        </Flex>
        <Section paddingTop="20px">
          <Newsletter />
        </Section>
        <Footer />
      </Flex>
    </>
  )
}

export default LandingPageTemplate
