/* Impala Operating System
 *
 * Copyright (C) 2009 University of Wroclaw. Department of Computer Science
 *    http://www.ii.uni.wroc.pl/
 * Copyright (C) 2009 Mateusz Kocielski, Artur Koninski, Pawel Wieczorek
 *    http://bitbucket.org/wieczyk/impala/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *  notice, this list of conditions and the following disclaimer in the
 *  documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */
#ifndef __SYS_KMEM_H
#define __SYS_KMEM_H

enum MALLOC_FLAGS {
    KM_SLEEP,           ///< jeżeli brakuje pamięci to czekaj
    KM_NOSLEEP          ///< nigdy nie czekaj
};

typedef void kmem_ctor_t(void *);
typedef void kmem_dtor_t(void *);

addr_t kmem_zalloc(size_t s, int flags);
addr_t kmem_alloc(size_t s, int flags);
void kmem_free(addr_t );
//#define kmem_free(x) do {DEBUGF(); kmem_free(x);}while(0)

kmem_cache_t *kmem_cache_create(const char *name, size_t esize, 
        kmem_ctor_t *ctor, kmem_dtor_t *dtor);
void kmem_cache_destroy(kmem_cache_t *kc);

addr_t kmem_cache_alloc(kmem_cache_t *kc, int flags);
void kmem_cache_free(kmem_cache_t *kc, addr_t buf);


void kmem_init(void);

#endif
