# Awesome AI Papers ⭐️

## Description
This repository is an up-to-date list of significant AI papers organized by publication date. It covers five fields : computer vision, natural language processing, audio processing, multimodal learning and reinforcement learning. Feel free to give this repository a star if you enjoy the work.

Maintainer: [Aimerou Ndiaye](https://www.linkedin.com/in/aimerou-ndiaye-867708162/)

## Table of Contents
1. [2023 Papers](#2023)
    - [Computer Vision](#2023cv)
    - [Natural Language Processing](#2023nlp)
    - [Audio Processing](#2023ap)
    - [Multimodal Learning](#2023ml)
    - [Reinforcement Learning](#2023rl)
    - [Other Papers](#2023op)
2. [2022 Papers](#2022)
    - [Computer Vision](#2022cv)
    - [Natural Language Processing](#2022nlp)
    - [Audio Processing](#2022ap)
    - [Multimodal Learning](#2022ml)
    - [Reinforcement Learning](#2022rl)
    - [Other Papers](#2022op)
3. [Historical Papers](#history)

## Taxonomy
To select the most relevant papers, we chose subjective limits in terms of number of citations. Each icon here designates a paper type that meets one of these criteria.

🏆 Historical Paper : more than 10k citations and a decisive impact in the evolution of AI.

⭐ Important Paper : more than 50 citations and state of the art results.

⏫ Trend : 1 to 50 citations, recent and innovative paper with growing adoption.

📰 Important Article : decisive work that was not accompanied by a research paper.

----

## 2023 Papers <a name="2023"></a>

### Computer Vision <a name="2023cv"></a>
* ⭐ 01/2023: [Muse: Text-To-Image Generation via Masked Generative Transformers (Muse)](https://arxiv.org/abs/2301.00704)
* ⭐ 02/2023: [Structure and Content-Guided Video Synthesis with Diffusion Models (Gen-1)](https://arxiv.org/abs/2302.03011)
* ⭐ 02/2023: [Scaling Vision Transformers to 22 Billion Parameters (ViT 22B)](https://arxiv.org/abs/2302.05442)
* ⭐ 02/2023: [Adding Conditional Control to Text-to-Image Diffusion Models (ControlNet)](https://arxiv.org/abs/2302.05543)
* ⭐ 03/2023: [Visual ChatGPT: Talking, Drawing and Editing with Visual Foundation Models (Visual ChatGPT)](https://arxiv.org/abs/2303.04671)
* ⭐ 03/2023: [Scaling up GANs for Text-to-Image Synthesis (GigaGAN)](https://arxiv.org/abs/2303.05511)
* ⭐ 04/2023: [Segment Anything (SAM)](https://arxiv.org/abs/2304.02643)
* ⭐ 04/2023: [DINOv2: Learning Robust Visual Features without Supervision (DINOv2)](https://arxiv.org/abs/2304.07193)
* ⭐ 04/2023: [Visual Instruction Tuning](https://arxiv.org/abs/2304.08485)
* ⭐ 04/2023: [Align your Latents: High-Resolution Video Synthesis with Latent Diffusion Models (VideoLDM)](https://arxiv.org/abs/2304.08818)
* ⭐ 04/2023: [Synthetic Data from Diffusion Models Improves ImageNet Classification](https://arxiv.org/abs/2304.08466)
* ⭐ 04/2023: [Segment Anything in Medical Images (MedSAM)](https://arxiv.org/abs/2304.12306)
* ⭐ 05/2023: [Drag Your GAN: Interactive Point-based Manipulation on the Generative Image Manifold (DragGAN)](https://arxiv.org/abs/2305.10973)
* ⭐ 06/2023: [Neuralangelo: High-Fidelity Neural Surface Reconstruction (Neuralangelo)](https://arxiv.org/abs/2306.03092)
* ⭐ 07/2023: [SDXL: Improving Latent Diffusion Models for High-Resolution Image Synthesis (SDXL)](https://arxiv.org/abs/2307.01952)
* ⭐ 08/2023: [3D Gaussian Splatting for Real-Time Radiance Field Rendering](https://dl.acm.org/doi/abs/10.1145/3592433)
* ⭐ 08/2023: [Qwen-VL: A Versatile Vision-Language Model for Understanding, Localization... (Qwen-VL)](https://arxiv.org/abs/2308.12966)
* ⏫ 08/2023: [MVDream: Multi-view Diffusion for 3D Generation (MVDream)](https://arxiv.org/abs/2308.16512)
* ⏫ 11/2023: [Florence-2: Advancing a Unified Representation for a Variety of Vision Tasks (Florence-2)](https://arxiv.org/abs/2311.06242)
* ⏫ 12/2023: [VideoPoet: A Large Language Model for Zero-Shot Video Generation (VideoPoet)](https://arxiv.org/abs/2312.14125)

### NLP <a name="2023nlp"></a>
* ⭐ 01/2023: [DetectGPT: Zero-Shot Machine-Generated Text Detection using Probability Curvature (DetectGPT)](https://arxiv.org/abs/2301.11305)
* ⭐ 02/2023: [Toolformer: Language Models Can Teach Themselves to Use Tools (Toolformer)](https://arxiv.org/abs/2302.04761)
* ⭐ 02/2023: [LLaMA: Open and Efficient Foundation Language Models (LLaMA)](https://arxiv.org/abs/2302.13971)
* 📰 03/2023: [GPT-4](https://openai.com/research/gpt-4)
* ⭐ 03/2023: [Sparks of Artificial General Intelligence: Early experiments with GPT-4 (GPT-4 Eval)](https://arxiv.org/abs/2303.12712)
* ⭐ 03/2023: [HuggingGPT: Solving AI Tasks with ChatGPT and its Friends in HuggingFace (HuggingGPT)](https://arxiv.org/abs/2303.17580)
* ⭐ 03/2023: [BloombergGPT: A Large Language Model for Finance (BloombergGPT)](https://arxiv.org/abs/2303.17564)
* ⭐ 04/2023: [Instruction Tuning with GPT-4](https://arxiv.org/abs/2304.03277)
* ⭐ 04/2023: [Generative Agents: Interactive Simulacra of Human  (Gen Agents)](https://arxiv.org/abs/2304.03442)
* ⭐ 05/2023: [PaLM 2 Technical Report (PaLM-2)](https://arxiv.org/abs/2305.10403)
* ⭐ 05/2023: [Tree of Thoughts: Deliberate Problem Solving with Large Language Models (ToT)](https://arxiv.org/abs/2305.10601)
* ⭐ 05/2023: [LIMA: Less Is More for Alignment (LIMA)](https://arxiv.org/abs/2305.11206)
* ⭐ 05/2023: [QLoRA: Efficient Finetuning of Quantized LLMs (QLoRA)](https://arxiv.org/abs/2305.14314)
* ⭐ 05/2023: [Voyager: An Open-Ended Embodied Agent with Large Language Models (Voyager)](https://arxiv.org/abs/2305.16291)
* ⭐ 07/2023: [ToolLLM: Facilitating Large Language Models to Master 16000+ Real-world APIs (ToolLLM)](https://arxiv.org/abs/2307.16789)
* ⭐ 08/2023: [MetaGPT: Meta Programming for Multi-Agent Collaborative Framework (MetaGPT)](https://arxiv.org/abs/2308.00352)
* ⭐ 08/2023: [Code Llama: Open Foundation Models for Code (Code Llama)](https://arxiv.org/abs/2308.12950)
* ⏫ 09/2023: [RLAIF: Scaling Reinforcement Learning from Human Feedback with AI Feedback (RLAIF)](https://arxiv.org/abs/2309.00267)
* ⭐ 09/2023: [Large Language Models as Optimizers (OPRO)](https://arxiv.org/abs/2309.03409)
* ⏫ 10/2023: [Eureka: Human-Level Reward Design via Coding Large Language Models (Eureka)](https://arxiv.org/abs/2310.12931)
* ⏫ 12/2023: [Mathematical discoveries from program search with large language models (FunSearch)](https://www.nature.com/articles/s41586-023-06924-6?utm_source=substack&utm_medium=email)

### Audio Processing <a name="2023ap"></a>
* ⭐ 01/2023: [Neural Codec Language Models are Zero-Shot Text to Speech Synthesizers (VALL-E)](https://arxiv.org/abs/2301.02111)
* ⭐ 01/2023: [MusicLM: Generating Music From Text (MusicLM)](https://arxiv.org/abs/2301.11325)
* ⭐ 01/2023: [AudioLDM: Text-to-Audio Generation with Latent Diffusion Models (AudioLDM)](https://arxiv.org/abs/2301.12503)
* ⭐ 03/2023: [Google USM: Scaling Automatic Speech Recognition Beyond 100 Languages (USM)](https://arxiv.org/abs/2303.01037)
* ⭐ 05/2023: [Scaling Speech Technology to 1,000+ Languages (MMS)](https://arxiv.org/abs/2305.13516)
* ⏫ 06/2023: [Simple and Controllable Music Generation (MusicGen)](https://arxiv.org/abs/2306.05284)
* ⏫ 06/2023: [AudioPaLM: A Large Language Model That Can Speak and Listen (AudioPaLM)](https://arxiv.org/abs/2306.12925)
* ⏫ 06/2023: [Voicebox: Text-Guided Multilingual Universal Speech Generation at Scale (Voicebox)](https://arxiv.org/abs/2306.15687)

### Multimodal Learning <a name="2023ml"></a>
* ⭐ 02/2023: [Language Is Not All You Need: Aligning Perception with Language Models (Kosmos-1)](https://arxiv.org/abs/2302.14045v2)
* ⭐ 03/2023: [PaLM-E: An Embodied Multimodal Language Model (PaLM-E)](https://arxiv.org/abs/2303.03378)
* ⭐ 04/2023: [AudioGPT: Understanding and Generating Speech, Music, Sound, and Talking Head (AudioGPT)](https://arxiv.org/abs/2304.12995)
* ⭐ 05/2023: [ImageBind: One Embedding Space To Bind Them All (ImageBind)](https://openaccess.thecvf.com/content/CVPR2023/html/Girdhar_ImageBind_One_Embedding_Space_To_Bind_Them_All_CVPR_2023_paper.html)
* ⏫ 07/2023: [Scaling Autoregressive Multi-Modal Models: Pretraining and Instruction Tuning (CM3Leon)](https://ai.meta.com/research/publications/scaling-autoregressive-multi-modal-models-pretraining-and-instruction-tuning/)
* ⏫ 07/2023: [Meta-Transformer: A Unified Framework for Multimodal Learning (Meta-Transformer)](https://arxiv.org/abs/2307.10802)
* ⏫ 08/2023: [SeamlessM4T: Massively Multilingual & Multimodal Machine Translation (SeamlessM4T)](https://arxiv.org/abs/2308.11596)

### Reinforcement Learning <a name="2023rl"></a>
* ⭐ 01/2023: [Mastering Diverse Domains through World Models (DreamerV3)](https://arxiv.org/abs/2301.04104)
* ⏫ 02/2023: [Grounding Large Language Models in Interactive Environments with Online RL (GLAM)](https://arxiv.org/abs/2302.02662)
* ⏫ 02/2023: [Efficient Online Reinforcement Learning with Offline Data (RLPD)](https://arxiv.org/abs/2302.02948)
* ⏫ 03/2023: [Reward Design with Language Models](https://arxiv.org/abs/2303.00001)
* ⭐ 05/2023: [Direct Preference Optimization: Your Language Model is Secretly a Reward Model (DPO)](https://arxiv.org/abs/2305.18290)
* ⏫ 06/2023: [Faster sorting algorithms discovered using deep reinforcement learning (AlphaDev)](https://www.nature.com/articles/s41586-023-06004-9)
* ⏫ 08/2023: [Retroformer: Retrospective Large Language Agents with Policy Gradient Optimization (Retroformer)](https://arxiv.org/abs/2308.02151)

### Other Papers <a name="2023op"></a>
* ⭐ 02/2023: [Symbolic Discovery of Optimization Algorithms (Lion)](https://arxiv.org/abs/2302.06675)
* ⭐ 07/2023: [RT-2: Vision-Language-Action Models Transfer Web Knowledge to Robotic Control (RT-2)](https://arxiv.org/abs/2307.15818)
* ⏫ 11/2023: [Scaling deep learning for materials discovery (GNoME)](https://www.nature.com/articles/s41586-023-06735-9)
* ⏫ 12/2023: [Discovery of a structural class of antibiotics with explainable deep learning](https://www.nature.com/articles/s41586-023-06887-8)



## 2022 Papers <a name="2022"></a>

### Computer Vision <a name="2022cv"></a>
* ⭐ 01/2022: [A ConvNet for the 2020s (ConvNeXt)](https://openaccess.thecvf.com/content/CVPR2022/html/Liu_A_ConvNet_for_the_2020s_CVPR_2022_paper.html)
* ⭐ 01/2022: [Patches Are All You Need (ConvMixer)](https://arxiv.org/abs/2201.09792)
* ⭐ 02/2022: [Block-NeRF: Scalable Large Scene Neural View Synthesis (Block-NeRF)](https://openaccess.thecvf.com/content/CVPR2022/html/Tancik_Block-NeRF_Scalable_Large_Scene_Neural_View_Synthesis_CVPR_2022_paper.html)
* ⭐ 03/2022: [DINO: DETR with Improved DeNoising Anchor Boxes for End-to-End Object Detection (DINO)](https://openreview.net/forum?id=3mRwyG5one)
* ⭐ 03/2022: [Scaling Up Your Kernels to 31×31: Revisiting Large Kernel Design in CNNs (Large Kernel CNN)](https://openaccess.thecvf.com/content/CVPR2022/html/Ding_Scaling_Up_Your_Kernels_to_31x31_Revisiting_Large_Kernel_Design_CVPR_2022_paper.html)
* ⭐ 03/2022: [TensoRF: Tensorial Radiance Fields (TensoRF)](https://link.springer.com/chapter/10.1007/978-3-031-19824-3_20)
* ⭐ 04/2022: [MaxViT: Multi-Axis Vision Transformer (MaxViT)](https://arxiv.org/abs/2204.01697)
* ⭐ 04/2022: [Hierarchical Text-Conditional Image Generation with CLIP Latents (DALL-E 2)](https://arxiv.org/abs/2204.06125)
* ⭐ 05/2022: [Photorealistic Text-to-Image Diffusion Models with Deep Language Understanding (Imagen)](https://arxiv.org/abs/2205.11487)
* ⭐ 05/2022: [GIT: A Generative Image-to-text Transformer for Vision and Language (GIT)](https://arxiv.org/abs/2205.14100)
* ⭐ 06/2022: [CMT: Convolutional Neural Network Meet Vision Transformers (CMT)](https://openaccess.thecvf.com/content/CVPR2022/html/Guo_CMT_Convolutional_Neural_Networks_Meet_Vision_Transformers_CVPR_2022_paper.html)
* ⭐ 07/2022: [Swin UNETR: Swin Transformers for Semantic Segmentation of Brain Tumors... (Swin UNETR)](https://link.springer.com/chapter/10.1007/978-3-031-08999-2_22)
* ⭐ 07/2022: [Classifier-Free Diffusion Guidance](https://arxiv.org/abs/2207.12598)
* ⭐ 08/2022: [Fine Tuning Text-to-Image Diffusion Models for Subject-Driven Generation (DreamBooth)](https://arxiv.org/abs/2208.12242)
* ⭐ 09/2022: [DreamFusion: Text-to-3D using 2D Diffusion (DreamFusion)](https://arxiv.org/abs/2209.14988)
* ⭐ 09/2022: [Make-A-Video: Text-to-Video Generation without Text-Video Data (Make-A-Video)](https://arxiv.org/abs/2209.14792)
* ⭐ 10/2022: [On Distillation of Guided Diffusion Models](https://arxiv.org/abs/2210.03142)
* ⭐ 10/2022: [LAION-5B: An open large-scale dataset for training next generation image-text models (LAION-5B)](https://arxiv.org/abs/2210.08402)
* ⭐ 10/2022: [Imagic: Text-Based Real Image Editing with Diffusion Models (Imagic)](https://arxiv.org/abs/2210.09276)
* ⭐ 11/2022: [Visual Prompt Tuning](https://link.springer.com/chapter/10.1007/978-3-031-19827-4_41)
* ⭐ 11/2022: [Magic3D: High-Resolution Text-to-3D Content Creation (Magic3D)](https://arxiv.org/abs/2211.10440)
* ⭐ 11/2022: [DiffusionDet: Diffusion Model for Object Detection (DiffusionDet)](https://arxiv.org/abs/2211.09788)
* ⭐ 11/2022: [InstructPix2Pix: Learning to Follow Image Editing Instructions (InstructPix2Pix)](https://arxiv.org/abs/2211.09800)
* ⭐ 12/2022: [Multi-Concept Customization of Text-to-Image Diffusion (Custom Diffusion)](https://arxiv.org/abs/2212.04488)
* ⭐ 12/2022: [Scalable Diffusion Models with Transformers (DiT)](https://arxiv.org/abs/2212.09748)

### NLP <a name="2022nlp"></a>
* ⭐ 01/2022: [LaMBDA: Language Models for Dialog Applications (LaMBDA)](https://arxiv.org/abs/2201.08239)
* ⭐ 01/2022: [Chain-of-Thought Prompting Elicits Reasoning in Large Language Models (CoT)](https://arxiv.org/abs/2201.11903)
* ⭐ 02/2022: [Competition-Level Code Generation with AlphaCode (AlphaCode)](https://www.science.org/doi/full/10.1126/science.abq1158)
* ⭐ 02/2022: [Finetuned Language Models Are Zero-Shot Learners (FLAN)](https://arxiv.org/abs/2109.01652)
* ⭐ 03/2022: [Training language models to follow human instructions with human feedback (InstructGPT)](https://arxiv.org/abs/2203.02155)
* ⭐ 03/2022: [Multitask Prompted Training Enables Zero-Shot Task Generalization (T0)](https://arxiv.org/abs/2110.08207)
* ⭐ 03/2022: [Training Compute-Optimal Large Language Models (Chinchilla)](https://arxiv.org/abs/2203.15556)
* ⭐ 04/2022: [Do As I Can, Not As I Say: Grounding Language in Robotic Affordances (SayCan)](https://arxiv.org/abs/2204.01691)
* ⭐ 04/2022: [GPT-NeoX-20B: An Open-Source Autoregressive Language Model (GPT-NeoX)](https://arxiv.org/abs/2204.06745)
* ⭐ 04/2022: [PaLM: Scaling Language Modeling with Pathways (PaLM)](https://arxiv.org/abs/2204.02311)
* ⭐ 06/2022: [Beyond the Imitation Game: Quantifying and extrapolating the capabilities of lang... (BIG-bench)](https://arxiv.org/abs/2206.04615)
* ⭐ 06/2022: [Solving Quantitative Reasoning Problems with Language Models (Minerva)](https://arxiv.org/abs/2206.14858)
* ⭐ 10/2022: [ReAct: Synergizing Reasoning and Acting in Language Models (ReAct)](https://arxiv.org/abs/2210.03629)
* ⭐ 11/2022: [BLOOM: A 176B-Parameter Open-Access Multilingual Language Model (BLOOM)](https://arxiv.org/abs/2211.05100)
* 📰 11/2022: [Optimizing Language Models for Dialogue (ChatGPT)](https://openai.com/blog/chatgpt/)
* ⭐ 12/2022: [Large Language Models Encode Clinical Knowledge (Med-PaLM)](https://arxiv.org/abs/2212.13138)

### Audio Processing <a name="2022ap"></a>
* ⭐ 02/2022: [mSLAM: Massively multilingual joint pre-training for speech and text (mSLAM)](https://arxiv.org/abs/2202.01374)
* ⭐ 02/2022: [ADD 2022: the First Audio Deep Synthesis Detection Challenge (ADD)](https://arxiv.org/abs/2202.08433)
* ⭐ 03/2022: [Efficient Training of Audio Transformers with Patchout (PaSST)](https://arxiv.org/abs/2110.05069)
* ⭐ 04/2022: [MAESTRO: Matched Speech Text Representations through Modality Matching (Maestro)](https://arxiv.org/abs/2204.03409)
* ⭐ 05/2022: [SpeechT5: Unified-Modal Encoder-Decoder Pre-Training for Spoken Language... (SpeechT5)](https://arxiv.org/abs/2110.07205)
* ⭐ 06/2022: [WavLM: Large-Scale Self-Supervised Pre-Training for Full Stack Speech Processing (WavLM)](https://ieeexplore.ieee.org/abstract/document/9814838)
* ⭐ 07/2022: [BigSSL: Exploring the Frontier of Large-Scale Semi-Supervised Learning for ASR (BigSSL)](https://arxiv.org/abs/2109.13226)
* ⭐ 08/2022: [MuLan: A Joint Embedding of Music Audio and Natural Language (MuLan)](https://arxiv.org/abs/2208.12415)
* ⭐ 09/2022: [AudioLM: a Language Modeling Approach to Audio Generation (AudioLM)](https://arxiv.org/abs/2209.03143)
* ⭐ 09/2022: [AudioGen: Textually Guided Audio Generation (AudioGen)](https://arxiv.org/abs/2209.15352)
* ⭐ 10/2022: [High Fidelity Neural Audio Compression (EnCodec)](https://arxiv.org/abs/2210.13438)
* ⭐ 12/2022: [Robust Speech Recognition via Large-Scale Weak Supervision (Whisper)](https://arxiv.org/abs/2212.04356)

### Multimodal Learning <a name="2022ml"></a>
* ⭐ 01/2022: [BLIP: Boostrapping Language-Image Pre-training for Unified Vision-Language... (BLIP)](https://proceedings.mlr.press/v162/li22n.html)
* ⭐ 02/2022: [data2vec: A General Framework for Self-supervised Learning in Speech, Vision and... (Data2vec)](https://proceedings.mlr.press/v162/baevski22a.html)
* ⭐ 03/2022: [VL-Adapter: Parameter-Efficient Transfer Learning for Vision-and-Language Tasks (VL-Adapter)](https://arxiv.org/abs/2112.06825)
* ⭐ 04/2022: [Winoground: Probing Vision and Language Models for Visio-Linguistic... (Winoground)](https://arxiv.org/abs/2204.03162)
* ⭐ 04/2022: [Flamingo: a Visual Language Model for Few-Shot Learning (Flamingo)](https://arxiv.org/abs/2204.14198)
* ⭐ 05/2022: [A Generalist Agent (Gato)](https://arxiv.org/abs/2205.06175)
* ⭐ 05/2022: [CoCa: Contrastive Captioners are Image-Text Foundation Models (CoCa)](https://arxiv.org/abs/2205.01917)
* ⭐ 05/2022: [VLMo: Unified Vision-Language Pre-Training with Mixture-of-Modality-Experts (VLMo)](https://arxiv.org/abs/2111.02358)
* ⭐ 08/2022: [Image as a Foreign Language: BEiT Pretraining for All Vision and Vision-Language Tasks (BEiT)](https://arxiv.org/abs/2208.10442v2)
* ⭐ 09/2022: [PaLI: A Jointly-Scaled Multilingual Language-Image Model (PaLI)](https://arxiv.org/abs/2209.06794)

### Reinforcement Learning <a name="2022rl"></a>
* ⭐ 01/2022: [Learning robust perceptive locomotion for quadrupedal robots in the wild](https://www.science.org/doi/abs/10.1126/scirobotics.abk2822)
* ⭐ 02/2022: [BC-Z: Zero-Shot Task Generalization with Robotic Imitation Learning](https://proceedings.mlr.press/v164/jang22a.html)
* ⭐ 02/2022: [Outracing champion Gran Turismo drivers with deep reinforcement learning (Sophy)](https://www.nature.com/articles/s41586-021-04357-7)
* ⭐ 02/2022: [Magnetic control of tokamak plasmas through deep reinforcement learning](https://www.nature.com/articles/s41586-021-04301-9%E2%80%A6)
* ⭐ 08/2022: [Learning to Walk in Minutes Using Massively Parallel Deep Reinforcement Learning (ANYmal)](https://arxiv.org/abs/2109.11978)
* ⭐ 10/2022: [Discovering faster matrix multiplication algorithms with reinforcement learning (AlphaTensor)](https://www.nature.com/articles/s41586-022%20-05172-4)

### Other Papers <a name="2022op"></a>
* ⭐ 02/2022: [FourCastNet: A Global Data-driven High-resolution Weather Model... (FourCastNet)](https://arxiv.org/abs/2202.11214)
* ⭐ 05/2022: [ColabFold: making protein folding accessible to all (ColabFold)](https://www.nature.com/articles/s41592-022-01488-1)
* ⭐ 06/2022: [Measuring and Improving the Use of Graph Information in GNN](https://arxiv.org/abs/2206.13170)
* ⭐ 10/2022: [TimesNet: Temporal 2D-Variation Modeling for General Time Series Analysis (TimesNet)](https://arxiv.org/abs/2210.02186)
* ⭐ 12/2022: [RT-1: Robotics Transformer for Real-World Control at Scale (RT-1)](https://arxiv.org/abs/2212.06817)



## Historical Papers <a name="history"></a>
* 🏆 1958: [Perceptron: A probabilistic model for information storage and organization in the brain (Perceptron)](https://psycnet.apa.org/record/1959-09865-001)
* 🏆 1986: [Learning representations by back-propagating errors (Backpropagation)](https://www.nature.com/articles/323533a0)
* 🏆 1986: [Induction of decision trees (CART)](https://link.springer.com/article/10.1007/BF00116251)
* 🏆 1989: [A Tutorial on Hidden Markov Models and Selected Applications in Speech Recognition (HMM)](https://ieeexplore.ieee.org/abstract/document/18626)
* 🏆 1989: [Multilayer feedforward networks are universal approximators](https://www.sciencedirect.com/science/article/abs/pii/0893608089900208)
* 🏆 1992: [A training algorithm for optimal margin classifiers (SVM)](https://dl.acm.org/doi/10.1145/130385.130401)
* 🏆 1996: [Bagging predictors](https://link.springer.com/article/10.1007/BF00058655)
* 🏆 1998: [Gradient-based learning applied to document recognition (CNN/GTN)](https://ieeexplore.ieee.org/abstract/document/726791)
* 🏆 2001: [Random Forests](https://link.springer.com/article/10.1023/a:1010933404324)
* 🏆 2001: [A fast and elitist multiobjective genetic algorithm (NSGA-II)](https://ieeexplore.ieee.org/abstract/document/996017)
* 🏆 2003: [Latent Dirichlet Allocation (LDA)](https://jmlr.csail.mit.edu/papers/v3/blei03a.html)
* 🏆 2006: [Reducing the Dimensionality of Data with Neural Networks (Autoencoder)](https://www.science.org/doi/abs/10.1126/science.1127647)
* 🏆 2008: [Visualizing Data using t-SNE (t-SNE)](https://www.jmlr.org/papers/v9/vandermaaten08a.html)
* 🏆 2009: [ImageNet: A large-scale hierarchical image database (ImageNet)](https://ieeexplore.ieee.org/document/5206848)
* 🏆 2012: [ImageNet Classification with Deep Convolutional Neural Networks (AlexNet)](https://papers.nips.cc/paper/2012/hash/c399862d3b9d6b76c8436e924a68c45b-Abstract.html)
* 🏆 2013: [Efficient Estimation of Word Representations in Vector Space (Word2vec)](https://arxiv.org/abs/1301.3781)
* 🏆 2013: [Auto-Encoding Variational Bayes (VAE)](https://arxiv.org/abs/1312.6114)
* 🏆 2014: [Generative Adversarial Networks (GAN)](https://papers.nips.cc/paper/2014/hash/5ca3e9b122f61f8f06494c97b1afccf3-Abstract.html)
* 🏆 2014: [Dropout: A Simple Way to Prevent Neural Networks from Overfitting (Dropout)](https://jmlr.org/papers/v15/srivastava14a.html)
* 🏆 2014: [Sequence to Sequence Learning with Neural Networks](https://proceedings.neurips.cc/paper/2014/hash/a14ac55a4f27472c5d894ec1c3c743d2-Abstract.html)
* 🏆 2014: [Neural Machine Translation by Jointly Learning to Align and Translate (RNNSearch-50)](https://arxiv.org/abs/1409.0473)
* 🏆 2014: [Adam: A Method for Stochastic Optimization (Adam)](https://arxiv.org/abs/1412.6980)
* 🏆 2015: [Batch Normalization: Accelerating Deep Network Training by Reducing Internal Cov... (BatchNorm)](http://proceedings.mlr.press/v37/ioffe15.html)
* 🏆 2015: [Going Deeper With Convolutions (Inception)](https://www.cv-foundation.org/openaccess/content_cvpr_2015/html/Szegedy_Going_Deeper_With_2015_CVPR_paper.html)
* 🏆 2015: [Human-level control through deep reinforcement learning (Deep Q Network)](https://www.nature.com/articles/nature14236/)
* 🏆 2015: [Faster R-CNN: Towards Real-Time Object Detection with Region Proposal Networks (Faster R-CNN)](https://papers.nips.cc/paper/2015/hash/14bfa6bb14875e45bba028a21ed38046-Abstract.html)
* 🏆 2015: [U-Net: Convolutional Networks for Biomedical Image Segmentation (U-Net)](https://arxiv.org/abs/1505.04597)
* 🏆 2015: [Deep Residual Learning for Image Recognition (ResNet)](https://arxiv.org/abs/1512.03385)
* 🏆 2016: [You Only Look Once: Unified, Real-Time Object Detection (YOLO)](https://www.cv-foundation.org/openaccess/content_cvpr_2016/html/Redmon_You_Only_Look_CVPR_2016_paper.html)
* 🏆 2017: [Attention is All you Need (Transformer)](https://proceedings.neurips.cc/paper/2017/hash/3f5ee243547dee91fbd053c1c4a845aa-Abstract.html)
* 🏆 2018: [BERT: Pre-training of Deep Bidirectional Transformers for Language Understanding (BERT)](https://arxiv.org/abs/1810.04805)
* 🏆 2020: [Language Models are Few-Shot Learners (GPT-3)](https://proceedings.neurips.cc/paper/2020/hash/1457c0d6bfcb4967418bfb8ac142f64a-Abstract.html)
* 🏆 2020: [Denoising Diffusion Probabilistic Models (DDPM)](https://proceedings.neurips.cc/paper/2020/hash/4c5bcfec8584af0d967f1ab10179ca4b-Abstract.html)
* 🏆 2020: [An Image is Worth 16x16 Words: Transformers for Image Recognition at Scale (ViT)](https://arxiv.org/abs/2010.11929)
* 🏆 2021: [Highly accurate protein structure prediction with AlphaFold (Alphafold)](https://www.nature.com/articles/s41586-021-03819-2)
* 📰 2022: [ChatGPT: Optimizing Language Models For Dialogue (ChatGPT)](https://openai.com/blog/chatgpt/)
