CREATE ALIAS IF NOT EXISTS FT_INIT FOR "org.h2.fulltext.FullText.init";
CALL FT_INIT();

 CREATE CACHED TABLE IF NOT EXISTS DOCUMENT_TABLE
 (
 ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY HASH,
 DOC_ID VARCHAR(255) UNIQUE,
 SOURCE_ID VARCHAR(32),
 SOURCE_DATE DATETIME,
 PROCESS_DATE DATETIME,
 CONTENT CLOB
 );

 CREATE INDEX IF NOT EXISTS SOURCE_DATE_INDEX ON DOCUMENT_TABLE (SOURCE_DATE);
 CREATE UNIQUE HASH INDEX IF NOT EXISTS DOC_ID_INDEX ON DOCUMENT_TABLE (DOC_ID);
 CREATE HASH INDEX IF NOT EXISTS SOURCE_ID_INDEX ON DOCUMENT_TABLE (SOURCE_ID);

 CREATE CACHED TABLE IF NOT EXISTS SENTENCE_TABLE
 (
 ID INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 DOC_KEY INT NOT NULL,
 CONTENT VARCHAR(512)
 );

 CREATE HASH INDEX IF NOT EXISTS DOC_KEY ON SENTENCE_TABLE (DOC_KEY);

CALL FT_CREATE_INDEX('PUBLIC', 'SENTENCE_TABLE', NULL);