# Project Specifications

## Tech Stacks

- Framework: [Next.js](https://nextjs.org/)
- Language: [TypeScript](https://www.typescriptlang.org/)
- Base Design System / UI Components: [Chakra UI](https://chakra-ui.com/)
- Content SDK: [Contentlayer](https://www.contentlayer.dev/)
- Markdown Rendering: [React Markdown](https://remarkjs.github.io/react-markdown/)
  - [chakra-ui-markdown-renderer](https://www.npmjs.com/package/chakra-ui-markdown-renderer)
- Comment system: [Giscus](https://giscus.app/)
- SEO:
  - [next-seo](https://www.npmjs.com/package/next-seo)
  - [next-sitemap](https://www.npmjs.com/package/next-sitemap)
- Anonymous Analytics: [umami](https://umami.is/)
- Utilities:
  - [date-fns](https://date-fns.org/)
  - [lodash-es](https://lodash.com/)
- Additional Components:
  - [cmdk](https://cmdk.paco.me/)
  - [nextjs-progressbar](https://www.npmjs.com/package/nextjs-progressbar)

### Development Tools

- Code Style:
  - [eslint](https://eslint.org/)
  - [prettier](https://prettier.io/)
- [◊ WIP ◊] Testing:
  - Test runner: [vitest](https://vitest.dev)
- Git hooks:
  - [husky](https://typicode.github.io/husky)
  - [lint-staged](https://www.npmjs.com/package/lint-staged)
  - [commitlint](https://commitlint.js.org/)
  - [commitizen](https://commitizen-tools.github.io/commitizen/)
- Release Workflow:
  - [standard-version](https://www.npmjs.com/package/standard-version)
  - [changelogithub](https://github.com/antfu/changelogithub)
  - [release-please](https://github.com/googleapis/release-please)
