---
title: 2020 Recap
date: "2020-12-31"
cover: https://images.unsplash.com/photo-1600066975936-ecc81000c8b6?auto=format&q=80
legacyID: "2020-12-31-2020-recap"
thumbnail: "📘"
published: true
tags:
  - recap
---

I think most would say 2020 is a roller coaster year. Even though, 2020 is one of a hella ride and worth for me to be remembered. I've made a quick recap in **[2019](https://agustinusnathaniel.com/blog/2019-recap)** before. So let's review what I've been up to in 2020.

## What I Learned and Discovered Throughout the Year

### Instagram Filter Creation

I love to edit photos and playing around with colors. Then I learn how to make my own Instagram filter. Turned out facebook provides a tool dedicated for that called Spark AR Studio. You can make literally almost anything starting from a color filter, games, quizzes, anything you can think of when playing around with AR. I just want to edit colors so I just go with color filter. Making a color filter is quite simple, you only have to create a LUT, import it to your Spark AR projects as a layer, export it, and upload it to Spark AR and connect it with your instagram account. Check out some filter I made [here](https://www.instagram.com/agustinusnathaniel/).

### React Hooks and Context

React hooks been around but I've never learn or use it until I finally get my hands on it when building  an app as part of my undergraduate thesis. I used to stick with Classful Components and use redux (just in desperate moments), but learning hooks and context helps me to switch fully to Functional Components.

### TailwindCSS

2019 was a year where I finally get my hands on React and started to re-learn GatsbyJS (I tried to learn Gatsby before touching React at 2018 and it was a disaster idea). It was a really fun journey. But there's something I've been wanting to try but never accomplished at 2019....TailwindCSS. So, at 2020 I finally get my hands on it and it was really different than other styling frameworks I've ever used before (Bootstrap, Bulma, SemanticUI). I use it to rebuild my first personal site (agustinusnathaniel.com). But around the end of 2020 I re-write it again using Chakra-UI.

### Svelte

I heard svelte often but never tried it until I stumble upon Rich Harris's video when he explain about reactivity. His explanation is really great and quite eye-opening for me who mainly develop using React. So I tried it, made some little projects with it and I like how straightforward it is. I'd recommend using svelte if you are looking for a powerful javascript libraries like react or vue (framework) but with an easier learning curve. I'd love to see Svelte's development over the next years. But not long after that I also got my hands on Next.js.

### Next.js

I learn Next.js and implement it in some of my projects. I used to avoid learning and using Next.js because I haven't understand SSR properly yet. I thought Next.js is only used for SSR projects. Then I found out Next.js support both static site generation and server side rendering since version 9.3 and I got my hands on it for the first time not so long after version 9.4 released. Since then, Next.js has been my go-to react framework for most of my projects.

### Chakra UI

I tried several design system or component libraries this year: Fluent UI, Carbon, Material UI, and Chakra UI. After trying out and play around with those design systems, I found out Chakra UI suits my needs the best. It's easy to be configured, easy to use, and it has color mode styling and management built in. After some time, I made a template with Next.js, Chakra UI, and TypeScript pre-configured and has been my go-to template to initiate most of my recent projects.

## Projects I Worked on in 2020

most of the projects are just a little side projects for me to try implement some simple ideas or learning something.

### 1. Personal Site Revamp

I re-write my personal site [agustinusnathaniel.com](https://agustinusnathaniel.com) using TailwindCSS and add blog section. At the end of the year I replace the TailwindCSS usage with Chakra UI.

### 2. Le-Cook

An [app](https://le-cook.sznm.dev) to find food recipe, powered by RecipePuppy API

### 3. Covid-19 Data

[Monitor Covid-19 statistics](https://covid19.sznm.dev), powered by @mathdroid's Covid-19 API, @ariya's Dekontaminasi API, and @Reynaldi531's api-covid19-indonesia v2. First developed using Gatsby, then re-wrote it with Next.js and Chakra UI.

### 4. Advice Generator

A random [advice generator](https://advicegen.sznm.dev) powered by Advice Slip JSON API, written using Svelte.

### 5. Insta Profile

A simple Svelte [app](https://instaprofile.sznm.dev) fetching data from Instagram.

### 6. sznm.dev

I make [another personal site](https://sznm.dev) of myself dedicated for dev content, built using Next.js, composed using Chakra UI.

### 7. KapturaLumina

Basic Photography Learning Mobile App with Gamification. Built using Ionic, React, and Firebase. Available as [PWA](https://kapturalumina.sznm.dev) and [android](https://play.google.com/store/apps/details?id=dev.sznm.kapturalumina) app. I built it as part of my undergraduate thesis.

### 8. nextarter-chakra

A [template](https://nextarter-chakra.sznm.dev/) I made to initialize Next.js projects with TypeScript and Chakra UI setup. Most of my following projects are initalized / generated using this template.

### 9. Add to Calendar Generator

A web [app](https://addtocal.sznm.dev) to generate Add to Calendar link (Google Calendar).

### 10. InstaDLD

Instagram post media [downloader](https://instadld.sznm.dev) with multipost download supported.

### 11. Public APIs

An [app](https://publicapis.sznm.dev) to find public API for you next projects. Didn't thought it could be the [product of the day](https://www.producthunt.com/posts/public-apis-3) in Product Hunt at 26 Dec 2020. Powered by api.publicapis.org.

## Some other stuffs worth to mention

- I graduated from college (finally) 😊😊. Really grateful for everyone who supported me until now, especially my family and friends.
- I started my career as Software Engineer right after I finished my thesis.

All in all, I'm glad I can get through 2020 pretty well enough. I never imagined I'd graduate in time, especially when the pandemic situation started to happen and my thesis proposals got rejected several times. Hoping to grow more in 2021 and crafting greater stuffs. Thank you for reading and I hope you are doing well 😄.

If you're interested in another version of my review of my journey in 2020, I also published it at [twitter](https://twitter.com/agstnsnathaniel/status/1345261139358142467) (focused around the projects I made throughout the year).

My previous recap: **[2019](https://agustinusnathaniel.com/blog/2019-recap)**.
