#
# TABLE STRUCTURE FOR: accounts
#

DROP TABLE IF EXISTS `accounts`;

CREATE TABLE `accounts` (
  `acc_id` int(11) NOT NULL AUTO_INCREMENT,
  `acc_name` varchar(255) NOT NULL,
  `acc_bank_name` varchar(255) NOT NULL,
  `acc_branch_name` varchar(255) NOT NULL,
  `acc_branch_number` varchar(11) NOT NULL,
  `acc_number` varchar(50) NOT NULL,
  `acc_iban` varchar(26) NOT NULL,
  `acc_type` int(11) NOT NULL,
  `acc_owner` varchar(255) NOT NULL,
  `acc_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `acc_balance` decimal(9,2) NOT NULL DEFAULT '0.00',
  `acc_date` varchar(100) NOT NULL,
  PRIMARY KEY (`acc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `accounts` (`acc_id`, `acc_name`, `acc_bank_name`, `acc_branch_name`, `acc_branch_number`, `acc_number`, `acc_iban`, `acc_type`, `acc_owner`, `acc_isActive`, `acc_balance`, `acc_date`) VALUES (1, 'Kuveyt Türk AFŞ', 'Kuveyt Türk', 'Kayapınar', '95337055', '', 'TR650020500009533705500001', 3, 'Azad Furkan Şakar', 1, '500000.00', '05/01/2020');
INSERT INTO `accounts` (`acc_id`, `acc_name`, `acc_bank_name`, `acc_branch_name`, `acc_branch_number`, `acc_number`, `acc_iban`, `acc_type`, `acc_owner`, `acc_isActive`, `acc_balance`, `acc_date`) VALUES (2, 'QNB Finansbank AFŞ', 'QNB Finansbank', 'Ofis', '85839678', '', 'TR760011100000000085839678', 3, 'Azad Furkan Şakar', 1, '71500.00', '01/01/2021');
INSERT INTO `accounts` (`acc_id`, `acc_name`, `acc_bank_name`, `acc_branch_name`, `acc_branch_number`, `acc_number`, `acc_iban`, `acc_type`, `acc_owner`, `acc_isActive`, `acc_balance`, `acc_date`) VALUES (3, 'Ziraat Bankası AFŞ', 'Ziraat Bankası', 'Karaköprü', '', '', 'TR570001002151667194125001', 3, 'Azad Furkan Şakar', 1, '249464.55', '13/01/2021');
INSERT INTO `accounts` (`acc_id`, `acc_name`, `acc_bank_name`, `acc_branch_name`, `acc_branch_number`, `acc_number`, `acc_iban`, `acc_type`, `acc_owner`, `acc_isActive`, `acc_balance`, `acc_date`) VALUES (4, 'Nakit', '', '', '', '', 'TR', 0, 'Azad Furkan Şakar', 1, '0.00', '19/01/2021');


#
# TABLE STRUCTURE FOR: accounts_type
#

DROP TABLE IF EXISTS `accounts_type`;

CREATE TABLE `accounts_type` (
  `act_id` int(11) NOT NULL AUTO_INCREMENT,
  `act_title` varchar(255) NOT NULL,
  `act_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `act_createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `rank` int(11) NOT NULL,
  PRIMARY KEY (`act_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `accounts_type` (`act_id`, `act_title`, `act_isActive`, `act_createdAt`, `rank`) VALUES (1, 'Banka Hesabı', 1, '2021-01-05 21:21:08', 0);
INSERT INTO `accounts_type` (`act_id`, `act_title`, `act_isActive`, `act_createdAt`, `rank`) VALUES (2, 'Kredi Kartı', 1, '2021-01-05 21:21:16', 1);
INSERT INTO `accounts_type` (`act_id`, `act_title`, `act_isActive`, `act_createdAt`, `rank`) VALUES (3, 'Vadesiz Hesap', 1, '2021-01-06 00:23:11', 2);


#
# TABLE STRUCTURE FOR: bill_payments
#

DROP TABLE IF EXISTS `bill_payments`;

CREATE TABLE `bill_payments` (
  `bill_pay_id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` int(11) NOT NULL,
  `acc_id` int(11) NOT NULL,
  `bill_pay_amount` decimal(9,2) NOT NULL,
  `bill_pay_description` text NOT NULL,
  `bill_pay_date` varchar(40) NOT NULL,
  PRIMARY KEY (`bill_pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `bill_payments` (`bill_pay_id`, `bill_id`, `acc_id`, `bill_pay_amount`, `bill_pay_description`, `bill_pay_date`) VALUES (7, 2, 2, '3000.00', 'Ödeme alındı', '2021/03/18');


#
# TABLE STRUCTURE FOR: bills
#

DROP TABLE IF EXISTS `bills`;

CREATE TABLE `bills` (
  `bill_id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_number` varchar(40) NOT NULL,
  `bill_cre_date` varchar(40) NOT NULL,
  `bill_items` text NOT NULL,
  `bill_description` text NOT NULL,
  `bill_total` decimal(9,2) NOT NULL,
  `sup_id` int(11) NOT NULL,
  PRIMARY KEY (`bill_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `bills` (`bill_id`, `bill_number`, `bill_cre_date`, `bill_items`, `bill_description`, `bill_total`, `sup_id`) VALUES (2, 'BILL0001', '2021/03/18', '[{\"pr_code\":\"PR0001\",\"pr_id\":\"1\",\"pr_unit\":\"Ad\",\"pr_qnt\":\"1\",\"pr_amount\":\"423.73\",\"pr_price\":\"76.27\",\"pr_tax\":\"76.27\"},{\"pr_code\":\"PR0002\",\"pr_id\":\"2\",\"pr_unit\":\"Ad\",\"pr_qnt\":\"1\",\"pr_amount\":\"2118.64\",\"pr_price\":\"381.36\",\"pr_tax\":\"381.36\"}]', 'Alış faturası', '3000.00', 1);


#
# TABLE STRUCTURE FOR: calendar
#

DROP TABLE IF EXISTS `calendar`;

CREATE TABLE `calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `isActive` tinyint(4) NOT NULL,
  `fw_id` int(11) NOT NULL DEFAULT '0',
  `bgColor` varchar(40) NOT NULL,
  `textColor` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8;

INSERT INTO `calendar` (`id`, `title`, `start_date`, `end_date`, `isActive`, `fw_id`, `bgColor`, `textColor`) VALUES (21, 'Proje tamamlanacak', '2021-03-16', '2021-03-31', 0, 0, '#002A68', '#FFF7F7');
INSERT INTO `calendar` (`id`, `title`, `start_date`, `end_date`, `isActive`, `fw_id`, `bgColor`, `textColor`) VALUES (23, 'Vivense IK ile görüşme', '2021-03-24', '0000-00-00', 0, 0, '#EC5F00', '#FFF7F7');


#
# TABLE STRUCTURE FOR: customers
#

DROP TABLE IF EXISTS `customers`;

CREATE TABLE `customers` (
  `cus_id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_name` varchar(255) NOT NULL,
  `cus_owner` varchar(255) NOT NULL,
  `cus_owner_phone` varchar(40) NOT NULL,
  `cus_phone` varchar(40) NOT NULL,
  `cus_fax` varchar(40) NOT NULL,
  `cus_gsm` varchar(40) NOT NULL,
  `cus_email` varchar(255) NOT NULL,
  `cus_address` text NOT NULL,
  `cus_tax_office` varchar(255) NOT NULL,
  `cus_tax_number` varchar(20) NOT NULL,
  `cus_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `cus_info` longtext NOT NULL,
  `cus_logo` varchar(255) DEFAULT NULL,
  `cus_debit` decimal(9,2) NOT NULL,
  `cus_credit` decimal(9,2) NOT NULL,
  PRIMARY KEY (`cus_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `customers` (`cus_id`, `cus_name`, `cus_owner`, `cus_owner_phone`, `cus_phone`, `cus_fax`, `cus_gsm`, `cus_email`, `cus_address`, `cus_tax_office`, `cus_tax_number`, `cus_isActive`, `cus_info`, `cus_logo`, `cus_debit`, `cus_credit`) VALUES (1, 'Tire İnşaat', 'Muzaffer ORUÇ', '(531) 619-1969', '(412) 224-5630', '(412) 224-5630', '(531) 521-5555', 'tiremuhasebe1@gmail.com', 'Kooperatifler Mahallesi Akkoyunlu 3. Sokak Eserler-4 Apt. No:1/5 Yenişehir,Diyarbakır', 'Gökalp', '6450523654', 1, '<p>M&uuml;şteri Anlaşma;</p>\r\n\r\n<ul>\r\n	<li>Anlaşma-1</li>\r\n	<li>Anlaşma-2</li>\r\n	<li>Anlaşma-3</li>\r\n	<li>Anlaşma-4</li>\r\n</ul>\r\n', '76116customers.png', '0.00', '900000.00');
INSERT INTO `customers` (`cus_id`, `cus_name`, `cus_owner`, `cus_owner_phone`, `cus_phone`, `cus_fax`, `cus_gsm`, `cus_email`, `cus_address`, `cus_tax_office`, `cus_tax_number`, `cus_isActive`, `cus_info`, `cus_logo`, `cus_debit`, `cus_credit`) VALUES (2, 'PD Yapı Proje', 'Uğur Yanar', '(555) 555-5555', '(555) 555-5555', '', '', 'info@pdyapi.com.tr', 'Ankara', '', '', 1, '<p>Müşteri notu</p>', '87118customers.png', '0.00', '-400000.00');


#
# TABLE STRUCTURE FOR: email_settings
#

DROP TABLE IF EXISTS `email_settings`;

CREATE TABLE `email_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `protocol` varchar(10) COLLATE utf8_turkish_ci NOT NULL,
  `host` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `port` varchar(10) COLLATE utf8_turkish_ci NOT NULL,
  `user` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `password` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `from` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `to` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `isActive` tinyint(4) NOT NULL DEFAULT '1',
  `user_name` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_turkish_ci;

INSERT INTO `email_settings` (`id`, `protocol`, `host`, `port`, `user`, `password`, `from`, `to`, `isActive`, `user_name`) VALUES (1, 'smtp', 'ssl://smtp.gmail.com', '465', 'superadmin@gmail.com', '123456789', 'superadmin@gmail.com', 'superadmin@gmail.com', 1, 'CodePay Muhasebe');


#
# TABLE STRUCTURE FOR: email_templates
#

DROP TABLE IF EXISTS `email_templates`;

CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates` (`id`, `title`, `url`, `subject`, `body`, `createdAt`) VALUES (1, 'Recover Your Password', 'forget-password', 'Forgot Password', '<p>Hi <b>{FULLNAME}</b>,</p><p>\r\nWe have received a request to reset your password.\r\n</p><p>\r\n\r\nYour new password: {NEW_PASS}</p><p>If you wish, you can log in from the link below and change your password.</p><p>{LOGIN_LINK}</p><p>If you are unable to initiate this request, please contact us.<br></p>', '2021-01-05 12:19:17');
INSERT INTO `email_templates` (`id`, `title`, `url`, `subject`, `body`, `createdAt`) VALUES (2, 'General Message', 'general-message', 'General Message', 'You can edit the message content here.', '2021-01-05 13:06:06');


#
# TABLE STRUCTURE FOR: email_templates_veriable
#

DROP TABLE IF EXISTS `email_templates_veriable`;

CREATE TABLE `email_templates_veriable` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_id` int(11) NOT NULL,
  `veriable_name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `email_templates_veriable` (`id`, `template_id`, `veriable_name`) VALUES (1, 1, '{FULLNAME}');
INSERT INTO `email_templates_veriable` (`id`, `template_id`, `veriable_name`) VALUES (2, 1, '{NEW_PASS}');
INSERT INTO `email_templates_veriable` (`id`, `template_id`, `veriable_name`) VALUES (3, 1, '{LOGIN_LINK}');


#
# TABLE STRUCTURE FOR: expense_category
#

DROP TABLE IF EXISTS `expense_category`;

CREATE TABLE `expense_category` (
  `exc_id` int(11) NOT NULL AUTO_INCREMENT,
  `exc_title` varchar(255) NOT NULL,
  `exc_isActive` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`exc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `expense_category` (`exc_id`, `exc_title`, `exc_isActive`) VALUES (0, 'Alış Faturası Ödemesi', 1);
INSERT INTO `expense_category` (`exc_id`, `exc_title`, `exc_isActive`) VALUES (4, 'Market harcaması', 1);


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `sup_id` int(11) NOT NULL DEFAULT '0',
  `acc_id` int(11) NOT NULL,
  `op_date` varchar(250) NOT NULL,
  `op_price` decimal(9,2) NOT NULL,
  `op_description` text NOT NULL,
  `op_type` enum('official','unofficial') NOT NULL,
  `exc_id` int(11) NOT NULL,
  `bill_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`op_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO `expenses` (`op_id`, `sup_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `exc_id`, `bill_id`) VALUES (12, 1, 2, '2021/03/18', '3000.00', 'Ödeme alındı', 'official', 0, 2);
INSERT INTO `expenses` (`op_id`, `sup_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `exc_id`, `bill_id`) VALUES (14, 0, 2, '2021/03/17', '500.00', 'Market harcaması', 'unofficial', 4, 0);
INSERT INTO `expenses` (`op_id`, `sup_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `exc_id`, `bill_id`) VALUES (15, 0, 3, '2021/03/21', '535.45', 'Market harcaması', 'unofficial', 4, 0);


#
# TABLE STRUCTURE FOR: forward_operations
#

DROP TABLE IF EXISTS `forward_operations`;

CREATE TABLE `forward_operations` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_id` int(11) NOT NULL DEFAULT '0',
  `acc_id` int(11) NOT NULL,
  `op_date` varchar(250) NOT NULL,
  `op_price` decimal(9,2) NOT NULL,
  `op_description` text NOT NULL,
  `op_type` enum('official','unofficial') NOT NULL,
  `inc_id` int(11) NOT NULL,
  `inv_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`op_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: forward_transactions
#

DROP TABLE IF EXISTS `forward_transactions`;

CREATE TABLE `forward_transactions` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_sup_id` int(11) NOT NULL DEFAULT '0',
  `acc_id` int(11) NOT NULL,
  `op_date` varchar(250) NOT NULL,
  `op_price` decimal(9,2) NOT NULL,
  `op_description` text NOT NULL,
  `op_type` enum('official','unofficial') NOT NULL,
  `inc_exc_id` int(11) NOT NULL DEFAULT '0',
  `transaction_type` varchar(40) NOT NULL,
  PRIMARY KEY (`op_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: income_category
#

DROP TABLE IF EXISTS `income_category`;

CREATE TABLE `income_category` (
  `inc_id` int(11) NOT NULL AUTO_INCREMENT,
  `inc_title` varchar(255) NOT NULL,
  `inc_isActive` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`inc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `income_category` (`inc_id`, `inc_title`, `inc_isActive`) VALUES (0, 'Satış Faturası Ödemesi', 1);
INSERT INTO `income_category` (`inc_id`, `inc_title`, `inc_isActive`) VALUES (2, 'Genel ve Bilinmeyen Gelir', 1);
INSERT INTO `income_category` (`inc_id`, `inc_title`, `inc_isActive`) VALUES (4, 'Resmi Satışlar', 1);


#
# TABLE STRUCTURE FOR: incomes
#

DROP TABLE IF EXISTS `incomes`;

CREATE TABLE `incomes` (
  `op_id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_id` int(11) NOT NULL DEFAULT '0',
  `acc_id` int(11) NOT NULL,
  `op_date` varchar(250) NOT NULL,
  `op_price` decimal(9,2) NOT NULL,
  `op_description` text NOT NULL,
  `op_type` enum('official','unofficial') NOT NULL,
  `inc_id` int(11) NOT NULL,
  `inv_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`op_id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO `incomes` (`op_id`, `cus_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `inc_id`, `inv_id`) VALUES (27, 0, 1, '2021/03/07', '500000.00', 'Hesap düzenleme', 'official', 2, 0);
INSERT INTO `incomes` (`op_id`, `cus_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `inc_id`, `inv_id`) VALUES (29, 1, 2, '2021/03/14', '75000.00', 'Fatura 1. ödemesi', 'official', 0, 11);
INSERT INTO `incomes` (`op_id`, `cus_id`, `acc_id`, `op_date`, `op_price`, `op_description`, `op_type`, `inc_id`, `inv_id`) VALUES (31, 0, 3, '2021/03/21', '250000.00', 'Gayrimenkul satışı', 'official', 4, 0);


#
# TABLE STRUCTURE FOR: invoice_payments
#

DROP TABLE IF EXISTS `invoice_payments`;

CREATE TABLE `invoice_payments` (
  `inv_pay_id` int(11) NOT NULL AUTO_INCREMENT,
  `inv_id` int(11) NOT NULL,
  `acc_id` int(11) NOT NULL,
  `inv_pay_amount` decimal(9,2) NOT NULL,
  `inv_pay_description` text NOT NULL,
  `inv_pay_date` varchar(40) NOT NULL,
  PRIMARY KEY (`inv_pay_id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `invoice_payments` (`inv_pay_id`, `inv_id`, `acc_id`, `inv_pay_amount`, `inv_pay_description`, `inv_pay_date`) VALUES (10, 11, 2, '75000.00', 'Fatura 1. ödemesi', '2021/03/14');


#
# TABLE STRUCTURE FOR: invoices
#

DROP TABLE IF EXISTS `invoices`;

CREATE TABLE `invoices` (
  `inv_id` int(11) NOT NULL AUTO_INCREMENT,
  `inv_number` varchar(40) NOT NULL,
  `inv_cre_date` varchar(40) NOT NULL,
  `inv_items` text NOT NULL,
  `inv_description` text NOT NULL,
  `inv_total` decimal(9,2) NOT NULL,
  `cus_id` int(11) NOT NULL,
  PRIMARY KEY (`inv_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO `invoices` (`inv_id`, `inv_number`, `inv_cre_date`, `inv_items`, `inv_description`, `inv_total`, `cus_id`) VALUES (11, 'INV0001', '2021/03/01', '[{\"sr_code\":\"SR0001\",\"sr_id\":\"3\",\"sr_unit\":\"m2\",\"sr_qnt\":\"2500\",\"sr_amount\":\"21.19\",\"sr_price\":\"3.81\",\"sr_tax\":\"9525\"},{\"sr_code\":\"SR0002\",\"sr_id\":\"4\",\"sr_unit\":\"Kg\",\"sr_qnt\":\"2500\",\"sr_amount\":\"12.71\",\"sr_price\":\"2.29\",\"sr_tax\":\"5725\"},{\"sr_code\":\"SR0003\",\"sr_id\":\"5\",\"sr_unit\":\"Komple\",\"sr_qnt\":\"1\",\"sr_amount\":\"847457.63\",\"sr_price\":\"152542.37\",\"sr_tax\":\"152542.37\"}]', 'Tire İnşaat 01.05.2020 tarihli yapılan anlaşmaya istinaden kesilen fatura', '1100000.00', 1);


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `folder_name` varchar(255) NOT NULL,
  `code` varchar(40) NOT NULL,
  `isActive` tinyint(4) NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `languages` (`id`, `title`, `folder_name`, `code`, `isActive`, `createdAt`) VALUES (1, 'Türkçe', 'turkish', 'tr', 1, '2021-01-03 14:41:19');
INSERT INTO `languages` (`id`, `title`, `folder_name`, `code`, `isActive`, `createdAt`) VALUES (2, 'English', 'english', 'en', 1, '2021-01-03 14:41:19');


#
# TABLE STRUCTURE FOR: migrations
#

DROP TABLE IF EXISTS `migrations`;

CREATE TABLE `migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `migrations` (`version`) VALUES ('0');


#
# TABLE STRUCTURE FOR: products
#

DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `pr_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_name` varchar(255) NOT NULL,
  `pr_price` decimal(9,2) NOT NULL,
  `pr_amount` decimal(9,2) NOT NULL,
  `pr_description` text NOT NULL,
  `pr_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `pr_tax` int(11) NOT NULL,
  `pr_code` varchar(50) NOT NULL,
  `pr_unit` varchar(50) NOT NULL,
  PRIMARY KEY (`pr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `products` (`pr_id`, `pr_name`, `pr_price`, `pr_amount`, `pr_description`, `pr_isActive`, `pr_tax`, `pr_code`, `pr_unit`) VALUES (1, 'Bisiklet', '76.27', '423.73', 'Bisiklettir bu ürün', 1, 18, 'PR0001', 'Ad');
INSERT INTO `products` (`pr_id`, `pr_name`, `pr_price`, `pr_amount`, `pr_description`, `pr_isActive`, `pr_tax`, `pr_code`, `pr_unit`) VALUES (2, 'iPhone 8', '381.36', '2118.64', 'iPhone 8', 1, 18, 'PR0002', 'Ad');


#
# TABLE STRUCTURE FOR: services
#

DROP TABLE IF EXISTS `services`;

CREATE TABLE `services` (
  `sr_id` int(11) NOT NULL AUTO_INCREMENT,
  `sr_name` varchar(255) NOT NULL,
  `sr_price` double(9,2) NOT NULL,
  `sr_amount` double(9,2) NOT NULL,
  `sr_description` text NOT NULL,
  `sr_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `sr_tax` int(11) NOT NULL,
  `sr_code` varchar(50) NOT NULL,
  `sr_unit` varchar(50) NOT NULL,
  PRIMARY KEY (`sr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `services` (`sr_id`, `sr_name`, `sr_price`, `sr_amount`, `sr_description`, `sr_isActive`, `sr_tax`, `sr_code`, `sr_unit`) VALUES (5, 'Anahtar Teslim 2 Katlı Villa Yapım İşi', '152542.37', '847457.63', 'İki katlı villa anahtar teslim birim fiyatıdır', 1, 18, 'SR0003', 'Komple');
INSERT INTO `services` (`sr_id`, `sr_name`, `sr_price`, `sr_amount`, `sr_description`, `sr_isActive`, `sr_tax`, `sr_code`, `sr_unit`) VALUES (4, 'Demir İşçiliği', '2.29', '12.71', 'Bir kg demir işçiliği için belirlenen birim fiyattır. (Demir hariç)', 1, 18, 'SR0002', 'Kg');
INSERT INTO `services` (`sr_id`, `sr_name`, `sr_price`, `sr_amount`, `sr_description`, `sr_isActive`, `sr_tax`, `sr_code`, `sr_unit`) VALUES (3, 'Alçıpan Duvar Kaplama (Taşıyıcı sistem dahil)', '3.81', '21.19', 'Bir metrekare alçıpan duvar kaplama sistemi için belirlenen birim fiyattır.', 1, 18, 'SR0001', 'm2');


#
# TABLE STRUCTURE FOR: settings
#

DROP TABLE IF EXISTS `settings`;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logo` varchar(255) COLLATE utf8_turkish_ci NOT NULL,
  `favicon` varchar(255) COLLATE utf8_turkish_ci NOT NULL,
  `cover` varchar(255) COLLATE utf8_turkish_ci NOT NULL,
  `about_img` varchar(255) COLLATE utf8_turkish_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_turkish_ci;

INSERT INTO `settings` (`id`, `logo`, `favicon`, `cover`, `about_img`) VALUES (1, '72051settings.png', '32368settings_view1.png', '39234settings_view.jpg', '63628settings_view.png');


#
# TABLE STRUCTURE FOR: suppliers
#

DROP TABLE IF EXISTS `suppliers`;

CREATE TABLE `suppliers` (
  `sup_id` int(11) NOT NULL AUTO_INCREMENT,
  `sup_name` varchar(255) NOT NULL,
  `sup_owner` varchar(255) NOT NULL,
  `sup_owner_phone` varchar(40) NOT NULL,
  `sup_phone` varchar(40) NOT NULL,
  `sup_fax` varchar(40) NOT NULL,
  `sup_gsm` varchar(40) NOT NULL,
  `sup_email` varchar(255) NOT NULL,
  `sup_address` text NOT NULL,
  `sup_tax_office` varchar(255) NOT NULL,
  `sup_tax_number` varchar(20) NOT NULL,
  `sup_isActive` tinyint(4) NOT NULL DEFAULT '1',
  `sup_info` longtext NOT NULL,
  `sup_logo` varchar(255) DEFAULT NULL,
  `sup_debit` decimal(9,2) NOT NULL,
  `sup_credit` decimal(9,2) NOT NULL,
  PRIMARY KEY (`sup_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `suppliers` (`sup_id`, `sup_name`, `sup_owner`, `sup_owner_phone`, `sup_phone`, `sup_fax`, `sup_gsm`, `sup_email`, `sup_address`, `sup_tax_office`, `sup_tax_number`, `sup_isActive`, `sup_info`, `sup_logo`, `sup_debit`, `sup_credit`) VALUES (1, 'Samtek Store', 'Samtek Store', '(555) 555-5555', '(535) 353-5656', '', '', 'info@samtek.com', 'Adrestir', 'Gökalp', '', 1, '<p>Not ve anlaşmalardır</p>\r\n', '35864suppliers.png', '0.00', '350000.00');


#
# TABLE STRUCTURE FOR: transfer
#

DROP TABLE IF EXISTS `transfer`;

CREATE TABLE `transfer` (
  `t_id` int(11) NOT NULL AUTO_INCREMENT,
  `t_giver_id` int(11) NOT NULL,
  `t_receiver_id` int(11) NOT NULL,
  `t_date` varchar(255) NOT NULL,
  `t_price` decimal(9,2) NOT NULL,
  PRIMARY KEY (`t_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) COLLATE utf8_turkish_ci NOT NULL,
  `img_url` varchar(255) COLLATE utf8_turkish_ci NOT NULL,
  `full_name` varchar(50) COLLATE utf8_turkish_ci NOT NULL,
  `user_type` varchar(50) COLLATE utf8_turkish_ci NOT NULL,
  `email` varchar(50) COLLATE utf8_turkish_ci NOT NULL,
  `password` varchar(100) COLLATE utf8_turkish_ci NOT NULL,
  `permissions` text COLLATE utf8_turkish_ci,
  `log_time` varchar(20) COLLATE utf8_turkish_ci NOT NULL,
  `isActive` tinyint(4) NOT NULL DEFAULT '1',
  `isOnline` tinyint(4) NOT NULL,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_turkish_ci;

INSERT INTO `users` (`id`, `user_name`, `img_url`, `full_name`, `user_type`, `email`, `password`, `permissions`, `log_time`, `isActive`, `isOnline`, `createdAt`) VALUES (1, 'superadmin', '99331users.png', 'Super Admin', 'superadmin', 'afsakarr@gmail.com', '17c4520f6cfd1ab53d8745e84681eb49', '{\"\\/\":{\"show\":\"1\"},\"calendar\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"users\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"settings\":{\"show\":\"1\",\"edit\":\"1\"},\"email_settings\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"email_templates\":{\"show\":\"1\",\"edit\":\"1\"},\"languages\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"services\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"products\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"customers\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\",\"activities\":\"1\"},\"suppliers\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\",\"activities\":\"1\"},\"accounts\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"account_types\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"incomes\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"income_category\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"expenses\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"expense_category\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"invoices\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"bills\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"},\"forward_transactions\":{\"show\":\"1\",\"edit\":\"1\",\"add\":\"1\",\"delete\":\"1\"}}', '1616316407', 1, 1, '2020-12-10 19:28:56');
INSERT INTO `users` (`id`, `user_name`, `img_url`, `full_name`, `user_type`, `email`, `password`, `permissions`, `log_time`, `isActive`, `isOnline`, `createdAt`) VALUES (2, 'admin', '25013users_view.png', 'Admin', 'admin', 'rank-wc@hotmail.com', '0192023a7bbd73250516f069df18b500', '{\"\\/\":{\"show\":\"1\"},\"calendar\":{\"show\":\"1\"},\"users\":{\"show\":\"1\"},\"settings\":{\"show\":\"1\"},\"email_settings\":{\"show\":\"1\"},\"email_templates\":{\"show\":\"1\"},\"languages\":{\"show\":\"1\"},\"services\":{\"show\":\"1\"},\"products\":{\"show\":\"1\"},\"customers\":{\"show\":\"1\"},\"suppliers\":{\"show\":\"1\"},\"accounts\":{\"show\":\"1\"},\"account_types\":{\"show\":\"1\"},\"incomes\":{\"show\":\"1\"},\"income_category\":{\"show\":\"1\"},\"expenses\":{\"show\":\"1\"},\"expense_category\":{\"show\":\"1\"},\"invoices\":{\"show\":\"1\"},\"bills\":{\"show\":\"1\"},\"forward_transactions\":{\"show\":\"1\"}}', '0', 1, 0, '2020-12-10 22:59:41');


