import { cn } from '@/lib/utils'
import { computed, Directive, input } from '@angular/core'
import { RdxToggleDirective } from '@radix-ng/primitives/toggle'
import { cva, type VariantProps } from 'class-variance-authority'

const toggleVariants = cva(
  'inline-flex items-center justify-center rounded-md text-sm font-medium ring-offset-background transition-colors hover:bg-muted hover:text-muted-foreground focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 data-[state=on]:bg-accent data-[state=on]:text-accent-foreground [&_svg]:pointer-events-none [&_svg]:size-4 [&_svg]:shrink-0 gap-2',
  {
    variants: {
      variant: {
        default: 'bg-transparent',
        outline:
          'border border-input bg-transparent hover:bg-accent hover:text-accent-foreground',
      },
      size: {
        default: 'h-10 px-3 min-w-10',
        sm: 'h-9 px-2.5 min-w-9',
        lg: 'h-11 px-5 min-w-11',
      },
    },
    defaultVariants: {
      variant: 'default',
      size: 'default',
    },
  },
)

@Directive({
  standalone: true,
  selector: 'button[ubToggle]',
  host: {
    '[class]': 'computedClass()',
  },
  hostDirectives: [RdxToggleDirective],
})
export class UbToggleDirective {
  variant = input<VariantProps<typeof toggleVariants>['variant']>()
  size = input<VariantProps<typeof toggleVariants>['size']>()
  class = input<string>()
  computedClass = computed(() => cn(
    toggleVariants({
      variant: this.variant(),
      size: this.size(),
      className: this.class(),
    }),
  ))
}
