using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Text;
using System.Threading.Tasks;
using VirusTotalNET;
using VirusTotalNET.ResponseCodes;
using VirusTotalNET.Results;
using System.IO;
using VirusTotalNET.Objects;
using System.Configuration;

public class VirusTotalEngine
{
    static string vtKey = ConfigurationManager.AppSettings["VTKey"];
    public static List<string> CheckVT(string file)
    {
        List<string> result = new List<string>();
        try
        {
            VirusTotal virusTotal = new VirusTotal(File.ReadLines(HttpContext.Current.Server.MapPath(vtKey)).First());

            virusTotal.UseTLS = true;

            byte[] filetobyte = File.ReadAllBytes(file);

            FileReport fileReport = Task.Run(async () => await virusTotal.GetFileReportAsync(filetobyte)).Result;

            bool hasFileBeenScannedBefore = fileReport.ResponseCode == FileReportResponseCode.Present;

            FileInfo vtfile = new FileInfo(file);

            if (hasFileBeenScannedBefore)
            {

                if (fileReport.ResponseCode == FileReportResponseCode.Present)
                {

                    foreach (KeyValuePair<string, ScanEngine> scan in fileReport.Scans)
                    {
                        StringBuilder scanString = new StringBuilder();
                        scanString.Append(scan.Key);
                        scanString.Append("*");
                        scanString.Append(scan.Value.Detected.ToString());
                        scanString.Append("*");
                        scanString.Append(scan.Value.Result);


                        result.Add(scanString.ToString());

                    }

                }

            }
            else
            {
                result.Add("Unknown.");
            }
        }
        catch
        {
            result.Add("Error.");
        }
        return result;
    }

}

