﻿using System;
using System.IO;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;

namespace MalwareDoctor_Online_Scanner
{
    public class Util
    {
        public static string GetMD5(string filename)
        {
            string errorMsg = "error";

            try
            {
                using (FileStream fStream = File.OpenRead(filename))
                {
                    return GetHash<MD5>(fStream);
                }

            }
            catch { }

            return errorMsg;

        }
        public static string GetHash<T>(Stream stream) where T : HashAlgorithm
        {
            StringBuilder sb = new StringBuilder();

            MethodInfo create = typeof(T).GetMethod("Create", new Type[] { });
            using (T crypt = (T)create.Invoke(null, null))
            {
                byte[] hashBytes = crypt.ComputeHash(stream);
                foreach (byte bt in hashBytes)
                {
                    sb.Append(bt.ToString("x2"));
                }
            }
            return sb.ToString();
        }
    }
}