using MalwareDoctor_Online_Scanner;
using System;
using System.Configuration;
using System.IO;
using System.Web.UI.WebControls;

public partial class Home : System.Web.UI.Page
{
    string uploadPath = ConfigurationManager.AppSettings["UploadPath"];
    protected void Page_Load(object sender, EventArgs e)
    {
        lblBrowse.Text = "Browse a file to scan it. We delete files after analysis.";
        btnScan.Text = "Scan";
        lblVT.Visible = false;
        lblVX.Visible = false;
        linkVXres.Visible = false;
        lblResults.Visible = false;
        btnDetails.Visible = false;
        lbtnNewScan.Visible = false;
        pageBody.Attributes.Add("bgcolor", "#C2C2C2");
    }


    public void UnhideControls()
    {
        lblVT.Visible = true;
        lblVX.Visible = true;
        linkVXres.Visible = true;
        lblResults.Visible = true;
        btnDetails.Visible = true;
        lbtnNewScan.Visible = true;
        btnScan.Visible = false;
        lblBrowse.Visible = false;
        FileUpload.Visible = false;
    }
    

    public void MakeTableHeaderVisible()
    {
        TableHeaderCell headerTableCellEngine = new TableHeaderCell();
        TableHeaderCell headerTableCellVerdict = new TableHeaderCell();
        TableHeaderCell headerTableCellDetection = new TableHeaderCell();

        headerTableCellEngine.Text = "Engine";
        headerTableCellVerdict.Text = "Verdict";
        headerTableCellDetection.Text = "Detection";

        TableHeaderRow headerRow = new TableHeaderRow();
        headerRow.Cells.Add(headerTableCellEngine);
        headerRow.Cells.Add(headerTableCellVerdict);
        headerRow.Cells.Add(headerTableCellDetection);
        TableVT.Rows.Add(headerRow);
    }

    protected void btnScan_Click(object sender, EventArgs e)
    {
        if (FileUpload.HasFile)
        {
            try
            {
                //string filename = Path.GetFileName(FileUpload.FileName);
                string tempFilename = Path.GetFileName(FileUpload.FileName);
                string filename = Path.GetRandomFileName();

                FileUpload.SaveAs(Server.MapPath(uploadPath) + filename);

                FileManager mgr = new FileManager(Server.MapPath(uploadPath) + filename);

                //start vt
                

                if (mgr.VT[0].Contains("Unknown"))
                {

                    lblVT.Text += "Unknown. The file is most likely new, and currently being analyzed.";

                }
                else if (mgr.VT[0].Contains("Error"))
                {
                    lblVT.Text += "Error. Most likely bad API key or public API key limitation.";
                }
                else
                {

                    int engineCount = 0;
                    int detectionCount = 0;


                    MakeTableHeaderVisible();
                    foreach (string line in mgr.VT)
                    {
                        if (String.IsNullOrEmpty(line) == false)
                        {
                            engineCount = engineCount + 1;
                        }
                        if (line.Contains("True") == true)
                        {
                            detectionCount = detectionCount + 1;
                        }

                        string[] detectionInfo;
                        detectionInfo = line.Split(new char[] { '*' });


                        var cellEngine = new TableCell();
                        var cellVerdict = new TableCell();
                        var cellDetection = new TableCell();
                        var row = new TableRow();
                        cellEngine.Text = detectionInfo[0];

                        if (detectionInfo[1] == "True")
                        {
                            cellVerdict.Text = "Infected";
                        }
                        else if (detectionInfo[1] == "False")
                        {
                            cellVerdict.Text = "Clean";
                        }

                        cellDetection.Text = detectionInfo[2];
                        row.Cells.Add(cellEngine);
                        row.Cells.Add(cellVerdict);
                        row.Cells.Add(cellDetection);

                        TableVT.Rows.Add(row);
                    }


                    lblVT.Text = lblVT.Text + detectionCount.ToString() + "/" + engineCount.ToString();

                }
                //end vt


                if (mgr.VXVaultDB.Contains("Not present"))
                {
                    linkVXres.NavigateUrl = String.Empty;
                    linkVXres.Target = String.Empty;
                    linkVXres.Text = mgr.VXVaultDB;
                }
                else
                {
                    linkVXres.NavigateUrl = mgr.VXVaultDB;
                    linkVXres.Target = "_blank";
                    linkVXres.Text = "Present in DB, click for details!";
                }

                lblResults.Text = "Results for " + tempFilename + " (MD5:" + mgr.MD5 + ")";


                UnhideControls();
                if (lblVT.Text.Contains("Unknown")|| lblVT.Text.Contains("Error"))
                {

                    btnDetails.Visible = false;

                }

                File.Delete(Server.MapPath(uploadPath) + filename);

            }
            catch (Exception ex)
            {
                lblResults.Text = ex.Message;
            }
        }
    }
}
