using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;

namespace MalwareDoctor_Online_Scanner
{
    public class FileManager
    {
        private string filename = String.Empty;

        public FileManager(string filename)
        {
            this.filename = filename;
        }

        public List<string> VT
        {
            get
            {
                return VirusTotalEngine.CheckVT(filename);
            }
        }

        public string VXVaultDB
        {
            get
            {
                return VXVault.CheckVXVault(filename);
            }
        }

        public string MD5
        {
            get
            {
                return Util.GetMD5(filename);
            }
        }

    }
}
