## 进程调度算法
### FCFS(first-come first-served)
FCFS是最简单的调度算法，该算法既可用于**作业调度**，也可用于**进程调度**。
当在作业调度中采用该算法时，系统将按照作业到达的先后次序来进行调度，或者说它是优先考虑在系统中等待时间最长的作业，而不管该作业所需执行的时间的长短，从后备作业队列中选择几个最先进入该队列的作业，将它们调入内存，为它们分配资源和创建进程。
然后把它放入就绪队列。

FCFS调度算法属于不可剥夺算法。
从表面上看，它对所有作业都是公平的，但若一个长作业先到达系统，就会使后面的许多短作业等待很长时间，因此它不能作为分时系统和实时系统的主要调度策略。
但它常被结合在其他调度策略中使用。例如，在使用优先级作为调度策略的系统中，往往对多个具有相同优先级的进程按FCFS原则处理。

FCFS调度算法的特点是算法简单，但效率低；对长作业比较有利，但对短作业不利(相对SJF和高响应比)；有利于CPU繁忙型作业，而不利于IO繁忙型作业。

### SJF/ SPF Shortest Job/Process First
短作业(进程)优先调度算法是指对短作业(进程)优先调度的算法。
短作业优先(SJF)调度算法从后备队列中选择一个或若干估计运行时间最短的作业，将它们调入内存运行；
短进程优先(SPF)调度算法从就绪队列中选择一个估计运行时间最短的进程，将处理机分配给它，使之立即执行，直到完成或发生某事件而阻塞时，才释放处理机。
> SJF 调度算法的平均等待时间、平均周转时间最少。

### 优先级调度算法
优先级调度算法又称优先权调度算法，它既可用于作业调度，又可用于进程调度。该算法中的优先级**用于描述作业运行的紧迫程度**。
优先级调度算法每次从就绪队列中选择优先级最高的进程，将处理机分配给它，使之投入运行。


### HRRN 高响应比优先（Highest Response Ratio Next）

高响应比优先调度算法主要用于作业调度，是对FCFS调度算法和SJF调度算法的一种综合平衡，
同时考虑了每个作业的等待时间和估计的运行时间。在每次进行作业调度时，先计算后备作业队列中每个作业的响应比，从中选出响应比最高的作业投入运行

*优先权=(等待时间 + 要求服务时间)/要求服务时间*

### 多级反馈队列调度算法（Multi-Level Feedback Queue）

多级反馈队列调度算法是一种常用的进程调度算法，基于时间片轮转算法和多级反馈队列算法。

它使用多个队列来管理进程，并为每个队列分配不同大小的时间片。

进程首先被放入第一级队列，如果在运行期间消耗完了它的时间片，那么它就会被移到下一级队列中，直到所有的队列都运行完毕。

该算法的主要特点是，允许进程在不同级别的队列之间移动，并**使具有高优先级的进程尽快得到处理**，**从而避免低优先级进程永远得不到处理的情况**。

当一个进程进入队列时，它被赋予一个初始优先级，根据进程的行为和系统的需求，优先级可以上升或下降。例如，如果一个进程在第一级队列运行了一段时间，在使用完指定时间片后仍然没有完成它的任务，那么它将被重新插入到第二级队列中。

> 多级反馈队列轮转算法是一种高效的进程调度算法，可以使具有高优先级的进程尽快得到处理，同时避免低优先级进程永远得不到处理的情况。它的实现需要维护多个队列和时间片大小，以及每个进程已经运行的时间和优先级等信息。

---
### 参考
- https://blog.csdn.net/qq_43511405/article/details/109089439
- https://zhuanlan.zhihu.com/p/585138200
- https://blog.csdn.net/weixin_46013401/article/details/110819774