package com.os.dynamicmatching.sample;

import com.os.dynamicmatching.algorithms.BF;
import com.os.dynamicmatching.util.RandomTestUtil;

import java.util.List;

/**
 * @author adorabled4
 * @className BFExample
 * @date : 2023-5-15 12:40:03
 **/
public class BFExample {

    public static void main(String[] args) {
        testBF(500, 10);
    }

    /**
     * 测试 动态分区匹配算法  仅仅测试当前算法的执行方式以及内容
     *
     * @param cap         frame容量
     * @param processSize 进程的个数
     */
    static void testBF(int cap, int processSize) {
        List<Long> timeCounts = RandomTestUtil.testDynamicMatching(cap, processSize, BF.class);
        long timeCount = 0;
        for (Long count : timeCounts) {
            timeCount += count;
        }
        System.out.println("\u001B[31m\u001B[1m[测试结束]\u001B[0m 分配总耗时: " + timeCount + "(ns)");
    }

        /*
    下面是一组测试结果
    2023-05--15 01:15:55 [ADD]添加进程: 1001 驻留时间: 3(s) 需要Frame: 10
    2023-05--15 01:15:55 当前空闲分区情况:
        [Partition] #: 1:Size: 500, Range: [0, 499]
    2023-05--15 01:15:55 [ALLOCATE]为进程1001分配, 大小: 10  起始frame: 0 本次分配耗时 : 23018(ns)
    2023-05--15 01:15:57 [ADD]添加进程: 1002 驻留时间: 10(s) 需要Frame: 150
    2023-05--15 01:15:57 当前空闲分区情况:
        [Partition] #: 1:Size: 490, Range: [10, 499]
    2023-05--15 01:15:57 [ALLOCATE]为进程1002分配, 大小: 150  起始frame: 10 本次分配耗时 : 427(ns)
    2023-05--15 01:15:58 [GC]回收进程 1001 ,大小: 10
    2023-05--15 01:15:59 [ADD]添加进程: 1003 驻留时间: 5(s) 需要Frame: 10
    2023-05--15 01:15:59 当前空闲分区情况:
        [Partition] #: 1:Size: 10, Range: [0, 9]
        [Partition] #: 2:Size: 340, Range: [160, 499]
    2023-05--15 01:15:59 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:00 当前空闲分区情况:
        [Partition] #: 1:Size: 10, Range: [0, 9]
        [Partition] #: 2:Size: 340, Range: [160, 499]
    2023-05--15 01:16:00 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:01 [ADD]添加进程: 1004 驻留时间: 2(s) 需要Frame: 160
    2023-05--15 01:16:01 [FAILED]添加进程到阻塞队列: 1004
    2023-05--15 01:16:01 当前空闲分区情况:
        [Partition] #: 1:Size: 10, Range: [0, 9]
        [Partition] #: 2:Size: 340, Range: [160, 499]
    2023-05--15 01:16:01 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:02 [FAILED]添加进程到阻塞队列: 1004
    2023-05--15 01:16:03 [ADD]添加进程: 1005 驻留时间: 6(s) 需要Frame: 140
    2023-05--15 01:16:03 [FAILED]添加进程到阻塞队列: 1005
    2023-05--15 01:16:03 当前空闲分区情况:
        [Partition] #: 1:Size: 10, Range: [0, 9]
        [Partition] #: 2:Size: 340, Range: [160, 499]
    2023-05--15 01:16:03 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:04 [FAILED]添加进程到阻塞队列: 1004
    2023-05--15 01:16:05 [ADD]添加进程: 1006 驻留时间: 6(s) 需要Frame: 190
    2023-05--15 01:16:05 [FAILED]添加进程到阻塞队列: 1006
    2023-05--15 01:16:05 [FAILED]添加进程到阻塞队列: 1005
    2023-05--15 01:16:06 当前空闲分区情况:
        [Partition] #: 1:Size: 10, Range: [0, 9]
        [Partition] #: 2:Size: 340, Range: [160, 499]
    2023-05--15 01:16:06 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:07 [GC]回收进程 1002 ,大小: 150
    2023-05--15 01:16:07 [ADD]添加进程: 1007 驻留时间: 7(s) 需要Frame: 140
    2023-05--15 01:16:07 当前空闲分区情况:
        [Partition] #: 1:Size: 500, Range: [0, 499]
    2023-05--15 01:16:07 [ALLOCATE]为进程1007分配, 大小: 140  起始frame: 0 本次分配耗时 : 561(ns)
    2023-05--15 01:16:07 当前空闲分区情况:
        [Partition] #: 1:Size: 360, Range: [140, 499]
    2023-05--15 01:16:07 [ALLOCATE]为进程1004分配, 大小: 160  起始frame: 140 本次分配耗时 : 533(ns)
    2023-05--15 01:16:08 当前空闲分区情况:
        [Partition] #: 1:Size: 200, Range: [300, 499]
    2023-05--15 01:16:08 [ALLOCATE]为进程1006分配, 大小: 190  起始frame: 300 本次分配耗时 : 643(ns)
    2023-05--15 01:16:09 [ADD]添加进程: 1008 驻留时间: 6(s) 需要Frame: 60
    2023-05--15 01:16:09 [FAILED]添加进程到阻塞队列: 1008
    2023-05--15 01:16:09 [GC]回收进程 1004 ,大小: 160
    2023-05--15 01:16:09 当前空闲分区情况:
        [Partition] #: 1:Size: 160, Range: [140, 299]
        [Partition] #: 2:Size: 10, Range: [490, 499]
    2023-05--15 01:16:09 [ALLOCATE]为进程1005分配, 大小: 140  起始frame: 140 本次分配耗时 : 522(ns)
    2023-05--15 01:16:10 当前空闲分区情况:
        [Partition] #: 1:Size: 20, Range: [280, 299]
        [Partition] #: 2:Size: 10, Range: [490, 499]
    2023-05--15 01:16:10 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:11 [ADD]添加进程: 1009 驻留时间: 2(s) 需要Frame: 90
    2023-05--15 01:16:11 [FAILED]添加进程到阻塞队列: 1009
    2023-05--15 01:16:11 [FAILED]添加进程到阻塞队列: 1008
    2023-05--15 01:16:12 当前空闲分区情况:
        [Partition] #: 1:Size: 20, Range: [280, 299]
        [Partition] #: 2:Size: 10, Range: [490, 499]
    2023-05--15 01:16:12 [FAILED]添加进程到阻塞队列: 1003
    2023-05--15 01:16:13 [ADD]添加进程: 1010 驻留时间: 2(s) 需要Frame: 20
    2023-05--15 01:16:13 当前空闲分区情况:
        [Partition] #: 1:Size: 20, Range: [280, 299]
        [Partition] #: 2:Size: 10, Range: [490, 499]
    2023-05--15 01:16:13 [ALLOCATE]为进程1010分配, 大小: 20  起始frame: 280 本次分配耗时 : 483(ns)
    2023-05--15 01:16:13 [FAILED]添加进程到阻塞队列: 1009
    2023-05--15 01:16:14 [GC]回收进程 1007 ,大小: 140
    2023-05--15 01:16:14 [GC]回收进程 1006 ,大小: 190
    2023-05--15 01:16:14 当前空闲分区情况:
        [Partition] #: 1:Size: 140, Range: [0, 139]
        [Partition] #: 2:Size: 200, Range: [300, 499]
    2023-05--15 01:16:14 [FAILED]添加进程到阻塞队列: 1008
    2023-05--15 01:16:15 [GC]回收进程 1010 ,大小: 20
    2023-05--15 01:16:15 [GC]回收进程 1005 ,大小: 140
    2023-05--15 01:16:15 当前空闲分区情况:
        [Partition] #: 1:Size: 500, Range: [0, 499]
    2023-05--15 01:16:15 [ALLOCATE]为进程1003分配, 大小: 10  起始frame: 0 本次分配耗时 : 490(ns)
    2023-05--15 01:16:16 当前空闲分区情况:
        [Partition] #: 1:Size: 490, Range: [10, 499]
    2023-05--15 01:16:16 [ALLOCATE]为进程1009分配, 大小: 90  起始frame: 10 本次分配耗时 : 722(ns)
    2023-05--15 01:16:17 当前空闲分区情况:
        [Partition] #: 1:Size: 400, Range: [100, 499]
    2023-05--15 01:16:17 [ALLOCATE]为进程1008分配, 大小: 60  起始frame: 100 本次分配耗时 : 640(ns)
    [测试结束] 分配总耗时: 24489(ns)
    2023-05--15 01:16:18 [GC]回收进程 1009 ,大小: 90
    2023-05--15 01:16:20 [GC]回收进程 1003 ,大小: 10
    2023-05--15 01:16:23 [GC]回收进程 1008 ,大小: 60
     */
}
