# Implementation of os classical algorithm

os经典算法实现

## 项目结构说明

下面以测试目录的页面置换算法为例 , 说明本项目的结构

```
└─页面置换算法(测试)
    ├─golang
    │  ├─.idea
    │  └─lru
    ├─Java
    │  └─com
    │      └─dhx
    │          ├─algorithms
    │          │  └─lru
    │          └─sample
    └─Python
        └─mx
            ├─algorithm
            └─sample
```

第一级目录为某方面算法的名称 , 比如置换算法、调度算法等。

第二级目录为某方面算法的**具体语言实现** ，例如页面置换算法(测试)

```

└─页面置换算法(测试)
    ├─golang
    ├─Java
    └─Python
```

第三级目录一般就是对应编程语言的实现代码，其中**algorithms**目录存放的为算法实现，
**sample**目录(或者是文件)存放的为操作示例

## 贡献

> 如果您在浏览本仓库的过程中发现了什么问题，欢迎您提出issue，我们欢迎所有人来为我们的项目做出贡献。
> - 指出问题并不一定是代码方面，可以是任何方面的问题，即使是文档中有一个错别字或者是格式有什么问题，
>  如果您能够帮助我们**指出问题**或者是提出pull request,我们也会热烈的欢迎!
> - 如果您想要向本项目进行pull request，请您务必预先浏览**贡献流程**

### 代码规范

#### Java

1. **命名**: 标识符的命名力求做到统一、达意和简洁，Java请使用驼峰法命名
2. **格式**: 请确保您的代码每个缩进为4个空格，源文件使用**utf-8**编码，行宽不要超过120。
3. **注释**: 请确保您的类、域和方法上面有相应的 Java Doc , 单行注释使用`//` 多行时用`/* ..*/`，较短的代码块用空行表示注释作用域，较长的代码块要用`/*------ start: ------*/`和`/*-------- end: -------*/`包围，可以考虑使用大括号来表示注释范围。

> Java编程规范（第三版）百度云下载（.pdf）：https://pan.baidu.com/s/1Di5VN-FfFPate-_fBNiXqA

### 贡献流程

理想的**贡献工作流程**概述如下：

1. fork当前代码仓库
2. 克隆项目仓库到本地
3. 更新本地分支代码，需要确认本地分支的代码是新的
4. 开始您的代码，请确保您的代码满足基本的代码规范，如变量名、排版以及必要的注释等
5. commit 和 push，请确保您的commit message 满足规范，详见https://www.conventionalcommits.org/zh-hans/v1.0.0/
6. pull reqeust，在pull request之前请将您的分支仓库与远程仓库同步，以确保您的 PR 优雅、简洁

## 注意事项

### 运行golang代码

如果您需要直接运行golang代码，请将工作目录切换为golang文件夹，以确保代码可以正确被编译器识别

```
└─页面置换算法(测试)
    ├─golang
```

![示意图](http://oss.dhx.icu/dhx/image-20230329122912749.png)

### 运行C++代码

如果您需要运行C++代码，请将工作目录切换为C++文件夹，以确保代码可以正确被编译器识别

如果使用的是CLion，请保持版本在`2023.1`以上或最新，低版本可能无法支持单文件编译

若无法使用最新版CLion，则在`2020.3`之后同样可以通过安装 C/C++ Single File Execution插件
然后在需要运行的代码中右键，点击Add executable for single c/cpp file。
这样，CLion会在CMakeLists.txt文件中添加相应的代码，并在右上角显示运行按钮。
建议使用最新版，较为方便无需配置CMake，只需要点击`main()`左侧的绿色运行按钮即可运行
![](http://oss.dhx.icu/dhx/img.png)

如果使用的是VS code，可以通过安装相关插件来运行，或者通过terminal使用`gcc/g++`运行相关文件
