# Downloading Source Han &amp; Noto CJK Mega/Ultra OTCs

The Adobe-branded *Source Han Sans*, *Source Han Serif*, and *Source Han Mono*, along with the Google-branded *Noto Sans CJK* and *Noto Serif CJK*, are open source Pan-CJK typefaces whose OpenType/CFF fonts and CID-based sources are covered under the terms of the [SIL Open Font License, Version 1.1](http://scripts.sil.org/OFL) (also see the [LICENSE](LICENSE.md) and [FAQ](http://scripts.sil.org/cms/scripts/page.php?item_id=OFL-FAQ_web)).

In the [Latest Release](https://github.com/adobe-fonts/source-han-super-otc/releases/latest) of this project you will find three ready-to-install OpenType/CFF Collections&mdash;two Mega OTCs and one Ultra OTC&mdash;that include 73, 143, or 216 fonts, depending on which of the five typeface families are included.

The Mega and Ultra OTCs include various combinations of the 45-font [Source Han Sans Super OTC](https://github.com/adobe-fonts/source-han-sans/releases/latest/), the 28-font [Source Han Serif Super OTC](https://github.com/adobe-fonts/source-han-serif/releases/latest/), the 70-font [Source Han Mono Super OTC](https://github.com/adobe-fonts/source-han-mono/releases/latest/), and the 45- and 28-font [Noto Sans CJK and Noto Serif CJK Super OTCs](https://github.com/googlefonts/noto-cjk/). The main intent of this particular open source project is to stress-test environments that consume OpenType/CFF Collections, specifically macOS (OS X) Version 10.8 (aka *Mountain Lion*) or later, iOS 7 or later, Windows 10 Version 1703 (aka *Creators Update*) or later, flavors of Linux that use *fontconfig* and FreeType Version 2.5.0.1 or greater, and Adobe CS6 apps or later.

The [COMMANDS.txt](COMMANDS.txt) file provides the command lines that were used to build these Mega OTCs and Ultra OTC. Only the [AFDKO](https://github.com/adobe-type-tools/afdko/) *sfntedit* and *otf2otc* tools are required.

## Mega OTCs

### Source Han&mdash;SourceHan.ttc

This Mega OTC includes all 143 fonts from *Source Han Sans*, *Source Han Serif*, and *Source Han Mono*, is 407,879,580 bytes, and its MD5 hash is 8f12d2fff6492b917496a3718e60cd5b.

### Noto CJK&mdash;NotoCJK.ttc

This Mega OTC includes all 73 fonts from *Noto Sans CJK* and *Noto Serif CJK*, is 285,763,672 bytes, and its MD5 hash is 5fb3f42574c27390bc60347858f4bf8e.

## Ultra OTC

### Source Han + Noto CJK&mdash;SourceHanNotoCJK.ttc

The Ultra OTC includes all 216 fonts from the *Source Han* and *Noto CJK* families, is 408,083,892 bytes, and its MD5 hash is d50619f15a3c4130bc26380bfe8bca52.

## Getting Involved

For any suggestions for changes, please [create a new issue](https://github.com/adobe-fonts/source-han-super-otc/issues) for consideration.

## Further information

For information about the design and background of the Source Han typefaces, please refer to their respective repositories.
