(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("@adobe/aem-core-cif-experience-platform-connector", [], factory);
	else if(typeof exports === 'object')
		exports["@adobe/aem-core-cif-experience-platform-connector"] = factory();
	else
		root["@adobe/aem-core-cif-experience-platform-connector"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	function webpackJsonpCallback(data) {
/******/ 		var chunkIds = data[0];
/******/ 		var moreModules = data[1];
/******/
/******/
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, resolves = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(Object.prototype.hasOwnProperty.call(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 				resolves.push(installedChunks[chunkId][0]);
/******/ 			}
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			if(Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				modules[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(data);
/******/
/******/ 		while(resolves.length) {
/******/ 			resolves.shift()();
/******/ 		}
/******/
/******/ 	};
/******/
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 	// Promise = chunk loading, 0 = chunk loaded
/******/ 	var installedChunks = {
/******/ 		"main": 0
/******/ 	};
/******/
/******/
/******/
/******/ 	// script path function
/******/ 	function jsonpScriptSrc(chunkId) {
/******/ 		return __webpack_require__.p + "" + chunkId + ".index.js"
/******/ 	}
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/dist/";
/******/
/******/ 	// on error function for async loading
/******/ 	__webpack_require__.oe = function(err) { console.error(err); throw err; };
/******/
/******/ 	var jsonpArray = window["webpackJsonp_adobe_aem_core_cif_experience_platform_connector"] = window["webpackJsonp_adobe_aem_core_cif_experience_platform_connector"] || [];
/******/ 	var oldJsonpFunction = jsonpArray.push.bind(jsonpArray);
/******/ 	jsonpArray.push = webpackJsonpCallback;
/******/ 	jsonpArray = jsonpArray.slice();
/******/ 	for(var i = 0; i < jsonpArray.length; i++) webpackJsonpCallback(jsonpArray[i]);
/******/ 	var parentJsonpFunction = oldJsonpFunction;
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/@magento/experience-platform-connector/src/config.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/config.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _handlers_addToCart__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./handlers/addToCart */ "./node_modules/@magento/experience-platform-connector/src/handlers/addToCart.js");
/* harmony import */ var _handlers_categoryPageView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./handlers/categoryPageView */ "./node_modules/@magento/experience-platform-connector/src/handlers/categoryPageView.js");
/* harmony import */ var _handlers_completeCheckout__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./handlers/completeCheckout */ "./node_modules/@magento/experience-platform-connector/src/handlers/completeCheckout.js");
/* harmony import */ var _handlers_createAccount__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./handlers/createAccount */ "./node_modules/@magento/experience-platform-connector/src/handlers/createAccount.js");
/* harmony import */ var _handlers_editAccount__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./handlers/editAccount */ "./node_modules/@magento/experience-platform-connector/src/handlers/editAccount.js");
/* harmony import */ var _handlers_pageView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./handlers/pageView */ "./node_modules/@magento/experience-platform-connector/src/handlers/pageView.js");
/* harmony import */ var _handlers_placeOrder__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./handlers/placeOrder */ "./node_modules/@magento/experience-platform-connector/src/handlers/placeOrder.js");
/* harmony import */ var _handlers_productPageView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./handlers/productPageView */ "./node_modules/@magento/experience-platform-connector/src/handlers/productPageView.js");
/* harmony import */ var _handlers_searchRequestSent__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./handlers/searchRequestSent */ "./node_modules/@magento/experience-platform-connector/src/handlers/searchRequestSent.js");
/* harmony import */ var _handlers_searchResponseReceived__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./handlers/searchResponseReceived */ "./node_modules/@magento/experience-platform-connector/src/handlers/searchResponseReceived.js");
/* harmony import */ var _handlers_shoppingCartPageView__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./handlers/shoppingCartPageView */ "./node_modules/@magento/experience-platform-connector/src/handlers/shoppingCartPageView.js");
/* harmony import */ var _handlers_shoppingMiniCartView__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./handlers/shoppingMiniCartView */ "./node_modules/@magento/experience-platform-connector/src/handlers/shoppingMiniCartView.js");
/* harmony import */ var _handlers_startCheckout__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./handlers/startCheckout */ "./node_modules/@magento/experience-platform-connector/src/handlers/startCheckout.js");
/* harmony import */ var _handlers_signIn__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./handlers/signIn */ "./node_modules/@magento/experience-platform-connector/src/handlers/signIn.js");














/* harmony default export */ __webpack_exports__["default"] = ([_handlers_addToCart__WEBPACK_IMPORTED_MODULE_0__["default"], _handlers_categoryPageView__WEBPACK_IMPORTED_MODULE_1__["default"], _handlers_completeCheckout__WEBPACK_IMPORTED_MODULE_2__["default"], _handlers_createAccount__WEBPACK_IMPORTED_MODULE_3__["default"], _handlers_editAccount__WEBPACK_IMPORTED_MODULE_4__["default"], _handlers_pageView__WEBPACK_IMPORTED_MODULE_5__["default"], _handlers_placeOrder__WEBPACK_IMPORTED_MODULE_6__["default"], _handlers_productPageView__WEBPACK_IMPORTED_MODULE_7__["default"], _handlers_searchRequestSent__WEBPACK_IMPORTED_MODULE_8__["default"], _handlers_searchResponseReceived__WEBPACK_IMPORTED_MODULE_9__["default"], _handlers_shoppingCartPageView__WEBPACK_IMPORTED_MODULE_10__["default"], _handlers_shoppingMiniCartView__WEBPACK_IMPORTED_MODULE_11__["default"], _handlers_startCheckout__WEBPACK_IMPORTED_MODULE_12__["default"], _handlers_signIn__WEBPACK_IMPORTED_MODULE_13__["default"]]);

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handleEvent.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handleEvent.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./config */ "./node_modules/@magento/experience-platform-connector/src/config.js");

/* harmony default export */ __webpack_exports__["default"] = ((sdk, event) => {
  _config__WEBPACK_IMPORTED_MODULE_0__["default"].forEach(({
    canHandle,
    handle
  }) => {
    if (canHandle(event)) {
      handle(sdk, event);
    }
  });
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/addToCart.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/addToCart.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'CART_ADD_ITEM';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    cartId,
    currencyCode,
    priceTotal,
    quantity,
    name,
    sku,
    selectedOptions
  } = payload;
  const configurableOptions = selectedOptions ? [{
    optionLabel: selectedOptions.attribute,
    valueLabel: selectedOptions.value
  }] : null;
  const cartItemContext = {
    id: cartId,
    prices: {
      subtotalExcludingTax: {
        value: priceTotal * quantity,
        currency: currencyCode
      }
    },
    items: [{
      product: {
        name: name,
        sku: sku,
        configurableOptions: configurableOptions
      },
      prices: {
        price: {
          value: priceTotal,
          currency: currencyCode
        }
      }
    }],
    possibleOnepageCheckout: false,
    giftMessageSelected: false,
    giftWrappingSelected: false
  };
  sdk.context.setShoppingCart(cartItemContext);
  sdk.publish.addToCart();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/categoryPageView.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/categoryPageView.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'CATEGORY_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    name,
    url_key,
    url_path
  } = payload;
  const categoryContext = {
    name,
    urlKey: url_key,
    urlPath: url_path
  };
  sdk.context.setCategory(categoryContext); // Send out page view event

  const pageContext = {
    pageType: 'Category',
    pageName: name,
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(pageContext);
  sdk.publish.pageView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/completeCheckout.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/completeCheckout.js ***!
  \**********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'ORDER_CONFIRMATION_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const grandTotal = payload.amount.grand_total.value;
  const {
    order_number,
    payment,
    shipping
  } = payload;
  const orderContext = {
    orderId: order_number,
    grandTotal: grandTotal,
    orderType: 'checkout',
    payments: [{
      paymentMethodCode: payment.title,
      paymentMethodName: payment.title,
      total: grandTotal
    }],
    shipping: {
      shippingMethod: shipping[0].method_title,
      shippingAmount: shipping[0].amount.value
    }
  };
  sdk.context.setOrder(orderContext);
  sdk.publish.placeOrder(); // Send out page view event

  const pageContext = {
    pageType: 'Order Confirmation Page',
    pageName: 'Order Confirmation',
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(pageContext);
  sdk.publish.pageView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/createAccount.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/createAccount.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'USER_CREATE_ACCOUNT';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    firstName,
    lastName,
    email
  } = payload;
  const accountContext = {
    firstName,
    lastName,
    emailAddress: email
  };
  sdk.context.setAccount(accountContext);
  sdk.publish.createAccount({
    personalEmail: {
      address: email
    }
  });
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/editAccount.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/editAccount.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'USER_ACCOUNT_UPDATE';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    email,
    firstName,
    lastName
  } = payload;
  const accountContext = {
    firstName,
    lastName,
    emailAddress: email
  };
  sdk.context.setAccount(accountContext);
  sdk.publish.editAccount({
    personalEmail: {
      address: email
    }
  });
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/pageView.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/pageView.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'CMS_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    title
  } = payload;
  const context = {
    pageType: 'CMS',
    pageName: title,
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(context);
  sdk.publish.pageView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/placeOrder.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/placeOrder.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'CHECKOUT_PLACE_ORDER_BUTTON_CLICKED';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const grandTotal = payload.amount.grand_total.value;
  const {
    payment,
    shipping
  } = payload;
  const orderContext = {
    grandTotal: grandTotal,
    orderType: 'checkout',
    payments: [{
      paymentMethodCode: payment.title,
      paymentMethodName: payment.title,
      total: grandTotal
    }],
    shipping: {
      shippingMethod: shipping[0].method_title,
      shippingAmount: shipping[0].amount.value
    }
  };
  sdk.context.setOrder(orderContext);
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/productPageView.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/productPageView.js ***!
  \*********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'PRODUCT_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    name,
    id,
    currency_code,
    price_range,
    sku,
    url_key
  } = payload;
  const pageContext = {
    pageType: 'PDP',
    pageName: name,
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(pageContext);
  sdk.publish.pageView();
  const productContext = {
    productId: id,
    name,
    sku,
    pricing: {
      currencyCode: currency_code,
      maximalPrice: price_range.maximum_price.final_price
    },
    canonicalUrl: url_key
  };
  sdk.context.setProduct(productContext);
  sdk.publish.productPageView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/searchRequestSent.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/searchRequestSent.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => ['SEARCH_REQUEST', 'SEARCHBAR_REQUEST'].includes(event.type);

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    query,
    pageSize,
    currentPage,
    refinements,
    sort
  } = payload;
  const filter = refinements.map(refinement => {
    const {
      attribute,
      value
    } = refinement;
    return {
      attribute: attribute,
      in: Array.from(value.values())
    };
  });
  const requestContext = {
    units: [{
      searchUnitId: 'productPage',
      queryTypes: ['products'],
      phrase: query,
      pageSize: pageSize,
      currentPage: currentPage,
      filter: filter,
      sort: [{
        attribute: sort === null || sort === void 0 ? void 0 : sort.attribute,
        direction: sort === null || sort === void 0 ? void 0 : sort.order
      }]
    }]
  };
  sdk.context.setSearchInput(requestContext);
  sdk.publish.searchRequestSent();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/searchResponseReceived.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/searchResponseReceived.js ***!
  \****************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'SEARCH_RESPONSE';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    categories,
    facets,
    page,
    perPage,
    products,
    searchRequestId,
    searchUnitId,
    suggestions
  } = payload;
  const searchResultsContext = {
    units: [{
      categories,
      facets,
      page,
      perPage,
      products,
      searchRequestId,
      searchUnitId,
      suggestions
    }]
  };
  sdk.context.setSearchResults(searchResultsContext);
  sdk.publish.searchResponseReceived(searchUnitId, searchResultsContext);
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/shoppingCartPageView.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/shoppingCartPageView.js ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/@magento/experience-platform-connector/src/utils.js");


const canHandle = event => event.type === 'CART_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    cart_id: id,
    products
  } = payload;
  const cartContext = {
    id,
    prices: {
      subtotalExcludingTax: {
        value: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCartTotal"])(products),
        currency: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCurrency"])(products)
      }
    },
    items: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getFormattedProducts"])(products),
    possibleOnepageCheckout: false,
    giftMessageSelected: false,
    giftWrappingSelected: false
  };
  sdk.context.setShoppingCart(cartContext);
  sdk.publish.shoppingCartView(); // Send out page view event

  const pageContext = {
    pageType: 'Cart',
    pageName: 'Cart',
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(pageContext);
  sdk.publish.pageView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/shoppingMiniCartView.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/shoppingMiniCartView.js ***!
  \**************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/@magento/experience-platform-connector/src/utils.js");


const canHandle = event => event.type === 'MINI_CART_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    cartId: id,
    products
  } = payload;
  const cartContext = {
    id: id,
    prices: {
      subtotalExcludingTax: {
        value: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCartTotal"])(products),
        currency: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCurrency"])(products)
      }
    },
    items: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getFormattedProducts"])(products),
    possibleOnepageCheckout: false,
    giftMessageSelected: false,
    giftWrappingSelected: false
  };
  sdk.context.setShoppingCart(cartContext);
  sdk.publish.shoppingCartView();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/signIn.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/signIn.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
const canHandle = event => event.type === 'USER_SIGN_IN';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  sdk.context.setShopper({
    shopperId: 'logged-in'
  });
  const {
    firstname,
    lastname,
    email
  } = payload;
  const accountContext = {
    firstName: firstname,
    lastName: lastname,
    emailAddress: email
  };
  sdk.context.setAccount(accountContext);
  sdk.publish.signIn({
    personalEmail: {
      address: email
    }
  });
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/handlers/startCheckout.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/handlers/startCheckout.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/@magento/experience-platform-connector/src/utils.js");


const canHandle = event => event.type === 'CHECKOUT_PAGE_VIEW';

const handle = (sdk, event) => {
  const {
    payload
  } = event;
  const {
    cart_id,
    products
  } = payload; // Send out page view event

  const pageContext = {
    pageType: 'Checkout',
    pageName: 'Checkout',
    eventType: 'visibilityHidden',
    maxXOffset: 0,
    maxYOffset: 0,
    minXOffset: 0,
    minYOffset: 0
  };
  sdk.context.setPage(pageContext);
  sdk.publish.pageView();
  const cartContext = {
    id: cart_id,
    prices: {
      subtotalExcludingTax: {
        value: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCartTotal"])(products),
        currency: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getCurrency"])(products)
      }
    },
    items: Object(_utils__WEBPACK_IMPORTED_MODULE_0__["getFormattedProducts"])(products),
    possibleOnepageCheckout: false,
    giftMessageSelected: false,
    giftWrappingSelected: false
  };
  sdk.context.setShoppingCart(cartContext);
  sdk.publish.initiateCheckout();
};

/* harmony default export */ __webpack_exports__["default"] = ({
  canHandle,
  handle
});

/***/ }),

/***/ "./node_modules/@magento/experience-platform-connector/src/utils.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@magento/experience-platform-connector/src/utils.js ***!
  \**************************************************************************/
/*! exports provided: getCartTotal, getCurrency, getFormattedProducts */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCartTotal", function() { return getCartTotal; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCurrency", function() { return getCurrency; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFormattedProducts", function() { return getFormattedProducts; });
/** Cart focused utils **/

/**
 * Returns the total sum from an array of cart products
 *
 * @param {Array} products
 * @returns {Number} Sum of all product prices in the array
 */
const getCartTotal = products => {
  return products ? products.reduce((previous, current) => current.prices.price.value * current.quantity + previous, 0) : 0;
};
/**
 * Get the currency from the first product item in an array of cart products
 *
 * @param {Array} products
 * @returns {String} Currency code from the first product item or null if array is empty
 */

const getCurrency = products => products && products.length > 0 ? products[0].prices.price.currency : null;
/**
 * Transforms an array of cart products into a format compatible with the
 * Magento Storefront Event SDK
 *
 * @param {Array} products
 * @returns {Array} Array of data compatible with the Magento Storefront Event SDK
 */

const getFormattedProducts = products => {
  return products ? products.map(item => {
    const {
      uid,
      product,
      prices,
      quantity,
      configurable_options: options
    } = item;
    const {
      name,
      sku,
      __typename: type,
      url_key: url,
      small_image: image,
      thumbnail
    } = product;
    const formattedOptions = options ? options.map(option => {
      const {
        id,
        option_label,
        value_label,
        configurable_product_option_value_uid: valueId
      } = option;
      return {
        id: id,
        optionLabel: option_label,
        valueId: valueId,
        valueLabel: value_label
      };
    }) : null;
    const imageUrl = image ? image.url : thumbnail ? thumbnail.url : null;
    return {
      formattedPrice: '',
      id: uid,
      prices: prices,
      product: {
        name: name,
        sku: sku,
        productType: type,
        pricing: {
          regularPrice: prices.price.value,
          minimalPrice: prices.price.value,
          maximalPrice: prices.price.value,
          currencyCode: prices.price.currency
        },
        canonicalUrl: url,
        mainImageUrl: imageUrl
      },
      configurableOptions: formattedOptions,
      quantity: quantity
    };
  }) : null;
};

/***/ }),

/***/ "./node_modules/object-assign/index.js":
/*!*********************************************!*\
  !*** ./node_modules/object-assign/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*
object-assign
(c) Sindre Sorhus
@license MIT
*/

/* eslint-disable no-unused-vars */

var getOwnPropertySymbols = Object.getOwnPropertySymbols;
var hasOwnProperty = Object.prototype.hasOwnProperty;
var propIsEnumerable = Object.prototype.propertyIsEnumerable;

function toObject(val) {
  if (val === null || val === undefined) {
    throw new TypeError('Object.assign cannot be called with null or undefined');
  }

  return Object(val);
}

function shouldUseNative() {
  try {
    if (!Object.assign) {
      return false;
    } // Detect buggy property enumeration order in older V8 versions.
    // https://bugs.chromium.org/p/v8/issues/detail?id=4118


    var test1 = new String('abc'); // eslint-disable-line no-new-wrappers

    test1[5] = 'de';

    if (Object.getOwnPropertyNames(test1)[0] === '5') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test2 = {};

    for (var i = 0; i < 10; i++) {
      test2['_' + String.fromCharCode(i)] = i;
    }

    var order2 = Object.getOwnPropertyNames(test2).map(function (n) {
      return test2[n];
    });

    if (order2.join('') !== '0123456789') {
      return false;
    } // https://bugs.chromium.org/p/v8/issues/detail?id=3056


    var test3 = {};
    'abcdefghijklmnopqrst'.split('').forEach(function (letter) {
      test3[letter] = letter;
    });

    if (Object.keys(Object.assign({}, test3)).join('') !== 'abcdefghijklmnopqrst') {
      return false;
    }

    return true;
  } catch (err) {
    // We don't expect any of the above to throw, but better to be safe.
    return false;
  }
}

module.exports = shouldUseNative() ? Object.assign : function (target, source) {
  var from;
  var to = toObject(target);
  var symbols;

  for (var s = 1; s < arguments.length; s++) {
    from = Object(arguments[s]);

    for (var key in from) {
      if (hasOwnProperty.call(from, key)) {
        to[key] = from[key];
      }
    }

    if (getOwnPropertySymbols) {
      symbols = getOwnPropertySymbols(from);

      for (var i = 0; i < symbols.length; i++) {
        if (propIsEnumerable.call(from, symbols[i])) {
          to[symbols[i]] = from[symbols[i]];
        }
      }
    }
  }

  return to;
};

/***/ }),

/***/ "./node_modules/prop-types/checkPropTypes.js":
/*!***************************************************!*\
  !*** ./node_modules/prop-types/checkPropTypes.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var printWarning = function () {};

if (true) {
  var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");

  var loggedTypeFailures = {};

  var has = __webpack_require__(/*! ./lib/has */ "./node_modules/prop-types/lib/has.js");

  printWarning = function (text) {
    var message = 'Warning: ' + text;

    if (typeof console !== 'undefined') {
      console.error(message);
    }

    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {
      /**/
    }
  };
}
/**
 * Assert that the values match with the type specs.
 * Error messages are memorized and will only be shown once.
 *
 * @param {object} typeSpecs Map of name to a ReactPropType
 * @param {object} values Runtime values that need to be type-checked
 * @param {string} location e.g. "prop", "context", "child context"
 * @param {string} componentName Name of the component for error messages.
 * @param {?Function} getStack Returns the component stack.
 * @private
 */


function checkPropTypes(typeSpecs, values, location, componentName, getStack) {
  if (true) {
    for (var typeSpecName in typeSpecs) {
      if (has(typeSpecs, typeSpecName)) {
        var error; // Prop type validation may throw. In case they do, we don't want to
        // fail the render phase where it didn't fail before. So we log it.
        // After these have been cleaned up, we'll let them throw.

        try {
          // This is intentionally an invariant that gets caught. It's the same
          // behavior as without this statement except with a better message.
          if (typeof typeSpecs[typeSpecName] !== 'function') {
            var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');
            err.name = 'Invariant Violation';
            throw err;
          }

          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);
        } catch (ex) {
          error = ex;
        }

        if (error && !(error instanceof Error)) {
          printWarning((componentName || 'React class') + ': type specification of ' + location + ' `' + typeSpecName + '` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a ' + typeof error + '. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).');
        }

        if (error instanceof Error && !(error.message in loggedTypeFailures)) {
          // Only monitor this failure once because there tends to be a lot of the
          // same error.
          loggedTypeFailures[error.message] = true;
          var stack = getStack ? getStack() : '';
          printWarning('Failed ' + location + ' type: ' + error.message + (stack != null ? stack : ''));
        }
      }
    }
  }
}
/**
 * Resets warning cache when testing.
 *
 * @private
 */


checkPropTypes.resetWarningCache = function () {
  if (true) {
    loggedTypeFailures = {};
  }
};

module.exports = checkPropTypes;

/***/ }),

/***/ "./node_modules/prop-types/factoryWithTypeCheckers.js":
/*!************************************************************!*\
  !*** ./node_modules/prop-types/factoryWithTypeCheckers.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/prop-types/node_modules/react-is/index.js");

var assign = __webpack_require__(/*! object-assign */ "./node_modules/object-assign/index.js");

var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ "./node_modules/prop-types/lib/ReactPropTypesSecret.js");

var has = __webpack_require__(/*! ./lib/has */ "./node_modules/prop-types/lib/has.js");

var checkPropTypes = __webpack_require__(/*! ./checkPropTypes */ "./node_modules/prop-types/checkPropTypes.js");

var printWarning = function () {};

if (true) {
  printWarning = function (text) {
    var message = 'Warning: ' + text;

    if (typeof console !== 'undefined') {
      console.error(message);
    }

    try {
      // --- Welcome to debugging React ---
      // This error was thrown as a convenience so that you can use this stack
      // to find the callsite that caused this warning to fire.
      throw new Error(message);
    } catch (x) {}
  };
}

function emptyFunctionThatReturnsNull() {
  return null;
}

module.exports = function (isValidElement, throwOnDirectAccess) {
  /* global Symbol */
  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;
  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.

  /**
   * Returns the iterator method function contained on the iterable object.
   *
   * Be sure to invoke the function with the iterable as context:
   *
   *     var iteratorFn = getIteratorFn(myIterable);
   *     if (iteratorFn) {
   *       var iterator = iteratorFn.call(myIterable);
   *       ...
   *     }
   *
   * @param {?object} maybeIterable
   * @return {?function}
   */

  function getIteratorFn(maybeIterable) {
    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);

    if (typeof iteratorFn === 'function') {
      return iteratorFn;
    }
  }
  /**
   * Collection of methods that allow declaration and validation of props that are
   * supplied to React components. Example usage:
   *
   *   var Props = require('ReactPropTypes');
   *   var MyArticle = React.createClass({
   *     propTypes: {
   *       // An optional string prop named "description".
   *       description: Props.string,
   *
   *       // A required enum prop named "category".
   *       category: Props.oneOf(['News','Photos']).isRequired,
   *
   *       // A prop named "dialog" that requires an instance of Dialog.
   *       dialog: Props.instanceOf(Dialog).isRequired
   *     },
   *     render: function() { ... }
   *   });
   *
   * A more formal specification of how these methods are used:
   *
   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)
   *   decl := ReactPropTypes.{type}(.isRequired)?
   *
   * Each and every declaration produces a function with the same signature. This
   * allows the creation of custom validation functions. For example:
   *
   *  var MyLink = React.createClass({
   *    propTypes: {
   *      // An optional string or URI prop named "href".
   *      href: function(props, propName, componentName) {
   *        var propValue = props[propName];
   *        if (propValue != null && typeof propValue !== 'string' &&
   *            !(propValue instanceof URI)) {
   *          return new Error(
   *            'Expected a string or an URI for ' + propName + ' in ' +
   *            componentName
   *          );
   *        }
   *      }
   *    },
   *    render: function() {...}
   *  });
   *
   * @internal
   */


  var ANONYMOUS = '<<anonymous>>'; // Important!
  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.

  var ReactPropTypes = {
    array: createPrimitiveTypeChecker('array'),
    bigint: createPrimitiveTypeChecker('bigint'),
    bool: createPrimitiveTypeChecker('boolean'),
    func: createPrimitiveTypeChecker('function'),
    number: createPrimitiveTypeChecker('number'),
    object: createPrimitiveTypeChecker('object'),
    string: createPrimitiveTypeChecker('string'),
    symbol: createPrimitiveTypeChecker('symbol'),
    any: createAnyTypeChecker(),
    arrayOf: createArrayOfTypeChecker,
    element: createElementTypeChecker(),
    elementType: createElementTypeTypeChecker(),
    instanceOf: createInstanceTypeChecker,
    node: createNodeChecker(),
    objectOf: createObjectOfTypeChecker,
    oneOf: createEnumTypeChecker,
    oneOfType: createUnionTypeChecker,
    shape: createShapeTypeChecker,
    exact: createStrictShapeTypeChecker
  };
  /**
   * inlined Object.is polyfill to avoid requiring consumers ship their own
   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
   */

  /*eslint-disable no-self-compare*/

  function is(x, y) {
    // SameValue algorithm
    if (x === y) {
      // Steps 1-5, 7-10
      // Steps 6.b-6.e: +0 != -0
      return x !== 0 || 1 / x === 1 / y;
    } else {
      // Step 6.a: NaN == NaN
      return x !== x && y !== y;
    }
  }
  /*eslint-enable no-self-compare*/

  /**
   * We use an Error-like object for backward compatibility as people may call
   * PropTypes directly and inspect their output. However, we don't use real
   * Errors anymore. We don't inspect their stack anyway, and creating them
   * is prohibitively expensive if they are created too often, such as what
   * happens in oneOfType() for any type before the one that matched.
   */


  function PropTypeError(message, data) {
    this.message = message;
    this.data = data && typeof data === 'object' ? data : {};
    this.stack = '';
  } // Make `instanceof Error` still work for returned errors.


  PropTypeError.prototype = Error.prototype;

  function createChainableTypeChecker(validate) {
    if (true) {
      var manualPropTypeCallCache = {};
      var manualPropTypeWarningCount = 0;
    }

    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {
      componentName = componentName || ANONYMOUS;
      propFullName = propFullName || propName;

      if (secret !== ReactPropTypesSecret) {
        if (throwOnDirectAccess) {
          // New behavior only for users of `prop-types` package
          var err = new Error('Calling PropTypes validators directly is not supported by the `prop-types` package. ' + 'Use `PropTypes.checkPropTypes()` to call them. ' + 'Read more at http://fb.me/use-check-prop-types');
          err.name = 'Invariant Violation';
          throw err;
        } else if ( true && typeof console !== 'undefined') {
          // Old behavior for people using React.PropTypes
          var cacheKey = componentName + ':' + propName;

          if (!manualPropTypeCallCache[cacheKey] && // Avoid spamming the console because they are often not actionable except for lib authors
          manualPropTypeWarningCount < 3) {
            printWarning('You are manually calling a React.PropTypes validation ' + 'function for the `' + propFullName + '` prop on `' + componentName + '`. This is deprecated ' + 'and will throw in the standalone `prop-types` package. ' + 'You may be seeing this warning due to a third-party PropTypes ' + 'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.');
            manualPropTypeCallCache[cacheKey] = true;
            manualPropTypeWarningCount++;
          }
        }
      }

      if (props[propName] == null) {
        if (isRequired) {
          if (props[propName] === null) {
            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));
          }

          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));
        }

        return null;
      } else {
        return validate(props, propName, componentName, location, propFullName);
      }
    }

    var chainedCheckType = checkType.bind(null, false);
    chainedCheckType.isRequired = checkType.bind(null, true);
    return chainedCheckType;
  }

  function createPrimitiveTypeChecker(expectedType) {
    function validate(props, propName, componentName, location, propFullName, secret) {
      var propValue = props[propName];
      var propType = getPropType(propValue);

      if (propType !== expectedType) {
        // `propValue` being instance of, say, date/regexp, pass the 'object'
        // check, but we can offer a more precise error message here rather than
        // 'of type `object`'.
        var preciseType = getPreciseType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'), {
          expectedType: expectedType
        });
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createAnyTypeChecker() {
    return createChainableTypeChecker(emptyFunctionThatReturnsNull);
  }

  function createArrayOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');
      }

      var propValue = props[propName];

      if (!Array.isArray(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));
      }

      for (var i = 0; i < propValue.length; i++) {
        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret);

        if (error instanceof Error) {
          return error;
        }
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createElementTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];

      if (!isValidElement(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createElementTypeTypeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];

      if (!ReactIs.isValidElementType(propValue)) {
        var propType = getPropType(propValue);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createInstanceTypeChecker(expectedClass) {
    function validate(props, propName, componentName, location, propFullName) {
      if (!(props[propName] instanceof expectedClass)) {
        var expectedClassName = expectedClass.name || ANONYMOUS;
        var actualClassName = getClassName(props[propName]);
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createEnumTypeChecker(expectedValues) {
    if (!Array.isArray(expectedValues)) {
      if (true) {
        if (arguments.length > 1) {
          printWarning('Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' + 'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).');
        } else {
          printWarning('Invalid argument supplied to oneOf, expected an array.');
        }
      }

      return emptyFunctionThatReturnsNull;
    }

    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];

      for (var i = 0; i < expectedValues.length; i++) {
        if (is(propValue, expectedValues[i])) {
          return null;
        }
      }

      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {
        var type = getPreciseType(value);

        if (type === 'symbol') {
          return String(value);
        }

        return value;
      });
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));
    }

    return createChainableTypeChecker(validate);
  }

  function createObjectOfTypeChecker(typeChecker) {
    function validate(props, propName, componentName, location, propFullName) {
      if (typeof typeChecker !== 'function') {
        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');
      }

      var propValue = props[propName];
      var propType = getPropType(propValue);

      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));
      }

      for (var key in propValue) {
        if (has(propValue, key)) {
          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);

          if (error instanceof Error) {
            return error;
          }
        }
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createUnionTypeChecker(arrayOfTypeCheckers) {
    if (!Array.isArray(arrayOfTypeCheckers)) {
       true ? printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') : undefined;
      return emptyFunctionThatReturnsNull;
    }

    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
      var checker = arrayOfTypeCheckers[i];

      if (typeof checker !== 'function') {
        printWarning('Invalid argument supplied to oneOfType. Expected an array of check functions, but ' + 'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.');
        return emptyFunctionThatReturnsNull;
      }
    }

    function validate(props, propName, componentName, location, propFullName) {
      var expectedTypes = [];

      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {
        var checker = arrayOfTypeCheckers[i];
        var checkerResult = checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret);

        if (checkerResult == null) {
          return null;
        }

        if (checkerResult.data && has(checkerResult.data, 'expectedType')) {
          expectedTypes.push(checkerResult.data.expectedType);
        }
      }

      var expectedTypesMessage = expectedTypes.length > 0 ? ', expected one of type [' + expectedTypes.join(', ') + ']' : '';
      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`' + expectedTypesMessage + '.'));
    }

    return createChainableTypeChecker(validate);
  }

  function createNodeChecker() {
    function validate(props, propName, componentName, location, propFullName) {
      if (!isNode(props[propName])) {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function invalidValidatorError(componentName, location, propFullName, key, type) {
    return new PropTypeError((componentName || 'React class') + ': ' + location + ' type `' + propFullName + '.' + key + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + type + '`.');
  }

  function createShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);

      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      }

      for (var key in shapeTypes) {
        var checker = shapeTypes[key];

        if (typeof checker !== 'function') {
          return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
        }

        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);

        if (error) {
          return error;
        }
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function createStrictShapeTypeChecker(shapeTypes) {
    function validate(props, propName, componentName, location, propFullName) {
      var propValue = props[propName];
      var propType = getPropType(propValue);

      if (propType !== 'object') {
        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));
      } // We need to check all keys in case some are required but missing from props.


      var allKeys = assign({}, props[propName], shapeTypes);

      for (var key in allKeys) {
        var checker = shapeTypes[key];

        if (has(shapeTypes, key) && typeof checker !== 'function') {
          return invalidValidatorError(componentName, location, propFullName, key, getPreciseType(checker));
        }

        if (!checker) {
          return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' + '\nBad object: ' + JSON.stringify(props[propName], null, '  ') + '\nValid keys: ' + JSON.stringify(Object.keys(shapeTypes), null, '  '));
        }

        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);

        if (error) {
          return error;
        }
      }

      return null;
    }

    return createChainableTypeChecker(validate);
  }

  function isNode(propValue) {
    switch (typeof propValue) {
      case 'number':
      case 'string':
      case 'undefined':
        return true;

      case 'boolean':
        return !propValue;

      case 'object':
        if (Array.isArray(propValue)) {
          return propValue.every(isNode);
        }

        if (propValue === null || isValidElement(propValue)) {
          return true;
        }

        var iteratorFn = getIteratorFn(propValue);

        if (iteratorFn) {
          var iterator = iteratorFn.call(propValue);
          var step;

          if (iteratorFn !== propValue.entries) {
            while (!(step = iterator.next()).done) {
              if (!isNode(step.value)) {
                return false;
              }
            }
          } else {
            // Iterator will provide entry [k,v] tuples rather than values.
            while (!(step = iterator.next()).done) {
              var entry = step.value;

              if (entry) {
                if (!isNode(entry[1])) {
                  return false;
                }
              }
            }
          }
        } else {
          return false;
        }

        return true;

      default:
        return false;
    }
  }

  function isSymbol(propType, propValue) {
    // Native Symbol.
    if (propType === 'symbol') {
      return true;
    } // falsy value can't be a Symbol


    if (!propValue) {
      return false;
    } // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'


    if (propValue['@@toStringTag'] === 'Symbol') {
      return true;
    } // Fallback for non-spec compliant Symbols which are polyfilled.


    if (typeof Symbol === 'function' && propValue instanceof Symbol) {
      return true;
    }

    return false;
  } // Equivalent of `typeof` but with special handling for array and regexp.


  function getPropType(propValue) {
    var propType = typeof propValue;

    if (Array.isArray(propValue)) {
      return 'array';
    }

    if (propValue instanceof RegExp) {
      // Old webkits (at least until Android 4.0) return 'function' rather than
      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/
      // passes PropTypes.object.
      return 'object';
    }

    if (isSymbol(propType, propValue)) {
      return 'symbol';
    }

    return propType;
  } // This handles more types than `getPropType`. Only used for error messages.
  // See `createPrimitiveTypeChecker`.


  function getPreciseType(propValue) {
    if (typeof propValue === 'undefined' || propValue === null) {
      return '' + propValue;
    }

    var propType = getPropType(propValue);

    if (propType === 'object') {
      if (propValue instanceof Date) {
        return 'date';
      } else if (propValue instanceof RegExp) {
        return 'regexp';
      }
    }

    return propType;
  } // Returns a string that is postfixed to a warning about an invalid type.
  // For example, "undefined" or "of type array"


  function getPostfixForTypeWarning(value) {
    var type = getPreciseType(value);

    switch (type) {
      case 'array':
      case 'object':
        return 'an ' + type;

      case 'boolean':
      case 'date':
      case 'regexp':
        return 'a ' + type;

      default:
        return type;
    }
  } // Returns class name of the object, if any.


  function getClassName(propValue) {
    if (!propValue.constructor || !propValue.constructor.name) {
      return ANONYMOUS;
    }

    return propValue.constructor.name;
  }

  ReactPropTypes.checkPropTypes = checkPropTypes;
  ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;
  ReactPropTypes.PropTypes = ReactPropTypes;
  return ReactPropTypes;
};

/***/ }),

/***/ "./node_modules/prop-types/index.js":
/*!******************************************!*\
  !*** ./node_modules/prop-types/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
if (true) {
  var ReactIs = __webpack_require__(/*! react-is */ "./node_modules/prop-types/node_modules/react-is/index.js"); // By explicitly using `prop-types` you are opting into new development behavior.
  // http://fb.me/prop-types-in-prod


  var throwOnDirectAccess = true;
  module.exports = __webpack_require__(/*! ./factoryWithTypeCheckers */ "./node_modules/prop-types/factoryWithTypeCheckers.js")(ReactIs.isElement, throwOnDirectAccess);
} else {}

/***/ }),

/***/ "./node_modules/prop-types/lib/ReactPropTypesSecret.js":
/*!*************************************************************!*\
  !*** ./node_modules/prop-types/lib/ReactPropTypesSecret.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


var ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';
module.exports = ReactPropTypesSecret;

/***/ }),

/***/ "./node_modules/prop-types/lib/has.js":
/*!********************************************!*\
  !*** ./node_modules/prop-types/lib/has.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = Function.call.bind(Object.prototype.hasOwnProperty);

/***/ }),

/***/ "./node_modules/prop-types/node_modules/react-is/cjs/react-is.development.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/prop-types/node_modules/react-is/cjs/react-is.development.js ***!
  \***********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/** @license React v16.13.1
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */


if (true) {
  (function () {
    'use strict'; // The Symbol used to tag the ReactElement-like types. If there is no native Symbol
    // nor polyfill, then a plain number is used for performance.

    var hasSymbol = typeof Symbol === 'function' && Symbol.for;
    var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;
    var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;
    var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;
    var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;
    var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;
    var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;
    var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace; // TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary
    // (unstable) APIs that have been removed. Can we remove the symbols?

    var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;
    var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;
    var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;
    var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;
    var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;
    var REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;
    var REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;
    var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for('react.block') : 0xead9;
    var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;
    var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;
    var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for('react.scope') : 0xead7;

    function isValidElementType(type) {
      return typeof type === 'string' || typeof type === 'function' || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
      type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
    }

    function typeOf(object) {
      if (typeof object === 'object' && object !== null) {
        var $$typeof = object.$$typeof;

        switch ($$typeof) {
          case REACT_ELEMENT_TYPE:
            var type = object.type;

            switch (type) {
              case REACT_ASYNC_MODE_TYPE:
              case REACT_CONCURRENT_MODE_TYPE:
              case REACT_FRAGMENT_TYPE:
              case REACT_PROFILER_TYPE:
              case REACT_STRICT_MODE_TYPE:
              case REACT_SUSPENSE_TYPE:
                return type;

              default:
                var $$typeofType = type && type.$$typeof;

                switch ($$typeofType) {
                  case REACT_CONTEXT_TYPE:
                  case REACT_FORWARD_REF_TYPE:
                  case REACT_LAZY_TYPE:
                  case REACT_MEMO_TYPE:
                  case REACT_PROVIDER_TYPE:
                    return $$typeofType;

                  default:
                    return $$typeof;
                }

            }

          case REACT_PORTAL_TYPE:
            return $$typeof;
        }
      }

      return undefined;
    } // AsyncMode is deprecated along with isAsyncMode


    var AsyncMode = REACT_ASYNC_MODE_TYPE;
    var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
    var ContextConsumer = REACT_CONTEXT_TYPE;
    var ContextProvider = REACT_PROVIDER_TYPE;
    var Element = REACT_ELEMENT_TYPE;
    var ForwardRef = REACT_FORWARD_REF_TYPE;
    var Fragment = REACT_FRAGMENT_TYPE;
    var Lazy = REACT_LAZY_TYPE;
    var Memo = REACT_MEMO_TYPE;
    var Portal = REACT_PORTAL_TYPE;
    var Profiler = REACT_PROFILER_TYPE;
    var StrictMode = REACT_STRICT_MODE_TYPE;
    var Suspense = REACT_SUSPENSE_TYPE;
    var hasWarnedAboutDeprecatedIsAsyncMode = false; // AsyncMode should be deprecated

    function isAsyncMode(object) {
      {
        if (!hasWarnedAboutDeprecatedIsAsyncMode) {
          hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

          console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');
        }
      }
      return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
    }

    function isConcurrentMode(object) {
      return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
    }

    function isContextConsumer(object) {
      return typeOf(object) === REACT_CONTEXT_TYPE;
    }

    function isContextProvider(object) {
      return typeOf(object) === REACT_PROVIDER_TYPE;
    }

    function isElement(object) {
      return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
    }

    function isForwardRef(object) {
      return typeOf(object) === REACT_FORWARD_REF_TYPE;
    }

    function isFragment(object) {
      return typeOf(object) === REACT_FRAGMENT_TYPE;
    }

    function isLazy(object) {
      return typeOf(object) === REACT_LAZY_TYPE;
    }

    function isMemo(object) {
      return typeOf(object) === REACT_MEMO_TYPE;
    }

    function isPortal(object) {
      return typeOf(object) === REACT_PORTAL_TYPE;
    }

    function isProfiler(object) {
      return typeOf(object) === REACT_PROFILER_TYPE;
    }

    function isStrictMode(object) {
      return typeOf(object) === REACT_STRICT_MODE_TYPE;
    }

    function isSuspense(object) {
      return typeOf(object) === REACT_SUSPENSE_TYPE;
    }

    exports.AsyncMode = AsyncMode;
    exports.ConcurrentMode = ConcurrentMode;
    exports.ContextConsumer = ContextConsumer;
    exports.ContextProvider = ContextProvider;
    exports.Element = Element;
    exports.ForwardRef = ForwardRef;
    exports.Fragment = Fragment;
    exports.Lazy = Lazy;
    exports.Memo = Memo;
    exports.Portal = Portal;
    exports.Profiler = Profiler;
    exports.StrictMode = StrictMode;
    exports.Suspense = Suspense;
    exports.isAsyncMode = isAsyncMode;
    exports.isConcurrentMode = isConcurrentMode;
    exports.isContextConsumer = isContextConsumer;
    exports.isContextProvider = isContextProvider;
    exports.isElement = isElement;
    exports.isForwardRef = isForwardRef;
    exports.isFragment = isFragment;
    exports.isLazy = isLazy;
    exports.isMemo = isMemo;
    exports.isPortal = isPortal;
    exports.isProfiler = isProfiler;
    exports.isStrictMode = isStrictMode;
    exports.isSuspense = isSuspense;
    exports.isValidElementType = isValidElementType;
    exports.typeOf = typeOf;
  })();
}

/***/ }),

/***/ "./node_modules/prop-types/node_modules/react-is/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/prop-types/node_modules/react-is/index.js ***!
  \****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "./node_modules/prop-types/node_modules/react-is/cjs/react-is.development.js");
}

/***/ }),

/***/ "./src/events-collector/EventCollectorContext.js":
/*!*******************************************************!*\
  !*** ./src/events-collector/EventCollectorContext.js ***!
  \*******************************************************/
/*! exports provided: EventCollectorContext, EventCollectorContextProvider, useEventCollectorContext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventCollectorContext", function() { return EventCollectorContext; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventCollectorContextProvider", function() { return EventCollectorContextProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useEventCollectorContext", function() { return useEventCollectorContext; });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _magento_peregrine_lib_context_eventing__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @magento/peregrine/lib/context/eventing */ "@magento/peregrine/lib/context/eventing");
/* harmony import */ var _magento_peregrine_lib_context_eventing__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_magento_peregrine_lib_context_eventing__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _magento_peregrine_lib_hooks_useAwaitQuery__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @magento/peregrine/lib/hooks/useAwaitQuery */ "@magento/peregrine/lib/hooks/useAwaitQuery");
/* harmony import */ var _magento_peregrine_lib_hooks_useAwaitQuery__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_magento_peregrine_lib_hooks_useAwaitQuery__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _magento_peregrine_lib_context_user__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @magento/peregrine/lib/context/user */ "@magento/peregrine/lib/context/user");
/* harmony import */ var _magento_peregrine_lib_context_user__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_magento_peregrine_lib_context_user__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _magento_experience_platform_connector_src_handleEvent__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @magento/experience-platform-connector/src/handleEvent */ "./node_modules/@magento/experience-platform-connector/src/handleEvent.js");
/* harmony import */ var _processors__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./processors */ "./src/events-collector/processors/index.js");
/* harmony import */ var _storeConfigQuery_gql__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./storeConfigQuery.gql */ "./src/events-collector/storeConfigQuery.gql.js");
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/








const EventCollectorContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createContext();
const EventCollectorContextProvider = props => {
  const {
    aep = null,
    acds = false
  } = props;
  const [sdk, setSdk] = Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);
  const [{
    isSignedIn,
    currentUser
  }] = Object(_magento_peregrine_lib_context_user__WEBPACK_IMPORTED_MODULE_4__["useUserContext"])();
  const [observable] = Object(_magento_peregrine_lib_context_eventing__WEBPACK_IMPORTED_MODULE_2__["useEventingContext"])();
  const storeConfigQuery = Object(_magento_peregrine_lib_hooks_useAwaitQuery__WEBPACK_IMPORTED_MODULE_3__["useAwaitQuery"])(_storeConfigQuery_gql__WEBPACK_IMPORTED_MODULE_7__["default"]);
  Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(() => {
    Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(null, /*! @adobe/magento-storefront-events-sdk */ "@adobe/magento-storefront-events-sdk", 7)).then(mse => {
      if (!window.magentoStorefrontEvents) {
        window.magentoStorefrontEvents = mse;
      }

      mse.context.setEventForwarding({
        aep: aep !== null,
        commerce: acds
      });

      if (aep) {
        mse.context.setAEP({
          imsOrgId: aep.orgId,
          datastreamId: aep.datastreamId
        });
      } // load the collector after the sdk to make sure that
      // the AEP context is set before the connector initializes


      Promise.resolve(/*! import() */).then(__webpack_require__.t.bind(null, /*! @adobe/magento-storefront-event-collector */ "@adobe/magento-storefront-event-collector", 7)).then(() => setSdk(mse)); // initialise the storefrontInstance context with some basic data that do not
      // depend on the dataServiceStorefrontInstanceContext query

      storeConfigQuery().then(({
        data
      }) => mse.context.setStorefrontInstance({
        storeViewCurrencyCode: data.storeConfig.base_currency_code,
        baseCurrencyCode: data.storeConfig.base_currency_code
      }));
    });
  }, []);
  Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(() => {
    if (sdk) {
      Object(_processors__WEBPACK_IMPORTED_MODULE_6__["default"])(sdk);
      const sub = observable.subscribe(async event => {
        Object(_magento_experience_platform_connector_src_handleEvent__WEBPACK_IMPORTED_MODULE_5__["default"])(sdk, event);
      });
      return () => {
        sub.unsubscribe();
      };
    }
  }, [sdk, observable]); // Sets shopper context on initial load (when shopper context is null)

  Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(() => {
    if (sdk && !sdk.context.getShopper()) {
      if (isSignedIn) {
        sdk.context.setShopper({
          shopperId: 'logged-in'
        });
        sdk.context.setAccount({
          firstName: currentUser.firstname,
          lastName: currentUser.lastname,
          emailAddress: currentUser.email,
          accountType: currentUser.__typename
        });
      } else {
        sdk.context.setShopper({
          shopperId: 'guest'
        });
      }
    }
  }, [sdk, isSignedIn, currentUser]);
  const contextValue = [{
    sdk
  }, {}];
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(EventCollectorContext.Provider, {
    value: contextValue
  }, props.children);
};
EventCollectorContextProvider.propTypes = {
  acds: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.bool,
  aep: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.shape({
    orgId: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired,
    datastreamId: prop_types__WEBPACK_IMPORTED_MODULE_1___default.a.string.isRequired
  })
};
const useEventCollectorContext = () => Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(EventCollectorContext);

/***/ }),

/***/ "./src/events-collector/index.js":
/*!***************************************!*\
  !*** ./src/events-collector/index.js ***!
  \***************************************/
/*! exports provided: EventCollectorContextProvider, useEventCollectorContext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EventCollectorContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventCollectorContext */ "./src/events-collector/EventCollectorContext.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EventCollectorContextProvider", function() { return _EventCollectorContext__WEBPACK_IMPORTED_MODULE_0__["EventCollectorContextProvider"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "useEventCollectorContext", function() { return _EventCollectorContext__WEBPACK_IMPORTED_MODULE_0__["useEventCollectorContext"]; });

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/


/***/ }),

/***/ "./src/events-collector/processors/index.js":
/*!**************************************************!*\
  !*** ./src/events-collector/processors/index.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _processCategoryStorefrontData__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./processCategoryStorefrontData */ "./src/events-collector/processors/processCategoryStorefrontData.js");
/* harmony import */ var _processProductStorefrontData__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./processProductStorefrontData */ "./src/events-collector/processors/processProductStorefrontData.js");
/* harmony import */ var _processSearchInputStorefrontData__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./processSearchInputStorefrontData */ "./src/events-collector/processors/processSearchInputStorefrontData.js");
/* harmony import */ var _processSearchResultsStorefrontData__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./processSearchResultsStorefrontData */ "./src/events-collector/processors/processSearchResultsStorefrontData.js");
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/




/* harmony default export */ __webpack_exports__["default"] = (mse => {
  Object(_processCategoryStorefrontData__WEBPACK_IMPORTED_MODULE_0__["processCategoryStorefrontData"])(mse);
  Object(_processProductStorefrontData__WEBPACK_IMPORTED_MODULE_1__["processProductStorefrontData"])(mse);
  Object(_processSearchInputStorefrontData__WEBPACK_IMPORTED_MODULE_2__["processSearchInputStorefrontData"])(mse);
  Object(_processSearchResultsStorefrontData__WEBPACK_IMPORTED_MODULE_3__["processSearchResultsStorefrontData"])(mse);
});

/***/ }),

/***/ "./src/events-collector/processors/processCategoryStorefrontData.js":
/*!**************************************************************************!*\
  !*** ./src/events-collector/processors/processCategoryStorefrontData.js ***!
  \**************************************************************************/
/*! exports provided: processCategoryStorefrontData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processCategoryStorefrontData", function() { return processCategoryStorefrontData; });
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
const processCategoryStorefrontData = mse => {
  const categoryCtxElement = document.querySelector('[data-cif-category-context]');

  if (categoryCtxElement) {
    try {
      const categoryCtx = JSON.parse(categoryCtxElement.dataset.cifCategoryContext);
      mse.context.setCategory(categoryCtx);
    } catch (e) {
      console.error(e);
    }
  }
};

/***/ }),

/***/ "./src/events-collector/processors/processProductStorefrontData.js":
/*!*************************************************************************!*\
  !*** ./src/events-collector/processors/processProductStorefrontData.js ***!
  \*************************************************************************/
/*! exports provided: processProductStorefrontData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processProductStorefrontData", function() { return processProductStorefrontData; });
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
const processProductStorefrontData = mse => {
  const productCtxElement = document.querySelector('[data-cif-product-context]');

  if (productCtxElement) {
    try {
      const productCtx = JSON.parse(productCtxElement.dataset.cifProductContext);
      mse.context.setProduct(productCtx);
      mse.publish.productPageView();
    } catch (e) {
      console.error(e);
    }
  }
};

/***/ }),

/***/ "./src/events-collector/processors/processSearchInputStorefrontData.js":
/*!*****************************************************************************!*\
  !*** ./src/events-collector/processors/processSearchInputStorefrontData.js ***!
  \*****************************************************************************/
/*! exports provided: processSearchInputStorefrontData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processSearchInputStorefrontData", function() { return processSearchInputStorefrontData; });
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
const processSearchInputStorefrontData = mse => {
  const searchInputCtxElement = document.querySelector('[data-cif-search-input-context]');

  if (searchInputCtxElement) {
    try {
      const searchInputCtx = JSON.parse(searchInputCtxElement.dataset.cifSearchInputContext);
      mse.context.setSearchInput({
        units: [searchInputCtx]
      });
      mse.publish.searchRequestSent(searchInputCtx.searchUnitId);
    } catch (e) {
      console.error(e);
    }
  }
};

/***/ }),

/***/ "./src/events-collector/processors/processSearchResultsStorefrontData.js":
/*!*******************************************************************************!*\
  !*** ./src/events-collector/processors/processSearchResultsStorefrontData.js ***!
  \*******************************************************************************/
/*! exports provided: processSearchResultsStorefrontData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processSearchResultsStorefrontData", function() { return processSearchResultsStorefrontData; });
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
const processSearchResultsStorefrontData = mse => {
  const searchResultsCtxElement = document.querySelector('[data-cif-search-results-context]');

  if (searchResultsCtxElement) {
    try {
      const searchResultsUnit = JSON.parse(searchResultsCtxElement.dataset.cifSearchResultsContext);
      const searchResultsCtx = {
        units: [searchResultsUnit]
      };
      mse.context.setSearchResults(searchResultsCtx);
      mse.publish.searchResponseReceived(searchResultsUnit.searchUnitId, searchResultsCtx);
    } catch (e) {
      console.error(e);
    }
  }
};

/***/ }),

/***/ "./src/events-collector/storeConfigQuery.gql.js":
/*!******************************************************!*\
  !*** ./src/events-collector/storeConfigQuery.gql.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _apollo_client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @apollo/client */ "@apollo/client");
/* harmony import */ var _apollo_client__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_apollo_client__WEBPACK_IMPORTED_MODULE_0__);
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/* harmony default export */ __webpack_exports__["default"] = (_apollo_client__WEBPACK_IMPORTED_MODULE_0__["gql"]`
    query StoreConfigQuery {
        storeConfig {
            base_currency_code
            store_code
        }
    }
`);

/***/ }),

/***/ "./src/index.js":
/*!**********************!*\
  !*** ./src/index.js ***!
  \**********************/
/*! exports provided: EventCollectorContextProvider, useEventCollectorContext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _events_collector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./events-collector */ "./src/events-collector/index.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EventCollectorContextProvider", function() { return _events_collector__WEBPACK_IMPORTED_MODULE_0__["EventCollectorContextProvider"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "useEventCollectorContext", function() { return _events_collector__WEBPACK_IMPORTED_MODULE_0__["useEventCollectorContext"]; });

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2022 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/


/***/ }),

/***/ "@adobe/magento-storefront-event-collector":
/*!************************************************************!*\
  !*** external "@adobe/magento-storefront-event-collector" ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@adobe/magento-storefront-event-collector");

/***/ }),

/***/ "@adobe/magento-storefront-events-sdk":
/*!*******************************************************!*\
  !*** external "@adobe/magento-storefront-events-sdk" ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@adobe/magento-storefront-events-sdk");

/***/ }),

/***/ "@apollo/client":
/*!*********************************!*\
  !*** external "@apollo/client" ***!
  \*********************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@apollo/client");

/***/ }),

/***/ "@magento/peregrine/lib/context/eventing":
/*!**********************************************************!*\
  !*** external "@magento/peregrine/lib/context/eventing" ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@magento/peregrine/lib/context/eventing");

/***/ }),

/***/ "@magento/peregrine/lib/context/user":
/*!******************************************************!*\
  !*** external "@magento/peregrine/lib/context/user" ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@magento/peregrine/lib/context/user");

/***/ }),

/***/ "@magento/peregrine/lib/hooks/useAwaitQuery":
/*!*************************************************************!*\
  !*** external "@magento/peregrine/lib/hooks/useAwaitQuery" ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("@magento/peregrine/lib/hooks/useAwaitQuery");

/***/ }),

/***/ "react":
/*!************************!*\
  !*** external "react" ***!
  \************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("react");

/***/ })

/******/ });
});
//# sourceMappingURL=index.js.map