/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2019 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
import React, { useContext, useState } from 'react';
import PropTypes from 'prop-types';

export const ConfigContext = React.createContext();

const ConfigContextProvider = props => {
    const [config] = useState(props.config);

    return <ConfigContext.Provider value={config}>{props.children}</ConfigContext.Provider>;
};

ConfigContextProvider.propTypes = {
    config: PropTypes.shape({
        storeView: PropTypes.string,
        headers: PropTypes.object,
        graphqlEndpoint: PropTypes.string.isRequired,
        graphqlMethod: PropTypes.oneOf(['GET', 'POST']).isRequired,
        mountingPoints: PropTypes.shape({
            accountContainer: PropTypes.string,
            addressBookContainer: PropTypes.string,
            authBarContainer: PropTypes.string,
            cartTrigger: PropTypes.string,
            minicart: PropTypes.string,
            navPanel: PropTypes.string,
            bundleProductOptionsContainer: PropTypes.string,
            giftCardProductOptionsContainer: PropTypes.string,
            accountDetails: PropTypes.string,
            resetPasswordPage: PropTypes.string,
            productRecs: PropTypes.string,
            cartDetailsContainer: PropTypes.string,
            checkoutPageContainer: PropTypes.string
        }),
        pagePaths: PropTypes.shape({
            addressBook: PropTypes.string,
            baseUrl: PropTypes.string,
            accountDetails: PropTypes.string,
            cartDetails: PropTypes.string,
            resetPassword: PropTypes.string,
            checkoutPage: PropTypes.string
        })
    }).isRequired
};

export default ConfigContextProvider;

export const useConfigContext = () => useContext(ConfigContext);
