/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2019 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
import React from 'react';
import { X as CloseIcon } from 'react-feather';
import { useIntl } from 'react-intl';

import classes from './header.css';
import { useCartState } from './cartContext';

/**
 * @deprecated replace with peregrine backed component, will be removed with CIF 3.0 latest
 */
const Header = () => {
    const [, dispatch] = useCartState();
    const intl = useIntl();

    return (
        <div className={classes.root}>
            <h2 className={classes.title}>
                {intl.formatMessage({ id: 'cart:shopping-cart', defaultMessage: 'Shopping Cart' })}
            </h2>
            <button
                onClick={() => {
                    dispatch({ type: 'close' });
                }}>
                <CloseIcon />
            </button>
        </div>
    );
};

export default Header;
