/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ~ Copyright 2019 Adobe
 ~
 ~ Licensed under the Apache License, Version 2.0 (the "License");
 ~ you may not use this file except in compliance with the License.
 ~ You may obtain a copy of the License at
 ~
 ~     http://www.apache.org/licenses/LICENSE-2.0
 ~
 ~ Unless required by applicable law or agreed to in writing, software
 ~ distributed under the License is distributed on an "AS IS" BASIS,
 ~ WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ~ See the License for the specific language governing permissions and
 ~ limitations under the License.
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
import React, { Fragment } from 'react';
import { shape, string } from 'prop-types';
import { useIntl } from 'react-intl';

import { useCheckoutState } from './checkoutContext';

/**
 * @deprecated replace with peregrine backed component, will be removed with CIF 3.0 latest
 */
const ShippingAddressSummary = props => {
    const { classes } = props;
    const [{ shippingAddress }] = useCheckoutState();
    const intl = useIntl();

    if (!shippingAddress) {
        return (
            <span className={classes.informationPrompt}>
                {intl.formatMessage({
                    id: 'checkout:add-shipping-information',
                    defaultMessage: 'Add Shipping Information'
                })}
            </span>
        );
    }

    const name = `${shippingAddress.firstname} ${shippingAddress.lastname}`;
    const street = shippingAddress.street.join(' ');

    return (
        <Fragment>
            <strong>{name}</strong>
            <br />
            <span>{street}</span>
        </Fragment>
    );
};

ShippingAddressSummary.propTypes = {
    classes: shape({
        informationPrompt: string
    })
};

export default ShippingAddressSummary;
