# Contribution guidelines for Chatty

First off, a huge thank you for considering contributing to Chatty! We're incredibly grateful for your interest in making this project even better.

> Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, we will reciprocate that respect by addressing your issue and assisting you finalize your pull requests.

# Your first contribution

Following these guidelines ensures a smooth and efficient process for everyone involved. It shows respect for the developers' time and helps us quickly address your valuable contributions. To contribute:

1. Create your own fork of the repository
2. Do the changes in your fork
3. Open a pull request when you feel like the changes are finished.

This lets us review your work and discuss any necessary adjustments.

> Make sure to follow a [semantic commit message](https://gist.github.com/joshbuchea/6f47e86d2510bce28f8e7f42ae84c716) style.
>
> Example of a PR:

> ```
> feat: add voice input support
> ^--^  ^------------^
> |     |
> |     +-> Summary in present tense.
> |
> +-------> Type: feat, fix, refactor, style, chore, docs or test.```
>
> First time opening a PR? Check [this](https://makeapullrequest.com/) out.

# Suggest a feature, enhancement or bug

You will find the current roadmap in the readme of the repository. If you wish to suggest a feature or enhancement, make sure to open an issue first. We'll then most likely include this in the readme file.

Thank you again for your contribution! 🎉
