// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: NeuralNetwork.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

// Copyright (c) 2017-2019, Apple Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-3-clause license that can be
// found in LICENSE.txt or at https://opensource.org/licenses/BSD-3-Clause

//*
// A neural network is defined through a collection of layers
// and represents a directed acyclic graph (DAG).
// Each layer has a name, a layer type,
// a list of input names, a list of output names,
// and a collection of parameters specific to the layer type.
//
// The graph structure and connectivity of the neural network
// is inferred from the input and output names.
// A neural network starts with the layer
// whose input name is equal to the value specified in
// ``Model.description.input.name``,
// and ends with the layer
// whose output name is equal to the value specified in
// ``Model.description.output.name``.
// Layers must have unique input and output names,
// and a layer may not have input or output names that
// refer to layers that are not yet defined.
//
// For Core ML specification version <=3,
// all inputs are mapped to static rank 5 tensors, with axis notations
// [Sequence, Batch, Channel, Height, Width].
//
// From specification version 4 onwards (iOS >= 13, macOS >= 10.15), more options are available
// (see enums ``NeuralNetworkMultiArrayShapeMapping``, ``NeuralNetworkImageShapeMapping``)
// to map inputs to generic N-Dimensional (or N rank) tensors, where N >= 1.
//
// Each layer type may have specific constraints on the ranks of its inputs and outputs.
//
// Some of the layers (such as softmax, reduce, etc) have parameters that have been described in
// terms of notational axis "Channel", "Height", "Width" or "Sequence". They can be re-interpreted easily in
// the general ND setting by using the following rule:
// "width" is same as axis = -1 (i.e. the last axis from the end)
// "height" is same as axis = -2 (i.e. the second last axis from the end)
// "channel" is same as axis = -3 (i.e. the third last axis from the end)
// "sequence" is same as axis = -5 (i.e. the fifth last axis from the end)
//
// Several layers are available in 3 different variations, with the names ending
// in identifiers: ``like``, ``static`` and ``dynamic``. For instance, ``FillLike``,
// ``FillStatic`` and ``FillDynamic``. The ``static`` variation generally will have
// a property corresponding to the shape of the output. For instance, if the
// output of the ``FillStatic`` layer is desired to be of shape (10, 4), the
// property ``targetShape`` will have to be set to [10, 4]. In the ``dynamic`` case,
// the shape is an input, hence it can be changed at runtime. For instance, for
// a ``FillDynamic`` layer, the input would have to be an array containing the
// values 10 and 4, if the desired output is of shape (10, 4). Whereas in the
// ``like`` case, the additional input's shape is used as the output shape, ignoring
// its values. For instance, for a ``FillLike`` layer, for an input with shape
// (10, 4), the output generated will also be of shape (10, 4), values of the
// input will be ignored.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

enum CoreML_Specification_NeuralNetworkMultiArrayShapeMapping: SwiftProtobuf.Enum {
  typealias RawValue = Int

  ///
  /// Default legacy value. Only supported for Core ML Specification version <= 3.
  ///
  /// The default legacy shape mapping resolves all input shapes to a rank 5 equivalent
  /// with axis notation of [Seq, Batch, Channel, Height, Width].
  ///
  /// When this enum value is selected,
  /// the repeated shape field in the message "ArrayFeatureType" in feature types proto,
  /// must be either length 1 or length 3.
  ///
  /// The following rule is used to map the values in the shape field to the actual tensor shape:
  /// rank 1 shape is mapped to shape [1,1,C,1,1]
  /// rank 3 shape is mapped to shape [1,1,C,H,W]
  /// At runtime, the first two dimensions (Seq or Batch) can be presented as well, with non-1 values.
  ///
  /// It is invalid to use this enum value if any of the layers added
  /// Specification version 4 (iOS >= 13, macOS >= 10.15) onwards are used in the network.
  /// Validator will raise an error in that case.
  case rank5ArrayMapping // = 0

  ///
  /// The exact shape and rank (i.e. number of dimensions in the shape) of the input,
  /// as specified in the message "ArrayFeatureType", is passed through to the layers.
  /// Supported only for Specification version >= 4 (iOS >= 13, macOS >= 10.15).
  case exactArrayMapping // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .rank5ArrayMapping
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .rank5ArrayMapping
    case 1: self = .exactArrayMapping
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .rank5ArrayMapping: return 0
    case .exactArrayMapping: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension CoreML_Specification_NeuralNetworkMultiArrayShapeMapping: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_NeuralNetworkMultiArrayShapeMapping] = [
    .rank5ArrayMapping,
    .exactArrayMapping,
  ]
}

#endif  // swift(>=4.2)

enum CoreML_Specification_NeuralNetworkImageShapeMapping: SwiftProtobuf.Enum {
  typealias RawValue = Int

  ///
  /// In this case, image input is mapped to a rank 5 tensor.
  /// For Color images, input tensor is shaped as [1,1,3,H,W].
  /// For Gray images, input tensor is shaped as [1,1,1,H,W].
  case rank5ImageMapping // = 0

  ///
  /// For Color images, input tensor is shaped as [1,3,H,W].
  /// For Gray images, input tensor is shaped as [1,1,H,W].
  /// Supported only for Specification version >= 4 (iOS >= 13, macOS >= 10.15).
  case rank4ImageMapping // = 1
  case UNRECOGNIZED(Int)

  init() {
    self = .rank5ImageMapping
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .rank5ImageMapping
    case 1: self = .rank4ImageMapping
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .rank5ImageMapping: return 0
    case .rank4ImageMapping: return 1
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension CoreML_Specification_NeuralNetworkImageShapeMapping: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_NeuralNetworkImageShapeMapping] = [
    .rank5ImageMapping,
    .rank4ImageMapping,
  ]
}

#endif  // swift(>=4.2)

///
/// Scatter accumulation mode.
enum CoreML_Specification_ScatterMode: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case scatterUpdate // = 0

  //// add
  case scatterAdd // = 1

  //// subtract
  case scatterSub // = 2

  //// multiply
  case scatterMul // = 3

  //// divide
  case scatterDiv // = 4

  //// maximum
  case scatterMax // = 5

  //// minimum
  case scatterMin // = 6
  case UNRECOGNIZED(Int)

  init() {
    self = .scatterUpdate
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .scatterUpdate
    case 1: self = .scatterAdd
    case 2: self = .scatterSub
    case 3: self = .scatterMul
    case 4: self = .scatterDiv
    case 5: self = .scatterMax
    case 6: self = .scatterMin
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .scatterUpdate: return 0
    case .scatterAdd: return 1
    case .scatterSub: return 2
    case .scatterMul: return 3
    case .scatterDiv: return 4
    case .scatterMax: return 5
    case .scatterMin: return 6
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension CoreML_Specification_ScatterMode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_ScatterMode] = [
    .scatterUpdate,
    .scatterAdd,
    .scatterSub,
    .scatterMul,
    .scatterDiv,
    .scatterMax,
    .scatterMin,
  ]
}

#endif  // swift(>=4.2)

///*
///A neural network.
struct CoreML_Specification_NeuralNetwork {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var layers: [CoreML_Specification_NeuralNetworkLayer] = []

  var preprocessing: [CoreML_Specification_NeuralNetworkPreprocessing] = []

  /// use this enum value to determine the input tensor shapes to the neural network, for multiarray inputs
  var arrayInputShapeMapping: CoreML_Specification_NeuralNetworkMultiArrayShapeMapping = .rank5ArrayMapping

  /// use this enum value to determine the input tensor shapes to the neural network, for image inputs
  var imageInputShapeMapping: CoreML_Specification_NeuralNetworkImageShapeMapping = .rank5ImageMapping

  var updateParams: CoreML_Specification_NetworkUpdateParameters {
    get {return _updateParams ?? CoreML_Specification_NetworkUpdateParameters()}
    set {_updateParams = newValue}
  }
  /// Returns true if `updateParams` has been explicitly set.
  var hasUpdateParams: Bool {return self._updateParams != nil}
  /// Clears the value of `updateParams`. Subsequent reads from it will return its default value.
  mutating func clearUpdateParams() {self._updateParams = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _updateParams: CoreML_Specification_NetworkUpdateParameters? = nil
}

///*
/// A neural network preprocessor that
/// performs a scalar multiplication of an image
/// followed by addition of scalar biases to the channels.
///
/// Input: X
///    An image in BGR or RGB format with shape ``[3, H, W]``
///    or in grayscale format with shape ``[1, H, W]``.
/// Output: Y
///    An image with format and shape corresponding to the input.
///
/// If the input image is in BGR format:
///
/// .. code::
///
///     Y[0, :, :] = channelScale * X[0, :, :] + blueBias
///     Y[1, :, :] = channelScale * X[1, :, :] + greenBias
///     Y[2, :, :] = channelScale * X[2, :, :] + redBias
///
/// If the input image is in RGB format:
///
/// .. code::
///
///     Y[0, :, :] = channelScale * X[0, :, :] + redBias
///     Y[1, :, :] = channelScale * X[1, :, :] + greenBias
///     Y[2, :, :] = channelScale * X[2, :, :] + blueBias
///
/// If the input image is in grayscale format:
///
/// .. code::
///
///     Y[0, :, :] = channelScale * X[0, :, :] + grayBias
struct CoreML_Specification_NeuralNetworkImageScaler {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ////Scalar to be multiplied.
  var channelScale: Float = 0

  ////Scalar blue bias to be added.
  var blueBias: Float = 0

  ////Scalar green bias to be added.
  var greenBias: Float = 0

  ////Scalar red bias to be added.
  var redBias: Float = 0

  ////Scalar bias to be added for grayscale images.
  var grayBias: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A neural network preprocessor that
/// subtracts the provided mean image from the input image.
/// The mean image is subtracted from the input named
/// ``NeuralNetworkPreprocessing.featureName``.
struct CoreML_Specification_NeuralNetworkMeanImage {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Mean image stored as a flattened array of floats,
  /// representing shape [Channel,Height,Width].
  var meanImage: [Float] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

//// Preprocessing parameters for image inputs.
struct CoreML_Specification_NeuralNetworkPreprocessing {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// must be equal to the input name to which the preprocessing is applied
  var featureName: String = String()

  var preprocessor: CoreML_Specification_NeuralNetworkPreprocessing.OneOf_Preprocessor? = nil

  var scaler: CoreML_Specification_NeuralNetworkImageScaler {
    get {
      if case .scaler(let v)? = preprocessor {return v}
      return CoreML_Specification_NeuralNetworkImageScaler()
    }
    set {preprocessor = .scaler(newValue)}
  }

  var meanImage: CoreML_Specification_NeuralNetworkMeanImage {
    get {
      if case .meanImage(let v)? = preprocessor {return v}
      return CoreML_Specification_NeuralNetworkMeanImage()
    }
    set {preprocessor = .meanImage(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Preprocessor: Equatable {
    case scaler(CoreML_Specification_NeuralNetworkImageScaler)
    case meanImage(CoreML_Specification_NeuralNetworkMeanImage)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_NeuralNetworkPreprocessing.OneOf_Preprocessor, rhs: CoreML_Specification_NeuralNetworkPreprocessing.OneOf_Preprocessor) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.scaler, .scaler): return {
        guard case .scaler(let l) = lhs, case .scaler(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.meanImage, .meanImage): return {
        guard case .meanImage(let l) = lhs, case .meanImage(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}
}

///*
/// A rectified linear unit (ReLU) activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \text{max}(0, x)
struct CoreML_Specification_ActivationReLU {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A leaky rectified linear unit (ReLU) activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \begin{cases}
///             x      & \text{if } x \geq 0 \\
///             \alpha x & \text{if } x < 0
///            \end{cases}
struct CoreML_Specification_ActivationLeakyReLU {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///negative slope value for leakyReLU
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A hyperbolic tangent activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \dfrac{1 - e^{-2x}}{1 + e^{-2x}}
struct CoreML_Specification_ActivationTanh {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A scaled hyperbolic tangent activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \alpha \tanh(\beta x)
struct CoreML_Specification_ActivationScaledTanh {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var beta: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A sigmoid activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \dfrac{1}{1 + e^{-x}}
struct CoreML_Specification_ActivationSigmoid {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A linear activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \alpha x + \beta
struct CoreML_Specification_ActivationLinear {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var beta: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A hard sigmoid activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \text{min}(\text{max}(\alpha x + \beta, 0), 1)
struct CoreML_Specification_ActivationSigmoidHard {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var beta: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A parameterized rectified linear unit (PReLU) activation function.
/// Input must be at least rank 3. Axis = -3 is denoted by "C", or channels.
/// "alpha" parameter can be a vector of length C.
///
/// This function has the following formula:
///
/// .. math::
///    f(x_i) = \begin{cases}
///                 x_i          & \text{if } x_i \geq 0 \\
///                 \alpha_i x_i & \text{if } x_i < 0
///             \end{cases} \;,\;i=1,...,C
struct CoreML_Specification_ActivationPReLU {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// parameter of length C or 1.
  /// If length is 1, same value is used for all channels
  var alpha: CoreML_Specification_WeightParams {
    get {return _alpha ?? CoreML_Specification_WeightParams()}
    set {_alpha = newValue}
  }
  /// Returns true if `alpha` has been explicitly set.
  var hasAlpha: Bool {return self._alpha != nil}
  /// Clears the value of `alpha`. Subsequent reads from it will return its default value.
  mutating func clearAlpha() {self._alpha = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _alpha: CoreML_Specification_WeightParams? = nil
}

///*
/// An exponential linear unit (ELU) activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \begin{cases}
///             x              & \text{if } x \geq 0 \\
///             \alpha (e^x - 1) & \text{if } x < 0
///            \end{cases}
struct CoreML_Specification_ActivationELU {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A thresholded rectified linear unit (ReLU) activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \begin{cases}
///             x & \text{if } x \geq \alpha \\
///             0 & \text{if } x < \alpha
///            \end{cases}
struct CoreML_Specification_ActivationThresholdedReLU {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A softsign activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \dfrac{x}{1 + |x|}
struct CoreML_Specification_ActivationSoftsign {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A softplus activation function.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \text{log}(1 + e^x)
struct CoreML_Specification_ActivationSoftplus {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A parametric softplus activation function.
/// Input must be at least rank 3. axis = -3 is denoted by "C", or channels.
/// "alpha"/"beta" parameter can be a vector of length C.
///
/// This function has the following formula:
///
/// .. math::
///     f(x_i) = \alpha_i \text{log}(1 + e^{\beta_i x_i}) \;,\;i=1,...,C
struct CoreML_Specification_ActivationParametricSoftplus {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// If length is 1, same value is used for all channels
  var alpha: CoreML_Specification_WeightParams {
    get {return _alpha ?? CoreML_Specification_WeightParams()}
    set {_alpha = newValue}
  }
  /// Returns true if `alpha` has been explicitly set.
  var hasAlpha: Bool {return self._alpha != nil}
  /// Clears the value of `alpha`. Subsequent reads from it will return its default value.
  mutating func clearAlpha() {self._alpha = nil}

  ///parameter of length C or 1
  var beta: CoreML_Specification_WeightParams {
    get {return _beta ?? CoreML_Specification_WeightParams()}
    set {_beta = newValue}
  }
  /// Returns true if `beta` has been explicitly set.
  var hasBeta: Bool {return self._beta != nil}
  /// Clears the value of `beta`. Subsequent reads from it will return its default value.
  mutating func clearBeta() {self._beta = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _alpha: CoreML_Specification_WeightParams? = nil
  fileprivate var _beta: CoreML_Specification_WeightParams? = nil
}

struct CoreML_Specification_ActivationParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var nonlinearityType: CoreML_Specification_ActivationParams.OneOf_NonlinearityType? = nil

  var linear: CoreML_Specification_ActivationLinear {
    get {
      if case .linear(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationLinear()
    }
    set {nonlinearityType = .linear(newValue)}
  }

  var reLu: CoreML_Specification_ActivationReLU {
    get {
      if case .reLu(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationReLU()
    }
    set {nonlinearityType = .reLu(newValue)}
  }

  var leakyReLu: CoreML_Specification_ActivationLeakyReLU {
    get {
      if case .leakyReLu(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationLeakyReLU()
    }
    set {nonlinearityType = .leakyReLu(newValue)}
  }

  var thresholdedReLu: CoreML_Specification_ActivationThresholdedReLU {
    get {
      if case .thresholdedReLu(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationThresholdedReLU()
    }
    set {nonlinearityType = .thresholdedReLu(newValue)}
  }

  var preLu: CoreML_Specification_ActivationPReLU {
    get {
      if case .preLu(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationPReLU()
    }
    set {nonlinearityType = .preLu(newValue)}
  }

  var tanh: CoreML_Specification_ActivationTanh {
    get {
      if case .tanh(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationTanh()
    }
    set {nonlinearityType = .tanh(newValue)}
  }

  var scaledTanh: CoreML_Specification_ActivationScaledTanh {
    get {
      if case .scaledTanh(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationScaledTanh()
    }
    set {nonlinearityType = .scaledTanh(newValue)}
  }

  var sigmoid: CoreML_Specification_ActivationSigmoid {
    get {
      if case .sigmoid(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationSigmoid()
    }
    set {nonlinearityType = .sigmoid(newValue)}
  }

  var sigmoidHard: CoreML_Specification_ActivationSigmoidHard {
    get {
      if case .sigmoidHard(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationSigmoidHard()
    }
    set {nonlinearityType = .sigmoidHard(newValue)}
  }

  var elu: CoreML_Specification_ActivationELU {
    get {
      if case .elu(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationELU()
    }
    set {nonlinearityType = .elu(newValue)}
  }

  var softsign: CoreML_Specification_ActivationSoftsign {
    get {
      if case .softsign(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationSoftsign()
    }
    set {nonlinearityType = .softsign(newValue)}
  }

  var softplus: CoreML_Specification_ActivationSoftplus {
    get {
      if case .softplus(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationSoftplus()
    }
    set {nonlinearityType = .softplus(newValue)}
  }

  var parametricSoftplus: CoreML_Specification_ActivationParametricSoftplus {
    get {
      if case .parametricSoftplus(let v)? = nonlinearityType {return v}
      return CoreML_Specification_ActivationParametricSoftplus()
    }
    set {nonlinearityType = .parametricSoftplus(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_NonlinearityType: Equatable {
    case linear(CoreML_Specification_ActivationLinear)
    case reLu(CoreML_Specification_ActivationReLU)
    case leakyReLu(CoreML_Specification_ActivationLeakyReLU)
    case thresholdedReLu(CoreML_Specification_ActivationThresholdedReLU)
    case preLu(CoreML_Specification_ActivationPReLU)
    case tanh(CoreML_Specification_ActivationTanh)
    case scaledTanh(CoreML_Specification_ActivationScaledTanh)
    case sigmoid(CoreML_Specification_ActivationSigmoid)
    case sigmoidHard(CoreML_Specification_ActivationSigmoidHard)
    case elu(CoreML_Specification_ActivationELU)
    case softsign(CoreML_Specification_ActivationSoftsign)
    case softplus(CoreML_Specification_ActivationSoftplus)
    case parametricSoftplus(CoreML_Specification_ActivationParametricSoftplus)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_ActivationParams.OneOf_NonlinearityType, rhs: CoreML_Specification_ActivationParams.OneOf_NonlinearityType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.linear, .linear): return {
        guard case .linear(let l) = lhs, case .linear(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reLu, .reLu): return {
        guard case .reLu(let l) = lhs, case .reLu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.leakyReLu, .leakyReLu): return {
        guard case .leakyReLu(let l) = lhs, case .leakyReLu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.thresholdedReLu, .thresholdedReLu): return {
        guard case .thresholdedReLu(let l) = lhs, case .thresholdedReLu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.preLu, .preLu): return {
        guard case .preLu(let l) = lhs, case .preLu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.tanh, .tanh): return {
        guard case .tanh(let l) = lhs, case .tanh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scaledTanh, .scaledTanh): return {
        guard case .scaledTanh(let l) = lhs, case .scaledTanh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sigmoid, .sigmoid): return {
        guard case .sigmoid(let l) = lhs, case .sigmoid(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sigmoidHard, .sigmoidHard): return {
        guard case .sigmoidHard(let l) = lhs, case .sigmoidHard(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.elu, .elu): return {
        guard case .elu(let l) = lhs, case .elu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.softsign, .softsign): return {
        guard case .softsign(let l) = lhs, case .softsign(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.softplus, .softplus): return {
        guard case .softplus(let l) = lhs, case .softplus(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.parametricSoftplus, .parametricSoftplus): return {
        guard case .parametricSoftplus(let l) = lhs, case .parametricSoftplus(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}
}

///*
/// Representation of the intermediate tensors
struct CoreML_Specification_Tensor {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Number of dimensions in the tensor shape
  var rank: UInt32 = 0

  /// actual value of the tensor shape.
  /// must be of length "rank". Can contain -1s for unknown dimensions.
  var dimValue: [Int64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A single neural network layer.
struct CoreML_Specification_NeuralNetworkLayer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///descriptive name of the layer
  var name: String {
    get {return _storage._name}
    set {_uniqueStorage()._name = newValue}
  }

  var input: [String] {
    get {return _storage._input}
    set {_uniqueStorage()._input = newValue}
  }

  var output: [String] {
    get {return _storage._output}
    set {_uniqueStorage()._output = newValue}
  }

  /// must be the same length as the "input" field
  var inputTensor: [CoreML_Specification_Tensor] {
    get {return _storage._inputTensor}
    set {_uniqueStorage()._inputTensor = newValue}
  }

  /// must be the same length as the "output" field
  var outputTensor: [CoreML_Specification_Tensor] {
    get {return _storage._outputTensor}
    set {_uniqueStorage()._outputTensor = newValue}
  }

  /// Must be set to true to mark the layer as updatable.
  /// If true, the weightParams in the layer's properties must also be set to updatable
  /// If false, the value of the isUpdatable parameter within the layer's weights are ignored
  var isUpdatable: Bool {
    get {return _storage._isUpdatable}
    set {_uniqueStorage()._isUpdatable = newValue}
  }

  var layer: OneOf_Layer? {
    get {return _storage._layer}
    set {_uniqueStorage()._layer = newValue}
  }

  /// Start at 100 here
  var convolution: CoreML_Specification_ConvolutionLayerParams {
    get {
      if case .convolution(let v)? = _storage._layer {return v}
      return CoreML_Specification_ConvolutionLayerParams()
    }
    set {_uniqueStorage()._layer = .convolution(newValue)}
  }

  var pooling: CoreML_Specification_PoolingLayerParams {
    get {
      if case .pooling(let v)? = _storage._layer {return v}
      return CoreML_Specification_PoolingLayerParams()
    }
    set {_uniqueStorage()._layer = .pooling(newValue)}
  }

  var activation: CoreML_Specification_ActivationParams {
    get {
      if case .activation(let v)? = _storage._layer {return v}
      return CoreML_Specification_ActivationParams()
    }
    set {_uniqueStorage()._layer = .activation(newValue)}
  }

  var innerProduct: CoreML_Specification_InnerProductLayerParams {
    get {
      if case .innerProduct(let v)? = _storage._layer {return v}
      return CoreML_Specification_InnerProductLayerParams()
    }
    set {_uniqueStorage()._layer = .innerProduct(newValue)}
  }

  var embedding: CoreML_Specification_EmbeddingLayerParams {
    get {
      if case .embedding(let v)? = _storage._layer {return v}
      return CoreML_Specification_EmbeddingLayerParams()
    }
    set {_uniqueStorage()._layer = .embedding(newValue)}
  }

  /// Normalization-related Layers
  var batchnorm: CoreML_Specification_BatchnormLayerParams {
    get {
      if case .batchnorm(let v)? = _storage._layer {return v}
      return CoreML_Specification_BatchnormLayerParams()
    }
    set {_uniqueStorage()._layer = .batchnorm(newValue)}
  }

  var mvn: CoreML_Specification_MeanVarianceNormalizeLayerParams {
    get {
      if case .mvn(let v)? = _storage._layer {return v}
      return CoreML_Specification_MeanVarianceNormalizeLayerParams()
    }
    set {_uniqueStorage()._layer = .mvn(newValue)}
  }

  var l2Normalize: CoreML_Specification_L2NormalizeLayerParams {
    get {
      if case .l2Normalize(let v)? = _storage._layer {return v}
      return CoreML_Specification_L2NormalizeLayerParams()
    }
    set {_uniqueStorage()._layer = .l2Normalize(newValue)}
  }

  var softmax: CoreML_Specification_SoftmaxLayerParams {
    get {
      if case .softmax(let v)? = _storage._layer {return v}
      return CoreML_Specification_SoftmaxLayerParams()
    }
    set {_uniqueStorage()._layer = .softmax(newValue)}
  }

  var lrn: CoreML_Specification_LRNLayerParams {
    get {
      if case .lrn(let v)? = _storage._layer {return v}
      return CoreML_Specification_LRNLayerParams()
    }
    set {_uniqueStorage()._layer = .lrn(newValue)}
  }

  var crop: CoreML_Specification_CropLayerParams {
    get {
      if case .crop(let v)? = _storage._layer {return v}
      return CoreML_Specification_CropLayerParams()
    }
    set {_uniqueStorage()._layer = .crop(newValue)}
  }

  var padding: CoreML_Specification_PaddingLayerParams {
    get {
      if case .padding(let v)? = _storage._layer {return v}
      return CoreML_Specification_PaddingLayerParams()
    }
    set {_uniqueStorage()._layer = .padding(newValue)}
  }

  var upsample: CoreML_Specification_UpsampleLayerParams {
    get {
      if case .upsample(let v)? = _storage._layer {return v}
      return CoreML_Specification_UpsampleLayerParams()
    }
    set {_uniqueStorage()._layer = .upsample(newValue)}
  }

  var resizeBilinear: CoreML_Specification_ResizeBilinearLayerParams {
    get {
      if case .resizeBilinear(let v)? = _storage._layer {return v}
      return CoreML_Specification_ResizeBilinearLayerParams()
    }
    set {_uniqueStorage()._layer = .resizeBilinear(newValue)}
  }

  var cropResize: CoreML_Specification_CropResizeLayerParams {
    get {
      if case .cropResize(let v)? = _storage._layer {return v}
      return CoreML_Specification_CropResizeLayerParams()
    }
    set {_uniqueStorage()._layer = .cropResize(newValue)}
  }

  var unary: CoreML_Specification_UnaryFunctionLayerParams {
    get {
      if case .unary(let v)? = _storage._layer {return v}
      return CoreML_Specification_UnaryFunctionLayerParams()
    }
    set {_uniqueStorage()._layer = .unary(newValue)}
  }

  /// Element-wise Operations
  var add: CoreML_Specification_AddLayerParams {
    get {
      if case .add(let v)? = _storage._layer {return v}
      return CoreML_Specification_AddLayerParams()
    }
    set {_uniqueStorage()._layer = .add(newValue)}
  }

  var multiply: CoreML_Specification_MultiplyLayerParams {
    get {
      if case .multiply(let v)? = _storage._layer {return v}
      return CoreML_Specification_MultiplyLayerParams()
    }
    set {_uniqueStorage()._layer = .multiply(newValue)}
  }

  var average: CoreML_Specification_AverageLayerParams {
    get {
      if case .average(let v)? = _storage._layer {return v}
      return CoreML_Specification_AverageLayerParams()
    }
    set {_uniqueStorage()._layer = .average(newValue)}
  }

  var scale: CoreML_Specification_ScaleLayerParams {
    get {
      if case .scale(let v)? = _storage._layer {return v}
      return CoreML_Specification_ScaleLayerParams()
    }
    set {_uniqueStorage()._layer = .scale(newValue)}
  }

  var bias: CoreML_Specification_BiasLayerParams {
    get {
      if case .bias(let v)? = _storage._layer {return v}
      return CoreML_Specification_BiasLayerParams()
    }
    set {_uniqueStorage()._layer = .bias(newValue)}
  }

  var max: CoreML_Specification_MaxLayerParams {
    get {
      if case .max(let v)? = _storage._layer {return v}
      return CoreML_Specification_MaxLayerParams()
    }
    set {_uniqueStorage()._layer = .max(newValue)}
  }

  var min: CoreML_Specification_MinLayerParams {
    get {
      if case .min(let v)? = _storage._layer {return v}
      return CoreML_Specification_MinLayerParams()
    }
    set {_uniqueStorage()._layer = .min(newValue)}
  }

  var dot: CoreML_Specification_DotProductLayerParams {
    get {
      if case .dot(let v)? = _storage._layer {return v}
      return CoreML_Specification_DotProductLayerParams()
    }
    set {_uniqueStorage()._layer = .dot(newValue)}
  }

  var reduce: CoreML_Specification_ReduceLayerParams {
    get {
      if case .reduce(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceLayerParams()
    }
    set {_uniqueStorage()._layer = .reduce(newValue)}
  }

  var loadConstant: CoreML_Specification_LoadConstantLayerParams {
    get {
      if case .loadConstant(let v)? = _storage._layer {return v}
      return CoreML_Specification_LoadConstantLayerParams()
    }
    set {_uniqueStorage()._layer = .loadConstant(newValue)}
  }

  /// Data Reorganization
  var reshape: CoreML_Specification_ReshapeLayerParams {
    get {
      if case .reshape(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReshapeLayerParams()
    }
    set {_uniqueStorage()._layer = .reshape(newValue)}
  }

  var flatten: CoreML_Specification_FlattenLayerParams {
    get {
      if case .flatten(let v)? = _storage._layer {return v}
      return CoreML_Specification_FlattenLayerParams()
    }
    set {_uniqueStorage()._layer = .flatten(newValue)}
  }

  var permute: CoreML_Specification_PermuteLayerParams {
    get {
      if case .permute(let v)? = _storage._layer {return v}
      return CoreML_Specification_PermuteLayerParams()
    }
    set {_uniqueStorage()._layer = .permute(newValue)}
  }

  var concat: CoreML_Specification_ConcatLayerParams {
    get {
      if case .concat(let v)? = _storage._layer {return v}
      return CoreML_Specification_ConcatLayerParams()
    }
    set {_uniqueStorage()._layer = .concat(newValue)}
  }

  var split: CoreML_Specification_SplitLayerParams {
    get {
      if case .split(let v)? = _storage._layer {return v}
      return CoreML_Specification_SplitLayerParams()
    }
    set {_uniqueStorage()._layer = .split(newValue)}
  }

  var sequenceRepeat: CoreML_Specification_SequenceRepeatLayerParams {
    get {
      if case .sequenceRepeat(let v)? = _storage._layer {return v}
      return CoreML_Specification_SequenceRepeatLayerParams()
    }
    set {_uniqueStorage()._layer = .sequenceRepeat(newValue)}
  }

  var reorganizeData: CoreML_Specification_ReorganizeDataLayerParams {
    get {
      if case .reorganizeData(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReorganizeDataLayerParams()
    }
    set {_uniqueStorage()._layer = .reorganizeData(newValue)}
  }

  var slice: CoreML_Specification_SliceLayerParams {
    get {
      if case .slice(let v)? = _storage._layer {return v}
      return CoreML_Specification_SliceLayerParams()
    }
    set {_uniqueStorage()._layer = .slice(newValue)}
  }

  /// Recurrent Layers
  var simpleRecurrent: CoreML_Specification_SimpleRecurrentLayerParams {
    get {
      if case .simpleRecurrent(let v)? = _storage._layer {return v}
      return CoreML_Specification_SimpleRecurrentLayerParams()
    }
    set {_uniqueStorage()._layer = .simpleRecurrent(newValue)}
  }

  var gru: CoreML_Specification_GRULayerParams {
    get {
      if case .gru(let v)? = _storage._layer {return v}
      return CoreML_Specification_GRULayerParams()
    }
    set {_uniqueStorage()._layer = .gru(newValue)}
  }

  var uniDirectionalLstm: CoreML_Specification_UniDirectionalLSTMLayerParams {
    get {
      if case .uniDirectionalLstm(let v)? = _storage._layer {return v}
      return CoreML_Specification_UniDirectionalLSTMLayerParams()
    }
    set {_uniqueStorage()._layer = .uniDirectionalLstm(newValue)}
  }

  var biDirectionalLstm: CoreML_Specification_BiDirectionalLSTMLayerParams {
    get {
      if case .biDirectionalLstm(let v)? = _storage._layer {return v}
      return CoreML_Specification_BiDirectionalLSTMLayerParams()
    }
    set {_uniqueStorage()._layer = .biDirectionalLstm(newValue)}
  }

  /// Custom (user-implemented) Layer
  var custom: CoreML_Specification_CustomLayerParams {
    get {
      if case .custom(let v)? = _storage._layer {return v}
      return CoreML_Specification_CustomLayerParams()
    }
    set {_uniqueStorage()._layer = .custom(newValue)}
  }

  /// Control Flow related Layers
  var copy: CoreML_Specification_CopyLayerParams {
    get {
      if case .copy(let v)? = _storage._layer {return v}
      return CoreML_Specification_CopyLayerParams()
    }
    set {_uniqueStorage()._layer = .copy(newValue)}
  }

  var branch: CoreML_Specification_BranchLayerParams {
    get {
      if case .branch(let v)? = _storage._layer {return v}
      return CoreML_Specification_BranchLayerParams()
    }
    set {_uniqueStorage()._layer = .branch(newValue)}
  }

  var loop: CoreML_Specification_LoopLayerParams {
    get {
      if case .loop(let v)? = _storage._layer {return v}
      return CoreML_Specification_LoopLayerParams()
    }
    set {_uniqueStorage()._layer = .loop(newValue)}
  }

  var loopBreak: CoreML_Specification_LoopBreakLayerParams {
    get {
      if case .loopBreak(let v)? = _storage._layer {return v}
      return CoreML_Specification_LoopBreakLayerParams()
    }
    set {_uniqueStorage()._layer = .loopBreak(newValue)}
  }

  var loopContinue: CoreML_Specification_LoopContinueLayerParams {
    get {
      if case .loopContinue(let v)? = _storage._layer {return v}
      return CoreML_Specification_LoopContinueLayerParams()
    }
    set {_uniqueStorage()._layer = .loopContinue(newValue)}
  }

  var rangeStatic: CoreML_Specification_RangeStaticLayerParams {
    get {
      if case .rangeStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RangeStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .rangeStatic(newValue)}
  }

  var rangeDynamic: CoreML_Specification_RangeDynamicLayerParams {
    get {
      if case .rangeDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RangeDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .rangeDynamic(newValue)}
  }

  /// Element-wise Unary Layers
  var clip: CoreML_Specification_ClipLayerParams {
    get {
      if case .clip(let v)? = _storage._layer {return v}
      return CoreML_Specification_ClipLayerParams()
    }
    set {_uniqueStorage()._layer = .clip(newValue)}
  }

  var ceil: CoreML_Specification_CeilLayerParams {
    get {
      if case .ceil(let v)? = _storage._layer {return v}
      return CoreML_Specification_CeilLayerParams()
    }
    set {_uniqueStorage()._layer = .ceil(newValue)}
  }

  var floor: CoreML_Specification_FloorLayerParams {
    get {
      if case .floor(let v)? = _storage._layer {return v}
      return CoreML_Specification_FloorLayerParams()
    }
    set {_uniqueStorage()._layer = .floor(newValue)}
  }

  var sign: CoreML_Specification_SignLayerParams {
    get {
      if case .sign(let v)? = _storage._layer {return v}
      return CoreML_Specification_SignLayerParams()
    }
    set {_uniqueStorage()._layer = .sign(newValue)}
  }

  var round: CoreML_Specification_RoundLayerParams {
    get {
      if case .round(let v)? = _storage._layer {return v}
      return CoreML_Specification_RoundLayerParams()
    }
    set {_uniqueStorage()._layer = .round(newValue)}
  }

  var exp2: CoreML_Specification_Exp2LayerParams {
    get {
      if case .exp2(let v)? = _storage._layer {return v}
      return CoreML_Specification_Exp2LayerParams()
    }
    set {_uniqueStorage()._layer = .exp2(newValue)}
  }

  var sin: CoreML_Specification_SinLayerParams {
    get {
      if case .sin(let v)? = _storage._layer {return v}
      return CoreML_Specification_SinLayerParams()
    }
    set {_uniqueStorage()._layer = .sin(newValue)}
  }

  var cos: CoreML_Specification_CosLayerParams {
    get {
      if case .cos(let v)? = _storage._layer {return v}
      return CoreML_Specification_CosLayerParams()
    }
    set {_uniqueStorage()._layer = .cos(newValue)}
  }

  var tan: CoreML_Specification_TanLayerParams {
    get {
      if case .tan(let v)? = _storage._layer {return v}
      return CoreML_Specification_TanLayerParams()
    }
    set {_uniqueStorage()._layer = .tan(newValue)}
  }

  var asin: CoreML_Specification_AsinLayerParams {
    get {
      if case .asin(let v)? = _storage._layer {return v}
      return CoreML_Specification_AsinLayerParams()
    }
    set {_uniqueStorage()._layer = .asin(newValue)}
  }

  var acos: CoreML_Specification_AcosLayerParams {
    get {
      if case .acos(let v)? = _storage._layer {return v}
      return CoreML_Specification_AcosLayerParams()
    }
    set {_uniqueStorage()._layer = .acos(newValue)}
  }

  var atan: CoreML_Specification_AtanLayerParams {
    get {
      if case .atan(let v)? = _storage._layer {return v}
      return CoreML_Specification_AtanLayerParams()
    }
    set {_uniqueStorage()._layer = .atan(newValue)}
  }

  var sinh: CoreML_Specification_SinhLayerParams {
    get {
      if case .sinh(let v)? = _storage._layer {return v}
      return CoreML_Specification_SinhLayerParams()
    }
    set {_uniqueStorage()._layer = .sinh(newValue)}
  }

  var cosh: CoreML_Specification_CoshLayerParams {
    get {
      if case .cosh(let v)? = _storage._layer {return v}
      return CoreML_Specification_CoshLayerParams()
    }
    set {_uniqueStorage()._layer = .cosh(newValue)}
  }

  var tanh: CoreML_Specification_TanhLayerParams {
    get {
      if case .tanh(let v)? = _storage._layer {return v}
      return CoreML_Specification_TanhLayerParams()
    }
    set {_uniqueStorage()._layer = .tanh(newValue)}
  }

  var asinh: CoreML_Specification_AsinhLayerParams {
    get {
      if case .asinh(let v)? = _storage._layer {return v}
      return CoreML_Specification_AsinhLayerParams()
    }
    set {_uniqueStorage()._layer = .asinh(newValue)}
  }

  var acosh: CoreML_Specification_AcoshLayerParams {
    get {
      if case .acosh(let v)? = _storage._layer {return v}
      return CoreML_Specification_AcoshLayerParams()
    }
    set {_uniqueStorage()._layer = .acosh(newValue)}
  }

  var atanh: CoreML_Specification_AtanhLayerParams {
    get {
      if case .atanh(let v)? = _storage._layer {return v}
      return CoreML_Specification_AtanhLayerParams()
    }
    set {_uniqueStorage()._layer = .atanh(newValue)}
  }

  var erf: CoreML_Specification_ErfLayerParams {
    get {
      if case .erf(let v)? = _storage._layer {return v}
      return CoreML_Specification_ErfLayerParams()
    }
    set {_uniqueStorage()._layer = .erf(newValue)}
  }

  var gelu: CoreML_Specification_GeluLayerParams {
    get {
      if case .gelu(let v)? = _storage._layer {return v}
      return CoreML_Specification_GeluLayerParams()
    }
    set {_uniqueStorage()._layer = .gelu(newValue)}
  }

  /// Element-wise Binary with Broadcasting Support
  var equal: CoreML_Specification_EqualLayerParams {
    get {
      if case .equal(let v)? = _storage._layer {return v}
      return CoreML_Specification_EqualLayerParams()
    }
    set {_uniqueStorage()._layer = .equal(newValue)}
  }

  var notEqual: CoreML_Specification_NotEqualLayerParams {
    get {
      if case .notEqual(let v)? = _storage._layer {return v}
      return CoreML_Specification_NotEqualLayerParams()
    }
    set {_uniqueStorage()._layer = .notEqual(newValue)}
  }

  var lessThan: CoreML_Specification_LessThanLayerParams {
    get {
      if case .lessThan(let v)? = _storage._layer {return v}
      return CoreML_Specification_LessThanLayerParams()
    }
    set {_uniqueStorage()._layer = .lessThan(newValue)}
  }

  var lessEqual: CoreML_Specification_LessEqualLayerParams {
    get {
      if case .lessEqual(let v)? = _storage._layer {return v}
      return CoreML_Specification_LessEqualLayerParams()
    }
    set {_uniqueStorage()._layer = .lessEqual(newValue)}
  }

  var greaterThan: CoreML_Specification_GreaterThanLayerParams {
    get {
      if case .greaterThan(let v)? = _storage._layer {return v}
      return CoreML_Specification_GreaterThanLayerParams()
    }
    set {_uniqueStorage()._layer = .greaterThan(newValue)}
  }

  var greaterEqual: CoreML_Specification_GreaterEqualLayerParams {
    get {
      if case .greaterEqual(let v)? = _storage._layer {return v}
      return CoreML_Specification_GreaterEqualLayerParams()
    }
    set {_uniqueStorage()._layer = .greaterEqual(newValue)}
  }

  var logicalOr: CoreML_Specification_LogicalOrLayerParams {
    get {
      if case .logicalOr(let v)? = _storage._layer {return v}
      return CoreML_Specification_LogicalOrLayerParams()
    }
    set {_uniqueStorage()._layer = .logicalOr(newValue)}
  }

  var logicalXor: CoreML_Specification_LogicalXorLayerParams {
    get {
      if case .logicalXor(let v)? = _storage._layer {return v}
      return CoreML_Specification_LogicalXorLayerParams()
    }
    set {_uniqueStorage()._layer = .logicalXor(newValue)}
  }

  var logicalNot: CoreML_Specification_LogicalNotLayerParams {
    get {
      if case .logicalNot(let v)? = _storage._layer {return v}
      return CoreML_Specification_LogicalNotLayerParams()
    }
    set {_uniqueStorage()._layer = .logicalNot(newValue)}
  }

  var logicalAnd: CoreML_Specification_LogicalAndLayerParams {
    get {
      if case .logicalAnd(let v)? = _storage._layer {return v}
      return CoreML_Specification_LogicalAndLayerParams()
    }
    set {_uniqueStorage()._layer = .logicalAnd(newValue)}
  }

  var modBroadcastable: CoreML_Specification_ModBroadcastableLayerParams {
    get {
      if case .modBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_ModBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .modBroadcastable(newValue)}
  }

  var minBroadcastable: CoreML_Specification_MinBroadcastableLayerParams {
    get {
      if case .minBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_MinBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .minBroadcastable(newValue)}
  }

  var maxBroadcastable: CoreML_Specification_MaxBroadcastableLayerParams {
    get {
      if case .maxBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_MaxBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .maxBroadcastable(newValue)}
  }

  var addBroadcastable: CoreML_Specification_AddBroadcastableLayerParams {
    get {
      if case .addBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_AddBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .addBroadcastable(newValue)}
  }

  var powBroadcastable: CoreML_Specification_PowBroadcastableLayerParams {
    get {
      if case .powBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_PowBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .powBroadcastable(newValue)}
  }

  var divideBroadcastable: CoreML_Specification_DivideBroadcastableLayerParams {
    get {
      if case .divideBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_DivideBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .divideBroadcastable(newValue)}
  }

  var floorDivBroadcastable: CoreML_Specification_FloorDivBroadcastableLayerParams {
    get {
      if case .floorDivBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_FloorDivBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .floorDivBroadcastable(newValue)}
  }

  var multiplyBroadcastable: CoreML_Specification_MultiplyBroadcastableLayerParams {
    get {
      if case .multiplyBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_MultiplyBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .multiplyBroadcastable(newValue)}
  }

  var subtractBroadcastable: CoreML_Specification_SubtractBroadcastableLayerParams {
    get {
      if case .subtractBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_SubtractBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .subtractBroadcastable(newValue)}
  }

  /// Tensor Manipulations
  var tile: CoreML_Specification_TileLayerParams {
    get {
      if case .tile(let v)? = _storage._layer {return v}
      return CoreML_Specification_TileLayerParams()
    }
    set {_uniqueStorage()._layer = .tile(newValue)}
  }

  var stack: CoreML_Specification_StackLayerParams {
    get {
      if case .stack(let v)? = _storage._layer {return v}
      return CoreML_Specification_StackLayerParams()
    }
    set {_uniqueStorage()._layer = .stack(newValue)}
  }

  var gather: CoreML_Specification_GatherLayerParams {
    get {
      if case .gather(let v)? = _storage._layer {return v}
      return CoreML_Specification_GatherLayerParams()
    }
    set {_uniqueStorage()._layer = .gather(newValue)}
  }

  var scatter: CoreML_Specification_ScatterLayerParams {
    get {
      if case .scatter(let v)? = _storage._layer {return v}
      return CoreML_Specification_ScatterLayerParams()
    }
    set {_uniqueStorage()._layer = .scatter(newValue)}
  }

  var gatherNd: CoreML_Specification_GatherNDLayerParams {
    get {
      if case .gatherNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_GatherNDLayerParams()
    }
    set {_uniqueStorage()._layer = .gatherNd(newValue)}
  }

  var scatterNd: CoreML_Specification_ScatterNDLayerParams {
    get {
      if case .scatterNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_ScatterNDLayerParams()
    }
    set {_uniqueStorage()._layer = .scatterNd(newValue)}
  }

  var softmaxNd: CoreML_Specification_SoftmaxNDLayerParams {
    get {
      if case .softmaxNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_SoftmaxNDLayerParams()
    }
    set {_uniqueStorage()._layer = .softmaxNd(newValue)}
  }

  var gatherAlongAxis: CoreML_Specification_GatherAlongAxisLayerParams {
    get {
      if case .gatherAlongAxis(let v)? = _storage._layer {return v}
      return CoreML_Specification_GatherAlongAxisLayerParams()
    }
    set {_uniqueStorage()._layer = .gatherAlongAxis(newValue)}
  }

  var scatterAlongAxis: CoreML_Specification_ScatterAlongAxisLayerParams {
    get {
      if case .scatterAlongAxis(let v)? = _storage._layer {return v}
      return CoreML_Specification_ScatterAlongAxisLayerParams()
    }
    set {_uniqueStorage()._layer = .scatterAlongAxis(newValue)}
  }

  var reverse: CoreML_Specification_ReverseLayerParams {
    get {
      if case .reverse(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReverseLayerParams()
    }
    set {_uniqueStorage()._layer = .reverse(newValue)}
  }

  var reverseSeq: CoreML_Specification_ReverseSeqLayerParams {
    get {
      if case .reverseSeq(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReverseSeqLayerParams()
    }
    set {_uniqueStorage()._layer = .reverseSeq(newValue)}
  }

  var splitNd: CoreML_Specification_SplitNDLayerParams {
    get {
      if case .splitNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_SplitNDLayerParams()
    }
    set {_uniqueStorage()._layer = .splitNd(newValue)}
  }

  var concatNd: CoreML_Specification_ConcatNDLayerParams {
    get {
      if case .concatNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_ConcatNDLayerParams()
    }
    set {_uniqueStorage()._layer = .concatNd(newValue)}
  }

  var transpose: CoreML_Specification_TransposeLayerParams {
    get {
      if case .transpose(let v)? = _storage._layer {return v}
      return CoreML_Specification_TransposeLayerParams()
    }
    set {_uniqueStorage()._layer = .transpose(newValue)}
  }

  var sliceStatic: CoreML_Specification_SliceStaticLayerParams {
    get {
      if case .sliceStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_SliceStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .sliceStatic(newValue)}
  }

  var sliceDynamic: CoreML_Specification_SliceDynamicLayerParams {
    get {
      if case .sliceDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_SliceDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .sliceDynamic(newValue)}
  }

  var slidingWindows: CoreML_Specification_SlidingWindowsLayerParams {
    get {
      if case .slidingWindows(let v)? = _storage._layer {return v}
      return CoreML_Specification_SlidingWindowsLayerParams()
    }
    set {_uniqueStorage()._layer = .slidingWindows(newValue)}
  }

  var topK: CoreML_Specification_TopKLayerParams {
    get {
      if case .topK(let v)? = _storage._layer {return v}
      return CoreML_Specification_TopKLayerParams()
    }
    set {_uniqueStorage()._layer = .topK(newValue)}
  }

  var argMin: CoreML_Specification_ArgMinLayerParams {
    get {
      if case .argMin(let v)? = _storage._layer {return v}
      return CoreML_Specification_ArgMinLayerParams()
    }
    set {_uniqueStorage()._layer = .argMin(newValue)}
  }

  var argMax: CoreML_Specification_ArgMaxLayerParams {
    get {
      if case .argMax(let v)? = _storage._layer {return v}
      return CoreML_Specification_ArgMaxLayerParams()
    }
    set {_uniqueStorage()._layer = .argMax(newValue)}
  }

  var embeddingNd: CoreML_Specification_EmbeddingNDLayerParams {
    get {
      if case .embeddingNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_EmbeddingNDLayerParams()
    }
    set {_uniqueStorage()._layer = .embeddingNd(newValue)}
  }

  var batchedMatmul: CoreML_Specification_BatchedMatMulLayerParams {
    get {
      if case .batchedMatmul(let v)? = _storage._layer {return v}
      return CoreML_Specification_BatchedMatMulLayerParams()
    }
    set {_uniqueStorage()._layer = .batchedMatmul(newValue)}
  }

  /// Tensor Allocation / Reshape-related Operations
  var getShape: CoreML_Specification_GetShapeLayerParams {
    get {
      if case .getShape(let v)? = _storage._layer {return v}
      return CoreML_Specification_GetShapeLayerParams()
    }
    set {_uniqueStorage()._layer = .getShape(newValue)}
  }

  var loadConstantNd: CoreML_Specification_LoadConstantNDLayerParams {
    get {
      if case .loadConstantNd(let v)? = _storage._layer {return v}
      return CoreML_Specification_LoadConstantNDLayerParams()
    }
    set {_uniqueStorage()._layer = .loadConstantNd(newValue)}
  }

  var fillLike: CoreML_Specification_FillLikeLayerParams {
    get {
      if case .fillLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_FillLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .fillLike(newValue)}
  }

  var fillStatic: CoreML_Specification_FillStaticLayerParams {
    get {
      if case .fillStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_FillStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .fillStatic(newValue)}
  }

  var fillDynamic: CoreML_Specification_FillDynamicLayerParams {
    get {
      if case .fillDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_FillDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .fillDynamic(newValue)}
  }

  var broadcastToLike: CoreML_Specification_BroadcastToLikeLayerParams {
    get {
      if case .broadcastToLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_BroadcastToLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .broadcastToLike(newValue)}
  }

  var broadcastToStatic: CoreML_Specification_BroadcastToStaticLayerParams {
    get {
      if case .broadcastToStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_BroadcastToStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .broadcastToStatic(newValue)}
  }

  var broadcastToDynamic: CoreML_Specification_BroadcastToDynamicLayerParams {
    get {
      if case .broadcastToDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_BroadcastToDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .broadcastToDynamic(newValue)}
  }

  var squeeze: CoreML_Specification_SqueezeLayerParams {
    get {
      if case .squeeze(let v)? = _storage._layer {return v}
      return CoreML_Specification_SqueezeLayerParams()
    }
    set {_uniqueStorage()._layer = .squeeze(newValue)}
  }

  var expandDims: CoreML_Specification_ExpandDimsLayerParams {
    get {
      if case .expandDims(let v)? = _storage._layer {return v}
      return CoreML_Specification_ExpandDimsLayerParams()
    }
    set {_uniqueStorage()._layer = .expandDims(newValue)}
  }

  var flattenTo2D: CoreML_Specification_FlattenTo2DLayerParams {
    get {
      if case .flattenTo2D(let v)? = _storage._layer {return v}
      return CoreML_Specification_FlattenTo2DLayerParams()
    }
    set {_uniqueStorage()._layer = .flattenTo2D(newValue)}
  }

  var reshapeLike: CoreML_Specification_ReshapeLikeLayerParams {
    get {
      if case .reshapeLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReshapeLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .reshapeLike(newValue)}
  }

  var reshapeStatic: CoreML_Specification_ReshapeStaticLayerParams {
    get {
      if case .reshapeStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReshapeStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .reshapeStatic(newValue)}
  }

  var reshapeDynamic: CoreML_Specification_ReshapeDynamicLayerParams {
    get {
      if case .reshapeDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReshapeDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .reshapeDynamic(newValue)}
  }

  var rankPreservingReshape: CoreML_Specification_RankPreservingReshapeLayerParams {
    get {
      if case .rankPreservingReshape(let v)? = _storage._layer {return v}
      return CoreML_Specification_RankPreservingReshapeLayerParams()
    }
    set {_uniqueStorage()._layer = .rankPreservingReshape(newValue)}
  }

  var constantPad: CoreML_Specification_ConstantPaddingLayerParams {
    get {
      if case .constantPad(let v)? = _storage._layer {return v}
      return CoreML_Specification_ConstantPaddingLayerParams()
    }
    set {_uniqueStorage()._layer = .constantPad(newValue)}
  }

  /// Random Distributions
  var randomNormalLike: CoreML_Specification_RandomNormalLikeLayerParams {
    get {
      if case .randomNormalLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomNormalLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .randomNormalLike(newValue)}
  }

  var randomNormalStatic: CoreML_Specification_RandomNormalStaticLayerParams {
    get {
      if case .randomNormalStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomNormalStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .randomNormalStatic(newValue)}
  }

  var randomNormalDynamic: CoreML_Specification_RandomNormalDynamicLayerParams {
    get {
      if case .randomNormalDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomNormalDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .randomNormalDynamic(newValue)}
  }

  var randomUniformLike: CoreML_Specification_RandomUniformLikeLayerParams {
    get {
      if case .randomUniformLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomUniformLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .randomUniformLike(newValue)}
  }

  var randomUniformStatic: CoreML_Specification_RandomUniformStaticLayerParams {
    get {
      if case .randomUniformStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomUniformStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .randomUniformStatic(newValue)}
  }

  var randomUniformDynamic: CoreML_Specification_RandomUniformDynamicLayerParams {
    get {
      if case .randomUniformDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomUniformDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .randomUniformDynamic(newValue)}
  }

  var randomBernoulliLike: CoreML_Specification_RandomBernoulliLikeLayerParams {
    get {
      if case .randomBernoulliLike(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomBernoulliLikeLayerParams()
    }
    set {_uniqueStorage()._layer = .randomBernoulliLike(newValue)}
  }

  var randomBernoulliStatic: CoreML_Specification_RandomBernoulliStaticLayerParams {
    get {
      if case .randomBernoulliStatic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomBernoulliStaticLayerParams()
    }
    set {_uniqueStorage()._layer = .randomBernoulliStatic(newValue)}
  }

  var randomBernoulliDynamic: CoreML_Specification_RandomBernoulliDynamicLayerParams {
    get {
      if case .randomBernoulliDynamic(let v)? = _storage._layer {return v}
      return CoreML_Specification_RandomBernoulliDynamicLayerParams()
    }
    set {_uniqueStorage()._layer = .randomBernoulliDynamic(newValue)}
  }

  var categoricalDistribution: CoreML_Specification_CategoricalDistributionLayerParams {
    get {
      if case .categoricalDistribution(let v)? = _storage._layer {return v}
      return CoreML_Specification_CategoricalDistributionLayerParams()
    }
    set {_uniqueStorage()._layer = .categoricalDistribution(newValue)}
  }

  /// Reduction-related Layers:
  var reduceL1: CoreML_Specification_ReduceL1LayerParams {
    get {
      if case .reduceL1(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceL1LayerParams()
    }
    set {_uniqueStorage()._layer = .reduceL1(newValue)}
  }

  var reduceL2: CoreML_Specification_ReduceL2LayerParams {
    get {
      if case .reduceL2(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceL2LayerParams()
    }
    set {_uniqueStorage()._layer = .reduceL2(newValue)}
  }

  var reduceMax: CoreML_Specification_ReduceMaxLayerParams {
    get {
      if case .reduceMax(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceMaxLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceMax(newValue)}
  }

  var reduceMin: CoreML_Specification_ReduceMinLayerParams {
    get {
      if case .reduceMin(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceMinLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceMin(newValue)}
  }

  var reduceSum: CoreML_Specification_ReduceSumLayerParams {
    get {
      if case .reduceSum(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceSumLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceSum(newValue)}
  }

  var reduceProd: CoreML_Specification_ReduceProdLayerParams {
    get {
      if case .reduceProd(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceProdLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceProd(newValue)}
  }

  var reduceMean: CoreML_Specification_ReduceMeanLayerParams {
    get {
      if case .reduceMean(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceMeanLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceMean(newValue)}
  }

  var reduceLogSum: CoreML_Specification_ReduceLogSumLayerParams {
    get {
      if case .reduceLogSum(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceLogSumLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceLogSum(newValue)}
  }

  var reduceSumSquare: CoreML_Specification_ReduceSumSquareLayerParams {
    get {
      if case .reduceSumSquare(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceSumSquareLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceSumSquare(newValue)}
  }

  var reduceLogSumExp: CoreML_Specification_ReduceLogSumExpLayerParams {
    get {
      if case .reduceLogSumExp(let v)? = _storage._layer {return v}
      return CoreML_Specification_ReduceLogSumExpLayerParams()
    }
    set {_uniqueStorage()._layer = .reduceLogSumExp(newValue)}
  }

  /// Masking / Selection Layers
  var whereNonZero: CoreML_Specification_WhereNonZeroLayerParams {
    get {
      if case .whereNonZero(let v)? = _storage._layer {return v}
      return CoreML_Specification_WhereNonZeroLayerParams()
    }
    set {_uniqueStorage()._layer = .whereNonZero(newValue)}
  }

  var matrixBandPart: CoreML_Specification_MatrixBandPartLayerParams {
    get {
      if case .matrixBandPart(let v)? = _storage._layer {return v}
      return CoreML_Specification_MatrixBandPartLayerParams()
    }
    set {_uniqueStorage()._layer = .matrixBandPart(newValue)}
  }

  var lowerTriangular: CoreML_Specification_LowerTriangularLayerParams {
    get {
      if case .lowerTriangular(let v)? = _storage._layer {return v}
      return CoreML_Specification_LowerTriangularLayerParams()
    }
    set {_uniqueStorage()._layer = .lowerTriangular(newValue)}
  }

  var upperTriangular: CoreML_Specification_UpperTriangularLayerParams {
    get {
      if case .upperTriangular(let v)? = _storage._layer {return v}
      return CoreML_Specification_UpperTriangularLayerParams()
    }
    set {_uniqueStorage()._layer = .upperTriangular(newValue)}
  }

  var whereBroadcastable: CoreML_Specification_WhereBroadcastableLayerParams {
    get {
      if case .whereBroadcastable(let v)? = _storage._layer {return v}
      return CoreML_Specification_WhereBroadcastableLayerParams()
    }
    set {_uniqueStorage()._layer = .whereBroadcastable(newValue)}
  }

  /// Normalization Layers
  var layerNormalization: CoreML_Specification_LayerNormalizationLayerParams {
    get {
      if case .layerNormalization(let v)? = _storage._layer {return v}
      return CoreML_Specification_LayerNormalizationLayerParams()
    }
    set {_uniqueStorage()._layer = .layerNormalization(newValue)}
  }

  var nonMaximumSuppression: CoreML_Specification_NonMaximumSuppressionLayerParams {
    get {
      if case .nonMaximumSuppression(let v)? = _storage._layer {return v}
      return CoreML_Specification_NonMaximumSuppressionLayerParams()
    }
    set {_uniqueStorage()._layer = .nonMaximumSuppression(newValue)}
  }

  /// Following layers are available only after Core ML Specification
  /// version >= 5 (iOS >= 14, macOS >= 11.0)
  var oneHot: CoreML_Specification_OneHotLayerParams {
    get {
      if case .oneHot(let v)? = _storage._layer {return v}
      return CoreML_Specification_OneHotLayerParams()
    }
    set {_uniqueStorage()._layer = .oneHot(newValue)}
  }

  var cumSum: CoreML_Specification_CumSumLayerParams {
    get {
      if case .cumSum(let v)? = _storage._layer {return v}
      return CoreML_Specification_CumSumLayerParams()
    }
    set {_uniqueStorage()._layer = .cumSum(newValue)}
  }

  var clampedReLu: CoreML_Specification_ClampedReLULayerParams {
    get {
      if case .clampedReLu(let v)? = _storage._layer {return v}
      return CoreML_Specification_ClampedReLULayerParams()
    }
    set {_uniqueStorage()._layer = .clampedReLu(newValue)}
  }

  var argSort: CoreML_Specification_ArgSortLayerParams {
    get {
      if case .argSort(let v)? = _storage._layer {return v}
      return CoreML_Specification_ArgSortLayerParams()
    }
    set {_uniqueStorage()._layer = .argSort(newValue)}
  }

  var pooling3D: CoreML_Specification_Pooling3DLayerParams {
    get {
      if case .pooling3D(let v)? = _storage._layer {return v}
      return CoreML_Specification_Pooling3DLayerParams()
    }
    set {_uniqueStorage()._layer = .pooling3D(newValue)}
  }

  var globalPooling3D: CoreML_Specification_GlobalPooling3DLayerParams {
    get {
      if case .globalPooling3D(let v)? = _storage._layer {return v}
      return CoreML_Specification_GlobalPooling3DLayerParams()
    }
    set {_uniqueStorage()._layer = .globalPooling3D(newValue)}
  }

  var sliceBySize: CoreML_Specification_SliceBySizeLayerParams {
    get {
      if case .sliceBySize(let v)? = _storage._layer {return v}
      return CoreML_Specification_SliceBySizeLayerParams()
    }
    set {_uniqueStorage()._layer = .sliceBySize(newValue)}
  }

  var convolution3D: CoreML_Specification_Convolution3DLayerParams {
    get {
      if case .convolution3D(let v)? = _storage._layer {return v}
      return CoreML_Specification_Convolution3DLayerParams()
    }
    set {_uniqueStorage()._layer = .convolution3D(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Layer: Equatable {
    /// Start at 100 here
    case convolution(CoreML_Specification_ConvolutionLayerParams)
    case pooling(CoreML_Specification_PoolingLayerParams)
    case activation(CoreML_Specification_ActivationParams)
    case innerProduct(CoreML_Specification_InnerProductLayerParams)
    case embedding(CoreML_Specification_EmbeddingLayerParams)
    /// Normalization-related Layers
    case batchnorm(CoreML_Specification_BatchnormLayerParams)
    case mvn(CoreML_Specification_MeanVarianceNormalizeLayerParams)
    case l2Normalize(CoreML_Specification_L2NormalizeLayerParams)
    case softmax(CoreML_Specification_SoftmaxLayerParams)
    case lrn(CoreML_Specification_LRNLayerParams)
    case crop(CoreML_Specification_CropLayerParams)
    case padding(CoreML_Specification_PaddingLayerParams)
    case upsample(CoreML_Specification_UpsampleLayerParams)
    case resizeBilinear(CoreML_Specification_ResizeBilinearLayerParams)
    case cropResize(CoreML_Specification_CropResizeLayerParams)
    case unary(CoreML_Specification_UnaryFunctionLayerParams)
    /// Element-wise Operations
    case add(CoreML_Specification_AddLayerParams)
    case multiply(CoreML_Specification_MultiplyLayerParams)
    case average(CoreML_Specification_AverageLayerParams)
    case scale(CoreML_Specification_ScaleLayerParams)
    case bias(CoreML_Specification_BiasLayerParams)
    case max(CoreML_Specification_MaxLayerParams)
    case min(CoreML_Specification_MinLayerParams)
    case dot(CoreML_Specification_DotProductLayerParams)
    case reduce(CoreML_Specification_ReduceLayerParams)
    case loadConstant(CoreML_Specification_LoadConstantLayerParams)
    /// Data Reorganization
    case reshape(CoreML_Specification_ReshapeLayerParams)
    case flatten(CoreML_Specification_FlattenLayerParams)
    case permute(CoreML_Specification_PermuteLayerParams)
    case concat(CoreML_Specification_ConcatLayerParams)
    case split(CoreML_Specification_SplitLayerParams)
    case sequenceRepeat(CoreML_Specification_SequenceRepeatLayerParams)
    case reorganizeData(CoreML_Specification_ReorganizeDataLayerParams)
    case slice(CoreML_Specification_SliceLayerParams)
    /// Recurrent Layers
    case simpleRecurrent(CoreML_Specification_SimpleRecurrentLayerParams)
    case gru(CoreML_Specification_GRULayerParams)
    case uniDirectionalLstm(CoreML_Specification_UniDirectionalLSTMLayerParams)
    case biDirectionalLstm(CoreML_Specification_BiDirectionalLSTMLayerParams)
    /// Custom (user-implemented) Layer
    case custom(CoreML_Specification_CustomLayerParams)
    /// Control Flow related Layers
    case copy(CoreML_Specification_CopyLayerParams)
    case branch(CoreML_Specification_BranchLayerParams)
    case loop(CoreML_Specification_LoopLayerParams)
    case loopBreak(CoreML_Specification_LoopBreakLayerParams)
    case loopContinue(CoreML_Specification_LoopContinueLayerParams)
    case rangeStatic(CoreML_Specification_RangeStaticLayerParams)
    case rangeDynamic(CoreML_Specification_RangeDynamicLayerParams)
    /// Element-wise Unary Layers
    case clip(CoreML_Specification_ClipLayerParams)
    case ceil(CoreML_Specification_CeilLayerParams)
    case floor(CoreML_Specification_FloorLayerParams)
    case sign(CoreML_Specification_SignLayerParams)
    case round(CoreML_Specification_RoundLayerParams)
    case exp2(CoreML_Specification_Exp2LayerParams)
    case sin(CoreML_Specification_SinLayerParams)
    case cos(CoreML_Specification_CosLayerParams)
    case tan(CoreML_Specification_TanLayerParams)
    case asin(CoreML_Specification_AsinLayerParams)
    case acos(CoreML_Specification_AcosLayerParams)
    case atan(CoreML_Specification_AtanLayerParams)
    case sinh(CoreML_Specification_SinhLayerParams)
    case cosh(CoreML_Specification_CoshLayerParams)
    case tanh(CoreML_Specification_TanhLayerParams)
    case asinh(CoreML_Specification_AsinhLayerParams)
    case acosh(CoreML_Specification_AcoshLayerParams)
    case atanh(CoreML_Specification_AtanhLayerParams)
    case erf(CoreML_Specification_ErfLayerParams)
    case gelu(CoreML_Specification_GeluLayerParams)
    /// Element-wise Binary with Broadcasting Support
    case equal(CoreML_Specification_EqualLayerParams)
    case notEqual(CoreML_Specification_NotEqualLayerParams)
    case lessThan(CoreML_Specification_LessThanLayerParams)
    case lessEqual(CoreML_Specification_LessEqualLayerParams)
    case greaterThan(CoreML_Specification_GreaterThanLayerParams)
    case greaterEqual(CoreML_Specification_GreaterEqualLayerParams)
    case logicalOr(CoreML_Specification_LogicalOrLayerParams)
    case logicalXor(CoreML_Specification_LogicalXorLayerParams)
    case logicalNot(CoreML_Specification_LogicalNotLayerParams)
    case logicalAnd(CoreML_Specification_LogicalAndLayerParams)
    case modBroadcastable(CoreML_Specification_ModBroadcastableLayerParams)
    case minBroadcastable(CoreML_Specification_MinBroadcastableLayerParams)
    case maxBroadcastable(CoreML_Specification_MaxBroadcastableLayerParams)
    case addBroadcastable(CoreML_Specification_AddBroadcastableLayerParams)
    case powBroadcastable(CoreML_Specification_PowBroadcastableLayerParams)
    case divideBroadcastable(CoreML_Specification_DivideBroadcastableLayerParams)
    case floorDivBroadcastable(CoreML_Specification_FloorDivBroadcastableLayerParams)
    case multiplyBroadcastable(CoreML_Specification_MultiplyBroadcastableLayerParams)
    case subtractBroadcastable(CoreML_Specification_SubtractBroadcastableLayerParams)
    /// Tensor Manipulations
    case tile(CoreML_Specification_TileLayerParams)
    case stack(CoreML_Specification_StackLayerParams)
    case gather(CoreML_Specification_GatherLayerParams)
    case scatter(CoreML_Specification_ScatterLayerParams)
    case gatherNd(CoreML_Specification_GatherNDLayerParams)
    case scatterNd(CoreML_Specification_ScatterNDLayerParams)
    case softmaxNd(CoreML_Specification_SoftmaxNDLayerParams)
    case gatherAlongAxis(CoreML_Specification_GatherAlongAxisLayerParams)
    case scatterAlongAxis(CoreML_Specification_ScatterAlongAxisLayerParams)
    case reverse(CoreML_Specification_ReverseLayerParams)
    case reverseSeq(CoreML_Specification_ReverseSeqLayerParams)
    case splitNd(CoreML_Specification_SplitNDLayerParams)
    case concatNd(CoreML_Specification_ConcatNDLayerParams)
    case transpose(CoreML_Specification_TransposeLayerParams)
    case sliceStatic(CoreML_Specification_SliceStaticLayerParams)
    case sliceDynamic(CoreML_Specification_SliceDynamicLayerParams)
    case slidingWindows(CoreML_Specification_SlidingWindowsLayerParams)
    case topK(CoreML_Specification_TopKLayerParams)
    case argMin(CoreML_Specification_ArgMinLayerParams)
    case argMax(CoreML_Specification_ArgMaxLayerParams)
    case embeddingNd(CoreML_Specification_EmbeddingNDLayerParams)
    case batchedMatmul(CoreML_Specification_BatchedMatMulLayerParams)
    /// Tensor Allocation / Reshape-related Operations
    case getShape(CoreML_Specification_GetShapeLayerParams)
    case loadConstantNd(CoreML_Specification_LoadConstantNDLayerParams)
    case fillLike(CoreML_Specification_FillLikeLayerParams)
    case fillStatic(CoreML_Specification_FillStaticLayerParams)
    case fillDynamic(CoreML_Specification_FillDynamicLayerParams)
    case broadcastToLike(CoreML_Specification_BroadcastToLikeLayerParams)
    case broadcastToStatic(CoreML_Specification_BroadcastToStaticLayerParams)
    case broadcastToDynamic(CoreML_Specification_BroadcastToDynamicLayerParams)
    case squeeze(CoreML_Specification_SqueezeLayerParams)
    case expandDims(CoreML_Specification_ExpandDimsLayerParams)
    case flattenTo2D(CoreML_Specification_FlattenTo2DLayerParams)
    case reshapeLike(CoreML_Specification_ReshapeLikeLayerParams)
    case reshapeStatic(CoreML_Specification_ReshapeStaticLayerParams)
    case reshapeDynamic(CoreML_Specification_ReshapeDynamicLayerParams)
    case rankPreservingReshape(CoreML_Specification_RankPreservingReshapeLayerParams)
    case constantPad(CoreML_Specification_ConstantPaddingLayerParams)
    /// Random Distributions
    case randomNormalLike(CoreML_Specification_RandomNormalLikeLayerParams)
    case randomNormalStatic(CoreML_Specification_RandomNormalStaticLayerParams)
    case randomNormalDynamic(CoreML_Specification_RandomNormalDynamicLayerParams)
    case randomUniformLike(CoreML_Specification_RandomUniformLikeLayerParams)
    case randomUniformStatic(CoreML_Specification_RandomUniformStaticLayerParams)
    case randomUniformDynamic(CoreML_Specification_RandomUniformDynamicLayerParams)
    case randomBernoulliLike(CoreML_Specification_RandomBernoulliLikeLayerParams)
    case randomBernoulliStatic(CoreML_Specification_RandomBernoulliStaticLayerParams)
    case randomBernoulliDynamic(CoreML_Specification_RandomBernoulliDynamicLayerParams)
    case categoricalDistribution(CoreML_Specification_CategoricalDistributionLayerParams)
    /// Reduction-related Layers:
    case reduceL1(CoreML_Specification_ReduceL1LayerParams)
    case reduceL2(CoreML_Specification_ReduceL2LayerParams)
    case reduceMax(CoreML_Specification_ReduceMaxLayerParams)
    case reduceMin(CoreML_Specification_ReduceMinLayerParams)
    case reduceSum(CoreML_Specification_ReduceSumLayerParams)
    case reduceProd(CoreML_Specification_ReduceProdLayerParams)
    case reduceMean(CoreML_Specification_ReduceMeanLayerParams)
    case reduceLogSum(CoreML_Specification_ReduceLogSumLayerParams)
    case reduceSumSquare(CoreML_Specification_ReduceSumSquareLayerParams)
    case reduceLogSumExp(CoreML_Specification_ReduceLogSumExpLayerParams)
    /// Masking / Selection Layers
    case whereNonZero(CoreML_Specification_WhereNonZeroLayerParams)
    case matrixBandPart(CoreML_Specification_MatrixBandPartLayerParams)
    case lowerTriangular(CoreML_Specification_LowerTriangularLayerParams)
    case upperTriangular(CoreML_Specification_UpperTriangularLayerParams)
    case whereBroadcastable(CoreML_Specification_WhereBroadcastableLayerParams)
    /// Normalization Layers
    case layerNormalization(CoreML_Specification_LayerNormalizationLayerParams)
    case nonMaximumSuppression(CoreML_Specification_NonMaximumSuppressionLayerParams)
    /// Following layers are available only after Core ML Specification
    /// version >= 5 (iOS >= 14, macOS >= 11.0)
    case oneHot(CoreML_Specification_OneHotLayerParams)
    case cumSum(CoreML_Specification_CumSumLayerParams)
    case clampedReLu(CoreML_Specification_ClampedReLULayerParams)
    case argSort(CoreML_Specification_ArgSortLayerParams)
    case pooling3D(CoreML_Specification_Pooling3DLayerParams)
    case globalPooling3D(CoreML_Specification_GlobalPooling3DLayerParams)
    case sliceBySize(CoreML_Specification_SliceBySizeLayerParams)
    case convolution3D(CoreML_Specification_Convolution3DLayerParams)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_NeuralNetworkLayer.OneOf_Layer, rhs: CoreML_Specification_NeuralNetworkLayer.OneOf_Layer) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.convolution, .convolution): return {
        guard case .convolution(let l) = lhs, case .convolution(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.pooling, .pooling): return {
        guard case .pooling(let l) = lhs, case .pooling(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.activation, .activation): return {
        guard case .activation(let l) = lhs, case .activation(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.innerProduct, .innerProduct): return {
        guard case .innerProduct(let l) = lhs, case .innerProduct(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.embedding, .embedding): return {
        guard case .embedding(let l) = lhs, case .embedding(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.batchnorm, .batchnorm): return {
        guard case .batchnorm(let l) = lhs, case .batchnorm(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.mvn, .mvn): return {
        guard case .mvn(let l) = lhs, case .mvn(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.l2Normalize, .l2Normalize): return {
        guard case .l2Normalize(let l) = lhs, case .l2Normalize(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.softmax, .softmax): return {
        guard case .softmax(let l) = lhs, case .softmax(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.lrn, .lrn): return {
        guard case .lrn(let l) = lhs, case .lrn(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.crop, .crop): return {
        guard case .crop(let l) = lhs, case .crop(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.padding, .padding): return {
        guard case .padding(let l) = lhs, case .padding(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.upsample, .upsample): return {
        guard case .upsample(let l) = lhs, case .upsample(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.resizeBilinear, .resizeBilinear): return {
        guard case .resizeBilinear(let l) = lhs, case .resizeBilinear(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.cropResize, .cropResize): return {
        guard case .cropResize(let l) = lhs, case .cropResize(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.unary, .unary): return {
        guard case .unary(let l) = lhs, case .unary(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.add, .add): return {
        guard case .add(let l) = lhs, case .add(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.multiply, .multiply): return {
        guard case .multiply(let l) = lhs, case .multiply(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.average, .average): return {
        guard case .average(let l) = lhs, case .average(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scale, .scale): return {
        guard case .scale(let l) = lhs, case .scale(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.bias, .bias): return {
        guard case .bias(let l) = lhs, case .bias(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.max, .max): return {
        guard case .max(let l) = lhs, case .max(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.min, .min): return {
        guard case .min(let l) = lhs, case .min(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.dot, .dot): return {
        guard case .dot(let l) = lhs, case .dot(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduce, .reduce): return {
        guard case .reduce(let l) = lhs, case .reduce(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.loadConstant, .loadConstant): return {
        guard case .loadConstant(let l) = lhs, case .loadConstant(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reshape, .reshape): return {
        guard case .reshape(let l) = lhs, case .reshape(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.flatten, .flatten): return {
        guard case .flatten(let l) = lhs, case .flatten(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.permute, .permute): return {
        guard case .permute(let l) = lhs, case .permute(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.concat, .concat): return {
        guard case .concat(let l) = lhs, case .concat(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.split, .split): return {
        guard case .split(let l) = lhs, case .split(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sequenceRepeat, .sequenceRepeat): return {
        guard case .sequenceRepeat(let l) = lhs, case .sequenceRepeat(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reorganizeData, .reorganizeData): return {
        guard case .reorganizeData(let l) = lhs, case .reorganizeData(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.slice, .slice): return {
        guard case .slice(let l) = lhs, case .slice(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.simpleRecurrent, .simpleRecurrent): return {
        guard case .simpleRecurrent(let l) = lhs, case .simpleRecurrent(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gru, .gru): return {
        guard case .gru(let l) = lhs, case .gru(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.uniDirectionalLstm, .uniDirectionalLstm): return {
        guard case .uniDirectionalLstm(let l) = lhs, case .uniDirectionalLstm(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.biDirectionalLstm, .biDirectionalLstm): return {
        guard case .biDirectionalLstm(let l) = lhs, case .biDirectionalLstm(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.custom, .custom): return {
        guard case .custom(let l) = lhs, case .custom(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.copy, .copy): return {
        guard case .copy(let l) = lhs, case .copy(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.branch, .branch): return {
        guard case .branch(let l) = lhs, case .branch(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.loop, .loop): return {
        guard case .loop(let l) = lhs, case .loop(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.loopBreak, .loopBreak): return {
        guard case .loopBreak(let l) = lhs, case .loopBreak(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.loopContinue, .loopContinue): return {
        guard case .loopContinue(let l) = lhs, case .loopContinue(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.rangeStatic, .rangeStatic): return {
        guard case .rangeStatic(let l) = lhs, case .rangeStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.rangeDynamic, .rangeDynamic): return {
        guard case .rangeDynamic(let l) = lhs, case .rangeDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.clip, .clip): return {
        guard case .clip(let l) = lhs, case .clip(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.ceil, .ceil): return {
        guard case .ceil(let l) = lhs, case .ceil(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.floor, .floor): return {
        guard case .floor(let l) = lhs, case .floor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sign, .sign): return {
        guard case .sign(let l) = lhs, case .sign(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.round, .round): return {
        guard case .round(let l) = lhs, case .round(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.exp2, .exp2): return {
        guard case .exp2(let l) = lhs, case .exp2(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sin, .sin): return {
        guard case .sin(let l) = lhs, case .sin(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.cos, .cos): return {
        guard case .cos(let l) = lhs, case .cos(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.tan, .tan): return {
        guard case .tan(let l) = lhs, case .tan(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.asin, .asin): return {
        guard case .asin(let l) = lhs, case .asin(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.acos, .acos): return {
        guard case .acos(let l) = lhs, case .acos(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.atan, .atan): return {
        guard case .atan(let l) = lhs, case .atan(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sinh, .sinh): return {
        guard case .sinh(let l) = lhs, case .sinh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.cosh, .cosh): return {
        guard case .cosh(let l) = lhs, case .cosh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.tanh, .tanh): return {
        guard case .tanh(let l) = lhs, case .tanh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.asinh, .asinh): return {
        guard case .asinh(let l) = lhs, case .asinh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.acosh, .acosh): return {
        guard case .acosh(let l) = lhs, case .acosh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.atanh, .atanh): return {
        guard case .atanh(let l) = lhs, case .atanh(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.erf, .erf): return {
        guard case .erf(let l) = lhs, case .erf(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gelu, .gelu): return {
        guard case .gelu(let l) = lhs, case .gelu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.equal, .equal): return {
        guard case .equal(let l) = lhs, case .equal(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.notEqual, .notEqual): return {
        guard case .notEqual(let l) = lhs, case .notEqual(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.lessThan, .lessThan): return {
        guard case .lessThan(let l) = lhs, case .lessThan(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.lessEqual, .lessEqual): return {
        guard case .lessEqual(let l) = lhs, case .lessEqual(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.greaterThan, .greaterThan): return {
        guard case .greaterThan(let l) = lhs, case .greaterThan(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.greaterEqual, .greaterEqual): return {
        guard case .greaterEqual(let l) = lhs, case .greaterEqual(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.logicalOr, .logicalOr): return {
        guard case .logicalOr(let l) = lhs, case .logicalOr(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.logicalXor, .logicalXor): return {
        guard case .logicalXor(let l) = lhs, case .logicalXor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.logicalNot, .logicalNot): return {
        guard case .logicalNot(let l) = lhs, case .logicalNot(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.logicalAnd, .logicalAnd): return {
        guard case .logicalAnd(let l) = lhs, case .logicalAnd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.modBroadcastable, .modBroadcastable): return {
        guard case .modBroadcastable(let l) = lhs, case .modBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.minBroadcastable, .minBroadcastable): return {
        guard case .minBroadcastable(let l) = lhs, case .minBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.maxBroadcastable, .maxBroadcastable): return {
        guard case .maxBroadcastable(let l) = lhs, case .maxBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.addBroadcastable, .addBroadcastable): return {
        guard case .addBroadcastable(let l) = lhs, case .addBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.powBroadcastable, .powBroadcastable): return {
        guard case .powBroadcastable(let l) = lhs, case .powBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.divideBroadcastable, .divideBroadcastable): return {
        guard case .divideBroadcastable(let l) = lhs, case .divideBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.floorDivBroadcastable, .floorDivBroadcastable): return {
        guard case .floorDivBroadcastable(let l) = lhs, case .floorDivBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.multiplyBroadcastable, .multiplyBroadcastable): return {
        guard case .multiplyBroadcastable(let l) = lhs, case .multiplyBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.subtractBroadcastable, .subtractBroadcastable): return {
        guard case .subtractBroadcastable(let l) = lhs, case .subtractBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.tile, .tile): return {
        guard case .tile(let l) = lhs, case .tile(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.stack, .stack): return {
        guard case .stack(let l) = lhs, case .stack(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gather, .gather): return {
        guard case .gather(let l) = lhs, case .gather(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scatter, .scatter): return {
        guard case .scatter(let l) = lhs, case .scatter(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gatherNd, .gatherNd): return {
        guard case .gatherNd(let l) = lhs, case .gatherNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scatterNd, .scatterNd): return {
        guard case .scatterNd(let l) = lhs, case .scatterNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.softmaxNd, .softmaxNd): return {
        guard case .softmaxNd(let l) = lhs, case .softmaxNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gatherAlongAxis, .gatherAlongAxis): return {
        guard case .gatherAlongAxis(let l) = lhs, case .gatherAlongAxis(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scatterAlongAxis, .scatterAlongAxis): return {
        guard case .scatterAlongAxis(let l) = lhs, case .scatterAlongAxis(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reverse, .reverse): return {
        guard case .reverse(let l) = lhs, case .reverse(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reverseSeq, .reverseSeq): return {
        guard case .reverseSeq(let l) = lhs, case .reverseSeq(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.splitNd, .splitNd): return {
        guard case .splitNd(let l) = lhs, case .splitNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.concatNd, .concatNd): return {
        guard case .concatNd(let l) = lhs, case .concatNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.transpose, .transpose): return {
        guard case .transpose(let l) = lhs, case .transpose(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sliceStatic, .sliceStatic): return {
        guard case .sliceStatic(let l) = lhs, case .sliceStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sliceDynamic, .sliceDynamic): return {
        guard case .sliceDynamic(let l) = lhs, case .sliceDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.slidingWindows, .slidingWindows): return {
        guard case .slidingWindows(let l) = lhs, case .slidingWindows(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.topK, .topK): return {
        guard case .topK(let l) = lhs, case .topK(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.argMin, .argMin): return {
        guard case .argMin(let l) = lhs, case .argMin(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.argMax, .argMax): return {
        guard case .argMax(let l) = lhs, case .argMax(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.embeddingNd, .embeddingNd): return {
        guard case .embeddingNd(let l) = lhs, case .embeddingNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.batchedMatmul, .batchedMatmul): return {
        guard case .batchedMatmul(let l) = lhs, case .batchedMatmul(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.getShape, .getShape): return {
        guard case .getShape(let l) = lhs, case .getShape(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.loadConstantNd, .loadConstantNd): return {
        guard case .loadConstantNd(let l) = lhs, case .loadConstantNd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.fillLike, .fillLike): return {
        guard case .fillLike(let l) = lhs, case .fillLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.fillStatic, .fillStatic): return {
        guard case .fillStatic(let l) = lhs, case .fillStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.fillDynamic, .fillDynamic): return {
        guard case .fillDynamic(let l) = lhs, case .fillDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.broadcastToLike, .broadcastToLike): return {
        guard case .broadcastToLike(let l) = lhs, case .broadcastToLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.broadcastToStatic, .broadcastToStatic): return {
        guard case .broadcastToStatic(let l) = lhs, case .broadcastToStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.broadcastToDynamic, .broadcastToDynamic): return {
        guard case .broadcastToDynamic(let l) = lhs, case .broadcastToDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.squeeze, .squeeze): return {
        guard case .squeeze(let l) = lhs, case .squeeze(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.expandDims, .expandDims): return {
        guard case .expandDims(let l) = lhs, case .expandDims(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.flattenTo2D, .flattenTo2D): return {
        guard case .flattenTo2D(let l) = lhs, case .flattenTo2D(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reshapeLike, .reshapeLike): return {
        guard case .reshapeLike(let l) = lhs, case .reshapeLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reshapeStatic, .reshapeStatic): return {
        guard case .reshapeStatic(let l) = lhs, case .reshapeStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reshapeDynamic, .reshapeDynamic): return {
        guard case .reshapeDynamic(let l) = lhs, case .reshapeDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.rankPreservingReshape, .rankPreservingReshape): return {
        guard case .rankPreservingReshape(let l) = lhs, case .rankPreservingReshape(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.constantPad, .constantPad): return {
        guard case .constantPad(let l) = lhs, case .constantPad(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomNormalLike, .randomNormalLike): return {
        guard case .randomNormalLike(let l) = lhs, case .randomNormalLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomNormalStatic, .randomNormalStatic): return {
        guard case .randomNormalStatic(let l) = lhs, case .randomNormalStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomNormalDynamic, .randomNormalDynamic): return {
        guard case .randomNormalDynamic(let l) = lhs, case .randomNormalDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomUniformLike, .randomUniformLike): return {
        guard case .randomUniformLike(let l) = lhs, case .randomUniformLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomUniformStatic, .randomUniformStatic): return {
        guard case .randomUniformStatic(let l) = lhs, case .randomUniformStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomUniformDynamic, .randomUniformDynamic): return {
        guard case .randomUniformDynamic(let l) = lhs, case .randomUniformDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomBernoulliLike, .randomBernoulliLike): return {
        guard case .randomBernoulliLike(let l) = lhs, case .randomBernoulliLike(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomBernoulliStatic, .randomBernoulliStatic): return {
        guard case .randomBernoulliStatic(let l) = lhs, case .randomBernoulliStatic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.randomBernoulliDynamic, .randomBernoulliDynamic): return {
        guard case .randomBernoulliDynamic(let l) = lhs, case .randomBernoulliDynamic(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.categoricalDistribution, .categoricalDistribution): return {
        guard case .categoricalDistribution(let l) = lhs, case .categoricalDistribution(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceL1, .reduceL1): return {
        guard case .reduceL1(let l) = lhs, case .reduceL1(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceL2, .reduceL2): return {
        guard case .reduceL2(let l) = lhs, case .reduceL2(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceMax, .reduceMax): return {
        guard case .reduceMax(let l) = lhs, case .reduceMax(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceMin, .reduceMin): return {
        guard case .reduceMin(let l) = lhs, case .reduceMin(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceSum, .reduceSum): return {
        guard case .reduceSum(let l) = lhs, case .reduceSum(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceProd, .reduceProd): return {
        guard case .reduceProd(let l) = lhs, case .reduceProd(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceMean, .reduceMean): return {
        guard case .reduceMean(let l) = lhs, case .reduceMean(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceLogSum, .reduceLogSum): return {
        guard case .reduceLogSum(let l) = lhs, case .reduceLogSum(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceSumSquare, .reduceSumSquare): return {
        guard case .reduceSumSquare(let l) = lhs, case .reduceSumSquare(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reduceLogSumExp, .reduceLogSumExp): return {
        guard case .reduceLogSumExp(let l) = lhs, case .reduceLogSumExp(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.whereNonZero, .whereNonZero): return {
        guard case .whereNonZero(let l) = lhs, case .whereNonZero(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.matrixBandPart, .matrixBandPart): return {
        guard case .matrixBandPart(let l) = lhs, case .matrixBandPart(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.lowerTriangular, .lowerTriangular): return {
        guard case .lowerTriangular(let l) = lhs, case .lowerTriangular(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.upperTriangular, .upperTriangular): return {
        guard case .upperTriangular(let l) = lhs, case .upperTriangular(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.whereBroadcastable, .whereBroadcastable): return {
        guard case .whereBroadcastable(let l) = lhs, case .whereBroadcastable(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.layerNormalization, .layerNormalization): return {
        guard case .layerNormalization(let l) = lhs, case .layerNormalization(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.nonMaximumSuppression, .nonMaximumSuppression): return {
        guard case .nonMaximumSuppression(let l) = lhs, case .nonMaximumSuppression(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.oneHot, .oneHot): return {
        guard case .oneHot(let l) = lhs, case .oneHot(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.cumSum, .cumSum): return {
        guard case .cumSum(let l) = lhs, case .cumSum(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.clampedReLu, .clampedReLu): return {
        guard case .clampedReLu(let l) = lhs, case .clampedReLu(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.argSort, .argSort): return {
        guard case .argSort(let l) = lhs, case .argSort(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.pooling3D, .pooling3D): return {
        guard case .pooling3D(let l) = lhs, case .pooling3D(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.globalPooling3D, .globalPooling3D): return {
        guard case .globalPooling3D(let l) = lhs, case .globalPooling3D(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.sliceBySize, .sliceBySize): return {
        guard case .sliceBySize(let l) = lhs, case .sliceBySize(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.convolution3D, .convolution3D): return {
        guard case .convolution3D(let l) = lhs, case .convolution3D(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// Branching Layer
///
/// A layer that provides the functionality of branching or an If-Else block.
///
/// Must have 1 input. There are no outputs as the execution is transferred to either the
/// if or the else branch based on the value of the input.
///
/// Input is the condition predicate. Must be a scalar (length 1 tensor).
struct CoreML_Specification_BranchLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// execute this graph if the absolute value of the input Tensor is greater than 1e-6
  /// This must be present.
  var ifBranch: CoreML_Specification_NeuralNetwork {
    get {return _ifBranch ?? CoreML_Specification_NeuralNetwork()}
    set {_ifBranch = newValue}
  }
  /// Returns true if `ifBranch` has been explicitly set.
  var hasIfBranch: Bool {return self._ifBranch != nil}
  /// Clears the value of `ifBranch`. Subsequent reads from it will return its default value.
  mutating func clearIfBranch() {self._ifBranch = nil}

  ///*
  /// execute this graph if the absolute value of the input Tensor is less than 1e-6
  /// This is optional.
  var elseBranch: CoreML_Specification_NeuralNetwork {
    get {return _elseBranch ?? CoreML_Specification_NeuralNetwork()}
    set {_elseBranch = newValue}
  }
  /// Returns true if `elseBranch` has been explicitly set.
  var hasElseBranch: Bool {return self._elseBranch != nil}
  /// Clears the value of `elseBranch`. Subsequent reads from it will return its default value.
  mutating func clearElseBranch() {self._elseBranch = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _ifBranch: CoreML_Specification_NeuralNetwork? = nil
  fileprivate var _elseBranch: CoreML_Specification_NeuralNetwork? = nil
}

///*
/// Loop Layer
///
/// A layer that provides the functionality of a "for" loop or a "while" loop.
///
/// There are either no inputs or 1 input. When an input is present, it corresponds to the maximum loop count,
/// in that case the value of the "maxLoopIterations" field is ignored. Input must be a scalar.
/// (For description below, maxLoopIterations is assumed to be the value of the input, when its present)
///
/// No outputs are produced. Blobs produced by the condition or the body network are visible in the scope of the overall network.
///
/// "conditionNetwork" must produce a tensor with the name specified in the "conditionVar" field.
///
/// There are 3 possible cases for determining the termination condition:
///
/// Case 1:
///
/// If there is no "conditionNetwork", in this case the layer corresponds to a pure for loop, which is run "maxLoopIterations" number of times.
/// Equivalent pseudo-code:
///
/// for loopIterator = 0 : maxLoopIterations
///      bodyNetwork()
///
///
/// Case 2:
///
/// "conditionNetwork" is present, and "maxLoopIterations" is 0 and there is no input,
/// in this case the layer corresponds to a while loop. Equivalent pseudo-code:
///
/// conditionVar = conditionNetwork()
/// while conditionVar:
///      bodyNetwork()
///      conditionVar = conditionNetwork()
///
///
/// Case 3:
///
/// "conditionNetwork" is provided, and "maxLoopIterations" is positive or there is an input,
/// in this case the layer corresponds to a while loop with a joint condition. Equivalent pseudo-code:
///
/// loopIterator = 0
/// conditionVar = conditionNetwork()
/// while (conditionVar and loopIterator < maxLoopIterations):
///      bodyNetwork()
///      loopIterator = loopIterator + 1
///      conditionVar = conditionNetwork()
struct CoreML_Specification_LoopLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// maximum number of iterations. Ignored if input is present.
  var maxLoopIterations: UInt64 = 0

  ///*
  /// This field provides the name of the tensor which is produced by the conditionNetwork
  /// and whose value is checked to start/continue/terminate the loop. Value close to 0.0f is treated as False.
  /// This field is optional.
  /// Must be a non empty string if and only if "conditionNetwork" is present.
  var conditionVar: String = String()

  ///*
  /// Must generate a tensor with the name provided in the "conditionVar" field.
  /// This field is optional.
  /// Must be present if and only if "conditionVar" field is a non empty string.
  var conditionNetwork: CoreML_Specification_NeuralNetwork {
    get {return _conditionNetwork ?? CoreML_Specification_NeuralNetwork()}
    set {_conditionNetwork = newValue}
  }
  /// Returns true if `conditionNetwork` has been explicitly set.
  var hasConditionNetwork: Bool {return self._conditionNetwork != nil}
  /// Clears the value of `conditionNetwork`. Subsequent reads from it will return its default value.
  mutating func clearConditionNetwork() {self._conditionNetwork = nil}

  ///*
  /// Body of the loop.
  /// This field must be present.
  var bodyNetwork: CoreML_Specification_NeuralNetwork {
    get {return _bodyNetwork ?? CoreML_Specification_NeuralNetwork()}
    set {_bodyNetwork = newValue}
  }
  /// Returns true if `bodyNetwork` has been explicitly set.
  var hasBodyNetwork: Bool {return self._bodyNetwork != nil}
  /// Clears the value of `bodyNetwork`. Subsequent reads from it will return its default value.
  mutating func clearBodyNetwork() {self._bodyNetwork = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _conditionNetwork: CoreML_Specification_NeuralNetwork? = nil
  fileprivate var _bodyNetwork: CoreML_Specification_NeuralNetwork? = nil
}

///*
/// Loop break Layer
///
/// Terminate the loop that has this layer.
/// If present, it should always reside in the "bodyNetwork" of the loop layer
///
/// No inputs/outputs
struct CoreML_Specification_LoopBreakLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Loop Continue Layer
///
/// Stop the current loop iteration and continue on the next iteration.
/// If present, it should always reside in the "bodyNetwork" of the loop layer
///
/// No inputs/outputs
struct CoreML_Specification_LoopContinueLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Copy Layer
///
/// A layer that copies its input tensor to the output tensor.
/// Must have 1 input and 1 output, with distinct names.
/// This is the only layer that is allowed to re-generate an output that is already present in the neural network prior to this layer,
/// in which case it will overwrite the output tensor.
struct CoreML_Specification_CopyLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// GreaterThan Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise greater than operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 > x2
///          or
///      y = x1 > alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_GreaterThanLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// GreaterEqual Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise greater equal operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 >= x2
///          or
///      y = x1 >= alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_GreaterEqualLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LessThan Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise less than operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 < x2
///          or
///      y = x1 < alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_LessThanLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LessEqual Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise less equal operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 <= x2
///          or
///      y = x1 <= alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_LessEqualLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Equal Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise equal operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 == x2
///          or
///      y = x1 == alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_EqualLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// NotEqual Layer
///
/// Either 1 or 2 inputs.
/// Produces 1 output.
/// Perform elementwise not equal operation.
///
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = x1 != x2
///          or
///      y = x1 != alpha, if only one input is provided
///
/// Broadcasting is supported.
struct CoreML_Specification_NotEqualLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Compare to the scalar value provided here if there is 1 input
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LogicalAnd Layer
///
/// Must have 2 inputs, produces 1 output.
/// Perform elementwise logical AND operation.
///
/// Input is considered False if equal to 0.0f otherwise True.
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = AND(x1, x2)
///
/// Broadcasting is supported.
struct CoreML_Specification_LogicalAndLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LogicalOr Layer
///
/// Must have 2 inputs, produces 1 output.
/// Perform elementwise logical OR operation.
///
/// Input is considered False if equal to 0.0f otherwise True.
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = OR(x1, x2)
///
/// Broadcasting is supported.
struct CoreML_Specification_LogicalOrLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LogicalXor Layer
///
/// Must have 2 inputs, produces 1 output.
/// Perform elementwise logical XOR operation.
///
/// Input is considered False if equal to 0.0f otherwise True.
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = XOR(x1, x2)
///
/// Broadcasting is supported.
struct CoreML_Specification_LogicalXorLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// LogicalNot Layer
///
/// Must have 1 input, produces 1 output.
/// Perform elementwise logical NOT operation.
///
/// Input is considered False if equal to 0.0f otherwise True.
/// Output is 1.0f if the condition is true otherwise 0.0f.
///
/// .. code::
///
///      y = NOT(x)
struct CoreML_Specification_LogicalNotLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Specifies the amount of spatial border to be either padded or cropped.
///
/// For padding:
///
/// .. code::
///
///     H_out = borderAmounts[0].startEdgeSize + H_in + borderAmounts[0].endEdgeSize
///     W_out = borderAmounts[1].startEdgeSize + W_in + borderAmounts[1].endEdgeSize
///
///     topPaddingAmount == Height startEdgeSize
///     bottomPaddingAmount == Height endEdgeSize
///     leftPaddingAmount == Width startEdgeSize
///     rightPaddingAmount == Width endEdgeSize
///
/// For cropping:
///
/// .. code::
///
///     H_out = (-borderAmounts[0].startEdgeSize) + H_in + (-borderAmounts[0].endEdgeSize)
///     W_out = (-borderAmounts[1].startEdgeSize) + W_in + (-borderAmounts[1].endEdgeSize)
///
///     topCropAmount == Height startEdgeSize
///     bottomCropAmount == Height endEdgeSize
///     leftCropAmount == Width startEdgeSize
///     rightCropAmount == Width endEdgeSize
struct CoreML_Specification_BorderAmounts {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The border amounts.
  /// This must be length 2 in the order ``[H, W]``.
  var borderAmounts: [CoreML_Specification_BorderAmounts.EdgeSizes] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct EdgeSizes {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    ///*
    /// The amount to be padded or cropped from the beginning.
    var startEdgeSize: UInt64 = 0

    ///*
    /// The amount to be padded or cropped from the end.
    var endEdgeSize: UInt64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

///*
/// Specifies the type of padding to be used with Convolution/Deconvolution and Pooling layers.
/// After padding, input spatial shape: ``[H_in, W_in]``, gets modified to the
/// output spatial shape ``[H_out, W_out]``.
///
/// .. code::
///
///      topPaddingAmount == Height startEdgeSize == borderAmounts[0].startEdgeSize
///      bottomPaddingAmount == Height endEdgeSize == borderAmounts[0].endEdgeSize
///      leftPaddingAmount == Width startEdgeSize == borderAmounts[1].startEdgeSize
///      rightPaddingAmount == Width endEdgeSize == borderAmounts[1].endEdgeSize
///
/// With Convolution or Pooling:
///
/// .. code::
///
///    H_out = int_division_round_down((H_in + topPaddingAmount + bottomPaddingAmount - KernelSize[0]),stride[0]) + 1
///
/// which is same as:
///
/// .. code::
///
///    H_out = int_division_round_up((H_in + topPaddingAmount + bottomPaddingAmount - KernelSize[0] + 1),stride[0])
///
/// With Deconvolution:
///
/// .. code::
///
///    H_out = (H_in-1) * stride[0] + kernelSize[0] - (topPaddingAmount + bottomPaddingAmount)
///
///
/// The equivalent expressions hold true for ``W_out`` as well.
///
///
/// By default, the values of ``paddingAmounts`` are set to ``0``,
/// which results in a "true" valid padding.
/// If non-zero values are provided for ``paddingAmounts``,
/// "valid" convolution/pooling is performed within the spatially expanded input.
struct CoreML_Specification_ValidPadding {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var paddingAmounts: CoreML_Specification_BorderAmounts {
    get {return _paddingAmounts ?? CoreML_Specification_BorderAmounts()}
    set {_paddingAmounts = newValue}
  }
  /// Returns true if `paddingAmounts` has been explicitly set.
  var hasPaddingAmounts: Bool {return self._paddingAmounts != nil}
  /// Clears the value of `paddingAmounts`. Subsequent reads from it will return its default value.
  mutating func clearPaddingAmounts() {self._paddingAmounts = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _paddingAmounts: CoreML_Specification_BorderAmounts? = nil
}

///*
/// Specifies the type of padding to be used with Convolution/Deconvolution and pooling layers.
/// After padding, input spatial shape: ``[H_in, W_in]``, gets modified to the
/// output spatial shape ``[H_out, W_out]``.
/// With Convolution or pooling:
///
/// .. code::
///
///      H_out = int_division_round_up(H_in,stride[0])
///      W_out = int_division_round_up(W_in,stride[1])
///
/// This is achieved by using the following padding amounts:
///
/// .. code::
///
///     totalPaddingHeight = max(0,(H_out-1) * stride[0] + KernelSize[0] - Hin)
///     totalPaddingWidth = max(0,(W_out-1) * stride[1] + KernelSize[1] - Win)
///
/// There are two modes of asymmetry:
/// ``BOTTOM_RIGHT_HEAVY``, and ``TOP_LEFT_HEAVY``.
///
/// If the mode is ``BOTTOM_RIGHT_HEAVY``:
///
/// .. code::
///
///     topPaddingAmount = floor(totalPaddingHeight / 2)
///     bottomPaddingAmount = totalPaddingHeight - topPaddingAmount
///     leftPaddingAmount = floor(totalPaddingWidth / 2)
///     rightPaddingAmount = totalPaddingWidth - leftPaddingAmount
///
/// If the mode is ``TOP_LEFT_HEAVY``:
///
/// .. code::
///
///     bottomPaddingAmount = floor(totalPaddingHeight / 2)
///     topPaddingAmount = totalPaddingHeight - bottomPaddingAmount
///     rightPaddingAmount = floor(totalPaddingWidth / 2)
///     leftPaddingAmount = totalPaddingWidth - rightPaddingAmount
///
///
/// With Deconvolution:
///
/// .. code::
///
///    H_out = H_in * stride[0]
///    W_out = W_in * stride[1]
struct CoreML_Specification_SamePadding {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var asymmetryMode: CoreML_Specification_SamePadding.SamePaddingMode = .bottomRightHeavy

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum SamePaddingMode: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case bottomRightHeavy // = 0
    case topLeftHeavy // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .bottomRightHeavy
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .bottomRightHeavy
      case 1: self = .topLeftHeavy
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .bottomRightHeavy: return 0
      case .topLeftHeavy: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_SamePadding.SamePaddingMode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_SamePadding.SamePaddingMode] = [
    .bottomRightHeavy,
    .topLeftHeavy,
  ]
}

#endif  // swift(>=4.2)

///*
/// Specifies how grid points are sampled from an interval.
/// Without the loss of generality, assume the interval to be [0, X-1] from which N points are to be sampled.
/// Here X may correspond to an input image's height or width.
/// All the methods can be expressed in terms of numpy's linspace function, along with the constraint that grid points have to lie in the interval [0, X-1].
/// Note: numpy.linspace(start = start, end = end, num = N, endpoint = True) corresponds to sampling
/// N points uniformly from the interval [start, end], endpoints included.
/// The methods vary in how the ``start`` and ``end`` values are computed.
struct CoreML_Specification_SamplingMode {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var samplingMethod: CoreML_Specification_SamplingMode.Method = .strictAlignEndpointsMode

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum Method: SwiftProtobuf.Enum {
    typealias RawValue = Int

    ///*
    /// start = 0, end = X-1
    /// grid points = numpy.linspace(start, end)
    case strictAlignEndpointsMode // = 0

    ///*
    /// if N == 1: start = end = (X-1)/2
    /// otherwise, start = 0, end = X-1
    /// grid points = numpy.linspace(start, end)
    case alignEndpointsMode // = 1

    ///*
    /// start = 0, end = X - X/N
    /// grid points = min(X-1, numpy.linspace(start, end))
    /// This is same as the mode used in the upsample layer in this specification, when used with bilinear interpolation. In that case N/X = upsample ratio.
    case upsampleMode // = 2

    ///*
    /// spacing = max(1, X-1)/N
    /// start = 0.5 * spacing
    /// end = start + (N-1) * spacing
    /// grid points = min(X-1, numpy.linspace(start, end))
    case roiAlignMode // = 3
    case UNRECOGNIZED(Int)

    init() {
      self = .strictAlignEndpointsMode
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .strictAlignEndpointsMode
      case 1: self = .alignEndpointsMode
      case 2: self = .upsampleMode
      case 3: self = .roiAlignMode
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .strictAlignEndpointsMode: return 0
      case .alignEndpointsMode: return 1
      case .upsampleMode: return 2
      case .roiAlignMode: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_SamplingMode.Method: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_SamplingMode.Method] = [
    .strictAlignEndpointsMode,
    .alignEndpointsMode,
    .upsampleMode,
    .roiAlignMode,
  ]
}

#endif  // swift(>=4.2)

///*
/// Specifies the convention used to specify four bounding box coordinates for an image of size (Height, Width).
/// The (0,0) coordinate corresponds to the top-left corner of the image.
struct CoreML_Specification_BoxCoordinatesMode {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var boxMode: CoreML_Specification_BoxCoordinatesMode.Coordinates = .cornersHeightFirst

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum Coordinates: SwiftProtobuf.Enum {
    typealias RawValue = Int

    ///*
    /// [h_start, w_start, h_end, w_end]
    case cornersHeightFirst // = 0

    ///*
    /// [w_start, h_start, w_end, h_end]
    case cornersWidthFirst // = 1

    ///*
    /// [h_center, w_center, box_height, box_width]
    case centerSizeHeightFirst // = 2

    ///*
    /// [w_center, h_center, box_width, box_height]
    case centerSizeWidthFirst // = 3
    case UNRECOGNIZED(Int)

    init() {
      self = .cornersHeightFirst
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .cornersHeightFirst
      case 1: self = .cornersWidthFirst
      case 2: self = .centerSizeHeightFirst
      case 3: self = .centerSizeWidthFirst
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .cornersHeightFirst: return 0
      case .cornersWidthFirst: return 1
      case .centerSizeHeightFirst: return 2
      case .centerSizeWidthFirst: return 3
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_BoxCoordinatesMode.Coordinates: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_BoxCoordinatesMode.Coordinates] = [
    .cornersHeightFirst,
    .cornersWidthFirst,
    .centerSizeHeightFirst,
    .centerSizeWidthFirst,
  ]
}

#endif  // swift(>=4.2)

///*
/// Weights for layer parameters.
/// Weights are stored as repeated floating point numbers
/// using row-major ordering
/// and can represent 1-, 2-, 3-, or 4-dimensional data.
struct CoreML_Specification_WeightParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Values specified in single / float / FP32 precision.
  var floatValue: [Float] = []

  ///*
  /// Values in 16-bit half precision floating point.
  var float16Value: Data = Data()

  ///*
  /// Raw value specification for quantized lower precisions.
  ///
  /// This field is interpreted as uintN, where N is the number of bits in quantization.
  /// E.g. if n=8, the field is interpreted as an array of UINT8.
  /// Use this field for quantized parameters unless specifically noted to use
  /// int8RawValue.
  var rawValue: Data = Data()

  ///*
  /// Field to be used if int8DynamicQuantize is set in the parent layer.
  /// Cannot be set if rawValue is also set.
  /// The values in this field are interpreted as INT8.
  ///
  /// If this field is set, following conditions must hold true:
  /// * QuantizationType == LinearQuantizationParams, such that
  ///   * size of the "scale" field is 1 and "bias" field is empty in "LinearQuantizationParams"
  var int8RawValue: Data = Data()

  ///*
  /// Quantization related parameters.
  var quantization: CoreML_Specification_QuantizationParams {
    get {return _quantization ?? CoreML_Specification_QuantizationParams()}
    set {_quantization = newValue}
  }
  /// Returns true if `quantization` has been explicitly set.
  var hasQuantization: Bool {return self._quantization != nil}
  /// Clears the value of `quantization`. Subsequent reads from it will return its default value.
  mutating func clearQuantization() {self._quantization = nil}

  var isUpdatable: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _quantization: CoreML_Specification_QuantizationParams? = nil
}

///*
/// Quantization parameters.
struct CoreML_Specification_QuantizationParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var numberOfBits: UInt64 = 0

  var quantizationType: CoreML_Specification_QuantizationParams.OneOf_QuantizationType? = nil

  var linearQuantization: CoreML_Specification_LinearQuantizationParams {
    get {
      if case .linearQuantization(let v)? = quantizationType {return v}
      return CoreML_Specification_LinearQuantizationParams()
    }
    set {quantizationType = .linearQuantization(newValue)}
  }

  var lookupTableQuantization: CoreML_Specification_LookUpTableQuantizationParams {
    get {
      if case .lookupTableQuantization(let v)? = quantizationType {return v}
      return CoreML_Specification_LookUpTableQuantizationParams()
    }
    set {quantizationType = .lookupTableQuantization(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_QuantizationType: Equatable {
    case linearQuantization(CoreML_Specification_LinearQuantizationParams)
    case lookupTableQuantization(CoreML_Specification_LookUpTableQuantizationParams)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_QuantizationParams.OneOf_QuantizationType, rhs: CoreML_Specification_QuantizationParams.OneOf_QuantizationType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.linearQuantization, .linearQuantization): return {
        guard case .linearQuantization(let l) = lhs, case .linearQuantization(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.lookupTableQuantization, .lookupTableQuantization): return {
        guard case .lookupTableQuantization(let l) = lhs, case .lookupTableQuantization(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}
}

struct CoreML_Specification_LinearQuantizationParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Stores scale and bias values corresponding to the quantized weights.
  /// Must be an array of 1 element, or an array of C elements, where C
  /// is number of output channels. For recurrent layers it is equal to
  /// the output vector size.
  ///
  /// Relationship between quantized weights, unquantized weights, scale and bias:
  ///
  /// W_unquantized = W_quantized * scale + bias
  var scale: [Float] = []

  var bias: [Float] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_LookUpTableQuantizationParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Stores look-up table quantization values. Must be an array of
  ///(2^numberOfBits) Elements.
  var floatValue: [Float] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs spatial convolution or deconvolution.
///
/// .. code::
///
///      y = ConvolutionLayer(x)
///
/// Requires 1 or 2 inputs and produces 1 output.
///
/// Input
///    First Input:
///      A blob with rank greater than or equal to 4.
///      Rank 4 blob represents [Batch, channels, height, width].
///      For ranks greater than 4, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
///     From Core ML specification version 4 onwards (iOS >= 13, macOS >= 10.15).
///     convolution layer can have 2 inputs, in which case the second input is
///     the blob representing the weights. This is allowed when "isDeconvolution" = False.
///     The weight blob should have shape
///     ``[outputChannels, kernelChannels, kernelHeight, kernelWidth]``,
///     where kernelChannels == inputChannels / nGroups.
///
/// Output
///   Rank is same as the input. e.g.: for rank 4 input, output shape is [B, C_out, H_out, W_out]
///
///
/// If ``dilationFactor`` is not 1, effective kernel size is
/// modified as follows:
///
/// .. code::
///
///      KernelSize[0] <-- (kernelSize[0]-1) * dilationFactor[0] + 1
///      KernelSize[1] <-- (kernelSize[1]-1) * dilationFactor[1] + 1
///
/// Type of padding can be ``valid`` or ``same``. Output spatial dimensions depend on the
/// the type of padding. For details, refer to the descriptions of the messages "ValidPadding"
/// and "SamePadding". Padded values are all zeros.
///
/// For Deconvolution, ``ConvolutionPaddingType`` (``valid`` or ``same``) is ignored when ``outputShape`` is set.
struct CoreML_Specification_ConvolutionLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The number of kernels.
  /// Same as ``C_out`` used in the layer description.
  var outputChannels: UInt64 {
    get {return _storage._outputChannels}
    set {_uniqueStorage()._outputChannels = newValue}
  }

  ///*
  /// Channel dimension of the kernels.
  /// Must be equal to ``inputChannels / nGroups``, if isDeconvolution == False
  /// Must be equal to ``inputChannels``, if isDeconvolution == True
  var kernelChannels: UInt64 {
    get {return _storage._kernelChannels}
    set {_uniqueStorage()._kernelChannels = newValue}
  }

  ///*
  /// Group convolution, i.e. weight reuse along channel axis.
  /// Input and kernels are divided into g groups
  /// and convolution / deconvolution is applied within the groups independently.
  /// If not set or 0, it is set to the default value 1.
  var nGroups: UInt64 {
    get {return _storage._nGroups}
    set {_uniqueStorage()._nGroups = newValue}
  }

  ///*
  /// Must be length 2 in the order ``[H, W]``.
  /// If not set, default value ``[3, 3]`` is used.
  var kernelSize: [UInt64] {
    get {return _storage._kernelSize}
    set {_uniqueStorage()._kernelSize = newValue}
  }

  ///*
  /// Must be length 2 in the order ``[H, W]``.
  /// If not set, default value ``[1, 1]`` is used.
  var stride: [UInt64] {
    get {return _storage._stride}
    set {_uniqueStorage()._stride = newValue}
  }

  ///*
  /// Must be length 2 in order ``[H, W]``.
  /// If not set, default value ``[1, 1]`` is used.
  /// It is ignored if ``isDeconvolution == true``.
  var dilationFactor: [UInt64] {
    get {return _storage._dilationFactor}
    set {_uniqueStorage()._dilationFactor = newValue}
  }

  ///*
  /// The type of padding.
  var convolutionPaddingType: OneOf_ConvolutionPaddingType? {
    get {return _storage._convolutionPaddingType}
    set {_uniqueStorage()._convolutionPaddingType = newValue}
  }

  var valid: CoreML_Specification_ValidPadding {
    get {
      if case .valid(let v)? = _storage._convolutionPaddingType {return v}
      return CoreML_Specification_ValidPadding()
    }
    set {_uniqueStorage()._convolutionPaddingType = .valid(newValue)}
  }

  var same: CoreML_Specification_SamePadding {
    get {
      if case .same(let v)? = _storage._convolutionPaddingType {return v}
      return CoreML_Specification_SamePadding()
    }
    set {_uniqueStorage()._convolutionPaddingType = .same(newValue)}
  }

  ///*
  /// Flag to specify whether it is a deconvolution layer.
  var isDeconvolution: Bool {
    get {return _storage._isDeconvolution}
    set {_uniqueStorage()._isDeconvolution = newValue}
  }

  ///*
  /// Flag to specify whether a bias is to be added or not.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  ///*
  /// Weights associated with this layer.
  /// If convolution (``isDeconvolution == false``), weights have the shape
  /// ``[outputChannels, kernelChannels, kernelHeight, kernelWidth]``, where kernelChannels == inputChannels / nGroups
  /// If deconvolution (``isDeconvolution == true``) weights have the shape
  /// ``[kernelChannels, outputChannels / nGroups, kernelHeight, kernelWidth]``, where kernelChannels == inputChannels
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  //// Must be of size [outputChannels].
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  ///*
  /// The output shape, which has length 2 ``[H_out, W_out]``.
  /// This is used only for deconvolution (``isDeconvolution == true``).
  /// If not set, the deconvolution output shape is calculated
  /// based on ``ConvolutionPaddingType``.
  var outputShape: [UInt64] {
    get {return _storage._outputShape}
    set {_uniqueStorage()._outputShape = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  ///*
  /// The type of padding.
  enum OneOf_ConvolutionPaddingType: Equatable {
    case valid(CoreML_Specification_ValidPadding)
    case same(CoreML_Specification_SamePadding)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_ConvolutionLayerParams.OneOf_ConvolutionPaddingType, rhs: CoreML_Specification_ConvolutionLayerParams.OneOf_ConvolutionPaddingType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.valid, .valid): return {
        guard case .valid(let l) = lhs, case .valid(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.same, .same): return {
        guard case .same(let l) = lhs, case .same(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that performs a 3-dimensional convolution.
///
/// .. code::
///
///      y = Convolution3DLayer(x)
///
/// Input
///    A blob of rank 5.
///    The input blob's shape should be ``[batch, channels, depth, height, width]``.
///
/// Fields
///   The bias field, if set, should have shape of ``[channelsOut]``.
///
/// Output
///   A blob of rank 5.
///   The output blob's shape is ``[batch, channelsOut, depthOut, heightOut, widthOut]``.
///
/// Type of padding can be ``custom``, ``valid``, or ``same``. Padded values are all zeros.
/// Output spatial dimensions depend on the type of padding. For details, refer to the
/// descriptions of the ``PaddingType`` field of this ``Convolution3DLayerParams`` message.
///
/// Example
///   For example, given an input of size ``[1, 3, 3, 8, 8]``, a stride of 2 in each dimension,
///   a kernel of 3 in each dimension, 2 output channels, and ``same`` padding, this layer will
///   compute the total padding applied in the depth, height, and width dimensions to be 2, 1, and 1,
///   respectively. The depth padding is even and will be applied equally to both sides of the depth
///   dimension. Since the height and width padding values are odd, they'll be applied to the
///   bottom/right of the height/width dimensions. Thus, the padding applied to the input will be
///   ``[1, 1, 0, 1, 0, 1]`` (front, back, top, bottom, left, right). Finally, the output produced
///   will have size ``[1, 2, 2, 4, 4]``.
struct CoreML_Specification_Convolution3DLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The number of channels in the output (channelsOut). Must be a positive integer.
  var outputChannels: Int32 {
    get {return _storage._outputChannels}
    set {_uniqueStorage()._outputChannels = newValue}
  }

  ///*
  /// The number of channels in the input (channels). Must be a positive integer.
  var inputChannels: Int32 {
    get {return _storage._inputChannels}
    set {_uniqueStorage()._inputChannels = newValue}
  }

  ///*
  /// Group convolution, i.e., weight reuse along the channel axis.
  /// It must evenly divide both the number of input and output channels and be at most the number
  /// of input channels (a depthwise convolution).
  /// Input and kernels are divided into g groups and convolution is applied within the groups
  /// independently.
  var nGroups: Int32 {
    get {return _storage._nGroups}
    set {_uniqueStorage()._nGroups = newValue}
  }

  /// Depth of the convolution kernel. Must be a positive integer.
  var kernelDepth: Int32 {
    get {return _storage._kernelDepth}
    set {_uniqueStorage()._kernelDepth = newValue}
  }

  /// Height of the convolution kernel. Must be a positive integer.
  var kernelHeight: Int32 {
    get {return _storage._kernelHeight}
    set {_uniqueStorage()._kernelHeight = newValue}
  }

  /// Width of the convolution kernel. Must be a positive integer.
  var kernelWidth: Int32 {
    get {return _storage._kernelWidth}
    set {_uniqueStorage()._kernelWidth = newValue}
  }

  /// Stride along the depth direction. Must be a positive integer.
  var strideDepth: Int32 {
    get {return _storage._strideDepth}
    set {_uniqueStorage()._strideDepth = newValue}
  }

  /// Stride along the height direction. Must be a positive integer.
  var strideHeight: Int32 {
    get {return _storage._strideHeight}
    set {_uniqueStorage()._strideHeight = newValue}
  }

  /// Stride along the width direction. Must be a positive integer.
  var strideWidth: Int32 {
    get {return _storage._strideWidth}
    set {_uniqueStorage()._strideWidth = newValue}
  }

  /// Dilation along the depth direction. Must be a positive integer.
  var dilationDepth: Int32 {
    get {return _storage._dilationDepth}
    set {_uniqueStorage()._dilationDepth = newValue}
  }

  /// Dilation along the height direction. Must be a positive integer.
  var dilationHeight: Int32 {
    get {return _storage._dilationHeight}
    set {_uniqueStorage()._dilationHeight = newValue}
  }

  /// Dilation along the width direction. Must be a positive integer.
  var dilationWidth: Int32 {
    get {return _storage._dilationWidth}
    set {_uniqueStorage()._dilationWidth = newValue}
  }

  ///*
  /// Flag to specify whether a bias is to be added or not.
  /// If false, then no bias is added.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  ///*
  /// Weights associated with this layer.
  /// Weights have the shape
  /// if deconvolution == False
  /// ``[outputChannels, kernelChannels, kernelDepth, kernelHeight, kernelWidth]``, where
  /// kernelChannels == inputChannels / nGroups
  /// else if deconvolution == True
  /// ``[outputChannels / nGroups, kernelChannels, kernelDepth, kernelHeight, kernelWidth]``, where
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  ///*
  /// Must be of size ``[outputChannels]``.
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  var paddingType: CoreML_Specification_Convolution3DLayerParams.PaddingType {
    get {return _storage._paddingType}
    set {_uniqueStorage()._paddingType = newValue}
  }

  /// Padding before the input in the depth direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingFront: Int32 {
    get {return _storage._customPaddingFront}
    set {_uniqueStorage()._customPaddingFront = newValue}
  }

  /// Padding after the input in the depth direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingBack: Int32 {
    get {return _storage._customPaddingBack}
    set {_uniqueStorage()._customPaddingBack = newValue}
  }

  /// Padding before the input in the height direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingTop: Int32 {
    get {return _storage._customPaddingTop}
    set {_uniqueStorage()._customPaddingTop = newValue}
  }

  /// Padding after the input in the height direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingBottom: Int32 {
    get {return _storage._customPaddingBottom}
    set {_uniqueStorage()._customPaddingBottom = newValue}
  }

  /// Padding before the input in the width direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingLeft: Int32 {
    get {return _storage._customPaddingLeft}
    set {_uniqueStorage()._customPaddingLeft = newValue}
  }

  /// Padding after the input in the width direction. Must be zero or a positive integer.
  /// Used when the `PaddingType` is `CustomPadding`, otherwise ignored by other padding types.
  var customPaddingRight: Int32 {
    get {return _storage._customPaddingRight}
    set {_uniqueStorage()._customPaddingRight = newValue}
  }

  /// Flag to specify if this is Convolution Transpose or not.
  var isDeconvolution: Bool {
    get {return _storage._isDeconvolution}
    set {_uniqueStorage()._isDeconvolution = newValue}
  }

  ///
  /// The output shape, which has length 3 ``[D_out, H_out, W_out]``.
  /// This is used only for deconvolution (``isDeconvolution == true``).
  /// If not set, the deconvolution output shape is calculated
  /// based on ``PaddingType``.
  var outputShape: [UInt64] {
    get {return _storage._outputShape}
    set {_uniqueStorage()._outputShape = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  ///*
  /// The type of padding.
  /// All padding types pad the input shape with zeros.
  /// CUSTOM padding will add the custom padding values specified below to their respective
  /// dimensions, e.g., `customPaddingFront` number of zeros will be added to one side of the
  /// input's depth dimension and `customPaddingBack` number of zeros will be added to the other
  /// side of the input's depth dimension.
  /// VALID padding adds no padding to any dimension. In this case, the last convolution along
  /// each dimension will be dropped if the input dimension and the kernel size, stride, and
  /// dilation do not match.
  /// SAME padding adds enough padding to each dimension such that the output of the convolution
  /// has size ``Ceiling(inputShape / stride)``. Padding is added evenly to both sides of each
  /// dimension unless the total padding to add is odd, in which case it is added to the
  /// back/bottom/right side of the respective dimension. For example, if the total padding needed
  /// in the depth dimension is 3, 1 zero will be added to the front side of the depth dimension
  /// and 2 zeros will be added to the back side.
  enum PaddingType: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case custom // = 0
    case valid // = 1
    case same // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .custom
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .custom
      case 1: self = .valid
      case 2: self = .same
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .custom: return 0
      case .valid: return 1
      case .same: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

#if swift(>=4.2)

extension CoreML_Specification_Convolution3DLayerParams.PaddingType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_Convolution3DLayerParams.PaddingType] = [
    .custom,
    .valid,
    .same,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that performs a matrix-vector or matrix-matrix product.
/// This is equivalent to a fully-connected, or dense layer.
/// The weight parameters correspond to a matrix of dimensions (inputChannels, outputChannels) i.e. (C_in, C_out)
///
/// .. code::
///
///      y = InnerProductLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///      Input can have rank 1 to rank 5. This is how it is reshaped in to the matrix (for rank > 1):
///      rank 1 (x1) : in this case, the layer corresponds to a matrix-vector product. x1 must be equal to C_in
///      rank 2 (x1, x2): x2 must be equal to C_in
///      rank 3 (x1, x2, x3) --> (x1 * x2, x3). x3 must be equal to C_in
///      rank 4 (x1, x2, x3, x4) ---> (x1, x2 * x3 * x4). x2 * x3 * x4 must be equal to C_in
///      rank 5 (x1, x2, x3, x4, x5) ---> (x1 * x2, x3 * x4 * x5). x3 * x4 * x5 must be equal to C_in
///
/// Output
///      Output rank is same as the input rank
///      rank 1: (C_out)
///      rank 2: (x1, C_out)
///      rank 3: (x1, x2, C_out)
///      rank 4: (x1, C_out, 1, 1)
///      rank 5: (x1, x2, C_out, 1, 1)
struct CoreML_Specification_InnerProductLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Input size: C_in.
  var inputChannels: UInt64 {
    get {return _storage._inputChannels}
    set {_uniqueStorage()._inputChannels = newValue}
  }

  //// Output size: C_out.
  var outputChannels: UInt64 {
    get {return _storage._outputChannels}
    set {_uniqueStorage()._outputChannels = newValue}
  }

  //// Whether a bias is added or not.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  //// Weight matrix [C_out, C_in].
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  //// Bias vector [C_out].
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  ///*
  /// If set, this layer, at runtime, quantizes the floating point input blob to int8 before applying an
  /// inner product using INT8 weight matrix parameters, as provided in weights->int8RawValue. The
  /// result is then dequantized.
  /// Requires:
  /// * hasBias == false
  /// * QuantizationType == LinearQuantizationParams, such that
  ///   * size of the "scale" field is 1 and "bias" field is empty in "LinearQuantizationParams"
  /// * numberOfBits == 8
  /// * weights->rawValue_size to be empty
  var int8DynamicQuantize: Bool {
    get {return _storage._int8DynamicQuantize}
    set {_uniqueStorage()._int8DynamicQuantize = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that performs a matrix lookup and optionally adds a bias.
/// The weights matrix is stored with dimensions [outputChannels, inputDim].
///
/// .. code::
///
///      y = EmbeddingLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     Input values must be in the range ``[0, inputDim - 1]``.
///
///     Input must have rank equal to 4 or 5, such that the last 3 dimensions are all 1.
///     rank 4: shape (x1, 1, 1, 1). x1 is effectively the batch/sequence length.
///     rank 5: shape (x1, x2 , 1, 1, 1). x1 * x2 is effectively the combined batch/sequence length.
///
/// Output
///      Output rank is same as the input rank. Please see input description above.
///      rank 4: shape (x1, outputChannels, 1, 1)
///      rank 5: shape (x1, x2, outputChannels, 1, 1)
struct CoreML_Specification_EmbeddingLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Size of the input dictionary.
  var inputDim: UInt64 {
    get {return _storage._inputDim}
    set {_uniqueStorage()._inputDim = newValue}
  }

  //// Size of the output vectors.
  var outputChannels: UInt64 {
    get {return _storage._outputChannels}
    set {_uniqueStorage()._outputChannels = newValue}
  }

  //// Whether a bias is added or not.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  //// 2-D weights of dimensions [outputChannels, inputDim].
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  //// Bias of size [outputChannels].
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that performs a matrix lookup and optionally adds a bias.
/// The weights matrix is stored with dimensions [embeddingSize, vocabSize].
///
/// .. code::
///
///      y = EmbeddingNDLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     Input values must be in the range ``[0, vocabSize - 1]``.
///     Input must have rank at least 2. The last dimension must always be 1.
///     rank 2: shape (x1, 1). x1 is the batch/sequence length.
///     rank 3: shape (x1, x2, 1). x1 * x2 is effectively the combined batch/sequence length.
///     rank 4: shape (x1, x2, x3, 1). x1 * x2 * x2 is effectively the combined batch/sequence length.
///     rank 5: shape (x1, x2 , x3, x4, 1). x1 * x2 * x3 * x4 is effectively the combined batch/sequence length.
///
/// Output
///      Output rank is same as the input rank. Please see input description above.
///      rank 2: shape (x1, embeddingSize)
///      rank 3: shape (x1, x2, embeddingSize)
///      rank 4: shape (x1, x2, x3, embeddingSize)
///      rank 5: shape (x1, x2, x3, x4, embeddingSize)
struct CoreML_Specification_EmbeddingNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Size of the input dictionary.
  var vocabSize: UInt64 {
    get {return _storage._vocabSize}
    set {_uniqueStorage()._vocabSize = newValue}
  }

  //// Size of the output vectors.
  var embeddingSize: UInt64 {
    get {return _storage._embeddingSize}
    set {_uniqueStorage()._embeddingSize = newValue}
  }

  //// Whether a bias is added or not.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  //// 2-D weights of dimensions [embeddingSize, vocabSize].
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  //// Bias of size [embeddingSize].
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that performs batch normalization,
/// which is performed along axis = -3,
/// and repeated along the other axes, if present.
///
/// .. code::
///
///      y = BatchnormLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// This operation is described by the following formula:
///
/// .. math::
///     y_i = \gamma_i \dfrac{ (x_i - \mu_i)}{\sqrt{\sigma_i^2 + \epsilon}} + \beta_i \;,\;i=1,....,C
///
/// Input
///     A blob with rank greater than equal to 3.
///     Example: Rank 4 blob represents [Batch, channels, height, width]
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     A blob with the same shape as the input.
struct CoreML_Specification_BatchnormLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Size of the channel dimension in the input.
  var channels: UInt64 {
    get {return _storage._channels}
    set {_uniqueStorage()._channels = newValue}
  }

  ///*
  /// If ``computeMeanVar == true``,
  /// the mean and variance are calculated from either
  /// the single input instance, if ``instanceNormalization == true``,
  /// or the whole batch, if ``instanceNormalization = false``.
  /// and the values provided in parameters "mean" and "variance" are ignored.
  var computeMeanVar: Bool {
    get {return _storage._computeMeanVar}
    set {_uniqueStorage()._computeMeanVar = newValue}
  }

  var instanceNormalization: Bool {
    get {return _storage._instanceNormalization}
    set {_uniqueStorage()._instanceNormalization = newValue}
  }

  ///*
  /// A small constant to avoid division by 0 while normalizing by variance.
  /// Defaults to ``1e-5`` if not set or set to ``0``.
  var epsilon: Float {
    get {return _storage._epsilon}
    set {_uniqueStorage()._epsilon = newValue}
  }

  //// Parameter of length [channels]
  var gamma: CoreML_Specification_WeightParams {
    get {return _storage._gamma ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._gamma = newValue}
  }
  /// Returns true if `gamma` has been explicitly set.
  var hasGamma: Bool {return _storage._gamma != nil}
  /// Clears the value of `gamma`. Subsequent reads from it will return its default value.
  mutating func clearGamma() {_uniqueStorage()._gamma = nil}

  //// Parameter of length [channels]
  var beta: CoreML_Specification_WeightParams {
    get {return _storage._beta ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._beta = newValue}
  }
  /// Returns true if `beta` has been explicitly set.
  var hasBeta: Bool {return _storage._beta != nil}
  /// Clears the value of `beta`. Subsequent reads from it will return its default value.
  mutating func clearBeta() {_uniqueStorage()._beta = nil}

  //// Parameter of length [channels]
  var mean: CoreML_Specification_WeightParams {
    get {return _storage._mean ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._mean = newValue}
  }
  /// Returns true if `mean` has been explicitly set.
  var hasMean: Bool {return _storage._mean != nil}
  /// Clears the value of `mean`. Subsequent reads from it will return its default value.
  mutating func clearMean() {_uniqueStorage()._mean = nil}

  //// Parameter of length [channels]
  var variance: CoreML_Specification_WeightParams {
    get {return _storage._variance ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._variance = newValue}
  }
  /// Returns true if `variance` has been explicitly set.
  var hasVariance: Bool {return _storage._variance != nil}
  /// Clears the value of `variance`. Subsequent reads from it will return its default value.
  mutating func clearVariance() {_uniqueStorage()._variance = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A spatial pooling layer.
///
/// .. code::
///
///      y = PoolingLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank greater than equal to 4.
///     Rank 4 blob represents [Batch, channels, height, width]
///     For ranks greater than 4, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     Rank is same as the input. e.g.: for rank 4 input, output shape is [B, C, H_out, W_out]
///
/// Padding options are similar to ``ConvolutionLayerParams``
/// with the additional option of ``ValidCompletePadding`` (``includeLastPixel``),
/// which ensures that the last application of the kernel
/// always includes the last pixel of the input image, if there is padding.
///
/// .. code::
///
///     H_out = ceil(float(H_in + 2 * paddingAmounts[0] - kernelSize[0])/float(Stride[0])) + 1
///     if (paddingAmounts[0] > 0 or paddingAmounts[1] > 0)
///          if ((H_out - 1) * Stride >= H_in + paddingAmounts[0]) {
///              H_out = H_out - 1
///          }
///     }
///
/// The equivalent expressions hold true for ``W_out`` as well.
/// Only symmetric padding is supported with this option.
struct CoreML_Specification_PoolingLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Type of pooling operation.
  var type: CoreML_Specification_PoolingLayerParams.PoolingType = .max

  ///*
  /// Must be length 2 in the order ``[H, W]``.
  /// If not set, default value ``[3, 3]`` is used.
  var kernelSize: [UInt64] = []

  ///*
  /// Must be length 2 in the order ``[H, W]``.
  /// If not set, default value ``[1, 1]`` is used.
  var stride: [UInt64] = []

  var poolingPaddingType: CoreML_Specification_PoolingLayerParams.OneOf_PoolingPaddingType? = nil

  var valid: CoreML_Specification_ValidPadding {
    get {
      if case .valid(let v)? = poolingPaddingType {return v}
      return CoreML_Specification_ValidPadding()
    }
    set {poolingPaddingType = .valid(newValue)}
  }

  var same: CoreML_Specification_SamePadding {
    get {
      if case .same(let v)? = poolingPaddingType {return v}
      return CoreML_Specification_SamePadding()
    }
    set {poolingPaddingType = .same(newValue)}
  }

  var includeLastPixel: CoreML_Specification_PoolingLayerParams.ValidCompletePadding {
    get {
      if case .includeLastPixel(let v)? = poolingPaddingType {return v}
      return CoreML_Specification_PoolingLayerParams.ValidCompletePadding()
    }
    set {poolingPaddingType = .includeLastPixel(newValue)}
  }

  ///*
  /// If true, padded values are excluded from the count (denominator)
  /// when computing average pooling.
  var avgPoolExcludePadding: Bool = false

  ///*
  /// If true, global pooling is performed.
  /// Kernel size is inferred from the input data spatial dimensions.
  var globalPooling: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_PoolingPaddingType: Equatable {
    case valid(CoreML_Specification_ValidPadding)
    case same(CoreML_Specification_SamePadding)
    case includeLastPixel(CoreML_Specification_PoolingLayerParams.ValidCompletePadding)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_PoolingLayerParams.OneOf_PoolingPaddingType, rhs: CoreML_Specification_PoolingLayerParams.OneOf_PoolingPaddingType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.valid, .valid): return {
        guard case .valid(let l) = lhs, case .valid(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.same, .same): return {
        guard case .same(let l) = lhs, case .same(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.includeLastPixel, .includeLastPixel): return {
        guard case .includeLastPixel(let l) = lhs, case .includeLastPixel(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  enum PoolingType: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case max // = 0
    case average // = 1
    case l2 // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .max
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .max
      case 1: self = .average
      case 2: self = .l2
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .max: return 0
      case .average: return 1
      case .l2: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  struct ValidCompletePadding {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    ///*
    /// Must be length 2 in order ``[H, W]``.
    /// If not set, value ``[0, 0]`` is used.
    var paddingAmounts: [UInt64] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_PoolingLayerParams.PoolingType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_PoolingLayerParams.PoolingType] = [
    .max,
    .average,
    .l2,
  ]
}

#endif  // swift(>=4.2)

///
/// A layer to pool three spatial dimensions
///
/// Input
///      A blob with rank equal to 5, representing [Batch, channels, depth, height, width].
///
/// Output
///      Rank is same as the input: A blob with rank equal to 5, representing [Batch, channels, depth, height, width].
///
/// Requires 1 input and produces 1 output.
///
/// For example, given an input of shape (1,1,2,3,3):
///        +----+----+----+
///      / | 10 | 11 | 12 |
///     /  +----+----+----+
///    /   | 13 | 14 | 15 |
///   /    +----+----+----+
///  /     | 16 | 17 | 18 |
/// /      +----+----+----+
/// +----+----+----+      /
/// |  1 |  2 |  3 |     /
/// +----+----+----+    /
/// |  4 |  5 |  6 |   /
/// +----+----+----+  /
/// |  7 |  8 |  9 | /
/// +----+----+----+
///
/// And applying MAX pooling using:
///      Kernel: 2x2x2
///      Stride: 1x1x1
///      Valid Padding
/// We expect to get an output with shape: (1,1,1,2,2) and value:
/// +----+----+
/// | 14 | 15 |
/// +----+----+
/// | 17 | 18 |
/// +----+----+
struct CoreML_Specification_Pooling3DLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Whether to use Max or Average
  var type: CoreML_Specification_Pooling3DLayerParams.PoolingType3D = .max

  /// Depth of the pooling region.
  var kernelDepth: Int32 = 0

  /// Height of the pooling region.
  var kernelHeight: Int32 = 0

  /// Width of the pooling region.
  var kernelWidth: Int32 = 0

  /// Stride along the depth direction
  var strideDepth: Int32 = 0

  /// Stride along the height direction
  var strideHeight: Int32 = 0

  /// Stride along the width direction
  var strideWidth: Int32 = 0

  var paddingType: CoreML_Specification_Pooling3DLayerParams.Pooling3DPaddingType = .custom

  /// Padding before the input in the depth direction.
  var customPaddingFront: Int32 = 0

  /// Padding after the input in the depth direction.
  var customPaddingBack: Int32 = 0

  /// Padding before the input in the height direction.
  var customPaddingTop: Int32 = 0

  /// Padding after the input in the height direction.
  var customPaddingBottom: Int32 = 0

  /// Padding before the input in the width direction.
  var customPaddingLeft: Int32 = 0

  /// Padding after the input in the width direction.
  var customPaddingRight: Int32 = 0

  /// If true, exclude zeros from padding in Average pooling.  Meaningless in Max Pooling.
  var countExcludePadding: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum PoolingType3D: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case max // = 0
    case average // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .max
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .max
      case 1: self = .average
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .max: return 0
      case .average: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  ///*
  /// The type of padding.
  /// All padding types pad the input shape with zeros.
  /// CUSTOM padding will add the custom padding values specified below to their respective
  /// dimensions, e.g., `customPaddingFront` number of zeros will be added to one side of the
  /// input's depth dimension and `customPaddingBack` number of zeros will be added to the other
  /// side of the input's depth dimension.
  /// VALID padding adds no padding to any dimension. In this case, the last pool along
  /// each dimension will be dropped if the input dimension and the kernel size, and stride do not match.
  /// SAME padding adds enough padding to each dimension such that the output
  /// has the same spatial dimensions as the input. Padding is added evenly to both
  /// sides of each dimension unless the total padding to add is odd, in which case the extra padding
  /// is added to the back/bottom/right side of the respective dimension.  For example, if the
  /// total horizontal padding is 3, then there will be 1 padding on the left, and 2 padding on the right.
  enum Pooling3DPaddingType: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case custom // = 0
    case valid // = 1
    case same // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .custom
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .custom
      case 1: self = .valid
      case 2: self = .same
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .custom: return 0
      case .valid: return 1
      case .same: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_Pooling3DLayerParams.PoolingType3D: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_Pooling3DLayerParams.PoolingType3D] = [
    .max,
    .average,
  ]
}

extension CoreML_Specification_Pooling3DLayerParams.Pooling3DPaddingType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_Pooling3DLayerParams.Pooling3DPaddingType] = [
    .custom,
    .valid,
    .same,
  ]
}

#endif  // swift(>=4.2)

///
/// A layer to pool three spatial dimensions down to one value.
/// This behaves like a special case of Pooling3DLayerParams in which
/// the Kernel is the size of the input and there is no padding.
///
/// Input
///      A blob with rank equal to 5, representing [Batch, channels, depth, height, width].
///
/// Output
///      Rank is same as the input: A blob with rank equal to 5, representing [Batch, channels, depth, height, width].
///      Depth, height, and width of the output will always be 1.
///
/// Requires 1 input and produces 1 output.
///
/// For example, given an input of shape (1,1,2,3,3):
///        +----+----+----+
///      / | 10 | 11 | 12 |
///     /  +----+----+----+
///    /   | 13 | 14 | 15 |
///   /    +----+----+----+
///  /     | 16 | 17 | 18 |
/// /      +----+----+----+
/// +----+----+----+      /
/// |  1 |  2 |  3 |     /
/// +----+----+----+    /
/// |  4 |  5 |  6 |   /
/// +----+----+----+  /
/// |  7 |  8 |  9 | /
/// +----+----+----+
///
/// And applying MAX global 3d pooling, we expect to get an output with shape: (1,1,1,1,1) and value:
/// +----+
/// | 18 |
/// +----+
struct CoreML_Specification_GlobalPooling3DLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Whether to use Max or Average
  var type: CoreML_Specification_GlobalPooling3DLayerParams.GlobalPoolingType3D = .max

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum GlobalPoolingType3D: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case max // = 0
    case average // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .max
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .max
      case 1: self = .average
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .max: return 0
      case .average: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_GlobalPooling3DLayerParams.GlobalPoolingType3D: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_GlobalPooling3DLayerParams.GlobalPoolingType3D] = [
    .max,
    .average,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that performs padding along spatial dimensions.
///
/// .. code::
///
///      y = PaddingLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 2.
///     e.g.: blob with shape ``[H_in, W_in]``.
///     For ranks greater than 2, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch
///     i.e. Padding is applied on last two dimensions.
///
/// Output
///     Same rank as the input.
///     e.g.: blob with shape ``[H_out, W_out]``.
///
/// Output dimensions are calculated as follows:
///
/// .. code::
///
///     H_out = H_in + topPaddingAmount + bottomPaddingAmount
///     W_out = W_in + leftPaddingAmount + rightPaddingAmount
///
///     topPaddingAmount == Height startEdgeSize == borderAmounts[0].startEdgeSize
///     bottomPaddingAmount == Height endEdgeSize == borderAmounts[0].endEdgeSize
///     leftPaddingAmount == Width startEdgeSize == borderAmounts[1].startEdgeSize
///     rightPaddingAmount == Width endEdgeSize == borderAmounts[1].endEdgeSize
///
/// There are three types of padding:
///
/// - ``PaddingConstant``, which fills a constant value at the border.
/// - ``PaddingReflection``, which reflects the values at the border.
/// - ``PaddingReplication``, which replicates the values at the border.
///
/// Given the following input:
///
/// .. code::
///
///     [1, 3, 4]  :  1   2   3   4
///                   5   6   7   8
///                   9   10  11  12
///
/// Here is the output of applying the padding
/// ``(top=2, left=2, bottom=0, right=0)``
/// with each of the supported types:
///
/// - ``PaddingConstant`` (``value = 0``):
///   .. code::
///
///       [1, 5, 6]  :  0   0   0  0   0   0
///                     0   0   0  0   0   0
///                     0   0   1  2   3   4
///                     0   0   5  6   7   8
///                     0   0   9  10  11  12
///
/// - ``PaddingReflection``:
///   .. code::
///
///       [1, 5, 6]  :  11  10  9  10  11  12
///                     7   6   5  6   7   8
///                     3   2   1  2   3   4
///                     7   6   5  6   7   8
///                     11  10  9  10  11  12
///
/// - ``PaddingReplication``:
///   .. code::
///
///       [1, 5, 6]  :  1   1   1  2   3   4
///                     1   1   1  2   3   4
///                     1   1   1  2   3   4
///                     5   5   5  6   7   8
///                     9   9   9  10  11  12
struct CoreML_Specification_PaddingLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var paddingType: CoreML_Specification_PaddingLayerParams.OneOf_PaddingType? = nil

  var constant: CoreML_Specification_PaddingLayerParams.PaddingConstant {
    get {
      if case .constant(let v)? = paddingType {return v}
      return CoreML_Specification_PaddingLayerParams.PaddingConstant()
    }
    set {paddingType = .constant(newValue)}
  }

  var reflection: CoreML_Specification_PaddingLayerParams.PaddingReflection {
    get {
      if case .reflection(let v)? = paddingType {return v}
      return CoreML_Specification_PaddingLayerParams.PaddingReflection()
    }
    set {paddingType = .reflection(newValue)}
  }

  var replication: CoreML_Specification_PaddingLayerParams.PaddingReplication {
    get {
      if case .replication(let v)? = paddingType {return v}
      return CoreML_Specification_PaddingLayerParams.PaddingReplication()
    }
    set {paddingType = .replication(newValue)}
  }

  //// Amounts to be padded to the input.
  var paddingAmounts: CoreML_Specification_BorderAmounts {
    get {return _paddingAmounts ?? CoreML_Specification_BorderAmounts()}
    set {_paddingAmounts = newValue}
  }
  /// Returns true if `paddingAmounts` has been explicitly set.
  var hasPaddingAmounts: Bool {return self._paddingAmounts != nil}
  /// Clears the value of `paddingAmounts`. Subsequent reads from it will return its default value.
  mutating func clearPaddingAmounts() {self._paddingAmounts = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_PaddingType: Equatable {
    case constant(CoreML_Specification_PaddingLayerParams.PaddingConstant)
    case reflection(CoreML_Specification_PaddingLayerParams.PaddingReflection)
    case replication(CoreML_Specification_PaddingLayerParams.PaddingReplication)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_PaddingLayerParams.OneOf_PaddingType, rhs: CoreML_Specification_PaddingLayerParams.OneOf_PaddingType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.constant, .constant): return {
        guard case .constant(let l) = lhs, case .constant(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.reflection, .reflection): return {
        guard case .reflection(let l) = lhs, case .reflection(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.replication, .replication): return {
        guard case .replication(let l) = lhs, case .replication(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  ///*
  /// Fill a constant value in the padded region.
  struct PaddingConstant {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var value: Float = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  ///*
  /// Reflect the values at the border for padding.
  struct PaddingReflection {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  ///*
  /// Replicate the values at the border for padding.
  struct PaddingReplication {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _paddingAmounts: CoreML_Specification_BorderAmounts? = nil
}

///*
/// A layer that concatenates along the axis = -3 or -5.
/// For general concatenation along any axis, see ConcatNDLayer.
///
/// .. code::
///
///      y = ConcatLayer(x1,x2,....)
///
/// Requires more than 1 input and produces 1 output.
///
/// Input
///   All input blobs must have same rank.
///   If "sequenceConcat" = False, rank must be greater than equal to 3. In this case concatenation is along axis = -3
///   If "sequenceConcat" = True, rank must be greater than equal to 5. In this case concatenation is along axis = -5
///
/// Output
///   Same rank as the input.
struct CoreML_Specification_ConcatLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// If true, concatenate along the axis = -5 instead of axis = -3.
  var sequenceConcat: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs local response normalization (LRN).
///
/// .. code::
///
///      y = LRNLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank greater than equal to 3.
///     Example: Rank 4 blob represents [Batch, channels, height, width]
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     A blob with the same shape as the input.
///
/// This layer is described by the following formula:
///
/// .. math::
///     x_i \leftarrow  \dfrac{x_i}{\left ( k + \dfrac{\alpha}{\text{localSize}} \sum_j x_j^2 \right )^\beta}
///
/// where the summation is done over a ``(localSize, 1, 1)`` neighborhood ---
/// that is, over a window "across" channels in 1x1 spatial neighborhoods.
struct CoreML_Specification_LRNLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var beta: Float = 0

  //// Number of channels in the normalization window.
  var localSize: UInt64 = 0

  //// Defaults to 1 if not set or 0. Must be strictly positive.
  var k: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Softmax Normalization Layer
///
/// A layer that performs softmax normalization.
/// Normalization is applied along axis = -3 or N-3 (where N is the rank of the input)
/// For softmax layer that can operate on any axis, see SoftmaxNDLayer.
///
///
/// .. code::
///
///      y = SoftmaxLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     Must be a blob with rank >= 3.
/// Output
///     A blob with the same shape as the input.
///
/// This layer is described by the following formula:
///
/// .. math::
///     x_i \leftarrow \dfrac{e^{x_i}}{\sum_i{e^{x_i}}}
struct CoreML_Specification_SoftmaxLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that uniformly splits across axis = -3 to produce a specified number of outputs.
/// For general split operation along any axis, see SplitNDLayer.
///
/// .. code::
///
///      (y1,y2,...yN) = SplitLayer(x), where N = nOutputs
///
/// Requires 1 input and produces multiple outputs.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H, W]``
/// Output
///     ``nOutputs`` blobs each with same rank as the input.
///     e.g.: For input that is of shape ``[C, H, W]``, output shapes will be ``[C/nOutputs, H, W]``
struct CoreML_Specification_SplitLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// The number of outputs.
  var nOutputs: UInt64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs elementwise addition.
/// This layer has limited broadcasting support. For general broadcasting see AddBroadcastableLayer.
///
/// .. code::
///
///      y = AddLayer(x1,x2,...)
///
/// Requires 1 or more than 1 input and produces 1 output.
///
/// Input
///     In general, there are no rank constraints.
///     However, only certain set of shapes are broadcastable. For example:
///     [B, 1, 1, 1], [B, C, 1, 1], [B, 1, H, W], [B, C, H, W]
/// Output
///     A blob with shape equal to the input blob.
///
/// If only one input is provided, scalar addition is performed:
///
/// .. math::
///     y = x + \alpha
struct CoreML_Specification_AddLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Scalar to be added to the input.
  /// Only used if there is a single input.
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs elementwise multiplication.
/// This layer has limited broadcasting support. For general broadcasting see MultiplyBroadcastableLayer.
///
/// .. code::
///
///      y = MultiplyLayer(x1,x2,...)
///
/// Requires 1 or more than 1 input and produces 1 output.
///
/// Input
///     In general, there are no rank constraints.
///     However, only certain set of shapes are broadcastable. For example:
///     [B, 1, 1, 1], [B, C, 1, 1], [B, 1, H, W], [B, C, H, W]
/// Output
///     A blob with shape equal to the first input blob.
///
/// If only one input is provided, scalar multiplication is performed:
///
/// .. math::
///     y = \alpha x
struct CoreML_Specification_MultiplyLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Scalar to be multiplied with the input.
  /// Only used if there is a single input.
  var alpha: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that applies a unary function.
///
/// .. code::
///
///      y = UnaryFunctionLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with no rank constraints.
/// Output
///     A blob with the same shape as the input.
///
/// The input is first modified by shifting and scaling:
///
/// .. math::
///     x \leftarrow \text{scale} \cdot x + \text{shift}
struct CoreML_Specification_UnaryFunctionLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// The type of unary function.
  var type: CoreML_Specification_UnaryFunctionLayerParams.Operation = .sqrt

  ///*
  /// A constant used in ``POWER`` and ``THRESHOLD`` functions.
  var alpha: Float = 0

  ///*
  /// A small constant to avoid division by 0 while normalizing variance.
  /// Defaults to ``1e-6`` if not set or set to ``0``.
  var epsilon: Float = 0

  ///*
  /// Input is shifted by this amount
  /// before the unary function is applied.
  /// Defaults to ``0.0`` if not set.
  var shift: Float = 0

  ///*
  /// Input is scaled by this amount
  /// before the unary function is applied.
  /// Defaults to ``1.0`` if not set or set to ``0``.
  var scale: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  ///*
  /// A unary operator.
  ///
  /// The following functions are supported:
  ///
  /// ``SQRT``
  ///     .. math:: f(x) = \sqrt{x}
  ///
  /// ``RSQRT``
  ///     .. math:: f(x) = \dfrac{1}{\sqrt{x + \epsilon}}
  ///
  /// ``INVERSE``
  ///     .. math:: f(x) = \dfrac{1}{x + \epsilon}
  ///
  /// ``POWER``
  ///     .. math:: f(x) = x^\alpha
  ///
  /// ``EXP``
  ///     .. math:: f(x) = e^x
  ///
  /// ``LOG``
  ///     .. math:: f(x) = \log x
  ///
  /// ``ABS``
  ///     .. math:: f(x) = |x|
  ///
  /// ``THRESHOLD``
  ///     .. math:: f(x) = \text{max}(\alpha, x)
  enum Operation: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case sqrt // = 0
    case rsqrt // = 1
    case inverse // = 2
    case power // = 3
    case exp // = 4
    case log // = 5
    case abs // = 6
    case threshold // = 7
    case UNRECOGNIZED(Int)

    init() {
      self = .sqrt
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .sqrt
      case 1: self = .rsqrt
      case 2: self = .inverse
      case 3: self = .power
      case 4: self = .exp
      case 5: self = .log
      case 6: self = .abs
      case 7: self = .threshold
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .sqrt: return 0
      case .rsqrt: return 1
      case .inverse: return 2
      case .power: return 3
      case .exp: return 4
      case .log: return 5
      case .abs: return 6
      case .threshold: return 7
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_UnaryFunctionLayerParams.Operation: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_UnaryFunctionLayerParams.Operation] = [
    .sqrt,
    .rsqrt,
    .inverse,
    .power,
    .exp,
    .log,
    .abs,
    .threshold,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that scales up spatial dimensions.
/// It supports two modes: nearest neighbour (default) and bilinear.
///
/// .. code::
///
///      y = UpsampleLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H, W]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     Same rank as the input.
///     e.g.: blob with shape ``[C, scalingFactor[0] * H, scalingFactor[1] * W]``
struct CoreML_Specification_UpsampleLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Scaling Factor. Mutually exclusive with fractionalScalingFactor.
  /// Must be length 2 in order ``[H, W]``.
  /// If not set, default value ``[1, 1]`` is used.
  var scalingFactor: [UInt64] = []

  ///*
  /// Fractional scaling factor. Mutually exclusive with scalingFactor.
  /// Must be length 2 in order ``[H, W]``.
  /// If not set, default value ``[1.0, 1.0]`` is used.
  var fractionalScalingFactor: [Float] = []

  var mode: CoreML_Specification_UpsampleLayerParams.InterpolationMode = .nn

  var linearUpsampleMode: CoreML_Specification_UpsampleLayerParams.LinearUpsampleMode = .default

  var unknownFields = SwiftProtobuf.UnknownStorage()

  ///
  /// Overall mode for interpolating new elements when upsampling.
  /// NN - Nearest Neighbors - simply pick the nearest true value for interpolated values.
  /// BILINEAR - Use bilinear interpolation. See LinearUpsamplingMode for behavior.
  enum InterpolationMode: SwiftProtobuf.Enum {
    typealias RawValue = Int

    //// Nearest Neighbour
    case nn // = 0

    //// Bilinear
    case bilinear // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .nn
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .nn
      case 1: self = .bilinear
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .nn: return 0
      case .bilinear: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  ///*
  /// LinearUpsampleMode specifies the behavior for linear upsampling. Only valid when Interpolation Mode is BILINEAR.
  /// If input grid is [0, Xin-1] (corresponding to an input size of Xin), and if the output size is Xout,
  /// then the grid points are sampled in the following manner:
  /// DEFAULT:
  ///   spacing = (Xin-Xin/Xout) / (Xout-1)
  ///   grid_point[i] = min(Xin-1, max(0, i * spacing)), for i = 0,1,2,….,Xout-1
  /// ALIGN_CORNERS_TRUE:
  ///   spacing = (Xin-1) / (Xout-1)
  ///   grid_point[i] = min(Xin-1, max(0, i * spacing)), for i = 0,1,2,….,Xout-1
  /// ALIGN_CORNERS_FALSE:
  ///   spacing = Xin / Xout
  ///   grid_point[i] = min(Xin-1, max(0, i * spacing + 0.5 * spacing - 0.5)), for i = 0,1,2,….,Xout-1
  enum LinearUpsampleMode: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case `default` // = 0
    case alignCornersTrue // = 1
    case alignCornersFalse // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .default
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .default
      case 1: self = .alignCornersTrue
      case 2: self = .alignCornersFalse
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .default: return 0
      case .alignCornersTrue: return 1
      case .alignCornersFalse: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_UpsampleLayerParams.InterpolationMode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_UpsampleLayerParams.InterpolationMode] = [
    .nn,
    .bilinear,
  ]
}

extension CoreML_Specification_UpsampleLayerParams.LinearUpsampleMode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_UpsampleLayerParams.LinearUpsampleMode] = [
    .default,
    .alignCornersTrue,
    .alignCornersFalse,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that resizes the input to a pre-specified spatial size using bilinear interpolation.
///
/// .. code::
///
///      y = ResizeBilinearLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H_in, W_in]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     Same rank as the input.
///     e.g.: blob with shape ``[C, H_out, W_out]``.
struct CoreML_Specification_ResizeBilinearLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Target Spatial Size.
  /// Must be length 2 in order ``[Height, Width]``, i.e. ``[H_out, W_out]``.
  /// If not set, default value ``[1, 1]`` is used.
  var targetSize: [UInt64] = []

  ///*
  /// Mode used to compute the grid on which the spatial output values are evaluated.
  /// Same mode is applied to both the height and width axes.
  var mode: CoreML_Specification_SamplingMode {
    get {return _mode ?? CoreML_Specification_SamplingMode()}
    set {_mode = newValue}
  }
  /// Returns true if `mode` has been explicitly set.
  var hasMode: Bool {return self._mode != nil}
  /// Clears the value of `mode`. Subsequent reads from it will return its default value.
  mutating func clearMode() {self._mode = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _mode: CoreML_Specification_SamplingMode? = nil
}

///*
/// A layer that extracts cropped spatial patches or RoIs (regions of interest) from the input and resizes them to a pre-specified size using
/// bilinear interpolation.
/// Note that RoI Align layer can be implemented with this layer followed by a pooling layer.
///
/// .. code::
///
///      y = CropResizeLayer(x)
///
/// Requires 2 inputs and produces 1 output.
///
/// Input
///     There are two inputs.
///     First input represents an image feature map.
///     Second input represents the bounding box coordinates for N patches or RoIs (region of interest).
///
///     First input is rank 5: [1, Batch, C, H_in, W_in].
///     Second input is rank 5. Its shape can be either [N, 1, 4, 1, 1] or [N, 1, 5, 1, 1].
///
///     N: number of patches/RoIs to be extracted
///
///     If RoI shape = ``[N, 1, 4, 1, 1]``
///                    The axis=-3 corresponds to the four coordinates specifying the bounding box.
///                    All the N RoIs are extracted from all the batches of the input.
///
///     If RoI shape = ``[N, 1, 5, 1, 1]``
///                     The first element of the axis=-3 specifies the input batch id from which to extract the RoI and
///                               must be in the interval ``[0, Batch - 1]``. That is, n-th RoI is extracted from the RoI[n,0,0,0,0]-th
///                     input batch id. The last four elements of the axis=-3 specify the bounding box coordinates.
///
/// Output
///     A blob with rank 5.
///           - Shape is [N, Batch, C, H_out, W_out] if input RoI shape is [N, 1, 4, 1, 1]
///           - Shape is [N, 1, C, H_out, W_out] if input RoI shape is [N, 1, 5, 1, 1]
struct CoreML_Specification_CropResizeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Target Spatial Size.
  /// Must be length 2 in order ``[Height, Width]``, i.e. ``[H_out, W_out]``.
  /// If not set, default value ``[1, 1]`` is used.
  var targetSize: [UInt64] = []

  ///*
  /// If true the bounding box coordinates must be in the interval [0, 1].
  /// They are scaled by (H_in - 1), (W_in - 1), i.e. based on the input spatial dimensions.
  /// If false the bounding box coordinates must be in the interval
  /// [0, H_in -1] and [0, W_in - 1], respectively for height and width dimensions.
  var normalizedCoordinates: Bool = false

  ///*
  /// Mode used to compute the grid on which the spatial output values are evaluated.
  /// Same mode is applied to both the height and width axes.
  var mode: CoreML_Specification_SamplingMode {
    get {return _mode ?? CoreML_Specification_SamplingMode()}
    set {_mode = newValue}
  }
  /// Returns true if `mode` has been explicitly set.
  var hasMode: Bool {return self._mode != nil}
  /// Clears the value of `mode`. Subsequent reads from it will return its default value.
  mutating func clearMode() {self._mode = nil}

  ///*
  /// Representation used to express the bounding box coordinates.
  /// It determines how the values of the second input are interpreted.
  var boxIndicesMode: CoreML_Specification_BoxCoordinatesMode {
    get {return _boxIndicesMode ?? CoreML_Specification_BoxCoordinatesMode()}
    set {_boxIndicesMode = newValue}
  }
  /// Returns true if `boxIndicesMode` has been explicitly set.
  var hasBoxIndicesMode: Bool {return self._boxIndicesMode != nil}
  /// Clears the value of `boxIndicesMode`. Subsequent reads from it will return its default value.
  mutating func clearBoxIndicesMode() {self._boxIndicesMode = nil}

  ///*
  /// Additional spatial scale that multiplies the bounding box coordinates.
  /// Generally used while implementing the RoI Align layer,
  /// which uses unnormalized RoI coordinates along with a spatial scale less than or equal to 1.
  var spatialScale: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _mode: CoreML_Specification_SamplingMode? = nil
  fileprivate var _boxIndicesMode: CoreML_Specification_BoxCoordinatesMode? = nil
}

///*
/// A layer that performs elementwise addition of a bias,
/// which is broadcasted to match the input shape.
///
/// .. code::
///
///      y = BiasLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H, W]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     A blob with the same shape as the input.
struct CoreML_Specification_BiasLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The shape of the bias.
  /// Must be one of the following:
  /// ``[1]``, ``[C]``, ``[1, H, W]`` or ``[C, H, W]``.
  var shape: [UInt64] = []

  ///*
  /// The bias values.
  /// The size must be equal to the product of the ``shape`` dimensions.
  var bias: CoreML_Specification_WeightParams {
    get {return _bias ?? CoreML_Specification_WeightParams()}
    set {_bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return self._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {self._bias = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _bias: CoreML_Specification_WeightParams? = nil
}

///*
/// A layer that performs elmentwise multiplication by a scale factor
/// and optionally adds a bias;
/// both the scale and bias are broadcasted to match the input shape.
///
/// .. code::
///
///      y = ScaleLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H, W]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     A blob with the same shape as the input.
struct CoreML_Specification_ScaleLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The shape of the scale.
  /// Must be one of the following:
  /// ``[1]``, ``[C]``, ``[1, H, W]`` or ``[C, H, W]``.
  var shapeScale: [UInt64] {
    get {return _storage._shapeScale}
    set {_uniqueStorage()._shapeScale = newValue}
  }

  ///*
  /// The scale values.
  /// The size must be equal to the product of the ``shape`` dimensions.
  var scale: CoreML_Specification_WeightParams {
    get {return _storage._scale ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._scale = newValue}
  }
  /// Returns true if `scale` has been explicitly set.
  var hasScale: Bool {return _storage._scale != nil}
  /// Clears the value of `scale`. Subsequent reads from it will return its default value.
  mutating func clearScale() {_uniqueStorage()._scale = nil}

  //// If true, a bias is added after scaling.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  ///*
  /// The shape of the bias.
  /// Must be one of the following:
  /// ``[1]``, ``[C]``, ``[1, H, W]`` or ``[C, H, W]``.
  var shapeBias: [UInt64] {
    get {return _storage._shapeBias}
    set {_uniqueStorage()._shapeBias = newValue}
  }

  ///*
  /// The bias values.
  /// The size must be equal to the product of the ``shape`` dimensions.
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that loads data as a parameter and provides it as an output.
/// The output is rank 5. For general rank, see LoadConstantNDLayer.
///
/// .. code::
///
///      y = LoadConstantLayer()
///
/// Requires no input and produces 1 output.
///
/// Output:
///     A blob with rank 5 and shape ``[1, 1, C, H, W]``
struct CoreML_Specification_LoadConstantLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The shape of the constant to be loaded,
  /// which must be``[C, H, W]``, that is length 3.
  var shape: [UInt64] = []

  ///*
  /// The data values,
  /// of size ``C * H * W``.
  var data: CoreML_Specification_WeightParams {
    get {return _data ?? CoreML_Specification_WeightParams()}
    set {_data = newValue}
  }
  /// Returns true if `data` has been explicitly set.
  var hasData: Bool {return self._data != nil}
  /// Clears the value of `data`. Subsequent reads from it will return its default value.
  mutating func clearData() {self._data = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _data: CoreML_Specification_WeightParams? = nil
}

///*
/// A layer that performs L2 normalization, i.e. divides by the
/// the square root of the sum of squares of all elements of input.
///
/// .. code::
///
///      y = L2NormalizeLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank greater than equal to 3.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     A blob with the same shape as the input.
///
/// This layer is described by the following formula:
///
/// .. math::
///     x_i \leftarrow \dfrac{x_i}{\sqrt{\sum{x_i^2} + \epsilon}}
struct CoreML_Specification_L2NormalizeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// A small constant to avoid division by 0 while normalizing variance.
  /// Defaults to ``1e-6`` if not set or set to ``0``.
  var epsilon: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that flattens the input.
///
/// .. code::
///
///      y = FlattenLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank greater than equal to 3.
///     e.g.: Rank 4 blob represents [Batch, C, H, W]
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     Same rank as the input, such that last two dimensions are both 1.
///     e.g.: For rank 4 input, output shape is ``[Batch, C * H * W, 1, 1]``
///
/// There are two X orders: ``CHANNEL_FIRST`` and ``CHANNEL_LAST``.
/// ``CHANNEL_FIRST`` does not require data to be rearranged,
/// because row major ordering is used by internal storage.
/// ``CHANNEL_LAST`` requires data to be rearranged.
struct CoreML_Specification_FlattenLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var mode: CoreML_Specification_FlattenLayerParams.FlattenOrder = .channelFirst

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum FlattenOrder: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case channelFirst // = 0
    case channelLast // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .channelFirst
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .channelFirst
      case 1: self = .channelLast
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .channelFirst: return 0
      case .channelLast: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_FlattenLayerParams.FlattenOrder: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_FlattenLayerParams.FlattenOrder] = [
    .channelFirst,
    .channelLast,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that recasts the input into a new shape.
///
/// .. code::
///
///      y = ReshapeLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank 5.
///     e.g.: ``[1, 1, C, H, W]`` or ``[Seq, 1, C, H, W]``.
/// Output
///     A blob with rank 5.
///     e.g.: ``[1, 1, C_out, H_out, W_out]`` or ``[Seq_out, 1, C_out, H_out, W_out]``.
///
/// There are two reshape orders: ``CHANNEL_FIRST`` and ``CHANNEL_LAST``.
/// ``CHANNEL_FIRST`` is equivalent to
/// flattening the input to ``[Seq, 1, C * H * W, 1, 1]`` in channel first order
/// and then reshaping it to the target shape;
/// no data rearrangement is required.
/// ``CHANNEL_LAST`` is equivalent to
/// flattening the input to ``[Seq, 1, H * W * C, 1, 1]`` in channel last order,
/// reshaping it to ``[Seq_out, 1, H_out, W_out, C_out]`` (it is now in "H_out-major"" order),
/// and then permuting it to ``[C_out, H_out, W_out]``;
/// both the flattening and permuting requires the data to be rearranged.
struct CoreML_Specification_ReshapeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The shape of the output.
  /// Must be of length 3 or 4.
  /// If set to 3, ``targetShape`` is interpreted as
  /// ``[1, 1, C_out, H_out, W_out]``, and sequence length of the input is preserved.
  /// If set to 4, ``targetShape`` is interpreted as
  /// ``[Seq_out, 1, C_out, H_out, W_out]``,
  /// where ``Seq_out`` is the new sequence length.
  var targetShape: [Int64] = []

  var mode: CoreML_Specification_ReshapeLayerParams.ReshapeOrder = .channelFirst

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum ReshapeOrder: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case channelFirst // = 0
    case channelLast // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .channelFirst
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .channelFirst
      case 1: self = .channelLast
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .channelFirst: return 0
      case .channelLast: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_ReshapeLayerParams.ReshapeOrder: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_ReshapeLayerParams.ReshapeOrder] = [
    .channelFirst,
    .channelLast,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that rearranges the dimensions and data of an input.
/// For generic transpose/permute operation see TransposeLayer.
///
/// .. code::
///
///      y = PermuteLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     Must be a rank 5 blob.
///     e.g.: shape ``[Seq, B, C, H, W]``.
/// Output
///     Rank 5 blob. Transposed version of the input, such that dimensions at axis=1 or axis=-4 is unchanged.
///
///
/// Examples:
///
///  Assume input shape is [Seq, B, C, H, W]
///
/// - If ``axis`` is set to ``[0, 3, 1, 2]``,
///   then the output has shape ``[Seq, B, W, C, H]``
///
/// - If ``axis`` is set to ``[3, 1, 2, 0]``,
///   then the output has shape ``[W, B, C, H, Seq]``
///
/// - If ``axis`` is set to ``[0, 3, 2, 1]``,
///   then the output has shape ``[Seq, B, W, H, C]``
///
/// - If ``axis`` is not set, or is set to ``[0, 1, 2, 3]``,
///   the output is the same as the input.
struct CoreML_Specification_PermuteLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The order in which to permute the dimensions.
  /// Must have length 4 and a permutation of ``[0, 1, 2, 3]``.
  var axis: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reorganizes data in the input in specific ways.
///
/// .. code::
///
///      y = ReorganizeDataLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 3.
///     e.g.: blob with shape ``[C, H, W]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
/// Output
///     Same rank as the input.
///     e.g.: blob with shape ``[C_out, H_out, W_out]``.
///
/// mode == SPACE_TO_DEPTH
///  ``[C_out, H_out, W_out]`` : ``[C * blockSize * blockSize, H/blockSize, W/blockSize]``.
///  blockSize must divide H and W.
///  Data is moved from the spatial dimensions to the channel dimension. Input is spatially divided into
///  non-overlapping blocks of size blockSize X blockSize and data from each block is moved into the
///  channel dimension.
///
/// mode == DEPTH_TO_SPACE
///  ``[C_out, H_out, W_out]`` : ``[C/(blockSize * blockSize), H * blockSize, W * blockSize]``.
///  Square of blockSize must divide C.
///  Reverse of SPACE_TO_DEPTH. Data is moved from the channel dimension to the spatial dimensions.
///
/// mode == PIXEL_SHUFFLE
///  ``[C_out, H_out, W_out]`` : ``[C/(blockSize * blockSize), H * blockSize, W *  blockSize]``.
///  Square of blockSize must divide C.
///  Similar to DEPTH_TO_SPACE, but using the pixel-shuffle semantics for channel order in the output space.
///  In both modes, elements along the channel dimension are collapsed into
///  blocks in the spatial dimensions. The difference is in the arrangement of
///  the input-channels' data in the output space. See below example for more
///  detail.
///  (Only available in Core ML Specification >= 5 (iOS >= 14, macOS >= 11.0)
///
///
/// Examples:
///
/// Assume input is the following [C = 8, H = 1, W = 2] tensor:
///
/// .. code::
///
///    [[[1 2]] [[3 4]] [[5 6]] [[7 8]] [[9 10]] [[11 12]] [[13 14]] [[15 16]]]
///
/// If block_size == 2 and mode == DEPTH_TO_SPACE, output will be the following
/// [C = 2, H = 2, W = 4] tensor:
///
/// .. code::
///
///    [[[ 1  5  2  6]
///      [ 9 13 10 14]]
///
///     [[ 3  7  4  8]
///      [11 15 12 16]]]
///
/// For mode == SPACE_TO_DEPTH, the behavior is the same as mode ==
/// DEPTH_TO_SPACE, but with the input and output swapped.
///
/// If block_size == 2 and mode == PIXEL_SHUFFLE, output will be the following
/// [C = 2, H = 2, W = 4] tensor:
///
/// .. code::
///
///    [[[ 1  3  2  4]
///      [ 5  7  6  8]]
///
///     [[ 9 11 10 12]
///      [13 15 14 16]]]
struct CoreML_Specification_ReorganizeDataLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var mode: CoreML_Specification_ReorganizeDataLayerParams.ReorganizationType = .spaceToDepth

  //// must be greater than 1
  var blockSize: UInt64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum ReorganizationType: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case spaceToDepth // = 0
    case depthToSpace // = 1
    case pixelShuffle // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .spaceToDepth
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .spaceToDepth
      case 1: self = .depthToSpace
      case 2: self = .pixelShuffle
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .spaceToDepth: return 0
      case .depthToSpace: return 1
      case .pixelShuffle: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_ReorganizeDataLayerParams.ReorganizationType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_ReorganizeDataLayerParams.ReorganizationType] = [
    .spaceToDepth,
    .depthToSpace,
    .pixelShuffle,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that slices the input data along axis = -1 or -2 or -3.
/// For general slice along any axis, please see SliceStaticLayer/SliceDynamicLayer.
///
/// .. code::
///
///      y = SliceLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob that can, in general, have any rank. However, depending on the value of "axis" ,
///     there may be additional rank constraints.
/// Output
///     A blob with the same rank as the input.
///
/// Sliced section is taken from the interval ``[startIndex, endIndex)``, i.e.
/// startIndex is inclusive while endIndex is exclusive.
/// stride must be positive and represents the step size for slicing.
/// Negative indexing is supported for startIndex and endIndex.
/// -1 denotes N-1, -2 denotes N-2 and so on, where N is the length of the dimension to be sliced.
struct CoreML_Specification_SliceLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// start of the sliced section. Inclusive.
  var startIndex: Int64 = 0

  //// end of sliced section. Exclusive.
  var endIndex: Int64 = 0

  //// The step size. Must be positive.
  var stride: UInt64 = 0

  /// The following mapping is used for interpreting this parameter:
  /// CHANNEL_AXIS => axis = -3, input must have rank at least 3.
  /// HEIGHT_AXIS => axis = -2, input must have rank at least 2.
  /// WIDTH_AXIS => axis = -1
  var axis: CoreML_Specification_SliceLayerParams.SliceAxis = .channelAxis

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum SliceAxis: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case channelAxis // = 0
    case heightAxis // = 1
    case widthAxis // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .channelAxis
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .channelAxis
      case 1: self = .heightAxis
      case 2: self = .widthAxis
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .channelAxis: return 0
      case .heightAxis: return 1
      case .widthAxis: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_SliceLayerParams.SliceAxis: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_SliceLayerParams.SliceAxis] = [
    .channelAxis,
    .heightAxis,
    .widthAxis,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that reduces the input using a specified operation.
///
/// .. code::
///
///      y = ReduceLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob that can, in general, have any rank. However, depending on the value of "axis" ,
///      there may be additional rank constraints.
/// Output
///     A blob with the same rank as the input, which has 1s on the dimensions specified in the parameter "axis"
///
///     Values supported for axis are [-1], [-2], [-3], [-2,-1], [-3,-2,-1]
///     and the equivalent positive values (depending on the rank of the input)
///     For mode == 'ArgMax', axis must be [-1] or [-2] or [-3].
struct CoreML_Specification_ReduceLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Specifies function used to reduce.
  var mode: CoreML_Specification_ReduceLayerParams.ReduceOperation = .sum

  ///*
  /// Used if mode is ``LOGSUM``.
  /// Defaults to ``1e-6`` if not set or is set to ``0``.
  var epsilon: Float = 0

  /// The following mapping is used for interpreting this parameter:
  /// CHW = axis [-3, -2, -1], input must have rank at least 3.
  /// HW = axis [-2, -1], input must have rank at least 2.
  /// C = axis [-3]
  /// H = axis [-2]
  /// W = axis [-1]
  var axis: CoreML_Specification_ReduceLayerParams.ReduceAxis = .chw

  var unknownFields = SwiftProtobuf.UnknownStorage()

  ///
  /// The following reduction operations are supported
  /// and are applied on the specified axis of the input array:
  ///
  /// ``SUM``
  ///     Sum of all elements
  ///
  ///     .. math:: \sum{x_i}
  ///
  /// ``AVG``
  ///     Sum of all elements divided by the number of elements
  ///
  ///     .. math:: \dfrac{\sum^n{x_i}}{n}
  ///
  /// ``PROD``
  ///     Product of all elements
  ///
  ///     .. math:: \prod{x_i}
  ///
  /// ``LOGSUM``
  ///     Sum of the natural logarithm of all elements
  ///
  ///     .. math:: \sum{\ln{(x_i + \epsilon)}}
  ///
  /// ``SUMSQUARE``
  ///     Sum of squares of all elements
  ///
  ///     .. math:: \sum{x^2}
  ///
  /// ``L1``
  ///     L1 normalization of all elements
  ///
  ///     .. math:: ||x||_1 = \sum{|x_i|}
  ///
  /// ``L2``
  ///     L2 normalization of all elements
  ///
  ///     .. math:: ||x||_2 = \sqrt{\sum{x_i^2}}
  ///
  /// ``MAX``
  ///     Maximum of all elements
  ///
  ///     .. math:: \text{max}(x_i)
  ///
  /// ``MIN``
  ///     Minumum of all elements
  ///
  ///     .. math:: \text{min}(x_i)
  ///
  /// ``ARGMAX``
  ///     Argument of the maximum of all elements
  ///
  ///     .. math:: \text{argmax}(x_i)
  enum ReduceOperation: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case sum // = 0
    case avg // = 1
    case prod // = 2
    case logsum // = 3
    case sumsquare // = 4
    case l1 // = 5
    case l2 // = 6
    case max // = 7
    case min // = 8

    //// only supported with axis = C, H or W.
    case argmax // = 9
    case UNRECOGNIZED(Int)

    init() {
      self = .sum
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .sum
      case 1: self = .avg
      case 2: self = .prod
      case 3: self = .logsum
      case 4: self = .sumsquare
      case 5: self = .l1
      case 6: self = .l2
      case 7: self = .max
      case 8: self = .min
      case 9: self = .argmax
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .sum: return 0
      case .avg: return 1
      case .prod: return 2
      case .logsum: return 3
      case .sumsquare: return 4
      case .l1: return 5
      case .l2: return 6
      case .max: return 7
      case .min: return 8
      case .argmax: return 9
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  enum ReduceAxis: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case chw // = 0
    case hw // = 1
    case c // = 2
    case h // = 3
    case w // = 4
    case UNRECOGNIZED(Int)

    init() {
      self = .chw
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .chw
      case 1: self = .hw
      case 2: self = .c
      case 3: self = .h
      case 4: self = .w
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .chw: return 0
      case .hw: return 1
      case .c: return 2
      case .h: return 3
      case .w: return 4
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_ReduceLayerParams.ReduceOperation: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_ReduceLayerParams.ReduceOperation] = [
    .sum,
    .avg,
    .prod,
    .logsum,
    .sumsquare,
    .l1,
    .l2,
    .max,
    .min,
    .argmax,
  ]
}

extension CoreML_Specification_ReduceLayerParams.ReduceAxis: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_ReduceLayerParams.ReduceAxis] = [
    .chw,
    .hw,
    .c,
    .h,
    .w,
  ]
}

#endif  // swift(>=4.2)

///*
/// A layer that crops the spatial dimensions of an input.
/// If two inputs are provided, the shape of the second input is used as the reference shape.
///
/// .. code::
///
///      y = CropLayer(x1) or y = CropLayer(x1,x2)
///
/// Requires 1 or 2 inputs and produces 1 output.
///
/// Input
///    1 or 2 tensors, each with rank at least 3, both inputs must have equal rank.
///    Example:
///     - 1 input case: A blob with shape ``[C, H_in, W_in]``.
///     - 2 input case: 1st blob with shape ``[C, H_in, W_in]``, 2nd blob with shape ``[C, H_out, W_out]``.
///
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     Same rank as the inputs.
///     e.g.: A blob with shape ``[C, H_out, W_out]``.
///
/// If one input is used, output is computed as follows:
///
/// .. code::
///
///      y = x1[:, topCropAmount:H_in - bottomCropAmount, leftCropAmount:W_in - rightCropAmount]
///
///      topCropAmount == Height startEdgeSize == borderAmounts[0].startEdgeSize
///      bottomCropAmount == Height endEdgeSize == borderAmounts[0].endEdgeSize
///      leftCropAmount == Width startEdgeSize == borderAmounts[1].startEdgeSize
///      rightCropAmount == Width endEdgeSize == borderAmounts[1].endEdgeSize
///
///      H_out = H_in - topCropAmount - bottomCropAmount
///      W_out = W_in - leftCropAmount - rightCropAmount
///
/// If two inputs are used, output is computed as follows:
///
/// .. code::
///
///      y = x1[:, offset[0]:offset[0] + H_out, offset[1]:offset[1] + W_out]
struct CoreML_Specification_CropLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The amounts to be cropped from the input.
  /// Used only if a single input is provided.
  var cropAmounts: CoreML_Specification_BorderAmounts {
    get {return _cropAmounts ?? CoreML_Specification_BorderAmounts()}
    set {_cropAmounts = newValue}
  }
  /// Returns true if `cropAmounts` has been explicitly set.
  var hasCropAmounts: Bool {return self._cropAmounts != nil}
  /// Clears the value of `cropAmounts`. Subsequent reads from it will return its default value.
  mutating func clearCropAmounts() {self._cropAmounts = nil}

  ///*
  /// The offset amounts.
  /// Used only if two inputs are provided.
  /// Must be of length 2, in order ``[H, W]``.
  var offset: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _cropAmounts: CoreML_Specification_BorderAmounts? = nil
}

///*
/// A layer that computes the elementwise average of the inputs.
/// This layer has limited broadcasting support. For general broadcasting see AddBroadcastableLayer.
///
/// .. code::
///
///      y = AverageLayer(x1,x2,...)
///
/// Requires multiple inputs and produces 1 output.
///
/// Input
///     In general, there are no rank constraints.
///     However, only certain set of shapes are broadcastable. For example:
///     [B, 1, 1, 1], [B, C, 1, 1], [B, 1, H, W], [B, C, H, W]
/// Output
///     A blob with the same shape as each input.
struct CoreML_Specification_AverageLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the elementwise maximum over the inputs.
///
/// .. code::
///
///      y = MaxLayer(x1,x2,...)
///
/// Requires multiple inputs and produces 1 output.
///
/// Input
///     In general, there are no rank constraints.
///     However, only certain set of shapes are broadcastable. For example:
///     [B, C, 1, 1], [B, C, H, W]
/// Output
///     A blob with the same shape as each input.
struct CoreML_Specification_MaxLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the elementwise minimum over the inputs.
///
/// .. code::
///
///      y = MinLayer(x1,x2,...)
///
/// Requires multiple inputs and produces 1 output.
///
/// Input
///     In general, there are no rank constraints.
///     However, only certain set of shapes are broadcastable. For example:
///     [B, C, 1, 1], [B, C, H, W]
/// Output
///     A blob with the same shape as each input.
struct CoreML_Specification_MinLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the dot product of two vectors.
///
/// .. code::
///
///      y = DotProductLayer(x1,x2)
///
/// Requires 2 inputs and produces 1 output.
///
/// Input
///     Two blobs with rank at least 3, such that the last two dimensions must be 1.
///     e.g.: blobs with shape ``[B, C, 1, 1]``.
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     Same rank as the input.
///     e.g. for rank 4 inputs, output shape: [B, 1, 1, 1]
struct CoreML_Specification_DotProductLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// If true, inputs are normalized first,
  /// thereby computing the cosine similarity.
  var cosineSimilarity: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs mean variance normalization, along axis = -3.
///
/// .. code::
///
///      y = MeanVarianceNormalizeLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank greater than equal to 3.
///     Example: Rank 4 blob represents [Batch, channels, height, width]
///     For ranks greater than 3, the leading dimensions, starting from 0 to -4 (inclusive), are all treated as batch.
///
/// Output
///     A blob with the same shape as the input.
///
/// If ``acrossChannels == true``
/// normalization is performed on flattened input, i.e. the input is reshaped to (Batch,C), where "Batch" contains
/// all dimensions from 0 to -4 (inclusive), and C contains dimensions -1, -2, -3.
///
/// If ``acrossChannels == false``
/// normalization is performed within a channel,
/// across spatial dimensions (i.e. last two dimensions).
struct CoreML_Specification_MeanVarianceNormalizeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// If true, mean and variance are computed across channels.
  var acrossChannels: Bool = false

  ///*
  /// If false, only mean is subtracted.
  var normalizeVariance: Bool = false

  ///*
  /// A small constant to avoid division by 0 while normalizing variance.
  /// Defaults to ``1e-6`` if not set or set to ``0``.
  var epsilon: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that repeats a sequence or the dimension sitting at axis = -5
///
/// .. code::
///
///      y = SequenceRepeatLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     A blob with rank at least 5.
///     e.g: shape ``[Seq, B, C, H, W]``
/// Output
///     A blob with the same rank as the input.
///     e.g.: for input shape ``[Seq, B, C, H, W]``, output shape is ``[nRepetitions * Seq, B, C, H, W]``.
struct CoreML_Specification_SequenceRepeatLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Number of repetitions.
  /// Defaults to ``1`` if not set or set to ``0``.
  var nRepetitions: UInt64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A simple recurrent layer.
///
/// .. code::
///
///      y_t = SimpleRecurrentLayer(x_t, y_{t-1})
///
/// Input
///    A blob of rank 5, with shape `[Seq, Batch, inputVectorSize, 1, 1]``.
///    This represents a sequence of vectors of size ``inputVectorSize``.
/// Output
///    Same rank as the input.
///    Represents a vector of size ``outputVectorSize``. It is either the final output or a sequence of outputs at all time steps.
///
/// - Output Shape: ``[1, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == false``
/// - Output Shape: ``[Seq, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == true``
///
/// This layer is described by the following equation:
///
/// .. math::
///     \boldsymbol{y_t} = f(\mathrm{clip}(W \boldsymbol{x_t} + \
///                                        R \boldsymbol{y_{t-1}} + b))
///
/// - ``W`` is a 2-dimensional weight matrix
///   (``[outputVectorSize, inputVectorSize]``, row-major)
/// - ``R`` is a 2-dimensional recursion matrix
///   (``[outputVectorSize, outputVectorSize]``, row-major)
/// - ``b`` is a 1-dimensional bias vector (``[outputVectorSize]``)
/// - ``f()`` is an activation
/// - ``clip()`` is a function that constrains values between ``[-50.0, 50.0]``
struct CoreML_Specification_SimpleRecurrentLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// The size of the input vectors.
  var inputVectorSize: UInt64 {
    get {return _storage._inputVectorSize}
    set {_uniqueStorage()._inputVectorSize = newValue}
  }

  //// The size of the output vectors.
  var outputVectorSize: UInt64 {
    get {return _storage._outputVectorSize}
    set {_uniqueStorage()._outputVectorSize = newValue}
  }

  ///*
  /// Activations supported are Linear, Sigmoid, Tanh, ReLU, Scaled Tanh (alpha = 1.71, beta = 2/3), Hard sigmoid (alpha = 0.2, beta = 0.5)
  var activation: CoreML_Specification_ActivationParams {
    get {return _storage._activation ?? CoreML_Specification_ActivationParams()}
    set {_uniqueStorage()._activation = newValue}
  }
  /// Returns true if `activation` has been explicitly set.
  var hasActivation: Bool {return _storage._activation != nil}
  /// Clears the value of `activation`. Subsequent reads from it will return its default value.
  mutating func clearActivation() {_uniqueStorage()._activation = nil}

  ///*
  ///If false output is just the result after final state update.
  ///If true, output is a sequence, containing outputs at all time steps.
  var sequenceOutput: Bool {
    get {return _storage._sequenceOutput}
    set {_uniqueStorage()._sequenceOutput = newValue}
  }

  //// If false, no bias is added.
  var hasBiasVector_p: Bool {
    get {return _storage._hasBiasVector_p}
    set {_uniqueStorage()._hasBiasVector_p = newValue}
  }

  //// Weight matrix W.
  var weightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._weightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weightMatrix = newValue}
  }
  /// Returns true if `weightMatrix` has been explicitly set.
  var hasWeightMatrix: Bool {return _storage._weightMatrix != nil}
  /// Clears the value of `weightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearWeightMatrix() {_uniqueStorage()._weightMatrix = nil}

  //// Recursion Weight matrix R.
  var recursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._recursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._recursionMatrix = newValue}
  }
  /// Returns true if `recursionMatrix` has been explicitly set.
  var hasRecursionMatrix: Bool {return _storage._recursionMatrix != nil}
  /// Clears the value of `recursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearRecursionMatrix() {_uniqueStorage()._recursionMatrix = nil}

  //// Bias vector b.
  var biasVector: CoreML_Specification_WeightParams {
    get {return _storage._biasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._biasVector = newValue}
  }
  /// Returns true if `biasVector` has been explicitly set.
  var hasBiasVector: Bool {return _storage._biasVector != nil}
  /// Clears the value of `biasVector`. Subsequent reads from it will return its default value.
  mutating func clearBiasVector() {_uniqueStorage()._biasVector = nil}

  /// If true, then the node processes the input sequence from right to left
  var reverseInput: Bool {
    get {return _storage._reverseInput}
    set {_uniqueStorage()._reverseInput = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// Gated-Recurrent Unit (GRU) Layer
///
/// .. code::
///
///      y_t = GRULayer(x_t, y_{t-1})
///
/// Input
///    A blob of rank 5, with shape `[Seq, Batch, inputVectorSize, 1, 1]``.
///    This represents a sequence of vectors of size ``inputVectorSize``.
/// Output
///    Same rank as the input.
///    Represents a vector of size ``outputVectorSize``. It is either the final output or a sequence of outputs at all time steps.
///
/// - Output Shape: ``[1, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == false``
/// - Output Shape: ``[Seq, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == true``
///
/// This layer is described by the following equations:
///
/// Update Gate
///     .. math::
///         \boldsymbol{z_t} = \
///             f(\mathrm{clip}(W_z \boldsymbol{x_t} + \
///                             R_z \boldsymbol{y_{t-1}} + b_z)
///
/// Reset Gate
///     .. math::
///         \boldsymbol{r_t} = \
///             f(\mathrm{clip}(W_r \boldsymbol{x_t} + \
///                             R_r \boldsymbol{y_{t-1}} + b_r))
///
/// Cell Memory State
///     .. math::
///         \boldsymbol{c_t} = \
///             \boldsymbol{y_{t-1}} \odot \boldsymbol{r_t}
///
/// Output Gate
///     .. math::
///         \boldsymbol{o_t} = \
///             g(\mathrm{clip}(W_o \boldsymbol{x_t} + \
///                             R_o \boldsymbol{c_t} + b_o))
///
/// Output
///     .. math::
///         \boldsymbol{y_t} = \
///             (1 - \boldsymbol{z_t}) \odot \boldsymbol{o_t} + \
///              \boldsymbol{z_t} \odot \boldsymbol{y_{t-1}}
///
/// - ``W_z``, ``W_r``, ``W_o`` are 2-dimensional input weight matrices
///   (``[outputVectorSize, inputVectorSize]``, row-major)
/// - ``R_z``, ``R_r``, ``R_o`` are 2-dimensional recursion matrices
///   (``[outputVectorSize, outputVectorSize]``, row-major)
/// - ``b_z``, ``b_r``, ``b_o`` are 1-dimensional bias vectors
///   (``[outputVectorSize]``)
/// - ``f()``, ``g()`` are activations
/// - ``clip()`` is a function that constrains values between ``[-50.0, 50.0]``
/// - ``⊙`` denotes the elementwise product of matrices
struct CoreML_Specification_GRULayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Size of the input vectors.
  var inputVectorSize: UInt64 {
    get {return _storage._inputVectorSize}
    set {_uniqueStorage()._inputVectorSize = newValue}
  }

  //// Size of the output vectors.
  var outputVectorSize: UInt64 {
    get {return _storage._outputVectorSize}
    set {_uniqueStorage()._outputVectorSize = newValue}
  }

  ///*
  /// 2 element array representing activations [f(), g()] in that order.
  /// Typical values used = [sigmoid, tanh].
  /// Activations supported are Linear, Sigmoid, Tanh, ReLU, Scaled Tanh (alpha = 1.71, beta = 2/3), Hard sigmoid (alpha = 0.2, beta = 0.5)
  var activations: [CoreML_Specification_ActivationParams] {
    get {return _storage._activations}
    set {_uniqueStorage()._activations = newValue}
  }

  ///*
  /// If false output is just the result after final state update.
  /// If true, output is a sequence, containing outputs at all time steps.
  var sequenceOutput: Bool {
    get {return _storage._sequenceOutput}
    set {_uniqueStorage()._sequenceOutput = newValue}
  }

  ///*
  /// If false, no biases (``b_z``, ``b_r``, ``b_o``) are added.
  var hasBiasVectors_p: Bool {
    get {return _storage._hasBiasVectors_p}
    set {_uniqueStorage()._hasBiasVectors_p = newValue}
  }

  //// Weight Matrix W_z.
  var updateGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._updateGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._updateGateWeightMatrix = newValue}
  }
  /// Returns true if `updateGateWeightMatrix` has been explicitly set.
  var hasUpdateGateWeightMatrix: Bool {return _storage._updateGateWeightMatrix != nil}
  /// Clears the value of `updateGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearUpdateGateWeightMatrix() {_uniqueStorage()._updateGateWeightMatrix = nil}

  //// Weight Matrix W_r.
  var resetGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._resetGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._resetGateWeightMatrix = newValue}
  }
  /// Returns true if `resetGateWeightMatrix` has been explicitly set.
  var hasResetGateWeightMatrix: Bool {return _storage._resetGateWeightMatrix != nil}
  /// Clears the value of `resetGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearResetGateWeightMatrix() {_uniqueStorage()._resetGateWeightMatrix = nil}

  //// Weight Matrix W_o.
  var outputGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._outputGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateWeightMatrix = newValue}
  }
  /// Returns true if `outputGateWeightMatrix` has been explicitly set.
  var hasOutputGateWeightMatrix: Bool {return _storage._outputGateWeightMatrix != nil}
  /// Clears the value of `outputGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateWeightMatrix() {_uniqueStorage()._outputGateWeightMatrix = nil}

  //// Recursion Weight Matrix R_z.
  var updateGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._updateGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._updateGateRecursionMatrix = newValue}
  }
  /// Returns true if `updateGateRecursionMatrix` has been explicitly set.
  var hasUpdateGateRecursionMatrix: Bool {return _storage._updateGateRecursionMatrix != nil}
  /// Clears the value of `updateGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearUpdateGateRecursionMatrix() {_uniqueStorage()._updateGateRecursionMatrix = nil}

  //// Recursion Weight Matrix R_r.
  var resetGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._resetGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._resetGateRecursionMatrix = newValue}
  }
  /// Returns true if `resetGateRecursionMatrix` has been explicitly set.
  var hasResetGateRecursionMatrix: Bool {return _storage._resetGateRecursionMatrix != nil}
  /// Clears the value of `resetGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearResetGateRecursionMatrix() {_uniqueStorage()._resetGateRecursionMatrix = nil}

  //// Recursion Weight Matrix R_o.
  var outputGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._outputGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateRecursionMatrix = newValue}
  }
  /// Returns true if `outputGateRecursionMatrix` has been explicitly set.
  var hasOutputGateRecursionMatrix: Bool {return _storage._outputGateRecursionMatrix != nil}
  /// Clears the value of `outputGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateRecursionMatrix() {_uniqueStorage()._outputGateRecursionMatrix = nil}

  //// Bias vector b_z.
  var updateGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._updateGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._updateGateBiasVector = newValue}
  }
  /// Returns true if `updateGateBiasVector` has been explicitly set.
  var hasUpdateGateBiasVector: Bool {return _storage._updateGateBiasVector != nil}
  /// Clears the value of `updateGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearUpdateGateBiasVector() {_uniqueStorage()._updateGateBiasVector = nil}

  //// Bias vector b_r.
  var resetGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._resetGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._resetGateBiasVector = newValue}
  }
  /// Returns true if `resetGateBiasVector` has been explicitly set.
  var hasResetGateBiasVector: Bool {return _storage._resetGateBiasVector != nil}
  /// Clears the value of `resetGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearResetGateBiasVector() {_uniqueStorage()._resetGateBiasVector = nil}

  //// Bias vector b_o.
  var outputGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._outputGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateBiasVector = newValue}
  }
  /// Returns true if `outputGateBiasVector` has been explicitly set.
  var hasOutputGateBiasVector: Bool {return _storage._outputGateBiasVector != nil}
  /// Clears the value of `outputGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateBiasVector() {_uniqueStorage()._outputGateBiasVector = nil}

  //// If true, then the node processes the input sequence from right to left
  var reverseInput: Bool {
    get {return _storage._reverseInput}
    set {_uniqueStorage()._reverseInput = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// Long short-term memory (LSTM) parameters.
///
/// This is described by the following equations:
///
/// Input Gate
///     .. math::
///         \boldsymbol{i_t} = \
///             f(\mathrm{clip}(W_i \boldsymbol{x_t} + \
///                             R_i \boldsymbol{y_{t-1}} + \
///                             p_i \odot c_{t-1} + b_i))
///
/// Forget Gate
///     .. math::
///         \boldsymbol{f_t} = \
///             f(\mathrm{clip}(W_f \boldsymbol{x_t} + \
///                             R_f \boldsymbol{y_{t-1}} + \
///                             p_f \odot c_{t-1} + b_f))
///
/// Block Input
///     .. math::
///         \boldsymbol{z_t} = \
///             g(\mathrm{clip}(W_z \boldsymbol{x_t} + \
///                             R_z \boldsymbol{y_{t-1}} + b_z))
///
/// Cell Memory State
///     .. math::
///         \boldsymbol{c_t} = \
///             \boldsymbol{c_{t-1}} \odot \boldsymbol{f_t} + \
///             \boldsymbol{i_t} \odot \boldsymbol{z_t}
///
/// Output Gate
///     .. math::
///         \boldsymbol{o_t} = \
///             f(\mathrm{clip}(W_o \boldsymbol{x_t} + \
///                             R_o \boldsymbol{y_{t-1}} + \
///                             p_o \odot c_t + b_o))
///
/// Output
///     .. math::
///         \boldsymbol{y_t} = \
///             h(\boldsymbol{c_t}) \odot \boldsymbol{o_t}
///
/// - ``W_i``, ``W_f``, ``W_z``, ``W_o`` are 2-dimensional input weight matrices
///   (``[outputVectorSize, inputVectorSize]``, row-major)
/// - ``R_i``, ``R_f``, ``R_z``, ``R_o`` are 2-dimensional recursion matrices
///   (``[outputVectorSize, outputVectorSize]``, row-major)
/// - ``b_i``, ``b_f``, ``b_z``, ``b_o`` are 1-dimensional bias vectors
///   (``[outputVectorSize]``)
/// - ``p_``, ``p_f``, ``p_o`` are 1-dimensional peephole vectors
///   (``[outputVectorSize]``)
/// - ``f()``, ``g()``, ``h()`` are activations
/// - ``clip()`` is a function that constrains values between ``[-50.0, 50.0]``
/// - ``⊙`` denotes the elementwise product of matrices
struct CoreML_Specification_LSTMParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// If true, output is a sequence, containing outputs at all time steps.
  /// If false, output is just the result after final state update.
  var sequenceOutput: Bool = false

  ///*
  /// If false, no biases (``b_i``, ``b_f``, ``b_z``, ``b_o``) are added.
  var hasBiasVectors_p: Bool = false

  ///*
  /// If true, a vector of ``1`` values is added to ``b_f``.
  var forgetBias: Bool = false

  ///*
  /// If true, peephole vectors are included.
  var hasPeepholeVectors_p: Bool = false

  ///*
  /// If the coupled Input and Forget flag is on, the behaviour of
  /// ``c_t`` is changed to the following (i.e. forget gate is not used):
  ///
  /// .. math::
  ///     \boldsymbol{c_t} = \
  ///         \boldsymbol{c_{t-1}} \odot (1 - \boldsymbol{i_t}) + \
  ///         \boldsymbol{i_t} \odot \boldsymbol{z_t}
  var coupledInputAndForgetGate: Bool = false

  ///*
  /// Places a limit on the maximum and minimum values of ``c_t``.
  /// c_t = min(c_t, cellClipThreshold)
  /// c_t = max(c_t, -cellClipThreshold)
  /// If 0, it is set to its default value = 50.0.
  var cellClipThreshold: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Weights for long short-term memory (LSTM) layers
struct CoreML_Specification_LSTMWeightParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Weight Matrix W_i.
  var inputGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._inputGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._inputGateWeightMatrix = newValue}
  }
  /// Returns true if `inputGateWeightMatrix` has been explicitly set.
  var hasInputGateWeightMatrix: Bool {return _storage._inputGateWeightMatrix != nil}
  /// Clears the value of `inputGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearInputGateWeightMatrix() {_uniqueStorage()._inputGateWeightMatrix = nil}

  //// Weight Matrix W_f.
  var forgetGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._forgetGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._forgetGateWeightMatrix = newValue}
  }
  /// Returns true if `forgetGateWeightMatrix` has been explicitly set.
  var hasForgetGateWeightMatrix: Bool {return _storage._forgetGateWeightMatrix != nil}
  /// Clears the value of `forgetGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearForgetGateWeightMatrix() {_uniqueStorage()._forgetGateWeightMatrix = nil}

  //// Weight Matrix W_z.
  var blockInputWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._blockInputWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._blockInputWeightMatrix = newValue}
  }
  /// Returns true if `blockInputWeightMatrix` has been explicitly set.
  var hasBlockInputWeightMatrix: Bool {return _storage._blockInputWeightMatrix != nil}
  /// Clears the value of `blockInputWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearBlockInputWeightMatrix() {_uniqueStorage()._blockInputWeightMatrix = nil}

  //// Weight Matrix W_o.
  var outputGateWeightMatrix: CoreML_Specification_WeightParams {
    get {return _storage._outputGateWeightMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateWeightMatrix = newValue}
  }
  /// Returns true if `outputGateWeightMatrix` has been explicitly set.
  var hasOutputGateWeightMatrix: Bool {return _storage._outputGateWeightMatrix != nil}
  /// Clears the value of `outputGateWeightMatrix`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateWeightMatrix() {_uniqueStorage()._outputGateWeightMatrix = nil}

  //// Recursion Weight Matrix R_i.
  var inputGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._inputGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._inputGateRecursionMatrix = newValue}
  }
  /// Returns true if `inputGateRecursionMatrix` has been explicitly set.
  var hasInputGateRecursionMatrix: Bool {return _storage._inputGateRecursionMatrix != nil}
  /// Clears the value of `inputGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearInputGateRecursionMatrix() {_uniqueStorage()._inputGateRecursionMatrix = nil}

  //// Recursion Weight Matrix R_f.
  var forgetGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._forgetGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._forgetGateRecursionMatrix = newValue}
  }
  /// Returns true if `forgetGateRecursionMatrix` has been explicitly set.
  var hasForgetGateRecursionMatrix: Bool {return _storage._forgetGateRecursionMatrix != nil}
  /// Clears the value of `forgetGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearForgetGateRecursionMatrix() {_uniqueStorage()._forgetGateRecursionMatrix = nil}

  //// Recursion Weight Matrix R_z.
  var blockInputRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._blockInputRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._blockInputRecursionMatrix = newValue}
  }
  /// Returns true if `blockInputRecursionMatrix` has been explicitly set.
  var hasBlockInputRecursionMatrix: Bool {return _storage._blockInputRecursionMatrix != nil}
  /// Clears the value of `blockInputRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearBlockInputRecursionMatrix() {_uniqueStorage()._blockInputRecursionMatrix = nil}

  //// Recursion Weight Matrix R_o.
  var outputGateRecursionMatrix: CoreML_Specification_WeightParams {
    get {return _storage._outputGateRecursionMatrix ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateRecursionMatrix = newValue}
  }
  /// Returns true if `outputGateRecursionMatrix` has been explicitly set.
  var hasOutputGateRecursionMatrix: Bool {return _storage._outputGateRecursionMatrix != nil}
  /// Clears the value of `outputGateRecursionMatrix`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateRecursionMatrix() {_uniqueStorage()._outputGateRecursionMatrix = nil}

  ///biases:
  var inputGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._inputGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._inputGateBiasVector = newValue}
  }
  /// Returns true if `inputGateBiasVector` has been explicitly set.
  var hasInputGateBiasVector: Bool {return _storage._inputGateBiasVector != nil}
  /// Clears the value of `inputGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearInputGateBiasVector() {_uniqueStorage()._inputGateBiasVector = nil}

  //// Bias vector b_f.
  var forgetGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._forgetGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._forgetGateBiasVector = newValue}
  }
  /// Returns true if `forgetGateBiasVector` has been explicitly set.
  var hasForgetGateBiasVector: Bool {return _storage._forgetGateBiasVector != nil}
  /// Clears the value of `forgetGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearForgetGateBiasVector() {_uniqueStorage()._forgetGateBiasVector = nil}

  //// Bias vector b_z.
  var blockInputBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._blockInputBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._blockInputBiasVector = newValue}
  }
  /// Returns true if `blockInputBiasVector` has been explicitly set.
  var hasBlockInputBiasVector: Bool {return _storage._blockInputBiasVector != nil}
  /// Clears the value of `blockInputBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearBlockInputBiasVector() {_uniqueStorage()._blockInputBiasVector = nil}

  //// Bias vector b_o.
  var outputGateBiasVector: CoreML_Specification_WeightParams {
    get {return _storage._outputGateBiasVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGateBiasVector = newValue}
  }
  /// Returns true if `outputGateBiasVector` has been explicitly set.
  var hasOutputGateBiasVector: Bool {return _storage._outputGateBiasVector != nil}
  /// Clears the value of `outputGateBiasVector`. Subsequent reads from it will return its default value.
  mutating func clearOutputGateBiasVector() {_uniqueStorage()._outputGateBiasVector = nil}

  ///peepholes:
  var inputGatePeepholeVector: CoreML_Specification_WeightParams {
    get {return _storage._inputGatePeepholeVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._inputGatePeepholeVector = newValue}
  }
  /// Returns true if `inputGatePeepholeVector` has been explicitly set.
  var hasInputGatePeepholeVector: Bool {return _storage._inputGatePeepholeVector != nil}
  /// Clears the value of `inputGatePeepholeVector`. Subsequent reads from it will return its default value.
  mutating func clearInputGatePeepholeVector() {_uniqueStorage()._inputGatePeepholeVector = nil}

  //// Peephole vector p_f.
  var forgetGatePeepholeVector: CoreML_Specification_WeightParams {
    get {return _storage._forgetGatePeepholeVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._forgetGatePeepholeVector = newValue}
  }
  /// Returns true if `forgetGatePeepholeVector` has been explicitly set.
  var hasForgetGatePeepholeVector: Bool {return _storage._forgetGatePeepholeVector != nil}
  /// Clears the value of `forgetGatePeepholeVector`. Subsequent reads from it will return its default value.
  mutating func clearForgetGatePeepholeVector() {_uniqueStorage()._forgetGatePeepholeVector = nil}

  //// Peephole vector p_o.
  var outputGatePeepholeVector: CoreML_Specification_WeightParams {
    get {return _storage._outputGatePeepholeVector ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._outputGatePeepholeVector = newValue}
  }
  /// Returns true if `outputGatePeepholeVector` has been explicitly set.
  var hasOutputGatePeepholeVector: Bool {return _storage._outputGatePeepholeVector != nil}
  /// Clears the value of `outputGatePeepholeVector`. Subsequent reads from it will return its default value.
  mutating func clearOutputGatePeepholeVector() {_uniqueStorage()._outputGatePeepholeVector = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A unidirectional long short-term memory (LSTM) layer.
///
/// .. code::
///
///      (y_t, c_t) = UniDirectionalLSTMLayer(x_t, y_{t-1}, c_{t-1})
///
/// Input
///    A blob of rank 5, with shape `[Seq, Batch, inputVectorSize, 1, 1]``.
///    This represents a sequence of vectors of size ``inputVectorSize``.
/// Output
///    Same rank as the input.
///    Represents a vector of size ``outputVectorSize``. It is either the final output or a sequence of outputs at all time steps.
///
/// - Output Shape: ``[1, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == false``
/// - Output Shape: ``[Seq, Batch, outputVectorSize, 1, 1]`` , if ``sequenceOutput == true``
struct CoreML_Specification_UniDirectionalLSTMLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// Size of the input vectors.
  var inputVectorSize: UInt64 = 0

  //// Size of the output vectors.
  var outputVectorSize: UInt64 = 0

  ///*
  /// 3 element array representing activations [f(),g(),h()] in that order.
  /// Typical values used = [sigmoid, tanh, tanh].
  /// Activations supported are Linear, Sigmoid, Tanh, ReLU, Scaled Tanh (alpha = 1.71, beta = 2/3), Hard sigmoid (alpha = 0.2, beta = 0.5)
  var activations: [CoreML_Specification_ActivationParams] = []

  var params: CoreML_Specification_LSTMParams {
    get {return _params ?? CoreML_Specification_LSTMParams()}
    set {_params = newValue}
  }
  /// Returns true if `params` has been explicitly set.
  var hasParams: Bool {return self._params != nil}
  /// Clears the value of `params`. Subsequent reads from it will return its default value.
  mutating func clearParams() {self._params = nil}

  //// Weights, biases and peepholes.
  var weightParams: CoreML_Specification_LSTMWeightParams {
    get {return _weightParams ?? CoreML_Specification_LSTMWeightParams()}
    set {_weightParams = newValue}
  }
  /// Returns true if `weightParams` has been explicitly set.
  var hasWeightParams: Bool {return self._weightParams != nil}
  /// Clears the value of `weightParams`. Subsequent reads from it will return its default value.
  mutating func clearWeightParams() {self._weightParams = nil}

  //// If true, then the node processes the input sequence from right to left
  var reverseInput: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _params: CoreML_Specification_LSTMParams? = nil
  fileprivate var _weightParams: CoreML_Specification_LSTMWeightParams? = nil
}

///*
/// Bidirectional long short-term memory (LSTM) layer
///
/// .. code::
///
///      (y_t, c_t, y_t_reverse, c_t_reverse) = BiDirectionalLSTMLayer(x_t, y_{t-1}, c_{t-1}, y_{t-1}_reverse, c_{t-1}_reverse)
///
/// Input
///    A blob of rank 5, with shape `[Seq, Batch, inputVectorSize, 1, 1]``.
///    This represents a sequence of vectors of size ``inputVectorSize``.
/// Output
///    Same rank as the input.
///    Represents a vector of size ``2 * outputVectorSize``. It is either the final output or a sequence of outputs at all time steps.
///
/// - Output Shape: ``[1, Batch, 2 * outputVectorSize, 1, 1]`` , if ``sequenceOutput == false``
/// - Output Shape: ``[Seq, Batch, 2 * outputVectorSize, 1, 1]`` , if ``sequenceOutput == true``
///
///
/// The first LSTM operates on the input sequence in the forward direction.
/// The second LSTM operates on the input sequence in the reverse direction.
///
/// Example: given the input sequence ``[x_1, x_2, x_3]``,
/// where ``x_i`` are vectors at time index ``i``:
///
/// The forward LSTM output is ``[yf_1, yf_2, yf_3]``,
///
/// where ``yf_i`` are vectors of size ``outputVectorSize``:
///
/// - ``yf_1`` is the output at the end of sequence {``x_1``}
/// - ``yf_2`` is the output at the end of sequence {``x_1``, ``x_2``}
/// - ``yf_3`` is the output at the end of sequence {``x_1``, ``x_2``, ``x_3``}
///
/// The backward LSTM output: ``[yb_1, yb_2, yb_3]``,
///
/// where ``yb_i`` are vectors of size ``outputVectorSize``:
///
/// - ``yb_1`` is the output at the end of sequence {``x_3``}
/// - ``yb_2`` is the output at the end of sequence {``x_3``, ``x_2``}
/// - ``yb_3`` is the output at the end of sequence {``x_3``, ``x_2``, ``x_1``}
///
/// Output of the bi-dir layer:
///
/// - if ``sequenceOutput = True`` : { ``[yf_1, yb_3]``,  ``[yf_2, yb_2]``,  ``[yf_3, yb_1]`` }
/// - if ``sequenceOutput = False`` : { ``[yf_3, yb_3]`` }
struct CoreML_Specification_BiDirectionalLSTMLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Size of the input vectors.
  var inputVectorSize: UInt64 = 0

  ///*
  /// Size of the outputs vectors.
  /// It is same for both forward and backward LSTMs.
  var outputVectorSize: UInt64 = 0

  ///*
  /// 3 element array representing activations [f(),g(),h()] in that order.
  /// Typical values used = [sigmoid, tanh, tanh].
  /// Activations supported are Linear, Sigmoid, Tanh, ReLU, Scaled Tanh (alpha = 1.71, beta = 2/3), Hard sigmoid (alpha = 0.2, beta = 0.5)
  var activationsForwardLstm: [CoreML_Specification_ActivationParams] = []

  ///*
  /// Currently, backward LSTM activations
  /// must be same as the ones for the forward LSTM.
  var activationsBackwardLstm: [CoreML_Specification_ActivationParams] = []

  ///*
  /// Common parameters shared by the forward and backward LSTMs.
  var params: CoreML_Specification_LSTMParams {
    get {return _params ?? CoreML_Specification_LSTMParams()}
    set {_params = newValue}
  }
  /// Returns true if `params` has been explicitly set.
  var hasParams: Bool {return self._params != nil}
  /// Clears the value of `params`. Subsequent reads from it will return its default value.
  mutating func clearParams() {self._params = nil}

  ///*
  /// Weights and biases.
  /// Must be a length 2 message,
  /// for the forward and backward LSTM respectively.
  var weightParams: [CoreML_Specification_LSTMWeightParams] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _params: CoreML_Specification_LSTMParams? = nil
}

struct CoreML_Specification_CustomLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The name of the class (conforming to MLCustomLayer) corresponding to this layer
  var className: String = String()

  /// Any weights -- these are serialized in binary format and memmapped at runtime
  var weights: [CoreML_Specification_WeightParams] = []

  /// these may be handled as strings, so this should not be large
  var parameters: Dictionary<String,CoreML_Specification_CustomLayerParams.CustomLayerParamValue> = [:]

  /// An (optional) description of the layer provided by the model creator. This information is displayed when viewing the model, but does not affect the model's execution on device.
  var description_p: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct CustomLayerParamValue {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var value: CoreML_Specification_CustomLayerParams.CustomLayerParamValue.OneOf_Value? = nil

    var doubleValue: Double {
      get {
        if case .doubleValue(let v)? = value {return v}
        return 0
      }
      set {value = .doubleValue(newValue)}
    }

    var stringValue: String {
      get {
        if case .stringValue(let v)? = value {return v}
        return String()
      }
      set {value = .stringValue(newValue)}
    }

    var intValue: Int32 {
      get {
        if case .intValue(let v)? = value {return v}
        return 0
      }
      set {value = .intValue(newValue)}
    }

    var longValue: Int64 {
      get {
        if case .longValue(let v)? = value {return v}
        return 0
      }
      set {value = .longValue(newValue)}
    }

    var boolValue: Bool {
      get {
        if case .boolValue(let v)? = value {return v}
        return false
      }
      set {value = .boolValue(newValue)}
    }

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_Value: Equatable {
      case doubleValue(Double)
      case stringValue(String)
      case intValue(Int32)
      case longValue(Int64)
      case boolValue(Bool)

    #if !swift(>=4.1)
      static func ==(lhs: CoreML_Specification_CustomLayerParams.CustomLayerParamValue.OneOf_Value, rhs: CoreML_Specification_CustomLayerParams.CustomLayerParamValue.OneOf_Value) -> Bool {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch (lhs, rhs) {
        case (.doubleValue, .doubleValue): return {
          guard case .doubleValue(let l) = lhs, case .doubleValue(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.stringValue, .stringValue): return {
          guard case .stringValue(let l) = lhs, case .stringValue(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.intValue, .intValue): return {
          guard case .intValue(let l) = lhs, case .intValue(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.longValue, .longValue): return {
          guard case .longValue(let l) = lhs, case .longValue(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.boolValue, .boolValue): return {
          guard case .boolValue(let l) = lhs, case .boolValue(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        default: return false
        }
      }
    #endif
    }

    init() {}
  }

  init() {}
}

struct CoreML_Specification_TransposeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Length of "axes" should match the rank of input & output tensor
  /// "axes" should be a permutation of "[0,1,2,...,N-1]" where N is the rank.
  var axes: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the matrix multiplication of two tensors with numpy-like broadcasting
/// where the matrices reside in the last two indices of the tensor.
///
/// .. code::
///
///      y = BatchedMatMul(a,b)
///
/// Requires 1 or 2 inputs and produces 1 output.
///
/// The first tensor, "a", must be provided as an input. The second tensor can either be an input or provided as a weight matrix parameter.
///
/// Input
///     - a: First N-Dimensional tensor
///     - b: Second N-Dimensional tensor (either a rank-N input or a matrix, i.e. N=2, provided as a layer parameter)
///
/// Output
///     A tensor containing the matrix product of two tensors.
///     When there are two inputs: rank is max(2, rank(a), rank(b))
///     When there is one input: rank is same as that of the input.
///
/// This operation behaves as following:
///
///  When there are two inputs:
///      - If N >= 2 for both tensors, it is treated as a batch of matrices residing in the last two indices.
///        All the indices, except for the last two, are broadcasted using conventional rules.
///      - If the first tensor is 1-D, it is converted to a 2-D tensor by prepending a 1 to its shape. Eg. (D) -> (1,D)
///      - If the second tensor is 1-D, it is converted to a 2-D tensor by appending a 1 to its shape. Eg. (D) -> (D,1)
///
///  When there is one input:
///      - The weight matrix corresponds to a matrix, of shape (X1, X2). Values of X1, X2 must be provided as layer parameters.
///      - The input, "a", is reshaped into a matrix by combining all the leading dimensions, except the last, into a batch dimension. eg:
///             - if "a" is rank 1 (X1,) -->  (1, X1). Output shape will be (X2,)
///             - if "a" is rank 2 (B1, X1) --> no need to reshape. Output shape will be (B1, X2)
///             - if "a" is rank 3 (B1, B2, X1) --> (B1 * B2, X1). Output shape will be (B1, B2, X2)
///             - etc
struct CoreML_Specification_BatchedMatMulLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// If transposeA is true, it transposes the left matrix on the fly before matrix multiplication.
  /// (is ignored when there is one input)
  var transposeA: Bool {
    get {return _storage._transposeA}
    set {_uniqueStorage()._transposeA = newValue}
  }

  ///*
  /// If transposeB is true, it transposes the right matrix on the fly before matrix multiplication.
  /// (is ignored when there is one input)
  var transposeB: Bool {
    get {return _storage._transposeB}
    set {_uniqueStorage()._transposeB = newValue}
  }

  //// X1: same as the last dimension of the input tensor
  var weightMatrixFirstDimension: UInt64 {
    get {return _storage._weightMatrixFirstDimension}
    set {_uniqueStorage()._weightMatrixFirstDimension = newValue}
  }

  //// X2: same as the last dimension of the output tensor
  var weightMatrixSecondDimension: UInt64 {
    get {return _storage._weightMatrixSecondDimension}
    set {_uniqueStorage()._weightMatrixSecondDimension = newValue}
  }

  //// Whether a bias is added or not. Supported only when there is one input.
  var hasBias_p: Bool {
    get {return _storage._hasBias_p}
    set {_uniqueStorage()._hasBias_p = newValue}
  }

  ///
  /// Weight matrix representing shape [X1, X2].
  /// Values are however stored in column major order,
  /// in the "repeated float" or "bytes" fields of the message "WeightParams"
  var weights: CoreML_Specification_WeightParams {
    get {return _storage._weights ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._weights = newValue}
  }
  /// Returns true if `weights` has been explicitly set.
  var hasWeights: Bool {return _storage._weights != nil}
  /// Clears the value of `weights`. Subsequent reads from it will return its default value.
  mutating func clearWeights() {_uniqueStorage()._weights = nil}

  //// Bias vector [X2]. Supported only when there is one input.
  var bias: CoreML_Specification_WeightParams {
    get {return _storage._bias ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._bias = newValue}
  }
  /// Returns true if `bias` has been explicitly set.
  var hasBias: Bool {return _storage._bias != nil}
  /// Clears the value of `bias`. Subsequent reads from it will return its default value.
  mutating func clearBias() {_uniqueStorage()._bias = nil}

  ///*
  /// If set, this layer, at runtime, quantizes the floating point input blob to int8 before applying the
  /// matrix multiplication using the INT8 weight parameters provided in weights->int8RawValue. The
  /// result is then dequantized.
  /// Requires:
  /// * number of inputs to be 1
  /// * hasBias == false
  /// * QuantizationType == LinearQuantizationParams, such that
  ///   * size of the "scale" field is 1 and "bias" field is empty in "LinearQuantizationParams"
  /// * numberOfBits == 8
  /// * weights->rawValue_size to be empty
  var int8DynamicQuantize: Bool {
    get {return _storage._int8DynamicQuantize}
    set {_uniqueStorage()._int8DynamicQuantize = newValue}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// A layer that concatenates a list of tensors along a specified axis.
///
/// .. code::
///
///      y = ConcatNDLayer(x1,x2,....)
///
/// Requires at least 2 input and produces 1 output.
///
/// Input
///     The rank of the input tensors must match and all dimensions also must match, except for the dimension 'axis'.
///
///
/// Output
///     Same rank as the input. The dimension along "axis", is the sum of the dimensions of the inputs.
///
/// example:
///
/// in1 : shape (3, 2), value = [[1, 2], [3, 4], [5, 6]]
/// in2 : shape (3, 2), value = [[7, 8], [9, 10], [11, 12]]
/// axis = 0
///
/// if interleave = False (default)
/// output : shape (6, 2)
/// output[0:3, :] = in1
/// output[3:6, :] = in2
/// value = [[1, 2], [3, 4], [5, 6], [7, 8], [9, 10], [11, 12]]
///
/// if interleave = True
/// output : shape (6, 2)
/// output[0::2, :] = in1
/// output[1::2, :] = in2
/// value = [[1, 2], [7, 8], [3, 4], [9, 10], [5, 6], [11, 12]]
struct CoreML_Specification_ConcatNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Dimension along which to concatenate. Supports negative values of the parameter 'axis'.
  var axis: Int64 = 0

  ///*
  /// (Only available in Core ML Specification >= 5 (iOS >= 14, macOS >= 11.0)
  /// Interleave option. If True, concatenation is done via interleaving the inputs.
  /// This requires all inputs to have the exact same shape.
  var interleave: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs softmax normalization along a specified axis.
///
/// .. code::
///
///      y = SoftmaxNDLayer(x)
///
/// Requires 1 input and produces 1 output.
///
/// Output shape is same as the input.
struct CoreML_Specification_SoftmaxNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Dimension on which the softmax would be performed. Supports negative values of the parameter 'axis'.
  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reverses specific dimensions of the input tensor.
/// It is similar in functionality to the numpy.flip method.
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_ReverseLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Reverses each dimension of the input tensor for which corresponding reverseDim is set to True.
  /// Requires len(reverseDim) == rank(inputTensor)
  var reverseDim: [Bool] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reverses variable length slices.
///
/// Requires 2 inputs and produces 1 output.
///
/// 2 inputs, in order are denoted by "data", "seq_lengths".
/// "seq_lenghts" must be a rank 1 tensor, i.e. seq_lengths.shape = (B,)
/// which contains the lengths of the amount of sequence to be reversed, for each element of the batch.
/// Dimension "batchAxis" in "data" must be equal to B, i.e,
/// data.shape[batchAxis] = B.
///
/// According to the batch axis, input "data" is first divided into a batch of B inputs,
/// each of which is flipped along the dimension "sequenceAxis", by the amount specified in
/// "seq_lengths", the second input.
///
/// e.g.:
///
/// data [shape = (2,4)]:
/// [0 1 2 3]
/// [4 5 6 7]
/// seq_lengths [shape = (2,)]:
/// [3, 0]
/// batchAxis = 0
/// sequenceAxis = 1
///
/// output [shape = (2,4)]:
/// [2 1 0 3]
/// [4 5 6 7]
///
///
/// data [shape = (2,3,2)]:
/// [0 1]
/// [2 3]
/// [4 5] (slice = 0)
/// [6 7]
/// [8 9]
/// [10 11] (slice = 1)
/// seq_lengths [shape = (2,)]:
/// [2, 3]
/// batchAxis = 0
/// sequenceAxis = 1
///
/// output [shape = (2,3,2)]:
/// [2 3]
/// [0 1]
/// [4 5] (slice = 0)
/// [10 11]
/// [8 9]
/// [6 7] (slice = 1)
///
/// Output shape is same as the input.
struct CoreML_Specification_ReverseSeqLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// batch axis has to be strictly less than seq_axis
  var batchAxis: Int64 = 0

  var sequenceAxis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that loads data as a parameter and provides it as an output.
///
/// .. code::
///
///      y = LoadConstantNDLayer()
///
/// Requires no input and produces 1 output.
///
/// Output: A tensor with shape as provided in the parameter "shape"
struct CoreML_Specification_LoadConstantNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The shape of the constant to be loaded.
  var shape: [UInt64] = []

  var data: CoreML_Specification_WeightParams {
    get {return _data ?? CoreML_Specification_WeightParams()}
    set {_data = newValue}
  }
  /// Returns true if `data` has been explicitly set.
  var hasData: Bool {return self._data != nil}
  /// Clears the value of `data`. Subsequent reads from it will return its default value.
  mutating func clearData() {self._data = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _data: CoreML_Specification_WeightParams? = nil
}

///*
/// A layer that generates an output tensor with a constant value.
/// Input is only used to determine the shape of the output.
/// This layer is used to allocate a tensor with a dynamic shape (that of the input) and constant value.
///
/// Requires 1 input and produces 1 output.
///
/// .. code::
///
///      y = FillLikeLayer(x)
///
/// Input
///     A N-Dimensional tensor, whose values are ignored. Only the shape is used to
///     infer the shape of the output.
///
/// Output
///     A N-Dimensional tensor with the same shape as the input tensor.
struct CoreML_Specification_FillLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var value: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that generates an output tensor with a constant value.
/// This layer is used to allocate a tensor with a static shape and constant value.
///
/// Requires no input and produces 1 output.
///
/// .. code::
///
///      y = FillStaticLayer(x)
///
/// Output
///     A N-Dimensional tensor of shape "targetShape".
struct CoreML_Specification_FillStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var value: Float = 0

  var targetShape: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that generates an output tensor with a constant value.
/// This layer is used to allocate a tensor with a dynamic shape (as specified by the input) and constant value.
///
/// Requires 1 input and produces 1 output.
///
/// .. code::
///
///      y = FillDynamicLayer(x)
///
/// Input
///     A rank 1 tensor specifying the shape of the output
///
/// Output
///     An N-Dimensional tensor with the shape specified by the values in the input tensor.
struct CoreML_Specification_FillDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var value: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns the elements either from tensor x or tensor y,
/// depending on the value in the condition tensor.
/// It is similar in functionality to the numpy.where method with 3 inputs.
///
/// Requires 3 inputs and produces 1 output.
/// Inputs, in order, are the condition tensor, x and y.
///
/// for each vector index (i,...,j):
///    output[i,...,j] = x[i,...,j] if condition[i,...,j] = True
///                      y[i,...,j] if condition[i,...,j] = False
///
/// All the 3 inputs are first broadcasted to a common shape.
/// (the shapes must be broadcastable)
///
/// output.rank = max(input[0].rank, input[1].rank, input[2].rank)
struct CoreML_Specification_WhereBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric sine function.
///
///
/// .. code::
///
///      y = SinLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_SinLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric cosine function.
///
///
/// .. code::
///
///      y = CosLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_CosLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric tangent function.
///
///
/// .. code::
///
///      y = TanLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_TanLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric arcsine function.
///
///
/// .. code::
///
///      y = AsinLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AsinLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric arccosine function.
///
///
/// .. code::
///
///      y = AcosLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AcosLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric arctangent function.
///
///
/// .. code::
///
///      y = AtanLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AtanLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic sine function.
///
///
/// .. code::
///
///      y = SinhLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_SinhLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic cosine function.
///
///
/// .. code::
///
///      y = CoshLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_CoshLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic tangent function.
///
///
/// .. code::
///
///      y = TanhLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_TanhLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic arcsine function.
///
///
/// .. code::
///
///      y = AsinhLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AsinhLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic arccosine function.
///
///
/// .. code::
///
///      y = AcoshLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AcoshLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes elementwise trigonometric hyperbolic arctangent function.
///
///
/// .. code::
///
///      y = AtanhLayer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_AtanhLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that raises each element in first tensor to the power of
/// corresponding element in the second tensor.
/// Supports conventional numpy-like broadcasting.
///
/// .. code::
///
///      y = PowBroadcastableLayer(x)
///
/// Requires 2 inputs and produces 1 output.
///
/// Input
///     - First N-Dimensional tensor
///     - Second N-Dimensional tensor
///
/// Output
///     An N-Dimensional tensor with the broadcast shape.
struct CoreML_Specification_PowBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the exponential of all elements in the input tensor, with the base 2.
///
///
/// .. code::
///
///      y = Exp2Layer(x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_Exp2LayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor containing the indices of all non-zero
/// elements of input tensor.
/// It is similar in functionality to the numpy.where method with 1 input.
///
/// Requires 1 input and produces 1 output.
/// Output is of rank 2, of shape (N,R),
/// where N is the number of non-zero elements in the input and R is the rank of the input.
///
/// Output contains indices represented in the multi-index form
///
/// e.g.:
/// input {shape = (4,)}:
/// [0 1 0 2]
/// output {shape = (2,1)}:
/// [1]
/// [3]
///
///
/// input {shape = (3, 3)}:
/// [1 2 1]
/// [0 2 2]
/// [2 1 0]
/// output {shape = (7,1)}:
/// [0. 0.]
/// [0. 1.]
/// [0. 2.]
/// [1. 1.]
/// [1. 2.]
/// [2. 0.]
/// [2. 1.]
struct CoreML_Specification_WhereNonZeroLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that copies a tensor setting everything outside a central band in
/// each inner-most matrix to zero.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters for matrix_band_part layer
/// band(m, n) = (num_lower < 0 || (m-n) <= num_lower) && (num_upper < 0 || (n-m) <= num_upper).
/// output[i, j, k, ..., m, n] = band(m, n) * input[i, j, k, ..., m, n]
///
///
/// Output shape is same as the input shape.
/// Rank of the input must be at least 2.
/// For rank higher than 2, the last 2 dimensions are treated as the matrix, while the rest are treated as batch.
struct CoreML_Specification_MatrixBandPartLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var numLower: Int64 = 0

  var numUpper: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that copies a tensor setting everything outside upper triangular to zero.
///
/// Requires 1 input and produces 1 output.
///
/// Output shape is same as the input shape.
/// Rank of the input must be at least 2.
/// For rank higher than 2, the last 2 dimensions are treated as the matrix, while the rest are treated as batch.
struct CoreML_Specification_UpperTriangularLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Diagonal below which to zero elements. k = 0 (the default) is the main diagonal, k < 0 is below it and k > 0 is above
  var k: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that copies a tensor setting everything outside lower triangular to zero.
///
/// Requires 1 input and produces 1 output.
///
/// Output shape is same as the input shape.
/// Rank of the input must be at least 2.
/// For rank higher than 2, the last 2 dimensions are treated as the matrix, while the rest are treated as batch.
struct CoreML_Specification_LowerTriangularLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Diagonal above which to zero elements. k = 0 (the default) is the main diagonal, k < 0 is below it and k > 0 is above
  var k: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
///
/// A layer that broadcasts a tensor to a new shape.
///
/// Requires 2 inputs and produces 1 output.
///
/// First input is broadcast to produce the output, while the second input is only
/// used to determine the shape of the output. Values of second input are not used.
///
/// Output is a tensor with the same shape as the second input.
struct CoreML_Specification_BroadcastToLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
///
/// A layer that broadcasts a tensor to a new shape.
///
/// Requires 1 input and produces 1 output.
///
/// Output tensor is the broadcasted version of the input and has shape as specified in the
/// parameter "targetShape".
struct CoreML_Specification_BroadcastToStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var targetShape: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
///
/// A layer that broadcasts a tensor to a new shape.
///
/// Requires 2 inputs and produces 1 output.
///
/// First input is the one that is broadcasted to produce the output.
/// Second input is a rank 1 tensor specifying the shape of the output.
/// Output tensor has shape as specified by the values in the 2nd input tensor.
struct CoreML_Specification_BroadcastToDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise addition operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_AddBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise maximum operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_MaxBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise minimum operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_MinBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise modular operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_ModBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise floor division operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_FloorDivBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise subtract operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_SubtractBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise multiply operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_MultiplyBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise division operation with broadcast support.
///
/// Requires 2 inputs and produces 1 output.
struct CoreML_Specification_DivideBroadcastableLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Gather layer that gathers elements from the first input, along a specified axis,
/// at indices specified in the second input.
/// It is similar in functionality to the numpy.take method.
///
/// Requires 2 inputs and produces 1 output.
///
/// Given two inputs, 'data' and 'indices', gather the slices of 'data'
/// and store into output.
/// e.g.
/// for i in [0, length(indices) - 1]
///    output[i] = data[indices[i]]  (1-D case, axis=0)
///
/// if axis = 0:
/// for each vector index (i,...,j)
///    output[i,...,j,:,..,:] = data[indices[i,...,j],:,..,:]
///
/// output.rank = (data.rank - 1) + indices.rank
///
/// Negative indices and negative axis are supported.
///
/// e.g:
///
/// data shape = (2, 3)
/// indices shape = (6, 8)
/// axis = 0
/// output shape = (6, 8) + (3,) = (6, 8, 3)
///
/// data shape = (2, 3, 5)
/// indices shape = (6, 8)
/// axis = 1
/// output shape = (2,) + (6, 8) + (5,) =  (2, 6, 8, 5)
struct CoreML_Specification_GatherLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_ScatterLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  //// mode of accumulation.
  var mode: CoreML_Specification_ScatterMode = .scatterUpdate

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that gathers elements from the first input, 'params', at the multi-indices specified
/// by the second input, 'indices'.
///
/// Requires 2 inputs and produces 1 output.
///
/// 'params' = input[0], 'indices' = input[1]
///
/// 'indices' is a rank K+1 tensor of shape [I_0, I_1, .., I_(K-1), I_K] which is viewed as a collection of
/// indices of (I_0 * I_1 * ... * I_(K-1)) points in the I_K dimensional space. For instance, the multi-index of the first point
/// is indices[0,0,...,0,:].
///
/// Here is how the output is constructed:
///
/// for i = 0,1,...,(I_0-1)
///   ...
///     for j = 0,1,....,(I_(K-1)-1)
///          output[i,....,j,:,:,..,:] = params[indices[i,...,j,:], :,:,..,:]
///
/// Hence, output shape is [I_0, I_1,...,I(K-1)] + params.shape[I_K:]
///
/// output.rank = indices.rank - 1 + params.rank - indices.shape[-1]
///
/// e.g:
///
/// input[0] shape = (4, 2, 3, 4)
/// input[1] shape = (6, 2)
/// output shape = (6,) + (3, 4) = (6, 3, 4)
///
/// input[0] shape = (3, 3, 3, 4, 7)
/// input[1] shape = (3, 5)
/// output shape = (3,) + () = (3,)
///
/// input[0] shape = (5, 3, 2, 5)
/// input[1] shape = (2, 7, 3, 2)
/// output shape = (2, 7, 3) + (2, 5) = (2, 7, 3, 2, 5)
struct CoreML_Specification_GatherNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///
/// A layer that scatters data into a new tensor according to multi-indices from the input.
/// This is the inverse operation of GatherND.
///
/// Requires 3 inputs and produces 1 output.
/// 3 inputs, in order are denoted as "container", "indices", "updates".
///
/// 'indices' is a rank K+1 tensor of shape [I_0, I_1, .., I_(K-1), I_K] which is viewed as a collection of
/// indices of (I_0 * I_1 * ... * I_(K-1)) points in the I_K dimensional space. For instance, the multi-index of the first point
/// is indices[0,0,...,0,:].
///
/// container.rank >= I_K
/// updates.rank = K + (container.rank - I_K)
/// shape of 'updates' = [I_0, I_1,...,I(K-1)] + container.shape[I_K:]
///
/// output = container
/// For each vector index (i,...,j) s.t. 0<=i<I_0,..., 0<=j<I_K
///   output[indices[i,...,j,:], :,:,..,:] = updates[i,....,j,:,:,..,:] // if mode == "SCATTER_UPDATE"
///
/// The output has the same shape as the first input.
///
/// e.g:
///
/// container shape = (3, 2)
/// indices shape = (4, 2)
/// updates shape = (4,)
/// output shape = (3, 2)
///
/// container shape = (7, 6)
/// indices shape = (4, 7, 2, 5, 1)
/// updates shape = (4, 7, 2, 5, 6)
/// output shape = (7, 6)
struct CoreML_Specification_ScatterNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// mode of accumulation.
  var mode: CoreML_Specification_ScatterMode = .scatterUpdate

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Gather layer that gathers elements from the first input, along a specified axis,
/// at indices specified in the second input.
/// It is similar in functionality to the numpy.take_along_axis method.
///
/// Requires 2 inputs and produces 1 output.
///
/// Given two inputs, 'data' and 'indices', gather the slices of 'data'
/// and store into output.
///
/// Both inputs and output have the same rank.
/// Output shape is same as the shape of 'indices'
/// Shapes of 'indices' and 'data' match, except at the 'axis' dimension.
///
/// This operation performs the following operation for axis=0:
/// for each vector index (i,j,....,k)
///    output[i,j,....,k] = data[index[i,j,....,k],j,....,k]
///
/// Negative indices and negative axis are supported.
///
/// e.g:
///
/// data shape = (4, 4, 7)
/// indices shape = (4, 5, 7)
/// axis = 1
/// output shape = (4, 5, 7)
struct CoreML_Specification_GatherAlongAxisLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that scatters data into a new tensor according to indices from
/// the input along the given axis into the output tensor.
/// This is the inverse operation of GatherAlongAxis.
/// It is similar in functionality to the numpy.put_along_axis method.
///
/// Requires 3 inputs and produces 1 output.
/// 3 inputs, in order are denoted as "container", "indices", "updates".
///
/// All inputs and output have the same rank.
/// Output shape is same as the shape of 'container'
/// Shapes of 'indices' and 'updates' match, which is same as the shape of 'container' except at the 'axis' dimension.
///
/// Negative indices and negative axis are supported.
///
/// This operation performs the following operation for axis=0:
/// output = container
/// for each vector index (i,j,....,k)
///    output[index[i,j,....,k],j,....,k] = updates[i,j,....,k]
///
/// e.g.:
///
/// container shape = (2, 5, 6)
/// indices shape = (2, 2, 6)
/// updates shape = (2, 2, 6)
/// axis = -2
/// output shape = (2, 5, 6)
struct CoreML_Specification_ScatterAlongAxisLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  //// mode of accumulation.
  var mode: CoreML_Specification_ScatterMode = .scatterUpdate

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that stacks the input tensors along the given axis.
/// It is similar in functionality to the numpy.stack method.
///
/// Requires at least 2 inputs and produces 1 output.
/// All inputs must have the same shape.
/// Rank of the output is 1 greater than the rank of the inputs.
///
/// Negative indexing is supported for the "axis" parameter.
///
/// e.g.:
///
/// input shape = (2, 4, 2)
/// number of inputs = 5
/// axis = 3
/// output shape = (2, 4, 2, 5)
///
/// input shape = (2, 4, 2)
/// number of inputs = 5
/// axis = -2
/// output shape = (2, 4, 5, 2)
struct CoreML_Specification_StackLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reshapes a tensor that does not alter the rank of the input.
/// Order of the data is left unchanged.
///
/// Requires 1 input and produces 1 output.
///
/// e.g:
///
/// input shape = (20,10)
/// targetShape = (5,-1)
/// output shape = (5,40)
///
/// input shape = (20,10,5)
/// targetShape = (0,2,25)
/// output shape = (20,2,25)
///
/// input shape = (10,3,5)
/// targetShape = (25,0,-1)
/// output shape = (25,3,2)
struct CoreML_Specification_RankPreservingReshapeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Length of this field must be same as the input/output rank.
  /// It can have 0's, in which case the corresponding input dimension is kept intact.
  /// At most one element can be -1, in which case the output dimension is calculated from rest of the shape.
  var targetShape: [Int64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Constant padding layer.
/// Pad the input array with a constant value, either along a single given axis or along a set of axes.
///
/// Requires 1 or 2 inputs and produces 1 output.
/// The amount of padding can be either set as a parameter ("padAmounts") or provided as a second input.
///
/// Output rank is same as the rank of the first input.
///
/// when "padToGivenOutputSizeMode" is False:
///
/// output_shape[i] = input_shape[i] + padAmounts[2*i] + padAmounts[2*i+1], i=0,...,rank-1
///
/// Examples:
///
/// input shape = (20,10)
/// padAmounts = [0,1,4,0]
/// output shape = (21,14)
///
/// input shape = (20,10,5)
/// padAmounts = [0,0,3,4,0,9]
/// output shape = (20,17,14)
///
///
/// when "padToGivenOutputSizeMode" is True
///
/// output_shape[i] = max(input_shape[i], max(padAmounts[2*i] + padAmounts[2*i+1])), i=0,...,rank-1
///
/// input shape = (20,10)
/// padAmounts = [0,21,14,0]
/// output shape = (21,14)
///
/// input shape = (20,10,5)
/// padAmounts = [0,0,17,0,0,14]
/// output shape = (20,17,14)
struct CoreML_Specification_ConstantPaddingLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The value to be used for padding.
  var value: Float = 0

  ///*
  /// Length of this repeated field must be twice the rank of the first input.
  /// 2*i-th and (2*i+1)-th values represent the amount of padding to be applied to the i-th input
  /// dimension, "before" and "after" the input values, respectively.
  var padAmounts: [UInt64] = []

  ///*
  /// When this is True, positive values in "padAmounts" are equivalent to the output shape.
  /// In that case only one of padAmounts[2*i] and padAmounts[2*i+1] can be non zero, for i=0,..,rank-1.
  var padToGivenOutputSizeMode: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the normal distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters
///     seed: seed used for the normal distribution.
///     mean: mean of the normal distribution.
///     stdDev: standard deviation of the normal distribution.
///
/// Input
///     An N-Dimensional tensor, whose values are ignored. Only the shape is used to
///     infer the shape of the output.
///
/// Output
///     An N-Dimensional tensor with the same shape as the input tensor.
struct CoreML_Specification_RandomNormalLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var mean: Float = 0

  var stdDev: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the normal distribution.
///
/// Requires no input and produces 1 output.
///
/// Parameters
///     seed: seed used for the normal distribution.
///     mean: mean of the normal distribution.
///     stdDev: standard deviation of the normal distribution.
///     outputShape: shape of the output tensor.
///
/// Output
///     An N-Dimensional tensor of shape "outputShape".
struct CoreML_Specification_RandomNormalStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var mean: Float = 0

  var stdDev: Float = 0

  var outputShape: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the normal distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///     seed: seed used for the normal distribution.
///     mean: mean of the normal distribution.
///     stdDev: standard deviation of the normal distribution.
///
/// Input
///     A rank 1 tensor specifying the shape of the output
///
/// Output
///     An N-Dimensional tensor with the shape specified by the values in the input tensor.
struct CoreML_Specification_RandomNormalDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var mean: Float = 0

  var stdDev: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the uniform distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters
///     seed: seed used for the uniform distribution.
///     minVal: lower bound on the range of random values for the uniform distribution.
///     maxVal: upper bound on the range of random values for the uniform distribution.
///
/// Input
///     An N-Dimensional tensor, whose values are ignored. Only the shape is used to
///     infer the shape of the output.
///
/// Output
///     An N-Dimensional tensor with the same shape as the input tensor.
struct CoreML_Specification_RandomUniformLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var minVal: Float = 0

  var maxVal: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the uniform distribution.
///
/// Requires no input and produces 1 output.
///
/// Parameters
///     seed: seed used for the uniform distribution.
///     minVal: lower bound on the range of random values for the uniform distribution.
///     maxVal: upper bound on the range of random values for the uniform distribution.
///     outputShape: shape of the output tensor.
///
/// Output
///     An N-Dimensional tensor of shape "outputShape".
struct CoreML_Specification_RandomUniformStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var minVal: Float = 0

  var maxVal: Float = 0

  var outputShape: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the uniform distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///     seed: seed used for the uniform distribution.
///     minVal: lower bound on the range of random values for the uniform distribution.
///     maxVal: upper bound on the range of random values for the uniform distribution.
///
/// Input
///     A rank 1 tensor specifying the shape of the output
///
/// Output
///     An N-Dimensional tensor with the shape specified by the values in the input tensor.
struct CoreML_Specification_RandomUniformDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var minVal: Float = 0

  var maxVal: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the Bernoulli distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters
///     seed: seed used for the Bernoulli distribution.
///     prob: probability of a 1 event.
///
/// Input
///     An N-Dimensional tensor, whose values are ignored. Only the shape is used to
///     infer the shape of the output.
///
/// Output
///     An N-Dimensional tensor with the same shape as the input tensor.
struct CoreML_Specification_RandomBernoulliLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var prob: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the Bernoulli distribution.
///
/// Requires no input and produces 1 output.
///
/// Parameters
///     seed: seed used for the Bernoulli distribution.
///     prob: probability of a 1 event.
///     outputShape: shape of the output tensor.
///
/// Output
///     An N-Dimensional tensor of shape "outputShape".
struct CoreML_Specification_RandomBernoulliStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var prob: Float = 0

  var outputShape: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor filled with values from the Bernoulli distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///     seed: seed used for the Bernoulli distribution.
///     prob: probability of a 1 event.
///
/// Input
///     A rank 1 tensor specifying the shape of the output
///
/// Output
///     An N-Dimensional tensor with the shape specified by the values in the input tensor.
struct CoreML_Specification_RandomBernoulliDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var prob: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor of the specified shape filled with values from the categorical distribution.
///
/// Requires 1 input and produces 1 output.
///
/// Parameter:
///     seed: seed used for the categorical distribution.
///     numSamples: number of samples to draw.
///     isLogits: true if the inputs are logits, false if the inputs are probabilities.
///     eps: default value is 1e-10.
///     temperature: default value is 1.0.
///
/// Input tensor shape = [D_1, D_2, ... , D_(R-1), D_R] (Rank = R)
/// Then the shape of the output is [D_1, D_2, ... , D_(R-1), numSamples] (Rank = R)
struct CoreML_Specification_CategoricalDistributionLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var seed: Int64 = 0

  var numSamples: Int64 = 0

  var isLogits: Bool = false

  var eps: Float = 0

  var temperature: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with L1 normalization operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceL1LayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with L2 normalization operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceL2LayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with max operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceMaxLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with min operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceMinLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with sum operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceSumLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with prod operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceProdLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with mean operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceMeanLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with logSum operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceLogSumLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with logSumExp operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceSumSquareLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs reduction with logSumExp operation.
///
/// Negative indexing is supported.
/// Requires 1 input and produces 1 output.
///
/// Parameters:
///    axes: dimensions along which to perform reduction
///    keepDims: if True, keep the reduced dimensions (value will be 1), otherwise, reduced dimensions are squeezed
///    reduceAll: ignore the "axes" parameter, perform reduction along all axes
struct CoreML_Specification_ReduceLogSumExpLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axes: [Int64] = []

  var keepDims: Bool = false

  var reduceAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that increases the rank of the input tensor by adding unit dimensions.
///
/// Requires 1 input and produces 1 output.
///
/// e.g.:
///
/// input shape = (10,5)
/// axes = (0,1)
/// output shape = (1,1,10,5)
///
/// input shape = (10,5)
/// axes = (0,2)
/// output shape = (1,10,1,5)
///
/// input shape = (10,5)
/// axes = (-2,-1)
/// output shape = (10,5,1,1)
struct CoreML_Specification_ExpandDimsLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Axis values provided here get dimension 1 in the output tensor.
  /// Negative indexing is supported.
  var axes: [Int64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that flattens the input tensor into a 2-dimensional matrix.
///
/// Requires 1 input and produces 1 output.
/// Output tensor is always rank 2.
///
/// First dimension of output is the product of all the dimensions in input[:axis] ("axis" is exclusive)
/// Second dimension of output is the product of all the dimensions in input[axis:] ("axis" is inclusive)
///
/// e.g.:
/// input shape:  (3,)
/// axis:  -1
/// output shape:  (1, 3)
///
/// input shape:  (3,)
/// axis:  1
/// output shape:  (3, 1)
///
/// input shape:  (4, 3)
/// axis:  -1
/// output shape:  (4, 3)
///
/// input shape:  (5, 2)
/// axis:  0
/// output shape:  (1, 10)
///
/// input shape:  (5, 5, 3)
/// axis:  -2
/// output shape:  (5, 15)
///
/// input shape:  (2, 3, 2)
/// axis:  -1
/// output shape:  (6, 2)
struct CoreML_Specification_FlattenTo2DLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reshapes a tensor.
///
/// Requires 1 input and produces 1 output.
///
/// Output tensor is the reshaped version of the input and has shape as specified in the
/// parameter "targetShape".
struct CoreML_Specification_ReshapeStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var targetShape: [Int64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reshapes a tensor.
///
/// Requires 2 inputs and produces 1 output.
///
/// First input is reshaped to produce the output, while the second input is only
/// used to determine the shape of the output. Values of the second input are not used.
///
/// Output is a tensor with the same shape as the second input.
struct CoreML_Specification_ReshapeLikeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that reshapes a tensor.
///
/// Requires 2 inputs and produces 1 output.
///
/// First input is the one that is reshaped to produce the output.
/// Second input is a rank 1 tensor specifying the shape of the output.
/// Output tensor has shape as specified by the values in the 2nd input tensor.
struct CoreML_Specification_ReshapeDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that decreases the rank of the input tensor by removing unit dimensions.
///
/// Requires 1 input and produces 1 output.
///
/// Output rank is one less than input rank, if input rank is more than 1.
/// If input rank is 1, output rank is also 1.
///
/// e.g.:
///
/// input shape = (1,1,10,5)
/// axes = (0,1)
/// output shape = (10,5)
///
/// input shape = (1,10,5,1)
/// axes = (0,3)
/// output shape = (10,5)
///
/// input shape = (10,5,1,1)
/// axes = (-2,-1)
/// output shape = (10,5)
///
/// input shape = (1,)
/// axes = (0)
/// output shape = (1,)
struct CoreML_Specification_SqueezeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// Axis values provided here get removed from the input tensor.
  /// Negative indexing is supported.
  var axes: [Int64] = []

  /// if true squeeze all dimensions that are 1.
  var squeezeAll: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns top K (or bottom K) values and the corresponding indices
/// of the input along a given axis.
///
/// Requires 1 or 2 inputs and produces 2 outputs.
///
/// The second input is the value of the K, and is optional.
/// If there is only one input, value of K that is specified in the layer parameter is used.
///
/// Both outputs have the same rank as the first input.
/// Second input must correspond to a scalar tensor.
///
/// e.g.:
///
/// first input's shape = (45, 34, 10, 5)
/// axis = 1
/// output shape, for both outputs = (45, K, 10, 5)
struct CoreML_Specification_TopKLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ////  negative indexing is supported
  var axis: Int64 = 0

  //// is ignored if a second input is present.
  var k: UInt64 = 0

  //// if true, bottom K (values, indices) are returned instead
  var useBottomK: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns the indices of the maximum value along a specified axis in a tensor.
///
/// Requires 1 input and produces 1 output. Negative indexing is supported.
///
/// Output has the same rank as the input if "removeDim" is False (default).
/// Output has rank one less than the input if "removeDim" is True and input rank is more than 1.
///
/// e.g.:
///
/// input shape = (45, 34, 10, 5)
/// axis = -2
/// output shape = (45, 1, 10, 5), if removeDim = False (default)
/// output shape = (45, 10, 5), if removeDim = True
///
/// input shape = (5,)
/// axis = 0
/// output shape = (1,), if removeDim = False or True
struct CoreML_Specification_ArgMaxLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var removeDim: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns the indices of the minimum value along a specified axis in a tensor.
///
/// Requires 1 input and produces 1 output. Negative indexing is supported.
///
/// Output has the same rank as the input if "removeDim" is False (default).
/// Output has rank one less than the input if "removeDim" is True and input rank is more than 1.
///
/// e.g.:
///
/// input shape = (45, 34, 10, 5)
/// axis = -2
/// output shape = (45, 1, 10, 5), if removeDim = False (default)
/// output shape = (45, 10, 5), if removeDim = True
///
/// input shape = (5,)
/// axis = 0
/// output shape = (1,), if removeDim = False or True
struct CoreML_Specification_ArgMinLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var removeDim: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer layer that splits the input tensor into multiple output tensors,
/// along the specified axis.
///
/// The layer either uniformly splits the input tensor into ``num_splits`` tensors, or
/// splits according to the given split sizes in ``split_sizes``.
/// Supports unequal splits and negative indexing.
///
/// Requires 1 input and produces at least 2 outputs.
/// Rank of all the outputs is same as that of the input.
///
/// If parameter "splitSizes" is provided, value of the parameter "numSplits" is ignored, since in that case
/// "numSplits" is automatically inferred to be the length of "splitSizes".
///
///
/// e.g.:
/// input shape:  (5, 3, 4)
/// axis = -3, split_sizes = [3, 2]
/// output shape:  (3, 3, 4)
/// output shape:  (2, 3, 4)
struct CoreML_Specification_SplitNDLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var numSplits: UInt64 = 0

  var splitSizes: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise ceil operation on the input tensor that
/// rounds the value to the smallest integer not less than x.
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_CeilLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise round operation on the input tensor
/// that rounds the value to the nearest integer.
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_RoundLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise floor operation on the input tensor
/// that rounds the value to the largest integer not greater than x.
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_FloorLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise sign operation (+1 for positive values,
/// -1 for negative values, 0 for zeros).
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_SignLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise clip operation. Clip the values in the
/// input tensor to the threshold values [min_value, max_value].
///
/// Requires 1 input and produces 1 output.
///
/// Parameter minVal: the minimum threshold.
/// Parameter maxVal: the maximum threshold.
///
/// output =  min(max(input, minVal), maxVal)
///
/// Output shape is same as the input.
struct CoreML_Specification_ClipLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var minVal: Float = 0

  var maxVal: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that extracts a slice of size ``(end - begin) / stride``
/// from the given input tensor.
/// Support negative indexing and negative strides.
///
/// Requires 1 input and produces 1 output.
/// Output rank is same as the input rank.
///
/// Value of beginIds, beginMasks, endIds, endMasks, strides are required parameters.
/// Lengths of all the parameters must equal the rank of the input.
///
/// i-th element of "beginIds" is ignored and assumed to be 0 if the i-th element of
/// "beginMasks" is True
///
/// i-th element of "endIds" is ignored and assumed to be -1 if the i-th element of
/// "endMasks" is True
///
/// e.g.:
/// if i-th element of "squeezeMasks" is set to True, only beginIds[i] would be sliced
/// out, and all other masks and inputs are ignored.
///
/// e.g. (without squeezeMasks):
/// input shape:  (5, 5, 5)
/// beginIds:  [1, 2, 3]
/// beginMasks:  [True, False, True]
/// endIds:  [3, -3, 2]
/// endMasks:  [False, True, True]
/// strides:  [2, 2, 2]
/// SqueezeMasks:  [False, False, False]
/// output shape:  (2, 2, 3)
/// This is equivalent to input[:3:2, 2::2, ::2]
///
/// e.g. (with squeezeMasks):
/// input shape:  (5, 5, 5)
/// beginIds:  [1, 2, 3]
/// beginMasks:  [True, False, True]
/// endIds:  [3, -3, 2]
/// endMasks:  [False, True, True]
/// strides:  [2, 2, 2]
/// SqueezeMasks:  [False, True, False]
/// output shape:  (2, 3)
/// This is equivalent to input[:3:2, 2, ::2]
struct CoreML_Specification_SliceStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var beginIds: [Int64] = []

  var beginMasks: [Bool] = []

  var endIds: [Int64] = []

  var endMasks: [Bool] = []

  var strides: [Int64] = []

  var squeezeMasks: [Bool] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that extracts a slice of size ``(end - begin) / stride``
/// from the given input tensor.
/// Support negative indexing and negative strides.
/// See "SliceStaticLayerParams" for the description and an example of the functionality of the layer.
///
/// Requires 2 to 7 inputs and produces 1 output.
/// Rank of the output is same as the rank of the first input unless squeezeMask is set.
///
/// Value of beginIds, beginMasks, endIds, endMasks, strides can be passed in either
/// as dynamic inputs or as static parameters.
/// Lengths of all the parameters or inputs from 2-6 must equal the rank of the first input.
///
/// The 2nd input represents the "beginIds".
/// The 3rd input, if present, corresponds to "endIds". In this case the value of the "endIds" parameter is ignored.
/// The 4th input, if present, corresponds to "strides". In this case the value of the "strides" parameter is ignored.
/// The 5th input, if present, corresponds to "beginMasks". In this case the value of the "beginMasks" parameter is ignored.
/// The 6th input, if present, corresponds to "endMasks". In this case the value of the "endMasks" parameter is ignored.
/// The 7th input, if present, corresponds to "squeezeMasks". In this case the value of the "squeezeMasks" parameter is ignored.
struct CoreML_Specification_SliceDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var beginMasks: [Bool] = []

  var endIds: [Int64] = []

  var endMasks: [Bool] = []

  var strides: [Int64] = []

  var squeezeMasks: [Bool] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that constructs a tensor by repeating the input tensor multiple
/// number of times.
///
/// Requires 1 or 2 inputs and produces 1 output.
/// Output rank is same as the input rank.
///
/// If two inputs are provided, second input is used as "reps"
/// and "reps" parameter is ignored.
///
/// If only one input is provided,
/// length of the "reps" parameter must be at least 1 and
/// not greater than the rank of the input.
/// If it is less than the input rank, it is made equal to the input rank by prepending 1's to it.
///
/// e.g.:
///
/// input shape = (2, 4, 2)
/// reps = (1, 2, 6)
/// output shape = (2, 8, 12)
///
/// input shape = (2, 4, 2)
/// reps = (6)
/// reps after prepending ones = (1, 1, 6)
/// output shape = (2, 4, 12)
///
/// input shape = (2, 4, 2)
/// second input = [1, 2, 6] -> shape: (3,)
/// reps = N/A [Ignored]
/// output shape = (2, 8, 12)
struct CoreML_Specification_TileLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var reps: [UInt64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns the shape of an input tensor.
///
/// Requires 1 input and produces 1 output.
///
/// Input: a tensor.
/// Output: a vector of length R, where R is the rank of the input tensor
/// Output is always a rank 1 tensor.
struct CoreML_Specification_GetShapeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that computes the Gauss error function,
/// which is defined as:
///
/// .. math::
///     f(x) = \dfrac{1}{\sqrt{\pi}}\int_{-x}^{x}{e^{-t^2}dt}
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_ErfLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that evaluates the Gaussian Error Linear Unit (GELU) activation.
/// Following equations are used to compute the activation based on the value of the "mode" parameter:
///
/// mode == 'EXACT':
/// .. math::
///     f(x) = 0.5x\left ( 1+\rm{erf}\left ( \frac{x}{\sqrt{2}} \right ) \right )
///
/// mode == 'TANH_APPROXIMATION':
/// .. math::
///     f(x) = 0.5x\left ( 1+\rm{tanh}\left ( \sqrt{2/\pi}\left ( x + 0.044715x^3 \right ) \right ) \right )
///
/// mode == 'SIGMOID_APPROXIMATION':
/// .. math::
///     f(x) = x*\rm{sigmoid}(1.702x)
///
/// Requires 1 input and produces 1 output.
/// Output shape is same as the input.
struct CoreML_Specification_GeluLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// mode of GELU operation.
  var mode: CoreML_Specification_GeluLayerParams.GeluMode = .exact

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum GeluMode: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case exact // = 0
    case tanhApproximation // = 1
    case sigmoidApproximation // = 2
    case UNRECOGNIZED(Int)

    init() {
      self = .exact
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .exact
      case 1: self = .tanhApproximation
      case 2: self = .sigmoidApproximation
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .exact: return 0
      case .tanhApproximation: return 1
      case .sigmoidApproximation: return 2
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension CoreML_Specification_GeluLayerParams.GeluMode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_GeluLayerParams.GeluMode] = [
    .exact,
    .tanhApproximation,
    .sigmoidApproximation,
  ]
}

#endif  // swift(>=4.2)

///*
/// RangeStatic layer that returns a tensor that contains evenly spaced values.
/// It is similar in functionality to the numpy.arange method.
///
/// Requires no input and produces 1 output.
/// Output is a rank 1 tensor.
struct CoreML_Specification_RangeStaticLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var endValue: Float = 0

  var startValue: Float = 0

  var stepSizeValue: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor that contains evenly spaced values.
/// Its functionality is similar to the numpy.arange method.
///
/// Requires at least 1 input, up to a maximum of 3 inputs.
/// Produces 1 output, which is a rank 1 tensor.
///
/// Each input must be a scalar, or rank 1 and shape (1,).
///
/// The first input represents the "endValue".
/// The second input, if present, corresponds to "startValue". In this case the value of the "startValue" parameter is ignored.
/// The third input, if present, corresponds to "stepSizeValue". In this case the value of the "stepSizeValue" parameter is ignored.
struct CoreML_Specification_RangeDynamicLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var startValue: Float = 0

  var stepSizeValue: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns a tensor containing all windows of size ``windowSize``
/// separated by ``step`` along the dimension ``axis``.
///
/// .. code::
///
///      y = SlidingWindows(x)
///
/// Requires 1 input and produces 1 output.
///
/// Input
///     An N-Dimensional tensor.
///
/// Output
///     An (N+1)-Dimensional tensor.
///
/// This operation behaves as following:
///      - if axis = 0 & input is rank 1 (L,). Output shape will be (M, W).
///      - if axis = 1 & input is rank 3 (B1, L, C1). Output shape will be (B1, M, W, C1)
///      - if axis = 2 & input is rank 5 (B1, B2, L, C1, C2) --> (B1 * B2, L, C1 * C2) --> (B1 * B2, M, W, C1 * C2). Output shape will be (B1, B2, M, W, C1, C2)
///      - etc.
/// where
///      - L, C, B refer to input length, feature dimension length & batch size respectively
///      - W is the window size.
///      - M is the number of windows/slices calculated as M = (L - W) / step + 1
struct CoreML_Specification_SlidingWindowsLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var axis: Int64 = 0

  var windowSize: UInt64 = 0

  var step: UInt64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that applies layer normalization over the input tensor.
///
/// Requires 1 input and produces 1 output.
///
/// output = gamma * (input - computed_mean) / (sqrt(computed_variance + eps)) + beta
///
/// Parameters
///     normalizedShape: subset of the input shape, along with layer norm is performed, rest of the input shape is treated as the batch dimension. The mean and variance are computed for the input, over the last few dimensions as specified by the normalizedShape parameter.
///     gamma: must have shape = "normalizedShape"
///     beta: must have shape = "normalizedShape"
///     eps: small constant to avoid division by 0
///
/// Output shape is same as the input.
///
/// e.g.:
/// input shape = (10,5)
/// normalized shape = (5,) or (10,5)
///
/// input shape = (10,5,6,7)
/// normalized shape = (7,) or (6,7) or (5,6,7) or (10,5,6,7)
struct CoreML_Specification_LayerNormalizationLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var normalizedShape: [Int64] {
    get {return _storage._normalizedShape}
    set {_uniqueStorage()._normalizedShape = newValue}
  }

  var eps: Float {
    get {return _storage._eps}
    set {_uniqueStorage()._eps = newValue}
  }

  var gamma: CoreML_Specification_WeightParams {
    get {return _storage._gamma ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._gamma = newValue}
  }
  /// Returns true if `gamma` has been explicitly set.
  var hasGamma: Bool {return _storage._gamma != nil}
  /// Clears the value of `gamma`. Subsequent reads from it will return its default value.
  mutating func clearGamma() {_uniqueStorage()._gamma = nil}

  var beta: CoreML_Specification_WeightParams {
    get {return _storage._beta ?? CoreML_Specification_WeightParams()}
    set {_uniqueStorage()._beta = newValue}
  }
  /// Returns true if `beta` has been explicitly set.
  var hasBeta: Bool {return _storage._beta != nil}
  /// Clears the value of `beta`. Subsequent reads from it will return its default value.
  mutating func clearBeta() {_uniqueStorage()._beta = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// Non maximum suppression (NMS) layer.
/// Applies the non maximum suppression algorithm to input bounding box coordinates.
/// The effect of this layer is similar to the functionality of the "NonMaximumSuppression"
/// model type (for details please see NonMaximumSuppression.proto) with a couple of differences.
/// One, this is a layer in a neural network model, whereas that is a different model type. Second,
/// this layer supports a batch of bounding boxes.
///
/// The NMS layer requires at least 2 inputs, and up to a maximum of 5 inputs. It produces 4 outputs.
/// Following is the description of inputs and outputs:
///
/// input 1, shape (B,N,4): coordinates of N boxes, for a batch size B.
/// input 2, shape (B,N,C): class scores for each box. C can be 1 when there is only 1 score per box, i.e., no class specific score.
///
/// input 3, optional, shape (1,): IoU threshold. When present, it overwrites the value provided in layer parameter "iouThreshold".
/// input 4, optional, shape (1,): Score threshold. When present, it overwrites the value provided in layer parameter "scoreThreshold".
/// input 5, optional, shape (1,): Maximum number of boxes. When present, it overwrites the value provided in layer parameter "maxBoxes".
///
/// output 1, shape (B,maxBoxes,4): box coordinates, corresponding to the surviving boxes.
/// output 2, shape (B,maxBoxes,C): box scores, corresponding to the surviving boxes.
/// output 3, shape (B,maxBoxes): indices of the surviving boxes. Hence it will have values in the range [0,N-1], except for padding.
/// output 4, shape (B,): number of boxes selected after the NMS algorithm, for each batch.
///
/// When surviving boxes are less than "maxBoxes", the first 3 outputs are padded.
/// For the first two outputs, the padding is done using values 0, whereas for the third output the
/// padding value used is -1, since the output values represent indices.
///
/// If no box survives, that is, all the scores are below the "scoreThreshold",
/// then for that batch, number of boxes (value of the fourth output) will be 1. The first 3 outputs will
/// correspond to the box with the highest score. This is to avoid generating an "empty" output.
///
/// The four values that describe the box dimensions are (in order):
///
///  - x (center location of the box along the horizontal axis)
///  - y (center location of the box along the vertical axis)
///  - width (size of box along the horizontal axis)
///  - height (size of box on along the vertical axis)
///
/// In each batch,
/// the N scores for N boxes, used for suppression, are generated by taking the max of the matrix (N,C)
/// along the columns.
/// If "perClassSuppression" flag is false, suppression happens across all classes.
/// If "perClassSuppression" flag is true, each box is assigned to the class with the highest
/// score and then the suppression happens separately for boxes within the same class.
///
/// Note that the 4th output can be used to dynamically slice the first 3 outputs, in case
/// the padded outputs are not required.
struct CoreML_Specification_NonMaximumSuppressionLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ///*
  /// The intersection over union (IoU) threshold over which boxes are suppressed.
  var iouThreshold: Float = 0

  ///*
  /// Before IoU suppression is performed, boxes with class scores below this threshold are rejected.
  var scoreThreshold: Float = 0

  ///*
  /// The maximum number of boxes to be given out as output.
  /// If the number of surviving boxes are less, output is padded up to this number.
  var maxBoxes: UInt64 = 0

  ///*
  /// If true, suppression is performed independently within boxes of each class.
  var perClassSuppression: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that performs element-wise clamped ReLU operation.
///
/// Requires 1 input and produces 1 output.
///
/// This function has the following formula:
///
/// .. math::
///     f(x) = \begin{cases}
///               \text{min}(\text{beta},x) \;\; \text{if} \;\; x \geq 0\\
///               \text{min}(\text{beta} ,\text{alpha}\cdot x) \;\; \text{if} \;\; x<0
///            \end{cases}
///
/// Output shape is same as the input.
///
/// Available (iOS >= 14, macOS >= 11.0, watchOS >= 7)
struct CoreML_Specification_ClampedReLULayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var alpha: Float = 0

  var beta: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that returns the indices that would sort the input tensor, along a specified axis.
///
/// Requires 1 input and produces 1 output.
///
/// Output has the same rank and shape as the input.
///
/// Value of "axis" must be positive and less than the rank of the input.
///
/// e.g.:
///
/// input shape = (5,)
/// axis = 0
/// input values = [3.1, 5.4, 32.9, 3.2, 77.0]
/// output shape = (5,)
/// output values = [0, 3, 1, 2, 4], descending = False
/// output values = [4, 2, 1, 3, 0], descending = True
///
/// input shape = (2,3)
/// axis = 1
/// input values = [[3, 5, 32], [3, 77, 6]]
/// output shape = (2,3)
/// output values = [[0, 1, 2], [0, 2, 1]], descending = False
/// output values = [[2, 1, 0], [1, 2, 0]], descending = True
struct CoreML_Specification_ArgSortLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// must be between [0, input_rank - 1]
  var axis: Int64 = 0

  var descending: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A layer that does slice operation by providing size to be extracted 
/// from the given input tensor.
///
/// Requires 2 inputs and produces 1 output.
/// Rank of the output is same as the rank of the first input.
///
/// The 1st input represents the tensor to be sliced.
/// The 2nd input represents the beginning index to be sliced from.
///
/// Example:
/// Input 1: x (x.shape = (2, 3, 4))
/// Input 2: begin
/// size: 2
/// axis: 1
///
/// Output: x[:, begin:begin+2, :]
struct CoreML_Specification_SliceBySizeLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var size: Int64 = 0

  var axis: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A neural network specialized as a classifier.
struct CoreML_Specification_NeuralNetworkClassifier {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var layers: [CoreML_Specification_NeuralNetworkLayer] = []

  var preprocessing: [CoreML_Specification_NeuralNetworkPreprocessing] = []

  /// use this enum value to determine the input tensor shapes to the neural network, for multiarray inputs
  var arrayInputShapeMapping: CoreML_Specification_NeuralNetworkMultiArrayShapeMapping = .rank5ArrayMapping

  /// use this enum value to determine the input tensor shapes to the neural network, for image inputs
  var imageInputShapeMapping: CoreML_Specification_NeuralNetworkImageShapeMapping = .rank5ImageMapping

  var updateParams: CoreML_Specification_NetworkUpdateParameters {
    get {return _updateParams ?? CoreML_Specification_NetworkUpdateParameters()}
    set {_updateParams = newValue}
  }
  /// Returns true if `updateParams` has been explicitly set.
  var hasUpdateParams: Bool {return self._updateParams != nil}
  /// Clears the value of `updateParams`. Subsequent reads from it will return its default value.
  mutating func clearUpdateParams() {self._updateParams = nil}

  /// The set of labels for every possible class.
  var classLabels: CoreML_Specification_NeuralNetworkClassifier.OneOf_ClassLabels? = nil

  var stringClassLabels: CoreML_Specification_StringVector {
    get {
      if case .stringClassLabels(let v)? = classLabels {return v}
      return CoreML_Specification_StringVector()
    }
    set {classLabels = .stringClassLabels(newValue)}
  }

  var int64ClassLabels: CoreML_Specification_Int64Vector {
    get {
      if case .int64ClassLabels(let v)? = classLabels {return v}
      return CoreML_Specification_Int64Vector()
    }
    set {classLabels = .int64ClassLabels(newValue)}
  }

  /// The name of the output blob containing the probability of each class.
  /// In other words, the score vector. Must be a 1-D tensor with the same
  /// number and order of elements as ClassLabels.
  var labelProbabilityLayerName: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The set of labels for every possible class.
  enum OneOf_ClassLabels: Equatable {
    case stringClassLabels(CoreML_Specification_StringVector)
    case int64ClassLabels(CoreML_Specification_Int64Vector)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_NeuralNetworkClassifier.OneOf_ClassLabels, rhs: CoreML_Specification_NeuralNetworkClassifier.OneOf_ClassLabels) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.stringClassLabels, .stringClassLabels): return {
        guard case .stringClassLabels(let l) = lhs, case .stringClassLabels(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.int64ClassLabels, .int64ClassLabels): return {
        guard case .int64ClassLabels(let l) = lhs, case .int64ClassLabels(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}

  fileprivate var _updateParams: CoreML_Specification_NetworkUpdateParameters? = nil
}

struct CoreML_Specification_OneHotLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  //// size of the one hot vector
  var oneHotVectorSize: UInt64 = 0

  ////  negative indexing is supported. It refers to the axis in the output tensor.
  var axis: Int64 = 0

  var onValue: Float = 0

  var offValue: Float = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_CumSumLayerParams {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  ////  negative indexing is supported
  var axis: Int64 = 0

  //// if true, the first element of the output is 0, and the last element contains the sum of the input up to the penultimate value
  //// if false, the first element of the output is same as the input and the last element is the sum of all the input values
  //// (this behavior is reversed when "reverse" flag is True)
  var excludeFinalSum: Bool = false

  //// if true, cumsum is performed in the opposite direction
  var reverse: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A neural network specialized as a regressor.
struct CoreML_Specification_NeuralNetworkRegressor {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var layers: [CoreML_Specification_NeuralNetworkLayer] = []

  var preprocessing: [CoreML_Specification_NeuralNetworkPreprocessing] = []

  /// use this enum value to determine the input tensor shapes to the neural network, for multiarray inputs
  var arrayInputShapeMapping: CoreML_Specification_NeuralNetworkMultiArrayShapeMapping = .rank5ArrayMapping

  /// use this enum value to determine the input tensor shapes to the neural network, for image inputs
  var imageInputShapeMapping: CoreML_Specification_NeuralNetworkImageShapeMapping = .rank5ImageMapping

  var updateParams: CoreML_Specification_NetworkUpdateParameters {
    get {return _updateParams ?? CoreML_Specification_NetworkUpdateParameters()}
    set {_updateParams = newValue}
  }
  /// Returns true if `updateParams` has been explicitly set.
  var hasUpdateParams: Bool {return self._updateParams != nil}
  /// Clears the value of `updateParams`. Subsequent reads from it will return its default value.
  mutating func clearUpdateParams() {self._updateParams = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _updateParams: CoreML_Specification_NetworkUpdateParameters? = nil
}

///*
/// Details on how the network will be updated
struct CoreML_Specification_NetworkUpdateParameters {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var lossLayers: [CoreML_Specification_LossLayer] {
    get {return _storage._lossLayers}
    set {_uniqueStorage()._lossLayers = newValue}
  }

  var optimizer: CoreML_Specification_Optimizer {
    get {return _storage._optimizer ?? CoreML_Specification_Optimizer()}
    set {_uniqueStorage()._optimizer = newValue}
  }
  /// Returns true if `optimizer` has been explicitly set.
  var hasOptimizer: Bool {return _storage._optimizer != nil}
  /// Clears the value of `optimizer`. Subsequent reads from it will return its default value.
  mutating func clearOptimizer() {_uniqueStorage()._optimizer = nil}

  var epochs: CoreML_Specification_Int64Parameter {
    get {return _storage._epochs ?? CoreML_Specification_Int64Parameter()}
    set {_uniqueStorage()._epochs = newValue}
  }
  /// Returns true if `epochs` has been explicitly set.
  var hasEpochs: Bool {return _storage._epochs != nil}
  /// Clears the value of `epochs`. Subsequent reads from it will return its default value.
  mutating func clearEpochs() {_uniqueStorage()._epochs = nil}

  ///*
  /// Describes whether to shuffle the batch of data between epochs.
  var shuffle: CoreML_Specification_BoolParameter {
    get {return _storage._shuffle ?? CoreML_Specification_BoolParameter()}
    set {_uniqueStorage()._shuffle = newValue}
  }
  /// Returns true if `shuffle` has been explicitly set.
  var hasShuffle: Bool {return _storage._shuffle != nil}
  /// Clears the value of `shuffle`. Subsequent reads from it will return its default value.
  mutating func clearShuffle() {_uniqueStorage()._shuffle = nil}

  ///*
  /// The seed to be used in an associated random number generator.
  var seed: CoreML_Specification_Int64Parameter {
    get {return _storage._seed ?? CoreML_Specification_Int64Parameter()}
    set {_uniqueStorage()._seed = newValue}
  }
  /// Returns true if `seed` has been explicitly set.
  var hasSeed: Bool {return _storage._seed != nil}
  /// Clears the value of `seed`. Subsequent reads from it will return its default value.
  mutating func clearSeed() {_uniqueStorage()._seed = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

///*
/// Loss layer - categorical cross entropy and mean squared error are the only supported loss functions currently
struct CoreML_Specification_LossLayer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var name: String = String()

  var lossLayerType: CoreML_Specification_LossLayer.OneOf_LossLayerType? = nil

  var categoricalCrossEntropyLossLayer: CoreML_Specification_CategoricalCrossEntropyLossLayer {
    get {
      if case .categoricalCrossEntropyLossLayer(let v)? = lossLayerType {return v}
      return CoreML_Specification_CategoricalCrossEntropyLossLayer()
    }
    set {lossLayerType = .categoricalCrossEntropyLossLayer(newValue)}
  }

  var meanSquaredErrorLossLayer: CoreML_Specification_MeanSquaredErrorLossLayer {
    get {
      if case .meanSquaredErrorLossLayer(let v)? = lossLayerType {return v}
      return CoreML_Specification_MeanSquaredErrorLossLayer()
    }
    set {lossLayerType = .meanSquaredErrorLossLayer(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_LossLayerType: Equatable {
    case categoricalCrossEntropyLossLayer(CoreML_Specification_CategoricalCrossEntropyLossLayer)
    case meanSquaredErrorLossLayer(CoreML_Specification_MeanSquaredErrorLossLayer)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_LossLayer.OneOf_LossLayerType, rhs: CoreML_Specification_LossLayer.OneOf_LossLayerType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.categoricalCrossEntropyLossLayer, .categoricalCrossEntropyLossLayer): return {
        guard case .categoricalCrossEntropyLossLayer(let l) = lhs, case .categoricalCrossEntropyLossLayer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.meanSquaredErrorLossLayer, .meanSquaredErrorLossLayer): return {
        guard case .meanSquaredErrorLossLayer(let l) = lhs, case .meanSquaredErrorLossLayer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}
}

///*
/// Categorical cross entropy loss layer
/// Categorical cross entropy is used for single label categorization (only one category is applicable for each data point).
///
/// The input is a vector of length N representing the distribution over N categories.  It must be the output of a softmax.
///
/// The target is a single value representing the true category or class label. If the target is the predictedFeatureName of a neural network classifier it will be inverse mapped to the corresponding categorical index for you.
///
/// math:
/// Loss_{CCE}(input, target) = -\sum_{i=1}^{N} (target == i) log( input[i] ) = - log (input[target])
struct CoreML_Specification_CategoricalCrossEntropyLossLayer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var input: String = String()

  var target: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Mean squared error loss layer,
/// specifying input and target
struct CoreML_Specification_MeanSquaredErrorLossLayer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var input: String = String()

  var target: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// Optimizer - stochastic gradient descent and adam are the only supported optimizers currently
struct CoreML_Specification_Optimizer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var optimizerType: CoreML_Specification_Optimizer.OneOf_OptimizerType? = nil

  var sgdOptimizer: CoreML_Specification_SGDOptimizer {
    get {
      if case .sgdOptimizer(let v)? = optimizerType {return v}
      return CoreML_Specification_SGDOptimizer()
    }
    set {optimizerType = .sgdOptimizer(newValue)}
  }

  var adamOptimizer: CoreML_Specification_AdamOptimizer {
    get {
      if case .adamOptimizer(let v)? = optimizerType {return v}
      return CoreML_Specification_AdamOptimizer()
    }
    set {optimizerType = .adamOptimizer(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_OptimizerType: Equatable {
    case sgdOptimizer(CoreML_Specification_SGDOptimizer)
    case adamOptimizer(CoreML_Specification_AdamOptimizer)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_Optimizer.OneOf_OptimizerType, rhs: CoreML_Specification_Optimizer.OneOf_OptimizerType) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.sgdOptimizer, .sgdOptimizer): return {
        guard case .sgdOptimizer(let l) = lhs, case .sgdOptimizer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.adamOptimizer, .adamOptimizer): return {
        guard case .adamOptimizer(let l) = lhs, case .adamOptimizer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}
}

///*
/// Stochastic gradient descent optimizer,
/// specifying configurable learning rate, mini batch size, and momentum
struct CoreML_Specification_SGDOptimizer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var learningRate: CoreML_Specification_DoubleParameter {
    get {return _learningRate ?? CoreML_Specification_DoubleParameter()}
    set {_learningRate = newValue}
  }
  /// Returns true if `learningRate` has been explicitly set.
  var hasLearningRate: Bool {return self._learningRate != nil}
  /// Clears the value of `learningRate`. Subsequent reads from it will return its default value.
  mutating func clearLearningRate() {self._learningRate = nil}

  var miniBatchSize: CoreML_Specification_Int64Parameter {
    get {return _miniBatchSize ?? CoreML_Specification_Int64Parameter()}
    set {_miniBatchSize = newValue}
  }
  /// Returns true if `miniBatchSize` has been explicitly set.
  var hasMiniBatchSize: Bool {return self._miniBatchSize != nil}
  /// Clears the value of `miniBatchSize`. Subsequent reads from it will return its default value.
  mutating func clearMiniBatchSize() {self._miniBatchSize = nil}

  var momentum: CoreML_Specification_DoubleParameter {
    get {return _momentum ?? CoreML_Specification_DoubleParameter()}
    set {_momentum = newValue}
  }
  /// Returns true if `momentum` has been explicitly set.
  var hasMomentum: Bool {return self._momentum != nil}
  /// Clears the value of `momentum`. Subsequent reads from it will return its default value.
  mutating func clearMomentum() {self._momentum = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _learningRate: CoreML_Specification_DoubleParameter? = nil
  fileprivate var _miniBatchSize: CoreML_Specification_Int64Parameter? = nil
  fileprivate var _momentum: CoreML_Specification_DoubleParameter? = nil
}

///*
/// Adam optimizer,
/// specifying configurable learning rate, mini batch size, betas, and eps
struct CoreML_Specification_AdamOptimizer {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var learningRate: CoreML_Specification_DoubleParameter {
    get {return _learningRate ?? CoreML_Specification_DoubleParameter()}
    set {_learningRate = newValue}
  }
  /// Returns true if `learningRate` has been explicitly set.
  var hasLearningRate: Bool {return self._learningRate != nil}
  /// Clears the value of `learningRate`. Subsequent reads from it will return its default value.
  mutating func clearLearningRate() {self._learningRate = nil}

  var miniBatchSize: CoreML_Specification_Int64Parameter {
    get {return _miniBatchSize ?? CoreML_Specification_Int64Parameter()}
    set {_miniBatchSize = newValue}
  }
  /// Returns true if `miniBatchSize` has been explicitly set.
  var hasMiniBatchSize: Bool {return self._miniBatchSize != nil}
  /// Clears the value of `miniBatchSize`. Subsequent reads from it will return its default value.
  mutating func clearMiniBatchSize() {self._miniBatchSize = nil}

  var beta1: CoreML_Specification_DoubleParameter {
    get {return _beta1 ?? CoreML_Specification_DoubleParameter()}
    set {_beta1 = newValue}
  }
  /// Returns true if `beta1` has been explicitly set.
  var hasBeta1: Bool {return self._beta1 != nil}
  /// Clears the value of `beta1`. Subsequent reads from it will return its default value.
  mutating func clearBeta1() {self._beta1 = nil}

  var beta2: CoreML_Specification_DoubleParameter {
    get {return _beta2 ?? CoreML_Specification_DoubleParameter()}
    set {_beta2 = newValue}
  }
  /// Returns true if `beta2` has been explicitly set.
  var hasBeta2: Bool {return self._beta2 != nil}
  /// Clears the value of `beta2`. Subsequent reads from it will return its default value.
  mutating func clearBeta2() {self._beta2 = nil}

  var eps: CoreML_Specification_DoubleParameter {
    get {return _eps ?? CoreML_Specification_DoubleParameter()}
    set {_eps = newValue}
  }
  /// Returns true if `eps` has been explicitly set.
  var hasEps: Bool {return self._eps != nil}
  /// Clears the value of `eps`. Subsequent reads from it will return its default value.
  mutating func clearEps() {self._eps = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _learningRate: CoreML_Specification_DoubleParameter? = nil
  fileprivate var _miniBatchSize: CoreML_Specification_Int64Parameter? = nil
  fileprivate var _beta1: CoreML_Specification_DoubleParameter? = nil
  fileprivate var _beta2: CoreML_Specification_DoubleParameter? = nil
  fileprivate var _eps: CoreML_Specification_DoubleParameter? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "CoreML.Specification"

extension CoreML_Specification_NeuralNetworkMultiArrayShapeMapping: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "RANK5_ARRAY_MAPPING"),
    1: .same(proto: "EXACT_ARRAY_MAPPING"),
  ]
}

extension CoreML_Specification_NeuralNetworkImageShapeMapping: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "RANK5_IMAGE_MAPPING"),
    1: .same(proto: "RANK4_IMAGE_MAPPING"),
  ]
}

extension CoreML_Specification_ScatterMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SCATTER_UPDATE"),
    1: .same(proto: "SCATTER_ADD"),
    2: .same(proto: "SCATTER_SUB"),
    3: .same(proto: "SCATTER_MUL"),
    4: .same(proto: "SCATTER_DIV"),
    5: .same(proto: "SCATTER_MAX"),
    6: .same(proto: "SCATTER_MIN"),
  ]
}

extension CoreML_Specification_NeuralNetwork: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetwork"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "layers"),
    2: .same(proto: "preprocessing"),
    5: .same(proto: "arrayInputShapeMapping"),
    6: .same(proto: "imageInputShapeMapping"),
    10: .same(proto: "updateParams"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.layers) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.preprocessing) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.arrayInputShapeMapping) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.imageInputShapeMapping) }()
      case 10: try { try decoder.decodeSingularMessageField(value: &self._updateParams) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.layers.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.layers, fieldNumber: 1)
    }
    if !self.preprocessing.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.preprocessing, fieldNumber: 2)
    }
    if self.arrayInputShapeMapping != .rank5ArrayMapping {
      try visitor.visitSingularEnumField(value: self.arrayInputShapeMapping, fieldNumber: 5)
    }
    if self.imageInputShapeMapping != .rank5ImageMapping {
      try visitor.visitSingularEnumField(value: self.imageInputShapeMapping, fieldNumber: 6)
    }
    try { if let v = self._updateParams {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetwork, rhs: CoreML_Specification_NeuralNetwork) -> Bool {
    if lhs.layers != rhs.layers {return false}
    if lhs.preprocessing != rhs.preprocessing {return false}
    if lhs.arrayInputShapeMapping != rhs.arrayInputShapeMapping {return false}
    if lhs.imageInputShapeMapping != rhs.imageInputShapeMapping {return false}
    if lhs._updateParams != rhs._updateParams {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkImageScaler: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkImageScaler"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "channelScale"),
    20: .same(proto: "blueBias"),
    21: .same(proto: "greenBias"),
    22: .same(proto: "redBias"),
    30: .same(proto: "grayBias"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try { try decoder.decodeSingularFloatField(value: &self.channelScale) }()
      case 20: try { try decoder.decodeSingularFloatField(value: &self.blueBias) }()
      case 21: try { try decoder.decodeSingularFloatField(value: &self.greenBias) }()
      case 22: try { try decoder.decodeSingularFloatField(value: &self.redBias) }()
      case 30: try { try decoder.decodeSingularFloatField(value: &self.grayBias) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.channelScale != 0 {
      try visitor.visitSingularFloatField(value: self.channelScale, fieldNumber: 10)
    }
    if self.blueBias != 0 {
      try visitor.visitSingularFloatField(value: self.blueBias, fieldNumber: 20)
    }
    if self.greenBias != 0 {
      try visitor.visitSingularFloatField(value: self.greenBias, fieldNumber: 21)
    }
    if self.redBias != 0 {
      try visitor.visitSingularFloatField(value: self.redBias, fieldNumber: 22)
    }
    if self.grayBias != 0 {
      try visitor.visitSingularFloatField(value: self.grayBias, fieldNumber: 30)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkImageScaler, rhs: CoreML_Specification_NeuralNetworkImageScaler) -> Bool {
    if lhs.channelScale != rhs.channelScale {return false}
    if lhs.blueBias != rhs.blueBias {return false}
    if lhs.greenBias != rhs.greenBias {return false}
    if lhs.redBias != rhs.redBias {return false}
    if lhs.grayBias != rhs.grayBias {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkMeanImage: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkMeanImage"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "meanImage"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.meanImage) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.meanImage.isEmpty {
      try visitor.visitPackedFloatField(value: self.meanImage, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkMeanImage, rhs: CoreML_Specification_NeuralNetworkMeanImage) -> Bool {
    if lhs.meanImage != rhs.meanImage {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkPreprocessing: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkPreprocessing"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "featureName"),
    10: .same(proto: "scaler"),
    11: .same(proto: "meanImage"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.featureName) }()
      case 10: try {
        var v: CoreML_Specification_NeuralNetworkImageScaler?
        var hadOneofValue = false
        if let current = self.preprocessor {
          hadOneofValue = true
          if case .scaler(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.preprocessor = .scaler(v)
        }
      }()
      case 11: try {
        var v: CoreML_Specification_NeuralNetworkMeanImage?
        var hadOneofValue = false
        if let current = self.preprocessor {
          hadOneofValue = true
          if case .meanImage(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.preprocessor = .meanImage(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.featureName.isEmpty {
      try visitor.visitSingularStringField(value: self.featureName, fieldNumber: 1)
    }
    switch self.preprocessor {
    case .scaler?: try {
      guard case .scaler(let v)? = self.preprocessor else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .meanImage?: try {
      guard case .meanImage(let v)? = self.preprocessor else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkPreprocessing, rhs: CoreML_Specification_NeuralNetworkPreprocessing) -> Bool {
    if lhs.featureName != rhs.featureName {return false}
    if lhs.preprocessor != rhs.preprocessor {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationReLU: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationReLU"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationReLU, rhs: CoreML_Specification_ActivationReLU) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationLeakyReLU: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationLeakyReLU"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationLeakyReLU, rhs: CoreML_Specification_ActivationLeakyReLU) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationTanh: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationTanh"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationTanh, rhs: CoreML_Specification_ActivationTanh) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationScaledTanh: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationScaledTanh"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.beta) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    if self.beta != 0 {
      try visitor.visitSingularFloatField(value: self.beta, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationScaledTanh, rhs: CoreML_Specification_ActivationScaledTanh) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.beta != rhs.beta {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationSigmoid: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationSigmoid"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationSigmoid, rhs: CoreML_Specification_ActivationSigmoid) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationLinear: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationLinear"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.beta) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    if self.beta != 0 {
      try visitor.visitSingularFloatField(value: self.beta, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationLinear, rhs: CoreML_Specification_ActivationLinear) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.beta != rhs.beta {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationSigmoidHard: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationSigmoidHard"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.beta) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    if self.beta != 0 {
      try visitor.visitSingularFloatField(value: self.beta, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationSigmoidHard, rhs: CoreML_Specification_ActivationSigmoidHard) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.beta != rhs.beta {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationPReLU: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationPReLU"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._alpha {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationPReLU, rhs: CoreML_Specification_ActivationPReLU) -> Bool {
    if lhs._alpha != rhs._alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationELU: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationELU"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationELU, rhs: CoreML_Specification_ActivationELU) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationThresholdedReLU: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationThresholdedReLU"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationThresholdedReLU, rhs: CoreML_Specification_ActivationThresholdedReLU) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationSoftsign: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationSoftsign"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationSoftsign, rhs: CoreML_Specification_ActivationSoftsign) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationSoftplus: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationSoftplus"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationSoftplus, rhs: CoreML_Specification_ActivationSoftplus) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationParametricSoftplus: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationParametricSoftplus"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._alpha) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._beta) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._alpha {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._beta {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationParametricSoftplus, rhs: CoreML_Specification_ActivationParametricSoftplus) -> Bool {
    if lhs._alpha != rhs._alpha {return false}
    if lhs._beta != rhs._beta {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ActivationParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ActivationParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    5: .same(proto: "linear"),
    10: .same(proto: "ReLU"),
    15: .same(proto: "leakyReLU"),
    20: .same(proto: "thresholdedReLU"),
    25: .same(proto: "PReLU"),
    30: .same(proto: "tanh"),
    31: .same(proto: "scaledTanh"),
    40: .same(proto: "sigmoid"),
    41: .same(proto: "sigmoidHard"),
    50: .same(proto: "ELU"),
    60: .same(proto: "softsign"),
    70: .same(proto: "softplus"),
    71: .same(proto: "parametricSoftplus"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 5: try {
        var v: CoreML_Specification_ActivationLinear?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .linear(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .linear(v)
        }
      }()
      case 10: try {
        var v: CoreML_Specification_ActivationReLU?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .reLu(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .reLu(v)
        }
      }()
      case 15: try {
        var v: CoreML_Specification_ActivationLeakyReLU?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .leakyReLu(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .leakyReLu(v)
        }
      }()
      case 20: try {
        var v: CoreML_Specification_ActivationThresholdedReLU?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .thresholdedReLu(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .thresholdedReLu(v)
        }
      }()
      case 25: try {
        var v: CoreML_Specification_ActivationPReLU?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .preLu(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .preLu(v)
        }
      }()
      case 30: try {
        var v: CoreML_Specification_ActivationTanh?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .tanh(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .tanh(v)
        }
      }()
      case 31: try {
        var v: CoreML_Specification_ActivationScaledTanh?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .scaledTanh(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .scaledTanh(v)
        }
      }()
      case 40: try {
        var v: CoreML_Specification_ActivationSigmoid?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .sigmoid(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .sigmoid(v)
        }
      }()
      case 41: try {
        var v: CoreML_Specification_ActivationSigmoidHard?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .sigmoidHard(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .sigmoidHard(v)
        }
      }()
      case 50: try {
        var v: CoreML_Specification_ActivationELU?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .elu(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .elu(v)
        }
      }()
      case 60: try {
        var v: CoreML_Specification_ActivationSoftsign?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .softsign(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .softsign(v)
        }
      }()
      case 70: try {
        var v: CoreML_Specification_ActivationSoftplus?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .softplus(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .softplus(v)
        }
      }()
      case 71: try {
        var v: CoreML_Specification_ActivationParametricSoftplus?
        var hadOneofValue = false
        if let current = self.nonlinearityType {
          hadOneofValue = true
          if case .parametricSoftplus(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.nonlinearityType = .parametricSoftplus(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.nonlinearityType {
    case .linear?: try {
      guard case .linear(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .reLu?: try {
      guard case .reLu(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .leakyReLu?: try {
      guard case .leakyReLu(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
    }()
    case .thresholdedReLu?: try {
      guard case .thresholdedReLu(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
    }()
    case .preLu?: try {
      guard case .preLu(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 25)
    }()
    case .tanh?: try {
      guard case .tanh(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 30)
    }()
    case .scaledTanh?: try {
      guard case .scaledTanh(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 31)
    }()
    case .sigmoid?: try {
      guard case .sigmoid(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 40)
    }()
    case .sigmoidHard?: try {
      guard case .sigmoidHard(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 41)
    }()
    case .elu?: try {
      guard case .elu(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 50)
    }()
    case .softsign?: try {
      guard case .softsign(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 60)
    }()
    case .softplus?: try {
      guard case .softplus(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 70)
    }()
    case .parametricSoftplus?: try {
      guard case .parametricSoftplus(let v)? = self.nonlinearityType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 71)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ActivationParams, rhs: CoreML_Specification_ActivationParams) -> Bool {
    if lhs.nonlinearityType != rhs.nonlinearityType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Tensor: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Tensor"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "rank"),
    2: .same(proto: "dimValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt32Field(value: &self.rank) }()
      case 2: try { try decoder.decodeRepeatedInt64Field(value: &self.dimValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.rank != 0 {
      try visitor.visitSingularUInt32Field(value: self.rank, fieldNumber: 1)
    }
    if !self.dimValue.isEmpty {
      try visitor.visitPackedInt64Field(value: self.dimValue, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Tensor, rhs: CoreML_Specification_Tensor) -> Bool {
    if lhs.rank != rhs.rank {return false}
    if lhs.dimValue != rhs.dimValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkLayer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkLayer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "input"),
    3: .same(proto: "output"),
    4: .same(proto: "inputTensor"),
    5: .same(proto: "outputTensor"),
    10: .same(proto: "isUpdatable"),
    100: .same(proto: "convolution"),
    120: .same(proto: "pooling"),
    130: .same(proto: "activation"),
    140: .same(proto: "innerProduct"),
    150: .same(proto: "embedding"),
    160: .same(proto: "batchnorm"),
    165: .same(proto: "mvn"),
    170: .same(proto: "l2normalize"),
    175: .same(proto: "softmax"),
    180: .same(proto: "lrn"),
    190: .same(proto: "crop"),
    200: .same(proto: "padding"),
    210: .same(proto: "upsample"),
    211: .same(proto: "resizeBilinear"),
    212: .same(proto: "cropResize"),
    220: .same(proto: "unary"),
    230: .same(proto: "add"),
    231: .same(proto: "multiply"),
    240: .same(proto: "average"),
    245: .same(proto: "scale"),
    250: .same(proto: "bias"),
    260: .same(proto: "max"),
    261: .same(proto: "min"),
    270: .same(proto: "dot"),
    280: .same(proto: "reduce"),
    290: .same(proto: "loadConstant"),
    300: .same(proto: "reshape"),
    301: .same(proto: "flatten"),
    310: .same(proto: "permute"),
    320: .same(proto: "concat"),
    330: .same(proto: "split"),
    340: .same(proto: "sequenceRepeat"),
    345: .same(proto: "reorganizeData"),
    350: .same(proto: "slice"),
    400: .same(proto: "simpleRecurrent"),
    410: .same(proto: "gru"),
    420: .same(proto: "uniDirectionalLSTM"),
    430: .same(proto: "biDirectionalLSTM"),
    500: .same(proto: "custom"),
    600: .same(proto: "copy"),
    605: .same(proto: "branch"),
    615: .same(proto: "loop"),
    620: .same(proto: "loopBreak"),
    625: .same(proto: "loopContinue"),
    635: .same(proto: "rangeStatic"),
    640: .same(proto: "rangeDynamic"),
    660: .same(proto: "clip"),
    665: .same(proto: "ceil"),
    670: .same(proto: "floor"),
    680: .same(proto: "sign"),
    685: .same(proto: "round"),
    700: .same(proto: "exp2"),
    710: .same(proto: "sin"),
    715: .same(proto: "cos"),
    720: .same(proto: "tan"),
    730: .same(proto: "asin"),
    735: .same(proto: "acos"),
    740: .same(proto: "atan"),
    750: .same(proto: "sinh"),
    755: .same(proto: "cosh"),
    760: .same(proto: "tanh"),
    770: .same(proto: "asinh"),
    775: .same(proto: "acosh"),
    780: .same(proto: "atanh"),
    790: .same(proto: "erf"),
    795: .same(proto: "gelu"),
    815: .same(proto: "equal"),
    820: .same(proto: "notEqual"),
    825: .same(proto: "lessThan"),
    827: .same(proto: "lessEqual"),
    830: .same(proto: "greaterThan"),
    832: .same(proto: "greaterEqual"),
    840: .same(proto: "logicalOr"),
    845: .same(proto: "logicalXor"),
    850: .same(proto: "logicalNot"),
    855: .same(proto: "logicalAnd"),
    865: .same(proto: "modBroadcastable"),
    870: .same(proto: "minBroadcastable"),
    875: .same(proto: "maxBroadcastable"),
    880: .same(proto: "addBroadcastable"),
    885: .same(proto: "powBroadcastable"),
    890: .same(proto: "divideBroadcastable"),
    895: .same(proto: "floorDivBroadcastable"),
    900: .same(proto: "multiplyBroadcastable"),
    905: .same(proto: "subtractBroadcastable"),
    920: .same(proto: "tile"),
    925: .same(proto: "stack"),
    930: .same(proto: "gather"),
    935: .same(proto: "scatter"),
    940: .same(proto: "gatherND"),
    945: .same(proto: "scatterND"),
    950: .same(proto: "softmaxND"),
    952: .same(proto: "gatherAlongAxis"),
    954: .same(proto: "scatterAlongAxis"),
    960: .same(proto: "reverse"),
    965: .same(proto: "reverseSeq"),
    975: .same(proto: "splitND"),
    980: .same(proto: "concatND"),
    985: .same(proto: "transpose"),
    995: .same(proto: "sliceStatic"),
    1000: .same(proto: "sliceDynamic"),
    1005: .same(proto: "slidingWindows"),
    1015: .same(proto: "topK"),
    1020: .same(proto: "argMin"),
    1025: .same(proto: "argMax"),
    1040: .same(proto: "embeddingND"),
    1045: .same(proto: "batchedMatmul"),
    1065: .same(proto: "getShape"),
    1070: .same(proto: "loadConstantND"),
    1080: .same(proto: "fillLike"),
    1085: .same(proto: "fillStatic"),
    1090: .same(proto: "fillDynamic"),
    1100: .same(proto: "broadcastToLike"),
    1105: .same(proto: "broadcastToStatic"),
    1110: .same(proto: "broadcastToDynamic"),
    1120: .same(proto: "squeeze"),
    1125: .same(proto: "expandDims"),
    1130: .same(proto: "flattenTo2D"),
    1135: .same(proto: "reshapeLike"),
    1140: .same(proto: "reshapeStatic"),
    1145: .same(proto: "reshapeDynamic"),
    1150: .same(proto: "rankPreservingReshape"),
    1155: .same(proto: "constantPad"),
    1170: .same(proto: "randomNormalLike"),
    1175: .same(proto: "randomNormalStatic"),
    1180: .same(proto: "randomNormalDynamic"),
    1190: .same(proto: "randomUniformLike"),
    1195: .same(proto: "randomUniformStatic"),
    1200: .same(proto: "randomUniformDynamic"),
    1210: .same(proto: "randomBernoulliLike"),
    1215: .same(proto: "randomBernoulliStatic"),
    1220: .same(proto: "randomBernoulliDynamic"),
    1230: .same(proto: "categoricalDistribution"),
    1250: .same(proto: "reduceL1"),
    1255: .same(proto: "reduceL2"),
    1260: .same(proto: "reduceMax"),
    1265: .same(proto: "reduceMin"),
    1270: .same(proto: "reduceSum"),
    1275: .same(proto: "reduceProd"),
    1280: .same(proto: "reduceMean"),
    1285: .same(proto: "reduceLogSum"),
    1290: .same(proto: "reduceSumSquare"),
    1295: .same(proto: "reduceLogSumExp"),
    1313: .same(proto: "whereNonZero"),
    1315: .same(proto: "matrixBandPart"),
    1320: .same(proto: "lowerTriangular"),
    1325: .same(proto: "upperTriangular"),
    1330: .same(proto: "whereBroadcastable"),
    1350: .same(proto: "layerNormalization"),
    1400: .same(proto: "NonMaximumSuppression"),
    1450: .same(proto: "oneHot"),
    1455: .same(proto: "cumSum"),
    1460: .same(proto: "clampedReLU"),
    1461: .same(proto: "argSort"),
    1465: .same(proto: "pooling3d"),
    1466: .same(proto: "globalPooling3d"),
    1470: .same(proto: "sliceBySize"),
    1471: .same(proto: "convolution3d"),
  ]

  fileprivate class _StorageClass {
    var _name: String = String()
    var _input: [String] = []
    var _output: [String] = []
    var _inputTensor: [CoreML_Specification_Tensor] = []
    var _outputTensor: [CoreML_Specification_Tensor] = []
    var _isUpdatable: Bool = false
    var _layer: CoreML_Specification_NeuralNetworkLayer.OneOf_Layer?

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _name = source._name
      _input = source._input
      _output = source._output
      _inputTensor = source._inputTensor
      _outputTensor = source._outputTensor
      _isUpdatable = source._isUpdatable
      _layer = source._layer
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularStringField(value: &_storage._name) }()
        case 2: try { try decoder.decodeRepeatedStringField(value: &_storage._input) }()
        case 3: try { try decoder.decodeRepeatedStringField(value: &_storage._output) }()
        case 4: try { try decoder.decodeRepeatedMessageField(value: &_storage._inputTensor) }()
        case 5: try { try decoder.decodeRepeatedMessageField(value: &_storage._outputTensor) }()
        case 10: try { try decoder.decodeSingularBoolField(value: &_storage._isUpdatable) }()
        case 100: try {
          var v: CoreML_Specification_ConvolutionLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .convolution(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .convolution(v)
          }
        }()
        case 120: try {
          var v: CoreML_Specification_PoolingLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .pooling(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .pooling(v)
          }
        }()
        case 130: try {
          var v: CoreML_Specification_ActivationParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .activation(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .activation(v)
          }
        }()
        case 140: try {
          var v: CoreML_Specification_InnerProductLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .innerProduct(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .innerProduct(v)
          }
        }()
        case 150: try {
          var v: CoreML_Specification_EmbeddingLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .embedding(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .embedding(v)
          }
        }()
        case 160: try {
          var v: CoreML_Specification_BatchnormLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .batchnorm(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .batchnorm(v)
          }
        }()
        case 165: try {
          var v: CoreML_Specification_MeanVarianceNormalizeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .mvn(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .mvn(v)
          }
        }()
        case 170: try {
          var v: CoreML_Specification_L2NormalizeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .l2Normalize(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .l2Normalize(v)
          }
        }()
        case 175: try {
          var v: CoreML_Specification_SoftmaxLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .softmax(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .softmax(v)
          }
        }()
        case 180: try {
          var v: CoreML_Specification_LRNLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .lrn(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .lrn(v)
          }
        }()
        case 190: try {
          var v: CoreML_Specification_CropLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .crop(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .crop(v)
          }
        }()
        case 200: try {
          var v: CoreML_Specification_PaddingLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .padding(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .padding(v)
          }
        }()
        case 210: try {
          var v: CoreML_Specification_UpsampleLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .upsample(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .upsample(v)
          }
        }()
        case 211: try {
          var v: CoreML_Specification_ResizeBilinearLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .resizeBilinear(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .resizeBilinear(v)
          }
        }()
        case 212: try {
          var v: CoreML_Specification_CropResizeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .cropResize(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .cropResize(v)
          }
        }()
        case 220: try {
          var v: CoreML_Specification_UnaryFunctionLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .unary(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .unary(v)
          }
        }()
        case 230: try {
          var v: CoreML_Specification_AddLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .add(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .add(v)
          }
        }()
        case 231: try {
          var v: CoreML_Specification_MultiplyLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .multiply(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .multiply(v)
          }
        }()
        case 240: try {
          var v: CoreML_Specification_AverageLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .average(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .average(v)
          }
        }()
        case 245: try {
          var v: CoreML_Specification_ScaleLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .scale(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .scale(v)
          }
        }()
        case 250: try {
          var v: CoreML_Specification_BiasLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .bias(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .bias(v)
          }
        }()
        case 260: try {
          var v: CoreML_Specification_MaxLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .max(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .max(v)
          }
        }()
        case 261: try {
          var v: CoreML_Specification_MinLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .min(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .min(v)
          }
        }()
        case 270: try {
          var v: CoreML_Specification_DotProductLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .dot(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .dot(v)
          }
        }()
        case 280: try {
          var v: CoreML_Specification_ReduceLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduce(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduce(v)
          }
        }()
        case 290: try {
          var v: CoreML_Specification_LoadConstantLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .loadConstant(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .loadConstant(v)
          }
        }()
        case 300: try {
          var v: CoreML_Specification_ReshapeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reshape(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reshape(v)
          }
        }()
        case 301: try {
          var v: CoreML_Specification_FlattenLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .flatten(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .flatten(v)
          }
        }()
        case 310: try {
          var v: CoreML_Specification_PermuteLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .permute(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .permute(v)
          }
        }()
        case 320: try {
          var v: CoreML_Specification_ConcatLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .concat(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .concat(v)
          }
        }()
        case 330: try {
          var v: CoreML_Specification_SplitLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .split(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .split(v)
          }
        }()
        case 340: try {
          var v: CoreML_Specification_SequenceRepeatLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sequenceRepeat(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sequenceRepeat(v)
          }
        }()
        case 345: try {
          var v: CoreML_Specification_ReorganizeDataLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reorganizeData(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reorganizeData(v)
          }
        }()
        case 350: try {
          var v: CoreML_Specification_SliceLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .slice(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .slice(v)
          }
        }()
        case 400: try {
          var v: CoreML_Specification_SimpleRecurrentLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .simpleRecurrent(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .simpleRecurrent(v)
          }
        }()
        case 410: try {
          var v: CoreML_Specification_GRULayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .gru(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .gru(v)
          }
        }()
        case 420: try {
          var v: CoreML_Specification_UniDirectionalLSTMLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .uniDirectionalLstm(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .uniDirectionalLstm(v)
          }
        }()
        case 430: try {
          var v: CoreML_Specification_BiDirectionalLSTMLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .biDirectionalLstm(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .biDirectionalLstm(v)
          }
        }()
        case 500: try {
          var v: CoreML_Specification_CustomLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .custom(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .custom(v)
          }
        }()
        case 600: try {
          var v: CoreML_Specification_CopyLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .copy(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .copy(v)
          }
        }()
        case 605: try {
          var v: CoreML_Specification_BranchLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .branch(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .branch(v)
          }
        }()
        case 615: try {
          var v: CoreML_Specification_LoopLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .loop(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .loop(v)
          }
        }()
        case 620: try {
          var v: CoreML_Specification_LoopBreakLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .loopBreak(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .loopBreak(v)
          }
        }()
        case 625: try {
          var v: CoreML_Specification_LoopContinueLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .loopContinue(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .loopContinue(v)
          }
        }()
        case 635: try {
          var v: CoreML_Specification_RangeStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .rangeStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .rangeStatic(v)
          }
        }()
        case 640: try {
          var v: CoreML_Specification_RangeDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .rangeDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .rangeDynamic(v)
          }
        }()
        case 660: try {
          var v: CoreML_Specification_ClipLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .clip(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .clip(v)
          }
        }()
        case 665: try {
          var v: CoreML_Specification_CeilLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .ceil(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .ceil(v)
          }
        }()
        case 670: try {
          var v: CoreML_Specification_FloorLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .floor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .floor(v)
          }
        }()
        case 680: try {
          var v: CoreML_Specification_SignLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sign(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sign(v)
          }
        }()
        case 685: try {
          var v: CoreML_Specification_RoundLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .round(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .round(v)
          }
        }()
        case 700: try {
          var v: CoreML_Specification_Exp2LayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .exp2(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .exp2(v)
          }
        }()
        case 710: try {
          var v: CoreML_Specification_SinLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sin(v)
          }
        }()
        case 715: try {
          var v: CoreML_Specification_CosLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .cos(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .cos(v)
          }
        }()
        case 720: try {
          var v: CoreML_Specification_TanLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .tan(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .tan(v)
          }
        }()
        case 730: try {
          var v: CoreML_Specification_AsinLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .asin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .asin(v)
          }
        }()
        case 735: try {
          var v: CoreML_Specification_AcosLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .acos(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .acos(v)
          }
        }()
        case 740: try {
          var v: CoreML_Specification_AtanLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .atan(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .atan(v)
          }
        }()
        case 750: try {
          var v: CoreML_Specification_SinhLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sinh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sinh(v)
          }
        }()
        case 755: try {
          var v: CoreML_Specification_CoshLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .cosh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .cosh(v)
          }
        }()
        case 760: try {
          var v: CoreML_Specification_TanhLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .tanh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .tanh(v)
          }
        }()
        case 770: try {
          var v: CoreML_Specification_AsinhLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .asinh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .asinh(v)
          }
        }()
        case 775: try {
          var v: CoreML_Specification_AcoshLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .acosh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .acosh(v)
          }
        }()
        case 780: try {
          var v: CoreML_Specification_AtanhLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .atanh(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .atanh(v)
          }
        }()
        case 790: try {
          var v: CoreML_Specification_ErfLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .erf(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .erf(v)
          }
        }()
        case 795: try {
          var v: CoreML_Specification_GeluLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .gelu(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .gelu(v)
          }
        }()
        case 815: try {
          var v: CoreML_Specification_EqualLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .equal(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .equal(v)
          }
        }()
        case 820: try {
          var v: CoreML_Specification_NotEqualLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .notEqual(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .notEqual(v)
          }
        }()
        case 825: try {
          var v: CoreML_Specification_LessThanLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .lessThan(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .lessThan(v)
          }
        }()
        case 827: try {
          var v: CoreML_Specification_LessEqualLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .lessEqual(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .lessEqual(v)
          }
        }()
        case 830: try {
          var v: CoreML_Specification_GreaterThanLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .greaterThan(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .greaterThan(v)
          }
        }()
        case 832: try {
          var v: CoreML_Specification_GreaterEqualLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .greaterEqual(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .greaterEqual(v)
          }
        }()
        case 840: try {
          var v: CoreML_Specification_LogicalOrLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .logicalOr(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .logicalOr(v)
          }
        }()
        case 845: try {
          var v: CoreML_Specification_LogicalXorLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .logicalXor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .logicalXor(v)
          }
        }()
        case 850: try {
          var v: CoreML_Specification_LogicalNotLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .logicalNot(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .logicalNot(v)
          }
        }()
        case 855: try {
          var v: CoreML_Specification_LogicalAndLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .logicalAnd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .logicalAnd(v)
          }
        }()
        case 865: try {
          var v: CoreML_Specification_ModBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .modBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .modBroadcastable(v)
          }
        }()
        case 870: try {
          var v: CoreML_Specification_MinBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .minBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .minBroadcastable(v)
          }
        }()
        case 875: try {
          var v: CoreML_Specification_MaxBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .maxBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .maxBroadcastable(v)
          }
        }()
        case 880: try {
          var v: CoreML_Specification_AddBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .addBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .addBroadcastable(v)
          }
        }()
        case 885: try {
          var v: CoreML_Specification_PowBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .powBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .powBroadcastable(v)
          }
        }()
        case 890: try {
          var v: CoreML_Specification_DivideBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .divideBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .divideBroadcastable(v)
          }
        }()
        case 895: try {
          var v: CoreML_Specification_FloorDivBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .floorDivBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .floorDivBroadcastable(v)
          }
        }()
        case 900: try {
          var v: CoreML_Specification_MultiplyBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .multiplyBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .multiplyBroadcastable(v)
          }
        }()
        case 905: try {
          var v: CoreML_Specification_SubtractBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .subtractBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .subtractBroadcastable(v)
          }
        }()
        case 920: try {
          var v: CoreML_Specification_TileLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .tile(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .tile(v)
          }
        }()
        case 925: try {
          var v: CoreML_Specification_StackLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .stack(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .stack(v)
          }
        }()
        case 930: try {
          var v: CoreML_Specification_GatherLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .gather(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .gather(v)
          }
        }()
        case 935: try {
          var v: CoreML_Specification_ScatterLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .scatter(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .scatter(v)
          }
        }()
        case 940: try {
          var v: CoreML_Specification_GatherNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .gatherNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .gatherNd(v)
          }
        }()
        case 945: try {
          var v: CoreML_Specification_ScatterNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .scatterNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .scatterNd(v)
          }
        }()
        case 950: try {
          var v: CoreML_Specification_SoftmaxNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .softmaxNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .softmaxNd(v)
          }
        }()
        case 952: try {
          var v: CoreML_Specification_GatherAlongAxisLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .gatherAlongAxis(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .gatherAlongAxis(v)
          }
        }()
        case 954: try {
          var v: CoreML_Specification_ScatterAlongAxisLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .scatterAlongAxis(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .scatterAlongAxis(v)
          }
        }()
        case 960: try {
          var v: CoreML_Specification_ReverseLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reverse(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reverse(v)
          }
        }()
        case 965: try {
          var v: CoreML_Specification_ReverseSeqLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reverseSeq(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reverseSeq(v)
          }
        }()
        case 975: try {
          var v: CoreML_Specification_SplitNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .splitNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .splitNd(v)
          }
        }()
        case 980: try {
          var v: CoreML_Specification_ConcatNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .concatNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .concatNd(v)
          }
        }()
        case 985: try {
          var v: CoreML_Specification_TransposeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .transpose(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .transpose(v)
          }
        }()
        case 995: try {
          var v: CoreML_Specification_SliceStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sliceStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sliceStatic(v)
          }
        }()
        case 1000: try {
          var v: CoreML_Specification_SliceDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sliceDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sliceDynamic(v)
          }
        }()
        case 1005: try {
          var v: CoreML_Specification_SlidingWindowsLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .slidingWindows(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .slidingWindows(v)
          }
        }()
        case 1015: try {
          var v: CoreML_Specification_TopKLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .topK(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .topK(v)
          }
        }()
        case 1020: try {
          var v: CoreML_Specification_ArgMinLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .argMin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .argMin(v)
          }
        }()
        case 1025: try {
          var v: CoreML_Specification_ArgMaxLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .argMax(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .argMax(v)
          }
        }()
        case 1040: try {
          var v: CoreML_Specification_EmbeddingNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .embeddingNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .embeddingNd(v)
          }
        }()
        case 1045: try {
          var v: CoreML_Specification_BatchedMatMulLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .batchedMatmul(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .batchedMatmul(v)
          }
        }()
        case 1065: try {
          var v: CoreML_Specification_GetShapeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .getShape(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .getShape(v)
          }
        }()
        case 1070: try {
          var v: CoreML_Specification_LoadConstantNDLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .loadConstantNd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .loadConstantNd(v)
          }
        }()
        case 1080: try {
          var v: CoreML_Specification_FillLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .fillLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .fillLike(v)
          }
        }()
        case 1085: try {
          var v: CoreML_Specification_FillStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .fillStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .fillStatic(v)
          }
        }()
        case 1090: try {
          var v: CoreML_Specification_FillDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .fillDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .fillDynamic(v)
          }
        }()
        case 1100: try {
          var v: CoreML_Specification_BroadcastToLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .broadcastToLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .broadcastToLike(v)
          }
        }()
        case 1105: try {
          var v: CoreML_Specification_BroadcastToStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .broadcastToStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .broadcastToStatic(v)
          }
        }()
        case 1110: try {
          var v: CoreML_Specification_BroadcastToDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .broadcastToDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .broadcastToDynamic(v)
          }
        }()
        case 1120: try {
          var v: CoreML_Specification_SqueezeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .squeeze(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .squeeze(v)
          }
        }()
        case 1125: try {
          var v: CoreML_Specification_ExpandDimsLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .expandDims(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .expandDims(v)
          }
        }()
        case 1130: try {
          var v: CoreML_Specification_FlattenTo2DLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .flattenTo2D(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .flattenTo2D(v)
          }
        }()
        case 1135: try {
          var v: CoreML_Specification_ReshapeLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reshapeLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reshapeLike(v)
          }
        }()
        case 1140: try {
          var v: CoreML_Specification_ReshapeStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reshapeStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reshapeStatic(v)
          }
        }()
        case 1145: try {
          var v: CoreML_Specification_ReshapeDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reshapeDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reshapeDynamic(v)
          }
        }()
        case 1150: try {
          var v: CoreML_Specification_RankPreservingReshapeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .rankPreservingReshape(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .rankPreservingReshape(v)
          }
        }()
        case 1155: try {
          var v: CoreML_Specification_ConstantPaddingLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .constantPad(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .constantPad(v)
          }
        }()
        case 1170: try {
          var v: CoreML_Specification_RandomNormalLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomNormalLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomNormalLike(v)
          }
        }()
        case 1175: try {
          var v: CoreML_Specification_RandomNormalStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomNormalStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomNormalStatic(v)
          }
        }()
        case 1180: try {
          var v: CoreML_Specification_RandomNormalDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomNormalDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomNormalDynamic(v)
          }
        }()
        case 1190: try {
          var v: CoreML_Specification_RandomUniformLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomUniformLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomUniformLike(v)
          }
        }()
        case 1195: try {
          var v: CoreML_Specification_RandomUniformStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomUniformStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomUniformStatic(v)
          }
        }()
        case 1200: try {
          var v: CoreML_Specification_RandomUniformDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomUniformDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomUniformDynamic(v)
          }
        }()
        case 1210: try {
          var v: CoreML_Specification_RandomBernoulliLikeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomBernoulliLike(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomBernoulliLike(v)
          }
        }()
        case 1215: try {
          var v: CoreML_Specification_RandomBernoulliStaticLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomBernoulliStatic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomBernoulliStatic(v)
          }
        }()
        case 1220: try {
          var v: CoreML_Specification_RandomBernoulliDynamicLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .randomBernoulliDynamic(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .randomBernoulliDynamic(v)
          }
        }()
        case 1230: try {
          var v: CoreML_Specification_CategoricalDistributionLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .categoricalDistribution(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .categoricalDistribution(v)
          }
        }()
        case 1250: try {
          var v: CoreML_Specification_ReduceL1LayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceL1(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceL1(v)
          }
        }()
        case 1255: try {
          var v: CoreML_Specification_ReduceL2LayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceL2(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceL2(v)
          }
        }()
        case 1260: try {
          var v: CoreML_Specification_ReduceMaxLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceMax(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceMax(v)
          }
        }()
        case 1265: try {
          var v: CoreML_Specification_ReduceMinLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceMin(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceMin(v)
          }
        }()
        case 1270: try {
          var v: CoreML_Specification_ReduceSumLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceSum(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceSum(v)
          }
        }()
        case 1275: try {
          var v: CoreML_Specification_ReduceProdLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceProd(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceProd(v)
          }
        }()
        case 1280: try {
          var v: CoreML_Specification_ReduceMeanLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceMean(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceMean(v)
          }
        }()
        case 1285: try {
          var v: CoreML_Specification_ReduceLogSumLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceLogSum(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceLogSum(v)
          }
        }()
        case 1290: try {
          var v: CoreML_Specification_ReduceSumSquareLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceSumSquare(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceSumSquare(v)
          }
        }()
        case 1295: try {
          var v: CoreML_Specification_ReduceLogSumExpLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .reduceLogSumExp(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .reduceLogSumExp(v)
          }
        }()
        case 1313: try {
          var v: CoreML_Specification_WhereNonZeroLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .whereNonZero(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .whereNonZero(v)
          }
        }()
        case 1315: try {
          var v: CoreML_Specification_MatrixBandPartLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .matrixBandPart(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .matrixBandPart(v)
          }
        }()
        case 1320: try {
          var v: CoreML_Specification_LowerTriangularLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .lowerTriangular(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .lowerTriangular(v)
          }
        }()
        case 1325: try {
          var v: CoreML_Specification_UpperTriangularLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .upperTriangular(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .upperTriangular(v)
          }
        }()
        case 1330: try {
          var v: CoreML_Specification_WhereBroadcastableLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .whereBroadcastable(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .whereBroadcastable(v)
          }
        }()
        case 1350: try {
          var v: CoreML_Specification_LayerNormalizationLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .layerNormalization(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .layerNormalization(v)
          }
        }()
        case 1400: try {
          var v: CoreML_Specification_NonMaximumSuppressionLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .nonMaximumSuppression(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .nonMaximumSuppression(v)
          }
        }()
        case 1450: try {
          var v: CoreML_Specification_OneHotLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .oneHot(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .oneHot(v)
          }
        }()
        case 1455: try {
          var v: CoreML_Specification_CumSumLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .cumSum(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .cumSum(v)
          }
        }()
        case 1460: try {
          var v: CoreML_Specification_ClampedReLULayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .clampedReLu(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .clampedReLu(v)
          }
        }()
        case 1461: try {
          var v: CoreML_Specification_ArgSortLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .argSort(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .argSort(v)
          }
        }()
        case 1465: try {
          var v: CoreML_Specification_Pooling3DLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .pooling3D(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .pooling3D(v)
          }
        }()
        case 1466: try {
          var v: CoreML_Specification_GlobalPooling3DLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .globalPooling3D(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .globalPooling3D(v)
          }
        }()
        case 1470: try {
          var v: CoreML_Specification_SliceBySizeLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .sliceBySize(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .sliceBySize(v)
          }
        }()
        case 1471: try {
          var v: CoreML_Specification_Convolution3DLayerParams?
          var hadOneofValue = false
          if let current = _storage._layer {
            hadOneofValue = true
            if case .convolution3D(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._layer = .convolution3D(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._name.isEmpty {
        try visitor.visitSingularStringField(value: _storage._name, fieldNumber: 1)
      }
      if !_storage._input.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._input, fieldNumber: 2)
      }
      if !_storage._output.isEmpty {
        try visitor.visitRepeatedStringField(value: _storage._output, fieldNumber: 3)
      }
      if !_storage._inputTensor.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._inputTensor, fieldNumber: 4)
      }
      if !_storage._outputTensor.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._outputTensor, fieldNumber: 5)
      }
      if _storage._isUpdatable != false {
        try visitor.visitSingularBoolField(value: _storage._isUpdatable, fieldNumber: 10)
      }
      switch _storage._layer {
      case .convolution?: try {
        guard case .convolution(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 100)
      }()
      case .pooling?: try {
        guard case .pooling(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 120)
      }()
      case .activation?: try {
        guard case .activation(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 130)
      }()
      case .innerProduct?: try {
        guard case .innerProduct(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 140)
      }()
      case .embedding?: try {
        guard case .embedding(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 150)
      }()
      case .batchnorm?: try {
        guard case .batchnorm(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 160)
      }()
      case .mvn?: try {
        guard case .mvn(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 165)
      }()
      case .l2Normalize?: try {
        guard case .l2Normalize(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 170)
      }()
      case .softmax?: try {
        guard case .softmax(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 175)
      }()
      case .lrn?: try {
        guard case .lrn(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 180)
      }()
      case .crop?: try {
        guard case .crop(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 190)
      }()
      case .padding?: try {
        guard case .padding(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 200)
      }()
      case .upsample?: try {
        guard case .upsample(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 210)
      }()
      case .resizeBilinear?: try {
        guard case .resizeBilinear(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 211)
      }()
      case .cropResize?: try {
        guard case .cropResize(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 212)
      }()
      case .unary?: try {
        guard case .unary(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 220)
      }()
      case .add?: try {
        guard case .add(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 230)
      }()
      case .multiply?: try {
        guard case .multiply(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 231)
      }()
      case .average?: try {
        guard case .average(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 240)
      }()
      case .scale?: try {
        guard case .scale(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 245)
      }()
      case .bias?: try {
        guard case .bias(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 250)
      }()
      case .max?: try {
        guard case .max(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 260)
      }()
      case .min?: try {
        guard case .min(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 261)
      }()
      case .dot?: try {
        guard case .dot(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 270)
      }()
      case .reduce?: try {
        guard case .reduce(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 280)
      }()
      case .loadConstant?: try {
        guard case .loadConstant(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 290)
      }()
      case .reshape?: try {
        guard case .reshape(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 300)
      }()
      case .flatten?: try {
        guard case .flatten(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 301)
      }()
      case .permute?: try {
        guard case .permute(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 310)
      }()
      case .concat?: try {
        guard case .concat(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 320)
      }()
      case .split?: try {
        guard case .split(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 330)
      }()
      case .sequenceRepeat?: try {
        guard case .sequenceRepeat(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 340)
      }()
      case .reorganizeData?: try {
        guard case .reorganizeData(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 345)
      }()
      case .slice?: try {
        guard case .slice(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 350)
      }()
      case .simpleRecurrent?: try {
        guard case .simpleRecurrent(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 400)
      }()
      case .gru?: try {
        guard case .gru(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 410)
      }()
      case .uniDirectionalLstm?: try {
        guard case .uniDirectionalLstm(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 420)
      }()
      case .biDirectionalLstm?: try {
        guard case .biDirectionalLstm(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 430)
      }()
      case .custom?: try {
        guard case .custom(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 500)
      }()
      case .copy?: try {
        guard case .copy(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 600)
      }()
      case .branch?: try {
        guard case .branch(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 605)
      }()
      case .loop?: try {
        guard case .loop(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 615)
      }()
      case .loopBreak?: try {
        guard case .loopBreak(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 620)
      }()
      case .loopContinue?: try {
        guard case .loopContinue(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 625)
      }()
      case .rangeStatic?: try {
        guard case .rangeStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 635)
      }()
      case .rangeDynamic?: try {
        guard case .rangeDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 640)
      }()
      case .clip?: try {
        guard case .clip(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 660)
      }()
      case .ceil?: try {
        guard case .ceil(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 665)
      }()
      case .floor?: try {
        guard case .floor(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 670)
      }()
      case .sign?: try {
        guard case .sign(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 680)
      }()
      case .round?: try {
        guard case .round(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 685)
      }()
      case .exp2?: try {
        guard case .exp2(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 700)
      }()
      case .sin?: try {
        guard case .sin(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 710)
      }()
      case .cos?: try {
        guard case .cos(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 715)
      }()
      case .tan?: try {
        guard case .tan(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 720)
      }()
      case .asin?: try {
        guard case .asin(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 730)
      }()
      case .acos?: try {
        guard case .acos(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 735)
      }()
      case .atan?: try {
        guard case .atan(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 740)
      }()
      case .sinh?: try {
        guard case .sinh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 750)
      }()
      case .cosh?: try {
        guard case .cosh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 755)
      }()
      case .tanh?: try {
        guard case .tanh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 760)
      }()
      case .asinh?: try {
        guard case .asinh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 770)
      }()
      case .acosh?: try {
        guard case .acosh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 775)
      }()
      case .atanh?: try {
        guard case .atanh(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 780)
      }()
      case .erf?: try {
        guard case .erf(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 790)
      }()
      case .gelu?: try {
        guard case .gelu(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 795)
      }()
      case .equal?: try {
        guard case .equal(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 815)
      }()
      case .notEqual?: try {
        guard case .notEqual(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 820)
      }()
      case .lessThan?: try {
        guard case .lessThan(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 825)
      }()
      case .lessEqual?: try {
        guard case .lessEqual(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 827)
      }()
      case .greaterThan?: try {
        guard case .greaterThan(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 830)
      }()
      case .greaterEqual?: try {
        guard case .greaterEqual(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 832)
      }()
      case .logicalOr?: try {
        guard case .logicalOr(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 840)
      }()
      case .logicalXor?: try {
        guard case .logicalXor(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 845)
      }()
      case .logicalNot?: try {
        guard case .logicalNot(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 850)
      }()
      case .logicalAnd?: try {
        guard case .logicalAnd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 855)
      }()
      case .modBroadcastable?: try {
        guard case .modBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 865)
      }()
      case .minBroadcastable?: try {
        guard case .minBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 870)
      }()
      case .maxBroadcastable?: try {
        guard case .maxBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 875)
      }()
      case .addBroadcastable?: try {
        guard case .addBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 880)
      }()
      case .powBroadcastable?: try {
        guard case .powBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 885)
      }()
      case .divideBroadcastable?: try {
        guard case .divideBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 890)
      }()
      case .floorDivBroadcastable?: try {
        guard case .floorDivBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 895)
      }()
      case .multiplyBroadcastable?: try {
        guard case .multiplyBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 900)
      }()
      case .subtractBroadcastable?: try {
        guard case .subtractBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 905)
      }()
      case .tile?: try {
        guard case .tile(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 920)
      }()
      case .stack?: try {
        guard case .stack(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 925)
      }()
      case .gather?: try {
        guard case .gather(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 930)
      }()
      case .scatter?: try {
        guard case .scatter(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 935)
      }()
      case .gatherNd?: try {
        guard case .gatherNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 940)
      }()
      case .scatterNd?: try {
        guard case .scatterNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 945)
      }()
      case .softmaxNd?: try {
        guard case .softmaxNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 950)
      }()
      case .gatherAlongAxis?: try {
        guard case .gatherAlongAxis(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 952)
      }()
      case .scatterAlongAxis?: try {
        guard case .scatterAlongAxis(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 954)
      }()
      case .reverse?: try {
        guard case .reverse(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 960)
      }()
      case .reverseSeq?: try {
        guard case .reverseSeq(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 965)
      }()
      case .splitNd?: try {
        guard case .splitNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 975)
      }()
      case .concatNd?: try {
        guard case .concatNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 980)
      }()
      case .transpose?: try {
        guard case .transpose(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 985)
      }()
      case .sliceStatic?: try {
        guard case .sliceStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 995)
      }()
      case .sliceDynamic?: try {
        guard case .sliceDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1000)
      }()
      case .slidingWindows?: try {
        guard case .slidingWindows(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1005)
      }()
      case .topK?: try {
        guard case .topK(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1015)
      }()
      case .argMin?: try {
        guard case .argMin(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1020)
      }()
      case .argMax?: try {
        guard case .argMax(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1025)
      }()
      case .embeddingNd?: try {
        guard case .embeddingNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1040)
      }()
      case .batchedMatmul?: try {
        guard case .batchedMatmul(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1045)
      }()
      case .getShape?: try {
        guard case .getShape(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1065)
      }()
      case .loadConstantNd?: try {
        guard case .loadConstantNd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1070)
      }()
      case .fillLike?: try {
        guard case .fillLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1080)
      }()
      case .fillStatic?: try {
        guard case .fillStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1085)
      }()
      case .fillDynamic?: try {
        guard case .fillDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1090)
      }()
      case .broadcastToLike?: try {
        guard case .broadcastToLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1100)
      }()
      case .broadcastToStatic?: try {
        guard case .broadcastToStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1105)
      }()
      case .broadcastToDynamic?: try {
        guard case .broadcastToDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1110)
      }()
      case .squeeze?: try {
        guard case .squeeze(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1120)
      }()
      case .expandDims?: try {
        guard case .expandDims(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1125)
      }()
      case .flattenTo2D?: try {
        guard case .flattenTo2D(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1130)
      }()
      case .reshapeLike?: try {
        guard case .reshapeLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1135)
      }()
      case .reshapeStatic?: try {
        guard case .reshapeStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1140)
      }()
      case .reshapeDynamic?: try {
        guard case .reshapeDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1145)
      }()
      case .rankPreservingReshape?: try {
        guard case .rankPreservingReshape(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1150)
      }()
      case .constantPad?: try {
        guard case .constantPad(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1155)
      }()
      case .randomNormalLike?: try {
        guard case .randomNormalLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1170)
      }()
      case .randomNormalStatic?: try {
        guard case .randomNormalStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1175)
      }()
      case .randomNormalDynamic?: try {
        guard case .randomNormalDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1180)
      }()
      case .randomUniformLike?: try {
        guard case .randomUniformLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1190)
      }()
      case .randomUniformStatic?: try {
        guard case .randomUniformStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1195)
      }()
      case .randomUniformDynamic?: try {
        guard case .randomUniformDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1200)
      }()
      case .randomBernoulliLike?: try {
        guard case .randomBernoulliLike(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1210)
      }()
      case .randomBernoulliStatic?: try {
        guard case .randomBernoulliStatic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1215)
      }()
      case .randomBernoulliDynamic?: try {
        guard case .randomBernoulliDynamic(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1220)
      }()
      case .categoricalDistribution?: try {
        guard case .categoricalDistribution(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1230)
      }()
      case .reduceL1?: try {
        guard case .reduceL1(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1250)
      }()
      case .reduceL2?: try {
        guard case .reduceL2(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1255)
      }()
      case .reduceMax?: try {
        guard case .reduceMax(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1260)
      }()
      case .reduceMin?: try {
        guard case .reduceMin(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1265)
      }()
      case .reduceSum?: try {
        guard case .reduceSum(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1270)
      }()
      case .reduceProd?: try {
        guard case .reduceProd(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1275)
      }()
      case .reduceMean?: try {
        guard case .reduceMean(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1280)
      }()
      case .reduceLogSum?: try {
        guard case .reduceLogSum(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1285)
      }()
      case .reduceSumSquare?: try {
        guard case .reduceSumSquare(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1290)
      }()
      case .reduceLogSumExp?: try {
        guard case .reduceLogSumExp(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1295)
      }()
      case .whereNonZero?: try {
        guard case .whereNonZero(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1313)
      }()
      case .matrixBandPart?: try {
        guard case .matrixBandPart(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1315)
      }()
      case .lowerTriangular?: try {
        guard case .lowerTriangular(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1320)
      }()
      case .upperTriangular?: try {
        guard case .upperTriangular(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1325)
      }()
      case .whereBroadcastable?: try {
        guard case .whereBroadcastable(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1330)
      }()
      case .layerNormalization?: try {
        guard case .layerNormalization(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1350)
      }()
      case .nonMaximumSuppression?: try {
        guard case .nonMaximumSuppression(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1400)
      }()
      case .oneHot?: try {
        guard case .oneHot(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1450)
      }()
      case .cumSum?: try {
        guard case .cumSum(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1455)
      }()
      case .clampedReLu?: try {
        guard case .clampedReLu(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1460)
      }()
      case .argSort?: try {
        guard case .argSort(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1461)
      }()
      case .pooling3D?: try {
        guard case .pooling3D(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1465)
      }()
      case .globalPooling3D?: try {
        guard case .globalPooling3D(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1466)
      }()
      case .sliceBySize?: try {
        guard case .sliceBySize(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1470)
      }()
      case .convolution3D?: try {
        guard case .convolution3D(let v)? = _storage._layer else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1471)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkLayer, rhs: CoreML_Specification_NeuralNetworkLayer) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._name != rhs_storage._name {return false}
        if _storage._input != rhs_storage._input {return false}
        if _storage._output != rhs_storage._output {return false}
        if _storage._inputTensor != rhs_storage._inputTensor {return false}
        if _storage._outputTensor != rhs_storage._outputTensor {return false}
        if _storage._isUpdatable != rhs_storage._isUpdatable {return false}
        if _storage._layer != rhs_storage._layer {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BranchLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BranchLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "ifBranch"),
    2: .same(proto: "elseBranch"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._ifBranch) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._elseBranch) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._ifBranch {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._elseBranch {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BranchLayerParams, rhs: CoreML_Specification_BranchLayerParams) -> Bool {
    if lhs._ifBranch != rhs._ifBranch {return false}
    if lhs._elseBranch != rhs._elseBranch {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LoopLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoopLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "maxLoopIterations"),
    2: .same(proto: "conditionVar"),
    3: .same(proto: "conditionNetwork"),
    4: .same(proto: "bodyNetwork"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.maxLoopIterations) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.conditionVar) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._conditionNetwork) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._bodyNetwork) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.maxLoopIterations != 0 {
      try visitor.visitSingularUInt64Field(value: self.maxLoopIterations, fieldNumber: 1)
    }
    if !self.conditionVar.isEmpty {
      try visitor.visitSingularStringField(value: self.conditionVar, fieldNumber: 2)
    }
    try { if let v = self._conditionNetwork {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._bodyNetwork {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LoopLayerParams, rhs: CoreML_Specification_LoopLayerParams) -> Bool {
    if lhs.maxLoopIterations != rhs.maxLoopIterations {return false}
    if lhs.conditionVar != rhs.conditionVar {return false}
    if lhs._conditionNetwork != rhs._conditionNetwork {return false}
    if lhs._bodyNetwork != rhs._bodyNetwork {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LoopBreakLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoopBreakLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LoopBreakLayerParams, rhs: CoreML_Specification_LoopBreakLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LoopContinueLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoopContinueLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LoopContinueLayerParams, rhs: CoreML_Specification_LoopContinueLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CopyLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CopyLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CopyLayerParams, rhs: CoreML_Specification_CopyLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GreaterThanLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GreaterThanLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GreaterThanLayerParams, rhs: CoreML_Specification_GreaterThanLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GreaterEqualLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GreaterEqualLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GreaterEqualLayerParams, rhs: CoreML_Specification_GreaterEqualLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LessThanLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LessThanLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LessThanLayerParams, rhs: CoreML_Specification_LessThanLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LessEqualLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LessEqualLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LessEqualLayerParams, rhs: CoreML_Specification_LessEqualLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_EqualLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".EqualLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_EqualLayerParams, rhs: CoreML_Specification_EqualLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NotEqualLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NotEqualLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NotEqualLayerParams, rhs: CoreML_Specification_NotEqualLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LogicalAndLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LogicalAndLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LogicalAndLayerParams, rhs: CoreML_Specification_LogicalAndLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LogicalOrLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LogicalOrLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LogicalOrLayerParams, rhs: CoreML_Specification_LogicalOrLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LogicalXorLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LogicalXorLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LogicalXorLayerParams, rhs: CoreML_Specification_LogicalXorLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LogicalNotLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LogicalNotLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LogicalNotLayerParams, rhs: CoreML_Specification_LogicalNotLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BorderAmounts: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BorderAmounts"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "borderAmounts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try { try decoder.decodeRepeatedMessageField(value: &self.borderAmounts) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.borderAmounts.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.borderAmounts, fieldNumber: 10)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BorderAmounts, rhs: CoreML_Specification_BorderAmounts) -> Bool {
    if lhs.borderAmounts != rhs.borderAmounts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BorderAmounts.EdgeSizes: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_BorderAmounts.protoMessageName + ".EdgeSizes"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "startEdgeSize"),
    2: .same(proto: "endEdgeSize"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.startEdgeSize) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.endEdgeSize) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.startEdgeSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.startEdgeSize, fieldNumber: 1)
    }
    if self.endEdgeSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.endEdgeSize, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BorderAmounts.EdgeSizes, rhs: CoreML_Specification_BorderAmounts.EdgeSizes) -> Bool {
    if lhs.startEdgeSize != rhs.startEdgeSize {return false}
    if lhs.endEdgeSize != rhs.endEdgeSize {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ValidPadding: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ValidPadding"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "paddingAmounts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._paddingAmounts) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._paddingAmounts {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ValidPadding, rhs: CoreML_Specification_ValidPadding) -> Bool {
    if lhs._paddingAmounts != rhs._paddingAmounts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SamePadding: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SamePadding"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "asymmetryMode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.asymmetryMode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.asymmetryMode != .bottomRightHeavy {
      try visitor.visitSingularEnumField(value: self.asymmetryMode, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SamePadding, rhs: CoreML_Specification_SamePadding) -> Bool {
    if lhs.asymmetryMode != rhs.asymmetryMode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SamePadding.SamePaddingMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "BOTTOM_RIGHT_HEAVY"),
    1: .same(proto: "TOP_LEFT_HEAVY"),
  ]
}

extension CoreML_Specification_SamplingMode: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SamplingMode"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "samplingMethod"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.samplingMethod) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.samplingMethod != .strictAlignEndpointsMode {
      try visitor.visitSingularEnumField(value: self.samplingMethod, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SamplingMode, rhs: CoreML_Specification_SamplingMode) -> Bool {
    if lhs.samplingMethod != rhs.samplingMethod {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SamplingMode.Method: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "STRICT_ALIGN_ENDPOINTS_MODE"),
    1: .same(proto: "ALIGN_ENDPOINTS_MODE"),
    2: .same(proto: "UPSAMPLE_MODE"),
    3: .same(proto: "ROI_ALIGN_MODE"),
  ]
}

extension CoreML_Specification_BoxCoordinatesMode: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BoxCoordinatesMode"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "boxMode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.boxMode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.boxMode != .cornersHeightFirst {
      try visitor.visitSingularEnumField(value: self.boxMode, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BoxCoordinatesMode, rhs: CoreML_Specification_BoxCoordinatesMode) -> Bool {
    if lhs.boxMode != rhs.boxMode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BoxCoordinatesMode.Coordinates: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CORNERS_HEIGHT_FIRST"),
    1: .same(proto: "CORNERS_WIDTH_FIRST"),
    2: .same(proto: "CENTER_SIZE_HEIGHT_FIRST"),
    3: .same(proto: "CENTER_SIZE_WIDTH_FIRST"),
  ]
}

extension CoreML_Specification_WeightParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WeightParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "floatValue"),
    2: .same(proto: "float16Value"),
    30: .same(proto: "rawValue"),
    31: .same(proto: "int8RawValue"),
    40: .same(proto: "quantization"),
    50: .same(proto: "isUpdatable"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.floatValue) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.float16Value) }()
      case 30: try { try decoder.decodeSingularBytesField(value: &self.rawValue) }()
      case 31: try { try decoder.decodeSingularBytesField(value: &self.int8RawValue) }()
      case 40: try { try decoder.decodeSingularMessageField(value: &self._quantization) }()
      case 50: try { try decoder.decodeSingularBoolField(value: &self.isUpdatable) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.floatValue.isEmpty {
      try visitor.visitPackedFloatField(value: self.floatValue, fieldNumber: 1)
    }
    if !self.float16Value.isEmpty {
      try visitor.visitSingularBytesField(value: self.float16Value, fieldNumber: 2)
    }
    if !self.rawValue.isEmpty {
      try visitor.visitSingularBytesField(value: self.rawValue, fieldNumber: 30)
    }
    if !self.int8RawValue.isEmpty {
      try visitor.visitSingularBytesField(value: self.int8RawValue, fieldNumber: 31)
    }
    try { if let v = self._quantization {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 40)
    } }()
    if self.isUpdatable != false {
      try visitor.visitSingularBoolField(value: self.isUpdatable, fieldNumber: 50)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_WeightParams, rhs: CoreML_Specification_WeightParams) -> Bool {
    if lhs.floatValue != rhs.floatValue {return false}
    if lhs.float16Value != rhs.float16Value {return false}
    if lhs.rawValue != rhs.rawValue {return false}
    if lhs.int8RawValue != rhs.int8RawValue {return false}
    if lhs._quantization != rhs._quantization {return false}
    if lhs.isUpdatable != rhs.isUpdatable {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_QuantizationParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".QuantizationParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "numberOfBits"),
    101: .same(proto: "linearQuantization"),
    102: .same(proto: "lookupTableQuantization"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.numberOfBits) }()
      case 101: try {
        var v: CoreML_Specification_LinearQuantizationParams?
        var hadOneofValue = false
        if let current = self.quantizationType {
          hadOneofValue = true
          if case .linearQuantization(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.quantizationType = .linearQuantization(v)
        }
      }()
      case 102: try {
        var v: CoreML_Specification_LookUpTableQuantizationParams?
        var hadOneofValue = false
        if let current = self.quantizationType {
          hadOneofValue = true
          if case .lookupTableQuantization(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.quantizationType = .lookupTableQuantization(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.numberOfBits != 0 {
      try visitor.visitSingularUInt64Field(value: self.numberOfBits, fieldNumber: 1)
    }
    switch self.quantizationType {
    case .linearQuantization?: try {
      guard case .linearQuantization(let v)? = self.quantizationType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 101)
    }()
    case .lookupTableQuantization?: try {
      guard case .lookupTableQuantization(let v)? = self.quantizationType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 102)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_QuantizationParams, rhs: CoreML_Specification_QuantizationParams) -> Bool {
    if lhs.numberOfBits != rhs.numberOfBits {return false}
    if lhs.quantizationType != rhs.quantizationType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LinearQuantizationParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LinearQuantizationParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "scale"),
    2: .same(proto: "bias"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.scale) }()
      case 2: try { try decoder.decodeRepeatedFloatField(value: &self.bias) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.scale.isEmpty {
      try visitor.visitPackedFloatField(value: self.scale, fieldNumber: 1)
    }
    if !self.bias.isEmpty {
      try visitor.visitPackedFloatField(value: self.bias, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LinearQuantizationParams, rhs: CoreML_Specification_LinearQuantizationParams) -> Bool {
    if lhs.scale != rhs.scale {return false}
    if lhs.bias != rhs.bias {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LookUpTableQuantizationParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LookUpTableQuantizationParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "floatValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.floatValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.floatValue.isEmpty {
      try visitor.visitPackedFloatField(value: self.floatValue, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LookUpTableQuantizationParams, rhs: CoreML_Specification_LookUpTableQuantizationParams) -> Bool {
    if lhs.floatValue != rhs.floatValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ConvolutionLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConvolutionLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "outputChannels"),
    2: .same(proto: "kernelChannels"),
    10: .same(proto: "nGroups"),
    20: .same(proto: "kernelSize"),
    30: .same(proto: "stride"),
    40: .same(proto: "dilationFactor"),
    50: .same(proto: "valid"),
    51: .same(proto: "same"),
    60: .same(proto: "isDeconvolution"),
    70: .same(proto: "hasBias"),
    90: .same(proto: "weights"),
    91: .same(proto: "bias"),
    100: .same(proto: "outputShape"),
  ]

  fileprivate class _StorageClass {
    var _outputChannels: UInt64 = 0
    var _kernelChannels: UInt64 = 0
    var _nGroups: UInt64 = 0
    var _kernelSize: [UInt64] = []
    var _stride: [UInt64] = []
    var _dilationFactor: [UInt64] = []
    var _convolutionPaddingType: CoreML_Specification_ConvolutionLayerParams.OneOf_ConvolutionPaddingType?
    var _isDeconvolution: Bool = false
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil
    var _outputShape: [UInt64] = []

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _outputChannels = source._outputChannels
      _kernelChannels = source._kernelChannels
      _nGroups = source._nGroups
      _kernelSize = source._kernelSize
      _stride = source._stride
      _dilationFactor = source._dilationFactor
      _convolutionPaddingType = source._convolutionPaddingType
      _isDeconvolution = source._isDeconvolution
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
      _outputShape = source._outputShape
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._outputChannels) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._kernelChannels) }()
        case 10: try { try decoder.decodeSingularUInt64Field(value: &_storage._nGroups) }()
        case 20: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._kernelSize) }()
        case 30: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._stride) }()
        case 40: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._dilationFactor) }()
        case 50: try {
          var v: CoreML_Specification_ValidPadding?
          var hadOneofValue = false
          if let current = _storage._convolutionPaddingType {
            hadOneofValue = true
            if case .valid(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._convolutionPaddingType = .valid(v)
          }
        }()
        case 51: try {
          var v: CoreML_Specification_SamePadding?
          var hadOneofValue = false
          if let current = _storage._convolutionPaddingType {
            hadOneofValue = true
            if case .same(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._convolutionPaddingType = .same(v)
          }
        }()
        case 60: try { try decoder.decodeSingularBoolField(value: &_storage._isDeconvolution) }()
        case 70: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 90: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 91: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        case 100: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._outputShape) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._outputChannels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._outputChannels, fieldNumber: 1)
      }
      if _storage._kernelChannels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._kernelChannels, fieldNumber: 2)
      }
      if _storage._nGroups != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._nGroups, fieldNumber: 10)
      }
      if !_storage._kernelSize.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._kernelSize, fieldNumber: 20)
      }
      if !_storage._stride.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._stride, fieldNumber: 30)
      }
      if !_storage._dilationFactor.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._dilationFactor, fieldNumber: 40)
      }
      switch _storage._convolutionPaddingType {
      case .valid?: try {
        guard case .valid(let v)? = _storage._convolutionPaddingType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 50)
      }()
      case .same?: try {
        guard case .same(let v)? = _storage._convolutionPaddingType else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 51)
      }()
      case nil: break
      }
      if _storage._isDeconvolution != false {
        try visitor.visitSingularBoolField(value: _storage._isDeconvolution, fieldNumber: 60)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 70)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 90)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 91)
      } }()
      if !_storage._outputShape.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._outputShape, fieldNumber: 100)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ConvolutionLayerParams, rhs: CoreML_Specification_ConvolutionLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._outputChannels != rhs_storage._outputChannels {return false}
        if _storage._kernelChannels != rhs_storage._kernelChannels {return false}
        if _storage._nGroups != rhs_storage._nGroups {return false}
        if _storage._kernelSize != rhs_storage._kernelSize {return false}
        if _storage._stride != rhs_storage._stride {return false}
        if _storage._dilationFactor != rhs_storage._dilationFactor {return false}
        if _storage._convolutionPaddingType != rhs_storage._convolutionPaddingType {return false}
        if _storage._isDeconvolution != rhs_storage._isDeconvolution {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        if _storage._outputShape != rhs_storage._outputShape {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Convolution3DLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Convolution3DLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "outputChannels"),
    2: .same(proto: "inputChannels"),
    10: .same(proto: "nGroups"),
    20: .same(proto: "kernelDepth"),
    21: .same(proto: "kernelHeight"),
    22: .same(proto: "kernelWidth"),
    31: .same(proto: "strideDepth"),
    32: .same(proto: "strideHeight"),
    33: .same(proto: "strideWidth"),
    40: .same(proto: "dilationDepth"),
    41: .same(proto: "dilationHeight"),
    42: .same(proto: "dilationWidth"),
    50: .same(proto: "hasBias"),
    60: .same(proto: "weights"),
    61: .same(proto: "bias"),
    70: .same(proto: "paddingType"),
    80: .same(proto: "customPaddingFront"),
    81: .same(proto: "customPaddingBack"),
    82: .same(proto: "customPaddingTop"),
    83: .same(proto: "customPaddingBottom"),
    84: .same(proto: "customPaddingLeft"),
    85: .same(proto: "customPaddingRight"),
    86: .same(proto: "isDeconvolution"),
    87: .same(proto: "outputShape"),
  ]

  fileprivate class _StorageClass {
    var _outputChannels: Int32 = 0
    var _inputChannels: Int32 = 0
    var _nGroups: Int32 = 0
    var _kernelDepth: Int32 = 0
    var _kernelHeight: Int32 = 0
    var _kernelWidth: Int32 = 0
    var _strideDepth: Int32 = 0
    var _strideHeight: Int32 = 0
    var _strideWidth: Int32 = 0
    var _dilationDepth: Int32 = 0
    var _dilationHeight: Int32 = 0
    var _dilationWidth: Int32 = 0
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil
    var _paddingType: CoreML_Specification_Convolution3DLayerParams.PaddingType = .custom
    var _customPaddingFront: Int32 = 0
    var _customPaddingBack: Int32 = 0
    var _customPaddingTop: Int32 = 0
    var _customPaddingBottom: Int32 = 0
    var _customPaddingLeft: Int32 = 0
    var _customPaddingRight: Int32 = 0
    var _isDeconvolution: Bool = false
    var _outputShape: [UInt64] = []

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _outputChannels = source._outputChannels
      _inputChannels = source._inputChannels
      _nGroups = source._nGroups
      _kernelDepth = source._kernelDepth
      _kernelHeight = source._kernelHeight
      _kernelWidth = source._kernelWidth
      _strideDepth = source._strideDepth
      _strideHeight = source._strideHeight
      _strideWidth = source._strideWidth
      _dilationDepth = source._dilationDepth
      _dilationHeight = source._dilationHeight
      _dilationWidth = source._dilationWidth
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
      _paddingType = source._paddingType
      _customPaddingFront = source._customPaddingFront
      _customPaddingBack = source._customPaddingBack
      _customPaddingTop = source._customPaddingTop
      _customPaddingBottom = source._customPaddingBottom
      _customPaddingLeft = source._customPaddingLeft
      _customPaddingRight = source._customPaddingRight
      _isDeconvolution = source._isDeconvolution
      _outputShape = source._outputShape
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularInt32Field(value: &_storage._outputChannels) }()
        case 2: try { try decoder.decodeSingularInt32Field(value: &_storage._inputChannels) }()
        case 10: try { try decoder.decodeSingularInt32Field(value: &_storage._nGroups) }()
        case 20: try { try decoder.decodeSingularInt32Field(value: &_storage._kernelDepth) }()
        case 21: try { try decoder.decodeSingularInt32Field(value: &_storage._kernelHeight) }()
        case 22: try { try decoder.decodeSingularInt32Field(value: &_storage._kernelWidth) }()
        case 31: try { try decoder.decodeSingularInt32Field(value: &_storage._strideDepth) }()
        case 32: try { try decoder.decodeSingularInt32Field(value: &_storage._strideHeight) }()
        case 33: try { try decoder.decodeSingularInt32Field(value: &_storage._strideWidth) }()
        case 40: try { try decoder.decodeSingularInt32Field(value: &_storage._dilationDepth) }()
        case 41: try { try decoder.decodeSingularInt32Field(value: &_storage._dilationHeight) }()
        case 42: try { try decoder.decodeSingularInt32Field(value: &_storage._dilationWidth) }()
        case 50: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 60: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 61: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        case 70: try { try decoder.decodeSingularEnumField(value: &_storage._paddingType) }()
        case 80: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingFront) }()
        case 81: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingBack) }()
        case 82: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingTop) }()
        case 83: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingBottom) }()
        case 84: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingLeft) }()
        case 85: try { try decoder.decodeSingularInt32Field(value: &_storage._customPaddingRight) }()
        case 86: try { try decoder.decodeSingularBoolField(value: &_storage._isDeconvolution) }()
        case 87: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._outputShape) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._outputChannels != 0 {
        try visitor.visitSingularInt32Field(value: _storage._outputChannels, fieldNumber: 1)
      }
      if _storage._inputChannels != 0 {
        try visitor.visitSingularInt32Field(value: _storage._inputChannels, fieldNumber: 2)
      }
      if _storage._nGroups != 0 {
        try visitor.visitSingularInt32Field(value: _storage._nGroups, fieldNumber: 10)
      }
      if _storage._kernelDepth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._kernelDepth, fieldNumber: 20)
      }
      if _storage._kernelHeight != 0 {
        try visitor.visitSingularInt32Field(value: _storage._kernelHeight, fieldNumber: 21)
      }
      if _storage._kernelWidth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._kernelWidth, fieldNumber: 22)
      }
      if _storage._strideDepth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._strideDepth, fieldNumber: 31)
      }
      if _storage._strideHeight != 0 {
        try visitor.visitSingularInt32Field(value: _storage._strideHeight, fieldNumber: 32)
      }
      if _storage._strideWidth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._strideWidth, fieldNumber: 33)
      }
      if _storage._dilationDepth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._dilationDepth, fieldNumber: 40)
      }
      if _storage._dilationHeight != 0 {
        try visitor.visitSingularInt32Field(value: _storage._dilationHeight, fieldNumber: 41)
      }
      if _storage._dilationWidth != 0 {
        try visitor.visitSingularInt32Field(value: _storage._dilationWidth, fieldNumber: 42)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 50)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 60)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 61)
      } }()
      if _storage._paddingType != .custom {
        try visitor.visitSingularEnumField(value: _storage._paddingType, fieldNumber: 70)
      }
      if _storage._customPaddingFront != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingFront, fieldNumber: 80)
      }
      if _storage._customPaddingBack != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingBack, fieldNumber: 81)
      }
      if _storage._customPaddingTop != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingTop, fieldNumber: 82)
      }
      if _storage._customPaddingBottom != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingBottom, fieldNumber: 83)
      }
      if _storage._customPaddingLeft != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingLeft, fieldNumber: 84)
      }
      if _storage._customPaddingRight != 0 {
        try visitor.visitSingularInt32Field(value: _storage._customPaddingRight, fieldNumber: 85)
      }
      if _storage._isDeconvolution != false {
        try visitor.visitSingularBoolField(value: _storage._isDeconvolution, fieldNumber: 86)
      }
      if !_storage._outputShape.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._outputShape, fieldNumber: 87)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Convolution3DLayerParams, rhs: CoreML_Specification_Convolution3DLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._outputChannels != rhs_storage._outputChannels {return false}
        if _storage._inputChannels != rhs_storage._inputChannels {return false}
        if _storage._nGroups != rhs_storage._nGroups {return false}
        if _storage._kernelDepth != rhs_storage._kernelDepth {return false}
        if _storage._kernelHeight != rhs_storage._kernelHeight {return false}
        if _storage._kernelWidth != rhs_storage._kernelWidth {return false}
        if _storage._strideDepth != rhs_storage._strideDepth {return false}
        if _storage._strideHeight != rhs_storage._strideHeight {return false}
        if _storage._strideWidth != rhs_storage._strideWidth {return false}
        if _storage._dilationDepth != rhs_storage._dilationDepth {return false}
        if _storage._dilationHeight != rhs_storage._dilationHeight {return false}
        if _storage._dilationWidth != rhs_storage._dilationWidth {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        if _storage._paddingType != rhs_storage._paddingType {return false}
        if _storage._customPaddingFront != rhs_storage._customPaddingFront {return false}
        if _storage._customPaddingBack != rhs_storage._customPaddingBack {return false}
        if _storage._customPaddingTop != rhs_storage._customPaddingTop {return false}
        if _storage._customPaddingBottom != rhs_storage._customPaddingBottom {return false}
        if _storage._customPaddingLeft != rhs_storage._customPaddingLeft {return false}
        if _storage._customPaddingRight != rhs_storage._customPaddingRight {return false}
        if _storage._isDeconvolution != rhs_storage._isDeconvolution {return false}
        if _storage._outputShape != rhs_storage._outputShape {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Convolution3DLayerParams.PaddingType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CUSTOM"),
    1: .same(proto: "VALID"),
    2: .same(proto: "SAME"),
  ]
}

extension CoreML_Specification_InnerProductLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".InnerProductLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputChannels"),
    2: .same(proto: "outputChannels"),
    10: .same(proto: "hasBias"),
    20: .same(proto: "weights"),
    21: .same(proto: "bias"),
    22: .same(proto: "int8DynamicQuantize"),
  ]

  fileprivate class _StorageClass {
    var _inputChannels: UInt64 = 0
    var _outputChannels: UInt64 = 0
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil
    var _int8DynamicQuantize: Bool = false

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _inputChannels = source._inputChannels
      _outputChannels = source._outputChannels
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
      _int8DynamicQuantize = source._int8DynamicQuantize
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._inputChannels) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._outputChannels) }()
        case 10: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 20: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 21: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        case 22: try { try decoder.decodeSingularBoolField(value: &_storage._int8DynamicQuantize) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._inputChannels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._inputChannels, fieldNumber: 1)
      }
      if _storage._outputChannels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._outputChannels, fieldNumber: 2)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 10)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
      } }()
      if _storage._int8DynamicQuantize != false {
        try visitor.visitSingularBoolField(value: _storage._int8DynamicQuantize, fieldNumber: 22)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_InnerProductLayerParams, rhs: CoreML_Specification_InnerProductLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._inputChannels != rhs_storage._inputChannels {return false}
        if _storage._outputChannels != rhs_storage._outputChannels {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        if _storage._int8DynamicQuantize != rhs_storage._int8DynamicQuantize {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_EmbeddingLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".EmbeddingLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputDim"),
    2: .same(proto: "outputChannels"),
    10: .same(proto: "hasBias"),
    20: .same(proto: "weights"),
    21: .same(proto: "bias"),
  ]

  fileprivate class _StorageClass {
    var _inputDim: UInt64 = 0
    var _outputChannels: UInt64 = 0
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _inputDim = source._inputDim
      _outputChannels = source._outputChannels
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._inputDim) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._outputChannels) }()
        case 10: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 20: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 21: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._inputDim != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._inputDim, fieldNumber: 1)
      }
      if _storage._outputChannels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._outputChannels, fieldNumber: 2)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 10)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_EmbeddingLayerParams, rhs: CoreML_Specification_EmbeddingLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._inputDim != rhs_storage._inputDim {return false}
        if _storage._outputChannels != rhs_storage._outputChannels {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_EmbeddingNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".EmbeddingNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "vocabSize"),
    2: .same(proto: "embeddingSize"),
    3: .same(proto: "hasBias"),
    20: .same(proto: "weights"),
    21: .same(proto: "bias"),
  ]

  fileprivate class _StorageClass {
    var _vocabSize: UInt64 = 0
    var _embeddingSize: UInt64 = 0
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _vocabSize = source._vocabSize
      _embeddingSize = source._embeddingSize
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._vocabSize) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._embeddingSize) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 20: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 21: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._vocabSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._vocabSize, fieldNumber: 1)
      }
      if _storage._embeddingSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._embeddingSize, fieldNumber: 2)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 3)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_EmbeddingNDLayerParams, rhs: CoreML_Specification_EmbeddingNDLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._vocabSize != rhs_storage._vocabSize {return false}
        if _storage._embeddingSize != rhs_storage._embeddingSize {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BatchnormLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BatchnormLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "channels"),
    5: .same(proto: "computeMeanVar"),
    6: .same(proto: "instanceNormalization"),
    10: .same(proto: "epsilon"),
    15: .same(proto: "gamma"),
    16: .same(proto: "beta"),
    17: .same(proto: "mean"),
    18: .same(proto: "variance"),
  ]

  fileprivate class _StorageClass {
    var _channels: UInt64 = 0
    var _computeMeanVar: Bool = false
    var _instanceNormalization: Bool = false
    var _epsilon: Float = 0
    var _gamma: CoreML_Specification_WeightParams? = nil
    var _beta: CoreML_Specification_WeightParams? = nil
    var _mean: CoreML_Specification_WeightParams? = nil
    var _variance: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _channels = source._channels
      _computeMeanVar = source._computeMeanVar
      _instanceNormalization = source._instanceNormalization
      _epsilon = source._epsilon
      _gamma = source._gamma
      _beta = source._beta
      _mean = source._mean
      _variance = source._variance
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._channels) }()
        case 5: try { try decoder.decodeSingularBoolField(value: &_storage._computeMeanVar) }()
        case 6: try { try decoder.decodeSingularBoolField(value: &_storage._instanceNormalization) }()
        case 10: try { try decoder.decodeSingularFloatField(value: &_storage._epsilon) }()
        case 15: try { try decoder.decodeSingularMessageField(value: &_storage._gamma) }()
        case 16: try { try decoder.decodeSingularMessageField(value: &_storage._beta) }()
        case 17: try { try decoder.decodeSingularMessageField(value: &_storage._mean) }()
        case 18: try { try decoder.decodeSingularMessageField(value: &_storage._variance) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._channels != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._channels, fieldNumber: 1)
      }
      if _storage._computeMeanVar != false {
        try visitor.visitSingularBoolField(value: _storage._computeMeanVar, fieldNumber: 5)
      }
      if _storage._instanceNormalization != false {
        try visitor.visitSingularBoolField(value: _storage._instanceNormalization, fieldNumber: 6)
      }
      if _storage._epsilon != 0 {
        try visitor.visitSingularFloatField(value: _storage._epsilon, fieldNumber: 10)
      }
      try { if let v = _storage._gamma {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
      } }()
      try { if let v = _storage._beta {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 16)
      } }()
      try { if let v = _storage._mean {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 17)
      } }()
      try { if let v = _storage._variance {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 18)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BatchnormLayerParams, rhs: CoreML_Specification_BatchnormLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._channels != rhs_storage._channels {return false}
        if _storage._computeMeanVar != rhs_storage._computeMeanVar {return false}
        if _storage._instanceNormalization != rhs_storage._instanceNormalization {return false}
        if _storage._epsilon != rhs_storage._epsilon {return false}
        if _storage._gamma != rhs_storage._gamma {return false}
        if _storage._beta != rhs_storage._beta {return false}
        if _storage._mean != rhs_storage._mean {return false}
        if _storage._variance != rhs_storage._variance {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PoolingLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PoolingLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    10: .same(proto: "kernelSize"),
    20: .same(proto: "stride"),
    30: .same(proto: "valid"),
    31: .same(proto: "same"),
    32: .same(proto: "includeLastPixel"),
    50: .same(proto: "avgPoolExcludePadding"),
    60: .same(proto: "globalPooling"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 10: try { try decoder.decodeRepeatedUInt64Field(value: &self.kernelSize) }()
      case 20: try { try decoder.decodeRepeatedUInt64Field(value: &self.stride) }()
      case 30: try {
        var v: CoreML_Specification_ValidPadding?
        var hadOneofValue = false
        if let current = self.poolingPaddingType {
          hadOneofValue = true
          if case .valid(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.poolingPaddingType = .valid(v)
        }
      }()
      case 31: try {
        var v: CoreML_Specification_SamePadding?
        var hadOneofValue = false
        if let current = self.poolingPaddingType {
          hadOneofValue = true
          if case .same(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.poolingPaddingType = .same(v)
        }
      }()
      case 32: try {
        var v: CoreML_Specification_PoolingLayerParams.ValidCompletePadding?
        var hadOneofValue = false
        if let current = self.poolingPaddingType {
          hadOneofValue = true
          if case .includeLastPixel(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.poolingPaddingType = .includeLastPixel(v)
        }
      }()
      case 50: try { try decoder.decodeSingularBoolField(value: &self.avgPoolExcludePadding) }()
      case 60: try { try decoder.decodeSingularBoolField(value: &self.globalPooling) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.type != .max {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if !self.kernelSize.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.kernelSize, fieldNumber: 10)
    }
    if !self.stride.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.stride, fieldNumber: 20)
    }
    switch self.poolingPaddingType {
    case .valid?: try {
      guard case .valid(let v)? = self.poolingPaddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 30)
    }()
    case .same?: try {
      guard case .same(let v)? = self.poolingPaddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 31)
    }()
    case .includeLastPixel?: try {
      guard case .includeLastPixel(let v)? = self.poolingPaddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 32)
    }()
    case nil: break
    }
    if self.avgPoolExcludePadding != false {
      try visitor.visitSingularBoolField(value: self.avgPoolExcludePadding, fieldNumber: 50)
    }
    if self.globalPooling != false {
      try visitor.visitSingularBoolField(value: self.globalPooling, fieldNumber: 60)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PoolingLayerParams, rhs: CoreML_Specification_PoolingLayerParams) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.kernelSize != rhs.kernelSize {return false}
    if lhs.stride != rhs.stride {return false}
    if lhs.poolingPaddingType != rhs.poolingPaddingType {return false}
    if lhs.avgPoolExcludePadding != rhs.avgPoolExcludePadding {return false}
    if lhs.globalPooling != rhs.globalPooling {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PoolingLayerParams.PoolingType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "MAX"),
    1: .same(proto: "AVERAGE"),
    2: .same(proto: "L2"),
  ]
}

extension CoreML_Specification_PoolingLayerParams.ValidCompletePadding: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_PoolingLayerParams.protoMessageName + ".ValidCompletePadding"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "paddingAmounts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try { try decoder.decodeRepeatedUInt64Field(value: &self.paddingAmounts) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.paddingAmounts.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.paddingAmounts, fieldNumber: 10)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PoolingLayerParams.ValidCompletePadding, rhs: CoreML_Specification_PoolingLayerParams.ValidCompletePadding) -> Bool {
    if lhs.paddingAmounts != rhs.paddingAmounts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Pooling3DLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Pooling3DLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "kernelDepth"),
    3: .same(proto: "kernelHeight"),
    4: .same(proto: "kernelWidth"),
    5: .same(proto: "strideDepth"),
    6: .same(proto: "strideHeight"),
    7: .same(proto: "strideWidth"),
    15: .same(proto: "paddingType"),
    8: .same(proto: "customPaddingFront"),
    9: .same(proto: "customPaddingBack"),
    10: .same(proto: "customPaddingTop"),
    11: .same(proto: "customPaddingBottom"),
    12: .same(proto: "customPaddingLeft"),
    13: .same(proto: "customPaddingRight"),
    14: .same(proto: "countExcludePadding"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 2: try { try decoder.decodeSingularInt32Field(value: &self.kernelDepth) }()
      case 3: try { try decoder.decodeSingularInt32Field(value: &self.kernelHeight) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self.kernelWidth) }()
      case 5: try { try decoder.decodeSingularInt32Field(value: &self.strideDepth) }()
      case 6: try { try decoder.decodeSingularInt32Field(value: &self.strideHeight) }()
      case 7: try { try decoder.decodeSingularInt32Field(value: &self.strideWidth) }()
      case 8: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingFront) }()
      case 9: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingBack) }()
      case 10: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingTop) }()
      case 11: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingBottom) }()
      case 12: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingLeft) }()
      case 13: try { try decoder.decodeSingularInt32Field(value: &self.customPaddingRight) }()
      case 14: try { try decoder.decodeSingularBoolField(value: &self.countExcludePadding) }()
      case 15: try { try decoder.decodeSingularEnumField(value: &self.paddingType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .max {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if self.kernelDepth != 0 {
      try visitor.visitSingularInt32Field(value: self.kernelDepth, fieldNumber: 2)
    }
    if self.kernelHeight != 0 {
      try visitor.visitSingularInt32Field(value: self.kernelHeight, fieldNumber: 3)
    }
    if self.kernelWidth != 0 {
      try visitor.visitSingularInt32Field(value: self.kernelWidth, fieldNumber: 4)
    }
    if self.strideDepth != 0 {
      try visitor.visitSingularInt32Field(value: self.strideDepth, fieldNumber: 5)
    }
    if self.strideHeight != 0 {
      try visitor.visitSingularInt32Field(value: self.strideHeight, fieldNumber: 6)
    }
    if self.strideWidth != 0 {
      try visitor.visitSingularInt32Field(value: self.strideWidth, fieldNumber: 7)
    }
    if self.customPaddingFront != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingFront, fieldNumber: 8)
    }
    if self.customPaddingBack != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingBack, fieldNumber: 9)
    }
    if self.customPaddingTop != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingTop, fieldNumber: 10)
    }
    if self.customPaddingBottom != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingBottom, fieldNumber: 11)
    }
    if self.customPaddingLeft != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingLeft, fieldNumber: 12)
    }
    if self.customPaddingRight != 0 {
      try visitor.visitSingularInt32Field(value: self.customPaddingRight, fieldNumber: 13)
    }
    if self.countExcludePadding != false {
      try visitor.visitSingularBoolField(value: self.countExcludePadding, fieldNumber: 14)
    }
    if self.paddingType != .custom {
      try visitor.visitSingularEnumField(value: self.paddingType, fieldNumber: 15)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Pooling3DLayerParams, rhs: CoreML_Specification_Pooling3DLayerParams) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.kernelDepth != rhs.kernelDepth {return false}
    if lhs.kernelHeight != rhs.kernelHeight {return false}
    if lhs.kernelWidth != rhs.kernelWidth {return false}
    if lhs.strideDepth != rhs.strideDepth {return false}
    if lhs.strideHeight != rhs.strideHeight {return false}
    if lhs.strideWidth != rhs.strideWidth {return false}
    if lhs.paddingType != rhs.paddingType {return false}
    if lhs.customPaddingFront != rhs.customPaddingFront {return false}
    if lhs.customPaddingBack != rhs.customPaddingBack {return false}
    if lhs.customPaddingTop != rhs.customPaddingTop {return false}
    if lhs.customPaddingBottom != rhs.customPaddingBottom {return false}
    if lhs.customPaddingLeft != rhs.customPaddingLeft {return false}
    if lhs.customPaddingRight != rhs.customPaddingRight {return false}
    if lhs.countExcludePadding != rhs.countExcludePadding {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Pooling3DLayerParams.PoolingType3D: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "MAX"),
    1: .same(proto: "AVERAGE"),
  ]
}

extension CoreML_Specification_Pooling3DLayerParams.Pooling3DPaddingType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CUSTOM"),
    1: .same(proto: "VALID"),
    2: .same(proto: "SAME"),
  ]
}

extension CoreML_Specification_GlobalPooling3DLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GlobalPooling3DLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .max {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GlobalPooling3DLayerParams, rhs: CoreML_Specification_GlobalPooling3DLayerParams) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GlobalPooling3DLayerParams.GlobalPoolingType3D: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "MAX"),
    1: .same(proto: "AVERAGE"),
  ]
}

extension CoreML_Specification_PaddingLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PaddingLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "constant"),
    2: .same(proto: "reflection"),
    3: .same(proto: "replication"),
    10: .same(proto: "paddingAmounts"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: CoreML_Specification_PaddingLayerParams.PaddingConstant?
        var hadOneofValue = false
        if let current = self.paddingType {
          hadOneofValue = true
          if case .constant(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.paddingType = .constant(v)
        }
      }()
      case 2: try {
        var v: CoreML_Specification_PaddingLayerParams.PaddingReflection?
        var hadOneofValue = false
        if let current = self.paddingType {
          hadOneofValue = true
          if case .reflection(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.paddingType = .reflection(v)
        }
      }()
      case 3: try {
        var v: CoreML_Specification_PaddingLayerParams.PaddingReplication?
        var hadOneofValue = false
        if let current = self.paddingType {
          hadOneofValue = true
          if case .replication(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.paddingType = .replication(v)
        }
      }()
      case 10: try { try decoder.decodeSingularMessageField(value: &self._paddingAmounts) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.paddingType {
    case .constant?: try {
      guard case .constant(let v)? = self.paddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .reflection?: try {
      guard case .reflection(let v)? = self.paddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .replication?: try {
      guard case .replication(let v)? = self.paddingType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case nil: break
    }
    try { if let v = self._paddingAmounts {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PaddingLayerParams, rhs: CoreML_Specification_PaddingLayerParams) -> Bool {
    if lhs.paddingType != rhs.paddingType {return false}
    if lhs._paddingAmounts != rhs._paddingAmounts {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PaddingLayerParams.PaddingConstant: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_PaddingLayerParams.protoMessageName + ".PaddingConstant"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.value) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.value != 0 {
      try visitor.visitSingularFloatField(value: self.value, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PaddingLayerParams.PaddingConstant, rhs: CoreML_Specification_PaddingLayerParams.PaddingConstant) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PaddingLayerParams.PaddingReflection: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_PaddingLayerParams.protoMessageName + ".PaddingReflection"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PaddingLayerParams.PaddingReflection, rhs: CoreML_Specification_PaddingLayerParams.PaddingReflection) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PaddingLayerParams.PaddingReplication: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_PaddingLayerParams.protoMessageName + ".PaddingReplication"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PaddingLayerParams.PaddingReplication, rhs: CoreML_Specification_PaddingLayerParams.PaddingReplication) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ConcatLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConcatLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    100: .same(proto: "sequenceConcat"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 100: try { try decoder.decodeSingularBoolField(value: &self.sequenceConcat) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.sequenceConcat != false {
      try visitor.visitSingularBoolField(value: self.sequenceConcat, fieldNumber: 100)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ConcatLayerParams, rhs: CoreML_Specification_ConcatLayerParams) -> Bool {
    if lhs.sequenceConcat != rhs.sequenceConcat {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LRNLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LRNLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
    3: .same(proto: "localSize"),
    4: .same(proto: "k"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.beta) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.localSize) }()
      case 4: try { try decoder.decodeSingularFloatField(value: &self.k) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    if self.beta != 0 {
      try visitor.visitSingularFloatField(value: self.beta, fieldNumber: 2)
    }
    if self.localSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.localSize, fieldNumber: 3)
    }
    if self.k != 0 {
      try visitor.visitSingularFloatField(value: self.k, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LRNLayerParams, rhs: CoreML_Specification_LRNLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.beta != rhs.beta {return false}
    if lhs.localSize != rhs.localSize {return false}
    if lhs.k != rhs.k {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SoftmaxLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SoftmaxLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SoftmaxLayerParams, rhs: CoreML_Specification_SoftmaxLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SplitLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SplitLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "nOutputs"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.nOutputs) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.nOutputs != 0 {
      try visitor.visitSingularUInt64Field(value: self.nOutputs, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SplitLayerParams, rhs: CoreML_Specification_SplitLayerParams) -> Bool {
    if lhs.nOutputs != rhs.nOutputs {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AddLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AddLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AddLayerParams, rhs: CoreML_Specification_AddLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MultiplyLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MultiplyLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MultiplyLayerParams, rhs: CoreML_Specification_MultiplyLayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_UnaryFunctionLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UnaryFunctionLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "alpha"),
    3: .same(proto: "epsilon"),
    4: .same(proto: "shift"),
    5: .same(proto: "scale"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.type) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.epsilon) }()
      case 4: try { try decoder.decodeSingularFloatField(value: &self.shift) }()
      case 5: try { try decoder.decodeSingularFloatField(value: &self.scale) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.type != .sqrt {
      try visitor.visitSingularEnumField(value: self.type, fieldNumber: 1)
    }
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 2)
    }
    if self.epsilon != 0 {
      try visitor.visitSingularFloatField(value: self.epsilon, fieldNumber: 3)
    }
    if self.shift != 0 {
      try visitor.visitSingularFloatField(value: self.shift, fieldNumber: 4)
    }
    if self.scale != 0 {
      try visitor.visitSingularFloatField(value: self.scale, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_UnaryFunctionLayerParams, rhs: CoreML_Specification_UnaryFunctionLayerParams) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.alpha != rhs.alpha {return false}
    if lhs.epsilon != rhs.epsilon {return false}
    if lhs.shift != rhs.shift {return false}
    if lhs.scale != rhs.scale {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_UnaryFunctionLayerParams.Operation: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SQRT"),
    1: .same(proto: "RSQRT"),
    2: .same(proto: "INVERSE"),
    3: .same(proto: "POWER"),
    4: .same(proto: "EXP"),
    5: .same(proto: "LOG"),
    6: .same(proto: "ABS"),
    7: .same(proto: "THRESHOLD"),
  ]
}

extension CoreML_Specification_UpsampleLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UpsampleLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "scalingFactor"),
    7: .same(proto: "fractionalScalingFactor"),
    5: .same(proto: "mode"),
    6: .same(proto: "linearUpsampleMode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.scalingFactor) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.linearUpsampleMode) }()
      case 7: try { try decoder.decodeRepeatedFloatField(value: &self.fractionalScalingFactor) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.scalingFactor.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.scalingFactor, fieldNumber: 1)
    }
    if self.mode != .nn {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 5)
    }
    if self.linearUpsampleMode != .default {
      try visitor.visitSingularEnumField(value: self.linearUpsampleMode, fieldNumber: 6)
    }
    if !self.fractionalScalingFactor.isEmpty {
      try visitor.visitPackedFloatField(value: self.fractionalScalingFactor, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_UpsampleLayerParams, rhs: CoreML_Specification_UpsampleLayerParams) -> Bool {
    if lhs.scalingFactor != rhs.scalingFactor {return false}
    if lhs.fractionalScalingFactor != rhs.fractionalScalingFactor {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs.linearUpsampleMode != rhs.linearUpsampleMode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_UpsampleLayerParams.InterpolationMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "NN"),
    1: .same(proto: "BILINEAR"),
  ]
}

extension CoreML_Specification_UpsampleLayerParams.LinearUpsampleMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "DEFAULT"),
    1: .same(proto: "ALIGN_CORNERS_TRUE"),
    2: .same(proto: "ALIGN_CORNERS_FALSE"),
  ]
}

extension CoreML_Specification_ResizeBilinearLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ResizeBilinearLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetSize"),
    2: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.targetSize) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.targetSize.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.targetSize, fieldNumber: 1)
    }
    try { if let v = self._mode {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ResizeBilinearLayerParams, rhs: CoreML_Specification_ResizeBilinearLayerParams) -> Bool {
    if lhs.targetSize != rhs.targetSize {return false}
    if lhs._mode != rhs._mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CropResizeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CropResizeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetSize"),
    2: .same(proto: "normalizedCoordinates"),
    3: .same(proto: "mode"),
    4: .same(proto: "boxIndicesMode"),
    5: .same(proto: "spatialScale"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.targetSize) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.normalizedCoordinates) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._mode) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._boxIndicesMode) }()
      case 5: try { try decoder.decodeSingularFloatField(value: &self.spatialScale) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.targetSize.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.targetSize, fieldNumber: 1)
    }
    if self.normalizedCoordinates != false {
      try visitor.visitSingularBoolField(value: self.normalizedCoordinates, fieldNumber: 2)
    }
    try { if let v = self._mode {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._boxIndicesMode {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if self.spatialScale != 0 {
      try visitor.visitSingularFloatField(value: self.spatialScale, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CropResizeLayerParams, rhs: CoreML_Specification_CropResizeLayerParams) -> Bool {
    if lhs.targetSize != rhs.targetSize {return false}
    if lhs.normalizedCoordinates != rhs.normalizedCoordinates {return false}
    if lhs._mode != rhs._mode {return false}
    if lhs._boxIndicesMode != rhs._boxIndicesMode {return false}
    if lhs.spatialScale != rhs.spatialScale {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BiasLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BiasLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "shape"),
    2: .same(proto: "bias"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.shape) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._bias) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.shape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.shape, fieldNumber: 1)
    }
    try { if let v = self._bias {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BiasLayerParams, rhs: CoreML_Specification_BiasLayerParams) -> Bool {
    if lhs.shape != rhs.shape {return false}
    if lhs._bias != rhs._bias {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ScaleLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ScaleLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "shapeScale"),
    2: .same(proto: "scale"),
    3: .same(proto: "hasBias"),
    4: .same(proto: "shapeBias"),
    5: .same(proto: "bias"),
  ]

  fileprivate class _StorageClass {
    var _shapeScale: [UInt64] = []
    var _scale: CoreML_Specification_WeightParams? = nil
    var _hasBias_p: Bool = false
    var _shapeBias: [UInt64] = []
    var _bias: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _shapeScale = source._shapeScale
      _scale = source._scale
      _hasBias_p = source._hasBias_p
      _shapeBias = source._shapeBias
      _bias = source._bias
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._shapeScale) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._scale) }()
        case 3: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 4: try { try decoder.decodeRepeatedUInt64Field(value: &_storage._shapeBias) }()
        case 5: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._shapeScale.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._shapeScale, fieldNumber: 1)
      }
      try { if let v = _storage._scale {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 3)
      }
      if !_storage._shapeBias.isEmpty {
        try visitor.visitPackedUInt64Field(value: _storage._shapeBias, fieldNumber: 4)
      }
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ScaleLayerParams, rhs: CoreML_Specification_ScaleLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._shapeScale != rhs_storage._shapeScale {return false}
        if _storage._scale != rhs_storage._scale {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._shapeBias != rhs_storage._shapeBias {return false}
        if _storage._bias != rhs_storage._bias {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LoadConstantLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoadConstantLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "shape"),
    2: .same(proto: "data"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.shape) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._data) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.shape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.shape, fieldNumber: 1)
    }
    try { if let v = self._data {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LoadConstantLayerParams, rhs: CoreML_Specification_LoadConstantLayerParams) -> Bool {
    if lhs.shape != rhs.shape {return false}
    if lhs._data != rhs._data {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_L2NormalizeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".L2NormalizeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "epsilon"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.epsilon) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.epsilon != 0 {
      try visitor.visitSingularFloatField(value: self.epsilon, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_L2NormalizeLayerParams, rhs: CoreML_Specification_L2NormalizeLayerParams) -> Bool {
    if lhs.epsilon != rhs.epsilon {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FlattenLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FlattenLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.mode != .channelFirst {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FlattenLayerParams, rhs: CoreML_Specification_FlattenLayerParams) -> Bool {
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FlattenLayerParams.FlattenOrder: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CHANNEL_FIRST"),
    1: .same(proto: "CHANNEL_LAST"),
  ]
}

extension CoreML_Specification_ReshapeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReshapeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetShape"),
    2: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.targetShape) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.targetShape.isEmpty {
      try visitor.visitPackedInt64Field(value: self.targetShape, fieldNumber: 1)
    }
    if self.mode != .channelFirst {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReshapeLayerParams, rhs: CoreML_Specification_ReshapeLayerParams) -> Bool {
    if lhs.targetShape != rhs.targetShape {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReshapeLayerParams.ReshapeOrder: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CHANNEL_FIRST"),
    1: .same(proto: "CHANNEL_LAST"),
  ]
}

extension CoreML_Specification_PermuteLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PermuteLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axis.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PermuteLayerParams, rhs: CoreML_Specification_PermuteLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReorganizeDataLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReorganizeDataLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "mode"),
    2: .same(proto: "blockSize"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.blockSize) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.mode != .spaceToDepth {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 1)
    }
    if self.blockSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.blockSize, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReorganizeDataLayerParams, rhs: CoreML_Specification_ReorganizeDataLayerParams) -> Bool {
    if lhs.mode != rhs.mode {return false}
    if lhs.blockSize != rhs.blockSize {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReorganizeDataLayerParams.ReorganizationType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SPACE_TO_DEPTH"),
    1: .same(proto: "DEPTH_TO_SPACE"),
    2: .same(proto: "PIXEL_SHUFFLE"),
  ]
}

extension CoreML_Specification_SliceLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SliceLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "startIndex"),
    2: .same(proto: "endIndex"),
    3: .same(proto: "stride"),
    4: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.startIndex) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.endIndex) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.stride) }()
      case 4: try { try decoder.decodeSingularEnumField(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.startIndex != 0 {
      try visitor.visitSingularInt64Field(value: self.startIndex, fieldNumber: 1)
    }
    if self.endIndex != 0 {
      try visitor.visitSingularInt64Field(value: self.endIndex, fieldNumber: 2)
    }
    if self.stride != 0 {
      try visitor.visitSingularUInt64Field(value: self.stride, fieldNumber: 3)
    }
    if self.axis != .channelAxis {
      try visitor.visitSingularEnumField(value: self.axis, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SliceLayerParams, rhs: CoreML_Specification_SliceLayerParams) -> Bool {
    if lhs.startIndex != rhs.startIndex {return false}
    if lhs.endIndex != rhs.endIndex {return false}
    if lhs.stride != rhs.stride {return false}
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SliceLayerParams.SliceAxis: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CHANNEL_AXIS"),
    1: .same(proto: "HEIGHT_AXIS"),
    2: .same(proto: "WIDTH_AXIS"),
  ]
}

extension CoreML_Specification_ReduceLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "mode"),
    2: .same(proto: "epsilon"),
    3: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.epsilon) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.mode != .sum {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 1)
    }
    if self.epsilon != 0 {
      try visitor.visitSingularFloatField(value: self.epsilon, fieldNumber: 2)
    }
    if self.axis != .chw {
      try visitor.visitSingularEnumField(value: self.axis, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceLayerParams, rhs: CoreML_Specification_ReduceLayerParams) -> Bool {
    if lhs.mode != rhs.mode {return false}
    if lhs.epsilon != rhs.epsilon {return false}
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceLayerParams.ReduceOperation: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "SUM"),
    1: .same(proto: "AVG"),
    2: .same(proto: "PROD"),
    3: .same(proto: "LOGSUM"),
    4: .same(proto: "SUMSQUARE"),
    5: .same(proto: "L1"),
    6: .same(proto: "L2"),
    7: .same(proto: "MAX"),
    8: .same(proto: "MIN"),
    9: .same(proto: "ARGMAX"),
  ]
}

extension CoreML_Specification_ReduceLayerParams.ReduceAxis: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "CHW"),
    1: .same(proto: "HW"),
    2: .same(proto: "C"),
    3: .same(proto: "H"),
    4: .same(proto: "W"),
  ]
}

extension CoreML_Specification_CropLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CropLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "cropAmounts"),
    5: .same(proto: "offset"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._cropAmounts) }()
      case 5: try { try decoder.decodeRepeatedUInt64Field(value: &self.offset) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._cropAmounts {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    if !self.offset.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.offset, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CropLayerParams, rhs: CoreML_Specification_CropLayerParams) -> Bool {
    if lhs._cropAmounts != rhs._cropAmounts {return false}
    if lhs.offset != rhs.offset {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AverageLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AverageLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AverageLayerParams, rhs: CoreML_Specification_AverageLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MaxLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MaxLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MaxLayerParams, rhs: CoreML_Specification_MaxLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MinLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MinLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MinLayerParams, rhs: CoreML_Specification_MinLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_DotProductLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DotProductLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "cosineSimilarity"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.cosineSimilarity) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.cosineSimilarity != false {
      try visitor.visitSingularBoolField(value: self.cosineSimilarity, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_DotProductLayerParams, rhs: CoreML_Specification_DotProductLayerParams) -> Bool {
    if lhs.cosineSimilarity != rhs.cosineSimilarity {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MeanVarianceNormalizeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MeanVarianceNormalizeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "acrossChannels"),
    2: .same(proto: "normalizeVariance"),
    3: .same(proto: "epsilon"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.acrossChannels) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.normalizeVariance) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.epsilon) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.acrossChannels != false {
      try visitor.visitSingularBoolField(value: self.acrossChannels, fieldNumber: 1)
    }
    if self.normalizeVariance != false {
      try visitor.visitSingularBoolField(value: self.normalizeVariance, fieldNumber: 2)
    }
    if self.epsilon != 0 {
      try visitor.visitSingularFloatField(value: self.epsilon, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MeanVarianceNormalizeLayerParams, rhs: CoreML_Specification_MeanVarianceNormalizeLayerParams) -> Bool {
    if lhs.acrossChannels != rhs.acrossChannels {return false}
    if lhs.normalizeVariance != rhs.normalizeVariance {return false}
    if lhs.epsilon != rhs.epsilon {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SequenceRepeatLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SequenceRepeatLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "nRepetitions"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.nRepetitions) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.nRepetitions != 0 {
      try visitor.visitSingularUInt64Field(value: self.nRepetitions, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SequenceRepeatLayerParams, rhs: CoreML_Specification_SequenceRepeatLayerParams) -> Bool {
    if lhs.nRepetitions != rhs.nRepetitions {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SimpleRecurrentLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SimpleRecurrentLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputVectorSize"),
    2: .same(proto: "outputVectorSize"),
    10: .same(proto: "activation"),
    15: .same(proto: "sequenceOutput"),
    20: .same(proto: "hasBiasVector"),
    30: .same(proto: "weightMatrix"),
    31: .same(proto: "recursionMatrix"),
    32: .same(proto: "biasVector"),
    100: .same(proto: "reverseInput"),
  ]

  fileprivate class _StorageClass {
    var _inputVectorSize: UInt64 = 0
    var _outputVectorSize: UInt64 = 0
    var _activation: CoreML_Specification_ActivationParams? = nil
    var _sequenceOutput: Bool = false
    var _hasBiasVector_p: Bool = false
    var _weightMatrix: CoreML_Specification_WeightParams? = nil
    var _recursionMatrix: CoreML_Specification_WeightParams? = nil
    var _biasVector: CoreML_Specification_WeightParams? = nil
    var _reverseInput: Bool = false

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _inputVectorSize = source._inputVectorSize
      _outputVectorSize = source._outputVectorSize
      _activation = source._activation
      _sequenceOutput = source._sequenceOutput
      _hasBiasVector_p = source._hasBiasVector_p
      _weightMatrix = source._weightMatrix
      _recursionMatrix = source._recursionMatrix
      _biasVector = source._biasVector
      _reverseInput = source._reverseInput
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._inputVectorSize) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._outputVectorSize) }()
        case 10: try { try decoder.decodeSingularMessageField(value: &_storage._activation) }()
        case 15: try { try decoder.decodeSingularBoolField(value: &_storage._sequenceOutput) }()
        case 20: try { try decoder.decodeSingularBoolField(value: &_storage._hasBiasVector_p) }()
        case 30: try { try decoder.decodeSingularMessageField(value: &_storage._weightMatrix) }()
        case 31: try { try decoder.decodeSingularMessageField(value: &_storage._recursionMatrix) }()
        case 32: try { try decoder.decodeSingularMessageField(value: &_storage._biasVector) }()
        case 100: try { try decoder.decodeSingularBoolField(value: &_storage._reverseInput) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._inputVectorSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._inputVectorSize, fieldNumber: 1)
      }
      if _storage._outputVectorSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._outputVectorSize, fieldNumber: 2)
      }
      try { if let v = _storage._activation {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      } }()
      if _storage._sequenceOutput != false {
        try visitor.visitSingularBoolField(value: _storage._sequenceOutput, fieldNumber: 15)
      }
      if _storage._hasBiasVector_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBiasVector_p, fieldNumber: 20)
      }
      try { if let v = _storage._weightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 30)
      } }()
      try { if let v = _storage._recursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 31)
      } }()
      try { if let v = _storage._biasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 32)
      } }()
      if _storage._reverseInput != false {
        try visitor.visitSingularBoolField(value: _storage._reverseInput, fieldNumber: 100)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SimpleRecurrentLayerParams, rhs: CoreML_Specification_SimpleRecurrentLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._inputVectorSize != rhs_storage._inputVectorSize {return false}
        if _storage._outputVectorSize != rhs_storage._outputVectorSize {return false}
        if _storage._activation != rhs_storage._activation {return false}
        if _storage._sequenceOutput != rhs_storage._sequenceOutput {return false}
        if _storage._hasBiasVector_p != rhs_storage._hasBiasVector_p {return false}
        if _storage._weightMatrix != rhs_storage._weightMatrix {return false}
        if _storage._recursionMatrix != rhs_storage._recursionMatrix {return false}
        if _storage._biasVector != rhs_storage._biasVector {return false}
        if _storage._reverseInput != rhs_storage._reverseInput {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GRULayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GRULayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputVectorSize"),
    2: .same(proto: "outputVectorSize"),
    10: .same(proto: "activations"),
    15: .same(proto: "sequenceOutput"),
    20: .same(proto: "hasBiasVectors"),
    30: .same(proto: "updateGateWeightMatrix"),
    31: .same(proto: "resetGateWeightMatrix"),
    32: .same(proto: "outputGateWeightMatrix"),
    50: .same(proto: "updateGateRecursionMatrix"),
    51: .same(proto: "resetGateRecursionMatrix"),
    52: .same(proto: "outputGateRecursionMatrix"),
    70: .same(proto: "updateGateBiasVector"),
    71: .same(proto: "resetGateBiasVector"),
    72: .same(proto: "outputGateBiasVector"),
    100: .same(proto: "reverseInput"),
  ]

  fileprivate class _StorageClass {
    var _inputVectorSize: UInt64 = 0
    var _outputVectorSize: UInt64 = 0
    var _activations: [CoreML_Specification_ActivationParams] = []
    var _sequenceOutput: Bool = false
    var _hasBiasVectors_p: Bool = false
    var _updateGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _resetGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _outputGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _updateGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _resetGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _outputGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _updateGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _resetGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _outputGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _reverseInput: Bool = false

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _inputVectorSize = source._inputVectorSize
      _outputVectorSize = source._outputVectorSize
      _activations = source._activations
      _sequenceOutput = source._sequenceOutput
      _hasBiasVectors_p = source._hasBiasVectors_p
      _updateGateWeightMatrix = source._updateGateWeightMatrix
      _resetGateWeightMatrix = source._resetGateWeightMatrix
      _outputGateWeightMatrix = source._outputGateWeightMatrix
      _updateGateRecursionMatrix = source._updateGateRecursionMatrix
      _resetGateRecursionMatrix = source._resetGateRecursionMatrix
      _outputGateRecursionMatrix = source._outputGateRecursionMatrix
      _updateGateBiasVector = source._updateGateBiasVector
      _resetGateBiasVector = source._resetGateBiasVector
      _outputGateBiasVector = source._outputGateBiasVector
      _reverseInput = source._reverseInput
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularUInt64Field(value: &_storage._inputVectorSize) }()
        case 2: try { try decoder.decodeSingularUInt64Field(value: &_storage._outputVectorSize) }()
        case 10: try { try decoder.decodeRepeatedMessageField(value: &_storage._activations) }()
        case 15: try { try decoder.decodeSingularBoolField(value: &_storage._sequenceOutput) }()
        case 20: try { try decoder.decodeSingularBoolField(value: &_storage._hasBiasVectors_p) }()
        case 30: try { try decoder.decodeSingularMessageField(value: &_storage._updateGateWeightMatrix) }()
        case 31: try { try decoder.decodeSingularMessageField(value: &_storage._resetGateWeightMatrix) }()
        case 32: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateWeightMatrix) }()
        case 50: try { try decoder.decodeSingularMessageField(value: &_storage._updateGateRecursionMatrix) }()
        case 51: try { try decoder.decodeSingularMessageField(value: &_storage._resetGateRecursionMatrix) }()
        case 52: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateRecursionMatrix) }()
        case 70: try { try decoder.decodeSingularMessageField(value: &_storage._updateGateBiasVector) }()
        case 71: try { try decoder.decodeSingularMessageField(value: &_storage._resetGateBiasVector) }()
        case 72: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateBiasVector) }()
        case 100: try { try decoder.decodeSingularBoolField(value: &_storage._reverseInput) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._inputVectorSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._inputVectorSize, fieldNumber: 1)
      }
      if _storage._outputVectorSize != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._outputVectorSize, fieldNumber: 2)
      }
      if !_storage._activations.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._activations, fieldNumber: 10)
      }
      if _storage._sequenceOutput != false {
        try visitor.visitSingularBoolField(value: _storage._sequenceOutput, fieldNumber: 15)
      }
      if _storage._hasBiasVectors_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBiasVectors_p, fieldNumber: 20)
      }
      try { if let v = _storage._updateGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 30)
      } }()
      try { if let v = _storage._resetGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 31)
      } }()
      try { if let v = _storage._outputGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 32)
      } }()
      try { if let v = _storage._updateGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 50)
      } }()
      try { if let v = _storage._resetGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 51)
      } }()
      try { if let v = _storage._outputGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 52)
      } }()
      try { if let v = _storage._updateGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 70)
      } }()
      try { if let v = _storage._resetGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 71)
      } }()
      try { if let v = _storage._outputGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 72)
      } }()
      if _storage._reverseInput != false {
        try visitor.visitSingularBoolField(value: _storage._reverseInput, fieldNumber: 100)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GRULayerParams, rhs: CoreML_Specification_GRULayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._inputVectorSize != rhs_storage._inputVectorSize {return false}
        if _storage._outputVectorSize != rhs_storage._outputVectorSize {return false}
        if _storage._activations != rhs_storage._activations {return false}
        if _storage._sequenceOutput != rhs_storage._sequenceOutput {return false}
        if _storage._hasBiasVectors_p != rhs_storage._hasBiasVectors_p {return false}
        if _storage._updateGateWeightMatrix != rhs_storage._updateGateWeightMatrix {return false}
        if _storage._resetGateWeightMatrix != rhs_storage._resetGateWeightMatrix {return false}
        if _storage._outputGateWeightMatrix != rhs_storage._outputGateWeightMatrix {return false}
        if _storage._updateGateRecursionMatrix != rhs_storage._updateGateRecursionMatrix {return false}
        if _storage._resetGateRecursionMatrix != rhs_storage._resetGateRecursionMatrix {return false}
        if _storage._outputGateRecursionMatrix != rhs_storage._outputGateRecursionMatrix {return false}
        if _storage._updateGateBiasVector != rhs_storage._updateGateBiasVector {return false}
        if _storage._resetGateBiasVector != rhs_storage._resetGateBiasVector {return false}
        if _storage._outputGateBiasVector != rhs_storage._outputGateBiasVector {return false}
        if _storage._reverseInput != rhs_storage._reverseInput {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LSTMParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LSTMParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "sequenceOutput"),
    20: .same(proto: "hasBiasVectors"),
    30: .same(proto: "forgetBias"),
    40: .same(proto: "hasPeepholeVectors"),
    50: .same(proto: "coupledInputAndForgetGate"),
    60: .same(proto: "cellClipThreshold"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try { try decoder.decodeSingularBoolField(value: &self.sequenceOutput) }()
      case 20: try { try decoder.decodeSingularBoolField(value: &self.hasBiasVectors_p) }()
      case 30: try { try decoder.decodeSingularBoolField(value: &self.forgetBias) }()
      case 40: try { try decoder.decodeSingularBoolField(value: &self.hasPeepholeVectors_p) }()
      case 50: try { try decoder.decodeSingularBoolField(value: &self.coupledInputAndForgetGate) }()
      case 60: try { try decoder.decodeSingularFloatField(value: &self.cellClipThreshold) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.sequenceOutput != false {
      try visitor.visitSingularBoolField(value: self.sequenceOutput, fieldNumber: 10)
    }
    if self.hasBiasVectors_p != false {
      try visitor.visitSingularBoolField(value: self.hasBiasVectors_p, fieldNumber: 20)
    }
    if self.forgetBias != false {
      try visitor.visitSingularBoolField(value: self.forgetBias, fieldNumber: 30)
    }
    if self.hasPeepholeVectors_p != false {
      try visitor.visitSingularBoolField(value: self.hasPeepholeVectors_p, fieldNumber: 40)
    }
    if self.coupledInputAndForgetGate != false {
      try visitor.visitSingularBoolField(value: self.coupledInputAndForgetGate, fieldNumber: 50)
    }
    if self.cellClipThreshold != 0 {
      try visitor.visitSingularFloatField(value: self.cellClipThreshold, fieldNumber: 60)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LSTMParams, rhs: CoreML_Specification_LSTMParams) -> Bool {
    if lhs.sequenceOutput != rhs.sequenceOutput {return false}
    if lhs.hasBiasVectors_p != rhs.hasBiasVectors_p {return false}
    if lhs.forgetBias != rhs.forgetBias {return false}
    if lhs.hasPeepholeVectors_p != rhs.hasPeepholeVectors_p {return false}
    if lhs.coupledInputAndForgetGate != rhs.coupledInputAndForgetGate {return false}
    if lhs.cellClipThreshold != rhs.cellClipThreshold {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LSTMWeightParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LSTMWeightParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputGateWeightMatrix"),
    2: .same(proto: "forgetGateWeightMatrix"),
    3: .same(proto: "blockInputWeightMatrix"),
    4: .same(proto: "outputGateWeightMatrix"),
    20: .same(proto: "inputGateRecursionMatrix"),
    21: .same(proto: "forgetGateRecursionMatrix"),
    22: .same(proto: "blockInputRecursionMatrix"),
    23: .same(proto: "outputGateRecursionMatrix"),
    40: .same(proto: "inputGateBiasVector"),
    41: .same(proto: "forgetGateBiasVector"),
    42: .same(proto: "blockInputBiasVector"),
    43: .same(proto: "outputGateBiasVector"),
    60: .same(proto: "inputGatePeepholeVector"),
    61: .same(proto: "forgetGatePeepholeVector"),
    62: .same(proto: "outputGatePeepholeVector"),
  ]

  fileprivate class _StorageClass {
    var _inputGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _forgetGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _blockInputWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _outputGateWeightMatrix: CoreML_Specification_WeightParams? = nil
    var _inputGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _forgetGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _blockInputRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _outputGateRecursionMatrix: CoreML_Specification_WeightParams? = nil
    var _inputGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _forgetGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _blockInputBiasVector: CoreML_Specification_WeightParams? = nil
    var _outputGateBiasVector: CoreML_Specification_WeightParams? = nil
    var _inputGatePeepholeVector: CoreML_Specification_WeightParams? = nil
    var _forgetGatePeepholeVector: CoreML_Specification_WeightParams? = nil
    var _outputGatePeepholeVector: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _inputGateWeightMatrix = source._inputGateWeightMatrix
      _forgetGateWeightMatrix = source._forgetGateWeightMatrix
      _blockInputWeightMatrix = source._blockInputWeightMatrix
      _outputGateWeightMatrix = source._outputGateWeightMatrix
      _inputGateRecursionMatrix = source._inputGateRecursionMatrix
      _forgetGateRecursionMatrix = source._forgetGateRecursionMatrix
      _blockInputRecursionMatrix = source._blockInputRecursionMatrix
      _outputGateRecursionMatrix = source._outputGateRecursionMatrix
      _inputGateBiasVector = source._inputGateBiasVector
      _forgetGateBiasVector = source._forgetGateBiasVector
      _blockInputBiasVector = source._blockInputBiasVector
      _outputGateBiasVector = source._outputGateBiasVector
      _inputGatePeepholeVector = source._inputGatePeepholeVector
      _forgetGatePeepholeVector = source._forgetGatePeepholeVector
      _outputGatePeepholeVector = source._outputGatePeepholeVector
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._inputGateWeightMatrix) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._forgetGateWeightMatrix) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._blockInputWeightMatrix) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateWeightMatrix) }()
        case 20: try { try decoder.decodeSingularMessageField(value: &_storage._inputGateRecursionMatrix) }()
        case 21: try { try decoder.decodeSingularMessageField(value: &_storage._forgetGateRecursionMatrix) }()
        case 22: try { try decoder.decodeSingularMessageField(value: &_storage._blockInputRecursionMatrix) }()
        case 23: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateRecursionMatrix) }()
        case 40: try { try decoder.decodeSingularMessageField(value: &_storage._inputGateBiasVector) }()
        case 41: try { try decoder.decodeSingularMessageField(value: &_storage._forgetGateBiasVector) }()
        case 42: try { try decoder.decodeSingularMessageField(value: &_storage._blockInputBiasVector) }()
        case 43: try { try decoder.decodeSingularMessageField(value: &_storage._outputGateBiasVector) }()
        case 60: try { try decoder.decodeSingularMessageField(value: &_storage._inputGatePeepholeVector) }()
        case 61: try { try decoder.decodeSingularMessageField(value: &_storage._forgetGatePeepholeVector) }()
        case 62: try { try decoder.decodeSingularMessageField(value: &_storage._outputGatePeepholeVector) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._inputGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._forgetGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._blockInputWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._outputGateWeightMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
      try { if let v = _storage._inputGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      } }()
      try { if let v = _storage._forgetGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 21)
      } }()
      try { if let v = _storage._blockInputRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 22)
      } }()
      try { if let v = _storage._outputGateRecursionMatrix {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 23)
      } }()
      try { if let v = _storage._inputGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 40)
      } }()
      try { if let v = _storage._forgetGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 41)
      } }()
      try { if let v = _storage._blockInputBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 42)
      } }()
      try { if let v = _storage._outputGateBiasVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 43)
      } }()
      try { if let v = _storage._inputGatePeepholeVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 60)
      } }()
      try { if let v = _storage._forgetGatePeepholeVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 61)
      } }()
      try { if let v = _storage._outputGatePeepholeVector {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 62)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LSTMWeightParams, rhs: CoreML_Specification_LSTMWeightParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._inputGateWeightMatrix != rhs_storage._inputGateWeightMatrix {return false}
        if _storage._forgetGateWeightMatrix != rhs_storage._forgetGateWeightMatrix {return false}
        if _storage._blockInputWeightMatrix != rhs_storage._blockInputWeightMatrix {return false}
        if _storage._outputGateWeightMatrix != rhs_storage._outputGateWeightMatrix {return false}
        if _storage._inputGateRecursionMatrix != rhs_storage._inputGateRecursionMatrix {return false}
        if _storage._forgetGateRecursionMatrix != rhs_storage._forgetGateRecursionMatrix {return false}
        if _storage._blockInputRecursionMatrix != rhs_storage._blockInputRecursionMatrix {return false}
        if _storage._outputGateRecursionMatrix != rhs_storage._outputGateRecursionMatrix {return false}
        if _storage._inputGateBiasVector != rhs_storage._inputGateBiasVector {return false}
        if _storage._forgetGateBiasVector != rhs_storage._forgetGateBiasVector {return false}
        if _storage._blockInputBiasVector != rhs_storage._blockInputBiasVector {return false}
        if _storage._outputGateBiasVector != rhs_storage._outputGateBiasVector {return false}
        if _storage._inputGatePeepholeVector != rhs_storage._inputGatePeepholeVector {return false}
        if _storage._forgetGatePeepholeVector != rhs_storage._forgetGatePeepholeVector {return false}
        if _storage._outputGatePeepholeVector != rhs_storage._outputGatePeepholeVector {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_UniDirectionalLSTMLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UniDirectionalLSTMLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputVectorSize"),
    2: .same(proto: "outputVectorSize"),
    10: .same(proto: "activations"),
    15: .same(proto: "params"),
    20: .same(proto: "weightParams"),
    100: .same(proto: "reverseInput"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.inputVectorSize) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.outputVectorSize) }()
      case 10: try { try decoder.decodeRepeatedMessageField(value: &self.activations) }()
      case 15: try { try decoder.decodeSingularMessageField(value: &self._params) }()
      case 20: try { try decoder.decodeSingularMessageField(value: &self._weightParams) }()
      case 100: try { try decoder.decodeSingularBoolField(value: &self.reverseInput) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.inputVectorSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.inputVectorSize, fieldNumber: 1)
    }
    if self.outputVectorSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.outputVectorSize, fieldNumber: 2)
    }
    if !self.activations.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.activations, fieldNumber: 10)
    }
    try { if let v = self._params {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
    } }()
    try { if let v = self._weightParams {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
    } }()
    if self.reverseInput != false {
      try visitor.visitSingularBoolField(value: self.reverseInput, fieldNumber: 100)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_UniDirectionalLSTMLayerParams, rhs: CoreML_Specification_UniDirectionalLSTMLayerParams) -> Bool {
    if lhs.inputVectorSize != rhs.inputVectorSize {return false}
    if lhs.outputVectorSize != rhs.outputVectorSize {return false}
    if lhs.activations != rhs.activations {return false}
    if lhs._params != rhs._params {return false}
    if lhs._weightParams != rhs._weightParams {return false}
    if lhs.reverseInput != rhs.reverseInput {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BiDirectionalLSTMLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BiDirectionalLSTMLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputVectorSize"),
    2: .same(proto: "outputVectorSize"),
    10: .same(proto: "activationsForwardLSTM"),
    11: .same(proto: "activationsBackwardLSTM"),
    15: .same(proto: "params"),
    20: .same(proto: "weightParams"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.inputVectorSize) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.outputVectorSize) }()
      case 10: try { try decoder.decodeRepeatedMessageField(value: &self.activationsForwardLstm) }()
      case 11: try { try decoder.decodeRepeatedMessageField(value: &self.activationsBackwardLstm) }()
      case 15: try { try decoder.decodeSingularMessageField(value: &self._params) }()
      case 20: try { try decoder.decodeRepeatedMessageField(value: &self.weightParams) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if self.inputVectorSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.inputVectorSize, fieldNumber: 1)
    }
    if self.outputVectorSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.outputVectorSize, fieldNumber: 2)
    }
    if !self.activationsForwardLstm.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.activationsForwardLstm, fieldNumber: 10)
    }
    if !self.activationsBackwardLstm.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.activationsBackwardLstm, fieldNumber: 11)
    }
    try { if let v = self._params {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 15)
    } }()
    if !self.weightParams.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.weightParams, fieldNumber: 20)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BiDirectionalLSTMLayerParams, rhs: CoreML_Specification_BiDirectionalLSTMLayerParams) -> Bool {
    if lhs.inputVectorSize != rhs.inputVectorSize {return false}
    if lhs.outputVectorSize != rhs.outputVectorSize {return false}
    if lhs.activationsForwardLstm != rhs.activationsForwardLstm {return false}
    if lhs.activationsBackwardLstm != rhs.activationsBackwardLstm {return false}
    if lhs._params != rhs._params {return false}
    if lhs.weightParams != rhs.weightParams {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CustomLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CustomLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "className"),
    20: .same(proto: "weights"),
    30: .same(proto: "parameters"),
    40: .same(proto: "description"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try { try decoder.decodeSingularStringField(value: &self.className) }()
      case 20: try { try decoder.decodeRepeatedMessageField(value: &self.weights) }()
      case 30: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_CustomLayerParams.CustomLayerParamValue>.self, value: &self.parameters) }()
      case 40: try { try decoder.decodeSingularStringField(value: &self.description_p) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.className.isEmpty {
      try visitor.visitSingularStringField(value: self.className, fieldNumber: 10)
    }
    if !self.weights.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.weights, fieldNumber: 20)
    }
    if !self.parameters.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_CustomLayerParams.CustomLayerParamValue>.self, value: self.parameters, fieldNumber: 30)
    }
    if !self.description_p.isEmpty {
      try visitor.visitSingularStringField(value: self.description_p, fieldNumber: 40)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CustomLayerParams, rhs: CoreML_Specification_CustomLayerParams) -> Bool {
    if lhs.className != rhs.className {return false}
    if lhs.weights != rhs.weights {return false}
    if lhs.parameters != rhs.parameters {return false}
    if lhs.description_p != rhs.description_p {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CustomLayerParams.CustomLayerParamValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_CustomLayerParams.protoMessageName + ".CustomLayerParamValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "doubleValue"),
    20: .same(proto: "stringValue"),
    30: .same(proto: "intValue"),
    40: .same(proto: "longValue"),
    50: .same(proto: "boolValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try {
        var v: Double?
        try decoder.decodeSingularDoubleField(value: &v)
        if let v = v {
          if self.value != nil {try decoder.handleConflictingOneOf()}
          self.value = .doubleValue(v)
        }
      }()
      case 20: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.value != nil {try decoder.handleConflictingOneOf()}
          self.value = .stringValue(v)
        }
      }()
      case 30: try {
        var v: Int32?
        try decoder.decodeSingularInt32Field(value: &v)
        if let v = v {
          if self.value != nil {try decoder.handleConflictingOneOf()}
          self.value = .intValue(v)
        }
      }()
      case 40: try {
        var v: Int64?
        try decoder.decodeSingularInt64Field(value: &v)
        if let v = v {
          if self.value != nil {try decoder.handleConflictingOneOf()}
          self.value = .longValue(v)
        }
      }()
      case 50: try {
        var v: Bool?
        try decoder.decodeSingularBoolField(value: &v)
        if let v = v {
          if self.value != nil {try decoder.handleConflictingOneOf()}
          self.value = .boolValue(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.value {
    case .doubleValue?: try {
      guard case .doubleValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularDoubleField(value: v, fieldNumber: 10)
    }()
    case .stringValue?: try {
      guard case .stringValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 20)
    }()
    case .intValue?: try {
      guard case .intValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 30)
    }()
    case .longValue?: try {
      guard case .longValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularInt64Field(value: v, fieldNumber: 40)
    }()
    case .boolValue?: try {
      guard case .boolValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularBoolField(value: v, fieldNumber: 50)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CustomLayerParams.CustomLayerParamValue, rhs: CoreML_Specification_CustomLayerParams.CustomLayerParamValue) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_TransposeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TransposeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.axes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.axes, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_TransposeLayerParams, rhs: CoreML_Specification_TransposeLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BatchedMatMulLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BatchedMatMulLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "transposeA"),
    2: .same(proto: "transposeB"),
    5: .same(proto: "weightMatrixFirstDimension"),
    6: .same(proto: "weightMatrixSecondDimension"),
    7: .same(proto: "hasBias"),
    8: .same(proto: "weights"),
    9: .same(proto: "bias"),
    10: .same(proto: "int8DynamicQuantize"),
  ]

  fileprivate class _StorageClass {
    var _transposeA: Bool = false
    var _transposeB: Bool = false
    var _weightMatrixFirstDimension: UInt64 = 0
    var _weightMatrixSecondDimension: UInt64 = 0
    var _hasBias_p: Bool = false
    var _weights: CoreML_Specification_WeightParams? = nil
    var _bias: CoreML_Specification_WeightParams? = nil
    var _int8DynamicQuantize: Bool = false

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _transposeA = source._transposeA
      _transposeB = source._transposeB
      _weightMatrixFirstDimension = source._weightMatrixFirstDimension
      _weightMatrixSecondDimension = source._weightMatrixSecondDimension
      _hasBias_p = source._hasBias_p
      _weights = source._weights
      _bias = source._bias
      _int8DynamicQuantize = source._int8DynamicQuantize
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularBoolField(value: &_storage._transposeA) }()
        case 2: try { try decoder.decodeSingularBoolField(value: &_storage._transposeB) }()
        case 5: try { try decoder.decodeSingularUInt64Field(value: &_storage._weightMatrixFirstDimension) }()
        case 6: try { try decoder.decodeSingularUInt64Field(value: &_storage._weightMatrixSecondDimension) }()
        case 7: try { try decoder.decodeSingularBoolField(value: &_storage._hasBias_p) }()
        case 8: try { try decoder.decodeSingularMessageField(value: &_storage._weights) }()
        case 9: try { try decoder.decodeSingularMessageField(value: &_storage._bias) }()
        case 10: try { try decoder.decodeSingularBoolField(value: &_storage._int8DynamicQuantize) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._transposeA != false {
        try visitor.visitSingularBoolField(value: _storage._transposeA, fieldNumber: 1)
      }
      if _storage._transposeB != false {
        try visitor.visitSingularBoolField(value: _storage._transposeB, fieldNumber: 2)
      }
      if _storage._weightMatrixFirstDimension != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._weightMatrixFirstDimension, fieldNumber: 5)
      }
      if _storage._weightMatrixSecondDimension != 0 {
        try visitor.visitSingularUInt64Field(value: _storage._weightMatrixSecondDimension, fieldNumber: 6)
      }
      if _storage._hasBias_p != false {
        try visitor.visitSingularBoolField(value: _storage._hasBias_p, fieldNumber: 7)
      }
      try { if let v = _storage._weights {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 8)
      } }()
      try { if let v = _storage._bias {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 9)
      } }()
      if _storage._int8DynamicQuantize != false {
        try visitor.visitSingularBoolField(value: _storage._int8DynamicQuantize, fieldNumber: 10)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BatchedMatMulLayerParams, rhs: CoreML_Specification_BatchedMatMulLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._transposeA != rhs_storage._transposeA {return false}
        if _storage._transposeB != rhs_storage._transposeB {return false}
        if _storage._weightMatrixFirstDimension != rhs_storage._weightMatrixFirstDimension {return false}
        if _storage._weightMatrixSecondDimension != rhs_storage._weightMatrixSecondDimension {return false}
        if _storage._hasBias_p != rhs_storage._hasBias_p {return false}
        if _storage._weights != rhs_storage._weights {return false}
        if _storage._bias != rhs_storage._bias {return false}
        if _storage._int8DynamicQuantize != rhs_storage._int8DynamicQuantize {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ConcatNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConcatNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "interleave"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.interleave) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.interleave != false {
      try visitor.visitSingularBoolField(value: self.interleave, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ConcatNDLayerParams, rhs: CoreML_Specification_ConcatNDLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.interleave != rhs.interleave {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SoftmaxNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SoftmaxNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SoftmaxNDLayerParams, rhs: CoreML_Specification_SoftmaxNDLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReverseLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReverseLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "reverseDim"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedBoolField(value: &self.reverseDim) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.reverseDim.isEmpty {
      try visitor.visitPackedBoolField(value: self.reverseDim, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReverseLayerParams, rhs: CoreML_Specification_ReverseLayerParams) -> Bool {
    if lhs.reverseDim != rhs.reverseDim {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReverseSeqLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReverseSeqLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "batchAxis"),
    2: .same(proto: "sequenceAxis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.batchAxis) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.sequenceAxis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.batchAxis != 0 {
      try visitor.visitSingularInt64Field(value: self.batchAxis, fieldNumber: 1)
    }
    if self.sequenceAxis != 0 {
      try visitor.visitSingularInt64Field(value: self.sequenceAxis, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReverseSeqLayerParams, rhs: CoreML_Specification_ReverseSeqLayerParams) -> Bool {
    if lhs.batchAxis != rhs.batchAxis {return false}
    if lhs.sequenceAxis != rhs.sequenceAxis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LoadConstantNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LoadConstantNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "shape"),
    2: .same(proto: "data"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.shape) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._data) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.shape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.shape, fieldNumber: 1)
    }
    try { if let v = self._data {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LoadConstantNDLayerParams, rhs: CoreML_Specification_LoadConstantNDLayerParams) -> Bool {
    if lhs.shape != rhs.shape {return false}
    if lhs._data != rhs._data {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FillLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FillLikeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.value) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.value != 0 {
      try visitor.visitSingularFloatField(value: self.value, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FillLikeLayerParams, rhs: CoreML_Specification_FillLikeLayerParams) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FillStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FillStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "value"),
    2: .same(proto: "targetShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.value) }()
      case 2: try { try decoder.decodeRepeatedUInt64Field(value: &self.targetShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.value != 0 {
      try visitor.visitSingularFloatField(value: self.value, fieldNumber: 1)
    }
    if !self.targetShape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.targetShape, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FillStaticLayerParams, rhs: CoreML_Specification_FillStaticLayerParams) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.targetShape != rhs.targetShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FillDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FillDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.value) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.value != 0 {
      try visitor.visitSingularFloatField(value: self.value, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FillDynamicLayerParams, rhs: CoreML_Specification_FillDynamicLayerParams) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_WhereBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WhereBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_WhereBroadcastableLayerParams, rhs: CoreML_Specification_WhereBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SinLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SinLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SinLayerParams, rhs: CoreML_Specification_SinLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CosLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CosLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CosLayerParams, rhs: CoreML_Specification_CosLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_TanLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TanLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_TanLayerParams, rhs: CoreML_Specification_TanLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AsinLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AsinLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AsinLayerParams, rhs: CoreML_Specification_AsinLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AcosLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AcosLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AcosLayerParams, rhs: CoreML_Specification_AcosLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AtanLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AtanLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AtanLayerParams, rhs: CoreML_Specification_AtanLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SinhLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SinhLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SinhLayerParams, rhs: CoreML_Specification_SinhLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CoshLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CoshLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CoshLayerParams, rhs: CoreML_Specification_CoshLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_TanhLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TanhLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_TanhLayerParams, rhs: CoreML_Specification_TanhLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AsinhLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AsinhLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AsinhLayerParams, rhs: CoreML_Specification_AsinhLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AcoshLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AcoshLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AcoshLayerParams, rhs: CoreML_Specification_AcoshLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AtanhLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AtanhLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AtanhLayerParams, rhs: CoreML_Specification_AtanhLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PowBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PowBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PowBroadcastableLayerParams, rhs: CoreML_Specification_PowBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Exp2LayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Exp2LayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Exp2LayerParams, rhs: CoreML_Specification_Exp2LayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_WhereNonZeroLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".WhereNonZeroLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_WhereNonZeroLayerParams, rhs: CoreML_Specification_WhereNonZeroLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MatrixBandPartLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MatrixBandPartLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "numLower"),
    2: .same(proto: "numUpper"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.numLower) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.numUpper) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.numLower != 0 {
      try visitor.visitSingularInt64Field(value: self.numLower, fieldNumber: 1)
    }
    if self.numUpper != 0 {
      try visitor.visitSingularInt64Field(value: self.numUpper, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MatrixBandPartLayerParams, rhs: CoreML_Specification_MatrixBandPartLayerParams) -> Bool {
    if lhs.numLower != rhs.numLower {return false}
    if lhs.numUpper != rhs.numUpper {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_UpperTriangularLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".UpperTriangularLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "k"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.k) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.k != 0 {
      try visitor.visitSingularInt64Field(value: self.k, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_UpperTriangularLayerParams, rhs: CoreML_Specification_UpperTriangularLayerParams) -> Bool {
    if lhs.k != rhs.k {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LowerTriangularLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LowerTriangularLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "k"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.k) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.k != 0 {
      try visitor.visitSingularInt64Field(value: self.k, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LowerTriangularLayerParams, rhs: CoreML_Specification_LowerTriangularLayerParams) -> Bool {
    if lhs.k != rhs.k {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BroadcastToLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BroadcastToLikeLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BroadcastToLikeLayerParams, rhs: CoreML_Specification_BroadcastToLikeLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BroadcastToStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BroadcastToStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.targetShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.targetShape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.targetShape, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BroadcastToStaticLayerParams, rhs: CoreML_Specification_BroadcastToStaticLayerParams) -> Bool {
    if lhs.targetShape != rhs.targetShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_BroadcastToDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".BroadcastToDynamicLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_BroadcastToDynamicLayerParams, rhs: CoreML_Specification_BroadcastToDynamicLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AddBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AddBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AddBroadcastableLayerParams, rhs: CoreML_Specification_AddBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MaxBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MaxBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MaxBroadcastableLayerParams, rhs: CoreML_Specification_MaxBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MinBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MinBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MinBroadcastableLayerParams, rhs: CoreML_Specification_MinBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ModBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ModBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ModBroadcastableLayerParams, rhs: CoreML_Specification_ModBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FloorDivBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FloorDivBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FloorDivBroadcastableLayerParams, rhs: CoreML_Specification_FloorDivBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SubtractBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SubtractBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SubtractBroadcastableLayerParams, rhs: CoreML_Specification_SubtractBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MultiplyBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MultiplyBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MultiplyBroadcastableLayerParams, rhs: CoreML_Specification_MultiplyBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_DivideBroadcastableLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DivideBroadcastableLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_DivideBroadcastableLayerParams, rhs: CoreML_Specification_DivideBroadcastableLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GatherLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GatherLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GatherLayerParams, rhs: CoreML_Specification_GatherLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ScatterLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ScatterLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.mode != .scatterUpdate {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ScatterLayerParams, rhs: CoreML_Specification_ScatterLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GatherNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GatherNDLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GatherNDLayerParams, rhs: CoreML_Specification_GatherNDLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ScatterNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ScatterNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.mode != .scatterUpdate {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ScatterNDLayerParams, rhs: CoreML_Specification_ScatterNDLayerParams) -> Bool {
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GatherAlongAxisLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GatherAlongAxisLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GatherAlongAxisLayerParams, rhs: CoreML_Specification_GatherAlongAxisLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ScatterAlongAxisLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ScatterAlongAxisLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.mode != .scatterUpdate {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ScatterAlongAxisLayerParams, rhs: CoreML_Specification_ScatterAlongAxisLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_StackLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StackLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_StackLayerParams, rhs: CoreML_Specification_StackLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RankPreservingReshapeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RankPreservingReshapeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.targetShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.targetShape.isEmpty {
      try visitor.visitPackedInt64Field(value: self.targetShape, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RankPreservingReshapeLayerParams, rhs: CoreML_Specification_RankPreservingReshapeLayerParams) -> Bool {
    if lhs.targetShape != rhs.targetShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ConstantPaddingLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ConstantPaddingLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "value"),
    2: .same(proto: "padAmounts"),
    3: .same(proto: "padToGivenOutputSizeMode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.value) }()
      case 2: try { try decoder.decodeRepeatedUInt64Field(value: &self.padAmounts) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.padToGivenOutputSizeMode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.value != 0 {
      try visitor.visitSingularFloatField(value: self.value, fieldNumber: 1)
    }
    if !self.padAmounts.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.padAmounts, fieldNumber: 2)
    }
    if self.padToGivenOutputSizeMode != false {
      try visitor.visitSingularBoolField(value: self.padToGivenOutputSizeMode, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ConstantPaddingLayerParams, rhs: CoreML_Specification_ConstantPaddingLayerParams) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.padAmounts != rhs.padAmounts {return false}
    if lhs.padToGivenOutputSizeMode != rhs.padToGivenOutputSizeMode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomNormalLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomNormalLikeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "mean"),
    3: .same(proto: "stdDev"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.mean) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.stdDev) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.mean != 0 {
      try visitor.visitSingularFloatField(value: self.mean, fieldNumber: 2)
    }
    if self.stdDev != 0 {
      try visitor.visitSingularFloatField(value: self.stdDev, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomNormalLikeLayerParams, rhs: CoreML_Specification_RandomNormalLikeLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.mean != rhs.mean {return false}
    if lhs.stdDev != rhs.stdDev {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomNormalStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomNormalStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "mean"),
    3: .same(proto: "stdDev"),
    4: .same(proto: "outputShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.mean) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.stdDev) }()
      case 4: try { try decoder.decodeRepeatedUInt64Field(value: &self.outputShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.mean != 0 {
      try visitor.visitSingularFloatField(value: self.mean, fieldNumber: 2)
    }
    if self.stdDev != 0 {
      try visitor.visitSingularFloatField(value: self.stdDev, fieldNumber: 3)
    }
    if !self.outputShape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.outputShape, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomNormalStaticLayerParams, rhs: CoreML_Specification_RandomNormalStaticLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.mean != rhs.mean {return false}
    if lhs.stdDev != rhs.stdDev {return false}
    if lhs.outputShape != rhs.outputShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomNormalDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomNormalDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "mean"),
    3: .same(proto: "stdDev"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.mean) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.stdDev) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.mean != 0 {
      try visitor.visitSingularFloatField(value: self.mean, fieldNumber: 2)
    }
    if self.stdDev != 0 {
      try visitor.visitSingularFloatField(value: self.stdDev, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomNormalDynamicLayerParams, rhs: CoreML_Specification_RandomNormalDynamicLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.mean != rhs.mean {return false}
    if lhs.stdDev != rhs.stdDev {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomUniformLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomUniformLikeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "minVal"),
    3: .same(proto: "maxVal"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.minVal) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.maxVal) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.minVal != 0 {
      try visitor.visitSingularFloatField(value: self.minVal, fieldNumber: 2)
    }
    if self.maxVal != 0 {
      try visitor.visitSingularFloatField(value: self.maxVal, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomUniformLikeLayerParams, rhs: CoreML_Specification_RandomUniformLikeLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.minVal != rhs.minVal {return false}
    if lhs.maxVal != rhs.maxVal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomUniformStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomUniformStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "minVal"),
    3: .same(proto: "maxVal"),
    4: .same(proto: "outputShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.minVal) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.maxVal) }()
      case 4: try { try decoder.decodeRepeatedUInt64Field(value: &self.outputShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.minVal != 0 {
      try visitor.visitSingularFloatField(value: self.minVal, fieldNumber: 2)
    }
    if self.maxVal != 0 {
      try visitor.visitSingularFloatField(value: self.maxVal, fieldNumber: 3)
    }
    if !self.outputShape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.outputShape, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomUniformStaticLayerParams, rhs: CoreML_Specification_RandomUniformStaticLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.minVal != rhs.minVal {return false}
    if lhs.maxVal != rhs.maxVal {return false}
    if lhs.outputShape != rhs.outputShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomUniformDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomUniformDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "minVal"),
    3: .same(proto: "maxVal"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.minVal) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.maxVal) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.minVal != 0 {
      try visitor.visitSingularFloatField(value: self.minVal, fieldNumber: 2)
    }
    if self.maxVal != 0 {
      try visitor.visitSingularFloatField(value: self.maxVal, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomUniformDynamicLayerParams, rhs: CoreML_Specification_RandomUniformDynamicLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.minVal != rhs.minVal {return false}
    if lhs.maxVal != rhs.maxVal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomBernoulliLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomBernoulliLikeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "prob"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.prob) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.prob != 0 {
      try visitor.visitSingularFloatField(value: self.prob, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomBernoulliLikeLayerParams, rhs: CoreML_Specification_RandomBernoulliLikeLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.prob != rhs.prob {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomBernoulliStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomBernoulliStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "prob"),
    3: .same(proto: "outputShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.prob) }()
      case 3: try { try decoder.decodeRepeatedUInt64Field(value: &self.outputShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.prob != 0 {
      try visitor.visitSingularFloatField(value: self.prob, fieldNumber: 2)
    }
    if !self.outputShape.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.outputShape, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomBernoulliStaticLayerParams, rhs: CoreML_Specification_RandomBernoulliStaticLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.prob != rhs.prob {return false}
    if lhs.outputShape != rhs.outputShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RandomBernoulliDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RandomBernoulliDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "prob"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.prob) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.prob != 0 {
      try visitor.visitSingularFloatField(value: self.prob, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RandomBernoulliDynamicLayerParams, rhs: CoreML_Specification_RandomBernoulliDynamicLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.prob != rhs.prob {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CategoricalDistributionLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CategoricalDistributionLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "seed"),
    2: .same(proto: "numSamples"),
    3: .same(proto: "isLogits"),
    4: .same(proto: "eps"),
    5: .same(proto: "temperature"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.seed) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.numSamples) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.isLogits) }()
      case 4: try { try decoder.decodeSingularFloatField(value: &self.eps) }()
      case 5: try { try decoder.decodeSingularFloatField(value: &self.temperature) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.seed != 0 {
      try visitor.visitSingularInt64Field(value: self.seed, fieldNumber: 1)
    }
    if self.numSamples != 0 {
      try visitor.visitSingularInt64Field(value: self.numSamples, fieldNumber: 2)
    }
    if self.isLogits != false {
      try visitor.visitSingularBoolField(value: self.isLogits, fieldNumber: 3)
    }
    if self.eps != 0 {
      try visitor.visitSingularFloatField(value: self.eps, fieldNumber: 4)
    }
    if self.temperature != 0 {
      try visitor.visitSingularFloatField(value: self.temperature, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CategoricalDistributionLayerParams, rhs: CoreML_Specification_CategoricalDistributionLayerParams) -> Bool {
    if lhs.seed != rhs.seed {return false}
    if lhs.numSamples != rhs.numSamples {return false}
    if lhs.isLogits != rhs.isLogits {return false}
    if lhs.eps != rhs.eps {return false}
    if lhs.temperature != rhs.temperature {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceL1LayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceL1LayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceL1LayerParams, rhs: CoreML_Specification_ReduceL1LayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceL2LayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceL2LayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceL2LayerParams, rhs: CoreML_Specification_ReduceL2LayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceMaxLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceMaxLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceMaxLayerParams, rhs: CoreML_Specification_ReduceMaxLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceMinLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceMinLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceMinLayerParams, rhs: CoreML_Specification_ReduceMinLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceSumLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceSumLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceSumLayerParams, rhs: CoreML_Specification_ReduceSumLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceProdLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceProdLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceProdLayerParams, rhs: CoreML_Specification_ReduceProdLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceMeanLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceMeanLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceMeanLayerParams, rhs: CoreML_Specification_ReduceMeanLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceLogSumLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceLogSumLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceLogSumLayerParams, rhs: CoreML_Specification_ReduceLogSumLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceSumSquareLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceSumSquareLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceSumSquareLayerParams, rhs: CoreML_Specification_ReduceSumSquareLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReduceLogSumExpLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReduceLogSumExpLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "keepDims"),
    3: .same(proto: "reduceAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.keepDims) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reduceAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.keepDims != false {
      try visitor.visitSingularBoolField(value: self.keepDims, fieldNumber: 2)
    }
    if self.reduceAll != false {
      try visitor.visitSingularBoolField(value: self.reduceAll, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReduceLogSumExpLayerParams, rhs: CoreML_Specification_ReduceLogSumExpLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.keepDims != rhs.keepDims {return false}
    if lhs.reduceAll != rhs.reduceAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ExpandDimsLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ExpandDimsLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ExpandDimsLayerParams, rhs: CoreML_Specification_ExpandDimsLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FlattenTo2DLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FlattenTo2DLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FlattenTo2DLayerParams, rhs: CoreML_Specification_FlattenTo2DLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReshapeStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReshapeStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "targetShape"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.targetShape) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.targetShape.isEmpty {
      try visitor.visitPackedInt64Field(value: self.targetShape, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReshapeStaticLayerParams, rhs: CoreML_Specification_ReshapeStaticLayerParams) -> Bool {
    if lhs.targetShape != rhs.targetShape {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReshapeLikeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReshapeLikeLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReshapeLikeLayerParams, rhs: CoreML_Specification_ReshapeLikeLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ReshapeDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ReshapeDynamicLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ReshapeDynamicLayerParams, rhs: CoreML_Specification_ReshapeDynamicLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SqueezeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SqueezeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axes"),
    2: .same(proto: "squeezeAll"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.axes) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.squeezeAll) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.axes.isEmpty {
      try visitor.visitPackedInt64Field(value: self.axes, fieldNumber: 1)
    }
    if self.squeezeAll != false {
      try visitor.visitSingularBoolField(value: self.squeezeAll, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SqueezeLayerParams, rhs: CoreML_Specification_SqueezeLayerParams) -> Bool {
    if lhs.axes != rhs.axes {return false}
    if lhs.squeezeAll != rhs.squeezeAll {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_TopKLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TopKLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "K"),
    3: .same(proto: "useBottomK"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.k) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.useBottomK) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.k != 0 {
      try visitor.visitSingularUInt64Field(value: self.k, fieldNumber: 2)
    }
    if self.useBottomK != false {
      try visitor.visitSingularBoolField(value: self.useBottomK, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_TopKLayerParams, rhs: CoreML_Specification_TopKLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.k != rhs.k {return false}
    if lhs.useBottomK != rhs.useBottomK {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ArgMaxLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ArgMaxLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "removeDim"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.removeDim) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.removeDim != false {
      try visitor.visitSingularBoolField(value: self.removeDim, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ArgMaxLayerParams, rhs: CoreML_Specification_ArgMaxLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.removeDim != rhs.removeDim {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ArgMinLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ArgMinLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "removeDim"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.removeDim) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.removeDim != false {
      try visitor.visitSingularBoolField(value: self.removeDim, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ArgMinLayerParams, rhs: CoreML_Specification_ArgMinLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.removeDim != rhs.removeDim {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SplitNDLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SplitNDLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "numSplits"),
    3: .same(proto: "splitSizes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.numSplits) }()
      case 3: try { try decoder.decodeRepeatedUInt64Field(value: &self.splitSizes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.numSplits != 0 {
      try visitor.visitSingularUInt64Field(value: self.numSplits, fieldNumber: 2)
    }
    if !self.splitSizes.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.splitSizes, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SplitNDLayerParams, rhs: CoreML_Specification_SplitNDLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.numSplits != rhs.numSplits {return false}
    if lhs.splitSizes != rhs.splitSizes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CeilLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CeilLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CeilLayerParams, rhs: CoreML_Specification_CeilLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RoundLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RoundLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RoundLayerParams, rhs: CoreML_Specification_RoundLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FloorLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FloorLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FloorLayerParams, rhs: CoreML_Specification_FloorLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SignLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SignLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SignLayerParams, rhs: CoreML_Specification_SignLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ClipLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ClipLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "minVal"),
    2: .same(proto: "maxVal"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.minVal) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.maxVal) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.minVal != 0 {
      try visitor.visitSingularFloatField(value: self.minVal, fieldNumber: 1)
    }
    if self.maxVal != 0 {
      try visitor.visitSingularFloatField(value: self.maxVal, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ClipLayerParams, rhs: CoreML_Specification_ClipLayerParams) -> Bool {
    if lhs.minVal != rhs.minVal {return false}
    if lhs.maxVal != rhs.maxVal {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SliceStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SliceStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "beginIds"),
    2: .same(proto: "beginMasks"),
    3: .same(proto: "endIds"),
    4: .same(proto: "endMasks"),
    5: .same(proto: "strides"),
    6: .same(proto: "squeezeMasks"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.beginIds) }()
      case 2: try { try decoder.decodeRepeatedBoolField(value: &self.beginMasks) }()
      case 3: try { try decoder.decodeRepeatedInt64Field(value: &self.endIds) }()
      case 4: try { try decoder.decodeRepeatedBoolField(value: &self.endMasks) }()
      case 5: try { try decoder.decodeRepeatedInt64Field(value: &self.strides) }()
      case 6: try { try decoder.decodeRepeatedBoolField(value: &self.squeezeMasks) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.beginIds.isEmpty {
      try visitor.visitPackedInt64Field(value: self.beginIds, fieldNumber: 1)
    }
    if !self.beginMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.beginMasks, fieldNumber: 2)
    }
    if !self.endIds.isEmpty {
      try visitor.visitPackedInt64Field(value: self.endIds, fieldNumber: 3)
    }
    if !self.endMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.endMasks, fieldNumber: 4)
    }
    if !self.strides.isEmpty {
      try visitor.visitPackedInt64Field(value: self.strides, fieldNumber: 5)
    }
    if !self.squeezeMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.squeezeMasks, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SliceStaticLayerParams, rhs: CoreML_Specification_SliceStaticLayerParams) -> Bool {
    if lhs.beginIds != rhs.beginIds {return false}
    if lhs.beginMasks != rhs.beginMasks {return false}
    if lhs.endIds != rhs.endIds {return false}
    if lhs.endMasks != rhs.endMasks {return false}
    if lhs.strides != rhs.strides {return false}
    if lhs.squeezeMasks != rhs.squeezeMasks {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SliceDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SliceDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "beginMasks"),
    3: .same(proto: "endIds"),
    4: .same(proto: "endMasks"),
    5: .same(proto: "strides"),
    6: .same(proto: "squeezeMasks"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeRepeatedBoolField(value: &self.beginMasks) }()
      case 3: try { try decoder.decodeRepeatedInt64Field(value: &self.endIds) }()
      case 4: try { try decoder.decodeRepeatedBoolField(value: &self.endMasks) }()
      case 5: try { try decoder.decodeRepeatedInt64Field(value: &self.strides) }()
      case 6: try { try decoder.decodeRepeatedBoolField(value: &self.squeezeMasks) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.beginMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.beginMasks, fieldNumber: 2)
    }
    if !self.endIds.isEmpty {
      try visitor.visitPackedInt64Field(value: self.endIds, fieldNumber: 3)
    }
    if !self.endMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.endMasks, fieldNumber: 4)
    }
    if !self.strides.isEmpty {
      try visitor.visitPackedInt64Field(value: self.strides, fieldNumber: 5)
    }
    if !self.squeezeMasks.isEmpty {
      try visitor.visitPackedBoolField(value: self.squeezeMasks, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SliceDynamicLayerParams, rhs: CoreML_Specification_SliceDynamicLayerParams) -> Bool {
    if lhs.beginMasks != rhs.beginMasks {return false}
    if lhs.endIds != rhs.endIds {return false}
    if lhs.endMasks != rhs.endMasks {return false}
    if lhs.strides != rhs.strides {return false}
    if lhs.squeezeMasks != rhs.squeezeMasks {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_TileLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TileLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "reps"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedUInt64Field(value: &self.reps) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.reps.isEmpty {
      try visitor.visitPackedUInt64Field(value: self.reps, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_TileLayerParams, rhs: CoreML_Specification_TileLayerParams) -> Bool {
    if lhs.reps != rhs.reps {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GetShapeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GetShapeLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GetShapeLayerParams, rhs: CoreML_Specification_GetShapeLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ErfLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ErfLayerParams"
  static let _protobuf_nameMap = SwiftProtobuf._NameMap()

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let _ = try decoder.nextFieldNumber() {
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ErfLayerParams, rhs: CoreML_Specification_ErfLayerParams) -> Bool {
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GeluLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".GeluLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "mode"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.mode) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.mode != .exact {
      try visitor.visitSingularEnumField(value: self.mode, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_GeluLayerParams, rhs: CoreML_Specification_GeluLayerParams) -> Bool {
    if lhs.mode != rhs.mode {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_GeluLayerParams.GeluMode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "EXACT"),
    1: .same(proto: "TANH_APPROXIMATION"),
    2: .same(proto: "SIGMOID_APPROXIMATION"),
  ]
}

extension CoreML_Specification_RangeStaticLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RangeStaticLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "endValue"),
    2: .same(proto: "startValue"),
    3: .same(proto: "stepSizeValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.endValue) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.startValue) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.stepSizeValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.endValue != 0 {
      try visitor.visitSingularFloatField(value: self.endValue, fieldNumber: 1)
    }
    if self.startValue != 0 {
      try visitor.visitSingularFloatField(value: self.startValue, fieldNumber: 2)
    }
    if self.stepSizeValue != 0 {
      try visitor.visitSingularFloatField(value: self.stepSizeValue, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RangeStaticLayerParams, rhs: CoreML_Specification_RangeStaticLayerParams) -> Bool {
    if lhs.endValue != rhs.endValue {return false}
    if lhs.startValue != rhs.startValue {return false}
    if lhs.stepSizeValue != rhs.stepSizeValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_RangeDynamicLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".RangeDynamicLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "startValue"),
    3: .same(proto: "stepSizeValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularFloatField(value: &self.startValue) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.stepSizeValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.startValue != 0 {
      try visitor.visitSingularFloatField(value: self.startValue, fieldNumber: 2)
    }
    if self.stepSizeValue != 0 {
      try visitor.visitSingularFloatField(value: self.stepSizeValue, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_RangeDynamicLayerParams, rhs: CoreML_Specification_RangeDynamicLayerParams) -> Bool {
    if lhs.startValue != rhs.startValue {return false}
    if lhs.stepSizeValue != rhs.stepSizeValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SlidingWindowsLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SlidingWindowsLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "windowSize"),
    3: .same(proto: "step"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.windowSize) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.step) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.windowSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.windowSize, fieldNumber: 2)
    }
    if self.step != 0 {
      try visitor.visitSingularUInt64Field(value: self.step, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SlidingWindowsLayerParams, rhs: CoreML_Specification_SlidingWindowsLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.windowSize != rhs.windowSize {return false}
    if lhs.step != rhs.step {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LayerNormalizationLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LayerNormalizationLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "normalizedShape"),
    2: .same(proto: "eps"),
    3: .same(proto: "gamma"),
    4: .same(proto: "beta"),
  ]

  fileprivate class _StorageClass {
    var _normalizedShape: [Int64] = []
    var _eps: Float = 0
    var _gamma: CoreML_Specification_WeightParams? = nil
    var _beta: CoreML_Specification_WeightParams? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _normalizedShape = source._normalizedShape
      _eps = source._eps
      _gamma = source._gamma
      _beta = source._beta
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeRepeatedInt64Field(value: &_storage._normalizedShape) }()
        case 2: try { try decoder.decodeSingularFloatField(value: &_storage._eps) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._gamma) }()
        case 4: try { try decoder.decodeSingularMessageField(value: &_storage._beta) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._normalizedShape.isEmpty {
        try visitor.visitPackedInt64Field(value: _storage._normalizedShape, fieldNumber: 1)
      }
      if _storage._eps != 0 {
        try visitor.visitSingularFloatField(value: _storage._eps, fieldNumber: 2)
      }
      try { if let v = _storage._gamma {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._beta {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LayerNormalizationLayerParams, rhs: CoreML_Specification_LayerNormalizationLayerParams) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._normalizedShape != rhs_storage._normalizedShape {return false}
        if _storage._eps != rhs_storage._eps {return false}
        if _storage._gamma != rhs_storage._gamma {return false}
        if _storage._beta != rhs_storage._beta {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NonMaximumSuppressionLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NonMaximumSuppressionLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "iouThreshold"),
    2: .same(proto: "scoreThreshold"),
    3: .same(proto: "maxBoxes"),
    4: .same(proto: "perClassSuppression"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.iouThreshold) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.scoreThreshold) }()
      case 3: try { try decoder.decodeSingularUInt64Field(value: &self.maxBoxes) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.perClassSuppression) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.iouThreshold != 0 {
      try visitor.visitSingularFloatField(value: self.iouThreshold, fieldNumber: 1)
    }
    if self.scoreThreshold != 0 {
      try visitor.visitSingularFloatField(value: self.scoreThreshold, fieldNumber: 2)
    }
    if self.maxBoxes != 0 {
      try visitor.visitSingularUInt64Field(value: self.maxBoxes, fieldNumber: 3)
    }
    if self.perClassSuppression != false {
      try visitor.visitSingularBoolField(value: self.perClassSuppression, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NonMaximumSuppressionLayerParams, rhs: CoreML_Specification_NonMaximumSuppressionLayerParams) -> Bool {
    if lhs.iouThreshold != rhs.iouThreshold {return false}
    if lhs.scoreThreshold != rhs.scoreThreshold {return false}
    if lhs.maxBoxes != rhs.maxBoxes {return false}
    if lhs.perClassSuppression != rhs.perClassSuppression {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ClampedReLULayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ClampedReLULayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "alpha"),
    2: .same(proto: "beta"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularFloatField(value: &self.alpha) }()
      case 2: try { try decoder.decodeSingularFloatField(value: &self.beta) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.alpha != 0 {
      try visitor.visitSingularFloatField(value: self.alpha, fieldNumber: 1)
    }
    if self.beta != 0 {
      try visitor.visitSingularFloatField(value: self.beta, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ClampedReLULayerParams, rhs: CoreML_Specification_ClampedReLULayerParams) -> Bool {
    if lhs.alpha != rhs.alpha {return false}
    if lhs.beta != rhs.beta {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ArgSortLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ArgSortLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "descending"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.descending) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.descending != false {
      try visitor.visitSingularBoolField(value: self.descending, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ArgSortLayerParams, rhs: CoreML_Specification_ArgSortLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.descending != rhs.descending {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SliceBySizeLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SliceBySizeLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    2: .same(proto: "size"),
    3: .same(proto: "axis"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.size) }()
      case 3: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.size != 0 {
      try visitor.visitSingularInt64Field(value: self.size, fieldNumber: 2)
    }
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SliceBySizeLayerParams, rhs: CoreML_Specification_SliceBySizeLayerParams) -> Bool {
    if lhs.size != rhs.size {return false}
    if lhs.axis != rhs.axis {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkClassifier: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkClassifier"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "layers"),
    2: .same(proto: "preprocessing"),
    5: .same(proto: "arrayInputShapeMapping"),
    6: .same(proto: "imageInputShapeMapping"),
    10: .same(proto: "updateParams"),
    100: .same(proto: "stringClassLabels"),
    101: .same(proto: "int64ClassLabels"),
    200: .same(proto: "labelProbabilityLayerName"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.layers) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.preprocessing) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.arrayInputShapeMapping) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.imageInputShapeMapping) }()
      case 10: try { try decoder.decodeSingularMessageField(value: &self._updateParams) }()
      case 100: try {
        var v: CoreML_Specification_StringVector?
        var hadOneofValue = false
        if let current = self.classLabels {
          hadOneofValue = true
          if case .stringClassLabels(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.classLabels = .stringClassLabels(v)
        }
      }()
      case 101: try {
        var v: CoreML_Specification_Int64Vector?
        var hadOneofValue = false
        if let current = self.classLabels {
          hadOneofValue = true
          if case .int64ClassLabels(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.classLabels = .int64ClassLabels(v)
        }
      }()
      case 200: try { try decoder.decodeSingularStringField(value: &self.labelProbabilityLayerName) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.layers.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.layers, fieldNumber: 1)
    }
    if !self.preprocessing.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.preprocessing, fieldNumber: 2)
    }
    if self.arrayInputShapeMapping != .rank5ArrayMapping {
      try visitor.visitSingularEnumField(value: self.arrayInputShapeMapping, fieldNumber: 5)
    }
    if self.imageInputShapeMapping != .rank5ImageMapping {
      try visitor.visitSingularEnumField(value: self.imageInputShapeMapping, fieldNumber: 6)
    }
    try { if let v = self._updateParams {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    } }()
    switch self.classLabels {
    case .stringClassLabels?: try {
      guard case .stringClassLabels(let v)? = self.classLabels else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 100)
    }()
    case .int64ClassLabels?: try {
      guard case .int64ClassLabels(let v)? = self.classLabels else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 101)
    }()
    case nil: break
    }
    if !self.labelProbabilityLayerName.isEmpty {
      try visitor.visitSingularStringField(value: self.labelProbabilityLayerName, fieldNumber: 200)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkClassifier, rhs: CoreML_Specification_NeuralNetworkClassifier) -> Bool {
    if lhs.layers != rhs.layers {return false}
    if lhs.preprocessing != rhs.preprocessing {return false}
    if lhs.arrayInputShapeMapping != rhs.arrayInputShapeMapping {return false}
    if lhs.imageInputShapeMapping != rhs.imageInputShapeMapping {return false}
    if lhs._updateParams != rhs._updateParams {return false}
    if lhs.classLabels != rhs.classLabels {return false}
    if lhs.labelProbabilityLayerName != rhs.labelProbabilityLayerName {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_OneHotLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".OneHotLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "oneHotVectorSize"),
    2: .same(proto: "axis"),
    3: .same(proto: "onValue"),
    4: .same(proto: "offValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.oneHotVectorSize) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 3: try { try decoder.decodeSingularFloatField(value: &self.onValue) }()
      case 4: try { try decoder.decodeSingularFloatField(value: &self.offValue) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.oneHotVectorSize != 0 {
      try visitor.visitSingularUInt64Field(value: self.oneHotVectorSize, fieldNumber: 1)
    }
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 2)
    }
    if self.onValue != 0 {
      try visitor.visitSingularFloatField(value: self.onValue, fieldNumber: 3)
    }
    if self.offValue != 0 {
      try visitor.visitSingularFloatField(value: self.offValue, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_OneHotLayerParams, rhs: CoreML_Specification_OneHotLayerParams) -> Bool {
    if lhs.oneHotVectorSize != rhs.oneHotVectorSize {return false}
    if lhs.axis != rhs.axis {return false}
    if lhs.onValue != rhs.onValue {return false}
    if lhs.offValue != rhs.offValue {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CumSumLayerParams: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CumSumLayerParams"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "axis"),
    2: .same(proto: "excludeFinalSum"),
    3: .same(proto: "reverse"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.axis) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.excludeFinalSum) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.reverse) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.axis != 0 {
      try visitor.visitSingularInt64Field(value: self.axis, fieldNumber: 1)
    }
    if self.excludeFinalSum != false {
      try visitor.visitSingularBoolField(value: self.excludeFinalSum, fieldNumber: 2)
    }
    if self.reverse != false {
      try visitor.visitSingularBoolField(value: self.reverse, fieldNumber: 3)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CumSumLayerParams, rhs: CoreML_Specification_CumSumLayerParams) -> Bool {
    if lhs.axis != rhs.axis {return false}
    if lhs.excludeFinalSum != rhs.excludeFinalSum {return false}
    if lhs.reverse != rhs.reverse {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NeuralNetworkRegressor: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NeuralNetworkRegressor"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "layers"),
    2: .same(proto: "preprocessing"),
    5: .same(proto: "arrayInputShapeMapping"),
    6: .same(proto: "imageInputShapeMapping"),
    10: .same(proto: "updateParams"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.layers) }()
      case 2: try { try decoder.decodeRepeatedMessageField(value: &self.preprocessing) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.arrayInputShapeMapping) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.imageInputShapeMapping) }()
      case 10: try { try decoder.decodeSingularMessageField(value: &self._updateParams) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.layers.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.layers, fieldNumber: 1)
    }
    if !self.preprocessing.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.preprocessing, fieldNumber: 2)
    }
    if self.arrayInputShapeMapping != .rank5ArrayMapping {
      try visitor.visitSingularEnumField(value: self.arrayInputShapeMapping, fieldNumber: 5)
    }
    if self.imageInputShapeMapping != .rank5ImageMapping {
      try visitor.visitSingularEnumField(value: self.imageInputShapeMapping, fieldNumber: 6)
    }
    try { if let v = self._updateParams {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NeuralNetworkRegressor, rhs: CoreML_Specification_NeuralNetworkRegressor) -> Bool {
    if lhs.layers != rhs.layers {return false}
    if lhs.preprocessing != rhs.preprocessing {return false}
    if lhs.arrayInputShapeMapping != rhs.arrayInputShapeMapping {return false}
    if lhs.imageInputShapeMapping != rhs.imageInputShapeMapping {return false}
    if lhs._updateParams != rhs._updateParams {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_NetworkUpdateParameters: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NetworkUpdateParameters"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "lossLayers"),
    2: .same(proto: "optimizer"),
    3: .same(proto: "epochs"),
    10: .same(proto: "shuffle"),
    20: .same(proto: "seed"),
  ]

  fileprivate class _StorageClass {
    var _lossLayers: [CoreML_Specification_LossLayer] = []
    var _optimizer: CoreML_Specification_Optimizer? = nil
    var _epochs: CoreML_Specification_Int64Parameter? = nil
    var _shuffle: CoreML_Specification_BoolParameter? = nil
    var _seed: CoreML_Specification_Int64Parameter? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _lossLayers = source._lossLayers
      _optimizer = source._optimizer
      _epochs = source._epochs
      _shuffle = source._shuffle
      _seed = source._seed
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeRepeatedMessageField(value: &_storage._lossLayers) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._optimizer) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._epochs) }()
        case 10: try { try decoder.decodeSingularMessageField(value: &_storage._shuffle) }()
        case 20: try { try decoder.decodeSingularMessageField(value: &_storage._seed) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if !_storage._lossLayers.isEmpty {
        try visitor.visitRepeatedMessageField(value: _storage._lossLayers, fieldNumber: 1)
      }
      try { if let v = _storage._optimizer {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      try { if let v = _storage._epochs {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      } }()
      try { if let v = _storage._shuffle {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
      } }()
      try { if let v = _storage._seed {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 20)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_NetworkUpdateParameters, rhs: CoreML_Specification_NetworkUpdateParameters) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._lossLayers != rhs_storage._lossLayers {return false}
        if _storage._optimizer != rhs_storage._optimizer {return false}
        if _storage._epochs != rhs_storage._epochs {return false}
        if _storage._shuffle != rhs_storage._shuffle {return false}
        if _storage._seed != rhs_storage._seed {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_LossLayer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".LossLayer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    10: .same(proto: "categoricalCrossEntropyLossLayer"),
    11: .same(proto: "meanSquaredErrorLossLayer"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 10: try {
        var v: CoreML_Specification_CategoricalCrossEntropyLossLayer?
        var hadOneofValue = false
        if let current = self.lossLayerType {
          hadOneofValue = true
          if case .categoricalCrossEntropyLossLayer(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.lossLayerType = .categoricalCrossEntropyLossLayer(v)
        }
      }()
      case 11: try {
        var v: CoreML_Specification_MeanSquaredErrorLossLayer?
        var hadOneofValue = false
        if let current = self.lossLayerType {
          hadOneofValue = true
          if case .meanSquaredErrorLossLayer(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.lossLayerType = .meanSquaredErrorLossLayer(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    switch self.lossLayerType {
    case .categoricalCrossEntropyLossLayer?: try {
      guard case .categoricalCrossEntropyLossLayer(let v)? = self.lossLayerType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .meanSquaredErrorLossLayer?: try {
      guard case .meanSquaredErrorLossLayer(let v)? = self.lossLayerType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_LossLayer, rhs: CoreML_Specification_LossLayer) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.lossLayerType != rhs.lossLayerType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_CategoricalCrossEntropyLossLayer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".CategoricalCrossEntropyLossLayer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "target"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.input) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.target) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.input.isEmpty {
      try visitor.visitSingularStringField(value: self.input, fieldNumber: 1)
    }
    if !self.target.isEmpty {
      try visitor.visitSingularStringField(value: self.target, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_CategoricalCrossEntropyLossLayer, rhs: CoreML_Specification_CategoricalCrossEntropyLossLayer) -> Bool {
    if lhs.input != rhs.input {return false}
    if lhs.target != rhs.target {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MeanSquaredErrorLossLayer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".MeanSquaredErrorLossLayer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    2: .same(proto: "target"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.input) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.target) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.input.isEmpty {
      try visitor.visitSingularStringField(value: self.input, fieldNumber: 1)
    }
    if !self.target.isEmpty {
      try visitor.visitSingularStringField(value: self.target, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MeanSquaredErrorLossLayer, rhs: CoreML_Specification_MeanSquaredErrorLossLayer) -> Bool {
    if lhs.input != rhs.input {return false}
    if lhs.target != rhs.target {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Optimizer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Optimizer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    10: .same(proto: "sgdOptimizer"),
    11: .same(proto: "adamOptimizer"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 10: try {
        var v: CoreML_Specification_SGDOptimizer?
        var hadOneofValue = false
        if let current = self.optimizerType {
          hadOneofValue = true
          if case .sgdOptimizer(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.optimizerType = .sgdOptimizer(v)
        }
      }()
      case 11: try {
        var v: CoreML_Specification_AdamOptimizer?
        var hadOneofValue = false
        if let current = self.optimizerType {
          hadOneofValue = true
          if case .adamOptimizer(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.optimizerType = .adamOptimizer(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.optimizerType {
    case .sgdOptimizer?: try {
      guard case .sgdOptimizer(let v)? = self.optimizerType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 10)
    }()
    case .adamOptimizer?: try {
      guard case .adamOptimizer(let v)? = self.optimizerType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 11)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Optimizer, rhs: CoreML_Specification_Optimizer) -> Bool {
    if lhs.optimizerType != rhs.optimizerType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SGDOptimizer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SGDOptimizer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "learningRate"),
    2: .same(proto: "miniBatchSize"),
    3: .same(proto: "momentum"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._learningRate) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._miniBatchSize) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._momentum) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._learningRate {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._miniBatchSize {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._momentum {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SGDOptimizer, rhs: CoreML_Specification_SGDOptimizer) -> Bool {
    if lhs._learningRate != rhs._learningRate {return false}
    if lhs._miniBatchSize != rhs._miniBatchSize {return false}
    if lhs._momentum != rhs._momentum {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_AdamOptimizer: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".AdamOptimizer"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "learningRate"),
    2: .same(proto: "miniBatchSize"),
    3: .same(proto: "beta1"),
    4: .same(proto: "beta2"),
    5: .same(proto: "eps"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._learningRate) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._miniBatchSize) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._beta1) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._beta2) }()
      case 5: try { try decoder.decodeSingularMessageField(value: &self._eps) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._learningRate {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._miniBatchSize {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._beta1 {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._beta2 {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._eps {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_AdamOptimizer, rhs: CoreML_Specification_AdamOptimizer) -> Bool {
    if lhs._learningRate != rhs._learningRate {return false}
    if lhs._miniBatchSize != rhs._miniBatchSize {return false}
    if lhs._beta1 != rhs._beta1 {return false}
    if lhs._beta2 != rhs._beta2 {return false}
    if lhs._eps != rhs._eps {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
