// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: Model.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

// Copyright (c) 2017, Apple Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-3-clause license that can be
// found in LICENSE.txt or at https://opensource.org/licenses/BSD-3-Clause

//*
// A Core ML model consists of a specification version
// and a model description,
// and can be any one of the following types:
//
// Neural Networks
//   - `NeuralNetwork`
//
// Regressors
//   - ``GLMRegressor``
//   - ``SupportVectorRegressor``
//   - ``TreeEnsembleRegressor``
//   - ``NeuralNetworkRegressor``
//   - ``BayesianProbitRegressor``
//
// Classifiers
//   - `NeuralNetworkClassifier`
//   - `TreeEnsembleClassifier`
//   - `GLMClassifier`
//   - `SupportVectorClassifier`
//   - `KNearestNeighborsClassifier`
//
// Other models
//   - `CustomModel`
//   - `TextClassifier`
//   - `WordTagger`
//   - `Gazetteer`
//   - `WordEmbedding`
//   - `VisionFeaturePrint`
//   - `LinkedModel`
//   - `SoundAnalysisPreprocessing`
//   - `ItemSimilarityRecommender`
//
// Feature Engineering
//   - `Imputer`
//   - `Scaler`
//   - `Normalizer`
//   - `OneHotEncoder`
//   - `CategoricalMapping`
//   - `FeatureVectorizer`
//   - `DictVectorizer`
//   - `ArrayFeatureExtractor`
//   - `NonMaximumSuppression`
//
// Pipelines
//   - `PipelineClassifier`
//   - `PipelineRegressor`
//   - `Pipeline`
//
// Simple Mathematical Functions
//   - `Identity`

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

///*
/// A pipeline consisting of one or more models.
struct CoreML_Specification_Pipeline {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var models: [CoreML_Specification_Model] = []

  /// Optional names given for each model
  /// If not supplied it defaults to ["model0",..., "model"(models.size()-1)]
  /// These names can be used to disambiguate the scope / domain of a parameter
  var names: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A classifier pipeline.
struct CoreML_Specification_PipelineClassifier {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var pipeline: CoreML_Specification_Pipeline {
    get {return _pipeline ?? CoreML_Specification_Pipeline()}
    set {_pipeline = newValue}
  }
  /// Returns true if `pipeline` has been explicitly set.
  var hasPipeline: Bool {return self._pipeline != nil}
  /// Clears the value of `pipeline`. Subsequent reads from it will return its default value.
  mutating func clearPipeline() {self._pipeline = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _pipeline: CoreML_Specification_Pipeline? = nil
}

///*
/// A regressor pipeline.
struct CoreML_Specification_PipelineRegressor {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var pipeline: CoreML_Specification_Pipeline {
    get {return _pipeline ?? CoreML_Specification_Pipeline()}
    set {_pipeline = newValue}
  }
  /// Returns true if `pipeline` has been explicitly set.
  var hasPipeline: Bool {return self._pipeline != nil}
  /// Clears the value of `pipeline`. Subsequent reads from it will return its default value.
  mutating func clearPipeline() {self._pipeline = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _pipeline: CoreML_Specification_Pipeline? = nil
}

///*
/// A feature description,
/// consisting of a name, short description, and type.
struct CoreML_Specification_FeatureDescription {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var name: String = String()

  var shortDescription: String = String()

  var type: CoreML_Specification_FeatureType {
    get {return _type ?? CoreML_Specification_FeatureType()}
    set {_type = newValue}
  }
  /// Returns true if `type` has been explicitly set.
  var hasType: Bool {return self._type != nil}
  /// Clears the value of `type`. Subsequent reads from it will return its default value.
  mutating func clearType() {self._type = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _type: CoreML_Specification_FeatureType? = nil
}

///*
/// Model metadata,
/// consisting of a short description, a version string,
/// an author, a license, and any other user defined
/// key/value meta data.
struct CoreML_Specification_Metadata {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var shortDescription: String = String()

  var versionString: String = String()

  var author: String = String()

  var license: String = String()

  var userDefined: Dictionary<String,String> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A description of a model,
/// consisting of descriptions of its input and output features.
/// Both regressor and classifier models require the name of the
/// primary predicted output feature (``predictedFeatureName``).
/// Classifier models can specify the output feature containing
/// probabilities for the predicted classes
/// (``predictedProbabilitiesName``).
struct CoreML_Specification_ModelDescription {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var input: [CoreML_Specification_FeatureDescription] = []

  var output: [CoreML_Specification_FeatureDescription] = []

  /// [Required for regressor and classifier models]: the name
  /// to give to an output feature containing the prediction.
  var predictedFeatureName: String = String()

  /// [Optional for classifier models]: the name to give to an
  /// output feature containing a dictionary mapping class
  /// labels to their predicted probabilities. If not specified,
  /// the dictionary will not be returned by the model.
  var predictedProbabilitiesName: String = String()

  var trainingInput: [CoreML_Specification_FeatureDescription] = []

  var metadata: CoreML_Specification_Metadata {
    get {return _metadata ?? CoreML_Specification_Metadata()}
    set {_metadata = newValue}
  }
  /// Returns true if `metadata` has been explicitly set.
  var hasMetadata: Bool {return self._metadata != nil}
  /// Clears the value of `metadata`. Subsequent reads from it will return its default value.
  mutating func clearMetadata() {self._metadata = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _metadata: CoreML_Specification_Metadata? = nil
}

struct CoreML_Specification_SerializedModel {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Identifier whose content describes the model type of the serialized protocol buffer message.
  var identifier: String = String()

  /// Must be a valid serialized protocol buffer of the above specified type.
  var model: Data = Data()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

///*
/// A Core ML model,
/// consisting of a specification version,
/// a model description, and a model type.
///
/// Core ML model compatibility is indicated by
/// a monotonically increasing specification version number,
/// which is incremented anytime a backward-incompatible change is made
/// (this is functionally equivalent to the MAJOR version number
/// described by `Semantic Versioning 2.0.0 <http://semver.org/>`_).
///
/// Specification Versions : OS Availability (Core ML Version)
///
/// 1 : iOS 11, macOS 10.13, tvOS 11, watchOS 4 (Core ML 1)
/// - Feedforward & Recurrent Neural Networks
/// - General Linear Models
/// - Tree Ensembles
/// - Support Vector Machines
/// - Pipelines
/// - Feature Engineering
///
/// 2 : iOS 11.2, macOS 10.13.2, tvOS 11.2, watchOS 4.2 (Core ML 1.2)
/// - Custom Layers for Neural Networks
/// - Float 16 support for Neural Network layers
///
/// 3 : iOS 12, macOS 10.14, tvOS 12, watchOS 5 (Core ML 2)
/// - Flexible shapes and image sizes
/// - Categorical sequences
/// - Core ML Vision Feature Print, Text Classifier, Word Tagger
/// - Non Max Suppression
/// - Crop and Resize Bilinear NN layers
/// - Custom Models
///
/// 4 : iOS 13, macOS 10.15, tvOS 13, watchOS 6 (Core ML 3)
/// - Updatable models
/// - Exact shape / general rank mapping for neural networks
/// - Large expansion of supported neural network layers
///   - Generalized operations
///   - Control flow
///   - Dynamic layers
///   - See NeuralNetwork.proto
/// - Nearest Neighbor Classifier
/// - Sound Analysis Prepreocessing
/// - Recommender
/// - Linked Model
/// - NLP Gazeteer
/// - NLP WordEmbedding
///
/// 5 : iOS 14, macOS 11, tvOS 14, watchOS 7 (Core ML 4)
/// - Model Deployment
/// - Model Encryption
/// - Unified converter API with PyTorch and Tensorflow 2 Support in coremltools 4
/// - MIL builder for neural networks and composite ops in coremltools 4
/// - New layers in neural network:
///      - CumSum
///      - OneHot
///      - ClampedReLu
///      - ArgSort
///      - SliceBySize
///      - Convolution3D
///      - Pool3D
///      - Bilinear Upsample with align corners and fractional factors
///      - PixelShuffle
///      - MatMul with int8 weights and int8 activations
///      - Concat interleave
///      - See NeuralNetwork.proto
/// - Enhanced Xcode model view with interactive previews
/// - Enhanced Xcode Playground support for Core ML models
///
/// 6 : iOS 15, macOS 12, tvOS 15, watchOS 8 (Core ML 5)
/// - Core ML Audio Feature Print
/// - new type of model: mlprogram (MILSpec.Program)
struct CoreML_Specification_Model {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var specificationVersion: Int32 {
    get {return _storage._specificationVersion}
    set {_uniqueStorage()._specificationVersion = newValue}
  }

  var description_p: CoreML_Specification_ModelDescription {
    get {return _storage._description_p ?? CoreML_Specification_ModelDescription()}
    set {_uniqueStorage()._description_p = newValue}
  }
  /// Returns true if `description_p` has been explicitly set.
  var hasDescription_p: Bool {return _storage._description_p != nil}
  /// Clears the value of `description_p`. Subsequent reads from it will return its default value.
  mutating func clearDescription_p() {_uniqueStorage()._description_p = nil}

  ///
  /// Following model types support on-device update:
  ///
  /// - NeuralNetworkClassifier
  /// - NeuralNetworkRegressor
  /// - NeuralNetwork
  /// - KNearestNeighborsClassifier
  var isUpdatable: Bool {
    get {return _storage._isUpdatable}
    set {_uniqueStorage()._isUpdatable = newValue}
  }

  /// start at 200 here
  /// model specific parameters:
  var type: OneOf_Type? {
    get {return _storage._type}
    set {_uniqueStorage()._type = newValue}
  }

  /// pipeline starts at 200
  var pipelineClassifier: CoreML_Specification_PipelineClassifier {
    get {
      if case .pipelineClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_PipelineClassifier()
    }
    set {_uniqueStorage()._type = .pipelineClassifier(newValue)}
  }

  var pipelineRegressor: CoreML_Specification_PipelineRegressor {
    get {
      if case .pipelineRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_PipelineRegressor()
    }
    set {_uniqueStorage()._type = .pipelineRegressor(newValue)}
  }

  var pipeline: CoreML_Specification_Pipeline {
    get {
      if case .pipeline(let v)? = _storage._type {return v}
      return CoreML_Specification_Pipeline()
    }
    set {_uniqueStorage()._type = .pipeline(newValue)}
  }

  /// regressors start at 300
  var glmRegressor: CoreML_Specification_GLMRegressor {
    get {
      if case .glmRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_GLMRegressor()
    }
    set {_uniqueStorage()._type = .glmRegressor(newValue)}
  }

  var supportVectorRegressor: CoreML_Specification_SupportVectorRegressor {
    get {
      if case .supportVectorRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_SupportVectorRegressor()
    }
    set {_uniqueStorage()._type = .supportVectorRegressor(newValue)}
  }

  var treeEnsembleRegressor: CoreML_Specification_TreeEnsembleRegressor {
    get {
      if case .treeEnsembleRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_TreeEnsembleRegressor()
    }
    set {_uniqueStorage()._type = .treeEnsembleRegressor(newValue)}
  }

  var neuralNetworkRegressor: CoreML_Specification_NeuralNetworkRegressor {
    get {
      if case .neuralNetworkRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_NeuralNetworkRegressor()
    }
    set {_uniqueStorage()._type = .neuralNetworkRegressor(newValue)}
  }

  var bayesianProbitRegressor: CoreML_Specification_BayesianProbitRegressor {
    get {
      if case .bayesianProbitRegressor(let v)? = _storage._type {return v}
      return CoreML_Specification_BayesianProbitRegressor()
    }
    set {_uniqueStorage()._type = .bayesianProbitRegressor(newValue)}
  }

  /// classifiers start at 400
  var glmClassifier: CoreML_Specification_GLMClassifier {
    get {
      if case .glmClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_GLMClassifier()
    }
    set {_uniqueStorage()._type = .glmClassifier(newValue)}
  }

  var supportVectorClassifier: CoreML_Specification_SupportVectorClassifier {
    get {
      if case .supportVectorClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_SupportVectorClassifier()
    }
    set {_uniqueStorage()._type = .supportVectorClassifier(newValue)}
  }

  var treeEnsembleClassifier: CoreML_Specification_TreeEnsembleClassifier {
    get {
      if case .treeEnsembleClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_TreeEnsembleClassifier()
    }
    set {_uniqueStorage()._type = .treeEnsembleClassifier(newValue)}
  }

  var neuralNetworkClassifier: CoreML_Specification_NeuralNetworkClassifier {
    get {
      if case .neuralNetworkClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_NeuralNetworkClassifier()
    }
    set {_uniqueStorage()._type = .neuralNetworkClassifier(newValue)}
  }

  var kNearestNeighborsClassifier: CoreML_Specification_KNearestNeighborsClassifier {
    get {
      if case .kNearestNeighborsClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_KNearestNeighborsClassifier()
    }
    set {_uniqueStorage()._type = .kNearestNeighborsClassifier(newValue)}
  }

  /// generic models start at 500
  var neuralNetwork: CoreML_Specification_NeuralNetwork {
    get {
      if case .neuralNetwork(let v)? = _storage._type {return v}
      return CoreML_Specification_NeuralNetwork()
    }
    set {_uniqueStorage()._type = .neuralNetwork(newValue)}
  }

  var itemSimilarityRecommender: CoreML_Specification_ItemSimilarityRecommender {
    get {
      if case .itemSimilarityRecommender(let v)? = _storage._type {return v}
      return CoreML_Specification_ItemSimilarityRecommender()
    }
    set {_uniqueStorage()._type = .itemSimilarityRecommender(newValue)}
  }

  var mlProgram: CoreML_Specification_MILSpec_Program {
    get {
      if case .mlProgram(let v)? = _storage._type {return v}
      return CoreML_Specification_MILSpec_Program()
    }
    set {_uniqueStorage()._type = .mlProgram(newValue)}
  }

  /// Custom and linked models
  var customModel: CoreML_Specification_CustomModel {
    get {
      if case .customModel(let v)? = _storage._type {return v}
      return CoreML_Specification_CustomModel()
    }
    set {_uniqueStorage()._type = .customModel(newValue)}
  }

  var linkedModel: CoreML_Specification_LinkedModel {
    get {
      if case .linkedModel(let v)? = _storage._type {return v}
      return CoreML_Specification_LinkedModel()
    }
    set {_uniqueStorage()._type = .linkedModel(newValue)}
  }

  /// feature engineering starts at 600
  var oneHotEncoder: CoreML_Specification_OneHotEncoder {
    get {
      if case .oneHotEncoder(let v)? = _storage._type {return v}
      return CoreML_Specification_OneHotEncoder()
    }
    set {_uniqueStorage()._type = .oneHotEncoder(newValue)}
  }

  var imputer: CoreML_Specification_Imputer {
    get {
      if case .imputer(let v)? = _storage._type {return v}
      return CoreML_Specification_Imputer()
    }
    set {_uniqueStorage()._type = .imputer(newValue)}
  }

  var featureVectorizer: CoreML_Specification_FeatureVectorizer {
    get {
      if case .featureVectorizer(let v)? = _storage._type {return v}
      return CoreML_Specification_FeatureVectorizer()
    }
    set {_uniqueStorage()._type = .featureVectorizer(newValue)}
  }

  var dictVectorizer: CoreML_Specification_DictVectorizer {
    get {
      if case .dictVectorizer(let v)? = _storage._type {return v}
      return CoreML_Specification_DictVectorizer()
    }
    set {_uniqueStorage()._type = .dictVectorizer(newValue)}
  }

  var scaler: CoreML_Specification_Scaler {
    get {
      if case .scaler(let v)? = _storage._type {return v}
      return CoreML_Specification_Scaler()
    }
    set {_uniqueStorage()._type = .scaler(newValue)}
  }

  var categoricalMapping: CoreML_Specification_CategoricalMapping {
    get {
      if case .categoricalMapping(let v)? = _storage._type {return v}
      return CoreML_Specification_CategoricalMapping()
    }
    set {_uniqueStorage()._type = .categoricalMapping(newValue)}
  }

  var normalizer: CoreML_Specification_Normalizer {
    get {
      if case .normalizer(let v)? = _storage._type {return v}
      return CoreML_Specification_Normalizer()
    }
    set {_uniqueStorage()._type = .normalizer(newValue)}
  }

  var arrayFeatureExtractor: CoreML_Specification_ArrayFeatureExtractor {
    get {
      if case .arrayFeatureExtractor(let v)? = _storage._type {return v}
      return CoreML_Specification_ArrayFeatureExtractor()
    }
    set {_uniqueStorage()._type = .arrayFeatureExtractor(newValue)}
  }

  var nonMaximumSuppression: CoreML_Specification_NonMaximumSuppression {
    get {
      if case .nonMaximumSuppression(let v)? = _storage._type {return v}
      return CoreML_Specification_NonMaximumSuppression()
    }
    set {_uniqueStorage()._type = .nonMaximumSuppression(newValue)}
  }

  /// simple mathematical functions used for testing start at 900
  var identity: CoreML_Specification_Identity {
    get {
      if case .identity(let v)? = _storage._type {return v}
      return CoreML_Specification_Identity()
    }
    set {_uniqueStorage()._type = .identity(newValue)}
  }

  /// CoreML provided models
  var textClassifier: CoreML_Specification_CoreMLModels_TextClassifier {
    get {
      if case .textClassifier(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_TextClassifier()
    }
    set {_uniqueStorage()._type = .textClassifier(newValue)}
  }

  var wordTagger: CoreML_Specification_CoreMLModels_WordTagger {
    get {
      if case .wordTagger(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_WordTagger()
    }
    set {_uniqueStorage()._type = .wordTagger(newValue)}
  }

  var visionFeaturePrint: CoreML_Specification_CoreMLModels_VisionFeaturePrint {
    get {
      if case .visionFeaturePrint(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_VisionFeaturePrint()
    }
    set {_uniqueStorage()._type = .visionFeaturePrint(newValue)}
  }

  var soundAnalysisPreprocessing: CoreML_Specification_CoreMLModels_SoundAnalysisPreprocessing {
    get {
      if case .soundAnalysisPreprocessing(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_SoundAnalysisPreprocessing()
    }
    set {_uniqueStorage()._type = .soundAnalysisPreprocessing(newValue)}
  }

  var gazetteer: CoreML_Specification_CoreMLModels_Gazetteer {
    get {
      if case .gazetteer(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_Gazetteer()
    }
    set {_uniqueStorage()._type = .gazetteer(newValue)}
  }

  var wordEmbedding: CoreML_Specification_CoreMLModels_WordEmbedding {
    get {
      if case .wordEmbedding(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_WordEmbedding()
    }
    set {_uniqueStorage()._type = .wordEmbedding(newValue)}
  }

  var audioFeaturePrint: CoreML_Specification_CoreMLModels_AudioFeaturePrint {
    get {
      if case .audioFeaturePrint(let v)? = _storage._type {return v}
      return CoreML_Specification_CoreMLModels_AudioFeaturePrint()
    }
    set {_uniqueStorage()._type = .audioFeaturePrint(newValue)}
  }

  /// Reserved private messages start at 3000
  /// These messages are subject to change with no notice or support.
  var serializedModel: CoreML_Specification_SerializedModel {
    get {
      if case .serializedModel(let v)? = _storage._type {return v}
      return CoreML_Specification_SerializedModel()
    }
    set {_uniqueStorage()._type = .serializedModel(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// start at 200 here
  /// model specific parameters:
  enum OneOf_Type: Equatable {
    /// pipeline starts at 200
    case pipelineClassifier(CoreML_Specification_PipelineClassifier)
    case pipelineRegressor(CoreML_Specification_PipelineRegressor)
    case pipeline(CoreML_Specification_Pipeline)
    /// regressors start at 300
    case glmRegressor(CoreML_Specification_GLMRegressor)
    case supportVectorRegressor(CoreML_Specification_SupportVectorRegressor)
    case treeEnsembleRegressor(CoreML_Specification_TreeEnsembleRegressor)
    case neuralNetworkRegressor(CoreML_Specification_NeuralNetworkRegressor)
    case bayesianProbitRegressor(CoreML_Specification_BayesianProbitRegressor)
    /// classifiers start at 400
    case glmClassifier(CoreML_Specification_GLMClassifier)
    case supportVectorClassifier(CoreML_Specification_SupportVectorClassifier)
    case treeEnsembleClassifier(CoreML_Specification_TreeEnsembleClassifier)
    case neuralNetworkClassifier(CoreML_Specification_NeuralNetworkClassifier)
    case kNearestNeighborsClassifier(CoreML_Specification_KNearestNeighborsClassifier)
    /// generic models start at 500
    case neuralNetwork(CoreML_Specification_NeuralNetwork)
    case itemSimilarityRecommender(CoreML_Specification_ItemSimilarityRecommender)
    case mlProgram(CoreML_Specification_MILSpec_Program)
    /// Custom and linked models
    case customModel(CoreML_Specification_CustomModel)
    case linkedModel(CoreML_Specification_LinkedModel)
    /// feature engineering starts at 600
    case oneHotEncoder(CoreML_Specification_OneHotEncoder)
    case imputer(CoreML_Specification_Imputer)
    case featureVectorizer(CoreML_Specification_FeatureVectorizer)
    case dictVectorizer(CoreML_Specification_DictVectorizer)
    case scaler(CoreML_Specification_Scaler)
    case categoricalMapping(CoreML_Specification_CategoricalMapping)
    case normalizer(CoreML_Specification_Normalizer)
    case arrayFeatureExtractor(CoreML_Specification_ArrayFeatureExtractor)
    case nonMaximumSuppression(CoreML_Specification_NonMaximumSuppression)
    /// simple mathematical functions used for testing start at 900
    case identity(CoreML_Specification_Identity)
    /// CoreML provided models
    case textClassifier(CoreML_Specification_CoreMLModels_TextClassifier)
    case wordTagger(CoreML_Specification_CoreMLModels_WordTagger)
    case visionFeaturePrint(CoreML_Specification_CoreMLModels_VisionFeaturePrint)
    case soundAnalysisPreprocessing(CoreML_Specification_CoreMLModels_SoundAnalysisPreprocessing)
    case gazetteer(CoreML_Specification_CoreMLModels_Gazetteer)
    case wordEmbedding(CoreML_Specification_CoreMLModels_WordEmbedding)
    case audioFeaturePrint(CoreML_Specification_CoreMLModels_AudioFeaturePrint)
    /// Reserved private messages start at 3000
    /// These messages are subject to change with no notice or support.
    case serializedModel(CoreML_Specification_SerializedModel)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_Model.OneOf_Type, rhs: CoreML_Specification_Model.OneOf_Type) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.pipelineClassifier, .pipelineClassifier): return {
        guard case .pipelineClassifier(let l) = lhs, case .pipelineClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.pipelineRegressor, .pipelineRegressor): return {
        guard case .pipelineRegressor(let l) = lhs, case .pipelineRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.pipeline, .pipeline): return {
        guard case .pipeline(let l) = lhs, case .pipeline(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.glmRegressor, .glmRegressor): return {
        guard case .glmRegressor(let l) = lhs, case .glmRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.supportVectorRegressor, .supportVectorRegressor): return {
        guard case .supportVectorRegressor(let l) = lhs, case .supportVectorRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.treeEnsembleRegressor, .treeEnsembleRegressor): return {
        guard case .treeEnsembleRegressor(let l) = lhs, case .treeEnsembleRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.neuralNetworkRegressor, .neuralNetworkRegressor): return {
        guard case .neuralNetworkRegressor(let l) = lhs, case .neuralNetworkRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.bayesianProbitRegressor, .bayesianProbitRegressor): return {
        guard case .bayesianProbitRegressor(let l) = lhs, case .bayesianProbitRegressor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.glmClassifier, .glmClassifier): return {
        guard case .glmClassifier(let l) = lhs, case .glmClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.supportVectorClassifier, .supportVectorClassifier): return {
        guard case .supportVectorClassifier(let l) = lhs, case .supportVectorClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.treeEnsembleClassifier, .treeEnsembleClassifier): return {
        guard case .treeEnsembleClassifier(let l) = lhs, case .treeEnsembleClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.neuralNetworkClassifier, .neuralNetworkClassifier): return {
        guard case .neuralNetworkClassifier(let l) = lhs, case .neuralNetworkClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.kNearestNeighborsClassifier, .kNearestNeighborsClassifier): return {
        guard case .kNearestNeighborsClassifier(let l) = lhs, case .kNearestNeighborsClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.neuralNetwork, .neuralNetwork): return {
        guard case .neuralNetwork(let l) = lhs, case .neuralNetwork(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.itemSimilarityRecommender, .itemSimilarityRecommender): return {
        guard case .itemSimilarityRecommender(let l) = lhs, case .itemSimilarityRecommender(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.mlProgram, .mlProgram): return {
        guard case .mlProgram(let l) = lhs, case .mlProgram(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.customModel, .customModel): return {
        guard case .customModel(let l) = lhs, case .customModel(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.linkedModel, .linkedModel): return {
        guard case .linkedModel(let l) = lhs, case .linkedModel(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.oneHotEncoder, .oneHotEncoder): return {
        guard case .oneHotEncoder(let l) = lhs, case .oneHotEncoder(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.imputer, .imputer): return {
        guard case .imputer(let l) = lhs, case .imputer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.featureVectorizer, .featureVectorizer): return {
        guard case .featureVectorizer(let l) = lhs, case .featureVectorizer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.dictVectorizer, .dictVectorizer): return {
        guard case .dictVectorizer(let l) = lhs, case .dictVectorizer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.scaler, .scaler): return {
        guard case .scaler(let l) = lhs, case .scaler(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.categoricalMapping, .categoricalMapping): return {
        guard case .categoricalMapping(let l) = lhs, case .categoricalMapping(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.normalizer, .normalizer): return {
        guard case .normalizer(let l) = lhs, case .normalizer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.arrayFeatureExtractor, .arrayFeatureExtractor): return {
        guard case .arrayFeatureExtractor(let l) = lhs, case .arrayFeatureExtractor(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.nonMaximumSuppression, .nonMaximumSuppression): return {
        guard case .nonMaximumSuppression(let l) = lhs, case .nonMaximumSuppression(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.identity, .identity): return {
        guard case .identity(let l) = lhs, case .identity(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.textClassifier, .textClassifier): return {
        guard case .textClassifier(let l) = lhs, case .textClassifier(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.wordTagger, .wordTagger): return {
        guard case .wordTagger(let l) = lhs, case .wordTagger(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.visionFeaturePrint, .visionFeaturePrint): return {
        guard case .visionFeaturePrint(let l) = lhs, case .visionFeaturePrint(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.soundAnalysisPreprocessing, .soundAnalysisPreprocessing): return {
        guard case .soundAnalysisPreprocessing(let l) = lhs, case .soundAnalysisPreprocessing(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.gazetteer, .gazetteer): return {
        guard case .gazetteer(let l) = lhs, case .gazetteer(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.wordEmbedding, .wordEmbedding): return {
        guard case .wordEmbedding(let l) = lhs, case .wordEmbedding(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.audioFeaturePrint, .audioFeaturePrint): return {
        guard case .audioFeaturePrint(let l) = lhs, case .audioFeaturePrint(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.serializedModel, .serializedModel): return {
        guard case .serializedModel(let l) = lhs, case .serializedModel(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "CoreML.Specification"

extension CoreML_Specification_Pipeline: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Pipeline"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "models"),
    2: .same(proto: "names"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.models) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.names) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.models.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.models, fieldNumber: 1)
    }
    if !self.names.isEmpty {
      try visitor.visitRepeatedStringField(value: self.names, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Pipeline, rhs: CoreML_Specification_Pipeline) -> Bool {
    if lhs.models != rhs.models {return false}
    if lhs.names != rhs.names {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PipelineClassifier: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineClassifier"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "pipeline"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._pipeline) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._pipeline {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PipelineClassifier, rhs: CoreML_Specification_PipelineClassifier) -> Bool {
    if lhs._pipeline != rhs._pipeline {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_PipelineRegressor: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineRegressor"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "pipeline"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._pipeline) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._pipeline {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_PipelineRegressor, rhs: CoreML_Specification_PipelineRegressor) -> Bool {
    if lhs._pipeline != rhs._pipeline {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_FeatureDescription: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".FeatureDescription"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "shortDescription"),
    3: .same(proto: "type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.shortDescription) }()
      case 3: try { try decoder.decodeSingularMessageField(value: &self._type) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.shortDescription.isEmpty {
      try visitor.visitSingularStringField(value: self.shortDescription, fieldNumber: 2)
    }
    try { if let v = self._type {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_FeatureDescription, rhs: CoreML_Specification_FeatureDescription) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.shortDescription != rhs.shortDescription {return false}
    if lhs._type != rhs._type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Metadata: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Metadata"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "shortDescription"),
    2: .same(proto: "versionString"),
    3: .same(proto: "author"),
    4: .same(proto: "license"),
    100: .same(proto: "userDefined"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.shortDescription) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.versionString) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.author) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.license) }()
      case 100: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.userDefined) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.shortDescription.isEmpty {
      try visitor.visitSingularStringField(value: self.shortDescription, fieldNumber: 1)
    }
    if !self.versionString.isEmpty {
      try visitor.visitSingularStringField(value: self.versionString, fieldNumber: 2)
    }
    if !self.author.isEmpty {
      try visitor.visitSingularStringField(value: self.author, fieldNumber: 3)
    }
    if !self.license.isEmpty {
      try visitor.visitSingularStringField(value: self.license, fieldNumber: 4)
    }
    if !self.userDefined.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.userDefined, fieldNumber: 100)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Metadata, rhs: CoreML_Specification_Metadata) -> Bool {
    if lhs.shortDescription != rhs.shortDescription {return false}
    if lhs.versionString != rhs.versionString {return false}
    if lhs.author != rhs.author {return false}
    if lhs.license != rhs.license {return false}
    if lhs.userDefined != rhs.userDefined {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_ModelDescription: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ModelDescription"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "input"),
    10: .same(proto: "output"),
    11: .same(proto: "predictedFeatureName"),
    12: .same(proto: "predictedProbabilitiesName"),
    50: .same(proto: "trainingInput"),
    100: .same(proto: "metadata"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.input) }()
      case 10: try { try decoder.decodeRepeatedMessageField(value: &self.output) }()
      case 11: try { try decoder.decodeSingularStringField(value: &self.predictedFeatureName) }()
      case 12: try { try decoder.decodeSingularStringField(value: &self.predictedProbabilitiesName) }()
      case 50: try { try decoder.decodeRepeatedMessageField(value: &self.trainingInput) }()
      case 100: try { try decoder.decodeSingularMessageField(value: &self._metadata) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.input.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.input, fieldNumber: 1)
    }
    if !self.output.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.output, fieldNumber: 10)
    }
    if !self.predictedFeatureName.isEmpty {
      try visitor.visitSingularStringField(value: self.predictedFeatureName, fieldNumber: 11)
    }
    if !self.predictedProbabilitiesName.isEmpty {
      try visitor.visitSingularStringField(value: self.predictedProbabilitiesName, fieldNumber: 12)
    }
    if !self.trainingInput.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.trainingInput, fieldNumber: 50)
    }
    try { if let v = self._metadata {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 100)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_ModelDescription, rhs: CoreML_Specification_ModelDescription) -> Bool {
    if lhs.input != rhs.input {return false}
    if lhs.output != rhs.output {return false}
    if lhs.predictedFeatureName != rhs.predictedFeatureName {return false}
    if lhs.predictedProbabilitiesName != rhs.predictedProbabilitiesName {return false}
    if lhs.trainingInput != rhs.trainingInput {return false}
    if lhs._metadata != rhs._metadata {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_SerializedModel: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".SerializedModel"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "identifier"),
    2: .same(proto: "model"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.identifier) }()
      case 2: try { try decoder.decodeSingularBytesField(value: &self.model) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.identifier.isEmpty {
      try visitor.visitSingularStringField(value: self.identifier, fieldNumber: 1)
    }
    if !self.model.isEmpty {
      try visitor.visitSingularBytesField(value: self.model, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_SerializedModel, rhs: CoreML_Specification_SerializedModel) -> Bool {
    if lhs.identifier != rhs.identifier {return false}
    if lhs.model != rhs.model {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_Model: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Model"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "specificationVersion"),
    2: .same(proto: "description"),
    10: .same(proto: "isUpdatable"),
    200: .same(proto: "pipelineClassifier"),
    201: .same(proto: "pipelineRegressor"),
    202: .same(proto: "pipeline"),
    300: .same(proto: "glmRegressor"),
    301: .same(proto: "supportVectorRegressor"),
    302: .same(proto: "treeEnsembleRegressor"),
    303: .same(proto: "neuralNetworkRegressor"),
    304: .same(proto: "bayesianProbitRegressor"),
    400: .same(proto: "glmClassifier"),
    401: .same(proto: "supportVectorClassifier"),
    402: .same(proto: "treeEnsembleClassifier"),
    403: .same(proto: "neuralNetworkClassifier"),
    404: .same(proto: "kNearestNeighborsClassifier"),
    500: .same(proto: "neuralNetwork"),
    501: .same(proto: "itemSimilarityRecommender"),
    502: .same(proto: "mlProgram"),
    555: .same(proto: "customModel"),
    556: .same(proto: "linkedModel"),
    600: .same(proto: "oneHotEncoder"),
    601: .same(proto: "imputer"),
    602: .same(proto: "featureVectorizer"),
    603: .same(proto: "dictVectorizer"),
    604: .same(proto: "scaler"),
    606: .same(proto: "categoricalMapping"),
    607: .same(proto: "normalizer"),
    609: .same(proto: "arrayFeatureExtractor"),
    610: .same(proto: "nonMaximumSuppression"),
    900: .same(proto: "identity"),
    2000: .same(proto: "textClassifier"),
    2001: .same(proto: "wordTagger"),
    2002: .same(proto: "visionFeaturePrint"),
    2003: .same(proto: "soundAnalysisPreprocessing"),
    2004: .same(proto: "gazetteer"),
    2005: .same(proto: "wordEmbedding"),
    2006: .same(proto: "audioFeaturePrint"),
    3000: .same(proto: "serializedModel"),
  ]

  fileprivate class _StorageClass {
    var _specificationVersion: Int32 = 0
    var _description_p: CoreML_Specification_ModelDescription? = nil
    var _isUpdatable: Bool = false
    var _type: CoreML_Specification_Model.OneOf_Type?

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _specificationVersion = source._specificationVersion
      _description_p = source._description_p
      _isUpdatable = source._isUpdatable
      _type = source._type
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularInt32Field(value: &_storage._specificationVersion) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._description_p) }()
        case 10: try { try decoder.decodeSingularBoolField(value: &_storage._isUpdatable) }()
        case 200: try {
          var v: CoreML_Specification_PipelineClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .pipelineClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .pipelineClassifier(v)
          }
        }()
        case 201: try {
          var v: CoreML_Specification_PipelineRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .pipelineRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .pipelineRegressor(v)
          }
        }()
        case 202: try {
          var v: CoreML_Specification_Pipeline?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .pipeline(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .pipeline(v)
          }
        }()
        case 300: try {
          var v: CoreML_Specification_GLMRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .glmRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .glmRegressor(v)
          }
        }()
        case 301: try {
          var v: CoreML_Specification_SupportVectorRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .supportVectorRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .supportVectorRegressor(v)
          }
        }()
        case 302: try {
          var v: CoreML_Specification_TreeEnsembleRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .treeEnsembleRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .treeEnsembleRegressor(v)
          }
        }()
        case 303: try {
          var v: CoreML_Specification_NeuralNetworkRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .neuralNetworkRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .neuralNetworkRegressor(v)
          }
        }()
        case 304: try {
          var v: CoreML_Specification_BayesianProbitRegressor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .bayesianProbitRegressor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .bayesianProbitRegressor(v)
          }
        }()
        case 400: try {
          var v: CoreML_Specification_GLMClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .glmClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .glmClassifier(v)
          }
        }()
        case 401: try {
          var v: CoreML_Specification_SupportVectorClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .supportVectorClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .supportVectorClassifier(v)
          }
        }()
        case 402: try {
          var v: CoreML_Specification_TreeEnsembleClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .treeEnsembleClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .treeEnsembleClassifier(v)
          }
        }()
        case 403: try {
          var v: CoreML_Specification_NeuralNetworkClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .neuralNetworkClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .neuralNetworkClassifier(v)
          }
        }()
        case 404: try {
          var v: CoreML_Specification_KNearestNeighborsClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .kNearestNeighborsClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .kNearestNeighborsClassifier(v)
          }
        }()
        case 500: try {
          var v: CoreML_Specification_NeuralNetwork?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .neuralNetwork(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .neuralNetwork(v)
          }
        }()
        case 501: try {
          var v: CoreML_Specification_ItemSimilarityRecommender?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .itemSimilarityRecommender(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .itemSimilarityRecommender(v)
          }
        }()
        case 502: try {
          var v: CoreML_Specification_MILSpec_Program?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .mlProgram(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .mlProgram(v)
          }
        }()
        case 555: try {
          var v: CoreML_Specification_CustomModel?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .customModel(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .customModel(v)
          }
        }()
        case 556: try {
          var v: CoreML_Specification_LinkedModel?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .linkedModel(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .linkedModel(v)
          }
        }()
        case 600: try {
          var v: CoreML_Specification_OneHotEncoder?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .oneHotEncoder(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .oneHotEncoder(v)
          }
        }()
        case 601: try {
          var v: CoreML_Specification_Imputer?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .imputer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .imputer(v)
          }
        }()
        case 602: try {
          var v: CoreML_Specification_FeatureVectorizer?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .featureVectorizer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .featureVectorizer(v)
          }
        }()
        case 603: try {
          var v: CoreML_Specification_DictVectorizer?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .dictVectorizer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .dictVectorizer(v)
          }
        }()
        case 604: try {
          var v: CoreML_Specification_Scaler?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .scaler(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .scaler(v)
          }
        }()
        case 606: try {
          var v: CoreML_Specification_CategoricalMapping?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .categoricalMapping(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .categoricalMapping(v)
          }
        }()
        case 607: try {
          var v: CoreML_Specification_Normalizer?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .normalizer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .normalizer(v)
          }
        }()
        case 609: try {
          var v: CoreML_Specification_ArrayFeatureExtractor?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .arrayFeatureExtractor(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .arrayFeatureExtractor(v)
          }
        }()
        case 610: try {
          var v: CoreML_Specification_NonMaximumSuppression?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .nonMaximumSuppression(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .nonMaximumSuppression(v)
          }
        }()
        case 900: try {
          var v: CoreML_Specification_Identity?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .identity(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .identity(v)
          }
        }()
        case 2000: try {
          var v: CoreML_Specification_CoreMLModels_TextClassifier?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .textClassifier(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .textClassifier(v)
          }
        }()
        case 2001: try {
          var v: CoreML_Specification_CoreMLModels_WordTagger?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .wordTagger(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .wordTagger(v)
          }
        }()
        case 2002: try {
          var v: CoreML_Specification_CoreMLModels_VisionFeaturePrint?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .visionFeaturePrint(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .visionFeaturePrint(v)
          }
        }()
        case 2003: try {
          var v: CoreML_Specification_CoreMLModels_SoundAnalysisPreprocessing?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .soundAnalysisPreprocessing(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .soundAnalysisPreprocessing(v)
          }
        }()
        case 2004: try {
          var v: CoreML_Specification_CoreMLModels_Gazetteer?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .gazetteer(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .gazetteer(v)
          }
        }()
        case 2005: try {
          var v: CoreML_Specification_CoreMLModels_WordEmbedding?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .wordEmbedding(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .wordEmbedding(v)
          }
        }()
        case 2006: try {
          var v: CoreML_Specification_CoreMLModels_AudioFeaturePrint?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .audioFeaturePrint(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .audioFeaturePrint(v)
          }
        }()
        case 3000: try {
          var v: CoreML_Specification_SerializedModel?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .serializedModel(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .serializedModel(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      if _storage._specificationVersion != 0 {
        try visitor.visitSingularInt32Field(value: _storage._specificationVersion, fieldNumber: 1)
      }
      try { if let v = _storage._description_p {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
      if _storage._isUpdatable != false {
        try visitor.visitSingularBoolField(value: _storage._isUpdatable, fieldNumber: 10)
      }
      switch _storage._type {
      case .pipelineClassifier?: try {
        guard case .pipelineClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 200)
      }()
      case .pipelineRegressor?: try {
        guard case .pipelineRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 201)
      }()
      case .pipeline?: try {
        guard case .pipeline(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 202)
      }()
      case .glmRegressor?: try {
        guard case .glmRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 300)
      }()
      case .supportVectorRegressor?: try {
        guard case .supportVectorRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 301)
      }()
      case .treeEnsembleRegressor?: try {
        guard case .treeEnsembleRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 302)
      }()
      case .neuralNetworkRegressor?: try {
        guard case .neuralNetworkRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 303)
      }()
      case .bayesianProbitRegressor?: try {
        guard case .bayesianProbitRegressor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 304)
      }()
      case .glmClassifier?: try {
        guard case .glmClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 400)
      }()
      case .supportVectorClassifier?: try {
        guard case .supportVectorClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 401)
      }()
      case .treeEnsembleClassifier?: try {
        guard case .treeEnsembleClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 402)
      }()
      case .neuralNetworkClassifier?: try {
        guard case .neuralNetworkClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 403)
      }()
      case .kNearestNeighborsClassifier?: try {
        guard case .kNearestNeighborsClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 404)
      }()
      case .neuralNetwork?: try {
        guard case .neuralNetwork(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 500)
      }()
      case .itemSimilarityRecommender?: try {
        guard case .itemSimilarityRecommender(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 501)
      }()
      case .mlProgram?: try {
        guard case .mlProgram(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 502)
      }()
      case .customModel?: try {
        guard case .customModel(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 555)
      }()
      case .linkedModel?: try {
        guard case .linkedModel(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 556)
      }()
      case .oneHotEncoder?: try {
        guard case .oneHotEncoder(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 600)
      }()
      case .imputer?: try {
        guard case .imputer(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 601)
      }()
      case .featureVectorizer?: try {
        guard case .featureVectorizer(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 602)
      }()
      case .dictVectorizer?: try {
        guard case .dictVectorizer(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 603)
      }()
      case .scaler?: try {
        guard case .scaler(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 604)
      }()
      case .categoricalMapping?: try {
        guard case .categoricalMapping(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 606)
      }()
      case .normalizer?: try {
        guard case .normalizer(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 607)
      }()
      case .arrayFeatureExtractor?: try {
        guard case .arrayFeatureExtractor(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 609)
      }()
      case .nonMaximumSuppression?: try {
        guard case .nonMaximumSuppression(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 610)
      }()
      case .identity?: try {
        guard case .identity(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 900)
      }()
      case .textClassifier?: try {
        guard case .textClassifier(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2000)
      }()
      case .wordTagger?: try {
        guard case .wordTagger(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2001)
      }()
      case .visionFeaturePrint?: try {
        guard case .visionFeaturePrint(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2002)
      }()
      case .soundAnalysisPreprocessing?: try {
        guard case .soundAnalysisPreprocessing(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2003)
      }()
      case .gazetteer?: try {
        guard case .gazetteer(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2004)
      }()
      case .wordEmbedding?: try {
        guard case .wordEmbedding(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2005)
      }()
      case .audioFeaturePrint?: try {
        guard case .audioFeaturePrint(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2006)
      }()
      case .serializedModel?: try {
        guard case .serializedModel(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3000)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_Model, rhs: CoreML_Specification_Model) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._specificationVersion != rhs_storage._specificationVersion {return false}
        if _storage._description_p != rhs_storage._description_p {return false}
        if _storage._isUpdatable != rhs_storage._isUpdatable {return false}
        if _storage._type != rhs_storage._type {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
