// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: MIL.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

// Copyright (c) 2019, Apple Inc. All rights reserved.
//
// Use of this source code is governed by a BSD-3-clause license that can be
// found in LICENSE.txt or at https://opensource.org/licenses/BSD-3-Clause

//
// - A Program is the container with following information
//     - set of functions: Function defines a program block to be executed
//     - A model can have multiple functions defined and will have a single point of entry.
// - A Function consists of
//     - List of named inputs and output types
//     - A block defining scope for a function - similar to a function in C/C++
// - A Block consists of 
//     - List of named inputs and output names
//     - Topologically sorted Ops
// - A Op consists of
//     - List of named inputs and outputs (name, type) pair
//     - Optionally, blocks for Control-Flow
//
// Programs, functions, blocks, ops, and tensor types all can contain an optional set of attributes.
//
// == Identifiers ==
// Identifiers, generally used for names and keys, must match the
// regular expression [A-Za-z\_][A-Za-z0-9\_@]*

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// Supported data types
enum CoreML_Specification_MILSpec_DataType: SwiftProtobuf.Enum {
  typealias RawValue = Int

  /// 0-10 reserved for special types
  case unusedType // = 0
  case bool // = 1

  /// arbitrary sequence of bytes
  case string // = 2

  /// Floats
  case float16 // = 10
  case float32 // = 11
  case float64 // = 12

  /// Ints
  case int8 // = 21
  case int16 // = 22
  case int32 // = 23
  case int64 // = 24

  /// UInts
  case uint8 // = 31
  case uint16 // = 32
  case uint32 // = 33
  case uint64 // = 34
  case UNRECOGNIZED(Int)

  init() {
    self = .unusedType
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unusedType
    case 1: self = .bool
    case 2: self = .string
    case 10: self = .float16
    case 11: self = .float32
    case 12: self = .float64
    case 21: self = .int8
    case 22: self = .int16
    case 23: self = .int32
    case 24: self = .int64
    case 31: self = .uint8
    case 32: self = .uint16
    case 33: self = .uint32
    case 34: self = .uint64
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unusedType: return 0
    case .bool: return 1
    case .string: return 2
    case .float16: return 10
    case .float32: return 11
    case .float64: return 12
    case .int8: return 21
    case .int16: return 22
    case .int32: return 23
    case .int64: return 24
    case .uint8: return 31
    case .uint16: return 32
    case .uint32: return 33
    case .uint64: return 34
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension CoreML_Specification_MILSpec_DataType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [CoreML_Specification_MILSpec_DataType] = [
    .unusedType,
    .bool,
    .string,
    .float16,
    .float32,
    .float64,
    .int8,
    .int16,
    .int32,
    .int64,
    .uint8,
    .uint16,
    .uint32,
    .uint64,
  ]
}

#endif  // swift(>=4.2)

/// The top level container.
struct CoreML_Specification_MILSpec_Program {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var version: Int64 = 0

  /// Must be unique within the containing program
  /// Names must be valid identifiers as described above.
  var functions: Dictionary<String,CoreML_Specification_MILSpec_Function> = [:]

  var docString: String = String()

  /// Any other attributes not described by other fields.
  /// Keys must be valid identifiers as described above.
  var attributes: Dictionary<String,CoreML_Specification_MILSpec_Value> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// A program-level function.
struct CoreML_Specification_MILSpec_Function {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Function inputs are unordered (name, ValueType) pairs.
  /// Inputs intended to process images must be rank-4 Float32 tensors. Dimensions
  /// are interpreted as NCHW, with N == 1 and C being 1 for grayscale and 3 for RGB.
  /// Names must be valid identifiers as described above.
  var inputs: [CoreML_Specification_MILSpec_NamedValueType] = []

  /// The active block is drawn from this named specialization.
  /// This key must exist in `block_specializations`.
  var opset: String = String()

  /// Named specializations of this function.
  ///
  /// Specialization keys are the name of the opset that the
  /// function specialization is written in. They must be valid
  /// identifiers as described above.
  ///
  /// Outputs from all blocks must match. They define the outputs
  /// of the function.
  /// Each block inherits the lexical scope from the function.
  var blockSpecializations: Dictionary<String,CoreML_Specification_MILSpec_Block> = [:]

  /// Any other attributes not described by other fields.
  /// Keys must be valid identifiers as described above.
  var attributes: Dictionary<String,CoreML_Specification_MILSpec_Value> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// A basic block with a single entry and exit in SSA form.
struct CoreML_Specification_MILSpec_Block {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Infrequently used, these are for operators that may need to give
  /// block-local names to input values (e.g. while_loop).
  var inputs: [CoreML_Specification_MILSpec_NamedValueType] = []

  /// The names to give to values returned by this block. They must be
  /// identifiers as described above.
  ///
  /// ValueType of outputs[i] is Operation[j].outputs[k].type where 
  /// i, j and k are indices of block output, block Operation and
  /// jth operation's output respectively.
  /// this is due to
  /// 1. An operation can have more than one output
  /// 2. Any one of operation's output could be potentially block's output
  var outputs: [String] = []

  var operations: [CoreML_Specification_MILSpec_Operation] = []

  /// Any other attributes not described by other fields.
  /// Keys must be valid identifiers as described above.
  var attributes: Dictionary<String,CoreML_Specification_MILSpec_Value> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Argument is list of Binding to either name or value
struct CoreML_Specification_MILSpec_Argument {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var arguments: [CoreML_Specification_MILSpec_Argument.Binding] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct Binding {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var binding: CoreML_Specification_MILSpec_Argument.Binding.OneOf_Binding? = nil

    /// The name of a previously defined value.
    var name: String {
      get {
        if case .name(let v)? = binding {return v}
        return String()
      }
      set {binding = .name(newValue)}
    }

    /// A compile time constant.
    var value: CoreML_Specification_MILSpec_Value {
      get {
        if case .value(let v)? = binding {return v}
        return CoreML_Specification_MILSpec_Value()
      }
      set {binding = .value(newValue)}
    }

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_Binding: Equatable {
      /// The name of a previously defined value.
      case name(String)
      /// A compile time constant.
      case value(CoreML_Specification_MILSpec_Value)

    #if !swift(>=4.1)
      static func ==(lhs: CoreML_Specification_MILSpec_Argument.Binding.OneOf_Binding, rhs: CoreML_Specification_MILSpec_Argument.Binding.OneOf_Binding) -> Bool {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch (lhs, rhs) {
        case (.name, .name): return {
          guard case .name(let l) = lhs, case .name(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.value, .value): return {
          guard case .value(let l) = lhs, case .value(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        default: return false
        }
      }
    #endif
    }

    init() {}
  }

  init() {}
}

/// A single operation/node/layer.
struct CoreML_Specification_MILSpec_Operation {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Examples: "convolution", "cropResize". Operation type defines the
  /// expected inputs and output.
  var type: String = String()

  /// Operator arguments
  ///
  /// Key: parameter name
  /// Value: Argument (list of bindings)
  ///
  /// Value is list of argument binding to given parameter
  /// Binding can be a string name (previous operation output or input given to model/block/function)
  ///             or a Value (known compile time value for given operation)
  /// Argument can be of length 1 (general) or variable length (e.g. concat layer)
  /// e.g. {'stride' : ['input_01']}
  /// e.g. {'x' : ['input_01', 'input_02', 'input_03', false]}
  var inputs: Dictionary<String,CoreML_Specification_MILSpec_Argument> = [:]

  /// Names to which to bind values returned by this operation.
  /// Names must be:
  ///  (*) valid identifiers as described above; and
  ///  (*) unique within the current scope.
  var outputs: [CoreML_Specification_MILSpec_NamedValueType] = []

  /// Nested blocks for loops and conditionals. For example,
  /// a conditional block will have two entries here.
  var blocks: [CoreML_Specification_MILSpec_Block] = []

  /// Any other information not captured by other fields.
  /// Keys must be valid identifiers as described above.
  var attributes: Dictionary<String,CoreML_Specification_MILSpec_Value> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Named Value parameters
/// (name, type) pair
struct CoreML_Specification_MILSpec_NamedValueType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The name of this parameter; must be a valid identifier as described above.
  var name: String = String()

  /// This parameter's required type.
  var type: CoreML_Specification_MILSpec_ValueType {
    get {return _type ?? CoreML_Specification_MILSpec_ValueType()}
    set {_type = newValue}
  }
  /// Returns true if `type` has been explicitly set.
  var hasType: Bool {return self._type != nil}
  /// Clears the value of `type`. Subsequent reads from it will return its default value.
  mutating func clearType() {self._type = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _type: CoreML_Specification_MILSpec_ValueType? = nil
}

/// A type of any kind
struct CoreML_Specification_MILSpec_ValueType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var type: OneOf_Type? {
    get {return _storage._type}
    set {_uniqueStorage()._type = newValue}
  }

  var tensorType: CoreML_Specification_MILSpec_TensorType {
    get {
      if case .tensorType(let v)? = _storage._type {return v}
      return CoreML_Specification_MILSpec_TensorType()
    }
    set {_uniqueStorage()._type = .tensorType(newValue)}
  }

  var listType: CoreML_Specification_MILSpec_ListType {
    get {
      if case .listType(let v)? = _storage._type {return v}
      return CoreML_Specification_MILSpec_ListType()
    }
    set {_uniqueStorage()._type = .listType(newValue)}
  }

  var tupleType: CoreML_Specification_MILSpec_TupleType {
    get {
      if case .tupleType(let v)? = _storage._type {return v}
      return CoreML_Specification_MILSpec_TupleType()
    }
    set {_uniqueStorage()._type = .tupleType(newValue)}
  }

  var dictionaryType: CoreML_Specification_MILSpec_DictionaryType {
    get {
      if case .dictionaryType(let v)? = _storage._type {return v}
      return CoreML_Specification_MILSpec_DictionaryType()
    }
    set {_uniqueStorage()._type = .dictionaryType(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Type: Equatable {
    case tensorType(CoreML_Specification_MILSpec_TensorType)
    case listType(CoreML_Specification_MILSpec_ListType)
    case tupleType(CoreML_Specification_MILSpec_TupleType)
    case dictionaryType(CoreML_Specification_MILSpec_DictionaryType)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_MILSpec_ValueType.OneOf_Type, rhs: CoreML_Specification_MILSpec_ValueType.OneOf_Type) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.tensorType, .tensorType): return {
        guard case .tensorType(let l) = lhs, case .tensorType(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.listType, .listType): return {
        guard case .listType(let l) = lhs, case .listType(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.tupleType, .tupleType): return {
        guard case .tupleType(let l) = lhs, case .tupleType(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.dictionaryType, .dictionaryType): return {
        guard case .dictionaryType(let l) = lhs, case .dictionaryType(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct CoreML_Specification_MILSpec_TensorType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The data type stored in a tensor of this type
  var dataType: CoreML_Specification_MILSpec_DataType = .unusedType

  /// The number of dimensions in the tensor shape. rank == -1 implies
  /// variable (not fixed) rank
  var rank: Int64 = 0

  /// Tensor shape values; must be of length "rank"
  var dimensions: [CoreML_Specification_MILSpec_Dimension] = []

  /// Any other tensor type attributes not described by other fields.
  /// Keys must be valid identifiers in MIL text syntax.
  var attributes: Dictionary<String,CoreML_Specification_MILSpec_Value> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_MILSpec_TupleType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Recursively define TupleType from ValueType.
  var types: [CoreML_Specification_MILSpec_ValueType] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_MILSpec_ListType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The type of element stored in a list of this type
  var type: CoreML_Specification_MILSpec_ValueType {
    get {return _storage._type ?? CoreML_Specification_MILSpec_ValueType()}
    set {_uniqueStorage()._type = newValue}
  }
  /// Returns true if `type` has been explicitly set.
  var hasType: Bool {return _storage._type != nil}
  /// Clears the value of `type`. Subsequent reads from it will return its default value.
  mutating func clearType() {_uniqueStorage()._type = nil}

  /// The number of elements in a list of this type. May be unknown (variable length)
  var length: CoreML_Specification_MILSpec_Dimension {
    get {return _storage._length ?? CoreML_Specification_MILSpec_Dimension()}
    set {_uniqueStorage()._length = newValue}
  }
  /// Returns true if `length` has been explicitly set.
  var hasLength: Bool {return _storage._length != nil}
  /// Clears the value of `length`. Subsequent reads from it will return its default value.
  mutating func clearLength() {_uniqueStorage()._length = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

/// An unordered key-value mapping
struct CoreML_Specification_MILSpec_DictionaryType {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var keyType: CoreML_Specification_MILSpec_ValueType {
    get {return _storage._keyType ?? CoreML_Specification_MILSpec_ValueType()}
    set {_uniqueStorage()._keyType = newValue}
  }
  /// Returns true if `keyType` has been explicitly set.
  var hasKeyType: Bool {return _storage._keyType != nil}
  /// Clears the value of `keyType`. Subsequent reads from it will return its default value.
  mutating func clearKeyType() {_uniqueStorage()._keyType = nil}

  var valueType: CoreML_Specification_MILSpec_ValueType {
    get {return _storage._valueType ?? CoreML_Specification_MILSpec_ValueType()}
    set {_uniqueStorage()._valueType = newValue}
  }
  /// Returns true if `valueType` has been explicitly set.
  var hasValueType: Bool {return _storage._valueType != nil}
  /// Clears the value of `valueType`. Subsequent reads from it will return its default value.
  mutating func clearValueType() {_uniqueStorage()._valueType = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

struct CoreML_Specification_MILSpec_Dimension {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var dimension: CoreML_Specification_MILSpec_Dimension.OneOf_Dimension? = nil

  var constant: CoreML_Specification_MILSpec_Dimension.ConstantDimension {
    get {
      if case .constant(let v)? = dimension {return v}
      return CoreML_Specification_MILSpec_Dimension.ConstantDimension()
    }
    set {dimension = .constant(newValue)}
  }

  var unknown: CoreML_Specification_MILSpec_Dimension.UnknownDimension {
    get {
      if case .unknown(let v)? = dimension {return v}
      return CoreML_Specification_MILSpec_Dimension.UnknownDimension()
    }
    set {dimension = .unknown(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Dimension: Equatable {
    case constant(CoreML_Specification_MILSpec_Dimension.ConstantDimension)
    case unknown(CoreML_Specification_MILSpec_Dimension.UnknownDimension)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_MILSpec_Dimension.OneOf_Dimension, rhs: CoreML_Specification_MILSpec_Dimension.OneOf_Dimension) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.constant, .constant): return {
        guard case .constant(let l) = lhs, case .constant(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.unknown, .unknown): return {
        guard case .unknown(let l) = lhs, case .unknown(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  struct ConstantDimension {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var size: UInt64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct UnknownDimension {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var variadic: Bool = false

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

/// See Variable vs Value primer above.
struct CoreML_Specification_MILSpec_Value {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// optional human-readable texts.
  var docString: String = String()

  var type: CoreML_Specification_MILSpec_ValueType {
    get {return _type ?? CoreML_Specification_MILSpec_ValueType()}
    set {_type = newValue}
  }
  /// Returns true if `type` has been explicitly set.
  var hasType: Bool {return self._type != nil}
  /// Clears the value of `type`. Subsequent reads from it will return its default value.
  mutating func clearType() {self._type = nil}

  var value: CoreML_Specification_MILSpec_Value.OneOf_Value? = nil

  var immediateValue: CoreML_Specification_MILSpec_Value.ImmediateValue {
    get {
      if case .immediateValue(let v)? = value {return v}
      return CoreML_Specification_MILSpec_Value.ImmediateValue()
    }
    set {value = .immediateValue(newValue)}
  }

  var blobFileValue: CoreML_Specification_MILSpec_Value.BlobFileValue {
    get {
      if case .blobFileValue(let v)? = value {return v}
      return CoreML_Specification_MILSpec_Value.BlobFileValue()
    }
    set {value = .blobFileValue(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Value: Equatable {
    case immediateValue(CoreML_Specification_MILSpec_Value.ImmediateValue)
    case blobFileValue(CoreML_Specification_MILSpec_Value.BlobFileValue)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_MILSpec_Value.OneOf_Value, rhs: CoreML_Specification_MILSpec_Value.OneOf_Value) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.immediateValue, .immediateValue): return {
        guard case .immediateValue(let l) = lhs, case .immediateValue(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.blobFileValue, .blobFileValue): return {
        guard case .blobFileValue(let l) = lhs, case .blobFileValue(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  /// An immediate value stored within the proto
  struct ImmediateValue {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var value: CoreML_Specification_MILSpec_Value.ImmediateValue.OneOf_Value? = nil

    var tensor: CoreML_Specification_MILSpec_TensorValue {
      get {
        if case .tensor(let v)? = value {return v}
        return CoreML_Specification_MILSpec_TensorValue()
      }
      set {value = .tensor(newValue)}
    }

    var tuple: CoreML_Specification_MILSpec_TupleValue {
      get {
        if case .tuple(let v)? = value {return v}
        return CoreML_Specification_MILSpec_TupleValue()
      }
      set {value = .tuple(newValue)}
    }

    var list: CoreML_Specification_MILSpec_ListValue {
      get {
        if case .list(let v)? = value {return v}
        return CoreML_Specification_MILSpec_ListValue()
      }
      set {value = .list(newValue)}
    }

    var dictionary: CoreML_Specification_MILSpec_DictionaryValue {
      get {
        if case .dictionary(let v)? = value {return v}
        return CoreML_Specification_MILSpec_DictionaryValue()
      }
      set {value = .dictionary(newValue)}
    }

    var unknownFields = SwiftProtobuf.UnknownStorage()

    enum OneOf_Value: Equatable {
      case tensor(CoreML_Specification_MILSpec_TensorValue)
      case tuple(CoreML_Specification_MILSpec_TupleValue)
      case list(CoreML_Specification_MILSpec_ListValue)
      case dictionary(CoreML_Specification_MILSpec_DictionaryValue)

    #if !swift(>=4.1)
      static func ==(lhs: CoreML_Specification_MILSpec_Value.ImmediateValue.OneOf_Value, rhs: CoreML_Specification_MILSpec_Value.ImmediateValue.OneOf_Value) -> Bool {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch (lhs, rhs) {
        case (.tensor, .tensor): return {
          guard case .tensor(let l) = lhs, case .tensor(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.tuple, .tuple): return {
          guard case .tuple(let l) = lhs, case .tuple(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.list, .list): return {
          guard case .list(let l) = lhs, case .list(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        case (.dictionary, .dictionary): return {
          guard case .dictionary(let l) = lhs, case .dictionary(let r) = rhs else { preconditionFailure() }
          return l == r
        }()
        default: return false
        }
      }
    #endif
    }

    init() {}
  }

  /// Reference to a "blob v2" storage file
  struct BlobFileValue {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// name of file
    var fileName: String = String()

    /// byte offset to metadata
    var offset: UInt64 = 0

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}

  fileprivate var _type: CoreML_Specification_MILSpec_ValueType? = nil
}

struct CoreML_Specification_MILSpec_TensorValue {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var value: CoreML_Specification_MILSpec_TensorValue.OneOf_Value? = nil

  var floats: CoreML_Specification_MILSpec_TensorValue.RepeatedFloats {
    get {
      if case .floats(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedFloats()
    }
    set {value = .floats(newValue)}
  }

  var ints: CoreML_Specification_MILSpec_TensorValue.RepeatedInts {
    get {
      if case .ints(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedInts()
    }
    set {value = .ints(newValue)}
  }

  var bools: CoreML_Specification_MILSpec_TensorValue.RepeatedBools {
    get {
      if case .bools(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedBools()
    }
    set {value = .bools(newValue)}
  }

  var strings: CoreML_Specification_MILSpec_TensorValue.RepeatedStrings {
    get {
      if case .strings(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedStrings()
    }
    set {value = .strings(newValue)}
  }

  var longInts: CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts {
    get {
      if case .longInts(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts()
    }
    set {value = .longInts(newValue)}
  }

  var doubles: CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles {
    get {
      if case .doubles(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles()
    }
    set {value = .doubles(newValue)}
  }

  var bytes: CoreML_Specification_MILSpec_TensorValue.RepeatedBytes {
    get {
      if case .bytes(let v)? = value {return v}
      return CoreML_Specification_MILSpec_TensorValue.RepeatedBytes()
    }
    set {value = .bytes(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_Value: Equatable {
    case floats(CoreML_Specification_MILSpec_TensorValue.RepeatedFloats)
    case ints(CoreML_Specification_MILSpec_TensorValue.RepeatedInts)
    case bools(CoreML_Specification_MILSpec_TensorValue.RepeatedBools)
    case strings(CoreML_Specification_MILSpec_TensorValue.RepeatedStrings)
    case longInts(CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts)
    case doubles(CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles)
    case bytes(CoreML_Specification_MILSpec_TensorValue.RepeatedBytes)

  #if !swift(>=4.1)
    static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.OneOf_Value, rhs: CoreML_Specification_MILSpec_TensorValue.OneOf_Value) -> Bool {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch (lhs, rhs) {
      case (.floats, .floats): return {
        guard case .floats(let l) = lhs, case .floats(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.ints, .ints): return {
        guard case .ints(let l) = lhs, case .ints(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.bools, .bools): return {
        guard case .bools(let l) = lhs, case .bools(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.strings, .strings): return {
        guard case .strings(let l) = lhs, case .strings(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.longInts, .longInts): return {
        guard case .longInts(let l) = lhs, case .longInts(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.doubles, .doubles): return {
        guard case .doubles(let l) = lhs, case .doubles(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      case (.bytes, .bytes): return {
        guard case .bytes(let l) = lhs, case .bytes(let r) = rhs else { preconditionFailure() }
        return l == r
      }()
      default: return false
      }
    }
  #endif
  }

  struct RepeatedFloats {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Float] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedDoubles {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Double] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedInts {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Int32] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedLongInts {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Int64] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedBools {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [Bool] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedStrings {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: [String] = []

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  struct RepeatedBytes {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var values: Data = Data()

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}
  }

  init() {}
}

struct CoreML_Specification_MILSpec_TupleValue {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Comment: TupleValue is recursively defined from Value.
  var values: [CoreML_Specification_MILSpec_Value] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_MILSpec_ListValue {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [CoreML_Specification_MILSpec_Value] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct CoreML_Specification_MILSpec_DictionaryValue {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [CoreML_Specification_MILSpec_DictionaryValue.KeyValuePair] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  struct KeyValuePair {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    var key: CoreML_Specification_MILSpec_Value {
      get {return _key ?? CoreML_Specification_MILSpec_Value()}
      set {_key = newValue}
    }
    /// Returns true if `key` has been explicitly set.
    var hasKey: Bool {return self._key != nil}
    /// Clears the value of `key`. Subsequent reads from it will return its default value.
    mutating func clearKey() {self._key = nil}

    var value: CoreML_Specification_MILSpec_Value {
      get {return _value ?? CoreML_Specification_MILSpec_Value()}
      set {_value = newValue}
    }
    /// Returns true if `value` has been explicitly set.
    var hasValue: Bool {return self._value != nil}
    /// Clears the value of `value`. Subsequent reads from it will return its default value.
    mutating func clearValue() {self._value = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _key: CoreML_Specification_MILSpec_Value? = nil
    fileprivate var _value: CoreML_Specification_MILSpec_Value? = nil
  }

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "CoreML.Specification.MILSpec"

extension CoreML_Specification_MILSpec_DataType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "UNUSED_TYPE"),
    1: .same(proto: "BOOL"),
    2: .same(proto: "STRING"),
    10: .same(proto: "FLOAT16"),
    11: .same(proto: "FLOAT32"),
    12: .same(proto: "FLOAT64"),
    21: .same(proto: "INT8"),
    22: .same(proto: "INT16"),
    23: .same(proto: "INT32"),
    24: .same(proto: "INT64"),
    31: .same(proto: "UINT8"),
    32: .same(proto: "UINT16"),
    33: .same(proto: "UINT32"),
    34: .same(proto: "UINT64"),
  ]
}

extension CoreML_Specification_MILSpec_Program: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Program"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "version"),
    2: .same(proto: "functions"),
    3: .same(proto: "docString"),
    4: .same(proto: "attributes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt64Field(value: &self.version) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Function>.self, value: &self.functions) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.docString) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: &self.attributes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.version != 0 {
      try visitor.visitSingularInt64Field(value: self.version, fieldNumber: 1)
    }
    if !self.functions.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Function>.self, value: self.functions, fieldNumber: 2)
    }
    if !self.docString.isEmpty {
      try visitor.visitSingularStringField(value: self.docString, fieldNumber: 3)
    }
    if !self.attributes.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: self.attributes, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Program, rhs: CoreML_Specification_MILSpec_Program) -> Bool {
    if lhs.version != rhs.version {return false}
    if lhs.functions != rhs.functions {return false}
    if lhs.docString != rhs.docString {return false}
    if lhs.attributes != rhs.attributes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Function: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Function"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputs"),
    2: .same(proto: "opset"),
    3: .standard(proto: "block_specializations"),
    4: .same(proto: "attributes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.inputs) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.opset) }()
      case 3: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Block>.self, value: &self.blockSpecializations) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: &self.attributes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.inputs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.inputs, fieldNumber: 1)
    }
    if !self.opset.isEmpty {
      try visitor.visitSingularStringField(value: self.opset, fieldNumber: 2)
    }
    if !self.blockSpecializations.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Block>.self, value: self.blockSpecializations, fieldNumber: 3)
    }
    if !self.attributes.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: self.attributes, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Function, rhs: CoreML_Specification_MILSpec_Function) -> Bool {
    if lhs.inputs != rhs.inputs {return false}
    if lhs.opset != rhs.opset {return false}
    if lhs.blockSpecializations != rhs.blockSpecializations {return false}
    if lhs.attributes != rhs.attributes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Block: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Block"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "inputs"),
    2: .same(proto: "outputs"),
    3: .same(proto: "operations"),
    4: .same(proto: "attributes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.inputs) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.outputs) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.operations) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: &self.attributes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.inputs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.inputs, fieldNumber: 1)
    }
    if !self.outputs.isEmpty {
      try visitor.visitRepeatedStringField(value: self.outputs, fieldNumber: 2)
    }
    if !self.operations.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.operations, fieldNumber: 3)
    }
    if !self.attributes.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: self.attributes, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Block, rhs: CoreML_Specification_MILSpec_Block) -> Bool {
    if lhs.inputs != rhs.inputs {return false}
    if lhs.outputs != rhs.outputs {return false}
    if lhs.operations != rhs.operations {return false}
    if lhs.attributes != rhs.attributes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Argument: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Argument"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "arguments"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.arguments) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.arguments.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.arguments, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Argument, rhs: CoreML_Specification_MILSpec_Argument) -> Bool {
    if lhs.arguments != rhs.arguments {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Argument.Binding: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_Argument.protoMessageName + ".Binding"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: String?
        try decoder.decodeSingularStringField(value: &v)
        if let v = v {
          if self.binding != nil {try decoder.handleConflictingOneOf()}
          self.binding = .name(v)
        }
      }()
      case 2: try {
        var v: CoreML_Specification_MILSpec_Value?
        var hadOneofValue = false
        if let current = self.binding {
          hadOneofValue = true
          if case .value(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.binding = .value(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.binding {
    case .name?: try {
      guard case .name(let v)? = self.binding else { preconditionFailure() }
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    }()
    case .value?: try {
      guard case .value(let v)? = self.binding else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Argument.Binding, rhs: CoreML_Specification_MILSpec_Argument.Binding) -> Bool {
    if lhs.binding != rhs.binding {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Operation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Operation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "inputs"),
    3: .same(proto: "outputs"),
    4: .same(proto: "blocks"),
    5: .same(proto: "attributes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.type) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Argument>.self, value: &self.inputs) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.outputs) }()
      case 4: try { try decoder.decodeRepeatedMessageField(value: &self.blocks) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: &self.attributes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.type.isEmpty {
      try visitor.visitSingularStringField(value: self.type, fieldNumber: 1)
    }
    if !self.inputs.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Argument>.self, value: self.inputs, fieldNumber: 2)
    }
    if !self.outputs.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.outputs, fieldNumber: 3)
    }
    if !self.blocks.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.blocks, fieldNumber: 4)
    }
    if !self.attributes.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: self.attributes, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Operation, rhs: CoreML_Specification_MILSpec_Operation) -> Bool {
    if lhs.type != rhs.type {return false}
    if lhs.inputs != rhs.inputs {return false}
    if lhs.outputs != rhs.outputs {return false}
    if lhs.blocks != rhs.blocks {return false}
    if lhs.attributes != rhs.attributes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_NamedValueType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".NamedValueType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._type) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    try { if let v = self._type {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_NamedValueType, rhs: CoreML_Specification_MILSpec_NamedValueType) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs._type != rhs._type {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_ValueType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ValueType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "tensorType"),
    2: .same(proto: "listType"),
    3: .same(proto: "tupleType"),
    4: .same(proto: "dictionaryType"),
  ]

  fileprivate class _StorageClass {
    var _type: CoreML_Specification_MILSpec_ValueType.OneOf_Type?

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _type = source._type
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try {
          var v: CoreML_Specification_MILSpec_TensorType?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .tensorType(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .tensorType(v)
          }
        }()
        case 2: try {
          var v: CoreML_Specification_MILSpec_ListType?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .listType(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .listType(v)
          }
        }()
        case 3: try {
          var v: CoreML_Specification_MILSpec_TupleType?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .tupleType(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .tupleType(v)
          }
        }()
        case 4: try {
          var v: CoreML_Specification_MILSpec_DictionaryType?
          var hadOneofValue = false
          if let current = _storage._type {
            hadOneofValue = true
            if case .dictionaryType(let m) = current {v = m}
          }
          try decoder.decodeSingularMessageField(value: &v)
          if let v = v {
            if hadOneofValue {try decoder.handleConflictingOneOf()}
            _storage._type = .dictionaryType(v)
          }
        }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      switch _storage._type {
      case .tensorType?: try {
        guard case .tensorType(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      }()
      case .listType?: try {
        guard case .listType(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      }()
      case .tupleType?: try {
        guard case .tupleType(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      }()
      case .dictionaryType?: try {
        guard case .dictionaryType(let v)? = _storage._type else { preconditionFailure() }
        try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
      }()
      case nil: break
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_ValueType, rhs: CoreML_Specification_MILSpec_ValueType) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._type != rhs_storage._type {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TensorType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "dataType"),
    2: .same(proto: "rank"),
    3: .same(proto: "dimensions"),
    4: .same(proto: "attributes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.dataType) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.rank) }()
      case 3: try { try decoder.decodeRepeatedMessageField(value: &self.dimensions) }()
      case 4: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: &self.attributes) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.dataType != .unusedType {
      try visitor.visitSingularEnumField(value: self.dataType, fieldNumber: 1)
    }
    if self.rank != 0 {
      try visitor.visitSingularInt64Field(value: self.rank, fieldNumber: 2)
    }
    if !self.dimensions.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.dimensions, fieldNumber: 3)
    }
    if !self.attributes.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,CoreML_Specification_MILSpec_Value>.self, value: self.attributes, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorType, rhs: CoreML_Specification_MILSpec_TensorType) -> Bool {
    if lhs.dataType != rhs.dataType {return false}
    if lhs.rank != rhs.rank {return false}
    if lhs.dimensions != rhs.dimensions {return false}
    if lhs.attributes != rhs.attributes {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TupleType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TupleType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "types"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.types) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.types.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.types, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TupleType, rhs: CoreML_Specification_MILSpec_TupleType) -> Bool {
    if lhs.types != rhs.types {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_ListType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ListType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "type"),
    2: .same(proto: "length"),
  ]

  fileprivate class _StorageClass {
    var _type: CoreML_Specification_MILSpec_ValueType? = nil
    var _length: CoreML_Specification_MILSpec_Dimension? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _type = source._type
      _length = source._length
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._type) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._length) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._type {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._length {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_ListType, rhs: CoreML_Specification_MILSpec_ListType) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._type != rhs_storage._type {return false}
        if _storage._length != rhs_storage._length {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_DictionaryType: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DictionaryType"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "keyType"),
    2: .same(proto: "valueType"),
  ]

  fileprivate class _StorageClass {
    var _keyType: CoreML_Specification_MILSpec_ValueType? = nil
    var _valueType: CoreML_Specification_MILSpec_ValueType? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _keyType = source._keyType
      _valueType = source._valueType
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._keyType) }()
        case 2: try { try decoder.decodeSingularMessageField(value: &_storage._valueType) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every if/case branch local when no optimizations
      // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
      // https://github.com/apple/swift-protobuf/issues/1182
      try { if let v = _storage._keyType {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      } }()
      try { if let v = _storage._valueType {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
      } }()
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_DictionaryType, rhs: CoreML_Specification_MILSpec_DictionaryType) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._keyType != rhs_storage._keyType {return false}
        if _storage._valueType != rhs_storage._valueType {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Dimension: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Dimension"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "constant"),
    2: .same(proto: "unknown"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: CoreML_Specification_MILSpec_Dimension.ConstantDimension?
        var hadOneofValue = false
        if let current = self.dimension {
          hadOneofValue = true
          if case .constant(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.dimension = .constant(v)
        }
      }()
      case 2: try {
        var v: CoreML_Specification_MILSpec_Dimension.UnknownDimension?
        var hadOneofValue = false
        if let current = self.dimension {
          hadOneofValue = true
          if case .unknown(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.dimension = .unknown(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.dimension {
    case .constant?: try {
      guard case .constant(let v)? = self.dimension else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .unknown?: try {
      guard case .unknown(let v)? = self.dimension else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Dimension, rhs: CoreML_Specification_MILSpec_Dimension) -> Bool {
    if lhs.dimension != rhs.dimension {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Dimension.ConstantDimension: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_Dimension.protoMessageName + ".ConstantDimension"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "size"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularUInt64Field(value: &self.size) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.size != 0 {
      try visitor.visitSingularUInt64Field(value: self.size, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Dimension.ConstantDimension, rhs: CoreML_Specification_MILSpec_Dimension.ConstantDimension) -> Bool {
    if lhs.size != rhs.size {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Dimension.UnknownDimension: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_Dimension.protoMessageName + ".UnknownDimension"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "variadic"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.variadic) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.variadic != false {
      try visitor.visitSingularBoolField(value: self.variadic, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Dimension.UnknownDimension, rhs: CoreML_Specification_MILSpec_Dimension.UnknownDimension) -> Bool {
    if lhs.variadic != rhs.variadic {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Value: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Value"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "docString"),
    2: .same(proto: "type"),
    3: .same(proto: "immediateValue"),
    5: .same(proto: "blobFileValue"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.docString) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._type) }()
      case 3: try {
        var v: CoreML_Specification_MILSpec_Value.ImmediateValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .immediateValue(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .immediateValue(v)
        }
      }()
      case 5: try {
        var v: CoreML_Specification_MILSpec_Value.BlobFileValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .blobFileValue(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .blobFileValue(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.docString.isEmpty {
      try visitor.visitSingularStringField(value: self.docString, fieldNumber: 1)
    }
    try { if let v = self._type {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    switch self.value {
    case .immediateValue?: try {
      guard case .immediateValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .blobFileValue?: try {
      guard case .blobFileValue(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Value, rhs: CoreML_Specification_MILSpec_Value) -> Bool {
    if lhs.docString != rhs.docString {return false}
    if lhs._type != rhs._type {return false}
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Value.ImmediateValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_Value.protoMessageName + ".ImmediateValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "tensor"),
    2: .same(proto: "tuple"),
    3: .same(proto: "list"),
    4: .same(proto: "dictionary"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: CoreML_Specification_MILSpec_TensorValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .tensor(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .tensor(v)
        }
      }()
      case 2: try {
        var v: CoreML_Specification_MILSpec_TupleValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .tuple(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .tuple(v)
        }
      }()
      case 3: try {
        var v: CoreML_Specification_MILSpec_ListValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .list(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .list(v)
        }
      }()
      case 4: try {
        var v: CoreML_Specification_MILSpec_DictionaryValue?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .dictionary(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .dictionary(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.value {
    case .tensor?: try {
      guard case .tensor(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .tuple?: try {
      guard case .tuple(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .list?: try {
      guard case .list(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .dictionary?: try {
      guard case .dictionary(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Value.ImmediateValue, rhs: CoreML_Specification_MILSpec_Value.ImmediateValue) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_Value.BlobFileValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_Value.protoMessageName + ".BlobFileValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "fileName"),
    2: .same(proto: "offset"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.fileName) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.offset) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.fileName.isEmpty {
      try visitor.visitSingularStringField(value: self.fileName, fieldNumber: 1)
    }
    if self.offset != 0 {
      try visitor.visitSingularUInt64Field(value: self.offset, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_Value.BlobFileValue, rhs: CoreML_Specification_MILSpec_Value.BlobFileValue) -> Bool {
    if lhs.fileName != rhs.fileName {return false}
    if lhs.offset != rhs.offset {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TensorValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "floats"),
    2: .same(proto: "ints"),
    3: .same(proto: "bools"),
    4: .same(proto: "strings"),
    5: .same(proto: "longInts"),
    6: .same(proto: "doubles"),
    7: .same(proto: "bytes"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedFloats?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .floats(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .floats(v)
        }
      }()
      case 2: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedInts?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .ints(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .ints(v)
        }
      }()
      case 3: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedBools?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .bools(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .bools(v)
        }
      }()
      case 4: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedStrings?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .strings(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .strings(v)
        }
      }()
      case 5: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .longInts(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .longInts(v)
        }
      }()
      case 6: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .doubles(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .doubles(v)
        }
      }()
      case 7: try {
        var v: CoreML_Specification_MILSpec_TensorValue.RepeatedBytes?
        var hadOneofValue = false
        if let current = self.value {
          hadOneofValue = true
          if case .bytes(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.value = .bytes(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.value {
    case .floats?: try {
      guard case .floats(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .ints?: try {
      guard case .ints(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .bools?: try {
      guard case .bools(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .strings?: try {
      guard case .strings(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .longInts?: try {
      guard case .longInts(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .doubles?: try {
      guard case .doubles(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case .bytes?: try {
      guard case .bytes(let v)? = self.value else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue, rhs: CoreML_Specification_MILSpec_TensorValue) -> Bool {
    if lhs.value != rhs.value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedFloats: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedFloats"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedFloatField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedFloats, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedFloats) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedDoubles"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedDoubleField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedDoubleField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedDoubles) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedInts: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedInts"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt32Field(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedInt32Field(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedInts, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedInts) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedLongInts"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedInt64Field(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedLongInts) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedBools: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedBools"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedBoolField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedBoolField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedBools, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedBools) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedStrings: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedStrings"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedStringField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedStrings, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedStrings) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TensorValue.RepeatedBytes: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_TensorValue.protoMessageName + ".RepeatedBytes"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBytesField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitSingularBytesField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TensorValue.RepeatedBytes, rhs: CoreML_Specification_MILSpec_TensorValue.RepeatedBytes) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_TupleValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TupleValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_TupleValue, rhs: CoreML_Specification_MILSpec_TupleValue) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_ListValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ListValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_ListValue, rhs: CoreML_Specification_MILSpec_ListValue) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_DictionaryValue: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".DictionaryValue"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedMessageField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_DictionaryValue, rhs: CoreML_Specification_MILSpec_DictionaryValue) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension CoreML_Specification_MILSpec_DictionaryValue.KeyValuePair: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = CoreML_Specification_MILSpec_DictionaryValue.protoMessageName + ".KeyValuePair"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "key"),
    2: .same(proto: "value"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._key) }()
      case 2: try { try decoder.decodeSingularMessageField(value: &self._value) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._key {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._value {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: CoreML_Specification_MILSpec_DictionaryValue.KeyValuePair, rhs: CoreML_Specification_MILSpec_DictionaryValue.KeyValuePair) -> Bool {
    if lhs._key != rhs._key {return false}
    if lhs._value != rhs._value {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
