#!/bin/bash

set -e
if [ "$#" -ne 1 ]; then
    echo "Usage: $0 <baseline-name=directory-of-the-baseline>"
    exit 1
fi
cd "$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"/../$1

echo "Formatting started"
python -m isort .
python -m black -q .
python -m docformatter -i -r .
python -m ruff check --fix .
echo "Formatting done"
