const config = {}
const settings = {

    controls: { // displays top-to-bottom in toolbar menu
        infinityMode: { type: 'toggle',
            label: chrome.i18n.getMessage('menuLabel_infinityMode') },
        autoStart: { type: 'toggle',
            label: chrome.i18n.getMessage('menuLabel_autoStart'),
            helptip: chrome.i18n.getMessage('helptip_autoStart') },
        toggleHidden: { type: 'toggle',
            label: chrome.i18n.getMessage('menuLabel_toggleVis'),
            helptip: chrome.i18n.getMessage('helptip_toggleVis') },
        autoScrollDisabled: { type: 'toggle',
            label: chrome.i18n.getMessage('menuLabel_autoScroll'),
            helptip: chrome.i18n.getMessage('helptip_autoScroll') },
        replyLanguage: { type: 'prompt', symbol: '🌐',
            label: chrome.i18n.getMessage('menuLabel_replyLang'),
            helptip: chrome.i18n.getMessage('prompt_updateReplyLang') },
        replyTopic: { type: 'prompt', symbol: '🧠',
            label: chrome.i18n.getMessage('menuLabel_replyTopic'),
            helptip: chrome.i18n.getMessage('prompt_updateReplyTopic') },
        replyInterval: { type: 'prompt', symbol: '⌚',
            label: chrome.i18n.getMessage('menuLabel_replyInt'),
            helptip: chrome.i18n.getMessage('prompt_updateReplyInt') }
    },

    load() {
        const keys = ( // original array if array, else new array from multiple args
            Array.isArray(arguments[0]) ? arguments[0] : Array.from(arguments))
        return Promise.all(keys.map(key => // resolve promise when all keys load
            new Promise(resolve => // resolve promise when single key value loads
                chrome.storage.sync.get(key, result => { // load from Chrome
                    config[key] = result[key] || false ; resolve()
    }))))},

    save(key, val) {
        chrome.storage.sync.set({ [key]: val }) // save to Chrome
        config[key] = val // save to memory
    }
}

window.config = config ; window.settings = settings;
