## 设备列表

点击**设备**列表页设备名称，进入设备信息页。该页包括
**设备信息**、**设备安全**、**子设备**、**设备事件**、**原始数据**、**指标数据**、**设备轨迹**、**设备控制**、**控制台**九个页面，其功能与展示信息如下：

![device_](_assets/device_.png)



### 设备信息

- 设备状态信息：设备在线时显示连接时间、客户端 IP、心跳时间；
- 运行日志：即设备连接上/下线信息；
- 设备告警：当前设备触发的告警记录；
- 设备基本信息：设备名称，设备类型认证方式，上联系统、控制台信息等；
- 位置信息：在地图上展示设备位置、围栏范围等信息；
- 终端列表：设备为网关时展示包含终端列表。



点击设备基础信息，位置信息右上角编辑按钮可进行相关信息修改：

![select_location](_assets/select_location.png)






### 设备安全

包含有设备认证、服务器连接、证书与策略等信息：

- 设备认证信息：设备连接 Token 认证信息；

- MQTT服务器信息：平台 MQTT 协议接入地址；

- CoAP服务器信息：平台 CoAP 协议接入地址；

- 已绑定证书：绑定/取消绑定操作，绑定证书下载，用于管理设备证书连接；

- 已绑定策略：绑定/取消绑定 ACL 策略操作；

- 代理订阅：代理订阅相关操作：

  设备连接成功后，由服务器自动代理设备订阅某些主题，设备无须再次进行订阅操作。 代理订阅不适于用CoAP协议的设备。

  初始情况下，系统已默认为设备订阅了设备主题与分组主题，设备开发人员无须关心主题。 控制端调用 API 时只需指定设备或分组，设备监听收到的消息并解析 payload 进行相应操作。

  当设备需要通过“主题”来区分消息时，平台也支持用户自定义代理订阅的主题（最多10个主题）。

  

![device_security](_assets/device_security.png)

> 编码信息、证书为设备连接认证重要信息，请妥善保管。



### 子设备

设备上联系统可以是另一个设备，此处显示该设备下子设备列表。



### 设备事件

- 设备上行消息记录，即设备上报的消息，该页面无需刷新也可实时展示设备最新上报的消息。

  ![device_evnets](_assets/device_evnets.png)



### 原始数据

- 具体功能点数据展示，实时数据将自动刷新展示。

![original_data](_assets/original_data.png)



### 指标数据

- 按不同的时间维度、聚合方式展示该设备聚合后的功能点数据。

  


### 设备轨迹

- 当设备所属产品定义的功能点为位置功能点时，该功能点上报的位置轨迹信息将在地图上展示。

![location_path](_assets/location_path.png)



### 设备控制

- **ActorCloud** 或 **外部应用** 向该设备下发的消息，点击**添加指令**可向当前设备即时或定时发送消息。

  - LWM2M 设备：
  
  支持选取所属产品已添加的产品属性并下发指令到设备，对于**写**、**执行**操作需要额外添加执行指令；
  
  - 其他设备：
  
    - 平台指令：选取所属产品已定义的数据流，完善功能点后可发送；
    
    - 自定义指令：自定义发送 JSON 格式的消息；
    
    - 升级指令：选取在 OTA 升级中上传的软件包，在升级指令中包含软件包下载地址发送到设备进行升级（需设备支持）。
    
    
  
- 定时任务：

如需周期性/定时向设备发送消息，可添加定时任务，定时任务下发与普通指令一致。



![device_control](_assets/device_control.png)



### 控制台

通过**应用** -> **应用模板**可以定义常用的设备控制操作卡片，即把一条数据流/产品属性中的某个值定义为一个操作卡片，其他值需要有一个默认值，通过点击操作卡片以实现一键发送控制指令。

设备所属产品定义了应用模板后，控制台将显示当前定义的应用模板操作卡片。模板卡片显示的值为当前最新值。

  - 数值、字符、时间类型：点击控制台中的卡片**编辑**按钮可以编辑当前值并将指令下发至设备；
  - 枚举类型：点击枚举值按钮可以将相关指令下发至设备；
  - 开关：点击开关可以下发切换设备状态的指令；
  - 布尔：点击 `true` `false` 按钮可以将相应指令下发至设备。






### 列表操作

设备列表页可进行更多设备操作：

- 批量导出：将平台设备导出为 Excel 文件，无需选中设备，设备列表页点击**批量导出**即可导出全部设备；
- 批量导入：使用 Excel 模板文件导入设备信息；
- 登录设备：通过 ssh 登录到设备控制台（需设备支持）；
- 指令下发：向选中设备下发指令；
- 任务配置：配置选中设备定时任务；
- 创建分组：从选中设备创建分组（仅限同一产品下设备）。



![device_list](_assets/device_list.png)



## 网关管理

**ActorCloud** 中具有汇聚设备消息、并连接至服务器的特殊设备可称作网关，如 LoRa 协议中的基站、NB-IoT 协议中的的运营商透传接口等。

点击**设备管理** -> **网关管理** 可进行接入网关的管理。

为方便管理统计，如设备上联系统为网关，需在设备新建时创建并选择相应网关。

![device_gateway_product](_assets/device_gateway_product.png)



### 网关信息

显示基本的网关信息，MQTT 透传协议的网关可通过网关编号，网关用户名，网关密钥连接至 **ActorCloud**。




#### 网关通道 (适配 Modbus 网关)

- 1.Modbus 网关详情页点开 网关通道 后面的 点击查看 按钮，进入网关通道配置；

- 2.点开 添加通道，先选择通道类型。通道类型可选择 COM、TCP，驱动类型可选择 Modbus TRU (COM类型)、Modbus TCP (TCP类型)；

- 3.创建一个 COM 类型的通道。其中 Baud 表示串口波特率，Data 表示数据位，Stop 表示停止位，Parity 表示奇偶校验位。注意：一个网关只能创建一个 COM 通道，并且不可与 TCP 通道并存；

- 4. 创建一个 TCP 类型的通道(需把前面创建 COM 通道删除)，注意：一个网关最多可创建 9 个 TCP 通道，并且不可与 COM 通道并存。



![gateway_way](_assets/gateway_way.png)



### 网关事件

实时显示该网关上报的消息，同设备事件功能类似。



### 网关控制

将配置信息下发更新至网关。



### 设备数据

显示网关设备的最新数据






## 分组管理

分组为设备的一个业务集合，同一个设备可以在不同分组中。

进入设备管理->设备列表页面，点击**分组**标签页，可查看分组列表：

- 点击**设备数量**查看分组下设备列表；
- 点击右上角的**新建**按钮可进行分组新建操作。




### 分组操作

在**分组**编辑和查看页，可以进行分组内设备的管理操作：

- **包含设备**列表内可移除当前分组内设备；

- 点击**添加设备**可添加符合规则的设备到当前分组。

  

![group_add_device](_assets/group_add_device.png)



### 代理订阅

- **代理订阅**列表内可查看当前分组代理订阅列表，分组内设备连接至平台后将自动订阅列表内主题。

  


### 分组控制

- **分组控制**列表内可查看通过设备管理平台向组内设备下发的消息记录；

- 点击**添加指令**可以通过设备管理平台向组内设备下发消息，支持自定义 JSON 格式消息与升级指令。




### 聚合数据

聚合分组里设备指定功能点数值信息，该功能与设备中的指标数据相同，但层级是整个分组下的设备。

