# 快速接入指南

设备快速接入指南将通过实例，指导开发者将 MQTT 协议设备快速接入 ActorCloud 平台，并完成模拟数据上报。

## 案例概述

本案例以空调上报温度和模式（制冷，制热）数据为例，帮助开发者快速接入 MQTT 协议设备。

## 接入步骤

1. #### 新建产品

   选择 设备管理->产品管理->新建，创建一个名为"**空调**"的产品，云端协议选择"**MQTT**"，产品类型选择"**设备**"，点击"完成"，添加产品成功。

   ![](../assets/example_product_create.png)

   新建产品详细操作请参考[创建产品](/device/product_create.md)。

2. #### 新建功能点

   选择 设备管理-> 产品管理，产品列表页找到上一步创建的产品“**空调**”，点击名称，进入产品详情页面，选择“**功能点**”选项卡，点击右上角“新建”。

   创建一个功能点“**模式**”，输入功能点标识（必填，不可重复）“**mode**”，数据类型选择“**字符串**”，数据传输类型选择“**可上报可下发**”，点击“完成”，新建功能点成功。

   ![](../assets/example_datapoint_create_1.png)

   再创建一个功能点“**温度**”，输入功能点标识“**temperature**”，数据类型选择“**数值**”，数据传输类型选择“**可上报可下发**”，点击“完成”，新建功能点成功。

   ![](../assets/example_datapoint_create_2.png)

   功能点详细介绍请参考[功能点](/device/product.md#功能点)。

3. #### 新建数据流

   选择“**数据流**”选项卡，点击右上角“新建”。

   数据流名称填入“**空调状态**”，数据格式选择“**JSON**”，流类型选择“**设备数据上报**”，数据流主题填入“**mode_temp**”，功能点选择上一步创建好的两个功能点“**模式**”“**温度**”，点击完成，成功添加数据流。

   ![](../assets/example_stream_create.png)

   数据流详细介绍请参考[数据流](/device/product.md#数据流)。

4. #### 新建设备

   选择 设备管理->新建，新建一个名为"**空调设备**"的设备，所属产品选择第一步创建的产品"**空调**"，设备类型选择"**终端**"，上联系统选择"**云**"，点击"下一步"，认证信息页面点击"完成"，添加设备成功。

   ![](../assets/example_device_create.png)

   新建设备详细操作请参考[创建设备](/device/device_create.md)。

5. #### 模拟设备上报数据

   选择 测试中心->MQTT客户端，选择上一步创建好的设备“**空调设备**”，点击启动设备，以模拟设备接入 ActorCloud。

   ![](../assets/example_mqtt_run.png)

   在“上报数据”选项卡，输入上面创建的数据流主题“**mode_temp**”，消息字段输入JSON数据“**{"mode":"cold","temperature":25}**”（制冷25度），点击“上报数据”，上报成功，右侧“已上报数据”选项卡可看到上报数据。

   ![](../assets/example_mqtt_report.png)

   MQTT客户端详细操作请参考[MQTT客户端](/test_center/mqtt.md#mqtt-客户端)。

6. #### 查看设备上报数据

   设备事件：进入设备管理，找到上面创建的设备“**空调设备**”，点击设备名称进入设备详情页，选择"设备事件"选项卡，可以看到刚刚上报的数据信息。设备事件详细参考[设备事件](/device/device.html#设备事件)。

   ![](../assets/example_device_event.png)

   原始数据：选择"原始数据"选项卡，可以看到被解析出来的上报数据。原始数据详细参考[原始数据](/device/device.html#原始数据)。

   ![](../assets/example_device_data.png)

​	