"""
Storage readers and writers - s3, gcs, azure, filesystem, etc.
"""

from __future__ import annotations
import deeplake._deeplake.core
import typing

__all__ = ["Reader", "Writer"]

class Reader:
    def __getstate__(self) -> tuple: ...
    def __setstate__(self, arg0: tuple) -> None: ...
    def get(
        self, path: str, start_bytes: int | None = None, end_bytes: int | None = None
    ) -> deeplake._deeplake.core.MemoryBuffer: ...
    def length(self, path: str) -> int: ...
    def list(self, path: str) -> list: ...
    def subdir(self, subpath: str) -> Reader: ...
    @property
    def original_path(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def token(self) -> str: ...

class Writer:
    def __getstate__(self) -> tuple: ...
    def __setstate__(self, arg0: tuple) -> None: ...
    def remove(self, path: str) -> None: ...
    def remove_directory(self, prefix: str = "") -> None: ...
    def set(self, path: str, content: bytes) -> None: ...
    def subdir(self, subpath: str) -> Writer: ...
    @property
    def original_path(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def token(self) -> str: ...
