//
//  SearchViewController.swift
//  WatchThis
//
//  Created by Theodor Bjørnstad on 4/25/20.
//  Copyright © 2020 Tech Knowns. All rights reserved.
//

import UIKit

class SearchViewController: UIViewController, UITableViewDelegate, UITableViewDataSource, UISearchBarDelegate {

    
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var searchBar: UISearchBar!
    
    var searchResults = [[String:Any]]()
    
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        searchBar.delegate = self
        
        tableView.delegate = self
        tableView.dataSource = self
        tableView.keyboardDismissMode = .onDrag

        self.navigationController?.navigationBar.prefersLargeTitles = true
        
        //Setting color on text in searchbar. Darkmode/lightmode
        if let textfield = searchBar.value(forKey: "searchField") as? UITextField {
            if traitCollection.userInterfaceStyle == .light{
                textfield.textColor = UIColor.black
            }
            else{
                textfield.textColor = UIColor.white
            }
        }
        
        // Do any additional setup after loading the view.
    }
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return searchResults.count
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cell = tableView.dequeueReusableCell(withIdentifier: "MovieTableViewCell") as! MovieTableViewCell

        let movie = searchResults[indexPath.row]
        let title = movie["title"] as! String
        let synopsis = movie["overview"] as! String

        cell.titleLabel.text = title
        cell.synopsisLabel.text = synopsis

        let baseUrl = "https://image.tmdb.org/t/p/w185"
        
        if let posterPath = movie["poster_path"] as? String {
            let posterUrl = URL (string: baseUrl + posterPath)!
            cell.posterView.af_setImage(withURL: posterUrl, placeholderImage: UIImage(named: "default-poster"))
        } else {
            cell.posterView.image = UIImage(named: "default-poster")
        }
        
        return cell
    }
    
    func searchBar(_ searchBar: UISearchBar, textDidChange searchText: String) {
        if(searchText.isEmpty){return}
        let formatedSearchText = searchText.replacingOccurrences(of: " ", with: "+")
        let url = URL(string: "https://api.themoviedb.org/3/search/movie?api_key=b6dcea27a60a83ccbe00da3c72753438&query=\(formatedSearchText)")!
        let request = URLRequest(url: url, cachePolicy: .reloadIgnoringLocalCacheData, timeoutInterval: 10)
        let session = URLSession(configuration: .default, delegate: nil, delegateQueue: OperationQueue.main)
        let task = session.dataTask(with: request) { (data, response, error) in
           // This will run when the network request returns
           if let error = error {
              print(error.localizedDescription)
           } else if let data = data {
              let movieData = try! JSONSerialization.jsonObject(with: data, options: []) as! [String: Any]
            
            
            self.searchResults = movieData["results"] as! [[String:Any]]
            self.tableView.reloadData()

           }
        }
        task.resume()
    }
    
//    func searchBarTextDidBeginEditing(_ searchBar: UISearchBar) {
//        searchBar.setShowsCancelButton(true, animated: true)
//    }
//
//    func searchBarTextDidEndEditing(_ searchBar: UISearchBar) {
//        searchBar.setShowsCancelButton(false, animated: true)
//    }

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destination.
        // Pass the selected object to the new view controller.
    }
    */
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destination.
        // Pass the selected object to the new view controller.
        
        if let mySender = sender as? UITableViewCell {
            print("Table View Cell Clicked")

            let cell = mySender
            let indexPath = tableView.indexPath(for: cell)!
            let movie = searchResults[indexPath.row]

            // Pass the selected movie to the details view controller

            let detailsViewController = segue.destination as! MovieDetailsViewController

            detailsViewController.movie = movie

            tableView.deselectRow(at: indexPath, animated: true)

        }
    }
}


