import * as Expressions from "../../2_statements/expressions";
import * as Statements from "../../2_statements/statements";
import * as Structures from "../../3_structures/structures";
import {StructureNode, StatementNode} from "../../nodes";
import {TypedIdentifier} from "../../types/_typed_identifier";
import {IStructureComponent, VoidType} from "../../types/basic";
import {IncludeType} from "../statements/include_type";
import {Type} from "../statements/type";
import * as Basic from "../../types/basic";
import {ScopeType} from "../_scope_type";
import {SyntaxInput} from "../_syntax_input";

export class Types {
  public runSyntax(node: StructureNode, input: SyntaxInput, qualifiedNamePrefix?: string): TypedIdentifier | undefined {
    const name = node.findFirstExpression(Expressions.NamespaceSimpleName)!.getFirstToken();
    const components: IStructureComponent[] = [];
    let voidd: VoidType | undefined = undefined;

    if (qualifiedNamePrefix === undefined) {
      qualifiedNamePrefix = "";
    }

    for (const c of node.getChildren()) {
      const ctyp = c.get();
      if (c instanceof StatementNode) {
        if (ctyp instanceof Statements.Type) {
          const found = new Type().runSyntax(c, input, qualifiedNamePrefix + name.getStr() + "-");
          if (found) {
            components.push({name: found.getName(), type: found.getType()});
          }
        } else if (ctyp instanceof Statements.IncludeType) {
          const found = new IncludeType().runSyntax(c, input);
          if (found instanceof VoidType) {
            voidd = found;
          } else {
            components.push(...found);
          }
        }
      } else if (c instanceof StructureNode && ctyp instanceof Structures.Types) {
        const found = new Types().runSyntax(c, input, qualifiedNamePrefix + name.getStr() + "-");
        if (found) {
          components.push({name: found.getName(), type: found.getType()});
        }
      }
    }

    if (voidd) {
      return new TypedIdentifier(name, input.filename, voidd);
    } else if (components.length === 0) { // todo, remove this check
      return undefined;
    }

    let qualifiedName = qualifiedNamePrefix + name.getStr();
    if (input.scope.getType() === ScopeType.ClassDefinition
        || input.scope.getType() === ScopeType.Interface) {
      qualifiedName = input.scope.getName() + "=>" + qualifiedName;
    }

    return new TypedIdentifier(name, input.filename, new Basic.StructureType(components, qualifiedName));
  }
}