  <!-- Header  -->
  <?php require 'partials/header.php'; ?>

  <!-- Navbar  -->
  <?php require 'partials/nav.php'; ?>
  
  <div class="relative isolate overflow-hidden bg-white px-6 py-24 sm:py-32 lg:overflow-visible lg:px-0">
  <div class="absolute inset-0 -z-10 overflow-hidden">
    <svg class="absolute top-0 left-[max(50%,25rem)] h-[64rem] w-[128rem] -translate-x-1/2 stroke-gray-200 [mask-image:radial-gradient(64rem_64rem_at_top,white,transparent)]" aria-hidden="true">
      <defs>
        <pattern id="e813992c-7d03-4cc4-a2bd-151760b470a0" width="200" height="200" x="50%" y="-1" patternUnits="userSpaceOnUse">
          <path d="M100 200V.5M.5 .5H200" fill="none" />
        </pattern>
      </defs>
      <svg x="50%" y="-1" class="overflow-visible fill-gray-50">
        <path d="M-100.5 0h201v201h-201Z M699.5 0h201v201h-201Z M499.5 400h201v201h-201Z M-300.5 600h201v201h-201Z" stroke-width="0" />
      </svg>
      <rect width="100%" height="100%" stroke-width="0" fill="url(#e813992c-7d03-4cc4-a2bd-151760b470a0)" />
    </svg>
  </div>
  <div class="mx-auto grid max-w-2xl grid-cols-1 gap-y-16 gap-x-8 lg:mx-0 lg:max-w-none lg:grid-cols-2 lg:items-start lg:gap-y-10">
    <div class="lg:col-span-2 lg:col-start-1 lg:row-start-1 lg:mx-auto lg:grid lg:w-full lg:max-w-7xl lg:grid-cols-2 lg:gap-x-8 lg:px-8">
      <div class="lg:pr-4">
        <div class="lg:max-w-lg">

        
          
          <h1 class="mt-2 text-3xl font-bold tracking-tight text-gray-900 sm:text-4xl">User Guide</h1>
          <p class="mt-2 text-xl leading-8 text-gray-700">Our customer to customer ecommerce platform enables easy buying and selling of laptops. We allow users a messaging system for communication.</p>

          <div class="flex my-4">
          <img src="/src/images/warning.png" class="w-10 h-10" alt="warning-image">
          <p class="mb-2 font-medium text-gray-800 mx-3">Be careful with your email and password. This is just a demo website, so don't use your real info.</p>
          </div>
        </div>
      </div>
    </div>
    <div class="-mt-12 -ml-12 p-12 lg:sticky lg:top-4 lg:col-start-2 lg:row-span-2 lg:row-start-1 lg:overflow-hidden">
      <img src="/src/images/user-guide.jpg" alt="user-guide-img">
    </div>
    <div class="lg:col-span-2 lg:col-start-1 lg:row-start-2 lg:mx-auto lg:grid lg:w-full lg:max-w-7xl lg:grid-cols-2 lg:gap-x-8 lg:px-8">
      <div class="lg:pr-4">
        <div class="max-w-xl text-base leading-7 text-gray-700 lg:max-w-lg">
        There are two available choices, which are buying and selling. In order to purchase an item, you may browse through the website and select a high-quality laptop. To communicate with the seller, it is necessary to create an account and log in. On the other hand, if you wish to sell your own laptop, kindly follow the instructions provided below.</p>
          <ul role="list" class="mt-8 space-y-8 text-gray-600">
            <li class="flex gap-x-3">
              
              <span><strong class="font-semibold text-lg text-gray-900">Register & login.</strong>To begin, kindly register and create an account. Upon successful completion, kindly proceed to log into your account accordingly.</span>
            </li>
            <li class="flex gap-x-3">
             
              <span><strong class="font-semibold text-lg text-gray-900">Profile.</strong>After logging into your account, please create your profile to facilitate contact by providing accurate and complete details.</span>
            </li>
            <li class="flex gap-x-3">
             
              <span><strong class="font-semibold text-lg text-gray-900">Create post.</strong>Once your profile is complete, you may proceed to create a post and sell your laptop. Simply click on the "Sell" button located on the home screen, provide the necessary information about your laptop, and post it for sale. </span>
            </li>
          </ul>
          
          
        </div>
      </div>
    </div>
  </div>
</div>


  <!-- Footer  -->
  <?php require 'partials/footer.php'; ?>