import type { Metadata } from "next";
import localFont from "next/font/local";
import "./globals.css";
import { Analytics } from "@vercel/analytics/react"
import { Providers } from "./providers";
import SideNavbar from "@/components/SideNavbar";
import Header from "@/components/Header";
import { Toaster } from "@/components/ui/sonner"

const geistSans = localFont({
  src: "./fonts/GeistVF.woff",
  variable: "--font-geist-sans",
  weight: "100 900",
});
const geistMono = localFont({
  src: "./fonts/GeistMonoVF.woff",
  variable: "--font-geist-mono",
  weight: "100 900",
});

export const metadata: Metadata = {
  title: "Figuringout.life",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased flex bg-secondary bg-opacity-5 font-[family-name:var(--font-geist-sans)]`}
      >
        <Providers>
          <>
            <SideNavbar />
            <Header />
            <div className="flex-1">{children}</div>
            <Toaster />
          </>
        </Providers>
        <Analytics />        
      </body>
    </html>
  );
}
