<img style="float: right;" align="left" src="https://raw.github.com/ZigRazor/CXXGraph/master/logos/CXXGraph.gif">

# CXXGraph

<img src="https://img.shields.io/badge/c++%20-%2300599C.svg?&style=for-the-badge&logo=c%2B%2B&ogoColor=white"/> <img src="https://img.shields.io/badge/github%20-%23121011.svg?&style=for-the-badge&logo=github&logoColor=white"/>

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5878831.svg)](https://doi.org/10.5281/zenodo.5878831)

[![DOI](https://img.shields.io/badge/doi-10.6084/m9.figshare.18705572-blue.svg?style=flat&labelColor=gainsboro&logoWidth=40&logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAFAAAAAZCAYAAACmRqkJAAAKi0lEQVR4Ae3ZaVBUV97H8evuE0EfH32MmkcfoyAuGjXKgkvMaFRAFuiloemWvRuEXlgEBREXBYJiXAQUFeKocUniQiKogAJhQWwWENDEjLNYvjFLzUzNkplEZb5kTme6nCRjKlOpSZlb9SmL2%2Ffcuv3re87%2FnKP0TYfOcslqPMbt63xBKuh09MTxgi7HKT1Sj1TvKp%2BMkZB6%2FXT8c4AjUYPyVdfb7Qs6HTIJ8EHe7Ul%2B152CphDabRQ0uMr7%2FRQgh%2B8qU6%2FBiPDVGv0jq0uGE94b0ZZ3j%2B25MTetoMsh%2FWD91OBqT9%2Fsehd5EqGV17nKMzTqOHvaRMMLEp7qACfinq%2FW1BBx5ZxB13x5X3Jr1v%2Fz9pUcaHU63PiicjrhvXfNRbY1Th49Q6Y1vu6zyqSjzX3aVIgf4OkKToxhgxpd5OMzV0bYE4CRN1Chu34pnTfwnV03FiTlfzDRXBHo6dfgIq8sX6ByV6vjthGc0UdrrPPVGFQBxlSjzJQWENVUZkebceiLpyM8IZSx7O7Zl4JivUNMZX5h8Rt4%2B2L0llKfgu6JKa%2BXvpB5bZ48%2Ba3F6lil2pDkE2rODzCsU0VUnNFHNZQqdS3lx3Utl%2FMILQcfYt5TEeC1GSprgAq0XlgYGLQyxJTlr0uK0DVX7E5s2ZtOgHvLw5fLK9xVmcqguEj%2F2LXbwsvPBkZZKl4j5NcIKinaUsLbejFWZ7m8Do2cmwnb4cFqArRwx3TEYzi%2Bz7DTD0uhxnj8cAEWWUZK%2BTcdhh4pmTWUsW01Y1uCUmNY7Rtqzo5svJSS0poVXtg6yVj7sn9qunek3j8xPVXXeMFoaDkev6lDF7ene7Y5r2taNAXmEBXaP69zevaOjuUeeZ0zhzJuPsM5CdYvOhZVqBMhBqIVDt8zwGdQjR4of9AA%2BXJjUFpww7GodnHAQca4srDAWCXjW3pETal%2BbfumuOLKqSm17vIQtWr1Uu3JYy6JbXuXFbRN1R8pm5byxtG5CcdOz9EUVc7I5IeQEWQ7wWVwzwrsRn%2BbAFeiCxNsKv5Y9P03BFgjAlT90AGOQy2T47fObl00ocFZHl%2B2UGXw0RjzNUWHTPFthckHWh18al8KsGuaFigVVzlKuY%2BG9z37qvuoGlelpsJVldrgrFjbOE%2BeWe8uW18W84qCqc4s7tmCIgzI75hs%2FaJKNFu7rF%2BIIIhr%2BmIQ%2Btn8LQkDMQOeWAYnDHgsQI3NNU7W9j4h5t72o%2FEyvLEQ%2F%2Bu7ymzbOxbCAeOxAgtghz6YgOVYiufEOUlqu0M37ho%2BYn%2FnpJT8bsejVSt90uqdFdlGmV7hF7cuWXetNCShLX%2BI3nKhN%2ByvCs%2Bs6GQpWB33fzKNQR%2BqWr022yvc94q7spBCY%2Bbzkou6ZfJNPf89ZN%2FdidYHnIsKfIzjCMIc7MAwSJiMPFxGMcKQixGwx07R%2FiEe4CNsxFCbAJvwifj8LkIgYRHa8Lm47jNY8AokmMS5NryPh%2FijOB%2BOX4h7foEuyPHlisMtylJpzu1YspkQ36YbLqnx8F1X4abaqmYs9DGmLlrk4CE9XlHlKZskxfpt%2FUJLzyhV23dG%2BITF72fqo9njEaokwIu8lSbG1N4wx273CrP%2B%2BjniQVZhGrzQjlEioFIRcjDM6MIdjBVtHogvl4W9qIX8sTfwU5SgU%2FzdhdGYLcJ9BzvRID6vgx2SxN8PUI9KnIEWH4n7FuIo%2FoRfYV5vMMV4wHRFs%2BvG%2FKl05ZrDVdP11T7eulK3oNQcz%2FAXcj3DpMePjO44KetDL2lDh%2FmV1S3nNoeWnJb7RSXmMJl%2BI0GmH13rKs8lvEdQwfoWKmCxdmGbAEdgAW5jFiQhBb8WXSYTPSjGCBHaMPR5LMANkOCM%2B%2FgD3MS5Z8W1ElzwW3HNJCSI9tcw2ub%2BO8T5LPTBQBy1nusNcB7ztximI1sIsSSzXb04v3vyusJmx63nMufHXlV6LvpEShDd9x%2FHFYWXVPuSX7%2FD7zmpcjuWRupbyvaHnj8Z7BNsUFCArm70iTRcd5bFEN7oxwJs%2FpoA%2FwfBaLJ2Z2EFbmEsNKL7fYYPUI9DIqj%2Fsgkw0CasW%2BL6RbBDFI7gTZSKzz6Gk02AJ23G3QF4xybYU8INce6s5CJNlTyXhYwKv%2FRWMiEeimquzIhrPpGzuSNCsbvLec2%2Brpmh2e0yu%2FxOp96wv6p8X0xeIZW5Bo2%2F6ucdvb%2FdMWVDm8lX11pRpD16OJ6VyZsrQ8yK%2BVFJ9h4UhwEHDj5JgGE23UkSfoZujMMzSESNCPBT9KAFjqi2rcIYZRPgYmzDQ9xDLSz4%2FGsCPIE%2BNkWrTJy%2FhRrRthpVyJJExbnmG2I%2B6x%2BT%2FHxYyQkzQfJGlufpWy6bYlvPUEgu%2BHlHJA5boo7rE3blnBR7r6mv%2BvCBMYEag%2Faqsyr1%2BIk5a%2Fd2z9zGBDpZ31qulCWk9443Hfg5BuJJAgxAG0ZBEmS4DZ7RKIliMVi0d8UvRUCeuPoNAf4Z%2FmgV13pAwiwR3iffFKBQJM5noB%2F6Y5h45v7Wwf0cDtD1DlMIeiugWmZOy5Cv3RgjX7%2FF4GdMXasOjgurmqdafqpojltml9IjvOJ8NMu9lNL5gQmXdMu0BTefz8loMyoJvivs3VMZvhpjqaig%2FZ8gwJGYIsIKRh%2FY4wh%2Bg%2FGQoxYbREgZ%2BB3uww1V3xKgN%2BrwCNtF4Pvx8NveQCEYX%2BAukhCIYuHZLy%2FyDjHbJQfo7PTK1dEBWqPBX2vS%2B2hNW1XquDURypiwXStCjVWuyrSKQC%2FdoUaHtOT2HENoyal4b40x7rK7ylip9NIV3Jy0P6fD24fl3Ra6uoe3PNqOH2Pw3x%2FC8K8CHIU%2BIpQ7OI8yNOJ9TMJO%2FAU9Nn6PjRiGmm%2FpwgsRLQpKjwjuU%2Fz1CQK0R4G4T4%2FwCHWYKlmcA6xr4SA2EzobXeUa9vh21LgpdKxK8hqd5RsaXWS7S9YvlhU2O7ya3ekXrm%2B9lK3KzFH6a4y5V92Ve5hkM4d02EShMestZekE2IxZX7MWdkAgBtmsi9U2lXEwliAOK%2BGLTowThWIZkrEVSSKYgegPOUxwtFmdaBGLsRgg2qeKtosQDh2GYzbisUIEaPvcQ8T5VGzCKowBk2I3mTVALe4wd4tumKcoaZirSKte4RtVrvXwLrw%2BJXV%2F18Ts3BtLEmOaS0yRtRdMfpGJhTKNMbDJWR5V7eEbUNDtcIQAd1PJMwnuJl6E9KQHY7AAHkzQoBkj8B%2B%2FpTWQ4Maezne1P3x1esLBuqmB%2BbccNhJMGetbM%2BGZIi1V%2FoRyOXB77sKVWuPmrd4RBvYQm9ihVue%2F7xDPGljB50MoJmO%2By36gCGsQovCyCGwOarD9R7PLLXZOJjKZvse%2FDQQSvffG7F1rWrZPiLKUX2DPr1hbfHAKb0kDBSeTed5MQj94Pn1xBMvA%2B2IDYTAkcXzXANPRjHq04ACeFeH9aAIcBC3LOq%2FY5pPDeYtO4yRTmzUhbx9LozCEea8ybaHoxDNmVtPltxSVzxhCm3Asg4Tvs683Aa5wwkD8qP9XbgQqUbb6Tp09U5Os3rWiV4jZv2OuvxPdvht70RfST8fjATZd7P33OYzxZ%2FdF7FwcgqPU0yMR2vMYDulpDfBvw%2BGCdBePpq8AAAAASUVORK5CYII%3D)](https://doi.org/10.6084/m9.figshare.18705572.v1)

[![codecov](https://codecov.io/gh/ZigRazor/CXXGraph/branch/master/graph/badge.svg?token=773AQ2H9RQ)](https://codecov.io/gh/ZigRazor/CXXGraph)
[![CodeFactor](https://www.codefactor.io/repository/github/zigrazor/cxxgraph/badge)](https://www.codefactor.io/repository/github/zigrazor/cxxgraph)

[![GitHub license](https://img.shields.io/github/license/ZigRazor/CXXGraph.svg)](https://github.com/ZigRazor/CXXGraph/blob/master/LICENSE) [![GitHub release](https://img.shields.io/github/release/ZigRazor/CXXGraph.svg)](https://GitHub.com/ZigRazor/CXXGraph/releases/)

[![Generic badge](https://img.shields.io/badge/Required-G++7.3.0-Green.svg)](https://shields.io/) [![Generic badge](https://img.shields.io/badge/required-C++17-Green.svg)](https://shields.io/) [![Generic badge](https://img.shields.io/badge/Required-CMake3.9-Green.svg)](https://shields.io/)

[![Generic badge](https://img.shields.io/badge/Build-Passed-Green.svg)](https://shields.io/) [![Generic badge](https://img.shields.io/badge/UnitTest-Passed-Green.svg)](https://shields.io/)

<br/><br/>
<br/><br/>
<br/><br/>

## Introduction
**CXXGraph** is a comprehensive C++ library that manages graph algorithms. This header-only library serves as an alternative to the [Boost Graph Library (BGL)](https://www.boost.org/doc/libs/1_77_0/libs/graph/doc/index.html).

## We are Looking for...

**We are looking for:**

- **A Web Developer** for the development of the CXXGraph website. All documentation is currently hosted on this GitHub page.
- **Developers and Contributors** to provide input. If you are new to the open-source world, we will guide you step by step!

If you are interested, please contact us at zigrazor@gmail.com or contribute to this project. We are waiting for you!

## Roadmap

| Completed | Description | Date of Completition |
| :-------: | :---------- | :-------------------: |
| :heavy_check_mark: | Release 0.4.0 | Oct 7, 2022 |
| :heavy_check_mark: | Release 0.5.0 | Mar 23, 2023 |
| :heavy_check_mark: | First Stable Release 1.0.0 | Mar 28, 2023 |
| :heavy_check_mark: | Release 1.0.1 | May 7, 2023 |
| :heavy_check_mark: | Release 1.1.0 | May 8, 2023 |
| :heavy_check_mark: | Stable Release 2.0.0 | Jun 1, 2023 |
| :heavy_check_mark: | Stable Release 3.0.0 | Nov 3, 2023 |
| :heavy_check_mark: | Release 3.1.0 | Jan 9, 2023 |
| :memo: | Introduce Hypergraph [#122](https://github.com/ZigRazor/CXXGraph/issues/122) | TBD |
| :memo: | Stable Release 4.0.0 | TBD |

## Table of Contents

- [CXXGraph](#cxxgraph)
  - [Introduction](#introduction)
  - [Hacktoberfest 2k22](#hacktoberfest-2k22)
  - [We are Looking for...](#we-are-looking-for)
  - [Roadmap](#roadmap)
  - [Table of Contents](#table-of-contents)
  - [Install and Uninstall](#install-and-uninstall)
    - [Install Linux Tarballs](#install-linux-tarballs)
    - [Install RPM](#install-rpm)
    - [Install DEB](#install-deb)
    - [Install From Source](#install-from-source)
  - [Classes Explanation](#classes-explanation)
  - [Requirements](#requirements)
  - [How to use](#how-to-use)
  - [Example](#example)
  - [Unit-Test Execution](#unit-test-execution)
    - [Google Test Installation](#google-test-installation)
    - [How to Compile Test](#how-to-compile-test)
    - [How to Run Test](#how-to-run-test)
  - [Benchmark Execution](#benchmark-execution)
    - [Google Benchmark Installation](#google-benchmark-installation)
    - [How to Compile Benchmark](#how-to-compile-benchmark)
    - [How to Run Benchmark](#how-to-run-benchmark)
    - [Benchmark Results](#benchmark-results)
  - [Packaging](#packaging)
    - [Tarballs](#tarballs)
    - [RPM](#rpm)
      - [(Fedora/CentOS/RedHat)](#fedoracentosredhat)
    - [DEB](#deb)
      - [(Debian/Ubuntu)](#debianubuntu)
  - [Algorithm Explanation](#algorithm-explanation)
    - [Dijkstra](#dijkstra)
    - [Dial](#dial)
    - [Prim's Algorithm](#prims-algorithm)
    - [BFS](#bfs)
    - [DFS](#dfs)
    - [Best First Search](#best-first-search)
    - [Cycle Detection](#cycle-detection)
    - [Bellman-Ford](#bellman-ford)
    - [Floyd Warshall](#floyd-warshall)
    - [Transitive Reduction](#transitive-reduction)
    - [Kruskal Algorithm](#kruskal-algorithm)
    - [Borůvka's Algorithm](#borůvkas-algorithm)
    - [Graph Slicing based on connectivity](#graph-slicing-based-on-connectivity)
    - [Ford-Fulkerson Algorithm](#ford-fulkerson-algorithm)
    - [Kosaraju's Algorithm](#kosarajus-algorithm)
    - [Kahn's Algorithm](#kahns-algorithm)
  - [Partition Algorithm Explanation](#partition-algorithm-explanation)
    - [Vertex-Cut](#vertex-cut)
    - [Edge Balanced Vertex-Cut](#edge-balanced-vertex-cut)
    - [Greedy Vertex-Cut](#greedy-vertex-cut)
    - [HDRF](#hdrf)
    - [EBV](#ebv)
  - [How to contribute](#how-to-contribute)
  - [Site](#site)
  - [Contact](#contact)
  - [Support](#support)
  - [References](#references)
  - [Credits](#credits)
  - [Contributors](#contributors)
  - [Cite Us](#cite-us)
  - [Hacktoberfest 2k21](#hacktoberfest-2k21)
  - [Other Details](#other-details)
  - [Author](#author)


## Install and Uninstall

### Install Linux Tarballs

To install on Unix/Linux systems, execute the following from the command line:

`$ sudo tar xjf CXXGraph-{version}.tar.bz2`

To uninstall:

`$ sudo rm -f /usr/include/Graph.hpp /usr/include/CXXGraph*`

### Install RPM

To install on Fedora/CentOS/RedHat systems, execute the following from the command line:

`$ sudo rpm -ivh CXXGraph-{version}.noarch.rpm`

To uninstall:

`$ sudo rpm -e CXXGraph-{version}`

### Install DEB

To install on Debian/Ubuntu systems, execute the following from the command line:

`$ sudo dpkg -i CXXGraph_{version}.deb`

To uninstall:

`$ sudo apt-get remove CXXGraph`

### Install From Source

For self-compiled installations using CMake, execute the following from the command line once compilation is complete:

`$ sudo make install`

## Classes Explanation

The Classes Explanation can be found in the [Classes Section](https://rawcdn.githack.com/ZigRazor/CXXGraph/master/docs/html/classes.html) of the [Doxygen Documentation](https://rawcdn.githack.com/ZigRazor/CXXGraph/master/docs/html/index.html)

## Prerequisites

- The minimum C++ standard required is **C++17** 
- A GCC compiler version 7.3.0 and later *OR* a MSVC compiler that supports C++17

## How to use

To use the library **simply put the header file where you need it.** It's that easy!

## Example

Work in Progress

## Unit-Test Execution

The Unit-Test requires CMake 3.9 and later, and the **[GoogleTest](https://github.com/google/googletest)**  library.

### Install GoogleTest

[GoogleTest](https://github.com/google/googletest)

```bash
git clone https://github.com/google/googletest.git
cd googletest        # Main directory of the cloned repository
mkdir -p build       # Create a directory to hold the build output
cd build
cmake ..             # Generate native build scripts for GoogleTest
make                 # Compile
sudo make install    # Install in /usr/local/ by default
```

### How to Compile GoogleTest

From the base directory:

```bash
mkdir -p build       # Create a directory to hold the build output
cd build             # Enter the build folder
cmake -DTEST=ON ..   # Generate native build scripts for GoogleTest,
make                 # Compile
```

### How to Run GoogleTest

After the build has compiled, run the "test_exe" executable in the "build" directory with the following command: 

`./test_exe`

## Benchmark Execution

The Benchmark requires CMake 3.9 and later, the **GoogleTest** library, and the **Google Benchmark** library.

### Install Google Benchmark

[Google Benchmark](https://github.com/google/benchmark)

```bash
# Check out the library
$ git clone https://github.com/google/benchmark.git
# Google Benchmark requires GoogleTest as a dependency. Add the source tree as a subdirectory
$ git clone https://github.com/google/googletest.git benchmark/googletest
# Go to the library's root directory
$ cd benchmark
# Make a build directory to place the build output
$ cmake -E make_directory "build"
# Generate the build system files with CMake
$ cmake -E chdir "build" cmake -DCMAKE_BUILD_TYPE=Release ../
# If starting with CMake 3.13, you can use the following:
# cmake -DCMAKE_BUILD_TYPE=Release -S . -B "build"
# Build the library
$ cmake --build "build" --config Release
# Install the library
$ sudo cmake --build "build" --config Release --target install
```

### How to Compile Google Benchmark

From the base directory:

```bash
mkdir -p build             # Create a directory to hold the build output
cd build                   # Enter the build folder
cmake -DBENCHMARK=ON ..    # Generate native build scripts for Google Benchmark
make                       # Compile
```

### How to Run Google Benchmark

After the build has compiled, run the "benchmark" executable in the "build" directory with the following command: 

`./benchmark`

### Benchmark Results

You can check the benchmark result using this [link](https://zigrazor.github.io/CXXGraph/dev/bench/).

## Packaging

### Tarballs

To create a tarball package, execute the following from the command line:

```bash
# Enter Packaging Directory
$ cd packaging
# Execute the script to generate tarballs
$ ./tarballs.sh
```

### RPM

#### (Fedora/CentOS/RedHat)

To create an RPM package, execute the following from the command line:

```bash
# Enter Packaging Directory
$ cd packaging/rpm
# Execute the script to generate tarballs
$ ./make_rpm.sh
```

### DEB

#### (Debian/Ubuntu)

To create a deb package, execute the following from the command line:

```bash
# Enter Packaging Directory
$ cd packaging/deb
# Execute the script to generate tarballs
$ ./make_deb.sh
```

## Algorithm Explanation

### Dijkstra

[Graph Dijkstras Shortest Path Algorithm(Dijkstra's Shortest Path)](https://en.wikipedia.org/wiki/Dijkstra%27s_algorithm)
**[Dijkstra's Algorithm]**(https://www.interviewbit.com/blog/find-shortest-path-dijkstras-algorithm/) is used to find the shortest path from a source node to all other reachable nodes in the graph. The algorithm initially assumes all the nodes are unreachable from the given source node so we mark the distances of all nodes as infinity.
(infinity) from source node (INF / infinity denotes unable to reach).

### Dial

Dial specialization of dijkstra’s algorithm.

When edge weights are small integers (bounded by a parameter *C*), specialized queues which take advantage of this fact can be used to speed up Dijkstra's algorithm. The first algorithm of this type was Dial's algorithm (Dial 1969) for graphs with positive integer edge weights, which uses a bucket queue to obtain a running time
*O(|E|+|V|C)*.([source wikipedia](https://en.wikipedia.org/wiki/Dijkstra%27s_algorithm#Specialized_variants))

Below is complete algorithm:

 1. Maintains some buckets, numbered 0, 1, 2,…,wV.
 2. Bucket k contains all temporarily labeled nodes with distance equal to k.
 3. Nodes in each bucket are represented by list of vertices.
 4. Buckets 0, 1, 2,..wV are checked sequentially until the first non-empty bucket is found. Each node contained in the first non-empty bucket has the minimum distance label by definition.
 5. One by one, these nodes with minimum distance label are permanently labeled and deleted from the bucket during the scanning process.
 6. Thus operations involving vertex include:
    - Checking if a bucket is empty
    - Adding a vertex to a bucket
    - Deleting a vertex from a bucket.
 7. The position of a temporarily labeled vertex in the buckets is updated accordingly when the distance label of a vertex changes.
 8. Process repeated until all vertices are permanently labeled (or distances of all vertices are finalized).

At this [link](https://ocw.mit.edu/courses/sloan-school-of-management/15-082j-network-optimization-fall-2010/animations/MIT15_082JF10_av07.pdf) you can find a step-by-step illustrations.

### Prim's Algorithm

[Prim's Algorithm](https://en.wikipedia.org/wiki/Prim%27s_algorithm)
Prim's Algorithm is is a greedy algorithm that finds a minimum spanning tree for a weighted undirected graph. This means it finds a subset of the edges that forms a tree that includes every vertex, where the total weight of all the edges in the tree is minimized. The algorithm operates by building this tree one vertex at a time, from an arbitrary starting vertex, at each step adding the cheapest possible connection from the tree to another vertex.

Steps:

1. Initialize a tree with a single vertex, chosen arbitrarily from the graph.
2. Grow the tree by one edge: of the edges that connect the tree to vertices not yet in the tree, find the minimum-weight edge, and transfer it to the tree.
3. Repeat step 2 (until all vertices are in the tree).

### BFS

(Breadth First Search)
[Breadth First Search Algorithm(Breadth First Search)](https://en.wikipedia.org/wiki/Breadth-first_search)
**Breadth First Search**, also quoted as **BFS**, is a Graph Traversal Algorithm. Time Complexity O(|V| + |E|) where V are the number of vertices and E are the number of edges in the graph.
Applications of Breadth First Search are :

 1. Finding shortest path between two vertices say u and v, with path length measured by number of edges (an advantage over depth first search algorithm)
 2. Ford-Fulkerson Method for computing the maximum flow in a flow network.
 3. Testing bipartiteness of a graph.
 4. Cheney's Algorithm, Copying garbage collection.

  And there are many more...

### DFS

(Depth First Search)
[Depth First Search Algorithm (Depth First Search)](https://en.wikipedia.org/wiki/Depth-first_search)
**Depth First Search**, also quoted as **DFS**, is a Graph Traversal Algorithm. Time Complexity O(|V| + |E|) where V is number of vertices and E is number of edges in graph.
Application of Depth First Search are:

  1. Finding connected components
  2. Finding 2-(edge or vertex)-connected components.
  3. Finding 3-(edge or vertex)-connected components.
  4. Finding the bridges of a graph.
  5. Generating words in order to plot the limit set of a group.
  6. Finding strongly connected components.

  And there are many more...

### Best First Search

[Best First Search](https://en.wikipedia.org/wiki/Best-first_search)
Best First Search is a class of search algorithms which traverses the graph by exploring the most promising node chosen according to an evaluation function. The worst-case time complexity is O(n * log n) where n is the number of nodes in the graph.

### Cycle Detection

[Cycle (graph theory)](https://en.wikipedia.org/wiki/Cycle_(graph_theory))

The existence of a cycle in directed and undirected graphs can be determined by whether depth-first search (DFS) finds an edge that points to an ancestor of the current vertex (it contains a back edge). All the back edges which DFS skips over are part of cycles. In an undirected graph, the edge to the parent of a node should not be counted as a back edge, but finding any other already visited vertex will indicate a back edge. In the case of undirected graphs, only O(n) time is required to find a cycle in an n-vertex graph, since at most n − 1 edges can be tree edges.

Many topological sorting algorithms will detect cycles too, since those are obstacles for topological order to exist. Also, if a directed graph has been divided into strongly connected components, cycles only exist within the components and not between them, since cycles are strongly connected.

For directed graphs, distributed message based algorithms can be used. These algorithms rely on the idea that a message sent by a vertex in a cycle will come back to itself.    Distributed cycle detection algorithms are useful for processing large-scale graphs using a distributed graph processing system on a computer cluster (or supercomputer).

Applications of cycle detection include the use of wait-for graphs to detect deadlocks in concurrent systems.

### Bellman-Ford

[Bellman-Ford Algorithm](https://en.wikipedia.org/wiki/Bellman%E2%80%93Ford_algorithm) can be used to find the shortest distance between a source and a target node. Time Complexity O(|V| . |E|) where V is number of vertices and E is number of edges in graph which is higher than Dijkstra's shortest path algorithm. The time complexity of dijkstra's algorithm is O(|E| + |V| log |v| ). The advantage of bellman-ford over dijkstra is that it can handle graphs with negative edge weights. Further, if the graph contains a negative weight cycle then the algorithm can detect and report the presense of negative cycle.

[This video](https://www.youtube.com/watch?v=24HziTZ8_xo) gives a nice overview of the algorithm implementation. This [MIT lecture](https://courses.csail.mit.edu/6.006/spring11/lectures/lec15.pdf) gives a proof of Bellman-Ford's correctness & its ability to detect negative cycles.
Applications:

- Distance‐vector routing protocol
- Routing Information Protocol (RIP)
- Interior Gateway Routing Protocol (IGRP)

### Floyd Warshall

[Floyd Warshall Algorithm](https://en.wikipedia.org/wiki/Floyd%E2%80%93Warshall_algorithm)

We initialize the solution matrix same as the input graph matrix as a first step. Then we update the solution matrix by considering all vertices as an intermediate vertex. The idea is to one by one pick all vertices and updates all shortest paths which include the picked vertex as an intermediate vertex in the shortest path. When we pick vertex number k as an intermediate vertex, we already have considered vertices {0, 1, 2, .. k-1} as intermediate vertices. For every pair (i, j) of the source and destination vertices respectively, there are two possible cases.

1) k is not an intermediate vertex in shortest path from i to j. We keep the value of dist[i][j] as it is.
2) k is an intermediate vertex in shortest path from i to j. We update the value of dist[i][j] as dist[i][k] + dist[k][j] if dist[i][j] > dist[i][k] + dist[k][j]

### Transitive Reduction

[Transitive Reduction](https://en.wikipedia.org/wiki/Transitive_reduction)

This algorithm is used to construct a directed graph with the same reachability and satisfies transitive closure, with as few edges as possible. More concretely, it creates a minimum equivalent graph with as few edges as possible, removing "short-circuit" paths through the graph.

This is done by iterating through each node-pair, checking to see if two edges exist that leads out of the first node OR out of the last node, removing the node-pair edge if it exists.

In pseudocode:
foreach x in graph.vertices
   foreach y in graph.vertices
      foreach z in graph.vertices
         delete edge xz if edges xy and yz exist

Our implementation has if gates that do early checking for edges in multiple places, which gives it a slightly faster runtime than the cubic pseudocode here.

### Kruskal Algorithm

[Kruskal Algorithm](https://en.wikipedia.org/wiki/Kruskal%27s_algorithm) can be used to find the minimum spanning forest of an undirected edge-weighted graph.  Time Complexity O(E log E) = O(E log V) where V is number of vertices and E is number of edges in graph. The main speed limitation for this algorithm is sorting the edges.

For a quick understanding of the algorithm procedure, check [this video](https://www.youtube.com/watch?v=71UQH7Pr9kU).
Some of the real life applications are:

- LAN/TV Network
- Tour Operations
- Water/gas pipe network
- Electric grid

Other algorithms to find the minimum spanning forest are Prim's algorithm or Borůvka's algorithm.

### Borůvka's Algorithm

[Borůvka's Algorithm](https://en.wikipedia.org/wiki/Bor%C5%AFvka%27s_algorithm#)  is a greedy algorithm that can be used for finding a minimum spanning tree in a graph, or a minimum spanning forest in the case of a graph that is not connected.

The algorithm begins by finding the minimum-weight edge incident to each vertex of the graph, and adding all of those edges to the forest. Then, it repeats a similar process of finding the minimum-weight edge from each tree constructed so far to a different tree, and adding all of those edges to the forest. Each repetition of this process reduces the number of trees, within each connected component of the graph, to at most half of this former value, so after logarithmically many repetitions the process finishes. When it does, the set of edges it has added forms the minimum spanning forest.

Borůvka's algorithm can be shown to take O(log V) iterations of the outer loop until it terminates, and therefore to run in time O(E log V), where E is the number of edges, and V is the number of vertices in G (assuming E ≥ V).

### Graph Slicing based on connectivity

Mathematical definition of the problem:
Let G be the set of nodes in a graph and n be a given node in that set.
Let C be the non-strict subset of G containing both n and all nodes reachable
from n, and let C' be its complement. There's a third set M, which is the
non-strict subset of C containing all nodes that are reachable from any node in C'.
The problem consists of finding all nodes that belong to C but not to M.

Currently implemented Algorithm:

- Use DFS to find all nodes reachable from n. These are elements of set C.
- Initialize C' to be complement of C (i.e. all nodes - nodes that are in C)
- For all nodes in C', apply DFS and get the list of reachable nodes. This is set M.
- Finally removes nodes from C that belong to M. This is our solution.

Application:

This algorithm is used in garbage collection systems to decide which other objects need to be released, given that one object is about to be released.

### Ford-Fulkerson Algorithm

[Ford-Fulkerson Algorithm](https://en.wikipedia.org/wiki/Ford%E2%80%93Fulkerson_algorithm) is a greedy algorithm for finding a maximum flow in a flow network.
The idea behind the algorithm is as follows: as long as there is a path from the source (start node) to the sink (end node), with available capacity on all edges in the path, we send flow along one of the paths. Then we find another path, and so on. A path with available capacity is called an augmenting path.

### Kosaraju's Algorithm
[Kosaraju's Algorithm](https://en.wikipedia.org/wiki/Kosaraju%27s_algorithm) is a linear time algorithm to find the strongly connected components of a directed graph.  It is based on the idea that if one is able to reach a vertex v starting from vertex u, then one should be able to reach vertex u starting from vertex v and if such is the case, one can say that vertices u and v are strongly connected - they are in a strongly connected sub-graph. Following is an example:

1). Create an empty stack ‘S’ and do DFS traversal of a graph. In DFS traversal, after calling recursive DFS for adjacent vertices of a vertex, push the vertex to stack. 
2). Reverse directions of all arcs to obtain the transpose graph. 
3). One by one pop a vertex from S while S is not empty. Let the popped vertex be ‘v’. Take v as source and do DFS (call DFSUtil(v)). The DFS starting from v prints strongly connected component of v.

### Kahn's Algorithm
[Kahn's Algorithm](https://en.wikipedia.org/wiki/Topological_sorting#Kahn's_algorithm) finds topological
ordering by iteratively removing nodes in the graph which have no incoming edges. When a node is removed from the graph, it is added to the topological ordering and all its edges are removed allowing for the next set of nodes with no incoming edges to be selected.
### Welsh Powell Coloring Algorithms
[Welsh Powell Coloring algorithm](https://www.geeksforgeeks.org/welsh-powell-graph-colouring-algorithm/) is a greedy vertex coloring algorithm. This algorithm is also used to find the chromatic number of a graph.

Welsh Powell Algorithm consists of following steps :

1. Find the degree of each vertex.
2. List the vertices in order of descending degrees.
3. Colour the first vertex with color 1.
4. Move down the list and color all the vertices not connected to the coloured vertex, with the same color.
5. Repeat step 4 on all uncolored vertices with a new color, in descending order of degrees until all the vertices are coloured.
   Hi there, I'm creating a pull request to merge the Welsh Powell Coloring algorithm into the master branch.

The algorithm returns a std::map<Node, int> result that assigns each node to a color ordered by integers.
Users can also query the minimum chromatic order of the graph by querying the highest value from the resulting map.
```C++
std::map<Node, int> result = graph.welshPowellColoring();
auto chromatic_color = std::max_element(result.begin(), result.end(),
                                [](const auto& lhs, const auto& rhs) {
                                    return lhs.second < rhs.second;
                                }
```
The minimum coloring starts from 1 instead of 0.

The algorithm assumes the graph to be undirected. All sources and inspirations are linked in the declaration of the algorithm and test cases.
## Partition Algorithm Explanation

### Vertex-Cut

A vertex-cut partitioning divides edges of a graph into equal size partitions. The vertices that hold the endpoints of an edge are also placed in the same partition as the edge itself. However, the vertices are not unique across partitions and might have to be replicated (cut), due to the distribution of their edge across different partitions.

Replication factor quantifies how many vertices are replicated over computers compared with the the number of vertices of the original input graph.

### Edge Balanced Vertex-Cut

This Algorithm is a simple vertex-cut in Round-Robin fashion.
It takes the original graph edges and assign them to the partitions, dividing it in equal(or similar) size. This algorithm does not take care of optimization in vertex replication ( Replication Factor) but only balance the edge in the partitions.

### Greedy Vertex-Cut

Greedy partitioning algorithms uses the entire history of the edge assignments to make the next decision.
The algorithm stores the set of partitions A(v) to which each already observed vertex v has been assigned and the current partition sizes.
When processing edge e ∈ E connecting vertices vi, vj ∈ V , the greedy algorithm follows this simple set of rules:

- Rule 1: If neither vi nor vj have been assigned to a partition, then e is placed in the partition with the smallest size in P.
- Rule 2: If only one of the two vertices has been already assigned (without loss of generality assume that vi is the assigned vertex) then e is placed in the partition with the smallest size in A(vi).
- Rule 3: If A(vi) ∩ A(vj ) 6= ∅, then edge e is placed in the partition with the smallest size in A(vi) ∩ A(vj).
- Rule 4: If A(vi) != ∅, A(vj ) != ∅ and A(vi)∩A(vj ) = ∅, then e is placed in the partition with the smallest size in A(vi)∪A(vj) and a new vertex replica is created accordingly.

### HDRF

High Degree (are) Replicated First(HDRF) Algorithm is a greedy vertex-cut algorithm as described by this [paper](https://www.fabiopetroni.com/Download/petroni2015HDRF.pdf).
This Algorithm try to optimize Replication Factor by using the history of the edge assignements amd the incremental vertex degree.
With a function that take in consideration this two factors calculate the best partition to assign the analyzed edge.
The replica created are based on the degree of the verteices, and the vertices replicated are probably a so called "Hub-Node", which are the vertices with higher degree.

### EBV

Efficient and Balanced Vertex-cut(EBV) is an offline vertex-cut algorithm as described by this [paper](https://arxiv.org/abs/2010.09007).
This algorithm try to balance the partitions with respect to the number of edges and vertices of each partitions and the Replication Factor.
It apply a formula to evaluate the partition in which assigns the edge that take into consideration also the total number of edges and vertices of the graph.
The evaluation formula is the following:

```math
Eva(u,v)(i) =I(u ∈ keep[i]) + I(v ∈ keep[i]) +α * \frac{ecount[i]}{(|E|/p)} + β * \frac{vcount[i]}{(|V|/p)}
```

The lowest value is taken as partition Id.

## Network Dynamics

### Degree Matrix

The Degree Matrix is a square matrix that provides insights into the connectivity of nodes in a graph. For directed graphs, it reflects the number of incoming and outgoing edges for each node, while for undirected graphs, it represents the number of edges incident to each node.

### Laplacian Matrix

The Laplacian Matrix is a square matrix derived from the adjacency matrix and degree matrix of a graph. It is instrumental in analyzing various properties of the graph, such as connectedness, the count of spanning trees, and other spectral characteristics.

### Transition Matrix

The Transition Matrix is commonly used in the study of Markov Chains and stochastic processes. Within the context of a graph, it denotes the probabilities of transitioning from one node to another, often based on the edge weights or predetermined criteria. This matrix finds applications in various fields such as network analysis, machine learning, and optimization.

## How to contribute

[![GitHub contributors](https://img.shields.io/github/contributors/ZigRazor/CXXGraph.svg)](https://GitHub.com/ZigRazor/CXXGraph/graphs/contributors/)
If you want to give your support you can create a ***pull request***   [![GitHub pull-requests](https://img.shields.io/github/issues-pr/ZigRazor/CXXGraph.svg)](https://GitHub.com/ZigRazor/CXXGraph/pull/) or report an ***issue***  [![GitHub issues](https://img.shields.io/github/issues/ZigRazor/CXXGraph.svg)](https://GitHub.com/ZigRazor/CXXGraph/issues/).
If you want to change the code, fix an issue, or implement a new feature please read our [CONTRIBUTING Guide](https://github.com/ZigRazor/CXXGraph/blob/master/CONTRIBUTING.md).

If you want to discuss new features or you have any questions or suggestions about the library, please open a [Discussion](https://github.com/ZigRazor/CXXGraph/discussions) or simply chat on [![Join the chat at https://gitter.im/CXXGraph-Community/community](https://badges.gitter.im/CXXGraph-Community/community.svg)](https://gitter.im/CXXGraph-Community/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

## Stars History

[![Star History Chart](https://api.star-history.com/svg?repos=ZigRazor/CXXGraph&type=Date)](https://star-history.com/#ZigRazor/CXXGraph&Date)

## Site

[CXXGraph Site](https://zigrazor.github.io/CXXGraph/)

## Contact

E-mail : zigrazor@gmail.com

[![Join the chat at https://gitter.im/CXXGraph-Community/community](https://badges.gitter.im/CXXGraph-Community/community.svg)](https://gitter.im/CXXGraph-Community/community?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

[GitHub Profile](https://github.com/ZigRazor) ![Profile views](https://gpvc.arturio.dev/ZigRazor)

![ZigRazor's github stats](https://github-readme-stats.vercel.app/api?username=ZigRazor&show_icons=true&title_color=fff&icon_color=79ff97&text_color=9f9f9f&bg_color=151515)

## Support

To support me, add a ***Star*** to the project  [![GitHub stars](https://img.shields.io/github/stars/ZigRazor/CXXGraph.svg?style=social&label=Star&maxAge=2592000)](https://GitHub.com/ZigRazor/CXXGraph/stargazers/) or ***follow me***  [![GitHub followers](https://img.shields.io/github/followers/ZigRazor.svg?style=social&label=Follow&maxAge=2592000)](https://github.com/ZigRazor?tab=followers)

To stay updated, ***watch*** the project  [![GitHub watchers](https://img.shields.io/github/watchers/ZigRazor/CXXGraph.svg?style=social&label=Watch&maxAge=2592000)](https://GitHub.com/ZigRazor/CXXGraph/watchers/)

## References

We are referenced by:

- [awesome-hpp](https://github.com/p-ranav/awesome-hpp)
- [cppreference.com](https://en.cppreference.com/w/cpp/links/libs)
- [awesome-cpp](https://github.com/fffaraz/awesome-cpp)

## Credits

Thanks to the community of [TheAlgorithms](https://github.com/TheAlgorithms) for some algorithm inspiration.

Thanks to [GeeksForGeeks](https://www.geeksforgeeks.org/) for some algorithm inspiration.

## Contributors

Thank you to all the people who have already contributed to CXXGraph!

[![Contributors](https://contrib.rocks/image?repo=zigrazor/CXXGraph)](https://github.com/ZigRazor/CXXGraph/graphs/contributors) 

## Cite Us

If you use this software please follow the [CITATION](https://github.com/ZigRazor/CXXGraph/blob/master/CITATION) instructions.
Thank you!

## Hacktoberfest 2k21

We participated at Hacktoberfest 2021. Thank you to all the contributors!

## Hacktoberfest 2k22

We participated at Hacktoberfest 2022. Thank you to all the contributors!

## Hacktoberfest 2k23

We participated at Hacktoberfest 2023. Thank you to all the contributors!

## Other Details

View the [Estimated Value of the Project](https://www.openhub.net/p/CXXGraph/estimated_cost)

## Author

| [<img src="https://avatars0.githubusercontent.com/u/6591180?s=460&v=4" width="100"><br><sub>@ZigRazor</sub>](https://github.com/ZigRazor) |
|:----:|

![footer](https://raw.github.com/ZigRazor/CXXGraph/master/logos/CXXGraph_footer.gif)
