# 《强化学习：原理与Python实战》数学记号

### 一般规律

- 大写是随机事件或随机变量，小写是确定性事件或确定性变量。
- 衬线体（如 $X$ ）是数值，非衬线体（如 $\mathsfit{X}$ ）则不一定是数值。为概率计算统计量的算子（包括 $\text{E}$ 、 $\Pr$ 、 $\text{Var}$ 、 $\text{H}$ ）不斜体。
- 粗体是向量（如 $\mathbfit{w}$ ）或矩阵（如 $\mathbfit{F}$ ）（矩阵用大写，即使是确定量也是如此）。
- 花体（如 $\mathcal{X}$ ）是集合。
- 哥特体（如 $\mathfrak{f}$ ）是映射。

### 数学记号表

下表列出常用记号。部分小节会有局部定义的记号，以该局部定义为准。

| 英语字母 | 含义 | 英文含义 |
| :---: | --- | --- |
| $A$, $a$ | 优势 | advantage |
| $\mathsfit{A}$, $\mathsfit{a}$ | 动作 | action |
| $\mathcal{A}$ | 动作空间 | action space |
| $B$, $b$ | 策略梯度算法中的基线；部分可观测任务中的数值化信念；（仅小写）额外量；异策学习时的行为策略 | baseline in policy gradient; numerical belief in partially observable tasks; (lower case only) bonus; behavior policy in off-policy learning |
| $\mathsfit{B}$, $\mathsfit{b}$ | 部分可观测任务中的信念 | belief in partially observable tasks |
| $\mathfrak{B}_ \pi$, $\mathfrak{b}_ \pi$ | 策略 $\pi$ 的Bellman期望算子（大写只用于值分布学习） | Bellman expectation operator of policy $\pi$ (upper case only used in distributional RL) |
| $\mathfrak{B}_ \ast$, $\mathfrak{b}_ \ast$ | Bellman最优算子（大写只用于值分布学习） | Bellman optimal operator (upper case only used in distributional RL) |
| $\mathcal{B}$ | 经验回放中抽取的一批经验；部分可观测任务中的信念空间 | a batch of transition generated by experience replay; belief space in partially observable tasks |
| $\mathcal{B}^+$ | 部分可观测任务中带终止信念的信念空间 | belief space with terminal belief in partially observable tasks |
| $c$ | 计数值；线性规划的目标系数 | counting; coefficients in linear programming |
| $d$, $d_ \infty$ | 度量 | metrics |
| $d_f$ | $f$ 散度 | $f$ -divergence |
| $d_ \text{KL}$ | KL散度 | KL divergence |
| $d_ \text{JS}$ | JS散度 | JS divergence |
| $d_ \text{TV}$ | 全变差 | total variation |
| $D$ | 回合结束指示 | indicator of episode end |
| $\mathcal{D}$ | 经验集 | set of experience |
| $e$ | 资格迹 | eligibility trace |
| $\text{e}$ | 自然对数 | the constant $\text{e}$ ($\approx 2.72$) |
| $\text{E}$ | 期望 | expectation |
| $\mathfrak{f}$ | 一般的映射 | a mapping |
| $\mathbfit{F}$ | Fisher信息矩阵 | Fisher information matrix |
| $G$, $g$ | 回报 | return |
| $\mathbfit{g}$ | 梯度向量 | gradient vector |
| $h$ | 动作偏好 | action preference |
| $\text{H}$ | 熵 | entropy |
| $k$ | 迭代次数指标 | index of iteration |
| $\ell$ | 损失 | loss |
| $o$ | 部分可观测环境的观测概率；渐近无穷小 | observation probability in partially observable tasks; infinitesimal in asymptotic notations |
| $O$, $\tilde{O}$ | 渐近无穷大 | infinite in asymptotic notations |
| $\mathsfit{O}$, $\mathsfit{o}$ | 观测 | observation|
| $p$ | 概率值，动力 | probability, dynamics |
| $\mathbfit{P}$ | 转移矩阵 | transition matrix |
| $\Pr$ | 概率 | probability |
| $Q$, $q$ | 动作价值 | action value |
| $Q_ \pi$, $q_ \pi$ | 策略 $\pi$ 的动作价值（大写只用于值分布学习） | action value of policy $\pi$ (upper case only used in distributional RL) |
| $Q_ \ast$, $q_ \ast$ | 最优动作价值（大写只用于值分布学习） | optimal action values (upper case only used in distributional RL) |
| $\mathbfit{q}$ | 动作价值的向量表示 | vector representation of action values |
| $R$, $r$ | 奖励 | reward |
| $\mathcal{R}$ | 奖励空间 | reward space |
| $\mathsfit{S}$, $\mathsfit{s}$ | 状态 | state |
| $\mathcal{S}$ | 状态空间 | state space |
| $\mathcal{S}^+$ | 带终止状态的状态空间 | state space with terminal state |
| $T$ | 回合步数 | steps in an episode |
| $\mathsfit{T}$, $\mathsfit{t}$ | 轨迹 | trajectory |
| $\mathfrak{u}$ | 部分可观测任务中的信念更新算子 | belief update operator in partially observable tasks |
| $U$, $u$ | 用自益得到的回报估计随机变量；小写的$u$还表示置信上界 | TD target; (lower case only) upper bound |
| $V$, $v$ | 状态价值 | state value |
| $V_ \pi$, $v_ \pi$ | 策略 $\pi$ 的状态价值（大写只用于值分布学习） | state value of the policy $\pi (upper case only used in distributional RL) |
| $V_ \ast$, $v_ \ast$ | 最优状态价值（大写只用于值分布学习） | optimal state values (upper case only used in distributional RL) |
| $\mathbfit{v}$ | 状态价值的向量表示 | vector representation of state values |
| $\text{Var}$ | 方差 | variance |
| $\mathbfit{w}$ | 价值估计参数 | parameters of value function estimate |
| $\mathsfit{X}$, $\mathsfit{x}$ | 一般的事件 | an event |
| $\mathcal{X}$ | 一般的事件空间 | event space |
| $\mathbfit{z}$ | 资格迹参数 | parameters for eligibility trace |
| **希腊字母** | **含义** | **英文含义** |
| $\alpha$ | 学习率 | learning rate |
| $\beta$ | 资格迹算法中的强化强度；值分布学习中的扭曲函数 | reinforce strength in eligibility trace; distortion function in distributional RL |
| $\gamma$ | 折扣因子 | discount factor |
| $\mathit\Delta$, $\delta$ | 时序差分误差 | TD error |
| $\varepsilon$ | 探索参数 | parameters for exploration |
| $\lambda$ | 资格迹衰减强度 | decay strength of eligibility trace |
| $\mathit\Pi$, $\pi$ | 策略 | policy |
| $\pi_ \ast$ | 最优策略 | optimal policy |
| $\uppi$ | 圆周率 | the constant $\uppi$ ($\approx 3.14$) |
| $\boldsymbol\theta$ | 策略估计参数 | parameters for policy function estimates |
| $\vartheta$ | 价值迭代终止阈值 | threshold for value iteration |
| $\rho$ | 访问频次；异策算法中的重要性采样比率 | visitation frequency; important sampling ratio in off-policy learning |
| $\boldsymbol\rho$ | 访问频次的向量表示 | vector representation of visitation frequency |
| $\phi$ | 分位数 | quantile |
| ${\huge\tau}$, $\tau$ | 半Markov决策过程中的逗留时间 | sojourn time of SMDP |
| $\mathit\Omega$, $\omega$ | 值分布学习中的累积概率；（仅小写）部分可观测任务中的条件概率 | cumulative probability in distribution RL; (lower case only) conditional probability for partially observable tasks |
| $\mathit\Psi$ | 扩展的优势估计 | Generalized Advantage Estimate (GAE) |
| **其他符号** | **含义** | **英文含义** |
| $\stackrel{\text{d}}{=}$ | 分布相同 | share the same distribution |
| $\stackrel{\text{几乎处处}}{=}$ | 几乎处处相等 | equal almost everywhere |
| $\lt$, $\leqslant$, $\geqslant$, $\gt$ | 普通数值比较；向量逐元素比较 | compare numbers; element-wise comparison |
| $\prec$, $\preccurlyeq$, $\succcurlyeq$, $\succ$ | 偏序关系 | partial order |
| $\ll$ | 绝对连续 | absolute continuous |
| $\varnothing$ | 空集 | empty set |
| $\nabla$ | 梯度 | gradient |
| $\sim$ | 服从分布；效用相同 | obey a distribution; utility equivalence in distributional RL |
| $\left\|\quad\right\|$ | 实数的绝对值；向量或矩阵的逐元素求绝对值；集合的元素个数 | absolute value of a real number; element-wise absolute values of a vector or a matrix; the number of elements in a set |
