<?php
/**
 * The view file of charter module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     charter
 * @link        https://www.zentao.net
 */
namespace zin;

$statusLabel = '';
if($charter->status == 'launched') $statusLabel = 'success-outline';
if($charter->status == 'failed')   $statusLabel = 'danger-outline';

$tableData = array();
foreach($groupDate as $productID => $roadmapList)
{
    $roadmapData = array();
    foreach($roadmapList as $roadmap)
    {
        $roadmapLink = $this->createLink('roadmap', 'view', "roadmapID=$roadmap->id");
        $roadmapData[] = div(common::hasPriv('roadmap', 'view') ? html(html::a($roadmapLink, $roadmap->name)) : $roadmap->name);
    }
    $productLink = $this->createLink('product', 'view', "productID=$productID");
    $tableData[] = h::tr(setClass('text-center'), h::td(common::hasPriv('product', 'view') ? html(html::a($productLink, zget($products, $productID))) : zget($products, $productID)), h::td($roadmapData));
}

$fileData = array();
foreach($lang->charter->charterList as $key => $name)
{
    $charterFiles = $charter->charterFiles;
    if(isset($charterFiles[$key]))
    {
        $fileID     = $charterFiles[$key]['id'];
        $files      = array($fileID => $charter->files[$fileID]);
        $fileData[] = div(setClass('flex'), cell(set::width('70px'), setClass('text-right text-gray'), $name), cell(setClass('pl-4'), fileList(set::files($files), set::object($charter), set::fieldset(false), set::showEdit(false))));
    }
}

$reviewedBy = '';
if(!empty($charter->reviewedBy))
{
    foreach(explode(',', $charter->reviewedBy) as $account)
    {
        if(empty($account)) continue;
        $reviewedBy .= zget($users, trim($account)) . ' ';
    }
}

$config->charter->roadmapStory->fieldList['roadmap']['map'] = $roadmaps;
$config->charter->roadmapStory->fieldList['module']['map']  = $modules;

$operateList = $this->loadModel('common')->buildOperateMenu($charter);
$actions = array(array('icon' => 'back', 'text' => $lang->goback, 'type' => 'ghost', 'back' => true), array('type' => 'divider'));
$actions = array_merge($actions, $operateList['mainActions']);
if(!empty($operateList['suffixActions'])) $actions = array_merge($actions, array(array('type' => 'divider')), $operateList['suffixActions']);

jsVar('browseType', $_SESSION['browseType']);
jsVar('storyGrades', $storyGrades);
div
(
    panel
    (
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span(setClass('label font-normal outline'), $charter->id),
                span(setClass('label font-normal', $statusLabel), zget($lang->charter->statusList, $charter->status)),
                span($charter->name),
                $charter->deleted ? span(setClass('label danger'), $lang->charter->deleted) : null
            )
        ),
        div
        (
            setClass('flex flex-wrap'),
            cell(set::width('1/3'), setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->category),  cell(setClass('pl-4 font-bold'), zget($lang->charter->categoryList, $charter->category))),
            cell(set::width('1/3'), setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->level),     cell(setClass('pl-4 font-bold'), priLabel(zget($lang->charter->levelList, $charter->level)))),
            cell(set::width('1/3'), setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->market),    cell(setClass('pl-4 font-bold'), zget($lang->charter->marketList, $charter->market))),
            cell(set::width('1/3'), setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->appliedBy), cell(setClass('pl-4 font-bold'), zget($users, $charter->appliedBy))),
            cell(set::width('1/3'), setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->budget),    cell(setClass('pl-4 font-bold'), $charter->budget))
        )
    ),
    panel
    (
        setClass('mt-4'),
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span($lang->charter->spec)
            )
        ),
        html(htmlspecialchars_decode($charter->spec))
    ),
    panel
    (
        setClass('mt-4'),
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span($lang->charter->productRoadmap)
            )
        ),
        div
        (
            h::table
            (
                setClass('table bordered'),
                h::tr(h::th($lang->charter->linkProduct), h::th($lang->charter->linkRoadmap)),
                $tableData
            )
        )
    ),
    $charter->charterFiles ? panel
    (
        setClass('mt-4'),
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span($lang->charter->charterFiles)
            )
        ),
        div($fileData)
    ) : null,
    $charter->status != 'wait' ? panel
    (
        setClass('mt-4'),
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span($lang->charter->review)
            )
        ),
        div(setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->review),          cell(setClass('pl-4 font-bold', $charter->status == 'failed' ? 'tetx-danger' : 'text-success'), zget($lang->charter->reviewResultList, $charter->reviewedResult))),
        div(setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->reviewer),        cell(setClass('pl-4 font-bold'), $reviewedBy)),
        div(setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->meetingDate),     cell(setClass('pl-4 font-bold'), $charter->meetingDate)),
        div(setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->meetingLocation), cell(setClass('pl-4 font-bold'), $charter->meetingLocation)),
        div(setClass('flex py-2'), cell(set::width('70px'), setClass('text-right text-gray'), $lang->charter->meetingMinutes),  cell(setClass('pl-4'), html($charter->meetingMinutes)))
    ) : null,
    panel
    (
        setClass('mt-4'),
        set::shadow(true),
        to::heading
        (
            div
            (
                setClass('panel-title'),
                span($lang->charter->roadmapStory)
            )
        ),
        dtable
        (
            set::nested(true),
            set::cols($config->charter->roadmapStory->fieldList),
            set::data(array_values($stories)),
            set::onRenderCell(jsRaw('window.onRenderCell'))
        )
    ),
    panel(setClass('mt-4'), set::shadow(true), history())
);

div
(
    setClass('detail-actions center sticky mt-4 bottom-4 z-10'),
    setKey('actions'),
    div
    (
        setClass('bg-black text-fore-in-dark backdrop-blur bg-opacity-60 rounded p-1.5'),
        toolbar
        (
            set::urlFormatter(array('{id}' => $charter->id)),
            set::btnType('ghost'),
            set(array('items' => $actions))
        )
    )
);
