<?php
namespace zin;

global $lang, $app;

$fields = defineFieldList('charter.review');

$readonly = empty(data('launchedCharter')) ? false : true;
$readonly = empty(data('charter.reviewedResult')) ? false : true;
$fields->field('reviewedResult')->label($lang->charter->review)->control('picker')->items($lang->charter->reviewResultList)->value(data('charter.reviewedResult'))->width('1/2')->required(true)->readonly($readonly)->tip(data('launchedCharter') && data('launchedCharter.id') != data('charter.id') && data('charter.status') == 'wait' ? sprintf($lang->charter->roadmapConflict, data('launchedCharter.id'), data('launchedCharter.name')) : '');

$fields->field('reviewerBox')
    ->width('1/2')
    ->required(true)
    ->label($lang->charter->reviewer)
    ->control('inputGroup')
    ->itemBegin('reviewedBy')
    ->control('picker')
    ->multiple(true)
    ->items(data('users'))
    ->value(data('charter.reviewedBy'))->itemEnd()
    ->itemBegin('check')
    ->control('checkbox')
    ->rootClass('center check-meeting w-32')
    ->checked(data('charter.check'))
    ->set('data-on',     'change')
    ->set('data-call',   'checkMeeting')
    ->set('data-params', 'event')
    ->text($lang->charter->meetingMinutes)
    ->value(1)
    ->itemEnd();

$fields->field('meetingDate')->hidden(!data('charter.check'))->control('datePicker')->value(data('charter.meetingDate') ? data('charter.meetingDate') : helper::today())->width('1/2');
$fields->field('meetingLocation')->hidden(!data('charter.check'))->control('input')->value(data('charter.meetingLocation'))->width('1/2');
$fields->field('meetingMinutes')->hidden(!data('charter.check'))->control('editor')->value(data('charter.meetingMinutes'));
