<?php
/**
 * The browse view file of charter module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     charter
 * @link        https://www.zentao.net
 */
namespace zin;

$charters = initTableData($charters, $config->charter->dtable->fieldList, $this->charter);

$linkParams = '';
foreach($app->rawParams as $key => $value) $linkParams = $key != 'orderBy' ? "{$linkParams}&{$key}={$value}" : "{$linkParams}&orderBy={name}_{sortType}";

jsVar('browseType', $browseType);

featureBar(li(searchToggle(set::open($browseType == 'bysearch'))));

toolbar
(
    hasPriv('charter', 'create') ? item
    (
        setClass('primary charter-create-btn'),
        set::icon('plus'),
        set::url(createLink('charter', 'create')),
        set::text($lang->charter->create)
    ) : null
);

dtable
(
    set::cols(array_values($config->charter->dtable->fieldList)),
    set::data(array_values($charters)),
    set::userMap($users),
    set::fixedLeftWidth('44%'),
    set::orderBy($orderBy),
    set::sortLink(createLink($app->rawModule, $app->rawMethod, $linkParams)),
    set::footPager(usePager())
);

render();
