<?php
/**
 * The managestep view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

unset($lang->deploy->stageList['testing']);
$steps = array();
foreach($stepGroups as $step) $steps = array_merge($steps, $step);
formBatchPanel
(
    set::idKey('index'),
    set::title($object->name . $lang->hyphen . $lang->deploy->manageStep),
    set::headingActionsClass('flex-auto'),
    set::data(array_values($steps)),
    to::headingActions(
        label
        (
            setClass('primary'),
            substr($object->begin, 0, 16) . ' ~ ' . substr($object->end, 0, 16)
        )
    ),
    formBatchItem
    (
        set::name('id'),
        set::label($lang->idAB),
        set::control('hidden'),
        set::hidden(true)
    ),
    formBatchItem
    (
        set::name('id'),
        set::label($lang->idAB),
        set::control('index'),
        set::width('32px')
    ),
    formBatchItem
    (
        set::name('stage'),
        set::label($lang->deploy->stage),
        set::control('picker'),
        set::items($lang->deploy->stageList),
        set::width('120px'),
        set::required(true),
        set::ditto(true)
    ),
    formBatchItem
    (
        set::name('begin'),
        set::label($lang->deploy->begin),
        set::control('datetimepicker'),
        set::width('140px'),
        set::required(true)
    ),
    formBatchItem
    (
        set::name('end'),
        set::label($lang->deploy->end),
        set::control('datetimepicker'),
        set::width('140px'),
        set::required(true)
    ),
    formBatchItem
    (
        set::name('title'),
        set::label($lang->deploy->title),
        set::required(true)
    ),
    formBatchItem
    (
        set::name('content'),
        set::label($lang->deploy->content),
        set::control('textarea')
    ),
    formBatchItem
    (
        set::name('assignedTo'),
        set::label($lang->deploy->assignedTo),
        set::control('picker'),
        set::items($users),
        set::width('128px'),
        set::ditto(true)
    )
);
