<?php
namespace zin;

global $lang;

jsVar('currentMethod', 'edit');

$projectID = data('projectID');
$from      = data('from');
$programID = data('programID');
$loadUrl   = helper::createLink('project', 'edit', "projectID={$projectID}&from={$from}&programID={$programID}&extra=charter={charter}");
query('formGridPanel')->each(function($node) use($lang, $loadUrl)
{
    $fields = $node->prop('fields');

    $fields->field('charter')
        ->class('charterBox')
        ->control('picker')
        ->items(data('charters'))
        ->value(data('project.charter'))
        ->disabled(data('disableModel'))
        ->moveBefore('parent');

    $fields->field('hasProduct')->hidden(data('model') == 'ipd');

    $fields->field('category')
        ->class('categoryBox')
        ->control('picker')
        ->items($lang->project->categoryList)
        ->value(data('project.category'))
        ->moveAfter('parent');

    $fields->field('budget')
        ->foldable(false)
        ->moveAfter('category');

    if(data('model') != 'ipd')
    {
        $fields->remove('category');
        $fields->orders('hasProduct,budget');
    }
    else
    {
        $fields->orders('category,budget');
    }

    $fields->field('productsBox')
        ->width('full')
        ->required(data('copyProject.parent') || data('parentProgram.id') || data('project.parent'))
        ->hidden(!data('charter') && !data('project.hasProduct'))
        ->control(array
        (
            'control'           => 'productsBox',
            'productItems'      => data('charter') ? data('charterProductPairs') : data('allProducts'),
            'branchGroups'      => data('charter') ? data('branchPairs') : data('branchGroups'),
            'planGroups'        => data('productPlans'),
            'roadmapGroups'     => data('productRoadmaps'),
            'productPlans'      => data('productPlans'),
            'linkedProducts'    => data('charter') ? data('charterProducts') : data('linkedProducts'),
            'linkedBranches'    => data('linkedBranches'),
            'project'           => data('project') ? data('project') : data('copyProject'),
            'hasNewProduct'     => data('app.rawMethod') == 'create',
            'isStage'           => data('isStage'),
            'type'              => data('charter') ? 'roadmap' : 'plan',
            'errorSameProducts' => $lang->project->errorSameProducts,
            'selectTip'         => $lang->project->selectProductTip
        ));

    $fields->autoLoad('charter', 'productsBox');

    $node->setProp('fields', $fields);
    $node->setProp('loadUrl', $loadUrl);
});

query('.charterBox .picker-box')->on('change', jsCallback()->call('changeCharter'));
query('.categoryBox .picker-box')->on('change', jsCallback()->call('changeCategory'));
