<?php
/**
 * The view file of service module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
namespace zin;

global $lang;

detailHeader
(
    to::title(
        entityLabel(
            set(array('entityID' => $service->id, 'level' => 1, 'text' => $service->name))
        ),
        $service->deleted == 1 ? label(setClass('danger-outline'), $lang->deleted) : null
    )
);

$hosts = array();
if($service->hosts)
{
    foreach(explode(',', $service->hosts) as $host)
    {
        if(isset($hosts[$host])) $hosts[] = $hosts[$host];
    }
}

if($service->deleted == 1 || !hasPriv('service', 'edit'))   unset($config->service->actionList['edit']);
if($service->deleted == 1 || !hasPriv('service', 'delete')) unset($config->service->actionList['delete']);

detailBody
(
    setID('serviceViewPage'),
    sectionList
    (
        section
        (
            setClass('flex-1 mr-4'),
            tableData
            (
                set::useTable(false),
                item
                (
                    set::trClass('border-b pb-4'),
                    set::name($lang->service->host),
                    implode(' ', $hosts)
                ),
                item
                (
                    set::trClass('border-b py-4'),
                    set::name($lang->service->entry),
                    $service->entry
                ),
                item
                (
                    set::trClass('border-b py-4'),
                    set::name($lang->service->deploy),
                    $service->deploy
                ),
                item
                (
                    set::trClass('border-b py-4'),
                    set::name($lang->service->port),
                    $service->port
                ),
                item
                (
                    set::trClass('border-b py-4'),
                    set::name($lang->service->external),
                    $service->external
                ),
                item
                (
                    set::trClass('pt-4'),
                    set::name($lang->service->desc),
                    html($service->desc)
                )
            )
        ),
        section
        (
            setClass('w-1/4'),
            set::title($lang->service->basicInfo),
            tableData
            (
                item
                (
                    set::name($lang->service->dept),
                    zget($depts, $service->dept)
                ),
                item
                (
                    set::name($lang->service->type),
                    zget($lang->service->typeList, $service->type)
                )
            )
        )
    ),
    history
    (
        set::commentUrl(createLink('action', 'comment', array('objectType' => 'service', 'objectID' => $service->id)))
    ),
    floatToolbar
    (
        isAjaxRequest('modal') ? null : to::prefix
        (
            backBtn
            (
                set::icon('back'),
                set::className('ghost text-white'),
                $lang->goback
            )
        ),
        set::object($service),
        set::suffix($config->service->actionList)
    )
);
