<?php
/**
 * The browse view file of service module of ZenTaoPMS.
 * @copyright   Copyright 2009-2024 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yanyi Cao <caoyanyi@easycorp.ltd>
 * @package     service
 * @link        https://www.zentao.net
 */
namespace zin;

featureBar();
toolbar
(
    btnGroup
    (
        btn
        (
            setClass('btn primary'),
            set::url(createLink('service', 'manage')),
            set::icon('program'),
            $lang->service->TreeView
        ),
        hasPriv('service', 'create') ? btn
        (
            setClass('btn primary ml-2'),
            set::icon('plus'),
            set::url(createLink('service', 'create')),
            $lang->service->createTop
        ) : null
    )
);

$config->service->dtable->fieldList['hosts']['map'] = $hosts;
$tableData = initTableData($serviceList, $config->service->dtable->fieldList, $this->service);
dtable
(
    set::orderBy($orderBy),
    set::sortLink(createLink('service', 'browse', "browseType={$browseType}&param={$param}&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}&pageID={$pager->pageID}")),
    set::cols($config->service->dtable->fieldList),
    set::data($tableData),
    set::footPager(usePager())
);
