<?php
namespace zin;

global $lang, $config;

$customFields = data('customFields');
$zentaoApp    = data('zentaoApp');
if($zentaoApp) jsVar('zentaoApp', $zentaoApp);
if($customFields)
{
    jsVar('customFields', $customFields);
    $config->instance->dtable->custom->fieldList['value']['onRenderCell'] = jsRaw('renderCustomField');
    $fields = array();
    foreach($customFields as $field)
    {
        if(!hasPriv('instance', 'manage') && $field->type == 'password') $field->value = preg_replace('/./', '*', $field->value);

        $fields[] = h::tr
        (
            h::td($field->label),
            h::td(hasPriv('instance', 'manage') ? input
            (
                setClass('custom-field'),
                set::type($field->type),
                set::name($field->name),
                set::value($field->value),
                set::autocomplete('new-password'),
                on::input('setCustomField')
            ) : $field->value),
            h::td($field->desc)
        );
    }

    $instance = data('instance');
    query('.section-list')->append(section
    (
        set::title($lang->instance->custom->title),
        formbase
        (
            set::url(createLink('instance', 'setting', "instanceID={$instance->id}&type=custom")),
            set::actions(array()),
            h::table
            (
                setClass('table w-full max-w-full bordered mt-4'),
                h::tr
                (
                    h::th(setClass('w-1/3'), $lang->instance->custom->name),
                    h::th($lang->instance->custom->value),
                    h::th(setClass('w-1/3'), $lang->instance->custom->desc)
                ),
                $fields,
                hasPriv('instance', 'manage') ? h::tr
                (
                    h::td(
                        set::colspan(3),
                        setClass('no-label text-center'),
                        btn
                        (
                            setClass('primary custom-btn disabled'),
                            $lang->save
                        )
                    )
                ) : null
            )
        )
    ));
}
