<?php
/**
 * The view view file of domain module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     domain
 * @link        https://www.zentao.net
 */
namespace zin;

global $lang;

if(isAjaxRequest('modal'))
{
    $config->domain->actionList['edit']['data-load'] = 'modal';
    unset($config->domain->actionList['edit']['data-toggle']);
}

detailHeader
(
    isAjaxRequest('modal') ? to::prefix() : '',
    to::title(
        entityLabel(
            set(array('entityID' => $domain->id, 'level' => 1, 'text' => $domain->domain))
        ),
        $domain->deleted == 1 ? label(setClass('danger-outline'), $lang->deleted) : null
    )
);

detailBody
(
    sectionList
    (
        section
        (
            tableData
            (
                item
                (
                    set::name($lang->domain->domain),
                    $domain->domain
                ),
                item
                (
                    set::name($lang->domain->adminURI),
                    $domain->adminURI
                ),
                item
                (
                    set::name($lang->domain->resolverURI),
                    $domain->resolverURI
                ),
                item
                (
                    set::name($lang->domain->register),
                    $domain->register
                ),
                item
                (
                    set::name($lang->domain->expiredDate),
                    substr($domain->expiredDate, 0, 10)
                ),
                item
                (
                    set::name($lang->domain->renew),
                    $lang->domain->renewMethod[$domain->renew]
                ),
                item
                (
                    set::name($lang->domain->account),
                    $domain->account
                )
            )
        )
    ),
    history
    (
        set::commentUrl(createLink('action', 'comment', array('objectType' => 'domain', 'objectID' => $domain->id)))
    ),
    floatToolbar
    (
        set::object($domain),
        isAjaxRequest('modal') ? null :
        to::prefix
        (
            backBtn
            (
                set::icon('back'),
                set::className('ghost text-white'),
                $lang->goback
            )
        ),
        $domain->deleted == 1 ? null : set::suffix($config->domain->actionList)
    )
);

render();
