<?php
/**
 * The finish view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

$serviceList = array();
if(!empty($services))
{
    foreach($services as $service)
    {
        $serviceList[] = h::tr
        (
            h::td($service->id),
            h::td(isset($optionMenu[$service->id]) ? $optionMenu[$service->id] : $service->name),
            h::td(input(set::name("version[$service->id]"), set::value($service->version))),
            h::td(input(set::name("softName[$service->id]"), set::value($service->softName))),
            h::td(input(set::name("softVersion[$service->id]"), set::value($service->softVersion))),
            h::td(checkbox(set::name("updateHost[$service->id]"), set::rootClass('justify-center'), set::checked(true), set::value(1)))
        );
    }
}

modalHeader
(
    set::title($lang->deploy->finish)
);

formPanel
(
    formGroup
    (
        set::width('1/2'),
        set::label($lang->deploy->result),
        picker
        (
            set::name('result'),
            set::items($lang->deploy->resultList),
            on::change('window.showServices')
        )
    ),
    empty($serviceList) ? null : formGroup
    (
        set::label($lang->deploy->service),
        set::id('serviceList'),
        setClass('hidden'),
        h::table
        (
            setClass('table table-fixed condensed bordered mb-4 mt-2 text-center'),
            h::tr
            (
                h::th(set::width('30px'), $lang->idAB),
                h::th(set::width('120px'), $lang->service->name),
                h::th($lang->service->version),
                h::th(set::width('120px'), $lang->service->softName),
                h::th($lang->service->softVersion),
                h::th($lang->deploy->updateHost)
            ),
            $serviceList
        )
    ),
    formGroup
    (
        set::label($lang->comment),
        set::control('editor'),
        set::name('comment'),
        set::row(10)
    )
);
