-- DROP TABLE IF EXISTS `zt_space`;
CREATE TABLE `zt_space` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `k8space` char(64) NOT NULL,
  `owner` char(30) NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime NOT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_instance`;
CREATE TABLE IF NOT EXISTS `zt_instance` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `solution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(50) NOT NULL DEFAULT '',
  `appID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `appName` char(50) NOT NULL DEFAULT '',
  `appVersion` char(20) NOT NULL DEFAULT '',
  `chart` char(50) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `version` char(50) NOT NULL DEFAULT '',
  `desc` text NULL,
  `introduction` text NULL,
  `source` char(20) NOT NULL DEFAULT '',
  `channel` char(20) NOT NULL DEFAULT '',
  `k8name` char(64) NOT NULL DEFAULT '',
  `status` char(20) NOT NULL DEFAULT '',
  `pinned` enum('0', '1') NOT NULL DEFAULT '0',
  `domain` char(255) NOT NULL DEFAULT '',
  `smtpSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSettings` text NULL,
  `dbSettings` text NULL,
  `autoBackup` tinyint(1) NOT NULL DEFAULT 0,
  `backupKeepDays` int unsigned NOT NULL DEFAULT 1,
  `autoRestore` tinyint(1) NOT NULL DEFAULT 0,
  `env` text NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdAt` datetime NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `space` (`space`),
  KEY `k8name` (`k8name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_solution`;
CREATE TABLE IF NOT EXISTS `zt_solution` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  `appID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `appName` char(50) NOT NULL DEFAULT '',
  `appVersion` char(20) NOT NULL DEFAULT '',
  `version` char(50) NOT NULL DEFAULT '',
  `chart` char(50) NOT NULL DEFAULT '',
  `cover` varchar(255) NOT NULL DEFAULT '',
  `desc` text NULL,
  `introduction` varchar(255) NOT NULL DEFAULT '',
  `source` char(20) NOT NULL DEFAULT '',
  `channel` char(20) NOT NULL DEFAULT '',
  `components` text NULL,
  `status` char(20) NOT NULL DEFAULT '',
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdAt` datetime NULL,
  `updatedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_artifactrepo`;
CREATE TABLE `zt_artifactrepo` (
  `id` smallint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `serverID` smallint(8) NOT NULL DEFAULT 0,
  `repoName` varchar(45) NOT NULL DEFAULT '',
  `format` varchar(10) NOT NULL DEFAULT '',
  `type` char(7) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NULL,
  `deleted` tinyint(4) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `zt_build` ADD `artifactRepoID` MEDIUMINT(8) UNSIGNED NOT NULL AFTER `bugs`;

REPLACE INTO
    `zt_privmanager` (`id`, `parent`, `code`, `type`, `edition`, `vision`, `order`)
VALUES
    (557, 457, 'ops', 'module', ',open,biz,max,ipd,', ',rnd,', 1920),
    (658, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2160),
    (126, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2180),
    (659, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2200),
    (127, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2220),
    (128, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2240),
    (129, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2260),
    (131, 557, '', 'package', ',biz,max,ipd,', ',rnd,', 2280),
    (245, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2380),
    (660, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2300),
    (661, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2320),
    (662, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2340),
    (663, 557, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2360),
    (517, 502, 'repo', 'module', ',open,biz,max,ipd,', ',rnd,', 2400),
    (664, 517, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2420),
    (665, 517, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2440),
    (300, 517, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2460),
    (299, 517, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2480),
    (666, 517, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2500),
    (506, 502, 'repocode', 'module', ',open,biz,max,ipd,', ',rnd,', 2520),
    (667, 506, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2540),
    (668, 506, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2560),
    (669, 502, 'codereview', 'module', ',biz,max,ipd,', ',rnd,', 2580),
    (227, 669, '', 'package', ',biz,max,ipd,', ',rnd,lite,or,', 2600),
    (670, 669, '', 'package', ',biz,max,ipd,', ',rnd,', 2620),
    (671, 669, '', 'package', ',biz,max,ipd,', ',rnd,', 2640),
    (505, 502, 'mr', 'module', ',open,biz,max,ipd,', ',rnd,', 2660),
    (672, 505, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2680),
    (516, 502, 'pipeline', 'module', ',open,biz,max,ipd,', ',rnd,', 2700),
    (673, 516, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2720),
    (507, 502, 'ci', 'module', ',open,biz,max,ipd,', ',rnd,', 2740),
    (674, 502, 'artifactrepo', 'module', ',open,biz,max,ipd,', ',rnd,', 2760),
    (675, 674, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2780),
    (676, 674, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2800),
    (677, 674, '', 'package', ',open,biz,max,ipd,', ',rnd,', 2820),
    (678, 515, 'application', 'package', ',open,biz,max,ipd,', ',rnd,', 2840),
    (679, 515, 'application', 'package', ',open,biz,max,ipd,', ',rnd,', 2860),
    (515, 502, 'app', 'module', ',open,biz,max,ipd,', ',rnd,', 3000),
    (563, 502, 'deploy', 'module', ',biz,max,ipd,', ',rnd,', 3020),
    (130, 557, '', 'package', ',biz,max,ipd,', ',rnd,lite,or,', 2270);

DELETE FROM `zt_priv` WHERE id=834;
DELETE FROM `zt_priv` WHERE `module` IN ('gitlab', 'jenkins', 'gitea', 'gogs', 'sonarqube');
UPDATE `zt_priv` SET `edition`=',open,biz,max,ipd,' WHERE `module`='host';
UPDATE `zt_priv` SET `edition`=',open,biz,max,ipd,' WHERE `module`='account';
UPDATE `zt_priv` SET `edition`=',open,biz,max,ipd,' WHERE `module`='serverroom';
REPLACE INTO
    `zt_priv` (`id`, `module`, `method`, `parent`, `edition`, `vision`, `system`, `order`)
VALUES
    (2136, 'system', 'dashboard', 658, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (1285, 'system', 'dblist', 126, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (1286, 'system', 'configdomain', 126, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (2137, 'system', 'ossview', 126, ',open,biz,max,ipd,', ',rnd,', '1', 15),
    (2138, 'ops', 'provide', 660, ',open,biz,max,ipd,', ',rnd,', '1', 20),
    (2139, 'ops', 'city', 661, ',open,biz,max,ipd,', ',rnd,', '1', 25),
    (2140, 'ops', 'cpubrand', 662, ',open,biz,max,ipd,', ',rnd,', '1', 30),
    (2141, 'ops', 'os', 663, ',open,biz,max,ipd,', ',rnd,', '1', 35),
    (1051, 'repo', 'maintain', 664, ',open,biz,max,ipd,', ',rnd,', '1', 0),
    (1052, 'repo', 'browse', 664, ',open,biz,max,ipd', ',rnd,', '1', 30),
    (1047, 'repo', 'create', 665, ',open,biz,max,ipd', ',rnd,', '1', 5),
    (1048, 'repo', 'edit', 665, ',open,biz,max,ipd', ',rnd,', '1', 10),
    (1060, 'repo', 'apiGetRepoByUrl', 665, ',open,biz,max,ipd', ',rnd,', '1', 15),
    (1694, 'repo', 'import', 665, ',open,biz,max,ipd', ',rnd,', '1', 20),
    (1049, 'repo', 'delete', 666, ',open,biz,max,ipd', ',rnd,', '1', 25),
    (1066, 'repo', 'review', 227, ',biz,max,ipd', ',rnd,', '1', 0),
    (1067, 'repo', 'addBug', 670, ',biz,max,ipd', ',rnd,', '1', 5),
    (1068, 'repo', 'editBug', 670, ',biz,max,ipd', ',rnd,', '1', 15),
    (1070, 'repo', 'addComment', 670, ',biz,max,ipd', ',rnd,', '1', 20),
    (1071, 'repo', 'editComment', 670, ',biz,max,ipd', ',rnd,', '1', 25),
    (1069, 'repo', 'deleteBug', 671, ',biz,max,ipd', ',rnd,', '1', 30),
    (1072, 'repo', 'deleteComment', 670, ',biz,max,ipd', ',rnd,', '1', 35),
    (1050, 'repo', 'showSyncCommit', 667, ',open,biz,max,ipd', ',rnd,', '1', 0),
    (1055, 'repo', 'log', 667, ',open,biz,max,ipd', ',rnd,', '1', 5),
    (1056, 'repo', 'revision', 667, ',open,biz,max,ipd', ',rnd,', '1', 10),
    (1053, 'repo', 'view', 667, ',open,biz,max,ipd', ',rnd,', '1', 15),
    (1061, 'repo', 'downloadCode', 668, ',open,biz,max,ipd', ',rnd,', '1', 5),
    (1058, 'repo', 'download', 668, ',open,biz,max,ipd', ',rnd,', '1', 10),
    (1054, 'repo', 'diff', 668, ',open,biz,max,ipd', ',rnd,', '1', 15),
    (1057, 'repo', 'blame', 668, ',open,biz,max,ipd', ',rnd,', '1', 20),
    (1062, 'repo', 'linkStory', 668, ',open,biz,max,ipd', ',rnd,', '1', 25),
    (1063, 'repo', 'linkBug', 668, ',open,biz,max,ipd', ',rnd,', '1', 30),
    (1064, 'repo', 'linkTask', 668, ',open,biz,max,ipd', ',rnd,', '1', 35),
    (1065, 'repo', 'unlink', 668, ',open,biz,max,ipd', ',rnd,', '1', 40),
    (820, 'mr', 'browse', 230, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (823, 'mr', 'view', 230, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (825, 'mr', 'diff', 230, ',open,biz,max,ipd,', ',rnd,', '1', 15),
    (826, 'mr', 'link', 230, ',open,biz,max,ipd,', ',rnd,', '1', 20),
    (819, 'mr', 'create', 248, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (821, 'mr', 'edit', 248, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (824, 'mr', 'accept', 248, ',open,biz,max,ipd,', ',rnd,', '1', 20),
    (827, 'mr', 'linkStory', 248, ',open,biz,max,ipd,', ',rnd,', '1', 25),
    (828, 'mr', 'linkBug', 248, ',open,biz,max,ipd,', ',rnd,', '1', 30),
    (829, 'mr', 'linkTask', 248, ',open,biz,max,ipd,', ',rnd,', '1', 35),
    (830, 'mr', 'unlink', 248, ',open,biz,max,ipd,', ',rnd,', '1', 40),
    (831, 'mr', 'approval', 248, ',open,biz,max,ipd,', ',rnd,', '1', 45),
    (832, 'mr', 'close', 248, ',open,biz,max,ipd,', ',rnd,', '1', 50),
    (833, 'mr', 'reopen', 248, ',open,biz,max,ipd,', ',rnd,', '1', 55),
    (822, 'mr', 'delete', 672, ',open,biz,max,ipd,', ',rnd,', '1', 4),
    (1082, 'job', 'browse', 246, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (1087, 'job', 'view', 246, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (1083, 'job', 'create', 247, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (1084, 'job', 'edit', 247, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (1086, 'job', 'exec', 247, ',open,biz,max,ipd,', ',rnd,', '1', 15),
    (1075, 'compile', 'browse', 247, ',open,biz,max,ipd,', ',rnd,', '1', 20),
    (1076, 'compile', 'logs', 247, ',open,biz,max,ipd,', ',rnd,', '1', 25),
    (1077, 'compile', 'syncCompile', 247, ',open,biz,max,ipd,', ',rnd,', '1', 30),
    (2142, 'artifactrepo', 'browse', 675, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (2143, 'artifactrepo', 'ajaxGetArtifactRepos', 675, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (2144, 'artifactrepo', 'create', 676, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (2145, 'artifactrepo', 'edit', 676, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (2146, 'artifactrepo', 'ajaxUpdateArtifactRepos', 676, ',open,biz,max,ipd,', ',rnd,', '1', 15),
    (2147, 'artifactrepo', 'delete', 677, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (2148, 'space', 'browse', 678, ',open,biz,max,ipd,', ',rnd,', '1', 5),
    (2149, 'instance', 'manage', 679, ',open,biz,max,ipd,', ',rnd,', '1', 10),
    (2160, 'ops', 'stage', 132, ',biz,max,ipd,', ',rnd,', '1', 10);

REPLACE INTO
    `zt_privlang` (`objectID`, `objectType`, `lang`, `key`, `value`, `desc`)
VALUES
    (658, 'manager', 'zh-cn', '', '仪表盘', ''),
    (658, 'manager', 'zh-tw', '', '儀表盤', ''),
    (658, 'manager', 'de', '', 'Dashboard', ''),
    (658, 'manager', 'en', '', 'Dashboard', ''),
    (658, 'manager', 'fr', '', 'Dashboard', ''),
    (126, 'manager', 'zh-cn', '', '平台', ''),
    (126, 'manager', 'zh-tw', '', '平臺', ''),
    (126, 'manager', 'de', '', 'Platform', ''),
    (126, 'manager', 'en', '', 'Platform', ''),
    (126, 'manager', 'fr', '', 'Platform', ''),
    (659, 'manager', 'zh-cn', '', '资源', ''),
    (659, 'manager', 'zh-tw', '', '資源', ''),
    (659, 'manager', 'de', '', 'Resource', ''),
    (659, 'manager', 'en', '', 'Resource', ''),
    (659, 'manager', 'fr', '', 'Resource', ''),
    (660, 'manager', 'zh-cn', '', '服务商管理', ''),
    (660, 'manager', 'zh-tw', '', '服務商管理', ''),
    (660, 'manager', 'de', '', 'Provider', ''),
    (660, 'manager', 'en', '', 'Provider', ''),
    (660, 'manager', 'fr', '', 'Provider', ''),
    (661, 'manager', 'zh-cn', '', '城市管理', ''),
    (661, 'manager', 'zh-tw', '', '城市管理', ''),
    (661, 'manager', 'de', '', 'City', ''),
    (661, 'manager', 'en', '', 'City', ''),
    (661, 'manager', 'fr', '', 'City', ''),
    (662, 'manager', 'zh-cn', '', 'CPU管理', ''),
    (662, 'manager', 'zh-tw', '', 'CPU管理', ''),
    (662, 'manager', 'de', '', 'Cpu Brand', ''),
    (662, 'manager', 'en', '', 'Cpu Brand', ''),
    (662, 'manager', 'fr', '', 'Cpu Brand', ''),
    (663, 'manager', 'zh-cn', '', '系统版本管理', ''),
    (663, 'manager', 'zh-tw', '', '系統版本管理', ''),
    (663, 'manager', 'de', '', 'OS Version', ''),
    (663, 'manager', 'en', '', 'OS Version', ''),
    (663, 'manager', 'fr', '', 'OS Version', ''),
    (129, 'manager', 'zh-cn', '', '账号管理', ''),
    (129, 'manager', 'zh-tw', '', '賬號管理', ''),
    (517, 'manager', 'zh-cn', '', '代码库', ''),
    (517, 'manager', 'zh-tw', '', '代碼庫', ''),
    (517, 'manager', 'de', '', 'Repository', ''),
    (517, 'manager', 'en', '', 'Repository', ''),
    (517, 'manager', 'fr', '', 'Repository', ''),
    (506, 'manager', 'zh-cn', '', '代码', ''),
    (506, 'manager', 'zh-tw', '', '代碼', ''),
    (506, 'manager', 'de', '', 'Code', ''),
    (506, 'manager', 'en', '', 'Code', ''),
    (506, 'manager', 'fr', '', 'Code', ''),
    (664, 'manager', 'zh-cn', '', '浏览代码库', ''),
    (664, 'manager', 'zh-tw', '', '瀏覽代碼庫', ''),
    (664, 'manager', 'de', '', 'Repo List', ''),
    (664, 'manager', 'en', '', 'Repo List', ''),
    (664, 'manager', 'fr', '', 'Repo List', ''),
    (665, 'manager', 'zh-cn', '', '创建维护代码库', ''),
    (665, 'manager', 'zh-tw', '', '創建維護代碼庫', ''),
    (665, 'manager', 'de', '', 'Manage Repository', ''),
    (665, 'manager', 'en', '', 'Manage Repository', ''),
    (665, 'manager', 'fr', '', 'Manage Repository', ''),
    (666, 'manager', 'zh-cn', '', '删除代码库', ''),
    (666, 'manager', 'zh-tw', '', '刪除代碼庫', ''),
    (666, 'manager', 'de', '', 'Delete Repository', ''),
    (666, 'manager', 'en', '', 'Delete Repository', ''),
    (666, 'manager', 'fr', '', 'Delete Repository', ''),
    (667, 'manager', 'zh-cn', '', '浏览代码', ''),
    (667, 'manager', 'zh-tw', '', '瀏覽代碼', ''),
    (667, 'manager', 'de', '', 'Code View', ''),
    (667, 'manager', 'en', '', 'Code View', ''),
    (667, 'manager', 'fr', '', 'Code View', ''),
    (668, 'manager', 'zh-cn', '', '维护代码', ''),
    (668, 'manager', 'zh-tw', '', '維護代碼', ''),
    (668, 'manager', 'de', '', 'Manage Code', ''),
    (668, 'manager', 'en', '', 'Manage Code', ''),
    (668, 'manager', 'fr', '', 'Manage Code', ''),
    (669, 'manager', 'zh-cn', '', '问题', ''),
    (669, 'manager', 'zh-tw', '', '問題', ''),
    (669, 'manager', 'de', '', 'Review', ''),
    (669, 'manager', 'en', '', 'Review', ''),
    (669, 'manager', 'fr', '', 'Review', ''),
    (227, 'manager', 'zh-cn', '', '浏览问题', ''),
    (227, 'manager', 'zh-tw', '', '瀏覽問題', ''),
    (227, 'manager', 'de', '', 'Review List', ''),
    (227, 'manager', 'en', '', 'Review List', ''),
    (227, 'manager', 'fr', '', 'Review List', ''),
    (670, 'manager', 'zh-cn', '', '创建维护问题', ''),
    (670, 'manager', 'zh-tw', '', '创建维护問題', ''),
    (670, 'manager', 'de', '', 'Manage Review', ''),
    (670, 'manager', 'en', '', 'Manage Review', ''),
    (670, 'manager', 'fr', '', 'Manage Review', ''),
    (671, 'manager', 'zh-cn', '', '删除问题', ''),
    (671, 'manager', 'zh-tw', '', '刪除問題', ''),
    (671, 'manager', 'de', '', 'Delete Review', ''),
    (671, 'manager', 'en', '', 'Delete Review', ''),
    (671, 'manager', 'fr', '', 'Delete Review', ''),
    (230, 'manager', 'zh-cn', '', '浏览合并请求', ''),
    (230, 'manager', 'zh-tw', '', '浏览合并請求', ''),
    (230, 'manager', 'de', '', 'MR List', ''),
    (230, 'manager', 'en', '', 'MR List', ''),
    (230, 'manager', 'fr', '', 'MR List', ''),
    (248, 'manager', 'zh-cn', '', '创建维护合并请求', ''),
    (248, 'manager', 'zh-tw', '', '创建维护合并請求', ''),
    (248, 'manager', 'de', '', 'Manage MR', ''),
    (248, 'manager', 'en', '', 'Manage MR', ''),
    (248, 'manager', 'fr', '', 'Manage MR', ''),
    (672, 'manager', 'zh-cn', '', '删除合并请求', ''),
    (672, 'manager', 'zh-tw', '', '刪除合并請求', ''),
    (672, 'manager', 'de', '', 'Delete MR', ''),
    (672, 'manager', 'en', '', 'Delete MR', ''),
    (672, 'manager', 'fr', '', 'Delete MR', ''),
    (246, 'manager', 'zh-cn', '', '浏览流水线', ''),
    (246, 'manager', 'zh-tw', '', '浏览流水綫', ''),
    (246, 'manager', 'de', '', 'PipeLine List', ''),
    (246, 'manager', 'en', '', 'PipeLine List', ''),
    (246, 'manager', 'fr', '', 'PipeLine List', ''),
    (247, 'manager', 'zh-cn', '', '创建维护流水线', ''),
    (247, 'manager', 'zh-tw', '', '创建维护流水綫', ''),
    (247, 'manager', 'de', '', 'Manage PipeLine', ''),
    (247, 'manager', 'en', '', 'Manage PipeLine', ''),
    (247, 'manager', 'fr', '', 'Manage PipeLine', ''),
    (673, 'manager', 'zh-cn', '', '删除流水线', ''),
    (673, 'manager', 'zh-tw', '', '刪除流水綫', ''),
    (673, 'manager', 'de', '', 'Delete PipeLine', ''),
    (673, 'manager', 'en', '', 'Delete PipeLine', ''),
    (673, 'manager', 'fr', '', 'Delete PipeLine', ''),
    (674, 'manager', 'zh-cn', 'artifactrepo', '制品库', ''),
    (674, 'manager', 'zh-tw', 'artifactrepo', '製品庫', ''),
    (674, 'manager', 'de', 'artifactrepo', 'Artifact Repo', ''),
    (674, 'manager', 'en', 'artifactrepo', 'Artifact Repo', ''),
    (674, 'manager', 'fr', 'artifactrepo', 'Artifact Repo', ''),
    (675, 'manager', 'zh-cn', '', '浏览制品库', ''),
    (675, 'manager', 'zh-tw', '', '浏览製品庫', ''),
    (675, 'manager', 'de', '', 'Artifact Repo List', ''),
    (675, 'manager', 'en', '', 'Artifact Repo List', ''),
    (675, 'manager', 'fr', '', 'Artifact Repo List', ''),
    (676, 'manager', 'zh-cn', '', '创建维护制品库', ''),
    (676, 'manager', 'zh-tw', '', '创建维护製品庫', ''),
    (676, 'manager', 'de', '', 'Manage Artifact Repo', ''),
    (676, 'manager', 'en', '', 'Manage Artifact Repo', ''),
    (676, 'manager', 'fr', '', 'Manage Artifact Repo', ''),
    (677, 'manager', 'zh-cn', '', '删除制品库', ''),
    (677, 'manager', 'zh-tw', '', '刪除製品庫', ''),
    (677, 'manager', 'de', '', 'Delete Artifact Repo', ''),
    (677, 'manager', 'en', '', 'Delete Artifact Repo', ''),
    (677, 'manager', 'fr', '', 'Delete Artifact Repo', ''),
    (678, 'manager', 'zh-cn', '', '浏览应用', ''),
    (678, 'manager', 'zh-tw', '', '浏览應用', ''),
    (678, 'manager', 'de', '', 'Application List', ''),
    (678, 'manager', 'en', '', 'Application List', ''),
    (678, 'manager', 'fr', '', 'Application List', ''),
    (679, 'manager', 'zh-cn', '', '管理应用', ''),
    (679, 'manager', 'zh-tw', '', '管理應用', ''),
    (679, 'manager', 'de', '', 'Manage Application', ''),
    (679, 'manager', 'en', '', 'Manage Application', ''),
    (679, 'manager', 'fr', '', 'Manage Application', ''),
    (2136, 'priv', 'zh-cn', 'system-dashboard', 'DevOps平台仪表盘', ''),
    (2136, 'priv', 'zh-tw', 'system-dashboard', 'DevOps平臺儀表盤', ''),
    (2136, 'priv', 'de', 'system-dashboard', 'DevOps Dashboard', ''),
    (2136, 'priv', 'en', 'system-dashboard', 'DevOps Dashboard', ''),
    (2136, 'priv', 'fr', 'system-dashboard', 'DevOps Dashboard', ''),
    (1285, 'priv', 'zh-cn', 'system-dblist', '数据库管理', ''),
    (1285, 'priv', 'zh-tw', 'system-dblist', '數據庫管理', ''),
    (1285, 'priv', 'de', 'system-dblist', 'Database', ''),
    (1285, 'priv', 'en', 'system-dblist', 'Database', ''),
    (1285, 'priv', 'fr', 'system-dblist', 'Database', ''),
    (1286, 'priv', 'zh-cn', 'system-configdomain', '域名管理', ''),
    (1286, 'priv', 'zh-tw', 'system-configdomain', '域名管理', ''),
    (1286, 'priv', 'de', 'system-configdomain', 'Domain', ''),
    (1286, 'priv', 'en', 'system-configdomain', 'Domain', ''),
    (1286, 'priv', 'fr', 'system-configdomain', 'Domain', ''),
    (2137, 'priv', 'zh-cn', 'system-ossview', '对象存储管理', ''),
    (2137, 'priv', 'zh-tw', 'system-ossview', '對象存儲管理', ''),
    (2137, 'priv', 'de', 'system-ossview', 'Oss', ''),
    (2137, 'priv', 'en', 'system-ossview', 'Oss', ''),
    (2137, 'priv', 'fr', 'system-ossview', 'Oss', ''),
    (2138, 'priv', 'zh-cn', 'ops-provider', '服务商管理', ''),
    (2138, 'priv', 'zh-tw', 'ops-provider', '服務商管理', ''),
    (2138, 'priv', 'de', 'ops-provider', 'Provider', ''),
    (2138, 'priv', 'en', 'ops-provider', 'Provider', ''),
    (2138, 'priv', 'fr', 'ops-provider', 'Provider', ''),
    (2139, 'priv', 'zh-cn', 'ops-city', '城市管理', ''),
    (2139, 'priv', 'zh-tw', 'ops-city', '城市管理', ''),
    (2139, 'priv', 'de', 'ops-city', 'City', ''),
    (2139, 'priv', 'en', 'ops-city', 'City', ''),
    (2139, 'priv', 'fr', 'ops-city', 'City', ''),
    (2140, 'priv', 'zh-cn', 'ops-cpubrand', 'CPU管理', ''),
    (2140, 'priv', 'zh-tw', 'ops-cpubrand', 'CPU管理', ''),
    (2140, 'priv', 'de', 'ops-cpubrand', 'Cpu Brand', ''),
    (2140, 'priv', 'en', 'ops-cpubrand', 'Cpu Brand', ''),
    (2140, 'priv', 'fr', 'ops-cpubrand', 'Cpu Brand', ''),
    (2141, 'priv', 'zh-cn', 'ops-os', '系统版本管理', ''),
    (2141, 'priv', 'zh-tw', 'ops-os', '系統版本管理', ''),
    (2141, 'priv', 'de', 'ops-os', 'Os Version', ''),
    (2141, 'priv', 'en', 'ops-os', 'Os Version', ''),
    (2141, 'priv', 'fr', 'ops-os', 'Os Version', ''),
    (1694, 'priv', 'zh-cn', 'repo-importAction', '批量添加', ''),
    (1694, 'priv', 'zh-tw', 'repo-importAction', '批量添加', ''),
    (1694, 'priv', 'de', 'repo-importAction', 'Import', ''),
    (1694, 'priv', 'en', 'repo-importAction', 'Import', ''),
    (1694, 'priv', 'fr', 'repo-importAction', 'Import', ''),
    (1050, 'priv', 'zh-cn', 'repo-showSyncCommit', '同步进度', ''),
    (1050, 'priv', 'zh-tw', 'repo-showSyncCommit', '同步進度', ''),
    (1050, 'priv', 'de', 'repo-showSyncCommit', 'Show Sync Progress', ''),
    (1050, 'priv', 'en', 'repo-showSyncCommit', 'Show Sync Progress', ''),
    (1050, 'priv', 'fr', 'repo-showSyncCommit', 'Show Sync Progress', ''),
    (1066, 'priv', 'zh-cn', 'repo-reviewAction', '问题列表', ''),
    (1066, 'priv', 'zh-tw', 'repo-reviewAction', '問題列表', ''),
    (1066, 'priv', 'de', 'repo-reviewAction', 'Review List', ''),
    (1066, 'priv', 'en', 'repo-reviewAction', 'Review List', ''),
    (1066, 'priv', 'fr', 'repo-reviewAction', 'Review List', ''),
    (1067, 'priv', 'zh-cn', 'repo-addBug', '添加问题', ''),
    (1067, 'priv', 'zh-tw', 'repo-addBug', '添加問題', ''),
    (1067, 'priv', 'de', 'repo-addBug', 'Create Review', ''),
    (1067, 'priv', 'en', 'repo-addBug', 'Create Review', ''),
    (1067, 'priv', 'fr', 'repo-addBug', 'Create Review', ''),
    (1068, 'priv', 'zh-cn', 'repo-editBug', '编辑问题', ''),
    (1068, 'priv', 'zh-tw', 'repo-editBug', '编辑問題', ''),
    (1068, 'priv', 'de', 'repo-editBug', 'Create Review', ''),
    (1068, 'priv', 'en', 'repo-editBug', 'Create Review', ''),
    (1068, 'priv', 'fr', 'repo-editBug', 'Create Review', ''),
    (1069, 'priv', 'zh-cn', 'repo-deleteBug', '删除问题', ''),
    (1069, 'priv', 'zh-tw', 'repo-deleteBug', '刪除問題', ''),
    (1069, 'priv', 'de', 'repo-deleteBug', 'Delete Review', ''),
    (1069, 'priv', 'en', 'repo-deleteBug', 'Delete Review', ''),
    (1069, 'priv', 'fr', 'repo-deleteBug', 'Delete Review', ''),
    (1071, 'priv', 'zh-cn', 'repo-editComment', '编辑评论', ''),
    (1071, 'priv', 'zh-tw', 'repo-editComment', '编辑评论', ''),
    (1071, 'priv', 'de', 'repo-editComment', 'Create Review', ''),
    (1071, 'priv', 'en', 'repo-editComment', 'Create Review', ''),
    (1071, 'priv', 'fr', 'repo-editComment', 'Create Review', ''),
    (1072, 'priv', 'zh-cn', 'repo-deleteComment', '删除评论', ''),
    (1072, 'priv', 'zh-tw', 'repo-deleteComment', '刪除评论', ''),
    (1072, 'priv', 'de', 'repo-deleteComment', 'Create Review', ''),
    (1072, 'priv', 'en', 'repo-deleteComment', 'Create Review', ''),
    (1072, 'priv', 'fr', 'repo-deleteComment', 'Create Review', ''),
    (2142, 'priv', 'zh-cn', 'artifactrepo-browse', '制品库列表', ''),
    (2142, 'priv', 'zh-tw', 'artifactrepo-browse', '制品库列表', ''),
    (2142, 'priv', 'de', 'artifactrepo-browse', 'Artifact Repo List', ''),
    (2142, 'priv', 'en', 'artifactrepo-browse', 'Artifact Repo List', ''),
    (2142, 'priv', 'fr', 'artifactrepo-browse', 'Artifact Repo List', ''),
    (2143, 'priv', 'zh-cn', 'artifactrepo-ajaxGetArtifactRepos', '接口：制品库列表', ''),
    (2143, 'priv', 'zh-tw', 'artifactrepo-ajaxGetArtifactRepos', '接口：制品库列表', ''),
    (2143, 'priv', 'de', 'artifactrepo-ajaxGetArtifactRepos', 'Api: Artifact Repo List', ''),
    (2143, 'priv', 'en', 'artifactrepo-ajaxGetArtifactRepos', 'Api: Artifact Repo List', ''),
    (2143, 'priv', 'fr', 'artifactrepo-ajaxGetArtifactRepos', 'Api: Artifact Repo List', ''),
    (2144, 'priv', 'zh-cn', 'artifactrepo-create', '创建制品库', ''),
    (2144, 'priv', 'zh-tw', 'artifactrepo-create', '创建制品库', ''),
    (2144, 'priv', 'de', 'artifactrepo-create', 'Create Artifact Repo', ''),
    (2144, 'priv', 'en', 'artifactrepo-create', 'Create Artifact Repo', ''),
    (2144, 'priv', 'fr', 'artifactrepo-create', 'Create Artifact Repo', ''),
    (2145, 'priv', 'zh-cn', 'artifactrepo-edit', '编辑制品库', ''),
    (2145, 'priv', 'zh-tw', 'artifactrepo-edit', '编辑制品库', ''),
    (2145, 'priv', 'de', 'artifactrepo-edit', 'Edit Artifact Repo', ''),
    (2145, 'priv', 'en', 'artifactrepo-edit', 'Edit Artifact Repo', ''),
    (2145, 'priv', 'fr', 'artifactrepo-edit', 'Edit Artifact Repo', ''),
    (2146, 'priv', 'zh-cn', 'artifactrepo-ajaxUpdateArtifactRepos', '接口：更新制品库状态', ''),
    (2146, 'priv', 'zh-tw', 'artifactrepo-ajaxUpdateArtifactRepos', '接口：更新制品库状态', ''),
    (2146, 'priv', 'de', 'artifactrepo-ajaxUpdateArtifactRepos', 'Api: Update Status', ''),
    (2146, 'priv', 'en', 'artifactrepo-ajaxUpdateArtifactRepos', 'Api: Update Status', ''),
    (2146, 'priv', 'fr', 'artifactrepo-ajaxUpdateArtifactRepos', 'Api: Update Status', ''),
    (2147, 'priv', 'zh-cn', 'artifactrepo-delete', '删除制品库', ''),
    (2147, 'priv', 'zh-tw', 'artifactrepo-delete', '刪除制品库', ''),
    (2147, 'priv', 'de', 'artifactrepo-delete', 'Delete Artifact Repo', ''),
    (2147, 'priv', 'en', 'artifactrepo-delete', 'Delete Artifact Repo', ''),
    (2147, 'priv', 'fr', 'artifactrepo-delete', 'Delete Artifact Repo', ''),
    (2148, 'priv', 'zh-cn', 'space-browse', '查看应用', ''),
    (2148, 'priv', 'zh-tw', 'space-browse', '查看應用', ''),
    (2148, 'priv', 'de', 'space-browse', 'Application List', ''),
    (2148, 'priv', 'en', 'space-browse', 'Application List', ''),
    (2148, 'priv', 'fr', 'space-browse', 'Application List', ''),
    (2149, 'priv', 'zh-cn', 'instance-manage', '管理应用', ''),
    (2149, 'priv', 'zh-tw', 'instance-manage', '管理應用', ''),
    (2149, 'priv', 'de', 'instance-manage', 'Manage Application', ''),
    (2149, 'priv', 'en', 'instance-manage', 'Manage Application', ''),
    (2149, 'priv', 'fr', 'instance-manage', 'Manage Application', ''),
    (2160, 'priv', 'zh-cn', 'ops-stage', '设置阶段', ''),
    (2160, 'priv', 'zh-tw', 'ops-stage', '設置階段', ''),
    (2160, 'priv', 'de', 'ops-stage', 'Stage Setting', ''),
    (2160, 'priv', 'en', 'ops-stage', 'Stage Setting', ''),
    (2160, 'priv', 'fr', 'ops-stage', 'Stage Setting', '');

CREATE TABLE IF NOT EXISTS `zt_prompt` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `desc` text DEFAULT NULL,
  `model` mediumint(8) unsigned DEFAULT NULL,
  `module` varchar(30) DEFAULT NULL,
  `source` text DEFAULT NULL,
  `targetForm` varchar(30) DEFAULT NULL,
  `purpose` text DEFAULT NULL,
  `elaboration` text DEFAULT NULL,
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `status` enum('draft','active') NOT NULL DEFAULT 'draft',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `zt_promptrole` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `model` mediumint(8) unsigned DEFAULT NULL,
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

REPLACE INTO
  `zt_priv` (`id`, `module`, `method`, `parent`, `edition`, `vision`, `system`, `order`)
VALUES
  (2117, 'ai', 'models', 653, ',open,biz,max,', ',rnd,', '1', 5),
  (2118, 'ai', 'editModel', 653, ',open,biz,max,', ',rnd,', '1', 10),
  (2119, 'ai', 'testConnection', 653, ',open,biz,max,', ',rnd,', '1', 15),
  (2120, 'ai', 'createPrompt', 655, ',biz,max,', ',rnd,', '1', 20),
  (2121, 'ai', 'promptEdit', 655, ',biz,max,', ',rnd,', '1', 25),
  (2122, 'ai', 'promptDelete', 657, ',biz,max,', ',rnd,', '1', 30),
  (2123, 'ai', 'promptAssignRole', 655, ',biz,max,', ',rnd,', '1', 35),
  (2124, 'ai', 'promptSelectDataSource', 655, ',biz,max,', ',rnd,', '1', 40),
  (2125, 'ai', 'promptSetPurpose', 655, ',biz,max,', ',rnd,', '1', 45),
  (2126, 'ai', 'promptSetTargetForm', 655, ',biz,max,', ',rnd,', '1', 50),
  (2127, 'ai', 'promptFinalize', 655, ',biz,max,', ',rnd,', '1', 55),
  (2128, 'ai', 'promptAudit', 655, ',biz,max,', ',rnd,', '1', 60),
  (2129, 'ai', 'promptPublish', 656, ',open,biz,max,', ',rnd,', '1', 65),
  (2130, 'ai', 'promptUnpublish', 656, ',open,biz,max,', ',rnd,', '1', 70),
  (2131, 'ai', 'prompts', 654, ',open,biz,max,', ',rnd,', '1', 75),
  (2132, 'ai', 'promptView', 654, ',open,biz,max,', ',rnd,', '1', 80),
  (2133, 'ai', 'promptExecute', 652, ',open,biz,max,', ',rnd,', '1', 85),
  (2134, 'ai', 'roleTemplates', 655, ',biz,max,', ',rnd,', '1', 90),
  (2135, 'ai', 'promptExecutionReset', 652, ',open,biz,max,', ',rnd,', '1', 95);

REPLACE INTO
  `zt_privmanager` (`id`, `parent`, `code`, `type`, `edition`, `vision`, `order`)
VALUES
  (651, 457, 'ai', 'module', ',open,biz,max,', ',rnd,', 2020),
  (652, 651, '', 'package', ',open,biz,max,', ',rnd,', 2040),
  (653, 651, '', 'package', ',open,biz,max,', ',rnd,', 2060),
  (654, 651, '', 'package', ',open,biz,max,', ',rnd,', 2080),
  (655, 651, '', 'package', ',biz,max,', ',rnd,', 2100),
  (656, 651, '', 'package', ',open,biz,max,', ',rnd,', 2120),
  (657, 651, '', 'package', ',biz,max,', ',rnd,', 2140);

REPLACE INTO
  `zt_privlang` (`objectID`, `objectType`, `lang`, `key`, `value`, `desc`)
VALUES
  (651, 'manager', 'zh-cn', '', 'AI', ''),
  (652, 'manager', 'zh-cn', '', '执行提词', ''),
  (653, 'manager', 'zh-cn', '', '语言模型管理', ''),
  (654, 'manager', 'zh-cn', '', '浏览提词', ''),
  (655, 'manager', 'zh-cn', '', '维护和设计提词', ''),
  (656, 'manager', 'zh-cn', '', '提词上下架', ''),
  (657, 'manager', 'zh-cn', '', '删除提词', ''),
  (651, 'manager', 'zh-tw', '', 'AI', ''),
  (652, 'manager', 'zh-tw', '', '執行提詞', ''),
  (653, 'manager', 'zh-tw', '', '語言模型管理', ''),
  (654, 'manager', 'zh-tw', '', '瀏覽提詞', ''),
  (655, 'manager', 'zh-tw', '', '維護和設計提詞', ''),
  (656, 'manager', 'zh-tw', '', '提詞上下架', ''),
  (657, 'manager', 'zh-tw', '', '刪除提詞', ''),
  (651, 'manager', 'en', '', 'AI', ''),
  (652, 'manager', 'en', '', 'Execute Prompts', ''),
  (653, 'manager', 'en', '', 'Manage Models', ''),
  (654, 'manager', 'en', '', 'Browse Prompts', ''),
  (655, 'manager', 'en', '', 'Manage and Design Prompts', ''),
  (656, 'manager', 'en', '', 'Publish and Unpublish Prompts', ''),
  (657, 'manager', 'en', '', 'Delete Prompts', ''),
  (651, 'manager', 'de', '', 'AI', ''),
  (652, 'manager', 'de', '', 'Execute Prompts', ''),
  (653, 'manager', 'de', '', 'Manage Models', ''),
  (654, 'manager', 'de', '', 'Browse Prompts', ''),
  (655, 'manager', 'de', '', 'Manage and Design Prompts', ''),
  (656, 'manager', 'de', '', 'Publish and Unpublish Prompts', ''),
  (657, 'manager', 'de', '', 'Delete Prompts', ''),
  (651, 'manager', 'fr', '', 'AI', ''),
  (652, 'manager', 'fr', '', 'Execute Prompts', ''),
  (653, 'manager', 'fr', '', 'Manage Models', ''),
  (654, 'manager', 'fr', '', 'Browse Prompts', ''),
  (655, 'manager', 'fr', '', 'Manage and Design Prompts', ''),
  (656, 'manager', 'fr', '', 'Publish and Unpublish Prompts', ''),
  (657, 'manager', 'fr', '', 'Delete Prompts', ''),
  (2117, 'priv', 'zh-cn', 'ai-modelBrowse', '', ''),
  (2118, 'priv', 'zh-cn', 'ai-modelEdit', '', ''),
  (2119, 'priv', 'zh-cn', 'ai-modelTestConnection', '', ''),
  (2120, 'priv', 'zh-cn', 'ai-promptCreate', '', ''),
  (2121, 'priv', 'zh-cn', 'ai-promptEdit', '', ''),
  (2122, 'priv', 'zh-cn', 'ai-promptDelete', '', ''),
  (2123, 'priv', 'zh-cn', 'ai-promptAssignRole', '', ''),
  (2124, 'priv', 'zh-cn', 'ai-promptSelectDataSource', '', ''),
  (2125, 'priv', 'zh-cn', 'ai-promptSetPurpose', '', ''),
  (2126, 'priv', 'zh-cn', 'ai-promptSetTargetForm', '', ''),
  (2127, 'priv', 'zh-cn', 'ai-promptFinalize', '', ''),
  (2128, 'priv', 'zh-cn', 'ai-promptAudit', '', ''),
  (2129, 'priv', 'zh-cn', 'ai-promptPublish', '', ''),
  (2130, 'priv', 'zh-cn', 'ai-promptUnpublish', '', ''),
  (2131, 'priv', 'zh-cn', 'ai-promptBrowse', '', ''),
  (2132, 'priv', 'zh-cn', 'ai-promptView', '', ''),
  (2133, 'priv', 'zh-cn', 'ai-promptExecute', '', ''),
  (2134, 'priv', 'zh-cn', 'ai-roleTemplates', '', ''),
  (2135, 'priv', 'zh-cn', 'ai-promptExecutionReset', '', ''),
  (2117, 'priv', 'zh-tw', 'ai-modelBrowse', '', ''),
  (2118, 'priv', 'zh-tw', 'ai-modelEdit', '', ''),
  (2119, 'priv', 'zh-tw', 'ai-modelTestConnection', '', ''),
  (2120, 'priv', 'zh-tw', 'ai-promptCreate', '', ''),
  (2121, 'priv', 'zh-tw', 'ai-promptEdit', '', ''),
  (2122, 'priv', 'zh-tw', 'ai-promptDelete', '', ''),
  (2123, 'priv', 'zh-tw', 'ai-promptAssignRole', '', ''),
  (2124, 'priv', 'zh-tw', 'ai-promptSelectDataSource', '', ''),
  (2125, 'priv', 'zh-tw', 'ai-promptSetPurpose', '', ''),
  (2126, 'priv', 'zh-tw', 'ai-promptSetTargetForm', '', ''),
  (2127, 'priv', 'zh-tw', 'ai-promptFinalize', '', ''),
  (2128, 'priv', 'zh-tw', 'ai-promptAudit', '', ''),
  (2129, 'priv', 'zh-tw', 'ai-promptPublish', '', ''),
  (2130, 'priv', 'zh-tw', 'ai-promptUnpublish', '', ''),
  (2131, 'priv', 'zh-tw', 'ai-promptBrowse', '', ''),
  (2132, 'priv', 'zh-tw', 'ai-promptView', '', ''),
  (2133, 'priv', 'zh-tw', 'ai-promptExecute', '', ''),
  (2134, 'priv', 'zh-tw', 'ai-roleTemplates', '', ''),
  (2135, 'priv', 'zh-tw', 'ai-promptExecutionReset', '', ''),
  (2117, 'priv', 'en', 'ai-modelBrowse', '', ''),
  (2118, 'priv', 'en', 'ai-modelEdit', '', ''),
  (2119, 'priv', 'en', 'ai-modelTestConnection', '', ''),
  (2120, 'priv', 'en', 'ai-promptCreate', '', ''),
  (2121, 'priv', 'en', 'ai-promptEdit', '', ''),
  (2122, 'priv', 'en', 'ai-promptDelete', '', ''),
  (2123, 'priv', 'en', 'ai-promptAssignRole', '', ''),
  (2124, 'priv', 'en', 'ai-promptSelectDataSource', '', ''),
  (2125, 'priv', 'en', 'ai-promptSetPurpose', '', ''),
  (2126, 'priv', 'en', 'ai-promptSetTargetForm', '', ''),
  (2127, 'priv', 'en', 'ai-promptFinalize', '', ''),
  (2128, 'priv', 'en', 'ai-promptAudit', '', ''),
  (2129, 'priv', 'en', 'ai-promptPublish', '', ''),
  (2130, 'priv', 'en', 'ai-promptUnpublish', '', ''),
  (2131, 'priv', 'en', 'ai-promptBrowse', '', ''),
  (2132, 'priv', 'en', 'ai-promptView', '', ''),
  (2133, 'priv', 'en', 'ai-promptExecute', '', ''),
  (2134, 'priv', 'en', 'ai-roleTemplates', '', ''),
  (2135, 'priv', 'en', 'ai-promptExecutionReset', '', ''),
  (2117, 'priv', 'de', 'ai-modelBrowse', '', ''),
  (2118, 'priv', 'de', 'ai-modelEdit', '', ''),
  (2119, 'priv', 'de', 'ai-modelTestConnection', '', ''),
  (2120, 'priv', 'de', 'ai-promptCreate', '', ''),
  (2121, 'priv', 'de', 'ai-promptEdit', '', ''),
  (2122, 'priv', 'de', 'ai-promptDelete', '', ''),
  (2123, 'priv', 'de', 'ai-promptAssignRole', '', ''),
  (2124, 'priv', 'de', 'ai-promptSelectDataSource', '', ''),
  (2125, 'priv', 'de', 'ai-promptSetPurpose', '', ''),
  (2126, 'priv', 'de', 'ai-promptSetTargetForm', '', ''),
  (2127, 'priv', 'de', 'ai-promptFinalize', '', ''),
  (2128, 'priv', 'de', 'ai-promptAudit', '', ''),
  (2129, 'priv', 'de', 'ai-promptPublish', '', ''),
  (2130, 'priv', 'de', 'ai-promptUnpublish', '', ''),
  (2131, 'priv', 'de', 'ai-promptBrowse', '', ''),
  (2132, 'priv', 'de', 'ai-promptView', '', ''),
  (2133, 'priv', 'de', 'ai-promptExecute', '', ''),
  (2134, 'priv', 'de', 'ai-roleTemplates', '', ''),
  (2135, 'priv', 'de', 'ai-promptExecutionReset', '', ''),
  (2117, 'priv', 'fr', 'ai-modelBrowse', '', ''),
  (2118, 'priv', 'fr', 'ai-modelEdit', '', ''),
  (2119, 'priv', 'fr', 'ai-modelTestConnection', '', ''),
  (2120, 'priv', 'fr', 'ai-promptCreate', '', ''),
  (2121, 'priv', 'fr', 'ai-promptEdit', '', ''),
  (2122, 'priv', 'fr', 'ai-promptDelete', '', ''),
  (2123, 'priv', 'fr', 'ai-promptAssignRole', '', ''),
  (2124, 'priv', 'fr', 'ai-promptSelectDataSource', '', ''),
  (2125, 'priv', 'fr', 'ai-promptSetPurpose', '', ''),
  (2126, 'priv', 'fr', 'ai-promptSetTargetForm', '', ''),
  (2127, 'priv', 'fr', 'ai-promptFinalize', '', ''),
  (2128, 'priv', 'fr', 'ai-promptAudit', '', ''),
  (2129, 'priv', 'fr', 'ai-promptPublish', '', ''),
  (2130, 'priv', 'fr', 'ai-promptUnpublish', '', ''),
  (2131, 'priv', 'fr', 'ai-promptBrowse', '', ''),
  (2132, 'priv', 'fr', 'ai-promptView', '', ''),
  (2133, 'priv', 'fr', 'ai-promptExecute', '', ''),
  (2134, 'priv', 'fr', 'ai-roleTemplates', '', ''),
  (2135, 'priv', 'fr', 'ai-promptExecutionReset', '', '');

REPLACE INTO
  `zt_privrelation` (`priv`, `type`, `relationPriv`)
VALUES
  ('ai-editModel', 'depend', 'ai-models'), ('ai-editModel', 'depend', 'ai-testConnection'),
  ('ai-testConnection', 'depend', 'ai-models'), ('ai-testConnection', 'depend', 'ai-editModel'),
  ('ai-promptView', 'depend', 'ai-prompts'),
  ('ai-createPrompt', 'depend', 'ai-prompts'), ('ai-createPrompt', 'depend', 'ai-promptView'),
  ('ai-promptEdit', 'depend', 'ai-prompts'), ('ai-promptEdit', 'depend', 'ai-promptView'),
  ('ai-promptDelete', 'depend', 'ai-prompts'), ('ai-promptDelete', 'depend', 'ai-promptView'),
  ('ai-promptAssignRole', 'depend', 'ai-prompts'), ('ai-promptAssignRole', 'depend', 'ai-promptView'),
  ('ai-promptSelectDataSource', 'depend', 'ai-prompts'), ('ai-promptSelectDataSource', 'depend', 'ai-promptView'),
  ('ai-promptSetPurpose', 'depend', 'ai-prompts'), ('ai-promptSetPurpose', 'depend', 'ai-promptView'),
  ('ai-promptSetTargetForm', 'depend', 'ai-prompts'), ('ai-promptSetTargetForm', 'depend', 'ai-promptView'),
  ('ai-promptFinalize', 'depend', 'ai-prompts'), ('ai-promptFinalize', 'depend', 'ai-promptView'),
  ('ai-promptAudit', 'depend', 'ai-prompts'), ('ai-promptAudit', 'depend', 'ai-promptView'),
  ('ai-promptPublish', 'depend', 'ai-prompts'), ('ai-promptPublish', 'depend', 'ai-promptView'),
  ('ai-promptUnpublish', 'depend', 'ai-prompts'), ('ai-promptUnpublish', 'depend', 'ai-promptView'),
  ('ai-promptEdit', 'depend', 'ai-createPrompt'), ('ai-promptAssignRole', 'depend', 'ai-createPrompt'), ('ai-promptSelectDataSource', 'depend', 'ai-createPrompt'), ('ai-promptSetPurpose', 'depend', 'ai-createPrompt'), ('ai-promptSetTargetForm', 'depend', 'ai-createPrompt'), ('ai-promptFinalize', 'depend', 'ai-createPrompt'), ('ai-promptAudit', 'depend', 'ai-createPrompt'),
  ('ai-createPrompt', 'recommend', 'ai-promptEdit'),
  ('ai-createPrompt', 'recommend', 'ai-promptDelete'),
  ('ai-createPrompt', 'recommend', 'ai-promptAssignRole'), ('ai-createPrompt', 'recommend', 'ai-promptSelectDataSource'), ('ai-createPrompt', 'recommend', 'ai-promptSetPurpose'), ('ai-createPrompt', 'recommend', 'ai-promptSetTargetForm'), ('ai-createPrompt', 'recommend', 'ai-promptFinalize'), ('ai-createPrompt', 'recommend', 'ai-promptAudit'),
  ('ai-promptAssignRole', 'depend', 'ai-promptSelectDataSource'), ('ai-promptAssignRole', 'depend', 'ai-promptSetPurpose'), ('ai-promptAssignRole', 'depend', 'ai-promptSetTargetForm'), ('ai-promptAssignRole', 'depend', 'ai-promptFinalize'), ('ai-promptAssignRole', 'depend', 'ai-promptAudit'), ('ai-promptAssignRole', 'depend', 'ai-promptExecute'),
  ('ai-promptSelectDataSource', 'depend', 'ai-promptAssignRole'), ('ai-promptSelectDataSource', 'depend', 'ai-promptSetPurpose'), ('ai-promptSelectDataSource', 'depend', 'ai-promptSetTargetForm'), ('ai-promptSelectDataSource', 'depend', 'ai-promptFinalize'), ('ai-promptSelectDataSource', 'depend', 'ai-promptAudit'), ('ai-promptSelectDataSource', 'depend', 'ai-promptExecute'),
  ('ai-promptSetPurpose', 'depend', 'ai-promptAssignRole'), ('ai-promptSetPurpose', 'depend', 'ai-promptSelectDataSource'), ('ai-promptSetPurpose', 'depend', 'ai-promptSetTargetForm'), ('ai-promptSetPurpose', 'depend', 'ai-promptFinalize'), ('ai-promptSetPurpose', 'depend', 'ai-promptAudit'), ('ai-promptSetPurpose', 'depend', 'ai-promptExecute'),
  ('ai-promptSetTargetForm', 'depend', 'ai-promptAssignRole'), ('ai-promptSetTargetForm', 'depend', 'ai-promptSelectDataSource'), ('ai-promptSetTargetForm', 'depend', 'ai-promptSetPurpose'), ('ai-promptSetTargetForm', 'depend', 'ai-promptFinalize'), ('ai-promptSetTargetForm', 'depend', 'ai-promptAudit'), ('ai-promptSetTargetForm', 'depend', 'ai-promptExecute'),
  ('ai-promptFinalize', 'depend', 'ai-promptAssignRole'), ('ai-promptFinalize', 'depend', 'ai-promptSelectDataSource'), ('ai-promptFinalize', 'depend', 'ai-promptSetPurpose'), ('ai-promptFinalize', 'depend', 'ai-promptSetTargetForm'), ('ai-promptFinalize', 'depend', 'ai-promptAudit'), ('ai-promptFinalize', 'depend', 'ai-promptExecute'),
  ('ai-promptAudit', 'depend', 'ai-promptAssignRole'), ('ai-promptAudit', 'depend', 'ai-promptSelectDataSource'), ('ai-promptAudit', 'depend', 'ai-promptSetPurpose'), ('ai-promptAudit', 'depend', 'ai-promptSetTargetForm'), ('ai-promptAudit', 'depend', 'ai-promptFinalize'), ('ai-promptAudit', 'depend', 'ai-promptExecute'),
  ('ai-roleTemplates', 'depend', 'ai-promptAssignRole'), ('ai-promptAssignRole', 'depend', 'ai-roleTemplates'),
  ('ai-promptExecutionReset', 'depend', 'ai-promptExecute'), ('ai-promptExecute', 'depend', 'ai-promptExecutionReset');

INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('请你扮演一名资深的产品经理。', '负责产品战略、设计、开发、数据分析、用户体验、团队管理、沟通协调等方面，需要具备多种技能和能力，以实现产品目标和公司战略。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('你是一名经验丰富的开发工程师。', '精通多种编程语言和框架、熟悉前后端技术和架构、擅长性能优化和安全防护、熟悉云计算和容器化技术、能够协调多人协作和项目管理。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('作为一名资深的测试工程师。', '测试工程师应该是专业且严谨的。熟悉测试流程和方法，精通自动化测试和性能测试，能够设计和编写测试用例和测试脚本，擅长问题诊断和分析，熟悉敏捷开发和持续集成，能够协调多部门合作和项目管理。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('假如你是一名资深的QA工程师。', '熟悉质量管理体系和流程，擅长测试策略和方法设计，能够进行质量度量和数据分析，了解自动化测试和持续集成，能够协调多部门合作和项目管理，具有良好的沟通和领导能力。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('你是一名文章写得很好的文案编辑。', '文笔流畅、条理清晰。精通广告文案写作和编辑，擅长创意思维和品牌策略，能够进行市场调研和竞品分析，具有敏锐的审美和语言表达能力，能够协调多部门合作和项目管理，具有良好的沟通和协调能力。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('请你扮演一名经验丰富的项目经理。', '具备项目计划制定、进度管理、成本控制、团队管理、沟通协调、风险管理、质量控制、敏捷开发、互联网技术和数据分析等多方面的技能和能力。');
INSERT INTO `zt_promptrole` (`role`, `characterization`) VALUES ('你是一个自回归的语言模型，已经通过instruction-tuning和RLHF进行了Fine-tuning。', '你仔细地提供准确、事实、深思熟虑、细致入微的答案，并在推理方面表现出色。如果你认为可能没有正确的答案，你会直接说出来。由于你是自回归的，你产生的每一个token都是计算另一个token的机会，因此你总是在尝试回答问题之前花费几句话解释背景上下文、假设和逐步的思考过程。您的用户是AI和伦理学的专家，所以他们已经知道您是一个语言模型以及您的能力和局限性，所以不需要再提醒他们。他们一般都熟悉伦理问题，所以您也不需要再提醒他们。在回答时不要啰嗦，但在可能有助于解释的地方提供详细信息和示例。');

INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('需求润色', 0, 'story', ',story.title,story.spec,story.verify,story.product,story.module,story.pri,story.category,story.estimate,', 'story.change', '帮忙优化其中各字段的表述，使表述清晰准确。必要时可以修改需求使其更加合理。', '需求描述格式建议使用：作为一名<某种类型的用户>，我希望<达成某些目的>，这样可以<开发的价值>。验收标准建议列举多条。', '请你扮演一名资深的产品经理。', '负责产品战略、设计、开发、数据分析、用户体验、团队管理、沟通协调等方面，需要具备多种技能和能力，以实现产品目标和公司战略。', 'system', '2023-08-10 13:24:14', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('一键拆用例', 0, 'story', ',story.title,story.spec,story.verify,story.product,story.module,story.pri,story.category,story.estimate,', 'story.testcasecreate', '为这个需求生成一个或多个对应的测试用例。', '', '作为一名资深的测试工程师。', '熟悉测试流程和方法，精通自动化测试和性能测试，能够设计和编写测试用例和测试脚本，擅长问题诊断和分析，熟悉敏捷开发和持续集成，能够协调多部门合作和项目管理。开发工程师应该是专业且严谨的。', 'system', '2023-08-10 13:24:14', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('任务润色', 0, 'task', ',task.name,task.desc,task.pri,task.status,task.estimate,task.consumed,task.left,task.progress,task.estStarted,task.realStarted,', 'task.edit', '优化其中各字段的表述，使表述清晰准确，明确任务目标。', '必要时指出任务的风险点。', '你是一名经验丰富的开发工程师。', '精通多种编程语言和框架、熟悉前后端技术和架构、擅长性能优化和安全防护、熟悉云计算和容器化技术、能够协调多人协作和项目管理。', 'system', '2023-08-10 13:24:14', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('需求转任务', 0, 'story', ',story.title,story.spec,story.verify,story.product,story.module,story.pri,story.category,story.estimate,', 'story.totask', '将需求转化为对应的开发任务要求。', '', '请你扮演一名资深的产品经理。', '负责产品战略、设计、开发、数据分析、用户体验、团队管理、沟通协调等方面，需要具备多种技能和能力，以实现产品目标和公司战略。同时精通多种编程语言和框架、熟悉前后端技术。', 'system', '2023-08-10 13:24:14', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('Bug润色', 0, 'bug', ',bug.title,bug.steps,bug.severity,bug.pri,bug.status,bug.confirmed,bug.type,', 'bug.edit', '优化其中各字段的表述，使表述清晰准确。', 'Bug描述格式建议使用：[步骤]<一步一步复现Bug的步骤>[结果]<Bug导致的结果描述>[期望]<Bug修复后期望的描述>', '作为一名资深的测试工程师。', '熟悉测试流程和方法，精通自动化测试和性能测试，能够设计和编写测试用例和测试脚本，擅长问题诊断和分析，熟悉敏捷开发和持续集成，能够协调多部门合作和项目管理。开发工程师应该是专业且严谨的。', 'system', '2023-08-10 13:24:14', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('文档润色', 0, 'doc', ',doc.content,doc.title,', 'doc.edit', '我希望你能帮我润色标题和文档正文。', '要求语句要通顺，逻辑要清晰，没有错别字且更具结构化。', '你是一名文章写得很好的文案编辑。', '文笔流畅、条理清晰。精通广告文案写作和编辑，擅长创意思维和品牌策略，能够进行市场调研和竞品分析，具有敏锐的审美和语言表达能力，能够协调多部门合作和项目管理，具有良好的沟通和协调能力。', 'system', '2023-08-31 15:54:57', 'active');

ALTER TABLE `zt_ticket` ADD `subStatus` varchar(30) NOT NULL DEFAULT '';

REPLACE INTO `zt_privrelation` (`priv`, `type`, `relationPriv`) VALUES ('kanban-view', 'depend', 'kanban-space');

CREATE TABLE IF NOT EXISTS `zt_practice` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `code` char(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `labels` varchar(255) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `content` text NULL,
  `contributor` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE UNIQUE INDEX `code` ON `zt_practice`(`code`);

REPLACE INTO
    `zt_priv` (`id`, `module`, `method`, `parent`, `edition`, `vision`, `system`, `order`)
VALUES
    (2161, 'traincourse', 'practice', 681, ',biz,max,ipd,', ',rnd,', '1', 5),
    (2162, 'traincourse', 'practiceBrowse', 681, ',biz,max,ipd,', ',rnd,', '1', 10),
    (2163, 'traincourse', 'practiceView', 681, ',biz,max,ipd,', ',rnd,', '1', 15),
    (2164, 'traincourse', 'updatePractice', 681, ',biz,max,ipd,', ',rnd,', '1', 20);

REPLACE INTO
    `zt_privmanager` (`id`, `parent`, `code`, `type`, `edition`, `vision`, `order`)
VALUES
    (681, 566, '', 'package', ',open,biz,max,ipd,', ',rnd,', 8);

REPLACE INTO
    `zt_privlang` (`objectID`, `objectType`, `lang`, `key`, `value`, `desc`)
VALUES
    (681, 'manager', 'zh-cn', '', '实践库', ''),
    (681, 'manager', 'zh-tw', '', '實踐庫', ''),
    (681, 'manager', 'en', '', 'Practice Library', ''),
    (681, 'manager', 'de', '', 'Practice Library', ''),
    (681, 'manager', 'fr', '', 'Practice Library', ''),
    (2161, 'priv', 'zh-cn', 'traincourse-practiceAction', '', ''),
    (2161, 'priv', 'zh-tw', 'traincourse-practiceAction', '', ''),
    (2161, 'priv', 'en', 'traincourse-practiceAction', '', ''),
    (2161, 'priv', 'de', 'traincourse-practiceAction', '', ''),
    (2161, 'priv', 'fr', 'traincourse-practiceAction', '', ''),
    (2162, 'priv', 'zh-cn', 'traincourse-practiceBrowse', '', ''),
    (2162, 'priv', 'zh-tw', 'traincourse-practiceBrowse', '', ''),
    (2162, 'priv', 'en', 'traincourse-practiceBrowse', '', ''),
    (2162, 'priv', 'de', 'traincourse-practiceBrowse', '', ''),
    (2162, 'priv', 'fr', 'traincourse-practiceBrowse', '', ''),
    (2163, 'priv', 'zh-cn', 'traincourse-practiceView'  , '', ''),
    (2163, 'priv', 'zh-tw', 'traincourse-practiceView'  , '', ''),
    (2163, 'priv', 'en', 'traincourse-practiceView'  , '', ''),
    (2163, 'priv', 'de', 'traincourse-practiceView'  , '', ''),
    (2163, 'priv', 'fr', 'traincourse-practiceView'  , '', ''),
    (2164, 'priv', 'zh-cn', 'traincourse-updatePractice', '', ''),
    (2164, 'priv', 'zh-tw', 'traincourse-updatePractice', '', ''),
    (2164, 'priv', 'en', 'traincourse-updatePractice', '', ''),
    (2164, 'priv', 'de', 'traincourse-updatePractice', '', ''),
    (2164, 'priv', 'fr', 'traincourse-updatePractice', '', '');

REPLACE INTO
    `zt_privrelation` (`priv`, `type`, `relationPriv`)
VALUES
    ('traincourse-practiceBrowse', 'depend', 'traincourse-practice'),
    ('traincourse-practiceView', 'depend', 'traincourse-practice'), ('traincourse-practiceView', 'depend', 'traincourse-practiceBrowse'),
    ('traincourse-updatePractice', 'depend', 'traincourse-practice'), ('traincourse-updatePractice', 'depend', 'traincourse-practiceBrowse'),
    ('traincourse-practice', 'recommend', 'traincourse-practiceBrowse'), ('traincourse-practice', 'recommend', 'traincourse-practiceView'),
    ('traincourse-practiceBrowse', 'recommend', 'traincourse-practiceView'),
    ('traincourse-updatePractice', 'recommend', 'traincourse-practiceView');

UPDATE zt_privlang SET `key` = 'execution-computeBurn' WHERE `key` = 'execution-computeBurnAction';

DELETE FROM zt_priv WHERE module='search' and method = 'select';
DELETE FROM zt_privlang WHERE `key`='search-select';

UPDATE `zt_privlang` SET `value`='删除风险' WHERE `objectID`=197 AND `objectType`='manager' AND `lang`='zh-cn';

DELETE FROM `zt_config` WHERE `module` = 'datatable' and `section` = 'productBrowse';
DELETE FROM `zt_config` WHERE `module` = 'datatable' and `section` = 'executionTask';
DELETE FROM `zt_config` WHERE `module` = 'datatable' and `section` = 'bugBrowse';
DELETE FROM `zt_config` WHERE `module` = 'datatable' and `section` = 'executionAll';
