<?php
namespace zin;

class monaco extends wg
{
    /**
     * @var mixed[]
     */
    protected static $defineProps = array(
        'id:string',
        'action?:string',
        'options?:array',
        'diffContent?:array',
        'selectedLines?:string',
        'onMouseDown?:string',
        'onMouseMove?:string'
    );

    /**
     * @var mixed[]
     */
    protected static $defaultProps = array(
        'action'      => 'create',
        'options'     => array(),
        'diffContent' => array(),
        'onMouseDown' => '',
        'onMouseMove' => ''
    );
    /**
     * @return string|null
     */
    public static function getPageJS()
    {
        return file_get_contents(__DIR__ . DS . 'js' . DS . 'v1.js');
    }

    protected function build()
    {
        global $app;
        $vsPath        = $app->getWebRoot() . 'js/monaco-editor/min/vs';
        $clientLang    = $app->clientLang;
        $id            = $this->prop('id');
        $action        = $this->prop('action');
        $options       = $this->prop('options');
        $diffContent   = $this->prop('diffContent');
        $selectedLines = $this->prop('selectedLines');
        $onMouseDown = $this->prop('onMouseDown');
        $onMouseMove = $this->prop('onMouseMove');

        if(!$options) $options = new stdclass();
        return div
        (
            jsVar('id', $id),
            jsVar('action', $action),
            jsVar('options', $options),
            jsVar('diffContent', !$diffContent ? new stdclass() : $diffContent),
            jsVar('onMouseDown', $onMouseDown),
            jsVar('onMouseMove', $onMouseMove),
            jsVar('vsPath', $vsPath),
            jsVar('clientLang', $clientLang),
            jsVar('selectedLines', $selectedLines),
            h::import($app->getWebRoot() . 'js/monaco-editor/min/vs/loader.js'),
            setID($id)
        );
    }
}
